// Code generated by smithy-go-codegen DO NOT EDIT.

package apigateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about the current ApiKey resource.
func (c *Client) GetApiKey(ctx context.Context, params *GetApiKeyInput, optFns ...func(*Options)) (*GetApiKeyOutput, error) {
	if params == nil {
		params = &GetApiKeyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetApiKey", params, optFns, c.addOperationGetApiKeyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetApiKeyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A request to get information about the current ApiKey resource.
type GetApiKeyInput struct {

	// The identifier of the ApiKey resource.
	//
	// This member is required.
	ApiKey *string

	// A boolean flag to specify whether ( true ) or not ( false ) the result contains
	// the key value.
	IncludeValue *bool

	noSmithyDocumentSerde
}

// A resource that can be distributed to callers for executing Method resources
// that require an API key. API keys can be mapped to any Stage on any RestApi,
// which indicates that the callers with the API key can make requests to that
// stage.
type GetApiKeyOutput struct {

	// The timestamp when the API Key was created.
	CreatedDate *time.Time

	// An Amazon Web Services Marketplace customer identifier, when integrating with
	// the Amazon Web Services SaaS Marketplace.
	CustomerId *string

	// The description of the API Key.
	Description *string

	// Specifies whether the API Key can be used by callers.
	Enabled bool

	// The identifier of the API Key.
	Id *string

	// The timestamp when the API Key was last updated.
	LastUpdatedDate *time.Time

	// The name of the API Key.
	Name *string

	// A list of Stage resources that are associated with the ApiKey resource.
	StageKeys []string

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// The value of the API Key.
	Value *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetApiKeyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetApiKey{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetApiKey{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetApiKey"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetApiKeyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetApiKey(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addAcceptHeader(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetApiKey(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetApiKey",
	}
}
