// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package migrate

import (
	"entgo.io/ent/dialect/entsql"
	"entgo.io/ent/dialect/sql/schema"
	"entgo.io/ent/schema/field"
)

var (
	// VersionedGroupsColumns holds the columns for the "versioned_groups" table.
	VersionedGroupsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "name", Type: field.TypeString},
	}
	// VersionedGroupsTable holds the schema information for the "versioned_groups" table.
	VersionedGroupsTable = &schema.Table{
		Name:       "versioned_groups",
		Columns:    VersionedGroupsColumns,
		PrimaryKey: []*schema.Column{VersionedGroupsColumns[0]},
	}
	// VersionedUsersColumns holds the columns for the "versioned_users" table.
	VersionedUsersColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "age", Type: field.TypeInt32},
		{Name: "name", Type: field.TypeString, Size: 10},
		{Name: "address", Type: field.TypeString, Nullable: true},
	}
	// VersionedUsersTable holds the schema information for the "versioned_users" table.
	VersionedUsersTable = &schema.Table{
		Name:       "versioned_users",
		Columns:    VersionedUsersColumns,
		PrimaryKey: []*schema.Column{VersionedUsersColumns[0]},
	}
	// Tables holds all the tables in the schema.
	Tables = []*schema.Table{
		VersionedGroupsTable,
		VersionedUsersTable,
	}
)

func init() {
	VersionedGroupsTable.Annotation = &entsql.Annotation{
		Table:     "versioned_groups",
		Charset:   "ascii",
		Collation: "ascii_general_ci",
	}
	VersionedUsersTable.Annotation = &entsql.Annotation{
		Table: "versioned_users",
	}
}
