// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary of the membership details of an AppInstanceUser.
type AppInstanceUserMembershipSummary struct {

	// The time at which an AppInstanceUser last marked a channel as read.
	ReadMarkerTimestamp *time.Time

	// The ID of the SubChannel that the AppInstanceUser is a member of.
	SubChannelId *string

	// The type of ChannelMembership.
	Type ChannelMembershipType

	noSmithyDocumentSerde
}

// The membership information, including member ARNs, the channel ARN, and
// membership types.
type BatchChannelMemberships struct {

	// The ARN of the channel to which you're adding users.
	ChannelArn *string

	// The identifier of the member who invited another member.
	InvitedBy *Identity

	// The users successfully added to the request.
	Members []Identity

	// The ID of the SubChannel.
	SubChannelId *string

	// The membership types set for the channel users.
	Type ChannelMembershipType

	noSmithyDocumentSerde
}

// A list of failed member ARNs, error codes, and error messages.
type BatchCreateChannelMembershipError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The AppInstanceUserArn of the member that the service couldn't add.
	MemberArn *string

	noSmithyDocumentSerde
}

// The details of a channel.
type Channel struct {

	// The ARN of a channel.
	ChannelArn *string

	// The ARN of the channel flow.
	ChannelFlowArn *string

	// The AppInstanceUser who created the channel.
	CreatedBy *Identity

	// The time at which the AppInstanceUser created the channel.
	CreatedTimestamp *time.Time

	// The attributes required to configure and create an elastic channel. An elastic
	// channel can support a maximum of 1-million members.
	ElasticChannelConfiguration *ElasticChannelConfiguration

	// The time at which a member sent the last message in the channel.
	LastMessageTimestamp *time.Time

	// The time at which a channel was last updated.
	LastUpdatedTimestamp *time.Time

	// The channel's metadata.
	Metadata *string

	// The mode of the channel.
	Mode ChannelMode

	// The name of a channel.
	Name *string

	// The channel's privacy setting.
	Privacy ChannelPrivacy

	noSmithyDocumentSerde
}

// Summary of details of a channel associated with channel flow.
type ChannelAssociatedWithFlowSummary struct {

	// The ARN of the channel.
	ChannelArn *string

	// The channel's metadata.
	Metadata *string

	// The mode of the channel.
	Mode ChannelMode

	// The name of the channel flow.
	Name *string

	// The channel's privacy setting.
	Privacy ChannelPrivacy

	noSmithyDocumentSerde
}

// The details of a channel ban.
type ChannelBan struct {

	// The ARN of the channel from which a member is being banned.
	ChannelArn *string

	// The AppInstanceUser who created the ban.
	CreatedBy *Identity

	// The time at which the ban was created.
	CreatedTimestamp *time.Time

	// The member being banned from the channel.
	Member *Identity

	noSmithyDocumentSerde
}

// Summary of the details of a ChannelBan.
type ChannelBanSummary struct {

	// The member being banned from a channel.
	Member *Identity

	noSmithyDocumentSerde
}

// The details of a channel flow.
type ChannelFlow struct {

	// The ARN of the channel flow.
	ChannelFlowArn *string

	// The time at which the channel flow was created.
	CreatedTimestamp *time.Time

	// The time at which a channel flow was updated.
	LastUpdatedTimestamp *time.Time

	// The name of the channel flow.
	Name *string

	// Information about the processor Lambda functions.
	Processors []Processor

	noSmithyDocumentSerde
}

// Summary of details of a channel flow.
type ChannelFlowSummary struct {

	// The ARN of the channel flow.
	ChannelFlowArn *string

	// The name of the channel flow.
	Name *string

	// Information about the processor Lambda functions.
	Processors []Processor

	noSmithyDocumentSerde
}

// The details of a channel member.
type ChannelMembership struct {

	// The ARN of the member's channel.
	ChannelArn *string

	// The time at which the channel membership was created.
	CreatedTimestamp *time.Time

	// The identifier of the member who invited another member.
	InvitedBy *Identity

	// The time at which a channel membership was last updated.
	LastUpdatedTimestamp *time.Time

	// The data of the channel member.
	Member *Identity

	// The ID of the SubChannel that a user belongs to.
	SubChannelId *string

	// The membership type set for the channel member.
	Type ChannelMembershipType

	noSmithyDocumentSerde
}

// Summary of the channel membership details of an AppInstanceUser.
type ChannelMembershipForAppInstanceUserSummary struct {

	// Returns the channel membership data for an AppInstance.
	AppInstanceUserMembershipSummary *AppInstanceUserMembershipSummary

	// Returns the channel data for an AppInstance.
	ChannelSummary *ChannelSummary

	noSmithyDocumentSerde
}

// The channel membership preferences for an AppInstanceUser.
type ChannelMembershipPreferences struct {

	// The push notification configuration of a message.
	PushNotifications *PushNotificationPreferences

	noSmithyDocumentSerde
}

// Summary of the details of a ChannelMembership.
type ChannelMembershipSummary struct {

	// A member's summary data.
	Member *Identity

	noSmithyDocumentSerde
}

// The details of a message in a channel.
type ChannelMessage struct {

	// The ARN of the channel.
	ChannelArn *string

	// The message content.
	Content *string

	// The time at which the message was created.
	CreatedTimestamp *time.Time

	// The time at which a message was edited.
	LastEditedTimestamp *time.Time

	// The time at which a message was updated.
	LastUpdatedTimestamp *time.Time

	// The attributes for the message, used for message filtering along with a
	// FilterRule defined in the PushNotificationPreferences.
	MessageAttributes map[string]MessageAttributeValue

	// The ID of a message.
	MessageId *string

	// The message metadata.
	Metadata *string

	// The persistence setting for a channel message.
	Persistence ChannelMessagePersistenceType

	// Hides the content of a message.
	Redacted bool

	// The message sender.
	Sender *Identity

	// The status of the channel message.
	Status *ChannelMessageStatusStructure

	// The ID of the SubChannel.
	SubChannelId *string

	// The message type.
	Type ChannelMessageType

	noSmithyDocumentSerde
}

// Stores information about a callback.
type ChannelMessageCallback struct {

	// The message ID.
	//
	// This member is required.
	MessageId *string

	// The message content.
	Content *string

	// The attributes for the message, used for message filtering along with a
	// FilterRule defined in the PushNotificationPreferences.
	MessageAttributes map[string]MessageAttributeValue

	// The message metadata.
	Metadata *string

	// The push notification configuration of the message.
	PushNotification *PushNotificationConfiguration

	// The ID of the SubChannel.
	SubChannelId *string

	noSmithyDocumentSerde
}

// Stores information about a message status.
type ChannelMessageStatusStructure struct {

	// Contains more details about the messasge status.
	Detail *string

	// The message status value.
	Value ChannelMessageStatus

	noSmithyDocumentSerde
}

// Summary of the messages in a Channel.
type ChannelMessageSummary struct {

	// The content of the message.
	Content *string

	// The time at which the message summary was created.
	CreatedTimestamp *time.Time

	// The time at which a message was last edited.
	LastEditedTimestamp *time.Time

	// The time at which a message was last updated.
	LastUpdatedTimestamp *time.Time

	// The message attribues listed in a the summary of a channel message.
	MessageAttributes map[string]MessageAttributeValue

	// The ID of the message.
	MessageId *string

	// The metadata of the message.
	Metadata *string

	// Indicates whether a message was redacted.
	Redacted bool

	// The message sender.
	Sender *Identity

	// The message status. The status value is SENT for messages sent to a channel
	// without a channel flow. For channels associated with channel flow, the value
	// determines the processing stage.
	Status *ChannelMessageStatusStructure

	// The type of message.
	Type ChannelMessageType

	noSmithyDocumentSerde
}

// Summary of the details of a moderated channel.
type ChannelModeratedByAppInstanceUserSummary struct {

	// Summary of the details of a Channel.
	ChannelSummary *ChannelSummary

	noSmithyDocumentSerde
}

// The details of a channel moderator.
type ChannelModerator struct {

	// The ARN of the moderator's channel.
	ChannelArn *string

	// The AppInstanceUser who created the moderator.
	CreatedBy *Identity

	// The time at which the moderator was created.
	CreatedTimestamp *time.Time

	// The moderator's data.
	Moderator *Identity

	noSmithyDocumentSerde
}

// Summary of the details of a ChannelModerator.
type ChannelModeratorSummary struct {

	// The data for a moderator.
	Moderator *Identity

	noSmithyDocumentSerde
}

// Summary of the details of a Channel.
type ChannelSummary struct {

	// The ARN of the channel.
	ChannelArn *string

	// The time at which the last persistent message in a channel was sent.
	LastMessageTimestamp *time.Time

	// The metadata of the channel.
	Metadata *string

	// The mode of the channel.
	Mode ChannelMode

	// The name of the channel.
	Name *string

	// The privacy setting of the channel.
	Privacy ChannelPrivacy

	noSmithyDocumentSerde
}

// The attributes required to configure and create an elastic channel. An elastic
// channel can support a maximum of 1-million members.
type ElasticChannelConfiguration struct {

	// The maximum number of SubChannels that you want to allow in the elastic channel.
	//
	// This member is required.
	MaximumSubChannels *int32

	// The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of
	// the calculated value is used in balancing members among SubChannels of the
	// elastic channel.
	//
	// This member is required.
	MinimumMembershipPercentage *int32

	// The maximum number of members allowed in a SubChannel.
	//
	// This member is required.
	TargetMembershipsPerSubChannel *int32

	noSmithyDocumentSerde
}

// The details of a user.
type Identity struct {

	// The ARN in an Identity.
	Arn *string

	// The name in an Identity.
	Name *string

	noSmithyDocumentSerde
}

// Stores metadata about a Lambda processor.
type LambdaConfiguration struct {

	// Controls how the Lambda function is invoked.
	//
	// This member is required.
	InvocationType InvocationType

	// The ARN of the Lambda message processing function.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// A list of message attribute values.
type MessageAttributeValue struct {

	// The strings in a message attribute value.
	StringValues []string

	noSmithyDocumentSerde
}

// The websocket endpoint used to connect to Amazon Chime SDK messaging.
type MessagingSessionEndpoint struct {

	// The endpoint to which you establish a websocket connection.
	Url *string

	noSmithyDocumentSerde
}

// The information about a processor in a channel flow.
type Processor struct {

	// The information about the type of processor and its identifier.
	//
	// This member is required.
	Configuration *ProcessorConfiguration

	// The sequence in which processors run. If you have multiple processors in a
	// channel flow, message processing goes through each processor in the sequence.
	// The value determines the sequence. At this point, we support only 1 processor
	// within a flow.
	//
	// This member is required.
	ExecutionOrder *int32

	// Determines whether to continue with message processing or stop it in cases where
	// communication with a processor fails. If a processor has a fallback action of
	// ABORT and communication with it fails, the processor sets the message status to
	// FAILED and does not send the message to any recipients. Note that if the last
	// processor in the channel flow sequence has a fallback action of CONTINUE and
	// communication with the processor fails, then the message is considered processed
	// and sent to recipients of the channel.
	//
	// This member is required.
	FallbackAction FallbackAction

	// The name of the channel flow.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A processor's metadata.
type ProcessorConfiguration struct {

	// Indicates that the processor is of type Lambda.
	//
	// This member is required.
	Lambda *LambdaConfiguration

	noSmithyDocumentSerde
}

// The push notification configuration of the message.
type PushNotificationConfiguration struct {

	// The body of the push notification.
	Body *string

	// The title of the push notification.
	Title *string

	// Enum value that indicates the type of the push notification for a message.
	// DEFAULT: Normal mobile push notification. VOIP: VOIP mobile push notification.
	Type PushNotificationType

	noSmithyDocumentSerde
}

// The channel membership preferences for push notification.
type PushNotificationPreferences struct {

	// Enum value that indicates which push notifications to send to the requested
	// member of a channel. ALL sends all push notifications, NONE sends no push
	// notifications, FILTERED sends only filtered push notifications.
	//
	// This member is required.
	AllowNotifications AllowNotifications

	// The simple JSON object used to send a subset of a push notification to the
	// requested member.
	FilterRule *string

	noSmithyDocumentSerde
}

// A Field of the channel that you want to search.
type SearchField struct {

	// An enum value that indicates the key to search the channel on. MEMBERS allows
	// you to search channels based on memberships. You can use it with the EQUALS
	// operator to get channels whose memberships are equal to the specified values,
	// and with the INCLUDES operator to get channels whose memberships include the
	// specified values.
	//
	// This member is required.
	Key SearchFieldKey

	// The operator used to compare field values, currently EQUALS or INCLUDES. Use the
	// EQUALS operator to find channels whose memberships equal the specified values.
	// Use the INCLUDES operator to find channels whose memberships include the
	// specified values.
	//
	// This member is required.
	Operator SearchFieldOperator

	// The values that you want to search for, a list of strings. The values must be
	// AppInstanceUserArns specified as a list of strings. This operation isn't
	// supported for AppInstanceUsers with large number of memberships.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Summary of the sub-channels associated with the elastic channel.
type SubChannelSummary struct {

	// The number of members in a SubChannel.
	MembershipCount *int32

	// The unique ID of a SubChannel.
	SubChannelId *string

	noSmithyDocumentSerde
}

// A tag object containing a key-value pair.
type Tag struct {

	// The key in a tag.
	//
	// This member is required.
	Key *string

	// The value in a tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
