// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

package dashboard

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The `CreateDashboard` request.
type CreateDashboardRequest struct {
	// Required. The project on which to execute the request. The format is
	// `"projects/{project_id_or_number}"`. The {project_id_or_number} must match
	// the dashboard resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The initial dashboard specification.
	Dashboard            *Dashboard `protobuf:"bytes,2,opt,name=dashboard,proto3" json:"dashboard,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateDashboardRequest) Reset()         { *m = CreateDashboardRequest{} }
func (m *CreateDashboardRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDashboardRequest) ProtoMessage()    {}
func (*CreateDashboardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0142a102f8bfb49, []int{0}
}

func (m *CreateDashboardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDashboardRequest.Unmarshal(m, b)
}
func (m *CreateDashboardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDashboardRequest.Marshal(b, m, deterministic)
}
func (m *CreateDashboardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDashboardRequest.Merge(m, src)
}
func (m *CreateDashboardRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDashboardRequest.Size(m)
}
func (m *CreateDashboardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDashboardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDashboardRequest proto.InternalMessageInfo

func (m *CreateDashboardRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDashboardRequest) GetDashboard() *Dashboard {
	if m != nil {
		return m.Dashboard
	}
	return nil
}

// The `ListDashboards` request.
type ListDashboardsRequest struct {
	// Required. The scope of the dashboards to list. A project scope must be
	// specified in the form of `"projects/{project_id_or_number}"`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A positive number that is the maximum number of results to return.
	// If unspecified, a default of 1000 is used.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDashboardsRequest) Reset()         { *m = ListDashboardsRequest{} }
func (m *ListDashboardsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDashboardsRequest) ProtoMessage()    {}
func (*ListDashboardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0142a102f8bfb49, []int{1}
}

func (m *ListDashboardsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDashboardsRequest.Unmarshal(m, b)
}
func (m *ListDashboardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDashboardsRequest.Marshal(b, m, deterministic)
}
func (m *ListDashboardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDashboardsRequest.Merge(m, src)
}
func (m *ListDashboardsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDashboardsRequest.Size(m)
}
func (m *ListDashboardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDashboardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDashboardsRequest proto.InternalMessageInfo

func (m *ListDashboardsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDashboardsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDashboardsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The `ListDashboards` request.
type ListDashboardsResponse struct {
	// The list of requested dashboards.
	Dashboards []*Dashboard `protobuf:"bytes,1,rep,name=dashboards,proto3" json:"dashboards,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results,
	// use that value as `pageToken` in the next call to this method.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDashboardsResponse) Reset()         { *m = ListDashboardsResponse{} }
func (m *ListDashboardsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDashboardsResponse) ProtoMessage()    {}
func (*ListDashboardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0142a102f8bfb49, []int{2}
}

func (m *ListDashboardsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDashboardsResponse.Unmarshal(m, b)
}
func (m *ListDashboardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDashboardsResponse.Marshal(b, m, deterministic)
}
func (m *ListDashboardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDashboardsResponse.Merge(m, src)
}
func (m *ListDashboardsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDashboardsResponse.Size(m)
}
func (m *ListDashboardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDashboardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDashboardsResponse proto.InternalMessageInfo

func (m *ListDashboardsResponse) GetDashboards() []*Dashboard {
	if m != nil {
		return m.Dashboards
	}
	return nil
}

func (m *ListDashboardsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The `GetDashboard` request.
type GetDashboardRequest struct {
	// Required. The resource name of the Dashboard. The format is one of
	// `"dashboards/{dashboard_id}"` (for system dashboards) or
	// `"projects/{project_id_or_number}/dashboards/{dashboard_id}"`
	// (for custom dashboards).
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDashboardRequest) Reset()         { *m = GetDashboardRequest{} }
func (m *GetDashboardRequest) String() string { return proto.CompactTextString(m) }
func (*GetDashboardRequest) ProtoMessage()    {}
func (*GetDashboardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0142a102f8bfb49, []int{3}
}

func (m *GetDashboardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDashboardRequest.Unmarshal(m, b)
}
func (m *GetDashboardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDashboardRequest.Marshal(b, m, deterministic)
}
func (m *GetDashboardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDashboardRequest.Merge(m, src)
}
func (m *GetDashboardRequest) XXX_Size() int {
	return xxx_messageInfo_GetDashboardRequest.Size(m)
}
func (m *GetDashboardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDashboardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDashboardRequest proto.InternalMessageInfo

func (m *GetDashboardRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `DeleteDashboard` request.
type DeleteDashboardRequest struct {
	// Required. The resource name of the Dashboard. The format is
	// `"projects/{project_id_or_number}/dashboards/{dashboard_id}"`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDashboardRequest) Reset()         { *m = DeleteDashboardRequest{} }
func (m *DeleteDashboardRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDashboardRequest) ProtoMessage()    {}
func (*DeleteDashboardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0142a102f8bfb49, []int{4}
}

func (m *DeleteDashboardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDashboardRequest.Unmarshal(m, b)
}
func (m *DeleteDashboardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDashboardRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDashboardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDashboardRequest.Merge(m, src)
}
func (m *DeleteDashboardRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDashboardRequest.Size(m)
}
func (m *DeleteDashboardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDashboardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDashboardRequest proto.InternalMessageInfo

func (m *DeleteDashboardRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `UpdateDashboard` request.
type UpdateDashboardRequest struct {
	// Required. The dashboard that will replace the existing dashboard.
	Dashboard            *Dashboard `protobuf:"bytes,1,opt,name=dashboard,proto3" json:"dashboard,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *UpdateDashboardRequest) Reset()         { *m = UpdateDashboardRequest{} }
func (m *UpdateDashboardRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDashboardRequest) ProtoMessage()    {}
func (*UpdateDashboardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0142a102f8bfb49, []int{5}
}

func (m *UpdateDashboardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDashboardRequest.Unmarshal(m, b)
}
func (m *UpdateDashboardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDashboardRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDashboardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDashboardRequest.Merge(m, src)
}
func (m *UpdateDashboardRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDashboardRequest.Size(m)
}
func (m *UpdateDashboardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDashboardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDashboardRequest proto.InternalMessageInfo

func (m *UpdateDashboardRequest) GetDashboard() *Dashboard {
	if m != nil {
		return m.Dashboard
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateDashboardRequest)(nil), "google.monitoring.dashboard.v1.CreateDashboardRequest")
	proto.RegisterType((*ListDashboardsRequest)(nil), "google.monitoring.dashboard.v1.ListDashboardsRequest")
	proto.RegisterType((*ListDashboardsResponse)(nil), "google.monitoring.dashboard.v1.ListDashboardsResponse")
	proto.RegisterType((*GetDashboardRequest)(nil), "google.monitoring.dashboard.v1.GetDashboardRequest")
	proto.RegisterType((*DeleteDashboardRequest)(nil), "google.monitoring.dashboard.v1.DeleteDashboardRequest")
	proto.RegisterType((*UpdateDashboardRequest)(nil), "google.monitoring.dashboard.v1.UpdateDashboardRequest")
}

func init() {
	proto.RegisterFile("google/monitoring/dashboard/v1/dashboards_service.proto", fileDescriptor_a0142a102f8bfb49)
}

var fileDescriptor_a0142a102f8bfb49 = []byte{
	// 703 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x95, 0xcb, 0x6e, 0xd3, 0x4c,
	0x14, 0xc7, 0x35, 0xe9, 0xf7, 0x55, 0xed, 0x70, 0x89, 0x30, 0x22, 0x0d, 0x29, 0x97, 0xc8, 0x42,
	0xa8, 0x44, 0xc5, 0xa3, 0xb4, 0x6a, 0x11, 0x46, 0x08, 0xf5, 0x82, 0x2a, 0xa4, 0x22, 0x55, 0x29,
	0xb0, 0x60, 0x13, 0x4d, 0x92, 0x13, 0x67, 0x68, 0x3c, 0x63, 0x3c, 0x93, 0x04, 0x8a, 0xba, 0x81,
	0x25, 0x62, 0xc5, 0x8e, 0x57, 0x60, 0x05, 0x12, 0x1b, 0x1e, 0x81, 0x25, 0xec, 0x58, 0xb1, 0x60,
	0xc5, 0x53, 0x20, 0x5f, 0x62, 0xbb, 0xa9, 0x5b, 0x27, 0x62, 0xe9, 0x39, 0xff, 0x33, 0xe7, 0x37,
	0xe7, 0xfc, 0x67, 0x8c, 0x6f, 0x59, 0x42, 0x58, 0x5d, 0x20, 0xb6, 0xe0, 0x4c, 0x09, 0x97, 0x71,
	0x8b, 0xb4, 0xa8, 0xec, 0x34, 0x04, 0x75, 0x5b, 0xa4, 0x5f, 0x8d, 0x3f, 0x64, 0x5d, 0x82, 0xdb,
	0x67, 0x4d, 0x30, 0x1c, 0x57, 0x28, 0xa1, 0x5d, 0x09, 0x12, 0x8d, 0x38, 0xd1, 0x88, 0xb4, 0x46,
	0xbf, 0x5a, 0xba, 0x14, 0x6e, 0x4c, 0x1d, 0x46, 0x28, 0xe7, 0x42, 0x51, 0xc5, 0x04, 0x97, 0x41,
	0x76, 0xe9, 0x6a, 0x22, 0xda, 0x66, 0xd0, 0x6d, 0xd5, 0x1b, 0xd0, 0xa1, 0x7d, 0x26, 0xdc, 0x50,
	0x60, 0x8c, 0xcb, 0x15, 0xea, 0xe7, 0x43, 0xbd, 0xff, 0xd5, 0xe8, 0xb5, 0x09, 0xd8, 0x8e, 0x7a,
	0x19, 0x06, 0xcb, 0xa3, 0xc1, 0xa0, 0xa4, 0x4d, 0xe5, 0x5e, 0xa8, 0x98, 0x4b, 0xf0, 0x34, 0xbb,
	0x0c, 0xb8, 0x0a, 0x02, 0xfa, 0x1b, 0x84, 0x0b, 0x1b, 0x2e, 0x50, 0x05, 0x9b, 0xc3, 0x8a, 0x35,
	0x78, 0xde, 0x03, 0xa9, 0xb4, 0x79, 0x3c, 0xed, 0x50, 0x17, 0xb8, 0x2a, 0xa2, 0x32, 0x5a, 0x98,
	0x5d, 0x9f, 0xfa, 0xb5, 0x96, 0xab, 0x85, 0x4b, 0xda, 0x36, 0x9e, 0x8d, 0x10, 0x8b, 0xb9, 0x32,
	0x5a, 0x38, 0xb5, 0x74, 0xc3, 0x38, 0xb9, 0x65, 0x46, 0x54, 0x21, 0xd8, 0x2a, 0xde, 0x40, 0x77,
	0xf0, 0x85, 0x6d, 0x26, 0x55, 0x24, 0x90, 0x63, 0x31, 0xcc, 0xe3, 0x59, 0x87, 0x5a, 0x50, 0x97,
	0x6c, 0x1f, 0x7c, 0x86, 0xff, 0x6b, 0x33, 0xde, 0xc2, 0x2e, 0xdb, 0x07, 0xed, 0x32, 0xc6, 0x7e,
	0x50, 0x89, 0x3d, 0xe0, 0xc5, 0x29, 0x2f, 0xbb, 0xe6, 0xcb, 0x1f, 0x79, 0x0b, 0xfa, 0x5b, 0x84,
	0x0b, 0xa3, 0x25, 0xa5, 0x23, 0xb8, 0x04, 0xed, 0x01, 0xc6, 0xb1, 0x2b, 0x8a, 0xa8, 0x3c, 0x35,
	0xd1, 0xd9, 0x6a, 0x89, 0x64, 0xed, 0x3a, 0xce, 0x73, 0x78, 0xa1, 0xea, 0x09, 0x92, 0x9c, 0x4f,
	0x72, 0xc6, 0x5b, 0xde, 0x89, 0x68, 0x0c, 0x7c, 0x7e, 0x0b, 0xd4, 0x91, 0x09, 0xcc, 0xe1, 0xff,
	0x38, 0xb5, 0x21, 0x79, 0x76, 0x7f, 0x41, 0xaf, 0xe2, 0xc2, 0x26, 0x74, 0x21, 0x65, 0x68, 0xc7,
	0xa6, 0xb4, 0x71, 0xe1, 0xb1, 0xd3, 0x4a, 0x9b, 0xf3, 0xa1, 0x51, 0xa2, 0x7f, 0x1c, 0xe5, 0xd2,
	0xa7, 0x19, 0x7c, 0x2e, 0x6e, 0xea, 0x6e, 0x70, 0xa7, 0xb4, 0x8f, 0x08, 0xe7, 0x47, 0x6c, 0xa6,
	0xad, 0x66, 0x15, 0x49, 0xf7, 0x65, 0x69, 0x7c, 0x38, 0x7d, 0xe5, 0xf5, 0x8f, 0xdf, 0xef, 0x73,
	0x44, 0xd7, 0xbd, 0x2b, 0xf5, 0x2a, 0xb0, 0xcd, 0x5d, 0xc7, 0x15, 0xcf, 0xa0, 0xa9, 0x24, 0xa9,
	0x1c, 0x24, 0xae, 0xbf, 0x19, 0x9f, 0xc1, 0xa3, 0x3d, 0x7b, 0xd8, 0x1c, 0xda, 0x4a, 0x56, 0xd1,
	0x54, 0xff, 0x96, 0x56, 0x27, 0x4d, 0x0b, 0x3c, 0xa8, 0x57, 0x7c, 0xf0, 0x6b, 0xda, 0x18, 0xe0,
	0xda, 0x07, 0x84, 0x4f, 0x27, 0xdd, 0xa3, 0x2d, 0x67, 0x15, 0x4d, 0xf1, 0xda, 0x24, 0x5d, 0x3d,
	0x0c, 0xe7, 0xb9, 0x2b, 0x81, 0x96, 0x20, 0x23, 0x95, 0x03, 0xed, 0x1d, 0xc2, 0xf9, 0x11, 0xab,
	0x66, 0x0f, 0x3e, 0xdd, 0xdb, 0xa5, 0xc2, 0x30, 0x6f, 0xf8, 0xce, 0x19, 0xf7, 0xbd, 0x47, 0x70,
	0xc8, 0x53, 0x19, 0x87, 0xe7, 0x0b, 0xc2, 0xf9, 0x91, 0x7b, 0x90, 0xcd, 0x93, 0x7e, 0x71, 0x26,
	0x69, 0xd9, 0x3d, 0x1f, 0xf1, 0xf6, 0xd2, 0xa2, 0x8f, 0x18, 0x8b, 0x4e, 0x84, 0x4d, 0x58, 0xb2,
	0xf4, 0x13, 0x7d, 0x5b, 0xbb, 0x98, 0xa8, 0x13, 0x54, 0xa6, 0x0e, 0x93, 0x46, 0x53, 0xd8, 0xdf,
	0xd7, 0xbe, 0xa2, 0x8e, 0x52, 0x8e, 0x34, 0x09, 0x19, 0x0c, 0x06, 0x23, 0x51, 0x42, 0x7b, 0xaa,
	0x43, 0x9a, 0x5d, 0xd1, 0x6b, 0xdd, 0x74, 0xba, 0x54, 0xb5, 0x85, 0x6b, 0x2f, 0x66, 0xc9, 0xe3,
	0x5a, 0x13, 0x48, 0x0d, 0x17, 0x68, 0x6b, 0x12, 0xfd, 0xc0, 0x65, 0x0a, 0xd6, 0x3f, 0x23, 0xac,
	0x37, 0x85, 0x9d, 0xd1, 0xce, 0xf5, 0xc2, 0x91, 0x77, 0x65, 0xc7, 0x33, 0xc2, 0x0e, 0x7a, 0xba,
	0x15, 0x66, 0x5a, 0xa2, 0x4b, 0xb9, 0x65, 0x08, 0xd7, 0x22, 0x16, 0x70, 0xdf, 0x26, 0x24, 0x26,
	0x38, 0xee, 0x67, 0x7b, 0x27, 0xfa, 0xf8, 0x93, 0x5b, 0xd8, 0xf2, 0xe5, 0xa6, 0xb9, 0xe1, 0xb5,
	0xcb, 0x34, 0x1f, 0x46, 0x29, 0xa6, 0x19, 0x95, 0x37, 0xcd, 0x27, 0xd5, 0xc6, 0xb4, 0xbf, 0xfd,
	0xf2, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xba, 0xd6, 0xa4, 0x47, 0x62, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DashboardsServiceClient is the client API for DashboardsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DashboardsServiceClient interface {
	// Creates a new custom dashboard.
	//
	// This method requires the `monitoring.dashboards.create` permission
	// on the specified project. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	CreateDashboard(ctx context.Context, in *CreateDashboardRequest, opts ...grpc.CallOption) (*Dashboard, error)
	// Lists the existing dashboards.
	//
	// This method requires the `monitoring.dashboards.list` permission
	// on the specified project. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	ListDashboards(ctx context.Context, in *ListDashboardsRequest, opts ...grpc.CallOption) (*ListDashboardsResponse, error)
	// Fetches a specific dashboard.
	//
	// This method requires the `monitoring.dashboards.get` permission
	// on the specified dashboard. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	GetDashboard(ctx context.Context, in *GetDashboardRequest, opts ...grpc.CallOption) (*Dashboard, error)
	// Deletes an existing custom dashboard.
	//
	// This method requires the `monitoring.dashboards.delete` permission
	// on the specified dashboard. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	DeleteDashboard(ctx context.Context, in *DeleteDashboardRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Replaces an existing custom dashboard with a new definition.
	//
	// This method requires the `monitoring.dashboards.update` permission
	// on the specified dashboard. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	UpdateDashboard(ctx context.Context, in *UpdateDashboardRequest, opts ...grpc.CallOption) (*Dashboard, error)
}

type dashboardsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDashboardsServiceClient(cc grpc.ClientConnInterface) DashboardsServiceClient {
	return &dashboardsServiceClient{cc}
}

func (c *dashboardsServiceClient) CreateDashboard(ctx context.Context, in *CreateDashboardRequest, opts ...grpc.CallOption) (*Dashboard, error) {
	out := new(Dashboard)
	err := c.cc.Invoke(ctx, "/google.monitoring.dashboard.v1.DashboardsService/CreateDashboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dashboardsServiceClient) ListDashboards(ctx context.Context, in *ListDashboardsRequest, opts ...grpc.CallOption) (*ListDashboardsResponse, error) {
	out := new(ListDashboardsResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.dashboard.v1.DashboardsService/ListDashboards", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dashboardsServiceClient) GetDashboard(ctx context.Context, in *GetDashboardRequest, opts ...grpc.CallOption) (*Dashboard, error) {
	out := new(Dashboard)
	err := c.cc.Invoke(ctx, "/google.monitoring.dashboard.v1.DashboardsService/GetDashboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dashboardsServiceClient) DeleteDashboard(ctx context.Context, in *DeleteDashboardRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.monitoring.dashboard.v1.DashboardsService/DeleteDashboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dashboardsServiceClient) UpdateDashboard(ctx context.Context, in *UpdateDashboardRequest, opts ...grpc.CallOption) (*Dashboard, error) {
	out := new(Dashboard)
	err := c.cc.Invoke(ctx, "/google.monitoring.dashboard.v1.DashboardsService/UpdateDashboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DashboardsServiceServer is the server API for DashboardsService service.
type DashboardsServiceServer interface {
	// Creates a new custom dashboard.
	//
	// This method requires the `monitoring.dashboards.create` permission
	// on the specified project. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	CreateDashboard(context.Context, *CreateDashboardRequest) (*Dashboard, error)
	// Lists the existing dashboards.
	//
	// This method requires the `monitoring.dashboards.list` permission
	// on the specified project. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	ListDashboards(context.Context, *ListDashboardsRequest) (*ListDashboardsResponse, error)
	// Fetches a specific dashboard.
	//
	// This method requires the `monitoring.dashboards.get` permission
	// on the specified dashboard. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	GetDashboard(context.Context, *GetDashboardRequest) (*Dashboard, error)
	// Deletes an existing custom dashboard.
	//
	// This method requires the `monitoring.dashboards.delete` permission
	// on the specified dashboard. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	DeleteDashboard(context.Context, *DeleteDashboardRequest) (*empty.Empty, error)
	// Replaces an existing custom dashboard with a new definition.
	//
	// This method requires the `monitoring.dashboards.update` permission
	// on the specified dashboard. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	UpdateDashboard(context.Context, *UpdateDashboardRequest) (*Dashboard, error)
}

// UnimplementedDashboardsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDashboardsServiceServer struct {
}

func (*UnimplementedDashboardsServiceServer) CreateDashboard(ctx context.Context, req *CreateDashboardRequest) (*Dashboard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDashboard not implemented")
}
func (*UnimplementedDashboardsServiceServer) ListDashboards(ctx context.Context, req *ListDashboardsRequest) (*ListDashboardsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDashboards not implemented")
}
func (*UnimplementedDashboardsServiceServer) GetDashboard(ctx context.Context, req *GetDashboardRequest) (*Dashboard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDashboard not implemented")
}
func (*UnimplementedDashboardsServiceServer) DeleteDashboard(ctx context.Context, req *DeleteDashboardRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDashboard not implemented")
}
func (*UnimplementedDashboardsServiceServer) UpdateDashboard(ctx context.Context, req *UpdateDashboardRequest) (*Dashboard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDashboard not implemented")
}

func RegisterDashboardsServiceServer(s *grpc.Server, srv DashboardsServiceServer) {
	s.RegisterService(&_DashboardsService_serviceDesc, srv)
}

func _DashboardsService_CreateDashboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDashboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DashboardsServiceServer).CreateDashboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.dashboard.v1.DashboardsService/CreateDashboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DashboardsServiceServer).CreateDashboard(ctx, req.(*CreateDashboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DashboardsService_ListDashboards_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDashboardsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DashboardsServiceServer).ListDashboards(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.dashboard.v1.DashboardsService/ListDashboards",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DashboardsServiceServer).ListDashboards(ctx, req.(*ListDashboardsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DashboardsService_GetDashboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDashboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DashboardsServiceServer).GetDashboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.dashboard.v1.DashboardsService/GetDashboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DashboardsServiceServer).GetDashboard(ctx, req.(*GetDashboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DashboardsService_DeleteDashboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDashboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DashboardsServiceServer).DeleteDashboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.dashboard.v1.DashboardsService/DeleteDashboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DashboardsServiceServer).DeleteDashboard(ctx, req.(*DeleteDashboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DashboardsService_UpdateDashboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDashboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DashboardsServiceServer).UpdateDashboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.dashboard.v1.DashboardsService/UpdateDashboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DashboardsServiceServer).UpdateDashboard(ctx, req.(*UpdateDashboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DashboardsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.dashboard.v1.DashboardsService",
	HandlerType: (*DashboardsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDashboard",
			Handler:    _DashboardsService_CreateDashboard_Handler,
		},
		{
			MethodName: "ListDashboards",
			Handler:    _DashboardsService_ListDashboards_Handler,
		},
		{
			MethodName: "GetDashboard",
			Handler:    _DashboardsService_GetDashboard_Handler,
		},
		{
			MethodName: "DeleteDashboard",
			Handler:    _DashboardsService_DeleteDashboard_Handler,
		},
		{
			MethodName: "UpdateDashboard",
			Handler:    _DashboardsService_UpdateDashboard_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/dashboard/v1/dashboards_service.proto",
}
