#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& [ `grep 'FREEBUSY;FBTYPE=BUSY' out3.tmp | wc -l` = '3' ] \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141212T090000Z/20141212T100000Z' out3.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring-instance.txt" 2>> $ERROR
echo "Cancel..."

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& [ `grep 'FREEBUSY;FBTYPE=BUSY' out4.tmp | wc -l` = '2' ] \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141114T090000Z/20141114T100000Z' out4.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-reschedule-instance.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out5.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141011T080000Z/20141011T090000Z' out6.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141010T080000Z/20141010T090000Z' out6.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring.txt" 2>> $ERROR
echo "Cancel..."

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REPLY' out7.tmp \
&& ! grep -q '^FREEBUSY' out7.tmp \
&& echo "Success" \
|| echo "Failed"
