/**
 * JNA-InChI - Library for calling InChI from Java
 * Copyright © 2018 Daniel Lowe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.github.dan2097.jnainchi.inchi;
import java.util.Arrays;
import java.util.List;

import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
/**
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class tagINCHIGEN_DATA extends Structure implements ByReference {
  /**
   * intermediate log (warning/error report)<br>
   * C type : char[256]
   */
  public byte[] pStrErrStruct = new byte[256];
  /**
   * number of allocated INChI, INChI_Aux data structures<br>
   * C type : int[2]
   */
  public int[] num_components = new int[2];
  /** C type : NORM_ATOMS*[2] */
  public tagNormAtomData[] NormAtomsNontaut = new tagNormAtomData[2];
  /** C type : NORM_ATOMS*[2] */
  public tagNormAtomData[] NormAtomsTaut = new tagNormAtomData[2];

  protected List<String> getFieldOrder() {
    return Arrays.asList("pStrErrStruct", "num_components", "NormAtomsNontaut", "NormAtomsTaut");
  }
  /**
   * @param pStrErrStruct intermediate log (warning/error report)<br>
   * C type : char[256]<br>
   * @param num_components number of allocated INChI, INChI_Aux data structures<br>
   * C type : int[2]<br>
   * @param NormAtomsNontaut C type : NORM_ATOMS*[2]<br>
   * @param NormAtomsTaut C type : NORM_ATOMS*[2]
   */
  public tagINCHIGEN_DATA(byte pStrErrStruct[], int num_components[], tagNormAtomData NormAtomsNontaut[], tagNormAtomData NormAtomsTaut[]) {
    super();
    if ((pStrErrStruct.length != this.pStrErrStruct.length)) 
      throw new IllegalArgumentException("Wrong array size !");
    this.pStrErrStruct = pStrErrStruct;
    if ((num_components.length != this.num_components.length)) 
      throw new IllegalArgumentException("Wrong array size !");
    this.num_components = num_components;
    if ((NormAtomsNontaut.length != this.NormAtomsNontaut.length)) 
      throw new IllegalArgumentException("Wrong array size !");
    this.NormAtomsNontaut = NormAtomsNontaut;
    if ((NormAtomsTaut.length != this.NormAtomsTaut.length)) 
      throw new IllegalArgumentException("Wrong array size !");
    this.NormAtomsTaut = NormAtomsTaut;
  }

}
