# generated by gen-config.py DO NOT edit

import typing
import kittens.ssh.copy

if typing.TYPE_CHECKING:
    choices_for_askpass = typing.Literal['unless-set', 'ssh', 'native']
    choices_for_remote_kitty = typing.Literal['if-needed', 'no', 'yes']
else:
    choices_for_askpass = str
    choices_for_remote_kitty = str

option_names = (  # {{{
 'askpass',
 'color_scheme',
 'copy',
 'cwd',
 'env',
 'hostname',
 'interpreter',
 'login_shell',
 'remote_dir',
 'remote_kitty',
 'share_connections',
 'shell_integration')  # }}}


class Options:
    askpass: choices_for_askpass = 'unless-set'
    color_scheme: str = ''
    cwd: str = ''
    hostname: str = '*'
    interpreter: str = 'sh'
    login_shell: str = ''
    remote_dir: str = '.local/share/kitty-ssh-kitten'
    remote_kitty: choices_for_remote_kitty = 'if-needed'
    share_connections: bool = True
    shell_integration: str = 'inherited'
    copy: typing.Dict[str, kittens.ssh.copy.CopyInstruction] = {}
    env: typing.Dict[str, str] = {}
    config_paths: typing.Tuple[str, ...] = ()
    config_overrides: typing.Tuple[str, ...] = ()

    def __init__(self, options_dict: typing.Optional[typing.Dict[str, typing.Any]] = None) -> None:
        if options_dict is not None:
            null = object()
            for key in option_names:
                val = options_dict.get(key, null)
                if val is not null:
                    setattr(self, key, val)

    @property
    def _fields(self) -> typing.Tuple[str, ...]:
        return option_names

    def __iter__(self) -> typing.Iterator[str]:
        return iter(self._fields)

    def __len__(self) -> int:
        return len(self._fields)

    def _copy_of_val(self, name: str) -> typing.Any:
        ans = getattr(self, name)
        if isinstance(ans, dict):
            ans = ans.copy()
        elif isinstance(ans, list):
            ans = ans[:]
        return ans

    def _asdict(self) -> typing.Dict[str, typing.Any]:
        return {k: self._copy_of_val(k) for k in self}

    def _replace(self, **kw: typing.Any) -> "Options":
        ans = Options()
        for name in self:
            setattr(ans, name, self._copy_of_val(name))
        for name, val in kw.items():
            setattr(ans, name, val)
        return ans

    def __getitem__(self, key: typing.Union[int, str]) -> typing.Any:
        k = option_names[key] if isinstance(key, int) else key
        try:
            return getattr(self, k)
        except AttributeError:
            pass
        raise KeyError(f"No option named: {k}")


defaults = Options()
defaults.copy = {}
defaults.env = {}
