
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPainter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPainter>
#include <QBrush>
#include <QColor>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGlyphRun>
#include <QImage>
#include <QLine>
#include <QLineF>
#include <QMatrix>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPainterPath>
#include <QPen>
#include <QPicture>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QPolygon>
#include <QPolygonF>
#include <QRect>
#include <QRectF>
#include <QRegion>
#include <QStaticText>
#include <QTextItem>
#include <QTextOption>
#include <QTransform>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPainter

//  Constructor QPainter::QPainter()


static void _init_ctor_QPainter_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPainter> ();
}

static void _call_ctor_QPainter_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter *> (new QPainter ());
}


//  Constructor QPainter::QPainter(QPaintDevice *)


static void _init_ctor_QPainter_1803 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return_new<QPainter> ();
}

static void _call_ctor_QPainter_1803 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  ret.write<QPainter *> (new QPainter (arg1));
}


// const QBrush &QPainter::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPainter *)cls)->background ());
}


// Qt::BGMode QPainter::backgroundMode()


static void _init_f_backgroundMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::BGMode>::target_type > ();
}

static void _call_f_backgroundMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::BGMode>::target_type > ((qt_gsi::Converter<Qt::BGMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::BGMode>(((QPainter *)cls)->backgroundMode ()));
}


// bool QPainter::begin(QPaintDevice *)


static void _init_f_begin_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_begin_1803 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  ret.write<bool > ((bool)((QPainter *)cls)->begin (arg1));
}


// void QPainter::beginNativePainting()


static void _init_f_beginNativePainting_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beginNativePainting_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->beginNativePainting ();
}


// QRectF QPainter::boundingRect(const QRectF &rect, int flags, const QString &text)


static void _init_f_boundingRect_4438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_4438 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPainter *)cls)->boundingRect (arg1, arg2, arg3));
}


// QRect QPainter::boundingRect(const QRect &rect, int flags, const QString &text)


static void _init_f_boundingRect_4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_boundingRect_4368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QRect > ((QRect)((QPainter *)cls)->boundingRect (arg1, arg2, arg3));
}


// QRect QPainter::boundingRect(int x, int y, int w, int h, int flags, const QString &text)


static void _init_f_boundingRect_5320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  decl->set_return<QRect > ();
}

static void _call_f_boundingRect_5320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  const QString &arg6 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QRect > ((QRect)((QPainter *)cls)->boundingRect (arg1, arg2, arg3, arg4, arg5, arg6));
}


// QRectF QPainter::boundingRect(const QRectF &rect, const QString &text, const QTextOption &o)


static void _init_f_boundingRect_6119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("o", true, "QTextOption()");
  decl->add_arg<const QTextOption & > (argspec_2);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_6119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QTextOption &arg3 = args ? gsi::arg_reader<const QTextOption & >() (args, heap) : gsi::arg_maker<const QTextOption & >() (QTextOption(), heap);
  ret.write<QRectF > ((QRectF)((QPainter *)cls)->boundingRect (arg1, arg2, arg3));
}


// const QBrush &QPainter::brush()


static void _init_f_brush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_brush_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QBrush & > ((const QBrush &)((QPainter *)cls)->brush ());
}


// QPoint QPainter::brushOrigin()


static void _init_f_brushOrigin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_brushOrigin_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QPainter *)cls)->brushOrigin ());
}


// QRectF QPainter::clipBoundingRect()


static void _init_f_clipBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_clipBoundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QPainter *)cls)->clipBoundingRect ());
}


// QPainterPath QPainter::clipPath()


static void _init_f_clipPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_clipPath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QPainter *)cls)->clipPath ());
}


// QRegion QPainter::clipRegion()


static void _init_f_clipRegion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_clipRegion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QPainter *)cls)->clipRegion ());
}


// QMatrix QPainter::combinedMatrix()


static void _init_f_combinedMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_combinedMatrix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMatrix > ((QMatrix)((QPainter *)cls)->combinedMatrix ());
}


// QTransform QPainter::combinedTransform()


static void _init_f_combinedTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_combinedTransform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QPainter *)cls)->combinedTransform ());
}


// QPainter::CompositionMode QPainter::compositionMode()


static void _init_f_compositionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPainter::CompositionMode>::target_type > ();
}

static void _call_f_compositionMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPainter::CompositionMode>::target_type > ((qt_gsi::Converter<QPainter::CompositionMode>::target_type)qt_gsi::CppToQtAdaptor<QPainter::CompositionMode>(((QPainter *)cls)->compositionMode ()));
}


// QPaintDevice *QPainter::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPainter *)cls)->device ());
}


// const QMatrix &QPainter::deviceMatrix()


static void _init_f_deviceMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_deviceMatrix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QMatrix & > ((const QMatrix &)((QPainter *)cls)->deviceMatrix ());
}


// const QTransform &QPainter::deviceTransform()


static void _init_f_deviceTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTransform & > ();
}

static void _call_f_deviceTransform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QTransform & > ((const QTransform &)((QPainter *)cls)->deviceTransform ());
}


// void QPainter::drawArc(const QRectF &rect, int a, int alen)


static void _init_f_drawArc_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawArc_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawArc (arg1, arg2, arg3);
}


// void QPainter::drawArc(const QRect &, int a, int alen)


static void _init_f_drawArc_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawArc_3110 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawArc (arg1, arg2, arg3);
}


// void QPainter::drawArc(int x, int y, int w, int h, int a, int alen)


static void _init_f_drawArc_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alen");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawArc_4062 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawArc (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QPainter::drawChord(const QRectF &rect, int a, int alen)


static void _init_f_drawChord_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawChord_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawChord (arg1, arg2, arg3);
}


// void QPainter::drawChord(int x, int y, int w, int h, int a, int alen)


static void _init_f_drawChord_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alen");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawChord_4062 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawChord (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QPainter::drawChord(const QRect &, int a, int alen)


static void _init_f_drawChord_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawChord_3110 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawChord (arg1, arg2, arg3);
}


// void QPainter::drawConvexPolygon(const QPolygonF &polygon)


static void _init_f_drawConvexPolygon_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawConvexPolygon_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawConvexPolygon (arg1);
}


// void QPainter::drawConvexPolygon(const QPolygon &polygon)


static void _init_f_drawConvexPolygon_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawConvexPolygon_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawConvexPolygon (arg1);
}


// void QPainter::drawEllipse(const QRectF &r)


static void _init_f_drawEllipse_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawEllipse (arg1);
}


// void QPainter::drawEllipse(const QRect &r)


static void _init_f_drawEllipse_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawEllipse (arg1);
}


// void QPainter::drawEllipse(int x, int y, int w, int h)


static void _init_f_drawEllipse_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawEllipse (arg1, arg2, arg3, arg4);
}


// void QPainter::drawEllipse(const QPointF &center, double rx, double ry)


static void _init_f_drawEllipse_3912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ry");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_3912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawEllipse (arg1, arg2, arg3);
}


// void QPainter::drawEllipse(const QPoint &center, int rx, int ry)


static void _init_f_drawEllipse_3234 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rx");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ry");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_3234 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawEllipse (arg1, arg2, arg3);
}


// void QPainter::drawGlyphRun(const QPointF &position, const QGlyphRun &glyphRun)


static void _init_f_drawGlyphRun_4097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("glyphRun");
  decl->add_arg<const QGlyphRun & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawGlyphRun_4097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QGlyphRun &arg2 = gsi::arg_reader<const QGlyphRun & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawGlyphRun (arg1, arg2);
}


// void QPainter::drawImage(const QRectF &targetRect, const QImage &image, const QRectF &sourceRect, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8645 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  const QRectF &arg3 = gsi::arg_reader<const QRectF & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, arg4);
}


// void QPainter::drawImage(const QRect &targetRect, const QImage &image, const QRect &sourceRect, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8505 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8505 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, arg4);
}


// void QPainter::drawImage(const QPointF &p, const QImage &image, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8769 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8769 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  const QRectF &arg3 = gsi::arg_reader<const QRectF & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, arg4);
}


// void QPainter::drawImage(const QPoint &p, const QImage &image, const QRect &sr, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8629 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8629 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, arg4);
}


// void QPainter::drawImage(const QRectF &r, const QImage &image)


static void _init_f_drawImage_3631 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3631 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2);
}


// void QPainter::drawImage(const QRect &r, const QImage &image)


static void _init_f_drawImage_3561 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3561 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2);
}


// void QPainter::drawImage(const QPointF &p, const QImage &image)


static void _init_f_drawImage_3755 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3755 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2);
}


// void QPainter::drawImage(const QPoint &p, const QImage &image)


static void _init_f_drawImage_3685 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3685 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2);
}


// void QPainter::drawImage(int x, int y, const QImage &image, int sx, int sy, int sw, int sh, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_9091 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("image");
  decl->add_arg<const QImage & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("sx", true, "0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("sy", true, "0");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sw", true, "-1");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sh", true, "-1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_7);
  decl->set_return<void > ();
}

static void _call_f_drawImage_9091 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QImage &arg3 = gsi::arg_reader<const QImage & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  int arg7 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  QFlags<Qt::ImageConversionFlag> arg8 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}


// void QPainter::drawLine(const QLineF &line)


static void _init_f_drawLine_1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLine_1856 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLineF &arg1 = gsi::arg_reader<const QLineF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLine (arg1);
}


// void QPainter::drawLine(const QLine &line)


static void _init_f_drawLine_1786 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLine_1786 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLine &arg1 = gsi::arg_reader<const QLine & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLine (arg1);
}


// void QPainter::drawLine(int x1, int y1, int x2, int y2)


static void _init_f_drawLine_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawLine_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLine (arg1, arg2, arg3, arg4);
}


// void QPainter::drawLine(const QPoint &p1, const QPoint &p2)


static void _init_f_drawLine_3724 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawLine_3724 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QPoint &arg2 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLine (arg1, arg2);
}


// void QPainter::drawLine(const QPointF &p1, const QPointF &p2)


static void _init_f_drawLine_3864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p2");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawLine_3864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLine (arg1, arg2);
}


// void QPainter::drawLines(const QVector<QLineF> &lines)


static void _init_f_drawLines_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lines");
  decl->add_arg<const QVector<QLineF> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2686 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QLineF> &arg1 = gsi::arg_reader<const QVector<QLineF> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLines (arg1);
}


// void QPainter::drawLines(const QVector<QPointF> &pointPairs)


static void _init_f_drawLines_2816 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pointPairs");
  decl->add_arg<const QVector<QPointF> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2816 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QPointF> &arg1 = gsi::arg_reader<const QVector<QPointF> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLines (arg1);
}


// void QPainter::drawLines(const QVector<QLine> &lines)


static void _init_f_drawLines_2616 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lines");
  decl->add_arg<const QVector<QLine> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2616 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QLine> &arg1 = gsi::arg_reader<const QVector<QLine> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLines (arg1);
}


// void QPainter::drawLines(const QVector<QPoint> &pointPairs)


static void _init_f_drawLines_2746 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pointPairs");
  decl->add_arg<const QVector<QPoint> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2746 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QPoint> &arg1 = gsi::arg_reader<const QVector<QPoint> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawLines (arg1);
}


// void QPainter::drawPath(const QPainterPath &path)


static void _init_f_drawPath_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPath_2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPath (arg1);
}


// void QPainter::drawPicture(const QPointF &p, const QPicture &picture)


static void _init_f_drawPicture_4004 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("picture");
  decl->add_arg<const QPicture & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPicture_4004 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QPicture &arg2 = gsi::arg_reader<const QPicture & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPicture (arg1, arg2);
}


// void QPainter::drawPicture(int x, int y, const QPicture &picture)


static void _init_f_drawPicture_3444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("picture");
  decl->add_arg<const QPicture & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPicture_3444 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QPicture &arg3 = gsi::arg_reader<const QPicture & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPicture (arg1, arg2, arg3);
}


// void QPainter::drawPicture(const QPoint &p, const QPicture &picture)


static void _init_f_drawPicture_3934 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("picture");
  decl->add_arg<const QPicture & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPicture_3934 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QPicture &arg2 = gsi::arg_reader<const QPicture & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPicture (arg1, arg2);
}


// void QPainter::drawPie(const QRectF &rect, int a, int alen)


static void _init_f_drawPie_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPie_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPie (arg1, arg2, arg3);
}


// void QPainter::drawPie(int x, int y, int w, int h, int a, int alen)


static void _init_f_drawPie_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alen");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawPie_4062 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPie (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QPainter::drawPie(const QRect &, int a, int alen)


static void _init_f_drawPie_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPie_3110 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPie (arg1, arg2, arg3);
}


// void QPainter::drawPixmap(const QRectF &targetRect, const QPixmap &pixmap, const QRectF &sourceRect)


static void _init_f_drawPixmap_5525 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5525 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QRectF &arg3 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}


// void QPainter::drawPixmap(const QRect &targetRect, const QPixmap &pixmap, const QRect &sourceRect)


static void _init_f_drawPixmap_5385 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5385 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}


// void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm, int sx, int sy, int sw, int sh)


static void _init_f_drawPixmap_7289 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pm");
  decl->add_arg<const QPixmap & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sx");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sy");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("sw");
  decl->add_arg<int > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("sh");
  decl->add_arg<int > (argspec_8);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_7289 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg5 = gsi::arg_reader<const QPixmap & >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  int arg7 = gsi::arg_reader<int >() (args, heap);
  int arg8 = gsi::arg_reader<int >() (args, heap);
  int arg9 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
}


// void QPainter::drawPixmap(int x, int y, const QPixmap &pm, int sx, int sy, int sw, int sh)


static void _init_f_drawPixmap_5971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pm");
  decl->add_arg<const QPixmap & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("sx");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("sy");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sw");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sh");
  decl->add_arg<int > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5971 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg3 = gsi::arg_reader<const QPixmap & >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  int arg7 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}


// void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm, const QRectF &sr)


static void _init_f_drawPixmap_5649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5649 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QRectF &arg3 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}


// void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm, const QRect &sr)


static void _init_f_drawPixmap_5509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}


// void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm)


static void _init_f_drawPixmap_3895 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3895 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2);
}


// void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm)


static void _init_f_drawPixmap_3825 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3825 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2);
}


// void QPainter::drawPixmap(int x, int y, const QPixmap &pm)


static void _init_f_drawPixmap_3335 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pm");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3335 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg3 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}


// void QPainter::drawPixmap(const QRect &r, const QPixmap &pm)


static void _init_f_drawPixmap_3701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2);
}


// void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm)


static void _init_f_drawPixmap_4653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pm");
  decl->add_arg<const QPixmap & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_4653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg5 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3, arg4, arg5);
}


// void QPainter::drawPixmapFragments(const QPainter::PixmapFragment *fragments, int fragmentCount, const QPixmap &pixmap, QFlags<QPainter::PixmapFragmentHint> hints)


static void _init_f_drawPixmapFragments_10038 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragments");
  decl->add_arg<const QPainter::PixmapFragment * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fragmentCount");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hints", true, "0");
  decl->add_arg<QFlags<QPainter::PixmapFragmentHint> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawPixmapFragments_10038 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainter::PixmapFragment *arg1 = gsi::arg_reader<const QPainter::PixmapFragment * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg3 = gsi::arg_reader<const QPixmap & >() (args, heap);
  QFlags<QPainter::PixmapFragmentHint> arg4 = args ? gsi::arg_reader<QFlags<QPainter::PixmapFragmentHint> >() (args, heap) : gsi::arg_maker<QFlags<QPainter::PixmapFragmentHint> >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPixmapFragments (arg1, arg2, arg3, arg4);
}


// void QPainter::drawPoint(const QPointF &pt)


static void _init_f_drawPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoint_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPoint (arg1);
}


// void QPainter::drawPoint(const QPoint &p)


static void _init_f_drawPoint_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoint_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPoint (arg1);
}


// void QPainter::drawPoint(int x, int y)


static void _init_f_drawPoint_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPoint_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPoint (arg1, arg2);
}


// void QPainter::drawPoints(const QPolygonF &points)


static void _init_f_drawPoints_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("points");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoints_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPoints (arg1);
}


// void QPainter::drawPoints(const QPolygon &points)


static void _init_f_drawPoints_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("points");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoints_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPoints (arg1);
}


// void QPainter::drawPolygon(const QPolygonF &polygon, Qt::FillRule fillRule)


static void _init_f_drawPolygon_3648 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fillRule", true, "Qt::OddEvenFill");
  decl->add_arg<const qt_gsi::Converter<Qt::FillRule>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPolygon_3648 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  const qt_gsi::Converter<Qt::FillRule>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::FillRule>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::FillRule>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::FillRule>(heap, Qt::OddEvenFill), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPolygon (arg1, qt_gsi::QtToCppAdaptor<Qt::FillRule>(arg2).cref());
}


// void QPainter::drawPolygon(const QPolygon &polygon, Qt::FillRule fillRule)


static void _init_f_drawPolygon_3578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fillRule", true, "Qt::OddEvenFill");
  decl->add_arg<const qt_gsi::Converter<Qt::FillRule>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPolygon_3578 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  const qt_gsi::Converter<Qt::FillRule>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::FillRule>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::FillRule>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::FillRule>(heap, Qt::OddEvenFill), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPolygon (arg1, qt_gsi::QtToCppAdaptor<Qt::FillRule>(arg2).cref());
}


// void QPainter::drawPolyline(const QPolygonF &polyline)


static void _init_f_drawPolyline_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polyline");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPolyline_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPolyline (arg1);
}


// void QPainter::drawPolyline(const QPolygon &polygon)


static void _init_f_drawPolyline_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPolyline_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawPolyline (arg1);
}


// void QPainter::drawRect(const QRectF &rect)


static void _init_f_drawRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRect_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRect (arg1);
}


// void QPainter::drawRect(int x1, int y1, int w, int h)


static void _init_f_drawRect_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawRect_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRect (arg1, arg2, arg3, arg4);
}


// void QPainter::drawRect(const QRect &rect)


static void _init_f_drawRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRect_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRect (arg1);
}


// void QPainter::drawRects(const QVector<QRectF> &rectangles)


static void _init_f_drawRects_2692 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rectangles");
  decl->add_arg<const QVector<QRectF> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRects_2692 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QRectF> &arg1 = gsi::arg_reader<const QVector<QRectF> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRects (arg1);
}


// void QPainter::drawRects(const QVector<QRect> &rectangles)


static void _init_f_drawRects_2622 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rectangles");
  decl->add_arg<const QVector<QRect> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRects_2622 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QRect> &arg1 = gsi::arg_reader<const QVector<QRect> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRects (arg1);
}


// void QPainter::drawRoundRect(const QRectF &r, int xround, int yround)


static void _init_f_drawRoundRect_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xround", true, "25");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yround", true, "25");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawRoundRect_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (25, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (25, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRoundRect (arg1, arg2, arg3);
}


// void QPainter::drawRoundRect(int x, int y, int w, int h, int, int)


static void _init_f_drawRoundRect_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5", true, "25");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("arg6", true, "25");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawRoundRect_4062 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (25, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (25, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRoundRect (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QPainter::drawRoundRect(const QRect &r, int xround, int yround)


static void _init_f_drawRoundRect_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xround", true, "25");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yround", true, "25");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawRoundRect_3110 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (25, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (25, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRoundRect (arg1, arg2, arg3);
}


// void QPainter::drawRoundedRect(const QRectF &rect, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_drawRoundedRect_5229 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xRadius");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yRadius");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawRoundedRect_5229 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SizeMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SizeMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRoundedRect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg4).cref());
}


// void QPainter::drawRoundedRect(int x, int y, int w, int h, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_drawRoundedRect_6111 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xRadius");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("yRadius");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawRoundedRect_6111 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  double arg6 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg7 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SizeMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SizeMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRoundedRect (arg1, arg2, arg3, arg4, arg5, arg6, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg7).cref());
}


// void QPainter::drawRoundedRect(const QRect &rect, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_drawRoundedRect_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xRadius");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yRadius");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawRoundedRect_5159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SizeMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SizeMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawRoundedRect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg4).cref());
}


// void QPainter::drawStaticText(const QPointF &topLeftPosition, const QStaticText &staticText)


static void _init_f_drawStaticText_4309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeftPosition");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("staticText");
  decl->add_arg<const QStaticText & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawStaticText_4309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QStaticText &arg2 = gsi::arg_reader<const QStaticText & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawStaticText (arg1, arg2);
}


// void QPainter::drawStaticText(const QPoint &topLeftPosition, const QStaticText &staticText)


static void _init_f_drawStaticText_4239 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeftPosition");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("staticText");
  decl->add_arg<const QStaticText & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawStaticText_4239 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QStaticText &arg2 = gsi::arg_reader<const QStaticText & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawStaticText (arg1, arg2);
}


// void QPainter::drawStaticText(int left, int top, const QStaticText &staticText)


static void _init_f_drawStaticText_3749 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("staticText");
  decl->add_arg<const QStaticText & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawStaticText_3749 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QStaticText &arg3 = gsi::arg_reader<const QStaticText & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawStaticText (arg1, arg2, arg3);
}


// void QPainter::drawText(const QPointF &p, const QString &s)


static void _init_f_drawText_3903 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawText_3903 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2);
}


// void QPainter::drawText(const QPoint &p, const QString &s)


static void _init_f_drawText_3833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawText_3833 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2);
}


// void QPainter::drawText(int x, int y, const QString &s)


static void _init_f_drawText_3343 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("s");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawText_3343 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3);
}


// void QPainter::drawText(const QPointF &p, const QString &str, int tf, int justificationPadding)


static void _init_f_drawText_5221 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("str");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("tf");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("justificationPadding");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawText_5221 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4);
}


// void QPainter::drawText(const QRectF &r, int flags, const QString &text, QRectF *br)


static void _init_f_drawText_5501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("br", true, "0");
  decl->add_arg<QRectF * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawText_5501 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QRectF *arg4 = args ? gsi::arg_reader<QRectF * >() (args, heap) : gsi::arg_maker<QRectF * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4);
}


// void QPainter::drawText(const QRect &r, int flags, const QString &text, QRect *br)


static void _init_f_drawText_5361 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("br", true, "0");
  decl->add_arg<QRect * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawText_5361 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QRect *arg4 = args ? gsi::arg_reader<QRect * >() (args, heap) : gsi::arg_maker<QRect * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4);
}


// void QPainter::drawText(int x, int y, int w, int h, int flags, const QString &text, QRect *br)


static void _init_f_drawText_6313 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("br", true, "0");
  decl->add_arg<QRect * > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawText_6313 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  const QString &arg6 = gsi::arg_reader<const QString & >() (args, heap);
  QRect *arg7 = args ? gsi::arg_reader<QRect * >() (args, heap) : gsi::arg_maker<QRect * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}


// void QPainter::drawText(const QRectF &r, const QString &text, const QTextOption &o)


static void _init_f_drawText_6119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("o", true, "QTextOption()");
  decl->add_arg<const QTextOption & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawText_6119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QTextOption &arg3 = args ? gsi::arg_reader<const QTextOption & >() (args, heap) : gsi::arg_maker<const QTextOption & >() (QTextOption(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3);
}


// void QPainter::drawTextItem(const QPointF &p, const QTextItem &ti)


static void _init_f_drawTextItem_4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ti");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_4092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QTextItem &arg2 = gsi::arg_reader<const QTextItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawTextItem (arg1, arg2);
}


// void QPainter::drawTextItem(int x, int y, const QTextItem &ti)


static void _init_f_drawTextItem_3532 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ti");
  decl->add_arg<const QTextItem & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_3532 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QTextItem &arg3 = gsi::arg_reader<const QTextItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawTextItem (arg1, arg2, arg3);
}


// void QPainter::drawTextItem(const QPoint &p, const QTextItem &ti)


static void _init_f_drawTextItem_4022 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ti");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_4022 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QTextItem &arg2 = gsi::arg_reader<const QTextItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawTextItem (arg1, arg2);
}


// void QPainter::drawTiledPixmap(const QRectF &rect, const QPixmap &pm, const QPointF &offset)


static void _init_f_drawTiledPixmap_5649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offset", true, "QPointF()");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5649 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QPointF &arg3 = args ? gsi::arg_reader<const QPointF & >() (args, heap) : gsi::arg_maker<const QPointF & >() (QPointF(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawTiledPixmap (arg1, arg2, arg3);
}


// void QPainter::drawTiledPixmap(int x, int y, int w, int h, const QPixmap &, int sx, int sy)


static void _init_f_drawTiledPixmap_5971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5");
  decl->add_arg<const QPixmap & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sx", true, "0");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sy", true, "0");
  decl->add_arg<int > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5971 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg5 = gsi::arg_reader<const QPixmap & >() (args, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg7 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawTiledPixmap (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}


// void QPainter::drawTiledPixmap(const QRect &, const QPixmap &, const QPoint &)


static void _init_f_drawTiledPixmap_5509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QPoint &arg3 = args ? gsi::arg_reader<const QPoint & >() (args, heap) : gsi::arg_maker<const QPoint & >() (QPoint(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->drawTiledPixmap (arg1, arg2, arg3);
}


// bool QPainter::end()


static void _init_f_end_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_end_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPainter *)cls)->end ());
}


// void QPainter::endNativePainting()


static void _init_f_endNativePainting_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endNativePainting_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->endNativePainting ();
}


// void QPainter::eraseRect(const QRectF &)


static void _init_f_eraseRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_eraseRect_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->eraseRect (arg1);
}


// void QPainter::eraseRect(int x, int y, int w, int h)


static void _init_f_eraseRect_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_eraseRect_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->eraseRect (arg1, arg2, arg3, arg4);
}


// void QPainter::eraseRect(const QRect &)


static void _init_f_eraseRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_eraseRect_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->eraseRect (arg1);
}


// void QPainter::fillPath(const QPainterPath &path, const QBrush &brush)


static void _init_f_fillPath_4316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("brush");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillPath_4316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const QBrush &arg2 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillPath (arg1, arg2);
}


// void QPainter::fillRect(const QRectF &, const QBrush &)


static void _init_f_fillRect_3664 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3664 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QBrush &arg2 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2);
}


// void QPainter::fillRect(int x, int y, int w, int h, const QBrush &)


static void _init_f_fillRect_4546 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5");
  decl->add_arg<const QBrush & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4546 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QBrush &arg5 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, arg5);
}


// void QPainter::fillRect(const QRect &, const QBrush &)


static void _init_f_fillRect_3594 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3594 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QBrush &arg2 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2);
}


// void QPainter::fillRect(const QRectF &, const QColor &color)


static void _init_f_fillRect_3659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("color");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QColor &arg2 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2);
}


// void QPainter::fillRect(int x, int y, int w, int h, const QColor &color)


static void _init_f_fillRect_4541 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("color");
  decl->add_arg<const QColor & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4541 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QColor &arg5 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, arg5);
}


// void QPainter::fillRect(const QRect &, const QColor &color)


static void _init_f_fillRect_3589 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("color");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3589 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const QColor &arg2 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2);
}


// void QPainter::fillRect(int x, int y, int w, int h, Qt::GlobalColor c)


static void _init_f_fillRect_4489 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("c");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4489 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg5 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg5).cref());
}


// void QPainter::fillRect(const QRect &r, Qt::GlobalColor c)


static void _init_f_fillRect_3537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3537 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg2).cref());
}


// void QPainter::fillRect(const QRectF &r, Qt::GlobalColor c)


static void _init_f_fillRect_3607 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3607 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg2).cref());
}


// void QPainter::fillRect(int x, int y, int w, int h, Qt::BrushStyle style)


static void _init_f_fillRect_4430 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4430 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg5 = gsi::arg_reader<const qt_gsi::Converter<Qt::BrushStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg5).cref());
}


// void QPainter::fillRect(const QRect &r, Qt::BrushStyle style)


static void _init_f_fillRect_3478 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3478 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::BrushStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg2).cref());
}


// void QPainter::fillRect(const QRectF &r, Qt::BrushStyle style)


static void _init_f_fillRect_3548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3548 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::BrushStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg2).cref());
}


// const QFont &QPainter::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QFont & > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QFont & > ((const QFont &)((QPainter *)cls)->font ());
}


// QFontInfo QPainter::fontInfo()


static void _init_f_fontInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontInfo > ();
}

static void _call_f_fontInfo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFontInfo > ((QFontInfo)((QPainter *)cls)->fontInfo ());
}


// QFontMetrics QPainter::fontMetrics()


static void _init_f_fontMetrics_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFontMetrics > ((QFontMetrics)((QPainter *)cls)->fontMetrics ());
}


// bool QPainter::hasClipping()


static void _init_f_hasClipping_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasClipping_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPainter *)cls)->hasClipping ());
}


// void QPainter::initFrom(const QPaintDevice *device)


static void _init_f_initFrom_2498 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_initFrom_2498 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPaintDevice *arg1 = gsi::arg_reader<const QPaintDevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->initFrom (arg1);
}


// bool QPainter::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPainter *)cls)->isActive ());
}


// Qt::LayoutDirection QPainter::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QPainter *)cls)->layoutDirection ()));
}


// const QMatrix &QPainter::matrix()


static void _init_f_matrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_matrix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QMatrix & > ((const QMatrix &)((QPainter *)cls)->matrix ());
}


// bool QPainter::matrixEnabled()


static void _init_f_matrixEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_matrixEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPainter *)cls)->matrixEnabled ());
}


// double QPainter::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QPainter *)cls)->opacity ());
}


// QPaintEngine *QPainter::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPainter *)cls)->paintEngine ());
}


// const QPen &QPainter::pen()


static void _init_f_pen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPen & > ();
}

static void _call_f_pen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QPen & > ((const QPen &)((QPainter *)cls)->pen ());
}


// QFlags<QPainter::RenderHint> QPainter::renderHints()


static void _init_f_renderHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QPainter::RenderHint> > ();
}

static void _call_f_renderHints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QPainter::RenderHint> > ((QFlags<QPainter::RenderHint>)((QPainter *)cls)->renderHints ());
}


// void QPainter::resetMatrix()


static void _init_f_resetMatrix_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetMatrix_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->resetMatrix ();
}


// void QPainter::resetTransform()


static void _init_f_resetTransform_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetTransform_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->resetTransform ();
}


// void QPainter::restore()


static void _init_f_restore_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restore_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->restore ();
}


// void QPainter::rotate(double a)


static void _init_f_rotate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->rotate (arg1);
}


// void QPainter::save()


static void _init_f_save_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_save_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->save ();
}


// void QPainter::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->scale (arg1, arg2);
}


// void QPainter::setBackground(const QBrush &bg)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("bg");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBackground (arg1);
}


// void QPainter::setBackgroundMode(Qt::BGMode mode)


static void _init_f_setBackgroundMode_1275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::BGMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundMode_1275 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::BGMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::BGMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBackgroundMode (qt_gsi::QtToCppAdaptor<Qt::BGMode>(arg1).cref());
}


// void QPainter::setBrush(const QBrush &brush)


static void _init_f_setBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrush_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBrush (arg1);
}


// void QPainter::setBrush(Qt::BrushStyle style)


static void _init_f_setBrush_1794 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrush_1794 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::BrushStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBrush (qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg1).cref());
}


// void QPainter::setBrushOrigin(int x, int y)


static void _init_f_setBrushOrigin_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setBrushOrigin_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBrushOrigin (arg1, arg2);
}


// void QPainter::setBrushOrigin(const QPoint &)


static void _init_f_setBrushOrigin_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrushOrigin_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBrushOrigin (arg1);
}


// void QPainter::setBrushOrigin(const QPointF &)


static void _init_f_setBrushOrigin_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrushOrigin_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setBrushOrigin (arg1);
}


// void QPainter::setClipPath(const QPainterPath &path, Qt::ClipOperation op)


static void _init_f_setClipPath_4492 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipPath_4492 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setClipPath (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}


// void QPainter::setClipRect(const QRectF &, Qt::ClipOperation op)


static void _init_f_setClipRect_3840 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_3840 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setClipRect (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}


// void QPainter::setClipRect(const QRect &, Qt::ClipOperation op)


static void _init_f_setClipRect_3770 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_3770 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setClipRect (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}


// void QPainter::setClipRect(int x, int y, int w, int h, Qt::ClipOperation op)


static void _init_f_setClipRect_4722 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_4722 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setClipRect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg5).cref());
}


// void QPainter::setClipRegion(const QRegion &, Qt::ClipOperation op)


static void _init_f_setClipRegion_3984 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipRegion_3984 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ClipOperation>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setClipRegion (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}


// void QPainter::setClipping(bool enable)


static void _init_f_setClipping_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setClipping_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setClipping (arg1);
}


// void QPainter::setCompositionMode(QPainter::CompositionMode mode)


static void _init_f_setCompositionMode_2917 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QPainter::CompositionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompositionMode_2917 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPainter::CompositionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPainter::CompositionMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setCompositionMode (qt_gsi::QtToCppAdaptor<QPainter::CompositionMode>(arg1).cref());
}


// void QPainter::setFont(const QFont &f)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setFont (arg1);
}


// void QPainter::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}


// void QPainter::setMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_2779 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMatrix &arg1 = gsi::arg_reader<const QMatrix & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setMatrix (arg1, arg2);
}


// void QPainter::setMatrixEnabled(bool enabled)


static void _init_f_setMatrixEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMatrixEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setMatrixEnabled (arg1);
}


// void QPainter::setOpacity(double opacity)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setOpacity (arg1);
}


// void QPainter::setPen(const QColor &color)


static void _init_f_setPen_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setPen (arg1);
}


// void QPainter::setPen(const QPen &pen)


static void _init_f_setPen_1685 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pen");
  decl->add_arg<const QPen & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1685 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPen &arg1 = gsi::arg_reader<const QPen & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setPen (arg1);
}


// void QPainter::setPen(Qt::PenStyle style)


static void _init_f_setPen_1569 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::PenStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1569 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::PenStyle>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::PenStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setPen (qt_gsi::QtToCppAdaptor<Qt::PenStyle>(arg1).cref());
}


// void QPainter::setRenderHint(QPainter::RenderHint hint, bool on)


static void _init_f_setRenderHint_3123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRenderHint_3123 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPainter::RenderHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPainter::RenderHint>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setRenderHint (qt_gsi::QtToCppAdaptor<QPainter::RenderHint>(arg1).cref(), arg2);
}


// void QPainter::setRenderHints(QFlags<QPainter::RenderHint> hints, bool on)


static void _init_f_setRenderHints_3819 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<QFlags<QPainter::RenderHint> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRenderHints_3819 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPainter::RenderHint> arg1 = gsi::arg_reader<QFlags<QPainter::RenderHint> >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setRenderHints (arg1, arg2);
}


// void QPainter::setTransform(const QTransform &transform, bool combine)


static void _init_f_setTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("transform");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransform_3106 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setTransform (arg1, arg2);
}


// void QPainter::setViewTransformEnabled(bool enable)


static void _init_f_setViewTransformEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewTransformEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setViewTransformEnabled (arg1);
}


// void QPainter::setViewport(const QRect &viewport)


static void _init_f_setViewport_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewport_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setViewport (arg1);
}


// void QPainter::setViewport(int x, int y, int w, int h)


static void _init_f_setViewport_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setViewport_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setViewport (arg1, arg2, arg3, arg4);
}


// void QPainter::setWindow(const QRect &window)


static void _init_f_setWindow_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindow_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setWindow (arg1);
}


// void QPainter::setWindow(int x, int y, int w, int h)


static void _init_f_setWindow_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setWindow_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setWindow (arg1, arg2, arg3, arg4);
}


// void QPainter::setWorldMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setWorldMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWorldMatrix_2779 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMatrix &arg1 = gsi::arg_reader<const QMatrix & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setWorldMatrix (arg1, arg2);
}


// void QPainter::setWorldMatrixEnabled(bool enabled)


static void _init_f_setWorldMatrixEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWorldMatrixEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setWorldMatrixEnabled (arg1);
}


// void QPainter::setWorldTransform(const QTransform &matrix, bool combine)


static void _init_f_setWorldTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWorldTransform_3106 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->setWorldTransform (arg1, arg2);
}


// void QPainter::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->shear (arg1, arg2);
}


// void QPainter::strokePath(const QPainterPath &path, const QPen &pen)


static void _init_f_strokePath_4091 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen");
  decl->add_arg<const QPen & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_strokePath_4091 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const QPen &arg2 = gsi::arg_reader<const QPen & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->strokePath (arg1, arg2);
}


// bool QPainter::testRenderHint(QPainter::RenderHint hint)


static void _init_f_testRenderHint_c2367 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testRenderHint_c2367 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPainter::RenderHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPainter::RenderHint>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QPainter *)cls)->testRenderHint (qt_gsi::QtToCppAdaptor<QPainter::RenderHint>(arg1).cref()));
}


// const QTransform &QPainter::transform()


static void _init_f_transform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTransform & > ();
}

static void _call_f_transform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QTransform & > ((const QTransform &)((QPainter *)cls)->transform ());
}


// void QPainter::translate(const QPointF &offset)


static void _init_f_translate_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->translate (arg1);
}


// void QPainter::translate(const QPoint &offset)


static void _init_f_translate_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->translate (arg1);
}


// void QPainter::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPainter *)cls)->translate (arg1, arg2);
}


// bool QPainter::viewTransformEnabled()


static void _init_f_viewTransformEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_viewTransformEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPainter *)cls)->viewTransformEnabled ());
}


// QRect QPainter::viewport()


static void _init_f_viewport_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_viewport_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPainter *)cls)->viewport ());
}


// QRect QPainter::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPainter *)cls)->window ());
}


// const QMatrix &QPainter::worldMatrix()


static void _init_f_worldMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_worldMatrix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QMatrix & > ((const QMatrix &)((QPainter *)cls)->worldMatrix ());
}


// bool QPainter::worldMatrixEnabled()


static void _init_f_worldMatrixEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_worldMatrixEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPainter *)cls)->worldMatrixEnabled ());
}


// const QTransform &QPainter::worldTransform()


static void _init_f_worldTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTransform & > ();
}

static void _call_f_worldTransform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QTransform & > ((const QTransform &)((QPainter *)cls)->worldTransform ());
}


// static QPaintDevice *QPainter::redirected(const QPaintDevice *device, QPoint *offset)


static void _init_f_redirected_3615 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<QPoint * > (argspec_1);
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_redirected_3615 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPaintDevice *arg1 = gsi::arg_reader<const QPaintDevice * >() (args, heap);
  QPoint *arg2 = args ? gsi::arg_reader<QPoint * >() (args, heap) : gsi::arg_maker<QPoint * >() (0, heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)QPainter::redirected (arg1, arg2));
}


// static void QPainter::restoreRedirected(const QPaintDevice *device)


static void _init_f_restoreRedirected_2498 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_restoreRedirected_2498 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPaintDevice *arg1 = gsi::arg_reader<const QPaintDevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QPainter::restoreRedirected (arg1);
}


// static void QPainter::setRedirected(const QPaintDevice *device, QPaintDevice *replacement, const QPoint &offset)


static void _init_f_setRedirected_6001 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("replacement");
  decl->add_arg<QPaintDevice * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setRedirected_6001 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPaintDevice *arg1 = gsi::arg_reader<const QPaintDevice * >() (args, heap);
  QPaintDevice *arg2 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  const QPoint &arg3 = args ? gsi::arg_reader<const QPoint & >() (args, heap) : gsi::arg_maker<const QPoint & >() (QPoint(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QPainter::setRedirected (arg1, arg2, arg3);
}



namespace gsi
{

static gsi::Methods methods_QPainter () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainter::QPainter()\nThis method creates an object of class QPainter.", &_init_ctor_QPainter_0, &_call_ctor_QPainter_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainter::QPainter(QPaintDevice *)\nThis method creates an object of class QPainter.", &_init_ctor_QPainter_1803, &_call_ctor_QPainter_1803);
  methods += new qt_gsi::GenericMethod (":background", "@brief Method const QBrush &QPainter::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
  methods += new qt_gsi::GenericMethod (":backgroundMode", "@brief Method Qt::BGMode QPainter::backgroundMode()\n", true, &_init_f_backgroundMode_c0, &_call_f_backgroundMode_c0);
  methods += new qt_gsi::GenericMethod ("begin", "@brief Method bool QPainter::begin(QPaintDevice *)\n", false, &_init_f_begin_1803, &_call_f_begin_1803);
  methods += new qt_gsi::GenericMethod ("beginNativePainting", "@brief Method void QPainter::beginNativePainting()\n", false, &_init_f_beginNativePainting_0, &_call_f_beginNativePainting_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QPainter::boundingRect(const QRectF &rect, int flags, const QString &text)\n", false, &_init_f_boundingRect_4438, &_call_f_boundingRect_4438);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRect QPainter::boundingRect(const QRect &rect, int flags, const QString &text)\n", false, &_init_f_boundingRect_4368, &_call_f_boundingRect_4368);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRect QPainter::boundingRect(int x, int y, int w, int h, int flags, const QString &text)\n", false, &_init_f_boundingRect_5320, &_call_f_boundingRect_5320);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QPainter::boundingRect(const QRectF &rect, const QString &text, const QTextOption &o)\n", false, &_init_f_boundingRect_6119, &_call_f_boundingRect_6119);
  methods += new qt_gsi::GenericMethod (":brush", "@brief Method const QBrush &QPainter::brush()\n", true, &_init_f_brush_c0, &_call_f_brush_c0);
  methods += new qt_gsi::GenericMethod (":brushOrigin", "@brief Method QPoint QPainter::brushOrigin()\n", true, &_init_f_brushOrigin_c0, &_call_f_brushOrigin_c0);
  methods += new qt_gsi::GenericMethod ("clipBoundingRect", "@brief Method QRectF QPainter::clipBoundingRect()\n", true, &_init_f_clipBoundingRect_c0, &_call_f_clipBoundingRect_c0);
  methods += new qt_gsi::GenericMethod (":clipPath", "@brief Method QPainterPath QPainter::clipPath()\n", true, &_init_f_clipPath_c0, &_call_f_clipPath_c0);
  methods += new qt_gsi::GenericMethod (":clipRegion", "@brief Method QRegion QPainter::clipRegion()\n", true, &_init_f_clipRegion_c0, &_call_f_clipRegion_c0);
  methods += new qt_gsi::GenericMethod ("combinedMatrix", "@brief Method QMatrix QPainter::combinedMatrix()\n", true, &_init_f_combinedMatrix_c0, &_call_f_combinedMatrix_c0);
  methods += new qt_gsi::GenericMethod ("combinedTransform", "@brief Method QTransform QPainter::combinedTransform()\n", true, &_init_f_combinedTransform_c0, &_call_f_combinedTransform_c0);
  methods += new qt_gsi::GenericMethod (":compositionMode", "@brief Method QPainter::CompositionMode QPainter::compositionMode()\n", true, &_init_f_compositionMode_c0, &_call_f_compositionMode_c0);
  methods += new qt_gsi::GenericMethod ("device", "@brief Method QPaintDevice *QPainter::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
  methods += new qt_gsi::GenericMethod ("deviceMatrix", "@brief Method const QMatrix &QPainter::deviceMatrix()\n", true, &_init_f_deviceMatrix_c0, &_call_f_deviceMatrix_c0);
  methods += new qt_gsi::GenericMethod ("deviceTransform", "@brief Method const QTransform &QPainter::deviceTransform()\n", true, &_init_f_deviceTransform_c0, &_call_f_deviceTransform_c0);
  methods += new qt_gsi::GenericMethod ("drawArc", "@brief Method void QPainter::drawArc(const QRectF &rect, int a, int alen)\n", false, &_init_f_drawArc_3180, &_call_f_drawArc_3180);
  methods += new qt_gsi::GenericMethod ("drawArc", "@brief Method void QPainter::drawArc(const QRect &, int a, int alen)\n", false, &_init_f_drawArc_3110, &_call_f_drawArc_3110);
  methods += new qt_gsi::GenericMethod ("drawArc", "@brief Method void QPainter::drawArc(int x, int y, int w, int h, int a, int alen)\n", false, &_init_f_drawArc_4062, &_call_f_drawArc_4062);
  methods += new qt_gsi::GenericMethod ("drawChord", "@brief Method void QPainter::drawChord(const QRectF &rect, int a, int alen)\n", false, &_init_f_drawChord_3180, &_call_f_drawChord_3180);
  methods += new qt_gsi::GenericMethod ("drawChord", "@brief Method void QPainter::drawChord(int x, int y, int w, int h, int a, int alen)\n", false, &_init_f_drawChord_4062, &_call_f_drawChord_4062);
  methods += new qt_gsi::GenericMethod ("drawChord", "@brief Method void QPainter::drawChord(const QRect &, int a, int alen)\n", false, &_init_f_drawChord_3110, &_call_f_drawChord_3110);
  methods += new qt_gsi::GenericMethod ("drawConvexPolygon", "@brief Method void QPainter::drawConvexPolygon(const QPolygonF &polygon)\n", false, &_init_f_drawConvexPolygon_2208, &_call_f_drawConvexPolygon_2208);
  methods += new qt_gsi::GenericMethod ("drawConvexPolygon", "@brief Method void QPainter::drawConvexPolygon(const QPolygon &polygon)\n", false, &_init_f_drawConvexPolygon_2138, &_call_f_drawConvexPolygon_2138);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QRectF &r)\n", false, &_init_f_drawEllipse_1862, &_call_f_drawEllipse_1862);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QRect &r)\n", false, &_init_f_drawEllipse_1792, &_call_f_drawEllipse_1792);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(int x, int y, int w, int h)\n", false, &_init_f_drawEllipse_2744, &_call_f_drawEllipse_2744);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QPointF &center, double rx, double ry)\n", false, &_init_f_drawEllipse_3912, &_call_f_drawEllipse_3912);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QPoint &center, int rx, int ry)\n", false, &_init_f_drawEllipse_3234, &_call_f_drawEllipse_3234);
  methods += new qt_gsi::GenericMethod ("drawGlyphRun", "@brief Method void QPainter::drawGlyphRun(const QPointF &position, const QGlyphRun &glyphRun)\n", false, &_init_f_drawGlyphRun_4097, &_call_f_drawGlyphRun_4097);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRectF &targetRect, const QImage &image, const QRectF &sourceRect, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8645, &_call_f_drawImage_8645);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRect &targetRect, const QImage &image, const QRect &sourceRect, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8505, &_call_f_drawImage_8505);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPointF &p, const QImage &image, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8769, &_call_f_drawImage_8769);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPoint &p, const QImage &image, const QRect &sr, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8629, &_call_f_drawImage_8629);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRectF &r, const QImage &image)\n", false, &_init_f_drawImage_3631, &_call_f_drawImage_3631);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRect &r, const QImage &image)\n", false, &_init_f_drawImage_3561, &_call_f_drawImage_3561);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPointF &p, const QImage &image)\n", false, &_init_f_drawImage_3755, &_call_f_drawImage_3755);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPoint &p, const QImage &image)\n", false, &_init_f_drawImage_3685, &_call_f_drawImage_3685);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(int x, int y, const QImage &image, int sx, int sy, int sw, int sh, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_9091, &_call_f_drawImage_9091);
  methods += new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QLineF &line)\n", false, &_init_f_drawLine_1856, &_call_f_drawLine_1856);
  methods += new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QLine &line)\n", false, &_init_f_drawLine_1786, &_call_f_drawLine_1786);
  methods += new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(int x1, int y1, int x2, int y2)\n", false, &_init_f_drawLine_2744, &_call_f_drawLine_2744);
  methods += new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QPoint &p1, const QPoint &p2)\n", false, &_init_f_drawLine_3724, &_call_f_drawLine_3724);
  methods += new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QPointF &p1, const QPointF &p2)\n", false, &_init_f_drawLine_3864, &_call_f_drawLine_3864);
  methods += new qt_gsi::GenericMethod ("drawLines_f", "@brief Method void QPainter::drawLines(const QVector<QLineF> &lines)\n", false, &_init_f_drawLines_2686, &_call_f_drawLines_2686);
  methods += new qt_gsi::GenericMethod ("drawLines_fp", "@brief Method void QPainter::drawLines(const QVector<QPointF> &pointPairs)\n", false, &_init_f_drawLines_2816, &_call_f_drawLines_2816);
  methods += new qt_gsi::GenericMethod ("drawLines_i", "@brief Method void QPainter::drawLines(const QVector<QLine> &lines)\n", false, &_init_f_drawLines_2616, &_call_f_drawLines_2616);
  methods += new qt_gsi::GenericMethod ("drawLines_ip", "@brief Method void QPainter::drawLines(const QVector<QPoint> &pointPairs)\n", false, &_init_f_drawLines_2746, &_call_f_drawLines_2746);
  methods += new qt_gsi::GenericMethod ("drawPath", "@brief Method void QPainter::drawPath(const QPainterPath &path)\n", false, &_init_f_drawPath_2514, &_call_f_drawPath_2514);
  methods += new qt_gsi::GenericMethod ("drawPicture", "@brief Method void QPainter::drawPicture(const QPointF &p, const QPicture &picture)\n", false, &_init_f_drawPicture_4004, &_call_f_drawPicture_4004);
  methods += new qt_gsi::GenericMethod ("drawPicture", "@brief Method void QPainter::drawPicture(int x, int y, const QPicture &picture)\n", false, &_init_f_drawPicture_3444, &_call_f_drawPicture_3444);
  methods += new qt_gsi::GenericMethod ("drawPicture", "@brief Method void QPainter::drawPicture(const QPoint &p, const QPicture &picture)\n", false, &_init_f_drawPicture_3934, &_call_f_drawPicture_3934);
  methods += new qt_gsi::GenericMethod ("drawPie", "@brief Method void QPainter::drawPie(const QRectF &rect, int a, int alen)\n", false, &_init_f_drawPie_3180, &_call_f_drawPie_3180);
  methods += new qt_gsi::GenericMethod ("drawPie", "@brief Method void QPainter::drawPie(int x, int y, int w, int h, int a, int alen)\n", false, &_init_f_drawPie_4062, &_call_f_drawPie_4062);
  methods += new qt_gsi::GenericMethod ("drawPie", "@brief Method void QPainter::drawPie(const QRect &, int a, int alen)\n", false, &_init_f_drawPie_3110, &_call_f_drawPie_3110);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QRectF &targetRect, const QPixmap &pixmap, const QRectF &sourceRect)\n", false, &_init_f_drawPixmap_5525, &_call_f_drawPixmap_5525);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QRect &targetRect, const QPixmap &pixmap, const QRect &sourceRect)\n", false, &_init_f_drawPixmap_5385, &_call_f_drawPixmap_5385);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm, int sx, int sy, int sw, int sh)\n", false, &_init_f_drawPixmap_7289, &_call_f_drawPixmap_7289);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, const QPixmap &pm, int sx, int sy, int sw, int sh)\n", false, &_init_f_drawPixmap_5971, &_call_f_drawPixmap_5971);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm, const QRectF &sr)\n", false, &_init_f_drawPixmap_5649, &_call_f_drawPixmap_5649);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm, const QRect &sr)\n", false, &_init_f_drawPixmap_5509, &_call_f_drawPixmap_5509);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3895, &_call_f_drawPixmap_3895);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3825, &_call_f_drawPixmap_3825);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3335, &_call_f_drawPixmap_3335);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QRect &r, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3701, &_call_f_drawPixmap_3701);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm)\n", false, &_init_f_drawPixmap_4653, &_call_f_drawPixmap_4653);
  methods += new qt_gsi::GenericMethod ("drawPixmapFragments", "@brief Method void QPainter::drawPixmapFragments(const QPainter::PixmapFragment *fragments, int fragmentCount, const QPixmap &pixmap, QFlags<QPainter::PixmapFragmentHint> hints)\n", false, &_init_f_drawPixmapFragments_10038, &_call_f_drawPixmapFragments_10038);
  methods += new qt_gsi::GenericMethod ("drawPoint", "@brief Method void QPainter::drawPoint(const QPointF &pt)\n", false, &_init_f_drawPoint_1986, &_call_f_drawPoint_1986);
  methods += new qt_gsi::GenericMethod ("drawPoint", "@brief Method void QPainter::drawPoint(const QPoint &p)\n", false, &_init_f_drawPoint_1916, &_call_f_drawPoint_1916);
  methods += new qt_gsi::GenericMethod ("drawPoint", "@brief Method void QPainter::drawPoint(int x, int y)\n", false, &_init_f_drawPoint_1426, &_call_f_drawPoint_1426);
  methods += new qt_gsi::GenericMethod ("drawPoints", "@brief Method void QPainter::drawPoints(const QPolygonF &points)\n", false, &_init_f_drawPoints_2208, &_call_f_drawPoints_2208);
  methods += new qt_gsi::GenericMethod ("drawPoints", "@brief Method void QPainter::drawPoints(const QPolygon &points)\n", false, &_init_f_drawPoints_2138, &_call_f_drawPoints_2138);
  methods += new qt_gsi::GenericMethod ("drawPolygon", "@brief Method void QPainter::drawPolygon(const QPolygonF &polygon, Qt::FillRule fillRule)\n", false, &_init_f_drawPolygon_3648, &_call_f_drawPolygon_3648);
  methods += new qt_gsi::GenericMethod ("drawPolygon", "@brief Method void QPainter::drawPolygon(const QPolygon &polygon, Qt::FillRule fillRule)\n", false, &_init_f_drawPolygon_3578, &_call_f_drawPolygon_3578);
  methods += new qt_gsi::GenericMethod ("drawPolyline", "@brief Method void QPainter::drawPolyline(const QPolygonF &polyline)\n", false, &_init_f_drawPolyline_2208, &_call_f_drawPolyline_2208);
  methods += new qt_gsi::GenericMethod ("drawPolyline", "@brief Method void QPainter::drawPolyline(const QPolygon &polygon)\n", false, &_init_f_drawPolyline_2138, &_call_f_drawPolyline_2138);
  methods += new qt_gsi::GenericMethod ("drawRect", "@brief Method void QPainter::drawRect(const QRectF &rect)\n", false, &_init_f_drawRect_1862, &_call_f_drawRect_1862);
  methods += new qt_gsi::GenericMethod ("drawRect", "@brief Method void QPainter::drawRect(int x1, int y1, int w, int h)\n", false, &_init_f_drawRect_2744, &_call_f_drawRect_2744);
  methods += new qt_gsi::GenericMethod ("drawRect", "@brief Method void QPainter::drawRect(const QRect &rect)\n", false, &_init_f_drawRect_1792, &_call_f_drawRect_1792);
  methods += new qt_gsi::GenericMethod ("drawRects_f", "@brief Method void QPainter::drawRects(const QVector<QRectF> &rectangles)\n", false, &_init_f_drawRects_2692, &_call_f_drawRects_2692);
  methods += new qt_gsi::GenericMethod ("drawRects_i", "@brief Method void QPainter::drawRects(const QVector<QRect> &rectangles)\n", false, &_init_f_drawRects_2622, &_call_f_drawRects_2622);
  methods += new qt_gsi::GenericMethod ("drawRoundRect", "@brief Method void QPainter::drawRoundRect(const QRectF &r, int xround, int yround)\n", false, &_init_f_drawRoundRect_3180, &_call_f_drawRoundRect_3180);
  methods += new qt_gsi::GenericMethod ("drawRoundRect", "@brief Method void QPainter::drawRoundRect(int x, int y, int w, int h, int, int)\n", false, &_init_f_drawRoundRect_4062, &_call_f_drawRoundRect_4062);
  methods += new qt_gsi::GenericMethod ("drawRoundRect", "@brief Method void QPainter::drawRoundRect(const QRect &r, int xround, int yround)\n", false, &_init_f_drawRoundRect_3110, &_call_f_drawRoundRect_3110);
  methods += new qt_gsi::GenericMethod ("drawRoundedRect", "@brief Method void QPainter::drawRoundedRect(const QRectF &rect, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_drawRoundedRect_5229, &_call_f_drawRoundedRect_5229);
  methods += new qt_gsi::GenericMethod ("drawRoundedRect", "@brief Method void QPainter::drawRoundedRect(int x, int y, int w, int h, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_drawRoundedRect_6111, &_call_f_drawRoundedRect_6111);
  methods += new qt_gsi::GenericMethod ("drawRoundedRect", "@brief Method void QPainter::drawRoundedRect(const QRect &rect, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_drawRoundedRect_5159, &_call_f_drawRoundedRect_5159);
  methods += new qt_gsi::GenericMethod ("drawStaticText", "@brief Method void QPainter::drawStaticText(const QPointF &topLeftPosition, const QStaticText &staticText)\n", false, &_init_f_drawStaticText_4309, &_call_f_drawStaticText_4309);
  methods += new qt_gsi::GenericMethod ("drawStaticText", "@brief Method void QPainter::drawStaticText(const QPoint &topLeftPosition, const QStaticText &staticText)\n", false, &_init_f_drawStaticText_4239, &_call_f_drawStaticText_4239);
  methods += new qt_gsi::GenericMethod ("drawStaticText", "@brief Method void QPainter::drawStaticText(int left, int top, const QStaticText &staticText)\n", false, &_init_f_drawStaticText_3749, &_call_f_drawStaticText_3749);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QPointF &p, const QString &s)\n", false, &_init_f_drawText_3903, &_call_f_drawText_3903);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QPoint &p, const QString &s)\n", false, &_init_f_drawText_3833, &_call_f_drawText_3833);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(int x, int y, const QString &s)\n", false, &_init_f_drawText_3343, &_call_f_drawText_3343);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QPointF &p, const QString &str, int tf, int justificationPadding)\n", false, &_init_f_drawText_5221, &_call_f_drawText_5221);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QRectF &r, int flags, const QString &text, QRectF *br)\n", false, &_init_f_drawText_5501, &_call_f_drawText_5501);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QRect &r, int flags, const QString &text, QRect *br)\n", false, &_init_f_drawText_5361, &_call_f_drawText_5361);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(int x, int y, int w, int h, int flags, const QString &text, QRect *br)\n", false, &_init_f_drawText_6313, &_call_f_drawText_6313);
  methods += new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QRectF &r, const QString &text, const QTextOption &o)\n", false, &_init_f_drawText_6119, &_call_f_drawText_6119);
  methods += new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPainter::drawTextItem(const QPointF &p, const QTextItem &ti)\n", false, &_init_f_drawTextItem_4092, &_call_f_drawTextItem_4092);
  methods += new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPainter::drawTextItem(int x, int y, const QTextItem &ti)\n", false, &_init_f_drawTextItem_3532, &_call_f_drawTextItem_3532);
  methods += new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPainter::drawTextItem(const QPoint &p, const QTextItem &ti)\n", false, &_init_f_drawTextItem_4022, &_call_f_drawTextItem_4022);
  methods += new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPainter::drawTiledPixmap(const QRectF &rect, const QPixmap &pm, const QPointF &offset)\n", false, &_init_f_drawTiledPixmap_5649, &_call_f_drawTiledPixmap_5649);
  methods += new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPainter::drawTiledPixmap(int x, int y, int w, int h, const QPixmap &, int sx, int sy)\n", false, &_init_f_drawTiledPixmap_5971, &_call_f_drawTiledPixmap_5971);
  methods += new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPainter::drawTiledPixmap(const QRect &, const QPixmap &, const QPoint &)\n", false, &_init_f_drawTiledPixmap_5509, &_call_f_drawTiledPixmap_5509);
  methods += new qt_gsi::GenericMethod ("end", "@brief Method bool QPainter::end()\n", false, &_init_f_end_0, &_call_f_end_0);
  methods += new qt_gsi::GenericMethod ("endNativePainting", "@brief Method void QPainter::endNativePainting()\n", false, &_init_f_endNativePainting_0, &_call_f_endNativePainting_0);
  methods += new qt_gsi::GenericMethod ("eraseRect", "@brief Method void QPainter::eraseRect(const QRectF &)\n", false, &_init_f_eraseRect_1862, &_call_f_eraseRect_1862);
  methods += new qt_gsi::GenericMethod ("eraseRect", "@brief Method void QPainter::eraseRect(int x, int y, int w, int h)\n", false, &_init_f_eraseRect_2744, &_call_f_eraseRect_2744);
  methods += new qt_gsi::GenericMethod ("eraseRect", "@brief Method void QPainter::eraseRect(const QRect &)\n", false, &_init_f_eraseRect_1792, &_call_f_eraseRect_1792);
  methods += new qt_gsi::GenericMethod ("fillPath", "@brief Method void QPainter::fillPath(const QPainterPath &path, const QBrush &brush)\n", false, &_init_f_fillPath_4316, &_call_f_fillPath_4316);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &, const QBrush &)\n", false, &_init_f_fillRect_3664, &_call_f_fillRect_3664);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, const QBrush &)\n", false, &_init_f_fillRect_4546, &_call_f_fillRect_4546);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &, const QBrush &)\n", false, &_init_f_fillRect_3594, &_call_f_fillRect_3594);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &, const QColor &color)\n", false, &_init_f_fillRect_3659, &_call_f_fillRect_3659);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, const QColor &color)\n", false, &_init_f_fillRect_4541, &_call_f_fillRect_4541);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &, const QColor &color)\n", false, &_init_f_fillRect_3589, &_call_f_fillRect_3589);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, Qt::GlobalColor c)\n", false, &_init_f_fillRect_4489, &_call_f_fillRect_4489);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &r, Qt::GlobalColor c)\n", false, &_init_f_fillRect_3537, &_call_f_fillRect_3537);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &r, Qt::GlobalColor c)\n", false, &_init_f_fillRect_3607, &_call_f_fillRect_3607);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, Qt::BrushStyle style)\n", false, &_init_f_fillRect_4430, &_call_f_fillRect_4430);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &r, Qt::BrushStyle style)\n", false, &_init_f_fillRect_3478, &_call_f_fillRect_3478);
  methods += new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &r, Qt::BrushStyle style)\n", false, &_init_f_fillRect_3548, &_call_f_fillRect_3548);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method const QFont &QPainter::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod ("fontInfo", "@brief Method QFontInfo QPainter::fontInfo()\n", true, &_init_f_fontInfo_c0, &_call_f_fontInfo_c0);
  methods += new qt_gsi::GenericMethod ("fontMetrics", "@brief Method QFontMetrics QPainter::fontMetrics()\n", true, &_init_f_fontMetrics_c0, &_call_f_fontMetrics_c0);
  methods += new qt_gsi::GenericMethod ("hasClipping|:clipping", "@brief Method bool QPainter::hasClipping()\n", true, &_init_f_hasClipping_c0, &_call_f_hasClipping_c0);
  methods += new qt_gsi::GenericMethod ("initFrom", "@brief Method void QPainter::initFrom(const QPaintDevice *device)\n", false, &_init_f_initFrom_2498, &_call_f_initFrom_2498);
  methods += new qt_gsi::GenericMethod ("isActive?", "@brief Method bool QPainter::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QPainter::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
  methods += new qt_gsi::GenericMethod (":matrix", "@brief Method const QMatrix &QPainter::matrix()\n", true, &_init_f_matrix_c0, &_call_f_matrix_c0);
  methods += new qt_gsi::GenericMethod (":matrixEnabled", "@brief Method bool QPainter::matrixEnabled()\n", true, &_init_f_matrixEnabled_c0, &_call_f_matrixEnabled_c0);
  methods += new qt_gsi::GenericMethod (":opacity", "@brief Method double QPainter::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QPainter::paintEngine()\n", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
  methods += new qt_gsi::GenericMethod ("pen", "@brief Method const QPen &QPainter::pen()\n", true, &_init_f_pen_c0, &_call_f_pen_c0);
  methods += new qt_gsi::GenericMethod (":renderHints", "@brief Method QFlags<QPainter::RenderHint> QPainter::renderHints()\n", true, &_init_f_renderHints_c0, &_call_f_renderHints_c0);
  methods += new qt_gsi::GenericMethod ("resetMatrix", "@brief Method void QPainter::resetMatrix()\n", false, &_init_f_resetMatrix_0, &_call_f_resetMatrix_0);
  methods += new qt_gsi::GenericMethod ("resetTransform", "@brief Method void QPainter::resetTransform()\n", false, &_init_f_resetTransform_0, &_call_f_resetTransform_0);
  methods += new qt_gsi::GenericMethod ("restore", "@brief Method void QPainter::restore()\n", false, &_init_f_restore_0, &_call_f_restore_0);
  methods += new qt_gsi::GenericMethod ("rotate", "@brief Method void QPainter::rotate(double a)\n", false, &_init_f_rotate_1071, &_call_f_rotate_1071);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method void QPainter::save()\n", false, &_init_f_save_0, &_call_f_save_0);
  methods += new qt_gsi::GenericMethod ("scale", "@brief Method void QPainter::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
  methods += new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QPainter::setBackground(const QBrush &bg)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
  methods += new qt_gsi::GenericMethod ("setBackgroundMode|backgroundMode=", "@brief Method void QPainter::setBackgroundMode(Qt::BGMode mode)\n", false, &_init_f_setBackgroundMode_1275, &_call_f_setBackgroundMode_1275);
  methods += new qt_gsi::GenericMethod ("setBrush|brush=", "@brief Method void QPainter::setBrush(const QBrush &brush)\n", false, &_init_f_setBrush_1910, &_call_f_setBrush_1910);
  methods += new qt_gsi::GenericMethod ("setBrush|brush=", "@brief Method void QPainter::setBrush(Qt::BrushStyle style)\n", false, &_init_f_setBrush_1794, &_call_f_setBrush_1794);
  methods += new qt_gsi::GenericMethod ("setBrushOrigin", "@brief Method void QPainter::setBrushOrigin(int x, int y)\n", false, &_init_f_setBrushOrigin_1426, &_call_f_setBrushOrigin_1426);
  methods += new qt_gsi::GenericMethod ("setBrushOrigin|brushOrigin=", "@brief Method void QPainter::setBrushOrigin(const QPoint &)\n", false, &_init_f_setBrushOrigin_1916, &_call_f_setBrushOrigin_1916);
  methods += new qt_gsi::GenericMethod ("setBrushOrigin|brushOrigin=", "@brief Method void QPainter::setBrushOrigin(const QPointF &)\n", false, &_init_f_setBrushOrigin_1986, &_call_f_setBrushOrigin_1986);
  methods += new qt_gsi::GenericMethod ("setClipPath", "@brief Method void QPainter::setClipPath(const QPainterPath &path, Qt::ClipOperation op)\n", false, &_init_f_setClipPath_4492, &_call_f_setClipPath_4492);
  methods += new qt_gsi::GenericMethod ("setClipRect", "@brief Method void QPainter::setClipRect(const QRectF &, Qt::ClipOperation op)\n", false, &_init_f_setClipRect_3840, &_call_f_setClipRect_3840);
  methods += new qt_gsi::GenericMethod ("setClipRect", "@brief Method void QPainter::setClipRect(const QRect &, Qt::ClipOperation op)\n", false, &_init_f_setClipRect_3770, &_call_f_setClipRect_3770);
  methods += new qt_gsi::GenericMethod ("setClipRect", "@brief Method void QPainter::setClipRect(int x, int y, int w, int h, Qt::ClipOperation op)\n", false, &_init_f_setClipRect_4722, &_call_f_setClipRect_4722);
  methods += new qt_gsi::GenericMethod ("setClipRegion", "@brief Method void QPainter::setClipRegion(const QRegion &, Qt::ClipOperation op)\n", false, &_init_f_setClipRegion_3984, &_call_f_setClipRegion_3984);
  methods += new qt_gsi::GenericMethod ("setClipping|clipping=", "@brief Method void QPainter::setClipping(bool enable)\n", false, &_init_f_setClipping_864, &_call_f_setClipping_864);
  methods += new qt_gsi::GenericMethod ("setCompositionMode|compositionMode=", "@brief Method void QPainter::setCompositionMode(QPainter::CompositionMode mode)\n", false, &_init_f_setCompositionMode_2917, &_call_f_setCompositionMode_2917);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QPainter::setFont(const QFont &f)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QPainter::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
  methods += new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QPainter::setMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setMatrix_2779, &_call_f_setMatrix_2779);
  methods += new qt_gsi::GenericMethod ("setMatrixEnabled|matrixEnabled=", "@brief Method void QPainter::setMatrixEnabled(bool enabled)\n", false, &_init_f_setMatrixEnabled_864, &_call_f_setMatrixEnabled_864);
  methods += new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QPainter::setOpacity(double opacity)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
  methods += new qt_gsi::GenericMethod ("setPen", "@brief Method void QPainter::setPen(const QColor &color)\n", false, &_init_f_setPen_1905, &_call_f_setPen_1905);
  methods += new qt_gsi::GenericMethod ("setPen", "@brief Method void QPainter::setPen(const QPen &pen)\n", false, &_init_f_setPen_1685, &_call_f_setPen_1685);
  methods += new qt_gsi::GenericMethod ("setPen", "@brief Method void QPainter::setPen(Qt::PenStyle style)\n", false, &_init_f_setPen_1569, &_call_f_setPen_1569);
  methods += new qt_gsi::GenericMethod ("setRenderHint", "@brief Method void QPainter::setRenderHint(QPainter::RenderHint hint, bool on)\n", false, &_init_f_setRenderHint_3123, &_call_f_setRenderHint_3123);
  methods += new qt_gsi::GenericMethod ("setRenderHints", "@brief Method void QPainter::setRenderHints(QFlags<QPainter::RenderHint> hints, bool on)\n", false, &_init_f_setRenderHints_3819, &_call_f_setRenderHints_3819);
  methods += new qt_gsi::GenericMethod ("setTransform", "@brief Method void QPainter::setTransform(const QTransform &transform, bool combine)\n", false, &_init_f_setTransform_3106, &_call_f_setTransform_3106);
  methods += new qt_gsi::GenericMethod ("setViewTransformEnabled|viewTransformEnabled=", "@brief Method void QPainter::setViewTransformEnabled(bool enable)\n", false, &_init_f_setViewTransformEnabled_864, &_call_f_setViewTransformEnabled_864);
  methods += new qt_gsi::GenericMethod ("setViewport|viewport=", "@brief Method void QPainter::setViewport(const QRect &viewport)\n", false, &_init_f_setViewport_1792, &_call_f_setViewport_1792);
  methods += new qt_gsi::GenericMethod ("setViewport", "@brief Method void QPainter::setViewport(int x, int y, int w, int h)\n", false, &_init_f_setViewport_2744, &_call_f_setViewport_2744);
  methods += new qt_gsi::GenericMethod ("setWindow|window=", "@brief Method void QPainter::setWindow(const QRect &window)\n", false, &_init_f_setWindow_1792, &_call_f_setWindow_1792);
  methods += new qt_gsi::GenericMethod ("setWindow", "@brief Method void QPainter::setWindow(int x, int y, int w, int h)\n", false, &_init_f_setWindow_2744, &_call_f_setWindow_2744);
  methods += new qt_gsi::GenericMethod ("setWorldMatrix", "@brief Method void QPainter::setWorldMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setWorldMatrix_2779, &_call_f_setWorldMatrix_2779);
  methods += new qt_gsi::GenericMethod ("setWorldMatrixEnabled|worldMatrixEnabled=", "@brief Method void QPainter::setWorldMatrixEnabled(bool enabled)\n", false, &_init_f_setWorldMatrixEnabled_864, &_call_f_setWorldMatrixEnabled_864);
  methods += new qt_gsi::GenericMethod ("setWorldTransform", "@brief Method void QPainter::setWorldTransform(const QTransform &matrix, bool combine)\n", false, &_init_f_setWorldTransform_3106, &_call_f_setWorldTransform_3106);
  methods += new qt_gsi::GenericMethod ("shear", "@brief Method void QPainter::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
  methods += new qt_gsi::GenericMethod ("strokePath", "@brief Method void QPainter::strokePath(const QPainterPath &path, const QPen &pen)\n", false, &_init_f_strokePath_4091, &_call_f_strokePath_4091);
  methods += new qt_gsi::GenericMethod ("testRenderHint", "@brief Method bool QPainter::testRenderHint(QPainter::RenderHint hint)\n", true, &_init_f_testRenderHint_c2367, &_call_f_testRenderHint_c2367);
  methods += new qt_gsi::GenericMethod (":transform", "@brief Method const QTransform &QPainter::transform()\n", true, &_init_f_transform_c0, &_call_f_transform_c0);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QPainter::translate(const QPointF &offset)\n", false, &_init_f_translate_1986, &_call_f_translate_1986);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QPainter::translate(const QPoint &offset)\n", false, &_init_f_translate_1916, &_call_f_translate_1916);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QPainter::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
  methods += new qt_gsi::GenericMethod (":viewTransformEnabled", "@brief Method bool QPainter::viewTransformEnabled()\n", true, &_init_f_viewTransformEnabled_c0, &_call_f_viewTransformEnabled_c0);
  methods += new qt_gsi::GenericMethod (":viewport", "@brief Method QRect QPainter::viewport()\n", true, &_init_f_viewport_c0, &_call_f_viewport_c0);
  methods += new qt_gsi::GenericMethod (":window", "@brief Method QRect QPainter::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
  methods += new qt_gsi::GenericMethod (":worldMatrix", "@brief Method const QMatrix &QPainter::worldMatrix()\n", true, &_init_f_worldMatrix_c0, &_call_f_worldMatrix_c0);
  methods += new qt_gsi::GenericMethod (":worldMatrixEnabled", "@brief Method bool QPainter::worldMatrixEnabled()\n", true, &_init_f_worldMatrixEnabled_c0, &_call_f_worldMatrixEnabled_c0);
  methods += new qt_gsi::GenericMethod (":worldTransform", "@brief Method const QTransform &QPainter::worldTransform()\n", true, &_init_f_worldTransform_c0, &_call_f_worldTransform_c0);
  methods += new qt_gsi::GenericStaticMethod ("redirected", "@brief Static method QPaintDevice *QPainter::redirected(const QPaintDevice *device, QPoint *offset)\nThis method is static and can be called without an instance.", &_init_f_redirected_3615, &_call_f_redirected_3615);
  methods += new qt_gsi::GenericStaticMethod ("restoreRedirected", "@brief Static method void QPainter::restoreRedirected(const QPaintDevice *device)\nThis method is static and can be called without an instance.", &_init_f_restoreRedirected_2498, &_call_f_restoreRedirected_2498);
  methods += new qt_gsi::GenericStaticMethod ("setRedirected", "@brief Static method void QPainter::setRedirected(const QPaintDevice *device, QPaintDevice *replacement, const QPoint &offset)\nThis method is static and can be called without an instance.", &_init_f_setRedirected_6001, &_call_f_setRedirected_6001);
  return methods;
}

gsi::Class<QPainter> decl_QPainter ("QtGui", "QPainter",
  methods_QPainter (),
  "@qt\n@brief Binding of QPainter");


GSI_QTGUI_PUBLIC gsi::Class<QPainter> &qtdecl_QPainter () { return decl_QPainter; }

}


//  Implementation of the enum wrapper class for QPainter::CompositionMode
namespace qt_gsi
{

static gsi::Enum<QPainter::CompositionMode> decl_QPainter_CompositionMode_Enum ("QtGui", "QPainter_CompositionMode",
    gsi::enum_const ("CompositionMode_SourceOver", QPainter::CompositionMode_SourceOver, "@brief Enum constant QPainter::CompositionMode_SourceOver") +
    gsi::enum_const ("CompositionMode_DestinationOver", QPainter::CompositionMode_DestinationOver, "@brief Enum constant QPainter::CompositionMode_DestinationOver") +
    gsi::enum_const ("CompositionMode_Clear", QPainter::CompositionMode_Clear, "@brief Enum constant QPainter::CompositionMode_Clear") +
    gsi::enum_const ("CompositionMode_Source", QPainter::CompositionMode_Source, "@brief Enum constant QPainter::CompositionMode_Source") +
    gsi::enum_const ("CompositionMode_Destination", QPainter::CompositionMode_Destination, "@brief Enum constant QPainter::CompositionMode_Destination") +
    gsi::enum_const ("CompositionMode_SourceIn", QPainter::CompositionMode_SourceIn, "@brief Enum constant QPainter::CompositionMode_SourceIn") +
    gsi::enum_const ("CompositionMode_DestinationIn", QPainter::CompositionMode_DestinationIn, "@brief Enum constant QPainter::CompositionMode_DestinationIn") +
    gsi::enum_const ("CompositionMode_SourceOut", QPainter::CompositionMode_SourceOut, "@brief Enum constant QPainter::CompositionMode_SourceOut") +
    gsi::enum_const ("CompositionMode_DestinationOut", QPainter::CompositionMode_DestinationOut, "@brief Enum constant QPainter::CompositionMode_DestinationOut") +
    gsi::enum_const ("CompositionMode_SourceAtop", QPainter::CompositionMode_SourceAtop, "@brief Enum constant QPainter::CompositionMode_SourceAtop") +
    gsi::enum_const ("CompositionMode_DestinationAtop", QPainter::CompositionMode_DestinationAtop, "@brief Enum constant QPainter::CompositionMode_DestinationAtop") +
    gsi::enum_const ("CompositionMode_Xor", QPainter::CompositionMode_Xor, "@brief Enum constant QPainter::CompositionMode_Xor") +
    gsi::enum_const ("CompositionMode_Plus", QPainter::CompositionMode_Plus, "@brief Enum constant QPainter::CompositionMode_Plus") +
    gsi::enum_const ("CompositionMode_Multiply", QPainter::CompositionMode_Multiply, "@brief Enum constant QPainter::CompositionMode_Multiply") +
    gsi::enum_const ("CompositionMode_Screen", QPainter::CompositionMode_Screen, "@brief Enum constant QPainter::CompositionMode_Screen") +
    gsi::enum_const ("CompositionMode_Overlay", QPainter::CompositionMode_Overlay, "@brief Enum constant QPainter::CompositionMode_Overlay") +
    gsi::enum_const ("CompositionMode_Darken", QPainter::CompositionMode_Darken, "@brief Enum constant QPainter::CompositionMode_Darken") +
    gsi::enum_const ("CompositionMode_Lighten", QPainter::CompositionMode_Lighten, "@brief Enum constant QPainter::CompositionMode_Lighten") +
    gsi::enum_const ("CompositionMode_ColorDodge", QPainter::CompositionMode_ColorDodge, "@brief Enum constant QPainter::CompositionMode_ColorDodge") +
    gsi::enum_const ("CompositionMode_ColorBurn", QPainter::CompositionMode_ColorBurn, "@brief Enum constant QPainter::CompositionMode_ColorBurn") +
    gsi::enum_const ("CompositionMode_HardLight", QPainter::CompositionMode_HardLight, "@brief Enum constant QPainter::CompositionMode_HardLight") +
    gsi::enum_const ("CompositionMode_SoftLight", QPainter::CompositionMode_SoftLight, "@brief Enum constant QPainter::CompositionMode_SoftLight") +
    gsi::enum_const ("CompositionMode_Difference", QPainter::CompositionMode_Difference, "@brief Enum constant QPainter::CompositionMode_Difference") +
    gsi::enum_const ("CompositionMode_Exclusion", QPainter::CompositionMode_Exclusion, "@brief Enum constant QPainter::CompositionMode_Exclusion") +
    gsi::enum_const ("RasterOp_SourceOrDestination", QPainter::RasterOp_SourceOrDestination, "@brief Enum constant QPainter::RasterOp_SourceOrDestination") +
    gsi::enum_const ("RasterOp_SourceAndDestination", QPainter::RasterOp_SourceAndDestination, "@brief Enum constant QPainter::RasterOp_SourceAndDestination") +
    gsi::enum_const ("RasterOp_SourceXorDestination", QPainter::RasterOp_SourceXorDestination, "@brief Enum constant QPainter::RasterOp_SourceXorDestination") +
    gsi::enum_const ("RasterOp_NotSourceAndNotDestination", QPainter::RasterOp_NotSourceAndNotDestination, "@brief Enum constant QPainter::RasterOp_NotSourceAndNotDestination") +
    gsi::enum_const ("RasterOp_NotSourceOrNotDestination", QPainter::RasterOp_NotSourceOrNotDestination, "@brief Enum constant QPainter::RasterOp_NotSourceOrNotDestination") +
    gsi::enum_const ("RasterOp_NotSourceXorDestination", QPainter::RasterOp_NotSourceXorDestination, "@brief Enum constant QPainter::RasterOp_NotSourceXorDestination") +
    gsi::enum_const ("RasterOp_NotSource", QPainter::RasterOp_NotSource, "@brief Enum constant QPainter::RasterOp_NotSource") +
    gsi::enum_const ("RasterOp_NotSourceAndDestination", QPainter::RasterOp_NotSourceAndDestination, "@brief Enum constant QPainter::RasterOp_NotSourceAndDestination") +
    gsi::enum_const ("RasterOp_SourceAndNotDestination", QPainter::RasterOp_SourceAndNotDestination, "@brief Enum constant QPainter::RasterOp_SourceAndNotDestination") +
    gsi::enum_const ("RasterOp_NotSourceOrDestination", QPainter::RasterOp_NotSourceOrDestination, "@brief Enum constant QPainter::RasterOp_NotSourceOrDestination") +
    gsi::enum_const ("RasterOp_SourceOrNotDestination", QPainter::RasterOp_SourceOrNotDestination, "@brief Enum constant QPainter::RasterOp_SourceOrNotDestination") +
    gsi::enum_const ("RasterOp_ClearDestination", QPainter::RasterOp_ClearDestination, "@brief Enum constant QPainter::RasterOp_ClearDestination") +
    gsi::enum_const ("RasterOp_SetDestination", QPainter::RasterOp_SetDestination, "@brief Enum constant QPainter::RasterOp_SetDestination") +
    gsi::enum_const ("RasterOp_NotDestination", QPainter::RasterOp_NotDestination, "@brief Enum constant QPainter::RasterOp_NotDestination"),
  "@qt\n@brief This class represents the QPainter::CompositionMode enum");

static gsi::QFlagsClass<QPainter::CompositionMode > decl_QPainter_CompositionMode_Enums ("QtGui", "QPainter_QFlags_CompositionMode",
  "@qt\n@brief This class represents the QFlags<QPainter::CompositionMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPainter> inject_QPainter_CompositionMode_Enum_in_parent (decl_QPainter_CompositionMode_Enum.defs ());
static gsi::ClassExt<QPainter> decl_QPainter_CompositionMode_Enum_as_child (decl_QPainter_CompositionMode_Enum, "CompositionMode");
static gsi::ClassExt<QPainter> decl_QPainter_CompositionMode_Enums_as_child (decl_QPainter_CompositionMode_Enums, "QFlags_CompositionMode");

}


//  Implementation of the enum wrapper class for QPainter::PixmapFragmentHint
namespace qt_gsi
{

static gsi::Enum<QPainter::PixmapFragmentHint> decl_QPainter_PixmapFragmentHint_Enum ("QtGui", "QPainter_PixmapFragmentHint",
    gsi::enum_const ("OpaqueHint", QPainter::OpaqueHint, "@brief Enum constant QPainter::OpaqueHint"),
  "@qt\n@brief This class represents the QPainter::PixmapFragmentHint enum");

static gsi::QFlagsClass<QPainter::PixmapFragmentHint > decl_QPainter_PixmapFragmentHint_Enums ("QtGui", "QPainter_QFlags_PixmapFragmentHint",
  "@qt\n@brief This class represents the QFlags<QPainter::PixmapFragmentHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPainter> inject_QPainter_PixmapFragmentHint_Enum_in_parent (decl_QPainter_PixmapFragmentHint_Enum.defs ());
static gsi::ClassExt<QPainter> decl_QPainter_PixmapFragmentHint_Enum_as_child (decl_QPainter_PixmapFragmentHint_Enum, "PixmapFragmentHint");
static gsi::ClassExt<QPainter> decl_QPainter_PixmapFragmentHint_Enums_as_child (decl_QPainter_PixmapFragmentHint_Enums, "QFlags_PixmapFragmentHint");

}


//  Implementation of the enum wrapper class for QPainter::RenderHint
namespace qt_gsi
{

static gsi::Enum<QPainter::RenderHint> decl_QPainter_RenderHint_Enum ("QtGui", "QPainter_RenderHint",
    gsi::enum_const ("Antialiasing", QPainter::Antialiasing, "@brief Enum constant QPainter::Antialiasing") +
    gsi::enum_const ("TextAntialiasing", QPainter::TextAntialiasing, "@brief Enum constant QPainter::TextAntialiasing") +
    gsi::enum_const ("SmoothPixmapTransform", QPainter::SmoothPixmapTransform, "@brief Enum constant QPainter::SmoothPixmapTransform") +
    gsi::enum_const ("HighQualityAntialiasing", QPainter::HighQualityAntialiasing, "@brief Enum constant QPainter::HighQualityAntialiasing") +
    gsi::enum_const ("NonCosmeticDefaultPen", QPainter::NonCosmeticDefaultPen, "@brief Enum constant QPainter::NonCosmeticDefaultPen") +
    gsi::enum_const ("Qt4CompatiblePainting", QPainter::Qt4CompatiblePainting, "@brief Enum constant QPainter::Qt4CompatiblePainting"),
  "@qt\n@brief This class represents the QPainter::RenderHint enum");

static gsi::QFlagsClass<QPainter::RenderHint > decl_QPainter_RenderHint_Enums ("QtGui", "QPainter_QFlags_RenderHint",
  "@qt\n@brief This class represents the QFlags<QPainter::RenderHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPainter> inject_QPainter_RenderHint_Enum_in_parent (decl_QPainter_RenderHint_Enum.defs ());
static gsi::ClassExt<QPainter> decl_QPainter_RenderHint_Enum_as_child (decl_QPainter_RenderHint_Enum, "RenderHint");
static gsi::ClassExt<QPainter> decl_QPainter_RenderHint_Enums_as_child (decl_QPainter_RenderHint_Enums, "QFlags_RenderHint");

}

