/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_UI_EXTRA_HEADER
#define LIFEOGRAPH_UI_EXTRA_HEADER


#include <gtkmm.h>

#include "diarydata.hpp"
#include "widgets/widget_calendar.hpp"
#include "widgets/widget_filter.hpp"
#include "widgets/widget_chart.hpp"
#include "widgets/widget_table.hpp"
#include "widgets/widget_picker.hpp"
#include "widgets/widget_textviewsearch.hpp"
#include "widgets/widget_textviewtheme.hpp"


namespace LIFEO
{

// FORWARD DECLARATION OF THE MAP WIDGET (to keep its problems in its own module)
class WidgetMap;

// PANEL OF EXTRA ITEMS
class UIExtra
{
    public:
                                    UIExtra();

        void                        handle_login();
        void                        handle_edit_enabled();
        void                        handle_logout();

        void                        set_view( const Ustring& );
        void                        set_entry( Entry * );

        void                        refresh_active_panel();
        void                        refresh_after_sync();

        // CALENDAR VIEW
        void                        update_calendar();
        void                        show_date_in_cal( date_t );
        date_t                      get_selected_date()
        { return m_W_calendar->get_selected_date(); }

        // SEARCH VIEW
        void                        do_search(); // temporarily public
        void                        remove_entry_from_search( Entry* );
        void                        update_search_for_active_entry();
        void                        go_to_match_at( int );
        void                        replace_match( Match& );
        void                        replace_match_cur();
        void                        replace_all_matches();

        // FILTER VIEW
        void                        set_active_filter( const Ustring& );
        void                        add_new_filter();
        void                        dismiss_filter( const Ustring& );
        void                        handle_filter_selected( const Ustring& );
        bool                        handle_filter_renamed( const Ustring& );
        void                        handle_filter_edited();
        void                        update_all_entries_filter_status();
        bool                        update_entry_filter_status( Entry* );
        WidgetFilter*               get_W_filter()
        { return m_W_filter; }

        // CHART VIEW
        void                        set_active_chart( const Ustring& );
        void                        add_new_chart();
        void                        dismiss_chart( const Ustring& );
        void                        handle_chart_selected( const Ustring& );
        bool                        handle_chart_renamed( const Ustring& );
        void                        handle_chart_edited();
        void                        refresh_chart();

        // TABLE VIEW
        void                        set_active_table( const Ustring& );
        void                        add_new_table();
        void                        dismiss_table( const Ustring& );
        void                        handle_table_selected( const Ustring& );
        bool                        handle_table_renamed( const Ustring& );
        void                        handle_table_edited();
        void                        refresh_table();

        // THEME VIEW
        void                        update_theme_list();
        void                        edit_theme();
        void                        assign_theme();
        void                        assign_theme_to_sel();

        void                        handle_theme_name_changed();
        bool                        handle_theme_click( GdkEventButton*, int );

        // MAP VIEW
        WidgetMap*                  get_W_map()
        { return m_W_map; }

    protected:
        // COMMON
        void                        handle_active_child_changed();
        int                         set_diary_view_cur( const std::string& );

        // CALENDAR VIEW
        void                        handle_calendar_day_selected( date_t );
        void                        add_new_chapter_ctg();
        void                        handle_chapter_ctg_selected( const Ustring& );
        bool                        handle_chapter_ctg_renamed( const Ustring& );
        void                        dismiss_chapter_ctg( const Ustring& );

        // FILTER VIEW
        void                        apply_filter();
        void                        revert_filter();

        // THEME VIEW
        void                        set_TvD_cur_from_FBxCh( Gtk::FlowBoxChild* );
        void                        reset_theme_to_default();
        void                        duplicate_theme();
        void                        dismiss_theme();
        void                        make_theme_default();

        // COMMON OBJECTS
        Gtk::Box*                   m_Bx_panel;
        Gtk::Stack*                 m_St_view;
        Gtk::Popover*               m_Po_extra_view; // popover in the headerbar

        // CALENDAR VIEW
        WidgetCalendar*             m_W_calendar;
        WidgetPicker< CategoryChapters >*   m_WP_chapter_ctg;

        // SEARCH VIEW
        Gtk::SearchEntry*           m_E_search;
        Gtk::ToggleButton*          m_TB_search_in_filtered;
        Gtk::Box*                   m_Bx_replace;
        // for some reason Glade cannot save a Listbox in a ScrolledWindow
        EntryClear*                 m_E_replace;
        Gtk::Button*                m_B_replace_all;
        TextviewDiarySearch*        m_TvD_search;

        int                         m_match_count{ 0 };
        int                         m_index_match_cur{ -1 };

        // FILTER VIEW
        WidgetPicker< Filter >*     m_WP_filter;
        Gtk::Button*                m_B_filter_apply;
        Gtk::Button*                m_B_filter_revert;
        Gtk::Label*                 m_L_filter_result;
        WidgetFilter*               m_W_filter;

        // CHART VIEW
        WidgetPicker< ChartElem >*  m_WP_chart;
        WidgetChart*                m_W_chart;

        // TABLE VIEW
        WidgetPicker< TableElem >*  m_WP_table;
        WidgetTable*                m_W_table;

        // THEME VIEW
        Gtk::Stack*                 m_St_themes;
        Gtk::FlowBox*               m_FBx_themes;
        TextviewDiaryTheme*         m_p2TvD_theme_prvw;
        TextviewDiaryTheme*         m_TVD_theme_edit;
        Gtk::Popover*               m_Po_theme{ nullptr };
        Gtk::Entry*                 m_E_theme_name;
        Gtk::ModelButton*           m_MoB_theme_dismiss;
        Gtk::ModelButton*           m_MoB_theme_make_dflt;
        Gtk::ModelButton*           m_MoB_theme_to_sel;

        // MAP VIEW
        Gtk::Box*                   m_Bx_map;
        WidgetMap*                  m_W_map;

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif

