; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=amdgcn-amd-amdhsa -aa-pipeline=basic-aa,scoped-noalias-aa -passes=load-store-vectorizer -S -o - %s | FileCheck -check-prefix=SCOPE %s
; RUN: opt -mtriple=amdgcn-amd-amdhsa -aa-pipeline=basic-aa -passes=load-store-vectorizer -S -o - %s | FileCheck -check-prefix=NOSCOPE %s

target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5"

; This fails to vectorize if the !alias.scope is not used

define amdgpu_kernel void @vectorize_alias_scope(ptr addrspace(1) nocapture %a, ptr addrspace(1) nocapture %b, ptr addrspace(1) nocapture readonly %c) #0 {
; SCOPE-LABEL: @vectorize_alias_scope(
; SCOPE-NEXT:  entry:
; SCOPE-NEXT:    [[LD_C:%.*]] = load float, ptr addrspace(1) [[C:%.*]], align 4, !alias.scope !0
; SCOPE-NEXT:    store <2 x float> zeroinitializer, ptr addrspace(1) [[A:%.*]], align 4, !noalias !0
; SCOPE-NEXT:    store float [[LD_C]], ptr addrspace(1) [[B:%.*]], align 4, !noalias !0
; SCOPE-NEXT:    ret void
;
; NOSCOPE-LABEL: @vectorize_alias_scope(
; NOSCOPE-NEXT:  entry:
; NOSCOPE-NEXT:    [[A_IDX_1:%.*]] = getelementptr inbounds float, ptr addrspace(1) [[A:%.*]], i64 1
; NOSCOPE-NEXT:    store float 0.000000e+00, ptr addrspace(1) [[A]], align 4, !noalias !0
; NOSCOPE-NEXT:    [[LD_C:%.*]] = load float, ptr addrspace(1) [[C:%.*]], align 4, !alias.scope !0
; NOSCOPE-NEXT:    store float 0.000000e+00, ptr addrspace(1) [[A_IDX_1]], align 4, !noalias !0
; NOSCOPE-NEXT:    store float [[LD_C]], ptr addrspace(1) [[B:%.*]], align 4, !noalias !0
; NOSCOPE-NEXT:    ret void
;
entry:
  %a.idx.1 = getelementptr inbounds float, ptr addrspace(1) %a, i64 1
  store float 0.0, ptr addrspace(1) %a, align 4, !noalias !0
  %ld.c = load float, ptr addrspace(1) %c, align 4, !alias.scope !0
  store float 0.0, ptr addrspace(1) %a.idx.1, align 4, !noalias !0
  store float %ld.c, ptr addrspace(1) %b, align 4, !noalias !0
  ret void
}

attributes #0 = { nounwind }

!0 = !{!1}
!1 = distinct !{!1, !2, !"some scope"}
!2 = distinct !{!2, !"some domain"}
