/*
 * Copyright (c) 2002-2011 LWJGL Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * * Neither the name of 'LWJGL' nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.lwjgl.opengl;

import org.lwjgl.util.generator.opengl.GLbitfield;
import org.lwjgl.util.generator.opengl.GLenum;
import org.lwjgl.util.generator.opengl.GLsizei;
import org.lwjgl.util.generator.opengl.GLuint;

public interface AMD_sparse_texture {

	/** Accepted by the &lt;flags&gt; parameter to TexStorageSparseAMD and TextureStorageSparseAMD: */
	int GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001;

	/** Accepted by the &lt;pname&gt; parameter to GetInternalformativ: */
	int GL_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195,
		GL_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196,
		GL_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197;

	/**
	 * Accepted by the &lt;pname&gt; parameter to GetIntegerv, GetFloatv, GetDoublev,
	 * GetInteger64v, and GetBooleanv:
	 */
	int GL_MAX_SPARSE_TEXTURE_SIZE_AMD     = 0x9198,
		GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD  = 0x9199,
		GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A;

	/** Accepted by the &lt;pname&gt; parameter of GetTexParameter{if}v: */
	int GL_MIN_SPARSE_LEVEL_AMD = 0x919B;

	/**
	 * Accepted by the &lt;pname&gt; parameter of TexParameter{if}{v} and
	 * GetTexParameter{if}v:
	 */
	int GL_MIN_LOD_WARNING_AMD = 0x919C;

	void glTexStorageSparseAMD(@GLenum int target,
	                           @GLenum int internalFormat,
	                           @GLsizei int width,
	                           @GLsizei int height,
	                           @GLsizei int depth,
	                           @GLsizei int layers,
	                           @GLbitfield int flags);

	void glTextureStorageSparseAMD(@GLuint int texture,
	                               @GLenum int target,
	                               @GLenum int internalFormat,
	                               @GLsizei int width,
	                               @GLsizei int height,
	                               @GLsizei int depth,
	                               @GLsizei int layers,
	                               @GLbitfield int flags);

}