package de.intarsys.tools.functor;

import de.intarsys.tools.event.RequestEvent;
import de.intarsys.tools.event.IRequestEvent;
import de.intarsys.tools.facade.FacadeTools;
import de.intarsys.tools.reflect.ObjectCreationException;

public class EventFunctorCallFactory implements IFunctorCallFactory {

	public IFunctorCall createFunctorCall(IFunctor functor, Object receiver,
			IArgs args) throws ObjectCreationException {
		RequestEvent event = new RequestEvent(receiver);
		event.setTarget(args.get("event.target"));
		event.setArgs(args);
		args.put(IRequestEvent.ARG_EVENT, FacadeTools.createFacade(event));
		args.put(IRequestEvent.ARG_JEVENT, event);
		return new FunctorCall(receiver, args);
	}

}
