/* ----- core/wforcesntrup953, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_wforcesntrup953_checksums[] = {
  "ccfc516d2d46a821fcebf8b326f81f90c54b1c6bdd795357022e77590a30c0ef",
  "22397d2cdd1652713cd69cc70fa941ccff3877d4ed5012fbce791261f740252b",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_wforcesntrup953_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_wforcesntrup953_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_wforcesntrup953_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_wforcesntrup953_CONSTBYTES

static void *storage_core_wforcesntrup953_h;
static unsigned char *test_core_wforcesntrup953_h;
static void *storage_core_wforcesntrup953_n;
static unsigned char *test_core_wforcesntrup953_n;
static void *storage_core_wforcesntrup953_k;
static unsigned char *test_core_wforcesntrup953_k;
static void *storage_core_wforcesntrup953_c;
static unsigned char *test_core_wforcesntrup953_c;
static void *storage_core_wforcesntrup953_h2;
static unsigned char *test_core_wforcesntrup953_h2;
static void *storage_core_wforcesntrup953_n2;
static unsigned char *test_core_wforcesntrup953_n2;
static void *storage_core_wforcesntrup953_k2;
static unsigned char *test_core_wforcesntrup953_k2;
static void *storage_core_wforcesntrup953_c2;
static unsigned char *test_core_wforcesntrup953_c2;

#define precomputed_core_wforcesntrup953_NUM 9

static const unsigned char precomputed_core_wforcesntrup953_h[precomputed_core_wforcesntrup953_NUM][crypto_core_OUTPUTBYTES] = {
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {0,1,255,0,0,0,1,255,0,0,0,0,0,1,1,0,0,1,0,0,255,255,255,1,0,0,255,0,0,0,1,1,0,1,0,0,255,255,0,0,255,0,0,0,0,255,255,255,0,255,0,1,0,255,1,0,0,1,1,1,0,255,0,0,255,1,0,255,1,0,0,0,0,255,0,0,0,1,0,255,0,255,0,0,0,255,1,0,0,0,1,1,0,0,255,1,1,0,1,0,255,255,1,0,1,1,0,255,0,255,0,255,0,0,0,0,255,255,0,0,0,0,1,255,0,0,0,1,0,0,255,255,0,255,0,0,255,0,255,0,1,0,0,0,1,0,0,0,1,0,1,0,0,255,1,1,1,0,0,255,0,255,1,0,0,0,0,0,0,1,0,1,255,0,0,1,0,255,0,1,0,1,0,0,0,255,0,0,0,1,0,0,0,0,0,1,0,255,0,0,0,0,0,255,0,0,255,255,255,0,0,0,0,255,0,1,1,1,255,0,1,1,255,0,0,1,0,1,255,255,255,0,0,1,1,0,0,255,0,255,0,1,0,0,0,0,0,255,1,0,1,255,0,0,1,0,255,0,1,0,1,0,0,0,255,0,1,255,0,0,255,0,0,0,0,255,1,0,255,0,1,255,0,0,0,0,0,1,0,0,0,1,0,0,0,255,255,0,1,0,255,255,255,1,0,0,0,0,0,0,255,0,1,0,1,0,0,1,1,1,255,0,0,255,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,255,0,0,255,255,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,255,1,1,255,1,0,1,0,0,0,1,0,255,0,0,1,255,0,0,255,0,0,0,0,0,0,0,1,255,1,0,0,0,1,0,255,0,0,0,1,255,255,1,0,255,255,0,255,0,0,255,0,255,255,0,1,1,0,0,0,0,255,255,0,0,1,0,255,0,0,0,1,0,255,0,255,0,1,255,0,255,0,0,0,0,255,0,0,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,255,0,0,1,0,255,1,1,0,0,255,1,255,1,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,255,0,255,255,255,0,0,0,0,0,0,255,0,0,0,0,255,0,1,0,255,255,255,0,1,0,0,255,0,1,0,0,0,1,255,255,0,0,0,0,0,0,255,1,1,1,0,0,0,1,1,1,0,1,255,255,1,0,0,1,0,255,0,0,1,0,255,1,0,0,255,1,0,0,255,0,0,1,0,0,255,1,0,1,0,1,255,0,0,255,0,0,0,0,1,0,1,0,0,0,255,0,255,0,255,1,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,1,0,1,0,1,1,0,0,0,0,0,255,0,1,0,255,0,0,1,0,0,0,0,0,0,255,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,255,0,1,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,255,255,0,0,0,0,1,255,0,0,0,0,0,255,255,0,255,0,0,255,0,0,255,0,0,0,0,0,1,255,1,255,1,0,255,0,1,255,255,0,0,1,255,0,255,0,1,0,0,255,255,255,0,0,1,1,0,255,1,0,1,0,0,0,0,0,0,255,0,0,0,0,255,255,255,1,1,0,0,1,255,0,255,0,255,255,0,1,0,0,255,255,1,255,255,0,255,1,255,255,0,0,0,0,0,0,0,0,0,0,1,255,0,255,0,1,1,0,1,255,0,255,0,0,0,0,0,0,0,255,1,0,1,1,0,255,255,0,255,1,255,1,0,0,1,255,0,255,0,1,0,1,0,0,0,0,0,255,1,0,1,0,1,0,255,1,1,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0,0,1,1,0,1,0,1,255,1,255,255,0,0,255,0,0,1,0,0,0,255,255,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,255,0,1,0,1,0,255,0,0,1,255,0,0,0,0,255,0,255,0,0,0,255,0,0,255,255,0,1,0,0,0,0,1},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_wforcesntrup953_n[precomputed_core_wforcesntrup953_NUM][crypto_core_INPUTBYTES] = {
  {249,204,130,119,235,59,90,248,201,175,136,65,118,11,33,192,236,81,168,210,127,216,14,176,33,152,69,129,216,34,154,69,104,31,125,54,104,208,43,209,70,46,183,59,205,221,99,206,191,168,169,243,4,57,178,31,255,218,125,21,234,108,12,93,43,80,246,69,109,106,141,215,42,64,103,207,81,198,56,183,70,191,141,79,179,36,191,223,21,177,25,27,145,204,255,199,197,94,158,230,222,237,211,21,178,51,199,252,215,147,111,37,173,15,248,110,43,128,70,40,219,84,33,235,7,214,85,126,224,176,218,198,18,116,247,49,127,245,67,108,219,2,245,56,101,216,229,105,162,1,155,240,67,127,54,178,139,74,113,119,84,21,223,57,173,252,162,245,175,219,127,150,99,94,218,255,199,235,45,20,139,89,31,151,175,8,22,24,68,94,178,175,220,223,187,177,138,84,146,183,195,206,218,81,138,80,243,102,163,204,136,130,4,147,10,85,184,24,169,0,19,227,5,174,68,48,71,250,150,51,34,47,201,98,10,11,39,169,203,234,170,105,101,82,244,27,80,221,39,70,165,190,101,240,39,252,63,20,69,83,103,233,153,44,86,6,33,19,13,75,89,119,201,190,185,67,23,95,68,174,34,222,234,170,204,174,12,162,52,206,232,254,56,176,205,48,162,51,85,13,17,141,244,156,212,154,223,92,182,218,51,25,160,1,120,252,16,120,196,139,83,131,228,21,56,158,242,28,79,205,66,219,39,157,160,182,169,125,238,56,73,211,180,136,35,33,9,86,138,213,142,115,16,95,199,238,130,184,10,214,136,83,73,30,54,12,245,90,168,36,12,120,136,10,253,71,159,98,139,101,87,115,40,205,212,222,208,178,103,235,217,169,130,246,4,246,79,249,27,201,139,240,72,127,134,144,99,128,244,1,42,12,243,27,97,75,117,210,18,21,99,239,155,129,122,109,207,109,149,12,105,148,114,0,151,30,36,163,216,45,180,211,64,246,56,22,186,170,167,113,125,226,184,58,101,70,121,33,249,39,48,127,25,54,216,148,128,55,136,40,55,208,16,243,122,178,143,52,252,154,57,180,134,236,81,118,222,129,212,209,173,41,95,231,136,105,196,179,138,107,187,10,141,119,234,58,166,41,23,27,37,36,131,21,141,125,166,249,89,136,250,162,29,82,21,50,86,214,229,160,181,41,109,51,110,208,206,20,197,87,130,49,101,59,80,79,119,37,219,171,122,202,59,194,253,82,65,134,195,193,151,37,175,171,248,8,124,179,122,53,186,246,149,149,225,143,75,193,250,98,26,201,148,194,165,229,188,231,154,83,103,82,184,197,219,64,7,230,197,100,241,253,100,98,119,129,27,135,31,189,201,128,195,111,130,159,202,1,37,30,166,50,130,104,119,165,198,174,5,155,11,225,231,183,29,225,210,253,116,14,91,29,81,44,44,58,84,53,249,133,233,164,22,135,79,156,124,141,103,212,120,26,46,81,173,101,54,11,27,96,15,123,145,5,156,203,62,136,139,67,99,77,81,167,250,44,107,234,50,89,204,187,136,99,95,3,95,158,27,188,244,158,53,132,238,102,4,187,209,195,156,43,25,190,40,26,30,206,9,158,22,21,19,51,43,158,10,64,121,96,122,119,249,140,94,242,178,54,193,33,200,68,255,145,172,84,131,88,180,63,159,81,233,213,242,31,198,239,154,17,68,13,221,160,192,130,168,37,138,249,28,57,110,146,28,189,47,106,20,241,48,199,136,234,159,233,44,204,208,225,120,160,246,119,255,168,26,234,247,45,46,152,117,233,58,59,231,215,166,246,78,24,52,74,169,130,63,197,1,239,111,132,194,70,177,83,202,12,220,57,102,193,68,90,197,52,152,158,224,224,14,245,113,61,175,46,132,112,61,172,97,215,231,14,169,143,144,41,30,211,228,19,124,118,171,45,216,21,96,134,252,49,245,128,212,169,219,149,110,93,125,158,236,220,141,62,180,99,62,139,168,142,79,204,67,194,104,248,205,15,186,231,138,149,244,237,57,84,7,121,132,70,254,6,104,99,252,233,16,182,151,104,221,111,98,145,152,128,134,162,62,107,71,40,35,1,254,206,53,24,194,30,222,77,9,66,207,84,75,38,23,227,15},
  {136,115,132,155,212,255,122,106,203,143,212,149,98,33,44,18,41,196,34,184,68,221,123,66,219,234,22,10,220,161,157,231,176,11,233,102,186,163,183,179,88,80,169,34,67,195,38,87,2,230,22,153,50,216,59,90,63,164,221,71,11,93,54,130,186,176,26,1,67,108,246,129,165,145,96,183,183,150,159,95,90,116,52,168,128,110,226,1,181,60,227,197,134,167,156,19,124,166,162,154,37,9,72,106,49,134,106,221,249,27,197,160,82,29,50,226,179,143,227,88,104,43,246,59,96,12,132,182,7,70,160,71,27,53,91,128,23,59,130,132,205,253,127,74,237,174,4,30,184,40,167,136,240,83,140,243,154,16,229,98,17,187,220,64,177,133,243,161,4,209,172,115,35,93,221,183,133,156,211,58,75,76,220,210,87,160,149,14,251,9,2,199,19,133,130,139,64,198,86,96,212,102,200,231,224,215,38,150,209,0,140,51,33,130,161,198,80,50,180,53,53,233,39,92,80,75,158,84,255,114,119,159,232,236,179,111,131,219,2,1,246,176,208,123,159,97,142,239,11,63,206,138,241,30,125,90,18,9,238,61,141,176,214,26,118,136,194,44,15,59,227,145,101,191,77,234,7,178,165,43,49,68,42,141,222,9,154,66,242,148,170,203,9,176,43,196,13,176,69,242,235,150,220,131,224,3,192,152,123,30,207,6,82,184,137,205,133,234,176,25,33,72,158,69,235,28,149,178,219,120,166,162,189,94,207,184,155,132,229,108,203,207,31,189,120,93,126,130,190,123,54,78,61,232,53,163,170,162,185,57,142,174,84,5,196,118,213,253,112,176,175,74,184,99,97,173,87,253,52,151,250,32,8,247,83,100,80,196,139,210,40,218,126,148,68,202,112,49,161,229,238,174,36,221,2,161,128,62,78,111,178,91,240,23,128,144,29,204,222,24,57,58,222,245,94,244,163,247,29,72,87,116,222,198,204,109,142,18,192,113,14,50,210,251,72,107,190,210,127,70,2,100,28,194,247,159,134,21,76,19,87,142,177,74,194,71,221,76,182,75,248,73,225,190,173,14,54,24,115,240,198,235,248,232,198,220,47,88,78,106,213,220,113,219,93,67,159,252,16,244,128,188,88,132,193,75,80,142,12,44,194,154,50,192,88,15,107,105,139,58,232,215,120,201,254,190,60,1,126,23,44,60,61,19,88,90,78,253,85,83,160,217,54,43,138,223,127,63,224,237,99,154,194,166,75,128,7,40,97,116,133,184,217,191,101,241,58,240,68,123,226,15,79,127,75,35,69,157,125,139,173,137,229,153,177,183,223,58,30,78,118,195,231,18,243,143,166,159,135,1,75,137,162,227,156,188,104,135,25,251,148,205,148,198,179,24,26,169,81,96,231,227,209,124,82,84,27,32,59,99,60,143,125,221,36,196,192,216,165,133,54,128,219,116,88,154,57,170,70,69,242,204,216,168,44,101,30,105,112,157,177,214,229,41,193,216,216,246,77,184,139,91,255,211,42,203,198,47,162,195,224,213,3,234,99,156,162,21,205,210,2,36,89,254,97,95,148,121,4,121,214,141,108,46,210,252,32,164,199,169,135,60,1,150,236,0,123,70,71,148,60,80,45,121,44,3,217,213,118,108,215,11,52,201,71,17,24,239,87,33,233,212,67,42,100,183,79,51,0,139,4,180,244,121,137,72,92,203,92,173,137,20,41,48,14,55,77,66,243,208,185,242,7,116,255,116,219,77,104,238,233,130,151,224,32,108,185,176,122,124,195,22,53,15,192,232,108,249,48,78,227,206,221,120,25,94,69,129,138,186,187,56,243,2,47,98,187,54,128,117,92,80,22,129,134,102,172,254,87,71,103,46,113,236,231,51,67,212,149,198,211,188,225,242,221,121,134,120,41,7,158,59,138,147,249,70,30,89,198,120,116,202,101,127,142,248,15,42,135,41,181,231,121,73,132,204,111,182,38,62,214,123,141,166,166,27,155,149,140,67,231,180,176,214,5,112,132,211,115,250,199,41,99,174,255,81,106,203,142,117,154,116,254,224,178,12,222,223,136,202,130,18,107,173,10,30,158,227,131,51,142,87,29,166,231,170,83,42,74,222,166,143,3,68,91,153,212,20,44,59,255,152,250},
  {57,125,246,174,115,214,232,173,248,188,171,242,216,59,197,195,112,77,137,182,49,218,190,130,241,104,110,253,157,160,155,67,232,12,13,27,25,168,194,151,113,145,15,220,226,184,58,60,75,135,205,109,196,189,194,119,130,162,61,78,146,48,14,116,230,200,107,176,139,131,187,26,179,106,105,38,124,168,203,170,147,63,33,204,160,113,83,131,42,252,140,4,220,222,75,163,103,122,177,200,60,145,177,66,115,220,84,234,149,150,137,168,6,21,54,34,239,219,17,117,166,123,178,67,102,72,63,219,119,106,55,93,209,230,134,222,125,209,135,130,231,127,35,253,80,118,165,137,213,151,139,107,225,3,198,185,81,13,37,77,139,49,6,157,20,236,235,245,56,103,204,134,29,212,187,203,114,207,220,49,69,150,143,46,253,217,35,226,128,198,29,81,200,102,15,218,81,40,250,88,92,70,27,250,99,27,65,227,25,33,112,74,211,143,69,57,39,179,223,87,156,135,192,175,245,106,235,102,39,217,129,196,31,226,9,16,194,234,46,94,163,20,156,90,108,233,9,110,180,135,197,150,25,93,139,46,216,186,252,53,151,94,81,60,179,111,202,246,205,23,104,207,154,230,219,43,91,130,173,29,91,22,199,30,117,84,64,40,192,27,183,235,70,22,117,52,204,89,6,72,142,80,113,230,252,21,162,242,239,12,44,15,2,10,20,93,8,163,215,159,120,241,80,95,99,129,48,224,77,225,97,19,252,55,191,207,230,128,203,76,125,21,230,62,181,167,9,95,53,181,188,76,128,82,15,181,177,232,120,61,202,232,50,228,143,35,121,153,71,253,66,116,238,129,132,1,14,187,123,184,214,130,109,44,41,68,138,18,13,3,120,42,36,199,108,226,138,129,29,138,170,13,68,174,118,86,171,189,202,153,127,33,24,150,94,43,5,41,109,139,68,96,218,129,150,29,111,221,21,46,111,117,100,203,163,193,240,56,181,169,215,75,234,155,177,226,128,242,95,206,9,214,212,231,38,252,0,16,181,153,18,100,215,60,67,233,120,125,56,224,135,65,228,25,134,78,77,157,24,180,58,73,164,227,251,17,195,191,225,73,9,100,31,51,123,214,136,131,11,254,91,25,145,83,136,109,185,251,105,112,178,246,82,181,100,108,131,4,94,105,13,243,144,34,15,95,124,184,205,89,162,115,226,67,44,183,90,143,230,1,114,105,3,161,195,91,239,101,154,251,109,100,211,210,250,32,233,138,246,172,81,69,39,124,124,234,202,184,232,71,254,174,49,77,150,205,100,108,31,172,247,203,13,21,165,82,23,117,140,123,125,187,191,242,250,186,47,9,59,169,65,42,198,202,253,26,117,213,241,48,109,179,129,112,244,44,202,44,227,97,20,60,176,250,217,152,37,118,90,255,23,52,32,146,94,95,88,238,104,172,195,225,221,97,5,53,51,191,45,175,189,165,83,137,235,197,81,238,171,57,58,85,107,219,143,34,252,230,179,147,180,89,55,95,212,53,13,163,169,192,202,40,38,64,72,16,251,18,117,143,88,71,132,87,80,109,101,28,190,29,153,29,106,222,55,221,184,134,180,97,71,142,21,6,121,62,58,60,144,237,11,35,141,93,34,66,89,163,67,196,214,238,161,37,100,184,149,94,9,140,91,180,110,33,190,37,219,26,108,103,72,98,224,121,183,235,107,58,10,87,198,103,52,11,7,89,174,68,14,157,112,76,76,47,231,91,67,74,76,95,177,107,200,44,79,254,46,249,189,175,8,28,49,45,142,87,32,190,114,198,63,169,72,43,71,7,92,19,17,249,155,238,15,216,111,175,59,214,167,188,174,110,248,190,70,212,2,20,150,154,150,170,55,27,112,246,169,51,133,108,137,34,59,56,85,115,48,121,225,100,66,104,43,132,246,70,221,190,44,209,81,32,223,75,47,70,157,47,136,37,233,47,210,232,226,105,222,98,201,97,108,41,211,99,17,116,96,13,82,28,80,14,38,97,248,7,150,219,156,123,169,62,254,114,198,88,164,199,161,155,37,135,187,173,144,222,56,237,177,42,120,101,0,145,254,214,128,35,69,228,177,63,190,76,202,246,103,129,125,110,122,121,174,173,220,81,67,51,222,244,7,29,174},
  {112,78,205,251,34,248,118,243,198,22,202,94,151,49,153,145,8,84,20,191,29,102,39,70,179,250,239,124,129,138,29,214,171,242,40,113,96,68,4,234,147,22,187,70,139,233,38,20,208,76,248,191,187,227,221,189,65,14,200,173,139,153,19,118,132,205,153,225,76,119,157,16,139,28,241,7,188,233,89,160,133,189,55,44,245,253,219,35,216,141,206,65,70,148,188,44,157,60,43,238,212,153,195,8,163,241,23,135,11,195,170,228,141,31,51,169,196,152,21,132,92,122,82,137,21,178,100,52,67,71,187,198,122,177,70,140,201,1,222,81,124,206,147,38,77,162,125,113,138,231,147,115,79,182,82,84,107,243,208,63,236,1,57,130,7,239,10,219,132,14,191,103,121,169,90,209,102,99,30,193,42,197,146,83,23,194,197,82,1,15,69,247,82,214,94,240,228,129,87,4,200,86,128,114,68,19,132,111,228,87,187,76,152,144,8,8,194,236,182,85,184,187,75,145,248,187,20,231,15,243,162,75,36,7,144,82,173,245,172,111,199,253,96,95,252,143,226,171,228,254,50,126,253,189,190,188,84,81,216,40,224,213,129,159,159,131,71,209,104,116,92,93,207,222,77,210,203,190,252,34,160,236,239,105,45,147,174,137,128,119,176,44,121,52,226,14,67,13,45,231,186,86,36,250,151,89,113,108,32,50,106,8,125,103,56,4,112,8,213,205,110,3,49,238,77,97,139,80,60,212,130,64,201,174,219,244,4,130,150,116,195,183,175,79,53,205,134,35,10,56,230,135,94,125,33,30,217,108,235,184,230,32,134,207,126,28,26,128,215,178,211,204,201,198,85,99,188,250,123,187,53,204,172,137,206,34,249,66,44,173,41,65,35,46,50,219,20,233,4,39,37,181,23,93,39,174,53,162,38,15,75,97,208,113,18,187,227,251,106,197,229,42,223,242,175,238,234,191,195,30,206,191,93,225,16,213,135,67,229,53,70,70,139,84,212,70,180,142,81,131,38,118,126,223,88,27,247,46,191,156,188,179,210,17,123,80,252,254,90,167,154,193,156,31,63,223,86,26,194,89,100,7,245,133,231,29,33,146,217,184,231,156,138,24,79,117,97,181,105,156,38,206,52,103,162,158,0,142,59,63,79,146,254,224,23,90,48,248,90,183,50,29,9,18,211,175,233,156,113,34,65,255,190,28,21,136,234,116,78,217,224,51,168,204,18,65,76,116,103,194,236,24,192,18,42,3,220,32,239,57,157,130,18,59,194,73,111,55,237,47,167,156,204,174,113,14,16,6,122,253,133,205,8,251,152,206,245,57,58,15,153,242,43,180,99,41,50,126,187,29,202,91,158,198,2,202,230,30,136,193,69,108,148,246,160,211,147,173,192,101,84,16,235,149,189,80,183,155,251,91,6,120,246,63,94,169,41,69,251,251,224,31,233,241,80,107,49,183,135,168,185,219,17,200,89,61,32,38,98,87,70,117,184,252,166,18,192,238,15,59,182,35,195,75,162,104,231,113,145,235,193,233,235,87,138,249,227,161,203,1,13,35,147,46,249,16,41,222,65,145,197,54,33,175,164,235,116,60,254,66,42,34,129,21,177,254,229,163,129,161,118,136,143,153,146,93,50,249,89,63,247,119,191,96,229,49,236,106,111,57,62,46,72,94,221,59,127,14,139,158,63,206,236,83,176,6,252,13,162,199,251,180,154,16,220,129,69,129,5,190,39,231,223,236,193,97,164,147,235,200,238,119,175,145,36,133,180,68,233,90,170,31,56,138,59,146,54,5,68,98,106,1,16,151,177,218,51,119,205,6,29,75,253,11,62,163,100,163,180,237,119,161,160,181,90,1,199,25,94,145,207,154,29,182,38,218,225,28,240,62,175,40,44,86,114,62,37,86,110,93,226,224,31,80,107,189,3,128,149,202,74,134,72,171,38,148,25,34,227,46,72,196,119,217,96,139,217,21,194,2,29,209,171,172,121,159,21,111,193,62,81,207,147,113,235,238,223,2,145,140,101,18,119,159,53,87,15,184,14,45,129,151,137,57,99,77,27,151,60,8,162,201,87,180,193,19,218,126,235,255,121,236,17,253,83,167,15,35,243,38,3,57,251,165,150,11,47,112,126,134,144,4,167},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
  {0,0,1,255,0,0,0,1,0,255,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,1,255,1,0,255,0,0,0,255,255,0,0,0,0,0,0,0,1,0,0,0,255,0,1,0,0,255,0,0,255,255,0,255,0,0,255,0,0,1,0,0,1,0,1,1,1,0,0,0,255,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,255,1,0,1,0,255,0,0,1,0,0,0,0,1,0,255,255,0,0,1,0,0,0,0,0,1,255,1,0,255,0,0,255,0,0,1,0,0,0,0,1,255,1,1,0,255,0,255,0,0,0,0,0,0,1,0,0,1,1,0,1,1,0,1,1,255,0,255,0,255,1,0,1,0,0,0,0,255,0,0,0,255,0,1,0,0,0,0,0,255,0,255,1,255,0,255,255,0,0,255,1,0,0,0,0,0,1,255,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,1,255,0,255,255,255,255,255,0,1,1,255,255,0,1,255,1,0,1,255,0,255,0,0,0,0,255,0,0,1,0,255,1,0,0,0,0,1,255,1,0,0,0,0,0,0,0,0,255,1,0,1,1,1,1,1,0,0,0,0,255,1,1,1,0,255,255,0,255,1,0,1,1,0,0,0,255,0,0,0,1,0,0,0,1,1,0,255,0,0,0,0,0,1,0,0,0,1,255,0,255,255,0,0,0,0,0,255,255,0,0,1,0,0,0,0,0,0,255,1,0,0,0,0,1,0,1,0,0,0,1,0,0,255,0,255,0,0,255,1,0,1,0,0,0,255,255,255,0,1,0,1,0,1,0,1,0,0,0,1,1,1,255,0,0,0,255,0,1,0,0,1,1,1,0,255,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,255,0,0,0,255,0,0,0,1,255,1,0,0,255,0,0,0,0,0,0,1,1,255,0,0,1,0,0,255,0,0,0,0,0,0,1,255,0,255,1,255,255,1,0,0,255,1,0,0,0,1,1,0,255,0,0,0,0,255,0,1,0,255,0,0,0,255,0,0,255,255,255,0,255,0,0,0,0,0,0,255,0,0,0,0,1,0,1,0,1,1,255,255,0,0,255,0,255,0,0,0,0,0,0,255,0,0,1,0,0,1,0,1,0,0,1,0,255,0,1,0,0,0,255,0,0,255,0,255,0,1,0,0,0,255,1,0,0,0,0,255,0,0,0,255,0,1,0,1,0,0,255,0,1,0,255,255,0,0,1,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,255,0,255,0,255,255,1,1,255,255,1,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,255,255,1,1,0,0,1,1,0,1,0,0,0,0,1,255,255,255,255,255,1,255,0,0,255,0,0,0,255,1,0,1,0,0,1,1,0,0,0,1,0,0,0,255,0,255,255,1,0,0,1,0,0,0,0,0,0,255,0,255,255,1,1,0,0,1,0,0,0,0,255,1,255,1,255,255,0,255,255,0,255,1,0,0,0,255,0,0,0,0,255,0,0,0,1,255,255,0,0,0,255,0,0,0,0,0,0,0,255,0,0,1,0,255,0,0,255,255,0,255,255,0,0,0,0,0,0,255,0,0,255,0,0,0,0,0,1,1,1,255,1,255,0,0,1,1,0,0,0,255,1,0,0,0,0,255,1,1,1,0,0,255,1,255,255,0,255,0,255,255,1,1,1,0,0,0,1,0,1,1,0,255,0,255,1,0,0,0,0,255,1,1,0,1,255,1,255,0,255,0,1,0,0,0,0,1,0,0,0,0,255,0,255,0,0,1,0,0,0,1,0,0,0,0,0,1,1,1,0,255,0,255,0,0,0,1,0,0,255,1,255,0,0,0,0,255,0,0,255,0,0,255,0,1,0,1,0,0,255,255,1,1,1,255,255,1,0,255,0,0,255,0,0,0,0,0,0,0,255,0,1,0,0,1,0,0,0,0,255,0,255,1,1,255,0,0,0,1,0,0,1,1,0,255,0,0,0,0,0,0,0,0,255,1,0,255,1,0,255,1,1,1,0,1,1,1,0,1,0,1,0,0,0},
  {0,1,255,0,0,0,1,255,0,0,0,0,0,1,1,0,0,1,0,0,255,255,255,1,0,0,255,0,0,0,1,1,0,1,0,0,255,255,0,0,255,0,0,0,0,255,255,255,0,255,0,1,0,255,1,0,0,1,1,1,0,255,0,0,255,1,0,255,1,0,0,0,0,255,0,0,0,1,0,255,0,255,0,0,0,255,1,0,0,0,1,1,0,0,255,1,1,0,1,0,255,255,1,0,1,1,0,255,0,255,0,255,0,0,0,0,255,255,0,0,0,0,1,255,0,0,0,1,0,0,255,255,0,255,0,0,255,0,255,0,1,0,0,0,1,0,0,0,1,0,1,0,0,255,1,1,1,0,0,255,0,255,1,0,0,0,0,0,0,1,0,1,255,0,0,1,0,255,0,1,0,1,0,0,0,255,0,0,0,1,0,0,0,0,0,1,0,255,0,0,0,0,0,255,0,0,255,255,255,0,0,0,0,255,0,1,1,1,255,0,1,1,255,0,0,1,0,1,255,255,255,0,0,1,1,0,0,255,0,255,0,1,0,0,0,0,0,255,1,0,1,255,0,0,1,0,255,0,1,0,1,0,0,0,255,0,1,255,0,0,255,0,0,0,0,255,1,0,255,0,1,255,0,0,0,0,0,1,0,0,0,1,0,0,0,255,255,0,1,0,255,255,255,1,0,0,0,0,0,0,255,0,1,0,1,0,0,1,1,1,255,0,0,255,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,255,0,0,255,255,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,255,1,1,255,1,0,1,0,0,0,1,0,255,0,0,1,255,0,0,255,0,0,0,0,0,0,0,1,255,1,0,0,0,1,0,255,0,0,0,1,255,255,1,0,255,255,0,255,0,0,255,0,255,255,0,1,1,0,0,0,0,255,255,0,0,1,0,255,0,0,0,1,0,255,0,255,0,1,255,0,255,0,0,0,0,255,0,0,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,255,0,0,1,0,255,1,1,0,0,255,1,255,1,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,255,0,255,255,255,0,0,0,0,0,0,255,0,0,0,0,255,0,1,0,255,255,255,0,1,0,0,255,0,1,0,0,0,1,255,255,0,0,0,0,0,0,255,1,1,1,0,0,0,1,1,1,0,1,255,255,1,0,0,1,0,255,0,0,1,0,255,1,0,0,255,1,0,0,255,0,0,1,0,0,255,1,0,1,0,1,255,0,0,255,0,0,0,0,1,0,1,0,0,0,255,0,255,0,255,1,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,1,0,1,0,1,1,0,0,0,0,0,255,0,1,0,255,0,0,1,0,0,0,0,0,0,255,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,255,0,1,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,255,255,0,0,0,0,1,255,0,0,0,0,0,255,255,0,255,0,0,255,0,0,255,0,0,0,0,0,1,255,1,255,1,0,255,0,1,255,255,0,0,1,255,0,255,0,1,0,0,255,255,255,0,0,1,1,0,255,1,0,1,0,0,0,0,0,0,255,0,0,0,0,255,255,255,1,1,0,0,1,255,0,255,0,255,255,0,1,0,0,255,255,1,255,255,0,255,1,255,255,0,0,0,0,0,0,0,0,0,0,1,255,0,255,0,1,1,0,1,255,0,255,0,0,0,0,0,0,0,255,1,0,1,1,0,255,255,0,255,1,255,1,0,0,1,255,0,255,0,1,0,1,0,0,0,0,0,255,1,0,1,0,1,0,255,1,1,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0,0,1,1,0,1,0,1,255,1,255,255,0,0,255,0,0,1,0,0,0,255,255,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,255,0,1,0,1,0,255,0,0,1,255,0,0,0,0,255,0,255,0,0,0,255,0,0,255,255,0,1,0,0,0,0,1},
  {0,0,255,0,255,255,1,0,0,0,0,1,0,0,255,1,255,1,255,0,255,1,0,1,0,255,0,1,0,255,1,0,1,255,0,1,0,255,1,1,1,0,0,0,0,0,0,1,0,0,255,0,0,1,1,0,0,0,1,0,0,255,1,255,0,0,255,0,255,255,0,0,255,1,255,0,0,1,1,0,0,255,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,255,0,1,255,0,0,1,0,0,0,0,0,1,255,0,1,1,0,255,0,0,255,0,0,1,0,1,255,1,0,0,0,0,255,0,0,255,1,0,0,1,0,0,255,0,0,1,0,1,255,0,1,0,0,1,0,0,0,1,255,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,255,0,0,1,0,0,1,1,0,255,1,0,0,0,255,0,1,0,0,0,0,255,0,0,255,255,0,255,255,255,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,255,0,0,1,0,0,0,0,1,0,255,255,255,255,0,0,0,255,255,0,0,0,255,0,0,0,0,1,1,0,0,255,1,0,0,255,0,0,255,0,0,0,1,255,0,0,0,1,1,0,255,0,1,1,255,255,1,255,0,0,0,1,0,255,255,0,0,255,1,0,0,255,1,0,255,1,0,0,0,1,1,0,0,0,255,0,1,0,0,0,0,0,0,1,1,0,255,255,0,0,255,0,1,1,0,255,255,255,0,0,0,255,0,255,255,0,0,255,0,255,0,0,255,0,255,1,1,255,1,1,0,0,255,0,0,0,255,1,255,0,0,0,1,0,0,0,255,0,0,255,0,1,1,255,0,255,255,255,255,0,0,255,0,0,255,0,255,0,0,1,255,0,255,0,0,0,0,0,0,1,0,0,1,0,0,255,0,255,0,0,255,1,0,0,0,0,1,0,0,255,0,0,0,0,1,0,0,255,0,0,1,0,0,1,0,255,255,0,0,0,0,1,1,255,0,255,0,0,255,1,0,1,0,0,0,255,0,0,0,0,0,1,0,0,255,0,0,0,255,0,0,0,255,0,255,255,0,0,1,1,1,255,0,255,255,0,255,0,255,1,0,1,255,255,0,0,1,0,1,0,1,0,1,1,0,0,0,255,0,1,255,255,0,255,255,0,1,0,0,255,1,0,0,1,0,255,0,0,1,0,255,0,1,255,0,0,255,1,0,0,0,1,0,255,0,255,0,1,0,255,255,0,0,0,0,255,0,0,0,0,0,0,0,255,255,0,0,0,1,0,0,255,255,0,0,255,0,0,0,0,0,0,255,1,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,255,0,0,255,0,1,0,255,0,0,0,1,255,1,0,255,0,0,0,0,0,0,0,0,0,255,0,255,1,0,0,1,0,255,0,1,0,255,0,0,0,0,255,255,1,0,255,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,255,255,1,255,0,0,0,0,0,0,0,1,255,0,0,1,0,0,255,0,0,0,0,0,0,0,0,255,1,0,0,0,0,0,255,0,0,1,0,0,0,1,0,1,0,255,0,0,255,255,0,1,0,1,0,0,0,0,0,1,0,0,255,0,0,255,1,0,255,0,1,1,255,0,0,1,0,255,0,0,0,0,1,255,255,0,0,255,255,1,0,0,1,0,0,1,0,0,255,1,1,0,1,0,0,0,0,255,1,0,255,1,0,255,1,0,0,255,255,0,0,255,0,0,1,0,1,0,0,255,1,0,1,0,1,0,0,0,255,1,0,0,255,0,255,0,1,255,255,1,0,0,0,0,0,0,255,255,0,255,0,0,255,255,0,255,0,255,0,0,0,0,0,1,255,0,0,0,1,0,0,1,0,0,255,1,1,1,0,1,0,1,0,0,1,1,255,0,1,0,1,0,255,1,0,0,255,255,1,0,1,0,255,0,0,0,0,255,0,0,1,255,255,0,1,0,0,1,1,0,255,1,0,0,255,1,0,0,1,1,0,255,255,1,0,0,1,0,0,0,255,0,0,1,1,0,1},
} ;

static const unsigned char precomputed_core_wforcesntrup953_k[precomputed_core_wforcesntrup953_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_wforcesntrup953_c[precomputed_core_wforcesntrup953_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_wforcesntrup953_impl(long long impl)
{
  unsigned char *h = test_core_wforcesntrup953_h;
  unsigned char *n = test_core_wforcesntrup953_n;
  unsigned char *k = test_core_wforcesntrup953_k;
  unsigned char *c = test_core_wforcesntrup953_c;
  unsigned char *h2 = test_core_wforcesntrup953_h2;
  unsigned char *n2 = test_core_wforcesntrup953_n2;
  unsigned char *k2 = test_core_wforcesntrup953_k2;
  unsigned char *c2 = test_core_wforcesntrup953_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup953_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_wforcesntrup953(impl);
    printf("core_wforcesntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup953_implementation(impl),ntruprime_dispatch_core_wforcesntrup953_compiler(impl));
  } else {
    crypto_core = ntruprime_core_wforcesntrup953;
    printf("core_wforcesntrup953 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup953_implementation(),ntruprime_core_wforcesntrup953_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    {
      long long weight,i,direction;
      for (weight = 0;weight <= nlen;++weight) {
        for (direction = 0;direction < 2;++direction) {
          output_prepare(h2,h,hlen);
          input_prepare(n2,n,nlen);
          input_prepare(k2,k,klen);
          input_prepare(c2,c,clen);
          for (i = 0;i < nlen;++i) {
            n[i] &= ~1;
            if (direction) {
              if (nlen-1-i < weight) n[i] += 1;
            } else {
              if (i < weight) n[i] += 1;
            }
            n2[i] = n[i];
          }
          crypto_core(h,n,k,c);
          checksum(h,hlen);
          output_compare(h2,h,hlen,"crypto_core");
          input_compare(n2,n,nlen,"crypto_core");
          input_compare(k2,k,klen,"crypto_core");
          input_compare(c2,c,clen,"crypto_core");
          double_canary(h2,h,hlen);
          double_canary(n2,n,nlen);
          double_canary(k2,k,klen);
          double_canary(c2,c,clen);
          crypto_core(h2,n2,k2,c2);
          if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic");
        }
      }
    }
    checksum_expected(core_wforcesntrup953_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_wforcesntrup953_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_wforcesntrup953_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_wforcesntrup953_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_wforcesntrup953_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_wforcesntrup953_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_wforcesntrup953_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_wforcesntrup953_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_wforcesntrup953_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_wforcesntrup953_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_wforcesntrup953(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup953")) return;
  storage_core_wforcesntrup953_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_wforcesntrup953_h = aligned(storage_core_wforcesntrup953_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_wforcesntrup953_n = callocplus(crypto_core_INPUTBYTES);
  test_core_wforcesntrup953_n = aligned(storage_core_wforcesntrup953_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_wforcesntrup953_k = callocplus(crypto_core_KEYBYTES);
  test_core_wforcesntrup953_k = aligned(storage_core_wforcesntrup953_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_wforcesntrup953_c = callocplus(crypto_core_CONSTBYTES);
  test_core_wforcesntrup953_c = aligned(storage_core_wforcesntrup953_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_wforcesntrup953_h2 = callocplus(maxalloc);
  test_core_wforcesntrup953_h2 = aligned(storage_core_wforcesntrup953_h2,crypto_core_OUTPUTBYTES);
  storage_core_wforcesntrup953_n2 = callocplus(maxalloc);
  test_core_wforcesntrup953_n2 = aligned(storage_core_wforcesntrup953_n2,crypto_core_INPUTBYTES);
  storage_core_wforcesntrup953_k2 = callocplus(maxalloc);
  test_core_wforcesntrup953_k2 = aligned(storage_core_wforcesntrup953_k2,crypto_core_KEYBYTES);
  storage_core_wforcesntrup953_c2 = callocplus(maxalloc);
  test_core_wforcesntrup953_c2 = aligned(storage_core_wforcesntrup953_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_wforcesntrup953 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup953();++impl)
      forked(test_core_wforcesntrup953_impl,impl);
    ++test_core_wforcesntrup953_h;
    ++test_core_wforcesntrup953_n;
    ++test_core_wforcesntrup953_k;
    ++test_core_wforcesntrup953_c;
    ++test_core_wforcesntrup953_h2;
    ++test_core_wforcesntrup953_n2;
    ++test_core_wforcesntrup953_k2;
    ++test_core_wforcesntrup953_c2;
  }
  free(storage_core_wforcesntrup953_c2);
  free(storage_core_wforcesntrup953_k2);
  free(storage_core_wforcesntrup953_n2);
  free(storage_core_wforcesntrup953_h2);
  free(storage_core_wforcesntrup953_c);
  free(storage_core_wforcesntrup953_k);
  free(storage_core_wforcesntrup953_n);
  free(storage_core_wforcesntrup953_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

