# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLVertexArrayObject(Object):
    r"""
    OpenGLVertexArrayObject - The vertex_array_object class uses, or
    emulates, vertex array objects.
    
    Superclass: Object
    
    These are extremely useful for setup/tear down of vertex attributes,
    and can offer significant performance benefits when the hardware
    supports them.
    
    It should be noted that this object is very lightweight, and it
    assumes the objects being used are correctly set up. Even without
    support for VAOs this class caches the array locations, types, etc
    and avoids repeated look ups. It it bound to a single shader_program
    object.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLVertexArrayObject, obj, update, **traits)
    
    def add_attribute_array(self, *args):
        """
        add_attribute_array(self, program:ShaderProgram,
            buffer:OpenGLBufferObject, name:str, offset:int,
            stride:int, elementType:int, elementTupleSize:int,
            normalize:bool) -> bool
        C++: bool add_attribute_array(ShaderProgram *program,
            OpenGLBufferObject *buffer, const std::string &name,
            int offset, size_t stride, int elementType,
            int elementTupleSize, bool normalize)
        add_attribute_array(self, program:ShaderProgram,
            buffer:OpenGLVertexBufferObject, name:str, offset:int,
            normalize:bool) -> bool
        C++: bool add_attribute_array(ShaderProgram *program,
            OpenGLVertexBufferObject *buffer, const std::string &name,
            int offset, bool normalize)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddAttributeArray, *my_args)
        return ret

    def add_attribute_array_with_divisor(self, *args):
        """
        add_attribute_array_with_divisor(self, program:ShaderProgram,
            buffer:OpenGLBufferObject, name:str, offset:int,
            stride:int, elementType:int, elementTupleSize:int,
            normalize:bool, divisor:int, isMatrix:bool) -> bool
        C++: bool add_attribute_array_with_divisor(ShaderProgram *program,
            OpenGLBufferObject *buffer, const std::string &name,
            int offset, size_t stride, int elementType,
            int elementTupleSize, bool normalize, int divisor,
            bool isMatrix)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddAttributeArrayWithDivisor, *my_args)
        return ret

    def add_attribute_matrix_with_divisor(self, *args):
        """
        add_attribute_matrix_with_divisor(self, program:ShaderProgram,
            buffer:OpenGLBufferObject, name:str, offset:int,
            stride:int, elementType:int, elementTupleSize:int,
            normalize:bool, divisor:int, tupleOffset:int) -> bool
        C++: bool add_attribute_matrix_with_divisor(ShaderProgram *program,
             OpenGLBufferObject *buffer, const std::string &name,
            int offset, size_t stride, int elementType,
            int elementTupleSize, bool normalize, int divisor,
            int tupleOffset)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddAttributeMatrixWithDivisor, *my_args)
        return ret

    def bind(self):
        """
        bind(self) -> None
        C++: void bind()"""
        ret = self._vtk_obj.Bind()
        return ret
        

    def release(self):
        """
        release(self) -> None
        C++: void release()"""
        ret = self._vtk_obj.Release()
        return ret
        

    def release_graphics_resources(self):
        """
        release_graphics_resources(self) -> None
        C++: void release_graphics_resources()"""
        ret = self._vtk_obj.ReleaseGraphicsResources()
        return ret
        

    def remove_attribute_array(self, *args):
        """
        remove_attribute_array(self, name:str) -> bool
        C++: bool remove_attribute_array(const std::string &name)"""
        ret = self._wrap_call(self._vtk_obj.RemoveAttributeArray, *args)
        return ret

    def set_force_emulation(self, *args):
        """
        set_force_emulation(self, val:bool) -> None
        C++: void set_force_emulation(bool val)"""
        ret = self._wrap_call(self._vtk_obj.SetForceEmulation, *args)
        return ret

    def shader_program_changed(self):
        """
        shader_program_changed(self) -> None
        C++: void shader_program_changed()"""
        ret = self._vtk_obj.ShaderProgramChanged()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLVertexArrayObject, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLVertexArrayObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLVertexArrayObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLVertexArrayObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

