/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#pragma once

#include "MvQRequestPanelHelp.h"
#include "MvIconParameter.h"

#include <QMap>
#include <QString>

class RequestPanel;
class MvQFolderModel;
class MvQIconHelpView;

class MvQIconHelp : public MvQRequestPanelHelp
{
    Q_OBJECT

public:
    MvQIconHelp(RequestPanel& owner, const MvIconParameter& param);
    ~MvQIconHelp() = default;

    void start() {}
    bool dialog() { return false; }
    QWidget* widget();

public slots:

protected:
    virtual void refresh(const std::vector<std::string>&);
    virtual long flags() { return 9; }
    virtual void set(Request&) {}
    void fill(const MvIconParameter&);

    MvQFolderModel* model_;
    MvQIconHelpView* view_;
    QWidget* holderW_;
    bool multiple_;
};
