#!/bin/sh
# Simple wrapper script used to start mkgmap-splitter in Debian

set -e

JAVA_CMDS="${JAVA_HOME}/bin/java"
JAVA_CMDS="${JAVA_CMDS} /usr/bin/java"

if [ -z "${JAVA_OPTS}" ] || [ "$(echo "${JAVA_OPTS}" | grep -c '\-Xmx')" -eq 0 ]; then
   JAVA_OPTS="${JAVA_OPTS} -Xmx2000m"
fi

if [ -z "${JAVACMD}" ]; then
    for jcmd in ${JAVA_CMDS}; do
       if [ -x "$jcmd" ] && [ -z "${JAVACMD}" ]; then
          JAVACMD="$jcmd"
          break
       fi
    done
fi

if [ "${JAVACMD}" ]; then
   echo "Using ${JAVACMD} to execute mkgmap-splitter."
   exec "${JAVACMD}" ${JAVA_OPTS} -jar /usr/share/mkgmap-splitter/splitter.jar "$@"
else
   echo "No valid JVM found to run mkgmap-splitter."
   exit 1
fi
