#include "ipbase.ih"

void IPbase::destroy(Record const &record)
{                                       // find this record's accumulated data
    auto iter = find(record.key());

    if (iter == end())                  // unknown record
        return;

    auto &accu = iter->second;

    accu->addSentBytes(record);
    accu->addReceivedBytes(record);
    log(*accu);

    erase(iter); 
}

