if (typeof T === 'undefined') require('../setup');

T('atan2', function () {

  function t(y, x, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, Decimal.atan2(y, x).valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', '1', 20, 4, 'NaN');
  t('NaN', 'Infinity', 20, 4, 'NaN');
  t('0', 'NaN', 20, 4, 'NaN');
  t('-Infinity', 'NaN', 20, 4, 'NaN');
  t('NaN', 'NaN', 20, 4, 'NaN');
  t('1', '0', 20, 4, '1.5707963267948966192');
  t('1', '-0', 20, 4, '1.5707963267948966192');
  t('0', '1', 20, 4, '0');
  t('0', '0', 20, 4, '0');
  t('0', '-0', 20, 4, '3.1415926535897932385');
  t('0', '-1', 20, 4, '3.1415926535897932385');
  t('-0', '1', 20, 4, '-0');
  t('-0', '0', 20, 4, '-0');
  t('-0', '-0', 20, 4, '-3.1415926535897932385');
  t('-0', '-1', 20, 4, '-3.1415926535897932385');
  t('-1', '0', 20, 4, '-1.5707963267948966192');
  t('-1', '-0', 20, 4, '-1.5707963267948966192');
  t('1', 'Infinity', 20, 4, '0');
  t('1', '-Infinity', 20, 4, '3.1415926535897932385');
  t('-1', 'Infinity', 20, 4, '-0');
  t('-1', '-Infinity', 20, 4, '-3.1415926535897932385');
  t('Infinity', '1', 20, 4, '1.5707963267948966192');
  t('Infinity', '-1', 20, 4, '1.5707963267948966192');
  t('-Infinity', '1', 20, 4, '-1.5707963267948966192');
  t('-Infinity', '-1', 20, 4, '-1.5707963267948966192');
  t('Infinity', 'Infinity', 20, 4, '0.78539816339744830962');
  t('Infinity', '-Infinity', 20, 4, '2.3561944901923449288');
  t('-Infinity', 'Infinity', 20, 4, '-0.78539816339744830962');
  t('-Infinity', '-Infinity', 20, 4, '-2.3561944901923449288');

  // Fails (1 ulp)
  //t('5900', '7999999999999999999999999999999999999999199999999999999999999.99999', 4, 1, '0.0000000000000000000000000000000000000000000000000000000007375');
  //t('5999999.9999999999999999999999999999999999999999999998', '599999999999999999999999989999999999999999999999999999999999999999999999999999999999999999999999999999999999999999959999999999999999999999999999999999999999999999999999999999999999999999999999999999999999.9999999999999999999999999999999999999999999', 2, 2, '0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011');

	t('17', '14', 4, 2, '0.8819');
	t('0.9481218', '0.94118', 6, 6, '0.789072');
  t('-7445', '20099977666211456789846696402535482054490525592', 5, 3, '-0.0000000000000000000000000000000000000000003704');
  t('35739959929999990.99999999995999999999999999999999992959', '0.955', 8, 6, '1.5707963');
  t('1.1', '6524806825029162376.20457337656513698810928', 5, 1, '0.00000000000000000016858');
  t('5211111.101111111177', '606497413079598703117552754486732', 6, 1, '0.00000000000000000000000000859214');
  t('-2913.07599', '986666666666666.8888888888873058007', 6, 6, '-0.00000000000295244');
  t('2.66213924447211273', '0.344623945616634', 3, 0, '1.45');
  t('312631627154243240137182349906197', '9999999555555555.88888888889999999999', 10, 1, '1.570796326');
  t('899.99', '26.9', 3, 4, '1.54');
  t('-2', '-0.0000006306201002089224863559916332763966685755123769189', 3, 5, '-1.57');
  t('0.21', '8', 4, 2, '0.02625');
  t('0.9481218', '0.94118', 6, 6, '0.789072');
  t('2', '9333333333333333397407226578881017498733601111111111111', 9, 1, '0.000000000000000000000000000000000000000000000000000000214285714');
  t('95726', '-2693596537831566265', 9, 3, '3.14159265');
  t('3', '136424614399.47534873339', 6, 2, '0.0000000000219902');
  t('724388888888888888888', '452240666.2222266666', 3, 0, '1.58');
  t('0.04129', '4.7459', 6, 3, '0.00869992');
  t('-0.000000003593', '831', 9, 3, '-0.00000000000432370638');
  t('3', '652', 1, 3, '0.004');
  t('53', '0.00021', 5, 2, '1.5708');
  t('583', '0.5', 2, 3, '1.5');
  t('0.88956212348302', '-3613.47', 4, 1, '3.141');
  t('499999999999999999999999999999999999999999899999999999999999999999999999999999999999999999999999.99999', '0.397', 2, 2, '1.6');
  t('670.7246136257055836748897015621', '8', 9, 1, '1.55886949');
  t('40000', '6809492801384871383672604464351', 5, 5, '0.0000000000000000000000000058742');
  t('6000000002222222.00014266', '-0.450903', 1, 6, '2');
  t('3', '4', 10, 3, '0.6435011087');
  t('2666641666666666', '59999999999999999999999999999999999999999.99999999999999999999999999925', 1, 6, '0.00000000000000000000000004');
  t('5', '0.65', 7, 6, '1.441521');
  t('43.65', '8568924402932018888.66666666666666666666135181', 9, 0, '0.00000000000000000509398823');
  t('4891999999999999999999999999999999999999999999999999991999999799999.999999999639999999992999', '710000000000000000.0000000000005700000000000060000000000033', 10, 0, '1.570796327');
  t('4.73001', '455555555555559399859117776418166', 8, 0, '0.000000000000000000000000000000010382949');
  t('40068.2342', '1', 2, 2, '1.6');
  t('0.6', '511111111112433397604060000000000000000000', 1, 4, '0.000000000000000000000000000000000000000001');
  t('530000000000000.286', '7', 7, 1, '1.570796');
  t('9251010716.51554394500003489103488443', '727127846893147834657170633071486391409', 2, 6, '0.000000000000000000000000000013');
  t('2156', '6', 5, 0, '1.5681');
  t('-0.007700837496370833875888297147521851009315187908640623592495789607215971', '-0.60609673305145265303411222292406724609400618553386938', 8, 4, '-3.1288877');
  t('0.631666343041280486605909338251618534368378514270566344350649949184', '0.1', 9, 0, '1.41378793');
  t('0.81895579436335688497005428053140270015707', '34.88388', 10, 4, '0.02347231408');
  t('7819', '8111111111111114050153374108607899100080038117344269814600726014856', 6, 2, '0.000000000000000000000000000000000000000000000000000000000000000963987');
  t('78230794955', '-6', 10, 2, '1.570796327');
  t('444444444444444444444', '0.7', 8, 3, '1.5707963');
  t('0.9793', '0.7', 1, 1, '0.9');
  t('5244107.0628867', '2999954.9965', 7, 3, '1.051172');
  t('8000000', '366666666666666666666666666666466666666666666666666666666.6666666666666666666666666', 5, 4, '0.000000000000000000000000000000000000000000000000021818');
  t('0.2', '0.189468318714349130097801836058861527404712938072131132348336428', 6, 1, '0.812432');
  t('0.2858318234746344', '600000000000000000000000000000000000000000', 7, 0, '0.0000000000000000000000000000000000000000004763864');
  t('4339137560184', '97970869.448873424003041514353519', 4, 4, '1.571');
  t('-0.23311', '0.311511919081010226751458633564788098826129188077', 2, 6, '-0.64');
  t('51748034844738', '1.9', 4, 3, '1.57');
  t('489991.33896294143521760395611846731', '0.87', 9, 2, '1.57079456');
  t('9708256886359351', '68007500000000000300000000.8000007', 7, 3, '0.0000000001427527');
  t('-0.7243703154875085348', '-3', 8, 3, '-2.9046707');
  t('45000000000000', '65555233', 10, 2, '1.570794871');
  t('611492726146771524971502', '6', 1, 5, '2');
  t('453102.0374285112290126', '144444444448560013578500490755362539053948899999999999999999', 8, 2, '0.0000000000000000000000000000000000000000000000000000031368603');
  t('-93.61', '-0.0000399443101158077208687249496264941993597813459', 7, 2, '-1.570796');
  t('2', '9581689854499862551.065722086916773096996491758707340479', 7, 4, '0.0000000000000000002087314');
  t('1.3', '5.5', 6, 2, '0.232104');
  t('-600000000', '-3.7', 64, 5, '-1.570796332961563285897988280138208232222043273348998383738452657');
  t('11058591315337683586049031068.0579551185', '0.388959837250046012554110591319702948213801', 61, 0, '1.570796326794896619231321691604578803363795829358878500062293');
  t('0.8448786268946126278', '0.13526', 50, 4, '1.4120494110103741256697724128137501343789286117212');
  t('30287996', '40950.1689588762720486401957594518884943112430153961670406237501355555', 23, 0, '1.5694443012595347494123');
  t('49990999999999999999299995399.9999999', '18373333333333333333333333333333333313333.31333333333333', 24, 0, '0.00000000000272084542815674891142779');
  t('81050298736775188105704407264452322940639721302743656726962427972686398373147738700', '5758', 57, 6, '1.57079632679489661923132169163975144209858469968755291049');
  t('88986', '933333549093318029464784161', 25, 4, '0.00000000000000000000009534212081677014822531107');
  t('0.000000096379436364822449512580758185420939', '0.6', 8, 1, '0.00000016063239');
  t('0.0000005078632254302310932666825377', '-406.26', 54, 1, '3.14159265233969914741200809306601738606958485281812206');
  t('4.7407009601', '629989999.9099919', 27, 6, '0.00000000752504160506883380341035311');

  /*
  t('-0.000002545', '-3534', 7, 6, '-3.141593');
  t('5929999999992999999959999999999999999999920999997999999999699999999999.9999999999999', '444444444444444760418728944267284577777777', 5, 6, '1.5708');
  t('5333333333303333333333383333.3333333133333333', '0.3465953', 5, 0, '1.5708');
  t('0.000000008978481', '316822982251', 1, 3, '0.00000000000000000002');
  t('-78785.25', '7', 9, 4, '-1.57070748');
  t('0.004887580293809264895474440608824721935', '0.1873', 7, 4, '0.02608901');
  t('0.55', '0.57375630544689', 3, 6, '0.764');
  t('12646367777777777777777777', '2246.78', 4, 2, '1.571');
  t('-2943115615404317859938.049791758272196826255702811809', '0.0004433', 1, 0, '-2');
  t('64740606639566801281770583511193610040782451981567', '566', 1, 3, '1');
  t('1', '6093666666666665555555.66', 7, 2, '0.0000000000000000000001641049');
  t('71555555555555555555555555555555555555555555555555555555555555555555555555555555555555.555555', '0.00001', 2, 0, '1.6');
  t('0.973', '6', 2, 3, '0.16');
  t('90.2', '43976', 1, 6, '0.002');
  t('0.000000631126386', '0.38113', 7, 2, '0.000001655935');
  t('2922.45', '257.6751582391223540845', 10, 3, '1.482852812');
  t('-86905.9603', '-5911244336', 2, 2, '-3.1');
  t('32471.88195727', '1432987587153153052054186', 6, 0, '0.0000000000000000000226603');
  t('0.27', '89997989.94', 10, 3, '0.000000003000067003');
  t('1907777.7777777777777877777', '70100200.07', 3, 1, '0.0272');
  t('-0.964', '0.905645353407738587546986', 5, 2, '-0.81659');
  t('371.3', '4999999999999999624815671461', 3, 0, '0.0000000000000000000000000743');
  t('406.72', '0.238', 8, 2, '1.5702112');
  t('0.5', '0.66', 10, 6, '0.6483319891');
  t('-40866.9873', '1', 3, 4, '-1.57');
  t('623362071568016913046606928078611383678055391537058846703690739', '745333333333333.555555555555555552', 10, 5, '1.570796327');
  t('26916.39', '265', 4, 0, '1.561');
  t('3.83743578493953981940491694913675522976137', '2', 9, 4, '1.09034757');
  t('-5699519999999999999999999999999.999999599999999928', '0.0000538', 2, 0, '-1.6');
  t('0.1', '28.999799', 1, 1, '0.003');
  t('5577.77777', '1', 7, 0, '1.570618');
  t('6', '6999.0999', 4, 3, '0.0008572');
  t('0.6', '-90000600', 1, 2, '4');
  t('754', '13777777777777772.77776', 10, 4, '0.00000000000005472580645');
  t('69', '5121548', 8, 0, '0.00001347249');
  t('1950999199959.99399999999999999999399999999999', '0.92618935666823328351405992089144837463098275645924421417501510733796', 2, 2, '1.6');
  t('383', '-4.17494445268', 2, 1, '1.5');
  t('918.8', '93333.8', 9, 5, '0.00984391851');
  t('118701.9438478744872242615462', '235', 8, 4, '1.5688166');
  t('0.3576218', '4892824558.517026874600751288585883153854', 6, 4, '0.0000000000730911');
  t('23', '-375797776666666666666.7777', 1, 5, '3');
  t('186059', '0.7340864854556', 5, 4, '1.5708');
  t('94655555.3', '36666666666666975777777777', 9, 4, '0.00000000000000000258151514');
  t('8649681078992028.94727211017835', '0.000006313646149661290333890483752452969088891970122483805217149927406228481', 9, 2, '1.57079633');
  t('-279410899528570351.9440369173572', '-555.868', 10, 6, '-1.570796327');
  t('682739271.77', '5677.1', 8, 5, '1.570788');
  t('20566548680871338889598852644501', '10186', 5, 0, '1.5708');
  t('15555555555555555555.9', '40000000', 8, 3, '1.5707963');
  t('-74', '7', 5, 5, '-1.4765');
  t('0.301635', '0.791608834565179391387', 4, 0, '0.3641');
  t('67777777777777777.0000000000000000006', '20.2', 7, 2, '1.570797');
  t('9040880016579317006295805025742298.6445910580737058384625530549604966806101801215', '0.00584715622263981921987653029446300193112208847086', 10, 4, '1.570796327');
  t('246934808644179708788.42663936773216678328641960788407829509949179074', '5', 8, 3, '1.5707963');
  t('32', '0.73', 2, 3, '1.5');
  t('64.44444444', '72184221110447.94805585513118138243631861047402', 3, 2, '0.000000000000893');
  t('-130000000000040000000000000000000000000000000000.0000000000000008', '0.517784', 8, 6, '-1.5707963');
  t('9.9999999999999999999999999999999999', '0.000000480124602285204346788609011963454', 5, 4, '1.5708');
  t('29989.9373492297462786', '758.93', 3, 3, '1.54');
  t('0.03236261788964124047', '124942493331587780350.3794806144769089376598265126008', 4, 0, '0.0000000000000000000002591');
  t('52', '95.8', 2, 3, '0.49');
  t('16', '65555555555166000000000011111111111111.777777777777777', 6, 0, '0.000000000000000000000000000000000000244068');
  t('0.2', '1670477777.7777777777777', 7, 4, '0.0000000001197262');
  t('0.66484415975', '82382', 4, 1, '0.00000807');
  t('-3.4', '-9', 8, 4, '-2.7803889');
  t('22332987678680772902.31087653648', '7.33130628', 4, 1, '1.57');
  t('0.0000071643281123487', '3', 3, 3, '0.00000238');
  t('93895689204457.0539998', '776253000', 1, 0, '2');
  t('8517', '-0.3', 1, 5, '2');
  t('0.099637519783681417', '670.21', 6, 2, '0.000148667');
  t('499999995947404786666666666666', '84.31', 2, 3, '1.5');
  t('3', '8', 5, 2, '0.35878');
  t('-477777777777772445451595455836588744152596356357238642145433673451615822', '-483183433563659474785331378153316', 10, 3, '-1.570796327');
  t('0.19999', '585193481', 4, 2, '0.0000000003418');
  t('4369999999999999993999999999799999999.9999979997999999996999998999999', '90.4095719', 1, 6, '2');
  t('0.04', '4', 9, 6, '0.00999966669');
  t('50.5', '488888888888888888882039220519322675000432635505974074206789548291343345556942584447950910654533333333333', 7, 0, '0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001032955');
  t('0.00004', '43.399', 4, 6, '0.0000009217');
  t('-4813417065996546', '0.0079947993756976', 4, 5, '-1.571');
  t('0.008', '14099', 8, 0, '0.00000056741613');
  t('572639', '6612174063649442377157402723363504373698298258635538987387646725023759891920828716', 6, 1, '0.0000000000000000000000000000000000000000000000000000000000000000000000000000866037');
  t('888233366.13333333', '0.00000028272587032424', 9, 5, '1.57079633');
  t('172888888888.089951', '0.6842509', 6, 3, '1.57079');
  t('1199999999999999999999999999969.999997999999999949995999999999999999999959999999969999999969979999', '3288721448.1752210990986472870508893186356787180739', 10, 1, '1.570796326');
  t('20', '606816230247518.0089', 3, 0, '0.000000000000033');
  t('0.000006981961', '1828222222212222222222222222222222222.222222222222222222222222245', 10, 5, '0.000000000000000000000000000000000000000003818989243');
  t('100000000000000000', '-4792', 10, 4, '1.570796327');
  t('300000000', '569.411111111111', 5, 1, '1.5707');
  t('4999999999999999999999999999999999999999999999999999999999.99999999999999999999999999999999999', '36663333333.111111111112084', 7, 1, '1.570796');
  t('77510496.85715', '0.0008544', 5, 0, '1.5708');
  t('-3989999.6989', '0.6369', 6, 0, '-1.5708');
  t('5826666666666666666.0000000000000000009433333333333333333333', '5097646440115351480575841.048024879', 1, 1, '0.000001');
  t('5633302780808', '7', 2, 5, '1.6');
  t('3000992770523914099894184572205493347910335630423478817352191762995', '66235616160.03832920993618', 2, 0, '1.6');
  t('-431066666666', '-406535', 8, 6, '-1.5707973');
  t('0.47', '0.43088680413857867', 3, 3, '0.828');
  t('0.60587519', '0.1', 4, 2, '1.408');
  t('7555555555593079498821189757', '0.8676178', 4, 6, '1.571');
  t('610', '8111111111111.111', 5, 2, '0.000000000075206');
  t('26.8452', '0.854658180949848472879307027464450981452484044182961', 9, 2, '1.53897055');
  t('-1950', '-5991999999999999999899999999999.9999999999', 13, 2, '-3.141592653589');
  t('5', '76', 9, 2, '0.0656948016');
  t('0.227612965', '76.736', 13, 3, '0.002966173601341');
  t('0.4', '85043083.1310123888585468128', 8, 0, '0.0000000047034984');
  t('8', '-0.000005', 11, 3, '1.5707969517');
  t('9222.287', '5555137855.5', 14, 1, '0.0000016601364790363');
  t('0.2', '0.5708472', 9, 4, '0.336992337');
  t('4', '8.0629552614851', 5, 0, '0.46052');
  t('-9407014521487438050752802003689', '0.7', 6, 0, '-1.5708');
  t('5309883156796538341567056480726204719131542715337727577260103498892564780933836', '67', 9, 1, '1.57079632');
  t('0.467471', '0.4026', 9, 1, '0.85981875');
  t('5', '0.08514', 10, 0, '1.553769973');
  t('68', '87541506.6189', 6, 0, '0.000000776775');
  t('0.29', '7288888888080888.888', 3, 2, '0.0000000000000000398');
  t('535088710', '51.603', 5, 1, '1.5707');
  t('65257864326100', '52222222222222232603837259016997593142527508619035544316899999999999', 8, 2, '0.0000000000000000000000000000000000000000000000000000012496187');
  t('-6', '-0.24417760982', 1, 3, '-2');
  t('0.150641617203003789406296', '976990923520791955199586054467506462', 6, 6, '0.000000000000000000000000000000000000154189');
  t('0.000000004233334109278', '566777777777777777.77', 16, 5, '0.000000000000000000000000007469125070280729');
  t('0.975', '450969999999999999999999999.99999999929999999999199999999890699999299919999699999', 12, 5, '0.00000000000000000000000000216200634189');
  t('0.64635113839', '166766106666662666.663', 13, 0, '0.000000000000000003875794376384');
  t('96270497710', '0.4941140457', 16, 4, '1.570796326789764');
  t('9584212519118646337525061411752922452907575819163628119955474052138', '0.0072', 2, 5, '1.6');
  t('8247', '577000000000.7777752', 9, 1, '0.0000000142928942');
  t('23671.4', '-98657555.33333333355555555555', 10, 1, '3.141352718');
  t('118190794.61469661', '9.29', 1, 2, '2');
  t('3', '4458774000', 5, 6, '0.00000000067283');
  t('0.8', '3811.96', 12, 1, '0.000209865787745');
  t('-0.78581426', '0.907778', 10, 6, '-0.7135074513');
  t('55555555555555555523529876239034678708869', '6.52697', 3, 0, '1.58');
  t('50289000000000000000000000', '0.6', 18, 2, '1.57079632679489662');
  t('6192008', '411111111111114642364750737275822311791443263748506885104444444444', 11, 4, '0.000000000000000000000000000000000000000000000000000000000015061641081');
  t('-68.51338', '-0.364', 8, 0, '-1.5761092');
  t('62761498913333333333', '0.00000741553710706062448489343470788408728587987333751120883031050730660871321571629543', 6, 3, '1.57079');
  t('9.22', '0.0603617', 11, 4, '1.5642495982');
  t('16626666663.66', '968500226055453670256798108771953281326459971091.2132429344444444444444444', 4, 4, '0.00000000000000000000000000000000000001717');
  t('60490010865191488888.555555555555555555763', '41111111111191111111.1111111111111111111111111111111111111111111111111111111111111118', 20, 0, '0.97386949780698462703');
  t('9888888915122222222222222222', '0.000000004', 18, 1, '1.57079632679489661');
  t('846147110893185519947', '353', 2, 4, '1.6');
  t('3014080.000108', '0.0934632513038', 9, 3, '1.57079629');
  t('-0.504414053494937', '-5838490548.6389761255529718821355529829664', 5, 4, '-3.1416');
  t('9000000000000000000000.0000008', '7', 11, 4, '1.5707963268');
  t('2349', '52097695.707205412205400007249197879285712226890088721187075326866727978437398', 8, 0, '0.000045088367');
  t('12', '280859106369043042382657353186319596980474278473816017996672078306702747102220', 4, 6, '0.00000000000000000000000000000000000000000000000000000000000000000000000000004273');
  t('2.47', '-544444444529732304', 2, 0, '3.2');
  t('17', '0.02', 18, 3, '1.56961985674943853');
  t('0.871814914786887298065565', '17.06', 8, 2, '0.051058452');
  t('0.7374041', '9', 2, 5, '0.082');
  t('2592205.0805090931902411118272434468895851605962540558617593', '592000', 14, 5, '1.3462699484142');
  t('3199814528', '62222957.88888888888888884339', 3, 1, '1.55');
  t('488464421', '41', 10, 3, '1.570796242');
  t('0.62', '32505200381608164972204391428791106', 14, 6, '0.000000000000000000000000000000000019073871033596');
  t('6000000000', '-1145184143055268000000000.8386', 7, 5, '3.141593');
  t('0.78', '0.596910486308076', 14, 3, '0.91759392380288');
  t('658296', '4.923916884352', 8, 0, '1.5707889');
  t('8.0178122337', '0.467177787', 4, 2, '1.513');
  t('8.938998999', '-94944811296661', 13, 0, '3.14159265359');
  t('922222222222271999999999999999999.298', '9.40000000000000000000000000000000000000000000000000000000000000000002', 8, 3, '1.5707963');
  t('6044.291446', '72649799999999959999999999999999999999.2999999899999999999999999599999991999999999999999', 11, 4, '0.000000000000000000000000000000000083197633662');
  t('0.343958204891340134044065556710679469960108473540765189197011282323919739545133465513', '0.0000741054', 9, 3, '1.57058087');
  t('0.817638730505', '244446838769433333333333', 19, 5, '0.000000000000000000000003344852952981779387');
  t('85000000000000000000700000000070000000.000000005000000000000000000005000000000015000000000000001', '6521479921.38876', 4, 2, '1.571');
  t('3', '7000100000080', 2, 5, '0.00000000000043');
  t('74929999099999.991999', '177102.85719179', 20, 3, '1.570796324431319156');
  t('-81711876774736', '0.2', 2, 2, '-1.5');
  t('3555555555555551195689', '735991091674.956571417858272812201492455054697693771', 18, 2, '1.57079632658789913');
  t('5483', '150000700000000.8', 4, 5, '0.00000000003655');
  t('153172389606854.6947232931652', '0.0000004', 3, 5, '1.57');
  t('-0.26739', '21729927191216388406', 10, 6, '-0.00000000000000000001230514938');
  t('0.52743016271', '0.92557355607167855', 9, 6, '0.517948839');
  t('0.179908845', '8309.30123171', 11, 1, '0.000021651501125');
  t('0.9', '5993979299999.695999', 2, 6, '0.00000000000015');
  t('-0.2', '8', 18, 1, '-0.0249947936189201595');
  t('0.161999991399999969999999999999', '0.00000639343267490545790870243', 15, 5, '1.57075686115903');
  t('0.40828527211317125708141583003519', '47349634803129624', 9, 4, '0.00000000000000000862277553');
  t('0.637988577110728269779036256382432462671448', '2.33', 17, 3, '0.26726404353743542');
  t('-77126777777177777277777777777757777777777777777777777.77777777787777747777777777777', '-0.1', 19, 6, '-1.570796326794896619');
  t('0.614048', '818995716.0000000000009', 11, 0, '0.00000000074975727957');
  t('55848.88', '0.188761359978651', 1, 6, '2');
  t('63052220245350273170.84499', '8878151.137606389001514644599087449945604279572', 6, 3, '1.57079');
  t('-0.269593735659', '0.217000000001', 8, 3, '-0.89306571');
  t('65892028634881197088548419304.409', '74836589983562870471094222', 16, 2, '1.569660581555961');
  t('81606.3787875159', '4', 2, 0, '1.6');
  t('51.4444444444444449601962585418375555555555', '94.9', 19, 5, '0.4967508398570922095');
  t('-8232339136552968101430591673885662037028311.6611516426299294683', '0.99871495835002046239454063840041207432606141011748340012003114831', 9, 6, '-1.57079633');
  t('169.2', '5333333333333325007904', 15, 6, '0.000000000000000000031725');
  t('6.0281288977737', '0.50333333335373533383333334330333333333333333313', 7, 6, '1.487492');
  t('22.5', '563744541070747483170260387977.62468', 1, 2, '0.00000000000000000000000000004');
  t('9', '-0.7888888888848888837888881888888', 4, 6, '1.658');
  t('1', '30.3444', 14, 3, '0.032943087515976');
  t('65030', '166696.166615666', 14, 2, '0.3719523730534');
  t('398.404', '1279000', 4, 6, '0.0003115');
  t('0.3', '-204140.31', 4, 0, '3.142');
  t('9', '71', 18, 6, '0.126088095064590432');
  t('0.0008160692112343', '0.236982', 2, 1, '0.0034');
  t('3999999999333.55555555599946', '63.46', 19, 3, '1.570796326779031619');
  t('-404786636.76', '-39999.07999913', 7, 1, '-1.570895');
  t('369333.333333334333333333333333332333333333363333333333', '4', 10, 3, '1.570785496');
  t('0.25415546669666666', '4396362952542323984546668860479706999999999999999999', 9, 6, '0.0000000000000000000000000000000000000000000000000000578103922');
  t('716000000000000000020003060000000000000000000000000000000000000000000000000009003300000', '6888888888888884680269.000000000000000009539623', 7, 0, '1.570797');
  t('-56401.617914006562068', '-5219748230.323739667', 18, 0, '-3.14158184816098268');
  t('0.00074754634633295291405070339859292186825046899699255542695', '41528570426868', 15, 5, '0.0000000000000000180007724477149');
  t('0.29653288', '105974.068632', 14, 3, '0.0000027981645305036');
  t('0.0207879189978533628689846261930751', '3.70472', 17, 4, '0.0056111395271356516');
  t('-9026.11', '0.005727933', 1, 2, '-1');
  t('6452000000', '0.00003325012', 15, 1, '1.57079632679489');
  t('711111111.1111115425304570840277777777777777777', '531211806937856566194.87748518162821411507214458', 18, 5, '0.00000000000133865833142955794');
  t('0.574263', '3513042332967225195760343517127481705641025735784111507010691762175172468766', 1, 3, '0.0000000000000000000000000000000000000000000000000000000000000000000000000001');
  t('19999999.999', '-6', 18, 5, '1.57079662679489663');
  t('3989666666666666.333333333333333333335', '0.570277788', 11, 6, '1.5707963268');
  t('1130713550650741422577414', '690.330207734', 1, 6, '2');
  t('5457.841105669', '7', 3, 1, '1.56');
  t('710628.235233359', '-80000', 2, 4, '1.7');
  t('700096403892084064200378317593.9641197539020648165777777777', '0.2432', 10, 1, '1.570796326');
  t('0.8571286803773208181803050631397084118598363976415044249031901589236939437728037', '967872523768.3333333333333376554842523475', 7, 6, '0.0000000000008855801');
  t('188888888888888888868048000000000000000.000000000000000036380579985998322222222222222222', '25.9', 11, 5, '1.5707963268');
  t('29999999999999.555555555555555555599999966547664969', '-0.1', 11, 3, '1.5707963267');
  t('0.555', '92979808598368222222222222222.080012608461880689119401042833', 2, 6, '0.000000000000000000000000000006');
  t('6.21', '964.788295', 13, 0, '0.006436556365145');
  t('213054904.047858775', '228808806237189473', 4, 4, '0.0000000009311');
  t('999999999959999.9988', '-492034', 3, 3, '1.57');
  t('0.884381671333064', '6498.394430127429256954373819746', 13, 1, '0.0001360923340961');
  t('4.93151', '6', 15, 6, '0.687963625503402');
  t('89925703.3177963346', '11111111111111111111822853333333333333333.138616958038440630433', 7, 4, '0.000000000000000000000000000000008093313');
  t('-7111.1111169', '-68.78333479333', 11, 5, '-1.5804686816');
  t('510962748', '8', 13, 0, '1.570796311139');
  t('0.74004', '8', 2, 3, '0.092');
  t('0.6', '22090.4286469031', 1, 6, '0.00003');
  t('-980683783443166666666666666666.31379473473395555555555555555', '-0.69214', 5, 1, '-1.5707');
  t('219680413149.63', '368265.125742', 14, 0, '1.5707946504274');
  t('70925', '305.000006', 18, 3, '1.56649603598168967');
  t('3878725934303176618211873151895131', '0.63596', 20, 4, '1.5707963267948966192');
  t('391.83461875264198205744979', '5544496962', 7, 1, '0.0000000706709');
  t('0.6895', '2701', 3, 0, '0.000256');
  t('1999999.959999999999999999949999999999999999999999999999999999', '400850444444444', 14, 5, '0.000000004989391898447');
  t('0.14', '4608196395865043688974388166208831306190487733992363597810733333333', 17, 6, '0.000000000000000000000000000000000000000000000000000000000000000000030380649602005387');
  t('2.12', '9681', 13, 5, '0.0002189856384787');
  t('0.4291721052132797', '9770000000000', 7, 3, '0.00000000000004392754');
  t('0.00007411904848297227831', '700000000000000000000000005000000000000200000000004000000.0000500000000000000000003000000000008', 12, 2, '0.000000000000000000000000000000000000000000000000000000000000105884354976');
  t('0.828', '0.8576505', 6, 4, '0.76781');
  t('-0.447', '96.76152764', 15, 2, '-0.0046195717572017');
  t('1590', '9448364249831029362222222222222222', 16, 0, '0.0000000000000000000000000000001682830972597649');
  t('0.00034768842104', '89999999999999999999999999999.399999999999999999999999999999999999999939999999999999999709999789', 8, 4, '0.0000000000000000000000000000000038632047');
  t('7', '5.8', 3, 0, '0.879');
  t('-0.65118752298812321381116607387959486212424133', '-599.9999999959999', 15, 5, '-3.1405073414776');
  t('793731469401175628213144848905070806055771110.7418825191088418554', '69', 2, 3, '1.5');
  t('0.432', '17', 14, 2, '0.025406296875962');
  t('0.6381718858188238519', '39000', 1, 3, '0.00001');
  t('-62439170169', '-95553672963354588648732705658818406500035091176441853597', 18, 6, '-3.14159265358979324');
  t('823681.488', '8858128.888838888888', 17, 3, '0.092719329601541061');
  t('85', '5314821.2112', 8, 6, '0.000015993012');
  t('553580700475', '644111111111111111111.77777777777777797997167909581426129381333333', 15, 6, '0.0000000008594490778463');
  t('6', '-1401959.5961241504692175591', 12, 0, '3.14158837387');
  t('21.9394', '0.0000087077', 14, 1, '1.570795929897');
  t('4880180155.18079581724378965502409426692247301', '346', 2, 5, '1.6');
  t('70501761.5', '0.11219', 17, 3, '1.5707963252035888');
  t('165000507.00802', '-9527999.996999499', 11, 6, '1.6284775478');
  t('35383790875589', '0.6', 10, 6, '1.570796327');
  t('15444444444444444444444444144.444444440444444444444444444444444444444444444444444', '7555555555.55', 10, 2, '1.570796327');
  t('58.4', '577510297001528277163819039859368375023785506618', 2, 1, '0.0000000000000000000000000000000000000000000001');
  t('0.879634', '-5999398799.998', 11, 1, '3.1415926534');
  t('18888888888888888367407555555555', '2333333333333333333281111111111111111111', 8, 4, '0.0000000080952381');
  t('679912222222202.222022', '20618214', 9, 4, '1.5707963');
  t('985768835329027577777777', '988888888888888888888888888.888888888888888888888888', 3, 6, '0.000997');
  t('0.13579719182904961200782885388171959', '40000', 7, 6, '0.00000339493');
  t('70369099999.9', '48417', 17, 4, '1.570795638751423');
  t('0.028706713691', '64.19', 20, 0, '0.00044721470286975516599');
  t('0.72368034253736', '899999994780884418555555555555555555555', 4, 4, '0.0000000000000000000000000000000000000008041');
  t('232023923217', '0.35404', 12, 5, '1.57079632679');
  t('89.56466352212148', '1.4220183', 16, 3, '1.554920659147802');
  t('9562047.05298192735564', '44740815335555555.777777555555555', 15, 4, '0.000000000213720894026331');
  t('68847858552146171849959435278665381385121539991737485699789847639', '31176695442538711111111.666666666666666666611111111111', 19, 5, '1.570796326794896619');
  t('6.5', '-0.6749182', 3, 1, '1.67');
  t('0.0000000532372342030311778219967031911242064028923898968191', '2099.99999699999993099999999999', 2, 4, '0.000000000025');
  t('-29999999999999948564133.88403069751247060547420643478', '10000', 6, 1, '-1.57079');
  t('6.3', '88129378993834442554.7798717', 8, 4, '0.00000000000000000007148581');
  t('599999999597.9999919', '0.7435479673704224321964182171072929384687381276323790094410316604197925', 17, 0, '1.5707963267936574');
  t('6.27', '0.40659151247037198885', 21, 2, '1.50603986427756669687');
  t('-21165321', '818128680020.1', 14, 1, '-0.000025870405856885');
  t('419', '0.11996851553056586971627', 15, 2, '1.57051000576327');
  t('539999999999.99909999999799999999979498', '6970213.000000000939741', 9, 4, '1.57078342');
  t('5982980908142359758745222149562532044.42309626976992393808368', '62336004000000000660.0300000000007', 27, 0, '1.57079632679489660881243436');
  t('562819249600000000000000000000', '5', 2, 3, '1.5');
  t('0.000000083490302676705187652', '8154950', 16, 4, '0.00000000000001023799075122535');
  t('9139734786791.7379043772496891390336', '2399999999919949999999997999.9999999', 29, 0, '0.0000000000000038082228279569108923980033427');
  t('-8863.31333', '8965742289799323971', 29, 6, '-0.00000000000000098857551817925199468953614107');
  t('646133725.2865829353688', '959666666666666666666666666666666666026666666.66666066666666796666866866666666666666666', 32, 5, '0.00000000000000000000000000000000000067328974500164946373963181660299');
  t('656000000.00000000009', '56928316454824', 2, 0, '0.000012');
  t('0.03629793847', '7005960667448530394805877944398329328117642.6955673951', 35, 1, '0.0000000000000000000000000000000000000000000051810080291557195553964650198652432');
  t('1000000', '76619994516457966111111111111', 30, 0, '0.0000000000000000000000130514235391285510166835690223');
  t('50000000.00000000000000000000050000000000007', '731923379', 8, 1, '0.068207192');
  t('6350000', '45', 36, 5, '1.57078924018072350951502351531135453');
  t('133', '73949.46732', 7, 5, '0.001798524');
  t('-23.9452582', '456350898364817749967', 4, 4, '-0.00000000000000000005247');
  t('653999999999999999999899.999999999999999999999999999999999999999999919999999999999999929999993', '8', 6, 0, '1.5708');
  t('0.4696126956620913702452175874', '70.7', 29, 0, '0.0066422318150328625633074037498');
  t('0.364445', '811111111111111111114072370201707590208043701553044444444444444', 34, 0, '0.0000000000000000000000000000000000000000000000000000000000000004493157534246575342449349502418641');
  t('-0.0000000052359006931491362608065430621330679882401940730812728248609', '-974', 4, 0, '-3.142');
  t('57698901906.9297', '981', 39, 5, '1.57079630979283994955004386873819961239');
  t('4160742881986563', '0.85973946034741104993576118', 14, 6, '1.5707963267949');
  t('994541769505557.2411661', '0.170083072554569509762017', 10, 1, '1.570796326');
  t('-711', '-45027710092211526765264608', 5, 0, '-3.1416');
  t('14.130295294', '9999999999999999999999999999999999999999999999.99999999999999', 29, 5, '0.0000000000000000000000000000000000000000000014130295294');
  t('7537661534862.99999999857669733347', '0.60290165167262', 30, 2, '1.57079632679481663399334249947');
  t('0.499999999999499999', '40', 22, 0, '0.0124993490193491803795');
  t('-703638515', '-626.02420098737845069053', 34, 4, '-1.570797216490653235415517383592167');
  t('4377761947049111.77777777777777777788831', '84922222222222222222222222222222222222222222222222222222222222262222222222222222222.232', 6, 3, '0.0000000000000000000000000000000000000000000000000000000000000000000515502');
  t('9.2322767', '700000000000000003000', 28, 4, '0.00000000000000000001318896671428571422919014265');
  t('0.535', '0.7464770174643088536054941461628799421212977869203', 13, 5, '0.6218462404717');
  t('-0.002073613262493', '-487826783751422981641835054736981551589093549130806746653783492181633922401954', 26, 6, '-3.1415926535897932384626434');
  t('27777.7777777777777741358579188507196343065620564', '0.3960800000000000007007000030000730010004', 31, 0, '1.570782067914897585582488387695');
  t('49045034.01413637332255191929245526302399992975192521546171389548677', '629999999999999999999999399999999999799099999999.9999999999999999999999299', 37, 1, '0.00000000000000000000000000000000000000007784926033989900527389200952700232853');
  t('0.3524562187568585061488996821987173805469245688135416574164', '2333333333877339163450565111111.444444444444444444447', 10, 1, '0.0000000000000000000000000000001510526651');
  t('-45254225215943888994768.30718187896231', '-4899999999999999999999999999999999999999999999999999999999999999999999999999999.99999999', 3, 3, '-3.15');
  t('31150745723902979335.88888888888888888', '9', 20, 1, '1.5707963267948966189');
  t('411111111111111111.44455147650538', '0.75130157365783518836839878776511986819148649178412246853', 16, 0, '1.570796326794897');
  t('0.390201064771592903596972929445', '429.999999999995999999999999999999999999199999999999999999', 25, 2, '0.0009074440875983279764663817');
  t('0.5150742741', '-5448', 2, 3, '3.1');
  t('7.0399', '0.000000009220111329055817309948360006115', 15, 1, '1.5707963254852');
  t('83.5513', '0.70545888267142660863', 19, 3, '1.562353105456501657');
  t('0.00022189434236501', '0.631722516742541', 13, 4, '0.000351252848139');
  t('95', '83847.496', 37, 5, '0.001133008901651709420752001468945723075');
  t('7000000000', '55197697604778.2366024947701', 9, 4, '0.000126816883');
  t('45.55555555055555555555555555555555555', '81516236', 6, 0, '0.000000558853');
  t('0.00288', '7211111111111.121111111111111051111611676', 16, 4, '0.0000000000000003993836671802768');
  t('8000000.000000000000000000005', '99800000000005000', 18, 2, '0.0000000000801603206412785491');
  t('255243968461810000000000000', '4055515443127923293789272670275709789971692', 9, 3, '0.0000000000000000629374914');
  t('1335570', '5000', 9, 0, '1.56705263');
  t('67807', '37100000000000000.200000006000000000000000000000000406', 8, 1, '0.0000000000018276819');
  t('0.0000000518049177', '-31111111111111111111111111111111111111.11', 24, 1, '3.14159265358979323846264');
  t('0.0000044634', '7952827463032853097062482701', 16, 2, '0.0000000000000000000000000000000005612343560510062');
  t('83700000000000000000', '8444238941777342317286032980419068584.3333345081402708739005130524147573974641822132', 2, 5, '0.0000000000000000099');
  t('8053373343', '67188849974152', 26, 2, '0.00011986175247129563767137035');
  t('-941941935858540705045.777709101535556', '0.958510507217164895749', 33, 6, '-1.57079632679489661923030410183859');
  t('5460579334603327826262.838', '9235092.131409718618959255931202012040764996908998636391', 36, 4, '1.57079632679489492800195471082245905');
  t('6886029306687777777777', '19999999999999999.99999999999999', 1, 5, '2');
  t('145299999999999999999999999999999.9999', '0.828', 4, 1, '1.57');
  t('-0.000004124767332368', '-6.6060090003', 17, 3, '-3.1415920291935304');
  t('422022224.2202222222222222222222222222222222222222222222222222222222', '30700', 26, 3, '1.5707235818109030112311289');
  t('7934621315846250909.4016054220341498', '42222222222222222222575999999999', 23, 3, '0.00000000000018792524169109541627372');
  t('47963500.0060000000000000002', '7179724', 6, 3, '1.4222');
  t('-432.496118648699465', '-4421', 36, 2, '-3.04407528459992051119254743732988688');
  t('82.462947', '0.46586903083612348206771698', 34, 4, '1.565146952237759875958487288540194');
  t('13076.480444', '9.5', 32, 5, '1.5700698317437754369739020981625');
  t('8', '11986717716726.599066422471014058913704803540990193918847', 10, 1, '0.0000000000006674053889');
  t('-0.728474579975813791067434772029', '9.2', 35, 5, '-0.079017154385054914064666104583882902');
  t('79999999999999999999999999999999999999999999999999999999999999999999999.899999', '0.90198569647534035813532384300735177', 30, 0, '1.57079632679489661923132169164');
  t('10000000', '542', 12, 1, '1.57074212679');
  t('7.99067012889653425', '511958331313477782', 6, 3, '0.000000000000000015608');
  t('0.5050119789596828575300523017582073014908919079250126179019047345288114283', '7', 16, 2, '0.07201979091122035');
  t('6.41723747', '6749484357377.9905612684085', 23, 6, '0.00000000000095077447849556016405385');
  t('88.38', '0.322156132554204577122836268', 28, 5, '1.567151218108055198381347945');
  t('0.059681014103381591', '2961405538.151', 11, 5, '0.000000000020152935265');
  t('-17.2', '-0.10955', 29, 5, '-1.577165426718243624125638317');
  t('874', '3584119489', 28, 6, '0.0000002438534771740649062952208662');
  t('38194444444444.44444', '2811.6904', 17, 6, '1.5707963267212815');
  t('72864512.0149', '64060101', 27, 6, '0.849610918740306264987045524');
  t('-63721081.29', '-74299909.369691999999', 38, 0, '-2.4326914416377803147757618064092051615');
  t('43262300', '77671330770405559', 5, 1, '0.00000000055699');
  t('8.627', '50000000000000000000000005100060060', 24, 1, '0.000000000000000000000000000000000172539999999999999999999');
  t('0.5963271665340185112', '58412600000000000000', 32, 3, '0.000000000000000000010208879018123119176342090576348');
  t('3022130195.40104', '-699999999199999999999999909999999.99999', 23, 5, '3.1415926535897932384626');
  t('5303000000000000000090000000000000003000', '0.09146604913142', 2, 2, '1.6');
  t('100000000.00000040080000001', '16118944', 23, 4, '1.4109815299015823466095');
  t('38888888888888888888656666666666', '6363', 31, 0, '1.570796326794896619231321691477');
  t('-5718250265604382450', '-8.1221', 33, 3, '-1.57079632679489662065170373557633');
  t('999999995930652366969109975', '0.82875548', 25, 0, '1.570796326794896619231322');
  t('65511304482.461771037219263061108232680717', '7666666666000000000000000.8644444444444444444444', 23, 5, '0.0000000000000085449527593250095056656');
  t('0.3941', '0.78535089490343347', 5, 4, '0.4651');
  t('0.3808', '5367074625702093762374389367806', 22, 2, '0.00000000000000000000000000000007095112823220445820329');
  t('799999799999912999299999.99999999997999', '643201.925', 30, 2, '1.57079632679489661842731908439');
  t('399999999999999921740236232048232573174', '0.12988771', 31, 4, '1.57079632679489661923132169164');
  t('427.93', '0.000709', 18, 5, '1.57079466998186645');
  t('263051765790724555648382977335029730164687329496736978442860021413', '-31327662827140084173926138691943913985366593.3355806384948212', 26, 0, '1.5707963267948966192314408');
  t('3000', '5555555526626938594227121804566775201742534056', 14, 1, '0.00000000000000000000000000000000000000000054000000281186');
  t('96349.5', '5', 29, 4, '1.5707444323896790351458372541');
  t('900000000', '0.631567', 7, 2, '1.570797');
  t('-0.74', '-38', 31, 1, '-3.122121430451231231383166703115');
  t('0.0000000014745244', '0.0099', 34, 2, '0.0000001489418585858574844992131096198818');
  t('7978922430682.742', '20000000000000000000000000000000000000000000000000000000009000000010.0000000000300333', 9, 6, '0.000000000000000000000000000000000000000000000000000000398946122');
  t('0.31683308918712856539265368348792449612529683651817461449707106045122662153234365648236', '0.00000081513065354', 28, 4, '1.570793754050188579069772893');
  t('-73162856237.47919', '2546', 21, 1, '-1.57079629199581781159');
  t('969999.99499999999999994999999999999929', '0.845986571459091', 7, 0, '1.570796');
  t('6991676', '1555555555555555912602856823366666666.6666666', 32, 6, '0.0000000000000000000000000000044946488571428561111985570497304');
  t('9682998416193', '78', 5, 6, '1.5708');
  t('4', '-0.9489647036973', 32, 5, '1.8037311088875706056105018840232');
  t('900000000000000096852401302738387', '5999.9999999999999999', 5, 4, '1.5708');
  t('66968164199519155158990', '0.5706740769217872906872841651415116808', 13, 2, '1.570796326795');
  t('1634332076219217662230944093502324458815131179273696099571685', '9811', 2, 0, '1.6');
  t('-740301920274801246745774560762330268216384178993862982168685982408876856125117', '700000000000000000000000000000000000000000000000000000000000000', 29, 1, '-1.5707963267948956736711646409');
  t('22.7', '0.000819949123', 10, 1, '1.570760205');
  t('0.04902', '11111111111344839.994442403253589581730717254587386841048901889149', 14, 2, '0.0000000000000000044117999999072');
  t('6403', '833333333940055334608093111', 34, 1, '0.000000000000000000000007683599994405829001279234875364981');
  t('-640760628', '-811111111111111115118251749366613960776845618329465596466333333333333388.33', 26, 5, '-3.1415926535897932384626434');
  t('184663342', '0.9492161', 22, 2, '1.570796321654644689859');
  t('70521493.1626001', '4140868', 23, 4, '1.5121458544561527392171');
  t('1312703162387150251', '334666666.6666666666604668166666666661666616796', 12, 6, '1.57079632654');
  t('313717235.946196231067663', '-38371086260060050208565051142089', 27, 1, '3.1415926535897932384626352');
  t('6', '5617', 15, 6, '0.00106818545806649');
  t('773559', '466', 9, 3, '1.57019391');
  t('0.0739', '13.285131', 1, 6, '0.006');
  t('933333333333333333282006000', '-0.3050995223716247182436', 11, 6, '1.5707963268');
  t('38199999999999999999.3404', '7144270241170638611392893944553280', 21, 2, '0.00000000000000534694219430040247384');
  t('5.566', '21.49482458', 18, 4, '0.25338059457177459');
  t('0.42', '0.6454542256567', 19, 3, '0.5768703495516482206');
  t('-6787.538178', '5626573517472222222222222222222', 20, 2, '-0.000000000000000000000000001206335997729813602');
  t('0.340076551907', '234035028867', 9, 2, '0.00000000000145310108');
  t('0.000838297817599865926864163309605652676788139517982002476908522680686751', '81.697999595', 21, 5, '0.0000102609344381272958488');
  t('0.2153', '9', 9, 3, '0.0239176604');
  t('52202450', '64731284666', 1, 4, '0.0008');
  t('8.208', '80.9', 10, 4, '0.1011125923');
  t('97722151513070236666.21811081663', '0.9899799399999999909999', 23, 5, '1.5707963267948966192212');
  t('7679755070666787109', '74648', 32, 5, '1.5707963267948868991296630955458');
  t('523567.7044403', '0.660777777777', 24, 3, '1.57079506472740816894896');
  t('68958572525.5433', '0.000000677119034945732293948820487008543522088096686303106884126333973432749658820338', 36, 0, '1.5707963267948966094121069059085482');
  t('0.6566791973', '801980056.94486167594213', 10, 1, '0.000000000818822353');
  t('482.9583917', '3789299999999990979.9669909999', 32, 4, '0.00000000000000012745319497004754166522200204638');
  t('-1949659070.376644484034863272798121513664062994778943096558824', '-8886.815614', 9, 5, '-1.57080088');
  t('4431377.27042127436917590315254309483378721', '0.8', 15, 5, '1.57079614626412');
  t('5961799.99', '911.2324', 16, 6, '1.570643481614845');
  t('0.934752030615316', '96689240809', 23, 2, '0.0000000000096675909624921543632344');
  t('-922222214222222222422222232322.222662222222222227', '874665.89', 31, 0, '-1.570796326794896619231320743207');
  t('287898159259', '778880.8888887888888888868', 37, 5, '1.570793621390697816456286761436479132');
  t('1216986674408109384277303994202349851322550729232601464617197535382.888888887788894209076', '91641406110048360', 13, 0, '1.570796326795');
  t('862.740845', '1000', 29, 4, '0.71184443469461056391740090478');
  t('-926072566053233004073285', '0.00000000599211109347', 5, 0, '-1.5708');
  t('9986.5203655', '7171111111', 1, 6, '0.000001');
  t('225.87560703109227408454', '0.88758646183059468848948231433988', 29, 0, '1.5668668104338539029165076205');
  t('0.9190502292705932910124493077853095022286775795149946411396448', '2101658249768616009892130860834432476864120339771823329473169', 27, 4, '0.000000000000000000000000000000000000000000000000000000000000437297657395904861242562965');
  t('0.4552621802829191051015900362683019948', '-32960803465025234145079948014376198384934309721500000000000000.26967294829485318777777777777777', 6, 3, '3.14159');
  t('29.999', '0.8050763475', 16, 5, '1.543965993928448');
  t('88889097384382106698025391343599514.60032949411735283738602699668750678', '0.04736', 33, 1, '1.57079632679489661923132169163975');
  t('999520951544273413368092334552401740154932988', '24809120297367542075258699406593', 13, 1, '1.570796326794');
  t('813873507649546526', '4.31665946310955152589402274708327', 20, 3, '1.5707963267948966139');
  t('43304119648082849952688', '879999999999999.999999999999999999999989', 1, 6, '2');
  t('641111141.1117111111111011155111', '1552.10005', 32, 6, '1.5707939058417256829609475971151');
  t('2.858320224', '77921.02', 36, 0, '0.000036682274214556718488071936068165058');
  t('-0.0000741', '0.8', 16, 6, '-0.00009262499973511132');
  t('51514.48', '0.000000064386793233830955427947954', 26, 1, '1.5707963267936467416583784');
  t('-897898654744374829341275817227823.3337213505304276068495476987', '5493878166214853350327765989051441094274659966523', 68, 4, '-0.00000000000000016343621528888123707284440587275777372063234100086558050135164781429');
  t('57725.564', '0.446959187807178770400687410674', 68, 1, '1.5707885839656052805303854194973888134360825156402291636716918121543');
  t('787846777122986402148649046024343425', '3494310823124439062970422012170.9324176672721964560857', 52, 6, '1.57079189152788205854518597399366633685361469016492');
  t('2523793333333333333333333333333333303333333.330333633333333333333333333333333', '0.0000005847750268704', 33, 2, '1.57079632679489661923132169163976');
  t('-5047640698785529', '-792691634849513080555342777847666887217887', 28, 6, '-3.141592653589793238462643377');
  t('947405117470.397399028771869', '0.89351904374780104842539682802731561624122447523995143501602058431961893055', 65, 0, '1.5707963267939534967726489687470164988839147693362400193256076666');
  t('0.73981360657233059', '97648554156675716240.187114849852578', 26, 6, '0.0000000000000000000075762883840073062525170162');
  t('66.28183', '5', 31, 2, '1.495503473971283236931882809234');
  t('6', '85050664469073.174660813925577455996817617', 28, 4, '0.00000000000007054618605809681327727291163');
  t('0.8319617308318998023232204795714927228863899', '7.7969995790929', 16, 3, '0.1063005951940995');
  t('49208.4509', '28996522049382111111111111.5555555555555550732287872912893674405770869374', 31, 5, '0.000000000000000000001697046660154492089344744646408');
  t('8689.21095', '4269907811927647439162392448190057', 75, 1, '0.0000000000000000000000000000020349879511982392629564502068302034085439986737311111007223088238051221344');
  t('4.0000006004000000000000000000070200010000000714', '-644444444478444240001463792772198644166566230640', 24, 3, '3.14159265358979323846264');
  t('0.235046402741794215627875733797444239550331806761511', '0.09354645439157534048835319238174296107473583143507343', 49, 0, '1.192022672269026110071373409205873506304496249814');
  t('0.60000438128007706956169305392757', '50682094179408222', 52, 0, '0.00000000000000001183858699990054130196796450643756666625288800476337');
  t('16273386611850313635381626346981510285924094877', '830.5', 6, 2, '1.5708');
  t('-7813.344', '-0.101744241773202522452', 72, 5, '-1.57080934865106568738467022857792299672448149768669427867474943259370629');
  t('0.38', '0.594599814920383974', 60, 6, '0.568664012785082634784314551280343894029549188690062607436198');
  t('93333333333333165517836294237943615448498575', '613.9895', 69, 2, '1.57079632679489661923132169163975144209857812122862433904707264592338');
  t('0.3246', '73038492241055666666666666666666.5555', 68, 1, '0.0000000000000000000000000000000044442319390807344037661791786520135349230695663651444087006145281737');
  t('-406.57', '-8778255251.85699', 42, 1, '-3.14159260727421134489761668120485281273039');
  t('50000000000000', '5080813463339358257878281554.717422315132024007818', 21, 6, '0.00000000000000984094384900672241813');
  t('0.000002179', '0.96673424450364607019651168', 65, 3, '0.0000022539803595300194681114148797071884158023887874845052495041153913');
  t('8622400540362.94871556929', '541447', 8, 3, '1.5707962');
  t('0.138189319113511347137924930418', '139753794626037234827306926400055829815083121111.111111', 51, 2, '0.000000000000000000000000000000000000000000000000988805488132095315892765838171563172379750966521774');
  t('19.999999999999999999999999999', '9542458972.501172704181748223', 80, 0, '0.0000000020958958333103320141004224442168791368325664782132264778620499262973695568527535');
  t('410700.701', '0.606668785863895019212099055085195487849958312455', 67, 3, '1.570794849639429423050979274694933539195837268137961437640950996861');
  t('0.476', '6999999.2222224911910766620573', 13, 6, '0.00000006800000755555');
  t('-34048362989387869277964355581', '-0.0008996784466828404717445418820716869503745427219', 63, 2, '-1.57079632679489661923132169163977786564343950667442283213359426');
  t('0.0000000698418653331655967', '0.8947132038', 65, 5, '0.00000007806061767786046709112137453371027329182230515078814751205746518');
  t('114229667550682.7178796822784', '0.6608784777363760663334650566027697485717134025', 17, 1, '1.5707963267948908');
  t('73368353.8888888888888810504146631786', '445140940.9309324958156678733323764594643243206053835', 64, 4, '0.1633518742891569177244761578885171295189514744773156389661261091');
  t('82850854585', '-8273344452845283560427471.768708480985', 35, 6, '3.141592653589783224271277700833399');
  t('717', '615', 35, 3, '0.86182558344419964364716468649112431');
  t('150001902000.08', '7.858242722757673749482220803657875450244', 28, 6, '1.570796326742508998687993629');
  t('56541283389999', '2874933333333333333333333339333333303333333303333333333333333373363333.333333333333333337', 26, 3, '0.000000000000000000000000000000000000000000000000000000019666989399174125776829607');
  t('-0.00270026629', '-8862100000000000100000000000000000800000000000000000000000000008000000000', 15, 1, '-3.14159265358979');
  t('0.0909963684278308881356657211097', '5274.48717', 8, 4, '0.000017252174');
  t('295056345973736.54669757424146971983563162', '0.7039723886049016', 30, 4, '1.57079632679489423333995480145');
  t('62337.55466065806761422', '2522222222.2222222222222222200225222222222', 44, 6, '0.000024715330036638166652060657233169860764148856');
  t('-0.15876124936', '8955044444444411111111.4', 49, 2, '-0.00000000000000000000001772869474237990404673686859752397572702732092879');
  t('5', '9009076330.51', 3, 0, '0.000000000555');
  t('0.69130296174593221057981513', '6444443333333333333.4444494733586153883333333333', 15, 4, '0.000000000000000000107271167731467');
  t('44680208.4041379899', '7000000000000000000000000000000000000000000.000000000000000000000000000000000005', 12, 3, '0.00000000000000000000000000000000000638288691487');
  t('-80000000', '8.3333333333333333319', 5, 5, '-1.5708');
  t('155.86990399999999', '130934.482', 22, 2, '0.001190441417636709863953');
  t('55159964107862172526.59611662529658', '84816547626853206983495770333878447.817757370500119194511024', 59, 2, '0.00000000000000065034436853685778396060322836618901826619037415274281887734');
  t('8399999999999999999999999999999.999999999999999999999999999999', '560000000000000000000.0000000059', 42, 3, '1.57079632672822995256465502497318354086331');
  t('8747.7171716145707545766828188434', '-4817234351', 65, 1, '3.1415908376687617468072037426025807012111991975531273987932576975');
  t('4207187731399', '40000000000000000000229440352', 32, 1, '0.00000000000000010517969328497499999939668835373');
  t('0.505090515538355263937759890757567437744214479108', '8669999939999999999799999999999999999999.999999', 69, 1, '0.0000000000000000000000000000000000000000582572686313484869469804568976545039207474977843873167795544398243511');
  t('2394', '2933042.5', 57, 4, '0.000816217108468118889984138681023786366426898906900808600709');
  t('-539', '-463506809059574', 60, 2, '-3.14159265358863036449948932107775632979987627215871175593542');
  t('8', '34771777077777777777777207777777777777777772777777777777577777777777777577777.7', 24, 5, '0.000000000000000000000000000000000000000000000000000000000000000000000000000230071646384524397891345');
  t('9202000000000', '8888888662058000834208351556222', 77, 3, '0.0000000000000000010352250264173638588515858855529819563233852487199192841197380968985626263798');
  t('8384', '50067665418491', 46, 2, '0.000000000167453383933967479889698294164970545928036606');
  t('-0.0096650112713053846', '5.569159654804851541228911178985448881121', 65, 6, '-0.0017354506186537126487125042760001812877167763068882219911772241614');
  t('3850999.99999399599949999999976', '0.09404893269295268655', 65, 6, '1.5707963023729457770866067456137467263069177156624754981170173206');
  t('72', '820775266218', 72, 2, '0.0000000000877219416366728291773605174674783866759527644802602635722988756877042285');
  t('0.07940651574854280592952225419183', '7798.55655555555575553555555395', 28, 0, '0.00001018220681995705597119112577');
  t('2999099999999999999999999999999999979999999999949.99999999', '-53.2348', 69, 5, '1.57079632679489661923132169163975144209858469970530316889832888646433');
  t('199399999999999999999999997999.99999999999999999999', '307380.248169', 22, 3, '1.570796326794896619231');
  t('0.13587828986565947904698163270905972434', '7000000000000000000000000000000000000000003000000000000000000000000000000', 51, 4, '0.0000000000000000000000000000000000000000000000000000000000000000000000000194111842665227827209973761012942463342857059666353');
  t('80669.812870108112208205', '3005546956024728', 48, 6, '0.0000000000268403102830925809749702393556352306894679075188');
  t('2513496378990548006080980268466700824', '2564007187444453449093812715797821774955852745108', 46, 4, '0.000000000000980300051926044100770925592432144521368379368');
  t('0.18010000702', '4672276073644403572947705660178488072021.78441766440589398141169253050299259590121813', 72, 6, '0.0000000000000000000000000000000000000000385465251156533021696628111332831874070723326920768289052719210101664011');
  t('8700000000000.00000000007000000030000004', '1888888888888888888885062505555.55555555555555555', 13, 2, '0.000000000000000004605882352942');
  t('71890445.90563298279624029270725221', '0.000001090051583746583950007465157227996666044002068948879023179146542', 71, 0, '1.5707963267948814565546959625336056450770273032661049665475562436220387');
  t('-0.02', '-7298528041', 21, 0, '-3.1415926535870529599');
  t('0.436354155424978418245846922444423565152727720923742019227068912', '7975999999.198659290066582940860087396827790079638532945397148056', 16, 2, '0.00000000005470839461745468');
  t('1', '0.00000000695709', 80, 3, '1.570796319837806619231321803883357315860524440059072154894112275839238247732918');
  t('0.72136203078', '5474362296194094550090482.923793727492090221025843204529862385923', 19, 6, '0.000000000000000000000000131770970160580686');
  t('731311.93', '385', 18, 1, '1.57026987570249844');
  t('552.08', '2771095806', 66, 3, '0.000000199228045022703446597396240333679928845038245453175541728276674462');
  t('716999.9999999599796999999999999991999999999999993', '3045400000000000000.00000070004', 1, 6, '0.0000000000002');
  t('22.444444444404444444444', '0.8326894326878041279412076', 52, 5, '1.533713310159717755995025221419523541262221167291561');
  t('-85555555555555555555555555555555555555555555555.5555556555555555555555', '-9.784', 12, 1, '-1.57079632679');
  t('0.271689365049798215305422610175534246120492665801364768824', '0.00000639228604464693506', 6, 1, '1.57077');
  t('9800000000', '333271222695648829749747890684365623964338093639', 39, 1, '0.0000000000000000000000000000000000000294054791791897135983919384952858393401');
  t('4499999999929999999939999999991999199999999999999999.99999995999999999', '7.863972', 16, 5, '1.570796326794897');
  t('6', '0.00000028167928621575529766', 42, 4, '1.57079627984834891660547323803119492936337');
  t('0.3249000705827196804', '0.7718128676342284', 54, 5, '0.398441257713642142729485937996462714300160707081982739');
  t('0.5593', '0.000676620931', 66, 4, '1.56958656351773661224055707452323576124727487210836199578867158488');
  t('0.0000087265426611852', '6', 12, 0, '0.00000145442377687');
  t('-8.92434', '88503263239117493.42120933', 17, 5, '-0.00000000000000010083628188814102');
  t('1', '664671777429332152402833736080035533881459524230179807170497605261107336988689', 2, 5, '0.0000000000000000000000000000000000000000000000000000000000000000000000000000015');
  t('0.8', '191257814057.39927238065635918285763', 54, 4, '0.00000000000418283563441705068372566203793977550448631727901941265');
  t('6991014.797500160035784', '946505104', 1, 3, '0.007');
  t('-97966.08824711', '-0.003559666787189616866676207056923022', 53, 6, '-1.5707963631306006458195782123690681635144390511258441');
  t('189333333333333333333333333.3333333333333333333333333333338333333333', '6.47346213934908352767460585419606355', 48, 1, '1.57079632679489661923132165744893028356469282816');
  t('0.94505786871819597246', '9111111111111182022734293197272050854049963311', 37, 4, '0.0000000000000000000000000000000000000000000001037258636398011896806803663621155943');
  t('0.7438518828075104881499', '0.76258237013165730785567339736049127777081956726098640526043729271895807', 31, 1, '0.7729651467167123554818440506437');
  t('83533182138147494870121987522346', '0.009392', 41, 3, '1.5707963267948966192313216916397513296642');
  t('362', '2506724706720', 64, 2, '0.0000000001444115498720519189272338674406980825379607219643558892774929407');
  t('0.9253862184671237368152794182787935', '12877819865812448178771914094.09710263695640835246083', 59, 6, '0.000000000000000000000000000071858919297652568050064399398015137322363818743953089739364');
  t('847789217337737', '0.5976', 26, 6, '1.5707963267948959143391294');
  t('-0.000307432687', '7124191139111299440532075106814928077188804754', 71, 1, '-0.000000000000000000000000000000000000000000000000043153346253193089223898304736433433133388464920941881358414811738193997');
  t('0.6', '0.0000000013528340815614620966244896461570376127273014', 69, 0, '1.57079632454017314996221820108643983025474406638597295509364460993816');
  t('0.00000000125789198203896836681457806116148088891998930658', '0.000867055605993776442129572577502712404610398948204958661', 37, 0, '0.000001450762757708430954351232085048048261');
  t('6222222222222222222222222202222222222222222222222229222222.22222222222', '7', 50, 6, '1.5707963267948966192313216916397514420985846996876');
  t('855555555555055555.5555', '0.49823191607458405702142065964532686704234862853363709091535', 6, 0, '1.5708');
  t('4900000000000001.0000000000000007', '71', 30, 1, '1.57079632679488212943540332429');
  t('0.000836037756216127544172538953313035458811065914777224', '0.8', 51, 2, '0.00104504681483015964680459559513497107917440131451763');
  t('45555557468736007923119843488087408928314026966666666', '755.555555555555555555555555555555555555555555555', 18, 0, '1.57079632679489662');
  t('-371105052082544116646941698', '0.52', 27, 5, '-1.57079632679489661923132169');
  t('30', '0.000387513702', 6, 4, '1.57078');
  t('88969719', '31998.667003', 75, 1, '1.57043666885753387160734748959060694517469349958597335775114594897262080956');
  t('0.190811111101111111111111111111111111111111111101111111111911', '915981763116.3083755645', 55, 1, '0.0000000000002083132206169071281090007134962444838288187667109815319');
  t('-0.97613492338', '1000', 77, 3, '-0.00097613461334690937183124824706676025511510522855069274720668193641126745792312');
  t('46711211111.1111211111111101111111110111711111018111111', '0.000000943924606019', 47, 4, '1.5707963267948965990236545477991978626225245004');
  t('522222222222222249887233252348593997199', '0.00044469624914679204', 18, 6, '1.57079632679489662');
  t('957778444444444444444444.44444444444444440395167888', '785388108310407536073619590474753683', 63, 4, '0.00000000000121949700321398727420969204332005559535881551765569513818335503');
  t('-866666666666686666666.66666', '-0.932941427215657334221659606', 7, 6, '-1.570796');
  t('5815914477777777777777', '21732449481235146381811645046.99999999999999999996082473392260187802', 67, 0, '0.0000002676143102414379150094699152789350675234261751374702332920930090893');
  t('78444560534111200373.23916949958', '5000000000000003388137027782617141636787288888888888888.5533111111111111111', 72, 2, '0.0000000000000000000000000000000000156889121068222294434110269496387135314997606932915552385376244082818539');
  t('0.8', '0.000000096690896107275021443171939148295677686', 71, 3, '1.5707962059312764851381334135202341776907724357527465371824278613215736');
  t('74313813150449442892949299008231728728590284597', '82480', 79, 0, '1.570796326794896619231321691639751442098583589799680072930504818936724207933546');
  t('0.3640478454413956', '26991849287468.3929524171920498244716354972778737149', 57, 4, '0.0000000000000134873250648451663456662059384555360296590059572293343928');
  t('0.910129910337889039851982244155368848722689712095885582577230458041015490054002', '0.463084746675', 28, 5, '1.100124232998932970365593437');
  t('0.8919', '155.29', 64, 6, '0.005743384590778067366763261861126063310613559614687803146870941563');
  t('0.99925339144017', '-66980033484813258242348786245385094.00245356395248', 25, 4, '3.141592653589793238462643');
  t('0.10369175554467917615854922309960767461520941133915', '44479.7', 5, 3, '0.0000023312');
  t('3.5', '0.000000008848987153603110470298528', 32, 2, '1.570796324266614575344718705513');
  t('0.3089534', '326841933099345383626137', 74, 4, '0.00000000000000000000000094526854944922851537915834177447643899722521803714565202692742365822704837');
  t('-277777711589906235083175000.51893625', '6050853048', 57, 1, '-1.57079632679489659744824552844814262348611839189934020474');
  t('2727734053456600109866.74210953941560655', '4', 63, 0, '1.57079632679489661922985527302209655112961231479316305424934257');
  t('6183616991936473787444444.759666840938775326408653850145723437948036', '96501', 50, 1, '1.5707963267948966192157157768287534933010781701336');
  t('0.3816782708148649427710242176191772147035994415192157489338265102978333', '28555555555555555555.8888888888895544444444444', 52, 0, '0.00000000000000000001336616512581239099182536756107034122967941904529539');
  t('2485561.90357258782385', '6825010000000000000000000000700000000000000000000000000000000000000000.3', 67, 4, '0.0000000000000000000000000000000000000000000000000000000000000003641843606928909736176210730453246145448836439020111690485834848328');
  t('887788.3333335580977668913612804444444444444444', '0.00000715112142335866980551512012042373518890511635831455180315436530052682457102384', 7, 6, '1.570796');
  t('-514852357057986062994865768056.010829047916', '0.358688631109424963897214146711028726612352', 68, 0, '-1.5707963267948966192313216916390547595910808502138101402121311883286');
  t('953621255039705357524', '600000000000000000000000000000000000000000.0000000003', 80, 5, '0.0000000000000000000015893687583995089292066666666666666666666653283688742851530036621539973169122178');
  t('6009059890752198994.931947559135', '81000', 69, 3, '1.57079632679488313958534168450358662012259836575823503355642788284945');
  t('6301777650264807527606407.79', '0.303429201177441790040853059436420969535391415', 14, 4, '1.5707963267949');
  t('0.508532029156598012762', '273000008000009000.1', 41, 6, '0.0000000000000000018627546309690263737429847096038681258029');
  t('0.1', '17655.255', 55, 2, '0.000005664036005083507613140391809154652922564053664617116322');
  t('9130434089206742874953209107471499.8505620008294', '17118972635542936816680469518.41781118950666352332280140228557', 72, 4, '1.57079445185965605279044999058586033621080492342904151489896211768597626');
  t('0.3', '486439999909999999999999999999999399999999.999996', 19, 5, '0.0000000000000000000000000000000000000000006167255983379354162');
  t('63333333333151751021975072199.2222222222222222226', '8590693135719081000000000000000', 62, 1, '0.0073721858013158475326612162814653787461267737439174487861026013');
  t('0.3', '2955555555555555415.5555355555555555555555555555555555555555555555555555555554', 54, 1, '0.000000000000000000101503759398496245409577259879021088172264979684906928');
  t('78.67058656222838307354', '0.5104050647482914960956486304887317342958181', 36, 6, '1.56430854113297639945343150045558517');
  t('558237752296994291889448880636637388506726206789', '8027039319494444444.111144444', 8, 0, '1.5707964');
  t('911625.23816', '56520624522828171304.1025054050358', 73, 1, '0.00000000000001612907227859456462743068858264105153760190997024045425386933591210809537');
  t('5266.67686464666261', '0.00000000167590885977528315984048072961617045513', 43, 6, '1.570796326794578409304484321748279794368215');
  t('10.888888888888888800000000000035892755468', '58005622385554', 50, 0, '0.00000000000018772126633711821379415126469879391357744988323783');
  t('0.4550302', '683434088778.25834857963', 79, 5, '0.0000000000006657996834975486880255779079976204211201004703240843475688893759711361422602403');
  t('0.0745267565134859474530048927022276067793032707', '0.050586420619636514529022', 20, 1, '0.97446220574663666057');
  t('800000000060000000000000000000000000000000.000000000000008', '144444444444444424446444444443.444444444444444444444444444444444444', 66, 2, '1.57079632679471606367577967777585903758478438008294954665446993905');
  t('4222222222367469117999999999999.555555555823012944', '98999909979999959.9999999999799994', 69, 3, '1.57079632679487317188422197193578891908046309743660965648351602275652');
  t('6616960060366.50251650564673', '579612605523231', 36, 5, '0.0114156810238153418573275479248302201');
  t('-0.6504641440112161552291909916', '24886142644444444444.444444444', 60, 4, '-0.0000000000000000000261376040997830198845481669370901826998725246766964726126738');
  t('99999999999999999999999999999999999999999999999999999.99999999999999999999999999999999999999999999999', '19086288866.2257012', 50, 6, '1.5707963267948966192313216916397514420985845088247');
  t('8197787231172738725.5774', '6.46892260834548356954709505752561186263393169', 68, 1, '1.5707963267948966184422157504966475762782739892124651803244416403843');
  t('51.0000009000000000000090000000000000000000002', '90772622330564.060653963225938303580188', 63, 0, '0.000000000000561843423607117534191261323924958111190584029202513323292374365');
  t('-0.0604954', '9111111111117444022222222222.3188953925937450263124142312222222222222222', 1, 5, '-0.000000000000000000000000000007');
  t('0.000005643770199768478098884083985', '349244.44644444374144444344444443444944', 57, 6, '0.0000000000161599425766853648363364073023958125293699441464356115652');
  t('5673730432.326424160414934768370361759553037165792', '65597145961.9207820332919443013', 118, 0, '0.08627882924504144252392276734222075412180818597682599869394468010538285299500589341542228404156281024092976034837551614');
  t('939999999059999999999999989.9999969999999992999995999999999999099', '37145067204920971793579468183662589324665184947345467800343057', 123, 2, '0.0000000000000000000000000000000000253061865220012031616992515601070666353812243972376901425105032672180959249727267706519135872452298317711183753842326560592');
  t('90675342005334806887442264791247186269473633710123648176765805468096', '106873.27921424606462606424603195644', 46, 4, '1.5707963267948966192313216916397514420985847');
  t('475.473345055726543480358', '612840.58', 74, 3, '0.0007758514451714584415747967396599570746683182533390873476901223817395948807');
  t('-38014499131339501012126880129168179993490051185475430006436599261441358462456512690', '6990907000000000000000200000000000000000060000.05', 127, 6, '-1.570796326794896619231321691639751441914683631417613973298550235689528271033190290020820541296084443635964775399337056335457265');
  t('57.9999999999999999999929999999', '19997999999999999999999990999999999999999999999999999999999999999999999999999999999999999999299999999999994999999999999999999.9994999949999', 155, 5, '0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000029002900290029002900286541705425673080359341063050072448797765938297308103342936252619934228226570671539489980203524521349560779021476290960965410594631222');
  t('388081539591508', '0.3600000300000000080000000000000000000000000000000100000000000040000000000000000000600070001', 160, 1, '1.570796326794895691591139736750577359980201797348419482301534281807518368049536303842930579449089623561438389027072889451021530866166889581732833385988629713477');
  t('74444444444044444444444444444444444444444.4844444444444444444', '0.0007892923483667236437054452542844278295922242621', 87, 3, '1.57079632679489661923132169163975144209858468908511838013123116532063990966422355575201');
  t('-0.014869942083264911', '-0.47', 93, 6, '-3.10996502894018623869273412665936651659583119825454705118276901585992591408747336451834235146');
  t('90000000000000000000000000.00000000000871538849', '0.0313112827186094571378276243115802208615294314390345397', 67, 4, '1.570796326794896619231321691291848300780701842600579307025469842171');
  t('0.3561516175756533509053437769606022684486111442975188882974713', '15188551817115235', 40, 5, '0.00000000000000002344868831894318850628511890292486056153');
  t('73545555555555555555.2222222222222222222818', '8.2290721711283041442169374009407381746209347811710572457', 37, 0, '1.570796326794896619119430876362516264');
  t('527570953437555555555.4444444444444444440798959077531660845614416733', '-336804713959173247808714881934', 95, 0, '3.1415926520233930915172339857266737549965681811528898816381529012984741153720703179623023182367');
  t('0.005945', '7295', 103, 4, '0.0000008149417409182568767149058509328072603537235396433119814988411859032687286426926288685603300363493277143');
  t('5109488042481583560594618955014760052217803368312700031656729319392325739', '0.519615', 71, 6, '1.5707963267948966192313216916397514420985846996875529104874722961539082');
  t('1434739683164837060899588741970428301109811340096', '0.0009273644299323217018673398694391347598993374702121570066366018717730230145916352617505325', 61, 2, '1.570796326794896619231321691639751442098584699687552264123229');
  t('706920127092661533733984414445.089890749840117091653824629520886729762', '-169872864336112104020726570795461221718265725321376430174.52335448815227579262668', 142, 1, '3.141592653589793238462643379118037014675228069660888940562869900100248330407950796643011954152084947410182517090756653781645877879342097596571');
  t('4075996728803502830728084267643655667846130396162730931065775207683738078056355767106192174147912066537115071583', '77375192357347218364695170045681693550', 77, 2, '1.5707963267948966192313216916397514420985846996875529104874722961539082031242');
  t('155555555555555555598994897038540406940755555555555555', '96666666666666666666667666666666666666.666', 7, 3, '1.570796');
  t('4600006000000000000000000000007000000000000000030000.000000000000000000000007', '53781964492385803857190739164330109945559913475216464', 14, 4, '0.085322987399437');
  t('-78554.752255337', '4383050152545578165087801332098875057621462246788747638205441138068067770199919506107475042865167740779850510330719650759108362481111111111111', 127, 1, '-0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001792239411399710881184209787283307230207222040239384487045680227529030969097655048737889667297741731879026792206937834579023225');
  t('3085950', '9.90993971032766390432233921213817192041660750004055193', 56, 4, '1.5707931154856692196952100900630498521067000388981372565');
  t('14000000', '76.475', 131, 2, '1.5707908642948966735629968208753661190832042756641792784894233165261746294274185996818711440256007598677828685147815670102366511391');
  t('211241676502628221219793186545403.486955273995091037', '96624112222847210433334940.22222222222222222222062488297919577777', 6, 6, '1.5708');
  t('154555555555555555555555555555555555525555.5555555555555555552555555', '-0.7860956628161953581884820771006389576759185736897752128', 28, 0, '1.570796326794896619231321692');
  t('575777777770.77', '524616934316417153899378645858026091229809910018942469690', 80, 5, '0.0000000000000000000000000000000000000000000010975203812683174359989646721816723660646622799653323065394581960537483832521191');
  t('960457811409', '2333333333333328110699.3333333333333333333307232064087151031745418999316615459943791920297070705240010758940605765', 158, 2, '0.0000000004116247763181437784477029995887971025546125122842574148198523447703490496341287183223586703348067900053478437583134541796800240456174338686954147874623490829');
  t('533333.3333333334', '922222220225222222222222222.2222222222222272222222222222222222222222222222222222226', 103, 6, '0.0000000000000000000005783132542643403275774685189819086375496165522251643741360961077125030599680489044060781791722759736505');
  t('-1213052935390720856136161603724893814945934800487116246890128261574986432718.66666666666661615563618122128976782073971012173735182265777947666666666666666', '-0.864965903356194138749427987164', 104, 4, '-1.5707963267948966192313216916397514420985846996875529104874722961539082031438175480838780545011058279672');
  t('299999999999999999999999999.9999999999999999999999999999999999999999999999', '8557565157217275', 87, 0, '1.57079632676637140204059744163975917897437655189852296386977663710403911156996803424225');
  t('672222212242222222222.222222222222222222222225222', '0.4755369359224074102457672369037381586014646118191591359349217629961588316582832', 15, 0, '1.5707963267949');
  t('6308094194416280698208660751199568253728', '92889558252169299144957894231545625455705206677758599211541447', 66, 6, '0.0000000000000000000000679096156027737856870165953753010327142869437910974946998524292627');
  t('26947777777777677777777777777777777.7787777', '300000000004291609999999.2668327565896732', 92, 5, '1.5707963267837639758468388049478826922782780286379596969497807279177871719387440424892054061');
  t('4111133333333333333333.130360235582450303783087', '1', 138, 6, '1.57079632679489661923107844971132943356890106434655179610369401341449147388184391523024067042532948214487486271087697842887765621904132833');
  t('9.387', '144718405926643364937168740.93824547790299923517696863', 3, 2, '0.0000000000000000000000000649');
  t('0.3000400000000006', '0.0001192436', 143, 1, '1.5703989011392442483258571456983611798893099597754989211615684357807274378942371392781848868210708820723949502580797752840609519432607061668651');
  t('-681448701858025247424232747157355982201956736129373600', '-50791264842224736352', 7, 5, '-1.570796');
  t('869', '4793567839326192888', 84, 1, '0.000000000000000181284594091016525343377660445478662522612819993521483805074083337360431488776090816');
  t('90722427', '250109201450074.30733359761676498214233600458243961256782112', 160, 6, '0.0000003627312648795355525836548960598901087358415310487994946053537784133694920967980387871503837710287762825207351628308969423837416889343063095931780370747970940778');
  t('0.48425', '286066857860650600996410581.265239755849636917586773', 83, 0, '0.0000000000000000000000000016927860977026871297216151139912118506162280894175756690957326871025564857192812457');
  t('-0.1691758430969448438509811426964238628160272424933623868', '38441799.999999999999999999999', 82, 6, '-0.00000000440083042669554606597039935244664201456941514146083394529179869242591136481959748');
  t('0.88743377830720141128', '44911704750205846465089.20035991581783170720630664', 79, 1, '0.00000000000000000000001975952111466296508610466879628778274945797855479921351164494570721828995531258');
  t('0.1390778769684090913204591819767278110546412548004433591511944600946897617', '277648656858155100000', 100, 4, '0.0000000000000000000005009131992288407646565860297151186680545668158106004180949699983160186063384049475224761533073680521');
  t('3164125884.4073964748', '8114246095554485455726642279.21714133750359864057137923492525024212836651396184814741323088', 16, 3, '0.0000000000000000003899469953395807');
  t('-905979636021967584802541909411156288', '588108692423205.42148522462645', 108, 1, '-1.57079632679489661923067255045705829671147845947102495531401582084282247801495938554022522074778853761054876');
  t('89050347044049581299381242480217.9999999999994058666666666', '100000000', 38, 4, '1.5707963267948966192313205686795012082');
  t('9384382790172389242876553396544966584953735032', '7064946.0405571683', 13, 1, '1.570796326794');
  t('4599999899999969.89999999999939999999999999999999739999999', '5', 38, 1, '1.5707963267948955322747763230120874736');
  t('981506679667634714879196539323100582275649736499268', '-2650656638416317072468924873980863', 63, 0, '1.57079632679489662193192138528004603453359070756740203353047978');
  t('586037818727633677314864284802161494978598191291944680271276', '6', 110, 3, '1.5707963267948966192313216916397514420985846996875529104874620579068049243806220019524784528637294712993274348');
  t('574154686971197550538045379511445947509305230954695364880561522114301766666666', '9888888888888888888888888888888888888888888888888888888888888888888888888888888888.888983', 3, 1, '0.000058');
  t('833333333333333333333333333.33383333', '72999999999999999999999999999999989999999999999991999999999999999999999999999999999999999.9999', 71, 1, '0.00000000000000000000000000000000000000000000000000000000000001141552511415525114155251141553196498842809782948770876337023831957236');
  t('96.3402996215634', '2491341', 127, 3, '0.00003867005744036718700608020885347968010326797283608601247338852900685567412910977952282838978925509735664135937710872195358739132');
  t('79426434555326.3494429931176377119', '5548816775921341335573752919169538232658846807822456', 33, 4, '0.0000000000000000000000000000000000000143141209671927143626968151771849');
  t('0.0000001062001393465405971229325030007729388770886693756636914', '336180147258451429388815475832', 90, 1, '0.000000000000000000000000000000000000315902471376143314757694174808693173283273948823278650621580500835250322789895234707102014');
  t('17617427151801129574689363188033188066316581767603884193280748', '677', 10, 5, '1.570796327');
  t('777929305385903021773103808998888888888.283', '-40000000000000000000000000000000000000000000', 99, 0, '3.14157320535716104287976885312267619645768364067945743283087352654351464091199938152996604492513107');
  t('8907343.731406520502608', '69999999979999999999999999969999999999999999999999999999999999999999999999.99999999999999999999999999999999999999999999', 62, 6, '0.00000000000000000000000000000000000000000000000000000000000000000012724776762787822650236520762663910259098755495558153325586862');
  t('250819996832', '1425.96710511181264829305', 51, 6, '1.57079632110967565151506039407607631548186473528578');
  t('79760705864752.590034378887191792353553', '221190358517212561113137148580429309410652.539149001962694775889', 78, 2, '0.000000000000000000000000000360597570343672020033321934731896312718728002003215497667573836712008129909233');
  t('122798561748895667178397457783.444444444444444444472095648194731410499440333333333333333333', '-945.8365052844807317724557186640488390163948025429', 93, 3, '1.57079632679489661923132169934209332472235802508353269925541974661360017811131128972503163371');
  t('0.73830769286468958435073517295112286023903480152273766669595572681884590535433972668550703545492219491464045399150541602953', '0.917623999507426932465698513285', 81, 6, '0.677531213135062401592793840240825045189043991067246346816601678059645864788559992');
  t('1111111111111111633339897942734048639999999999.536', '133333333.3333333433333333333', 36, 5, '1.57079632679489661923132169163975144');
  t('5700.00000000000000000000000000000000040000000000000000000000000000003', '9053383922385411111111111111111111.44444', 76, 1, '0.0000000000000000000000000000006295988382759479767686584736906823520722172984126494205649911271981775143551');
  t('69462003776525952004.82873978513336259191217', '-2105047991541417177490.2146508063500364663', 76, 5, '3.108606798098124987486589522268950807525528865381147185304423921904809805789');
  t('21502651556673465391', '800000000037086428911099356.1111111111111677452482981745', 134, 4, '0.00000002687831444459579939368497473656167704348943372435157380403092336836953977388157314889936582373761375733254907672175596268237428281521');
  t('58295101.3661564', '9014276912692376857288719996989653360072435291', 43, 5, '0.000000000000000000000000000000000000006466974770219796453090121711188861881498733');
  t('0.000027986163598924032135240167125334836421401534826111', '309999.999999939999999999999999999999999999999999999999999999999997999', 131, 5, '0.000000000090277947093320802619321729970060867654209409497293952095312278676879093851942569202176582229896070110363393868128598914321472256232');
  t('1677777777777777.77777777777777777777777777777777777777777777777777777777777777777777777777377777777', '-0.0000000844881959834018968468966965172841535602610106977118884808425801190268338295326', 16, 0, '1.570796326794897');
  t('8000000000000000000000000000000000000000000000000006000', '63799999999999999997995999999999999.999699999999999', 147, 2, '1.57079632679489661922334669163975144209883519968755291048750996522556979245768781671539418331651686543336534480039595056410471872099175729791181467');
  t('2032052379.533660371', '9008408762723954465975275104', 7, 3, '0.0000000000000000002255728');
  t('0.2', '9469271261673552962337073319785087973044680768761041181995638326388413209173674363694947160560', 51, 0, '0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000211209494873687853797993615699392199048835942769682');
  t('71.55597265318754617515924104647167', '32687182117249941794139638138438699428350927996277311883849594700166666666666666', 1, 5, '0.000000000000000000000000000000000000000000000000000000000000000000000000000002');
  t('7917115171105937243308628941722895758658223976929999999999999.450390885183551718818270879443416', '0.564649363488766750234765', 42, 0, '1.57079632679489661923132169163975144209859');
  t('0.4336936493051792780815993910992885681953915', '0.158091281', 39, 1, '1.2212425179878022825951292693078599802');
  t('5742961.654589856087140492362225516455', '0.0000000027199222763248884721736764675', 91, 0, '1.570796326794896145621633883418332506033922777514213210101555904194883881966593604855232504');
  t('-78888886224171912755965709735335521411984571782', '-0.498534065678868', 77, 6, '-1.5707963267948966192313216916397514420985846996938723566039027611058600343317');
  t('0.6328376942981936498122893081270007155361095980688154089352625410143947398933611259637713933', '200000000000000000000000000000.0000000000000000000000000000000000003', 82, 2, '0.000000000000000000000000000003164188471490968249061446540635003577680547990344077044676302145022031862778024721');
  t('451553999999999999999999999999999999999999999999.999989999999999999999999999999999999999999999999999999999999999999699999999999999999999999999999999999997', '2179867.74348135911361166458933762521651', 75, 5, '1.57079632679489661923132169163975144209857987220790821381971248965326965797');
  t('23426222.43534344425145662222849768340485901634018', '0.46054313928538489712145160781512802351887871', 151, 5, '1.570796307135596424482147905335846783823006287638693262592550565031361657573767104652245381862280952326045436262045850250404202828673857758486472770777');
  t('-0.1497472941964723767085196305363848611820341531317', '3229040934900', 136, 4, '-0.00000000000004637516129881762952577787416052408464521366012294824870465807107099736443435144845068432075065645176187810876643648311085549361656374495');
  t('0.000032692447567833842573995114541534118489314477714398466552', '0.0022', 50, 3, '0.014859109746820637986790873409593793749016563193617');
  t('7730861828375132811350247000000.9999999999999999993319180869413347342243262222462999999999999999999999', '877777777777410969870800672510711856872048', 94, 2, '0.000000000008807310943722186154910214377271911725279025605218195725746446089776178023186063708658209022537');
  t('3828303706471691807358.67584236187', '76991786666666666666666666.9471181', 98, 3, '0.000049723533756803596789369526555841609607593009368742702526784291424133637589727591964366293192372328');
  t('0.41834347007795242893541353025886699916756218325869383435691257192900010312670415771179083110976', '-30488888888', 72, 3, '3.14159265357607206050779155644255937070758927507630890116765983212129486');
  t('48593', '4309179095025896118957906682613978327.36105861733486651962234072281096', 31, 3, '0.00000000000000000000000000000001127662576291876751476713928419');
  t('0.47581826188573685726003970918', '855555555555555555555555555555552555535555555555.65555555557855755555555555555555555555555', 141, 5, '0.000000000000000000000000000000000000000000000000556151215191121001992254205535066885218560698571552601964723124881578373533198748699391477997457624648393615628224964789552854434863987261484');
  t('776.60227231438556807203685739788030324', '466789999999999999999999999999999999999999999999999.999999799999929999999999999999999999999', 28, 6, '0.000000000000000000000000000000000000000000000001663708032122336742586681072');
  t('27139682215199', '-0.427164292', 20, 0, '1.5707963267949123588');
  t('1.9999919099999999999999999999991999999999999999949999998999999', '29051186163666095402692866172', 148, 5, '0.00000000000000000000000000006884372633642620020902382710722442677137247841317792269570342620288713251473139165033654511267903218352626142519124947110977653846884115505516099859');
  t('38491043841097744449575392100945071907404967218658359676241425676528', '59043987605834390449010463723157588095252473817305820717026253139418448063232333333', 157, 1, '0.0000000000000006519045444229833623555503288339636905423544017830503855889069316196544203742443397919112990681700158318776030826848064430394828191821891516127833105686159603');
  t('0.6074549506040092741579463620868', '0.05', 9, 4, '1.48867083');
  t('-56779450399897004882363349', '511.11811435', 113, 3, '-1.5707963267948966192313126898246449167430133495294849852247521055740809031821768047190531457396686652970704373557');
  t('8.881755007257237531101', '9438888888888888888888888888888888888888888888688.8898888888888888888888888888888888889888888888', 10, 3, '0.0000000000000000000000000000000000000000000000009409746329');
  t('0.1775360797018436804481995866199008132528696238', '2134541741.399236596704501235335178042935', 137, 2, '0.000000000083172924782190054637956680268821411263301807557332046319038670331166563493870267580545000421380880700400363716858011980965313753991409867');
  t('2140047457312666701599', '0.5456', 141, 0, '1.57079632679489661923106674402252190214196666504398936751465911270705944239184106687266427790596262558577505903501072396278504462829253445676');
  t('-89961135870622830803787358', '76', 138, 6, '-1.57079632679489661923132084683049837420680449039074220384298956192084053122115227048875654497581999612486575090534529277690300325166909442');
  t('4555555555555505555555555.5555555555555555555555555555', '1089822022661392611.07680332', 2, 6, '1.6');
  t('0.8726791323027579456950604732259195501107960997', '3000000000000000002929999999999999992222222.9999', 67, 4, '0.0000000000000000000000000000000000000000002908930441009193149475812846700753198589613878379615146261296622223');
  t('44677458708296298642412526583539170855367999972661123354497647702', '0.2813082993', 50, 1, '1.5707963267948966192313216916397514420985846996875');
  t('9.5076339921662678402013966079168719314796561881009808391006', '7000000000500.0000000000000000000000000000000000004000000000000000000000000000000000000000000000001', 82, 1, '0.000000000001358233427355307303789105301352493989124336056047708383564917392787919552003428297');
  t('848.912153428727512869', '832565', 94, 6, '0.001019634333940315726772632377622140639370256538276208707182360984026112984172127168971511747794');
  t('217795211784534483814129645408727845424289432', '0.34835931732762728174886938219460524881301467637945876007851345858911808042449106918017864353410959192125394879815677227391', 70, 6, '1.570796326794896619231321691639751442098584698088071845346975566230882');
  t('0.00000092564277958644568', '8480917.1335976037346', 116, 2, '0.00000000000010914418393730822320359951450862500563042270598178031021647022687328484530020413339592263595157463697683328378560713');
  t('-2614625762.773926992', '-8777777777777777762297813220275902.4444445665842015493828628794333967176084502537534024594347515129753', 115, 0, '-3.14159265358979323846264308541074509982573940571712709182779139799998310282046188216661749156304405593514376290239');
  t('11461919629730759625228401864583149321678725486666', '17226517234187337656920949798550.5710395270065', 15, 0, '1.5707963267949');
  t('9529.293918618200264802550463', '45905353919161032205630754022545145497046199690516446146142949674734300007304687771328888888', 87, 1, '0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000207585675853827682708263182827545809266038764748858615790604964513256843313739024799265');
  t('4931807985367632068099641965788078631005357752013537766768', '855555555555598413566582634564820127827686295803999999', 24, 6, '1.57062284973546698757318');
  t('1222222222228888888888888888.44442222393', '4848876523102982610762027526118715837197167017831877659524059082945280135118167481506834710302193035792941259', 33, 1, '0.000000000000000000000000000000000000000000000000000000000000000000000000000000000252062970959454721933130800579175');
  t('0.65905283767', '91759850.797', 25, 2, '0.000000007182366056021824817912066');
  t('38646235317000000000000000', '392.99999999999999', 155, 1, '1.5707963267948966192313115224732912067296773433032539476990602090237296790832984949207476692734856765221786797531489432959335235165818886348595050722872649');
  t('140.59708495682', '704988273984913255331184662757601056412073990', 54, 0, '0.00000000000000000000000000000000000000000019943180637899344229614873265513076623127065032223688');
  t('40009000000000000000000009000000000.00000001', '-758225110518373.90616449122413807134072409179977555', 92, 6, '1.5707963267948966192502730553458769115220766903290535224896412087883935645583359372852522271');
  t('41111111111111111111111111111111111111111111111111111111111111111.11111111111111111111111111116', '8133333333331333333333333333323333333333383333333333333333333333333331533333333333333333333333333133333333333333.3333333333353333333333', 59, 4, '0.0000000000000000000000000000000000000000000000050546448087444123443518770412930772106492895889428882672235');
  t('0.25274843764119', '4652169', 68, 5, '0.000000054329160793855457814274352295189650194844158936888885081624957483648');
  t('2229285222205.9', '64259037060592496566.666', 55, 6, '0.00000003469216664581845690083434371364902493537833786639708567');
  t('-61787701764444444244444444.4444', '0.2621851215799072834806611628299950936849667539014914003278410784517994934256', 64, 4, '-1.570796326794896619231321687396429323087824541070836205351156636');
  t('680900799956.2391631230560881936', '8391110142781354241382569821666.000000000000000960842828541994714847171', 73, 5, '0.00000000000000000008114549664706758238959780469755669131069566623063766451113786504326331472');
  t('4', '0.000000444701055646305958', 29, 5, '1.5707962156196327076552902315');
  t('0.00198001', '0.00000008468050238', 44, 1, '1.5707535590804263029523178312770954555911085');
  t('-0.7130528641642158065152955257818276', '52735589484026937661762004210304.69277296014467611843', 105, 5, '-0.0000000000000000000000000000000135212836557026088281582940182087535603761995519039589777297542328421307992530629688115836952372007194197');
  t('966.111111111166838', '2003211111111111111111.222222222226100817412756', 30, 1, '0.000000000000000000482281226253432075279108415864');
  t('1253382716537023744335738.617227', '8366', 149, 5, '1.5707963267948966192246469546343502061835817732436952269627036937748029678669967872852429755805186858237780455970930093501678395176355216393940021267');
  t('0.1450308526578697626', '0.0000000023740220455603089791982355285743340035442753787007949015135136704131487', 123, 6, '1.57079631042581375132136756085022174281936640087102879690413132598413125227649915444026986827237418333023456324579013933523');
  t('-0.0000923271', '-0.8164471', 20, 2, '-3.1414795695949986698');
  t('4019690000', '39199999999999999999999.999999999999999999999999999999999', 34, 6, '0.0000000000001025431122448979591836734690283384');
  t('271404708840691103355801.25135516388', '44771371040248283020320799202337516759860212466813318576387', 11, 0, '0.0000000000000000000000000000000000060620146879');
  t('0.07948', '65164779173494056164705678199399214432.7753112842', 60, 0, '0.00000000000000000000000000000000000000121967727057576982062522557565587463547127577622786974736415');
  t('-74034764624294387503097023451431155727.43', '-9893397940328478146968185711993879785255445365424604873267742872304487659999999999', 89, 3, '-3.1415926535897932384626433832795028841971693918918563781817536016674856258988199995544278');
  t('51422786418193539093758918790888694531137381.39515595448436505775327075637140311904', '59391453223469067375909851953325715796153719695686', 113, 4, '0.00000086582805483298920695113481817468061368501113905559080094260462087032575849697569255576731957845954015468780504656');
  t('822222.000000000041', '51.98', 139, 2, '1.570733107858975722375330878870332290422676204429093343243025394145036864781446595900335803730507982996272299748145770756256190437046568957');
  t('314.45113772541884105508869303918184209915481176628167411336753262184768003104884285', '6055549438890919874006.16', 134, 2, '0.000000000000000000051927763268829143814877352683643872547078851558174265853176706208724483808779909583200857669625658126653678670747537850555960350527245');
  t('-81', '-84461916276393698250146357094665017645306.080880925883535', 130, 3, '-3.141592653589793238462643383279502884196210387271533187149932768737691484471729181406173295136450108275520101651225210948336933552');
  t('609956740688025555555555555555555.54339231792840733474184973356978647799', '0.02088012648229998364', 28, 6, '1.570796326794896619231321692');
  t('3924929.5722656165977195', '522222222222222222222222222222212222222222222222222222222222722.2222222262222222222222222222222222222222222222222272222222222222223', 81, 4, '0.00000000000000000000000000000000000000000000000000000000751582258518947859137776595744695243064524830916451574445449710734406903172862777');
  t('12259514169167236986', '0.8804048415673891647411059422620447306142293545127976010844975590223332549603878340166788976765', 54, 1, '1.57079632679489661915950768421508420391784933621788535');
  t('542255555555585555555.55555595555555555555555', '-0.0000007191212402776862523881025786684710773335505466822427698804028989506425398255096971', 50, 2, '1.5707963267948966192313216929659181044961459574984');
  t('7997799999999.9', '3666611111111111111111111.6', 151, 1, '0.000000000002181251231079231503507625153269899391786413562359303561129282926521506042201375981631222457254264249435077924569895581243487256656766754115125987039258');
  t('866286982800789222222222222222222.33333333333333694509', '768729093635206106', 59, 0, '1.570796326794895731847453646167184828695466934849965367965');
  t('0.00000768051615239539597001403103803697317975876950718631769440976', '0.0804506', 89, 1, '0.0000954687240251940698222011974414767843822164146677305359095652528751758177390364205102692');
  t('7826492748730.98327', '-83905264.5', 102, 1, '1.57080704746725786178446206321543381181944563808474819873714889061568767819517895278520110435566963041');
  t('941481458570438719975240701069002690311993074704940', '0.000000437544', 106, 2, '1.570796326794896619231321691639751442098584699687552910487007556252748201364651132572896398980417962314421');
  t('7666666661292222222.2222', '33955.55555555', 120, 3, '1.57079632679489219024581134120454657758500999823271146150789228775225941565229934685637415497293206253521179789876699365');
  t('192.18516', '10464403328474129848571185798411285726528159459669033080203445577683064444.4444', 138, 0, '0.0000000000000000000000000000000000000000000000000000000000000000000000183656109161097804808759329287637084247224666328378849187480444296729557418400856698019916650291164368837101872598280106020015272150990193');
  t('-41051998029509861911139068268154480121793285162158877204', '-7', 141, 6, '-1.57079632679489661923132169163975144209858469968755291065798774816596648487177212008848468300413792006851801560826705336933781560326804782928');
  t('0.486', '49997999999999999999999999099999999999999999999999999999999999999999.999999999999999999999999999969999999999999999999999999999999999999933', 11, 1, '0.0000000000000000000000000000000000000000000000000000000000000000000097203888155');
  t('158.12043', '5788872', 37, 4, '0.00002731454935619171755700350207318101578');
  t('677777747777777777771777777777777777777777777777777777777777777777777177777777777777777777777777777777777777677777777777777777.77777777777777', '581917756.541399788674239', 67, 6, '1.570796326794896619231321691639751442098584699687552910487472296154');
  t('600000.0000000000071105788314514363999999999999999', '428807.314', 14, 0, '0.95028656520608');
  t('0.00000008318681191811809802', '0.66796280966831542421856833837311292', 149, 0, '0.00000012453808911820260054495239306929577405767521426290923889141635328216173789212838116278798859743419679470333693356752062601854260814760508395125924255');
  t('7232000000', '24816666666606066.6666', 111, 4, '0.000000291417058429178850928433211815214011999826075711915496896882586051959985797628488536033458239263060267533742473');
  t('23941000000605.07', '75419056082957197252049378368521', 103, 2, '0.0000000000000000003174396663659004825207471306999043235499650019238031307216935149640192555947727348390554466956674082607');
  t('45504200660.5497725852', '7961631842871974044030177533634479', 125, 4, '0.0000000000000000000000057154364279339984545013829876484477518654876121711878962171517273099898586385301004832007670714488311497029971860721850949185');
  t('79999995999999499999999999999999999904999999999993999949.9999999999999999999999999999999999999999999999999998990999999999999', '840.06', 4, 6, '1.571');
  t('9.05523', '3.231', 47, 0, '1.2280672896394693201455453000312384689178555644');
  t('7.73799', '704748', 103, 0, '0.00001097979703339214363121493626710004432589140163643885245352412050050800262888631853805632596214638572019');
  t('-4888888888888886252157139003876571194445774536680770289682047822613472560559691953673038', '-60007939260003483734.799896939547830730071142342892922222222', 20, 5, '-1.5707963267948966192');
  t('0.489', '0.11093580556', 23, 4, '1.3477097550580344440273');
  t('0.008803686223576127055470083618014906783219645155628874328652856274334373648191302338106256721', '74468819147877505186.935784716699', 82, 5, '0.0000000000000000000001182197639806008377040390420142841236029699421968900354052715816339835301952756133');
  t('0.000037343322375073946695815841124553463198588', '800000000000000000000000000000000000000000000000000000000000', 15, 4, '0.0000000000000000000000000000000000000000000000000000000000000000466791529688424');
  t('1', '632360623611246353560094487873539910347119755019490035538293120747568556743139700416075609789733950415380555615248145585643151699609819', 90, 5, '0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000158137613675130686118609626910143829352009046516903520115677510268536611716405238661079278');
  t('0.13787033365456851325237332317511290179133209682582', '560367112494090300428187335778579726960640365877632013263686426024981392473026850444444444444444', 132, 0, '0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000246035733683465427358342899716337781273249617371705080525325614105431272208290337749269513587443754864016295373180212305688780255694');
  t('0.00007148434993973896685377156900893826860470842', '243', 1, 4, '0.0000003');
  t('177797977.7777737', '1', 8, 3, '1.5707963');
  t('-0.81747561789366094011576359981073168', '401919379981201037776805570849949955958297325630', 88, 5, '-0.00000000000000000000000000000000000000000000000203392933660451183239593652834425964615423252104878642670074648964668845312417546867777');
  t('502222222222222222222222242222222122.222222222222222222222222222222222222222221222222', '36944444444414.44444444444444444444444444494444444444444', 20, 1, '1.5707963267948966192');
  t('-372989834161426138907180819047205585574827114271618969808197258.1111111111111112777777777777', '0.72084622249261', 217, 4, '-1.570796326794896619231321691639751442098584699687552910487472294221291931942975175277346519627577001730237056468922992114248158160658415267711391938231335054699263375104774223283284705400589806622869213450216036816317');
  t('61966577582844833476227495525370342327174571799094194047209950151091638914815978707376543512569088419264394187266562917362816069349384208929395281622617883577777777', '5444635054056524908047777', 137, 3, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566411533235469223047752911');
  t('8526631880.147300383790485127054981348', '299999999999999999499043387673030257194794646052666666666.55555586893326520480365285307921974857378016', 196, 2, '0.00000000000000000000000000000000000000000000002842210626715766799342909065949140783987944477642746605511496241072080453667797752399841418091573631936625789842700693311700776336973927153638642036925951150367943742917488059873818842608980888458');
  t('81587268333981777117078916051078162665643396218346137132916285844549390959421577832847074434260000865951837058840220245529735346635457079', '33442.37406677356741752843034570491591227471', 62, 4, '1.5707963267948966192313216916397514420985846996875529104874723');
  t('-50107463004133916433789058858180544.2870891546473419403312923312390575816335611496719', '-16915831880311718964474821671199325994328013098111816741', 122, 0, '-3.1415926535897932384596812195881946354044219074778537599484140572893681355858365768156118825737344714958874453911233702192');
  t('0.0000344387097109771230817668145274108477694', '0.18145467467880094375', 38, 4, '0.00018979235094621338299091702475205940996');
  t('944444444444444441427209753284450337249883829079363697373167215555.9999999993939121646470256986885531644571896965127336434624561155572717220081010056674106933', '0.7201', 116, 2, '1.5707963267948966192313216916397514420985846996875529104874722961531457443195750875468756885632460875848997556612148');
  t('53748.922602046882673178575892255721993558442148371001525822', '6653.9313397', 211, 5, '1.447626439766253428071600022918535743645694919220448297974846093622279372336760394133336190713208399028765501587978939966377717392581688843393024240968581332546780712208195784899901971721364950914777386554371801');
  t('-1000000000000000001545613855555555555555555555', '0.048525583143981380589252413319996338133894530878704374721829226326119883104770059320850250947203295463051027817094886169535157928525190493361169921414906836752181101089205282059318032792584751016411206872041366961378170225053140409624008704830132602602957564082960893675475', 60, 0, '-1.5707963267948966192313216916397514420985846996390273273435');
  t('41001874490749126739715692426307025426623140160982931040342', '0.00004676287', 55, 4, '1.57079632679489661923132169163975144209858469968755291');
  t('0.00000000621560084209545644621771230832465554953342646716565424397716951959586941584625448223853993523295211653227850400154767', '2066.000000000000002682012723', 60, 4, '0.00000000000300851928465414154799070985316241279750057446625350484839045');
  t('0.281997', '0.241', 262, 0, '0.8636267877278523289573700095602009437688205043822846133776853734091671784974224042214166380751595937198745742549735308042571206299135663847741918685062164250649406398102921460112694951202612140660672732542748715092549399258478475963869820483984195082830553029646');
  t('666666666666666666644059933996171505396717905960974838269077306737216483932499513287914725245043393088', '9249851414404822234299335400863582861507450510013107617295481885817193163460345730460752349446370955719582915263425251319683085067254037322.3613631120610137539584435834293747806307139200956069903831554035370668603669761912505673908775348078048819794252752400779191550897818668', 79, 5, '0.00000000000000000000000000000000000007207322980653122745617008735778719828105028719036498350716361340859567630988529');
  t('458138171809107343619.11972274032', '402732', 292, 5, '1.570796326794895740169010839693235091037599626559617277019336557373018340306323249771510224220181061976369878119340916233721717718834523197594612933215831332741323948906602272000645199160542548021521598690866416101299242192948845760643658846190830424883854039628004502254282830389847778948244');
  t('7984166699203224603268396119', '4100000000000000000000000000000000000000000006.000000000000000000000000000700048000000000002', 312, 4, '0.00000000000000000194735773151298161055326734609756097314816471269576616358051725059520233493983122509257954411778201282272615460328925047637920652702517176563212992177119006711103763253405682412148687494021989143812513699994586724418255194096341939387789750386165887189139139360857859293822280029000754527755462457063096260471725');
  t('0.3116939963877248720165238684060808386814282111890853734251656474', '0.0010868428094182529896487680910147902', 186, 5, '1.56730945050825757817634659238957747411773856234813769087323288961937245557291881631886181926610716646369081473547346970864829667272524660157856072663239381258305570274680740542005915598');
  t('-54974.1', '8061230000000000000000.60222', 195, 5, '-0.00000000000000000681956723725783782375591480707266480830942257892353724492783547630571351644359047559055921383344164028005290583876670791537735997373828987678139552580594315687529325820723869935095528801049628183');
  t('0.969581789', '2000', 44, 6, '0.00048479085652112932646689972878547927368813389');
  t('0.0004004458627846230688223307335', '0.28266765424', 287, 2, '0.0014166657871439847616187655465915006245199623779258366281384701774493917627929064421370679512048983812958127332014190405070426370820270336559445682868680063940799618087147435555180978549204353275595727387706650646375458899336401083443949609770657035877985383430768150185195383852530229054');
  t('29999999999999999999999999990998999999999999999999999999999999919999999999999999999991999999999999999999999999999999999999999999996999999999999999999999999999999999999999.99999999999399999999939999999999999999999999999999999999999999999999999999999999999999999999999999999999', '0.3321712331724895901349720890766036749934251526803387430357158', 146, 3, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566411533235469223047752911158626797');
  t('-0.25569783815762078827002138152066897560004180898718349575', '-775620647387034717913878973627715892054188457523999795703217688799964441004560555490446921', 68, 0, '-3.1415926535897932384626433832795028841971693993751058209749445923079');
  t('0.34369144062255284377583358', '3117328806816332474.3737824642851577542203064', 46, 4, '0.0000000000000000001102519053720092666602963204113768873717522509');
  t('485594644510205636622228430175013628691699938843173271760919501270666365', '0.68782600866496449724218518940538432067459067512169403620255071558524881352718834795748721931537825976726679534658501872329002985844059542404184096740072858228570067295876424541702119967', 35, 1, '1.5707963267948966192313216916397514');
  t('94.1', '17281372887551230492514', 40, 1, '0.000000000000000000005445169235818391300725698365254063752817');
  t('-0.19606385568090237408641182458552508470349970430655711', '71938658952928074781626292272963', 139, 6, '-0.000000000000000000000000000000002725431062166361222170399419846614562904328358152363017483369441408335984110703392707070165586620046085666973640072743430412611247569188225');
  t('3333533333333333383333333.3333733333332333333333333333333333338333363333333333333333333343333333333333', '0.091138368299099666603828612157383065861', 130, 6, '1.570796326794896619231321664299881344574536571524710497006161779277649455499860324531196847060779932475715714077810592105785957731');
  t('0.77869095426711312163084147048192097479647905329855624805855455839676880759753303448198793559501455069888945240495096302785100704125501405169150987578090662375', '385.594562855', 319, 4, '0.002019452478665255636861773809025982186331092743851256832463478444965580224159918042506614752324745834485663707988671679663957997014490998673467965317952837788589801157100789528360138072786921332093877412254789081416781978097522780188553314006046749111984822209900112369232688878367531841602627788864456525828344188874047');
  t('97.95843791', '8151.3811', 302, 4, '0.012016825303984263006540335878564989368953526018019415710782499251125586056993650345316678347934073061209117571949656365942149901189797581242128623459347111229675025069616308833771960742881428682039901439377172620785499166683655717251375499595979087843978120902560916326514121700275903219927355103536331');
  t('-59917277323723663370163153305', '-999999999999999959441973407936294388969570159166651954273737934295550519798961041751268118863333333333333333333', 291, 3, '-3.14159265358979323846264338327950288419716939937510582097494459230781640628620899856811754801839340218185840618864220989603649456252260199333279482374135504670747330827657132197869969623775166573250730902340025769301079670381946717265669762515895264630237939892635000245561977459976290747224');
  t('254793793283367054504982539810822873343886552921556033085909454144763828730582164684126140899332908333164431832516533030453879', '0.000000005620462363528659955436982755933349124720785', 167, 0, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566411533235469223047752690569958168134763729723576287895');
  t('67897147358918698593570217401337752122374764', '4611970296', 213, 6, '1.57079632679489661923132169163975137417275165076506429404209215595879159790000303011986752447391995884537709288891161613805519439179551883729737414857245818199777144233988070193207958664191652836873338326655955155');
  t('34.30637', '984.297042981', 12, 2, '0.0348395728825');
  t('360.000000000070006', '54444444444444448585833.4444444443333', 210, 5, '0.0000000000000000000066122448979604689949899906704561796693777590933945115176527285390652568855156180615253867963018534504567034498628995714093614468730494784607429735935616976228052677829279291277009797647394575284809131815323546');
  t('0.02967241043208407224652683211964930472118973442957627374286', '4621772795807599545078.37801463954333479305523935295919', 248, 3, '0.0000000000000000000000064201361129218324637245379949778969188552602712653787066974040207774950819944159770228112976646530906288118014750721397760933909344364938490966458167620499337737321393963918728911492286515326305296728912980739161413119906306376487160747470700765773');
  t('1.4529', '41043479833406.30150582173', 171, 5, '0.0000000000000353990452538931365471165080742870402067097557743192249750672066145983183765651055519515169321185071545761294765134683799421434664319954904586074551107908279937790263151468');
  t('0.106434272151885561', '301262769144377161517108072426055181257113296803729597123080', 255, 3, '0.000000000000000000000000000000000000000000000000000000000000353293812090261983978675495865481551453952367523454278981750399514088208547269706129910650432791642455938896092656223000570806238409103478905761610261997649109630087005904946383650093203492512202089252815183095455276659186384908818916977208759574745767338');
  t('-2510541305071032173967979612425359806265793036706807483620711397580914359479114301981881088066288267727583886895638554281050922054216142409682329852324197535703.3636570428783060735578822729290666399346390178925845686338011242568331845738894332377221166264926455555555555555', '6517375458349457157283356739489036982075925062317212148734217488843249199419802679162713190521937716018096404990467764120279761452238', 249, 0, '-1.57079632679489661923132168904374736712677006777956491819847642552022704509692563179350440451584582579247739606122808620704674862390085469323850971025269468693726444297333929776931947862370475217847227253660853038259280071609225499942935828368879535');
  t('0.3', '7.679266262', 151, 0, '0.03904637660924058057680952799738943319157964694350561064037342758613737121601866230992590853149980520161252795354115204327814014737124786856080511260272');
  t('889733333333333333333333.3327476543861829492563799513501770552379052886767811784918986190216', '19999999999999999999999999999999999999999999999999999.999', 98, 4, '0.000000000000000000000000000044486666666666666666666666637382719309147462818997567511047747915687446184737936939203720849479617');
  t('92702942046153786206145041518211509.9998885223406082604549999999999', '706485.53', 290, 3, '1.5707963267948966192313216916321304808388194617803084842632542293581704985914616032534334434503133186544437902462680971128184312440127845192765183556001418272844449906405016017395432228298464361553563942999920145418032272939521286008897352806105082504903983104662731488882508791669272263097');
  t('-804128311111111111111111111.8336598845451868355047076213634685820222034606165695417568223209166111314653214658962938187721547468534753043921071293668012873051575934697982070110423131526168248756542688894974172922248493220369453546125851', '828614658202115472063462538413115006770114714069993279894706796812769059260489995000944899421677058460375497703564229333833514137067168912622974311078213805556959521221463376972465258408316969877', 3, 1, '-0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000097');
  t('157839999999.999699999999999', '0.2483774675736265073429211530058057794363293067430417465866791775118216741', 192, 5, '1.57079632679332301642104782582992019506534690581479598599171752389200699188590172463022118877907051958137368690618664377126243580581740369178883891964427992898264631627917319483866506416507964');
  t('7334156068486127018834429770505220598379835135839678837599283537805', '6717675561574582227116859', 42, 4, '1.57079632679489661923132169163975144209858');
  t('95555555555555579683326893475674634624758.70153996921008510932076473574296014776', '69156576191916478.783', 237, 3, '1.57079632679489661923132096790814013134491971280086636760244285131208529520073868530611513030116593940497283829585066742257333255643183717349015763699732427456869106913561223316483727681551222919421714480504123427145865172561060750925177');
  t('-0.052820761561712632067657239', '74059999999990999969999999998999979999699999599999999999999999.99', 112, 1, '-0.0000000000000000000000000000000000000000000000000000000000000007132157920837030925085399148130826315298815146848240038667808092729419645035247967547812722979493176104503919176');
  t('8012320148197829919388', '188888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888.888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888883888888', 199, 0, '0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004241816549045909957323058823529411764705882352941176470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941176470588235294117647058823529411764705882350397075219');
  t('10000000000000000000000000000000000000000000000000000000000000000000000000000', '8871342736182156520403092408219352285281052202136565393786129003674121509790860377604.079000441319185159562983234', 159, 2, '0.00000000112722507712553656860589251423070320424942739111918324415444252470009869866819250396520764874002378422271657921491632982900076045368528585855654418460644866818');
  t('2391486600002473404069939885054312351710811731255031857893209260506862417752443396.6998764156607818436700053748454161466696463942536417679817496653094666161255796315973432397003', '0.336112949645588144142444096709333986571902795619879768991744619226986000620922073408768007479464974677348095938277428077674385633236334401853146404638262213084796470071', 46, 4, '1.5707963267948966192313216916397514420985847');
  t('-0.182693768630022535483809678950863115', '-0.907526422136192963322126016', 285, 0, '-2.94293819381931073213819642651883121423920543686564714835234966463121318680670667161404860983203719852060277468902497946135883189318722512234407546468521887353674934813690739749339036849231754739682549515138764616538757798576501905098160780514390920874619730983582108052844831998090051');
  t('551930983034039826781953864049640.2356690209281908693994451518260529366302', '0.000000554429245319160201', 32, 4, '1.5707963267948966192313216916398');
  t('88702213489188071901153919571450681.907', '5285', 80, 3, '1.5707963267948966192313216916396918607218398658107591210765054675830986877923285');
  t('843370921314159294882670188514584444633088749959', '33590000000000000000000000000000000000000000000000000000000000000000000400000000000010500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050000000000000000000000000000000008000000000.0000000000000000000000005', 51, 2, '0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000251077975979207887729285557759626211560907636189045');
  t('-87657666862743154543464222548981302829172346317113677304307460766779026072660443863141214367479972222329695023297492588413688063170424045341963836336703477140981508009686049770681999021758836190', '333333333333333333.3333337333333336', 200, 1, '-1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566411533235469223047752911158626797040642405587251420513509692605489771505628038670340172');
  t('0.52958', '57390.98', 248, 4, '0.0000092275824525904429289481377200323513122290274394683729346331954844468463940801676191124597905677822353029456279095451380050564508577823964913887477934452319244957383187948095776864272336209760868205026125588376017196254448385190653831249940186793377');
  t('45145449247936698791.55009', '6666337641574307191857819472235658061402992432984688547670446.346411862235', 10, 2, '0.000000000000000000000000000000000000000006772151619');
  t('55555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555155555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555565555555555555555.55555555555', '7666698856243485653043216105428604869599491434213385514778965830588024410048714', 82, 0, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431045');
  t('110186034581683976547838651042073264965770163886326126419947576328673814701351728882315527298085118550757273813112985533535', '-21590079.5628551755299005131649667125009203708622138961348', 318, 1, '1.57079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664134926561566832038929087356365382217967086844511584541111683237984960070149410388675151759611149801138852139514734673971033801298302486538319276485063503660516282457229098268240286035843310157999233786341');
  t('400000.007', '9977943272299949704984', 68, 4, '0.000000000000000040088422642214385347048091468711631118917158176032977614317182552548');
  t('95243.333333373333333333333333333333333333333313333333333333333333333333333373333333333333333333333333333333333333333333333333333333', '0.10727984713249068240154809088471178752469870083896202064813264071414253636735246382007', 254, 3, '1.5707952004184524334588318377968545395430509740053908362832723279727034711188427270667463279281950016898660536629901751929083603552664425535561418655485999250662935818152195844675807106505791187355154537479694872818165643961469057079510666799568467169532');
  t('7429615796470009791453894238377043645888175250462404396558.336746288', '0.467544167650145010442078', 131, 6, '1.5707963267948966192313216916397514420985846996875529104874093663631278660823748552825403053307495456238881860284548110712721210044');
  t('899.99969', '-77397397410157797370000', 47, 5, '3.1415926535897932384510150893043119025680995542');
  t('42122222222.6607002562149501888378695744770055', '0.00190230844195908788386', 195, 2, '1.57079632679485145759592877797715885658199832484100809963554456249877168201208663373995744711105756330056462247568906937837800937132527343018969630519531095543858939217954635342375623547771689102');
  t('66500556547309277435632763.601913545304254694', '562077526852560143651441168373021700411769280771.5531493497678025345532963744204399922376949953294267770685200945204691006445568778088888888888888888888', 19, 0, '0.0000000000000000000001183120715031775186');
  t('0.6536314837546866282100693957411836781068338', '68160439.74000386359858313174613645957940513636874811111111111111', 138, 1, '0.00000000958960191935301557374600251600633389085042959992004459752195303062701527713115734791814473411208840332546573073991997189350676010173802248');
  t('-52221.54', '-854588888885888888886882888885888888888888888888888888888888888888888888.888887', 14, 4, '-3.1415926535898');
  t('0.030878', '0.8555700774744595102779', 293, 4, '0.036074898820292289947024435671190455880681328552648820339542847879196262021084400507592563192136161833532941986085010990207774028536610491555795113009988866196592011441738630153134794707756416607649622728521002921826414314747531112043802632929789131967840929590852581211315162168978413460123495');
  t('0.558311081223364152874695063684529324787463810926408243641990742280304840206575580954526078130452492693938049399156360783264999453539904917488814396436718899505787274505784562725492005063518107453868000925718031', '59158.4', 54, 1, '0.00000943756222627367114559932261748760061786129193107878971');
  t('0.603667588449664260065766122648941328933013686172134073455379032603319741731847077481740922303977700213733387669841595836959872395654027662886162270353050209380911865189723072461152981063738', '9739599567186479445494421971417820489574582391448017461800815', 82, 6, '0.00000000000000000000000000000000000000000000000000000000000006198073999710116891705808210678924407948564421065941542641369701504313680754326064');
  t('94280000000000000000000000009000000000000000000000000000000.00000000000000000000000080000000000000000000008', '5483270357339999999999999', 128, 4, '1.5707963267948966192313216916397513839391621568364710267369525732374339019727580520691582432422111507765990798096549162498147422');
  t('892143768454089730431116702673912474110760607285390100334.440798613073423279380196333426611721950684460192985096379751656086782907613186', '0.0077875', 204, 1, '1.57079632679489661923132169163975144209858469968755291048746356717963817689950159199724016600977008228824383184843186875293010092163932234953584210367249257583503865473523907580956401748988295985651545022');
  t('0.299572428932627118578198593730198230287507399022200985457228150060377172031918037000031669703886071426039585074360472785507443605141393937269762561841156134961977215426733046959884164917720120825303341752974569862', '62034525842927951269788130549561618667580322715030098539737094399149252857235650627377621857233947291559934450490', 199, 6, '0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004829124183058117468065248132676476392559070799701264593882082889217098451456830996925063690007273659103234547105024404807281009375377372973715525456221415364235665829821196928891696389145324007318435');
  t('0.9596923042', '907467484274.7604545843564', 7, 6, '0.00000000000105755');
  t('-6277.909847731984296576656523212824019057049141279983250563716370211535557', '40754644569232730909822159941728528996.255380554100623919631656284929349183654117148275560086379391810802143957355380113483966', 6, 3, '-0.000000000000000000000000000000000154042');
  t('78888888888888881850782869479843334717455380991803919461380837961891058168082887941222', '143024804019939.99999999999999999606260260186349410165461491', 83, 5, '1.5707963267948966192313216916397514420985846996875529104874722961539082013301140258');
  t('562652521289687.66', '74385506318071374849158160745606323256738210290133180698266', 92, 4, '0.0000000000000000000000000000000000000000000075640074140759817165944523036656289364049051007152246471003013987274397712492700789882116009');
  t('7666666870900', '95', 3, 6, '1.57');
  t('-0.89947878241961', '0.291863612291081606647546', 216, 2, '-1.25703408050991952864668887219637063759191481363744844037140407835421342132344637398249001350701924307761931627436350907012844471710559316331935500326172918235850979839811107665330127894799151532499308168482147601593');
  t('1.00608774285338837620658080487557', '1702925011366235976307704172708338844107925.4841106557365758762710201416090871009984844278329609594849', 160, 6, '0.0000000000000000000000000000000000000000005907997922035430352291228808631198682141848267521013743645324246262111510664134284055661157622103353338929675177139798748006660933449052866928147345313750575308');
  t('2.3987', '0.69562991875012071992730146870038745', 219, 4, '1.28853624419843038468727351588081835770213704647587244345231949642722447497594091396846825516180836904054220099378195526799704144915116292563367738346086380407914260412068086532818012730927431741260380597357682561320379');
  t('9000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000090000000000000000000000000', '983692700978', 104, 4, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339911');
  t('-3819122337833895423886807111111111111111.8219704689467233333', '0.036955289093598928350418', 95, 0, '-1.570796326794896619231321691639751442098575023304911929422417106183782625120966714329334818874');
  t('5999999592095999969699.9999', '0.04129522835171495874', 286, 0, '1.570796326794896619231314809101224920439572894401620696575205021198175456203836710350892285899343136759582363401721266989385580736368718652482781743148924048603608126472316454771367022296823063034251011403800719064645947923091820560747831241128016265167103049599447381150611116935151633');
  t('1361328250848813.076272', '7343968743.198916718819949497260439945244329867918358342846053546504087822321786007988501819070693505488279277154346939262451665443726288050113572026573114943046175947057290797076259300554563626494504893981', 265, 1, '1.570790932086648591193796321088442936443675834115345986480644917436178090309212169344912204849525097913013364971702194608303200452590914075301372011565767043104339171888716880736287502586194311506690261970719797281698367551279328958400340004303306540302655579123347');
  t('45321675851435638476493333333333333.7329929603550163189392423128610226307776847177145484593542971958586410603170406783569093505155237017839441708403099245155397926701726966725323188428864276858285507363706265826995696040150142677811111111111111111', '777777294969464500000000000000', 48, 4, '1.57077916552977829786226762785378601952704521883');
  t('-7963503581542987436349124249909956149725002369506790710928564671717113189819853143856886712279531176869878140164554933586761128991941431554288915', '-590121527432263279', 83, 0, '-1.5707963267948966192313216916397514420985846996875529104874722961539082031431044994');
  t('40000000000.0000000000000000000070000000000000000000000000004000000000000023', '870534498213359201079105368116.9489176849', 301, 3, '0.00000000000000000004594878213568097395833845344057297838532707974753322708094344028490667409036650335309771147861773750516321020424561629576864188130387404472904669404307279334154220677732440196032301424209260571725178852960114436910255601352360182101910663362597672274897214149445856133935693499262422920977408328159858');
  t('4400000000000000000000000000000000200000000070000.0000020000000000001', '0.366025167537562161789628472251313612903161604734171767072743083', 213, 6, '1.57079632679489661923132169163975144209858469968746972294939557748077419667213829167850249131115687274681614173522647735437433755026994400594757305006412525887222320116900270239790755645052032168088793518039040483');
  t('3999999.991999999999609999999958', '7946679', 20, 5, '0.46632794362967849356');
  t('-59999999999999999999993999999999999999999939999999999999999.999999999999999999', '-0.6417368466465456688372416572426988295736482062362', 88, 5, '-1.570796326794896619231321691639751442098584699687552910487482991768018978904251787744533');
  t('877777777777773657660137857111111.222222222222222403120907215641181371089573', '26133333333337333333333.333333333333333333333333333333333333333333333333313333', 291, 4, '1.57079632676512446733258281771787239713000385647355811574723320267909093830633196419030335612992258759172272960593553239374503751988356573153714207946180879523927573168936372367025192235522057856908082718762820407600586302006465581454112894952001869424010561965230942286386408302662765530883');
  t('50.1111111111111111111045', '1453397483709174885971185510976099039984017', 201, 5, '0.0000000000000000000000000000000000000000344786004329826912054711000061106316916320892455800954355475436022028211417899610965211726318026408868849230029707053448839044734073549051100955168097641403274889781624973614539144271107245572342057738');
  t('8038563998768770232812192778984586819714334467041683844252332577569804503706645868939296284889538383232062221050453304817365', '755555555555555555555545555555555555555555.5555555555555555555555555555555555555556555555555555567', 212, 5, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044992200260535587493560392583249876224978828395057519666043370894646597123261796144293212564712019706501341252350258482867424036211602');
  t('-2', '0.180718357', 230, 3, '-1.4806818715141448721477192088701967364481492181260264140010262838724656721905052974180690766220325819323024474851957670246188487258133893823826102113466613162811547192458448671316413215152123940085915522652486434424041799994319168');
  t('6547806010050364423678746715062320167', '0.519694268956385409539624470273162381296015094', 97, 6, '1.570796326794896619231321691639751442019215477667429558602349715293661928365494254725902076987578');
  t('56666666666666666.69950399999999', '37963.2800324639824477572239695048884128774928496690587988291620819148853584098211378661410960724227872963475074699432063168224060203630344335042061938849273983939964361996861312785299341102284053644241046358482702921272950292969462135517973416035000178202285868382157', 86, 1, '1.570796326794226678995454680185179239143560420641455441523353062167766465265295154259');
  t('19942194117409773041674965948', '0.519', 53, 5, '1.570796326794896619231321691613726221556432478984737');
  t('-24444444418899044106316478186780379225218054962338341442186659328212606765854391736517283577807447212851728663737684099285172121447483030248326240715532696934142453940279147700255399400568336109604348955159126418911162263416383364070952155555555555555555555', '-6.7198777717075702', 223, 0, '-1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775291115862679704064240558725142051350969260552779822311474477465190982214405487832966723065');
  t('0.83193168512771', '400000000', 114, 5, '0.00000000207982921281927499700110149965703274815622725425231255915661511133289686086258571594596197781634398615462825047711');
  t('94302565.7069', '0.8556985306813452866073229971909901714524717083022304', 52, 3, '1.570796317720927907277868668996766028541435048826663');
  t('8', '566666667666666666666668666666666666666666666666666666666666666666666.6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666', 276, 0, '0.0000000000000000000000000000000000000000000000000000000000000000000141176470339100346460410655035262353113020104821770278800335579693155488411094548678375408842319592297499501679440259437720845111663169416181899296740075421340945308058380898997576067452388045556731370149352203111146192048635532123074501413613789366018436951798977868875823764');
  t('210000000000000000000000000000000000000000000000000000000000000.05000000000000000600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050000000000000000000000000001', '-25547315234298551394331.61116', 21, 4, '1.57079632679489661923');
  t('899999999999999999999999999999999999999999999999.99999999999999999999999999999999999999', '88027244175535428', 219, 4, '1.57079632679489661923132169163965363404950077143421957715413896282057486980977116598068407933803709143627704621909363380110649715841337323233398834603954919891024482003915508005044786295950904197420169857709955968212997');
  t('343895900830523060035384277184317461443926661831518112971920019309584599511703049891477438281801054703470805059960668159733531882051242182823209347501438917251452271658101142597186811531133347071938', '484953167393953512783985452332035448723224971091568920711082624805698000000000000000', 4, 1, '1.57');
  t('6814849720595877337832473403450226504846135222155735843643917761910689885546522349803301924265628623787824359084518305', '43203370512941405505579077020.04754651647369956', 79, 4, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104');
  t('95', '-7999991.9999999975936482', 289, 6, '3.141580778577918784772583047672397399158843028714797414766221882310605199191713054545796185000172150086816010201462115375638199058567836248541834836985138242694362349912222602680825310252945353371323479552992285321048728722975126831857222815134028920449453653521303042616547428023493093461');
  t('41559.9999999997', '0.132274251011594808510055044218035126336995019', 27, 1, '1.57079314406508403142748489');
  t('6763893415012622250665098518.271103773442607646708', '0.39423221995419657199429', 234, 4, '1.57079632679489661923132169158146663543986521326367098723631265865739593941872256147064167868756190881013682387496808356396781838236907890953494258114728807209416423767168649280669347177060382449707124770399394522833990979903898687468');
  t('0.0091196134917495510380672387070632', '599999999999999999.99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999', 107, 1, '0.00000000000000000001519935581958258506344539784510533333333216287949180287548370006525987844991737539011597700351014560216212');
  t('-488888.888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888', '-4261741111111111111', 276, 2, '-3.14159265358967852269832483533078722584092069755448740945355518960973304726248673250162299788296551925043169908338022286934425081724889899980313223466968203961387001153577369144572875403147132212885167219410230826639122384093707591427286213725934363520580755154640012060596022');
  t('6.033', '0.61532018830216189066035199558284', 205, 3, '1.469155386246314998157241585914248463912571961555596686769633026591802210886155052436674203469209601562482536120193646022285193185689495754959726598082725658325028305461059169836058369465724787164528092045');
  t('8985.631839988', '4400078422188292221406277955391711628766282846314022328967544', 148, 5, '0.000000000000000000000000000000000000000000000000000000002042152656797233451627084786702992163622010729862732862047054350302999668943413502474620176670313898289420564799398874124489042820257103235994105569');
  t('6000000', '0.0900165933', 190, 4, '1.570796311792131069231322817262114923151024936514573840468650121877384464635878374484505714182812864988282871379935453730065704661045618730331033995472678393031424280383630411428059261024217');
  t('-976418240883801436024642320407397607617110791137606056.53706417276573639131750794342306947629418258736153196826080185374568383201784295352008985353739112199655674925668709366836110796', '-29815048643503116803837635757', 172, 6, '-1.570796326794896619231321722174871941809992648198633165903132849721623923801314610481900600578791464297422833221550984291803451626645945901999624968189782554284250330822539');
  t('442629464762994679124286516463716666666666666666666', '0.49826392077940024986012080749980941355831723234552896', 25, 6, '1.570796326794896619231322');
  t('9052532400777996495647045927509092653815345584512298037722043774864657955650', '2222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222.22222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222', 167, 0, '0.0000000000000000000000000000000000000000000000000000000000000000040736395803500984230411706673790916942169055130305341169749196986890960800424999999999999999999999999999999999999999999999999999999774666091192827081566821877432908654');
  t('4599999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999499999999999999999999999999999999.99999999999999999999999999999999999', '385247714260136655085', 245, 3, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566410695740438222750676639419496362258033709935077507470031431735962580831810396948564953300404924443547058443958135741136643016724276');
  t('-5.3627473628', '90479622.89511303502013274', 316, 3, '-0.00000005927022230206095632428634259409479562843467761637884886703386057849176187070155819766447181264069829860483646836874746960994999701391203163750293646645870794370113673287051042507836378260396993613932066130274791737453919692265755129850634219388923362875210805618652978865416477474509618550533052291771147470628890415');
  t('8.97394262084410910038739424859733806352719028183735422708624', '198025.46111', 52, 6, '0.00004531711510428520691082233891118191815022617915762478');
  t('0.9623813955636442616698560675', '9067', 181, 6, '0.0001061411042185510638235098099419203700507755216917614280711875211393988867425864815584311442799667942299234926282405846831394297142870261210840723439847836242153859229585696408369367');
  t('708666666646666666666666666666666666666666606666266666.666666', '44250691712411126006031958276812390342634', 13, 6, '1.570796326795');
  t('6282130000000000050000000000004000000000000000000000000', '-4248852729243703177487020703158574.1505494481206093259808850437863114379659205718', 257, 5, '1.5707963267948966192319980311502747364499703038022387178845218873850758551833160054079818663147636861942794136423532167178524373415018284308900547929109987603265422481038043618689038729000417968247962890998270353579885644660782449439276963362826511810990943');
  t('2475801296161', '8.86529586814587313530678201460343004382756326578169548217758395708917888375718976165288445426862038649872278763641653320418891724652937', 23, 2, '1.5707963267913158408055');
  t('63333313833333333.3333333033333333333363333333333333333333333333333333333333333333333333333333333', '351880.0045369559310503591322875877740352679961274154831282779374060849465743214714844336479354538', 198, 4, '1.57079632678934061744902183870452794870259205385773712799780043375555479373908928019738802248103817038969274545832499090006100804994341434972777751785044326744278860950112131134769683278602707475947');
  t('9298888888888888.422277896269224000461', '0.732', 20, 6, '1.5707963267948965405');
  t('-61533.1641544681400141490702488', '35443782992239700570510627290955492935446986078', 291, 5, '-0.00000000000000000000000000000000000000000173607778176332428831076444136037491253573442584977401561616714559726609319205595389249087706739391595779983777028971904201084664805345515197204805250539602462999819941866125233313816284233945018929332186274847505028718046137151273099429949150118177891760246359775016477783155078313382916462');
  t('2.00000000000000000000001500050689047086880458535923588888888888888888888', '1011223683', 110, 5, '0.0000000019778017797868367343135248548382456333012213982031055953558293704360787523531225642935157741100331126599252636');
  t('111410664855161708352008273018320905508523103904638189882920080633188256.6805932502930587426092762664029950002955880020765683070072250742085930290866019670793664161286407100748859407', '6000004000000000000000000000000000000000000100000000000000000000000000000000000000000', 88, 1, '0.00000000000001856843176357244234370648302993074702988795075889470271376834433479622972824958243282199');
  t('47777777777777777777542133891036871973917316674519882695693999541058739874136829969914682723', '0.0000000165052567840899577955967925186700946695129725581', 307, 2, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533645615180333828083181445108140717427805335793778866067380587982082875166633200592432231069556151199123991625287099915946867796374078162676247633938736149114533070732405012228263871415216579365770343956445408');
  t('-216779081768160192.0586933150887298434', '9679664588', 312, 1, '-1.57079628214268890136603048103890095545395353007199980145335074655795778108679464260150666112052212237090310959577606781705366136109928343450240078292971470959818706871948260337398164360074278191745367648570736996092894959115862271846295561865215468779709553284568373198672882208326471937667020378634457787086481');
  t('32546136481607334235205757664189214692176189', '0.272121421644903109158', 288, 2, '1.57079632679489661923132169163975144209858469132645537134681326210057941447232458882347199956436619453288114500147212553224676121192778803909224029399680646823174631838260581391170784913847556743603090574016648027042046223859950331465651036875259202122415220818130827163552130708080543186');
  t('56783210576023095.60586', '6002090307390553731200', 83, 2, '0.0000094605725116148531862398246641864060964048518120159201111806668321912341651944665294');
  t('22185444644444444444444444444844445444444444444444444446444444444434444.4444444444444444444444444044', '3695855190033495091864610633924384611656668186283908854938162300401076755041541349216.682', 62, 5, '0.0000000000000060027905596169693064208115203370457693333902678775289433177627');
  t('100000517030037444444444444444', '24757.925097165486098913427019116552811568744900575000674177412021174155042435229191184262871906457521635637741110217541601355497096900548048446722464578', 31, 3, '1.570796326794896619231321444061');
  t('199049223.81366207931', '0.007', 59, 6, '1.5707963267597294386420972930180169622179783015143250048425');
  t('9006120000000000000200000000000.00070506001', '0.59705445330083658', 220, 2, '1.570796326794896619231321691639685147795011036824967608366327422736638449105274529062063817803997727434511945562275782846091555149284577006941642608207748323486691072615944715066947165269430727793541026187005507449815755');
  t('8000124.000017394', '0.2514846855571176199100659', 105, 4, '1.57079629535979816868596077330137010310716931141340381708802639573596056759479140257209206347219700973163');
  t('2032095748010419208159243747177345805930448670290878208419199779209176992085797695784447342735718099445741732677142054288983748829915702799266729403', '540494348267267431628321095797466869858184644863912394694442157300447777', 268, 0, '1.570796326794896619231321691639751442098584699687552910487472296153908203142838520533836186612338553260042601140219123855317445350149564057787831616963264026340005236012862914866002748145312474986833769062444451057137466156612268395113365388661151451320287364082709087');
  t('0.13030575421122778532569575985389868722760355073368781661113758812710631321429554405306074775586782940513240434250513616549548589558573577609587363757', '2439090.888888888888888888087495499133182354064949275008545940448787023458', 227, 3, '0.00000005342390265357743728601770135324882455097488450243578262838838149188668393606876216074515332404177295922034169858588015166811498637570980576340423554943110084489815065943564848953713640427391642263379009317050354083268222735997');
  t('166138368.97364934', '0.52646931819689832227807305127736676237254408937', 201, 5, '1.57079632362603609983859858955005600787464509646797101822123591284770095724975123579131847878610922627531474424481107206183182576602655141031601303686756283684081837714849080286248298343194651328690506');
  t('90278261.999', '44181263901455617558506022222', 296, 0, '0.0000000000000000000020433607829862388379052826759763474811709935985214345930981036075755221128676236896828582561803087492314048061192925460196668138404831775069107629636947061839660846116629079982056372186697951385282037082781133883930308765373927197081664579142739793823460829673275103976720089405838592227872323026');
  */

  /*
  t('507989703691573773692646637245632143.09301632', '0.00023524617890895959726260377795727594485001429509775073664719906972586', 212, 5, '1.5707963267948966192313216916397514420981216072720975975518521619523382277587695328995261126066204896228118627274766101949928370591955716970514296655082530879555931469579228461529134448859724770008186821763953534');
  t('998004066737556045215051253813565143.8832197436075567424903', '68460', 79, 1, '1.570796326794896619231321691639682845183720621437636344635653658674424581224736');
  t('86433369263490', '5508888888808888888888888.8888888888888888888888888888888888888888888885', 86, 4, '0.000000000015689800794326475525854199889274777485905975141509279029660740291172467785708899958855');
  t('0.7973373214153259863051018287493346373785456059873526730404740179185666429644939510543367', '74670635858417266137341180611791957639030904013024415014531722727492563832868239597940038462020', 166, 2, '0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001067805720748320019776504365520943386135689928097330133269033583985955196744609594949245670082514215082043451566084038899667992446356666645689615168067785792012884666');
  t('374033450990312455890638.93277366754385751914874291207476855323', '-6666666365211113037927954891933417475012126402854993', 198, 4, '3.14159265358979323846264338322339786401164704278477957375778567565310873587709891126824042916853916530375916510539919732145793866765463800729639359549187308435043692126575133559961390472413880001608');
  t('4557501505542494196542681', '93333333.33333333333333333333333333333336', 100, 4, '1.57079632679489659875226464254645361475453491619971109469026604267355885640904202942190790244340782');
  t('37586159087389043860.12840597360881140349084978654981863744036379008045263', '3.6438981991208205', 106, 2, '1.570796326794896619134373818071488227850040106984836922503521587963115820727789238370957876462074138956552');
  t('17599999999999699999999999999999992999999993999993999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999939999999999999999999999999999999999999999299999999999999999999999999999.9999999999999929999999999999999999999999999999999999999999999999999999999999999999999', '239.08634346880753213670664434445983324566699252092', 267, 5, '1.57079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664115332354692230477529111586267970406424055872514205135096926055277982231147447746519098221440548783295313861290436891192338552122049010626854866178737588');
  t('17422302175613385207748026341667793.594196677214347221187029105709222219653', '-6280267194750492426996442356045048839033599677080041121772044493494905599018712212202141305035063759781863164611006386569952647332454509', 120, 4, '3.14159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706797937395260538484933');
  t('35.555555555555555555810399', '93562191474.7', 19, 2, '0.0000000003800205509847433992');
  t('655178821.976656372810150627894556017394162', '7888888882560128104291718030707688373465696627.7326264', 126, 3, '0.0000000000000000000000000000000000000830508366552167219528879348715744781169072251135990820988376468496467700564812559667432779025950027231130180203262644520954481');
  t('199999999999999799999999999.9999999994', '0.653318820342085268812047613103630556669545319658016361298875617708968747674283425167125121963005981242800362985755651010982871276990746272946978260352896984118314942191617134511691985687996367786493880337469', 316, 4, '1.570796326794896619231321688373157340388155089033213134539708848666623351958286385190648800942745178227447454581139372405216691621700580749157222378524630195337503579276817739005064303427112293190296434606965952328879086669185500336592522402543610416649515184160246856420078752276381558599638215422211400494331186573');
  t('-469999949999999999999999999999999999999999999999999999.99999799999999999999999999999999999999999999', '399999099999999999999379999997099999996299.599999999999999999999999999999999999999999999999999299', 6, 5, '-1.5708');
  t('51843159066983173373682855093655745987316653072561245618131830177218273192375264776925774965411855969428183736674315451097616560126874281100401430816', '0.1583437056606648927940136337333346813606236278675', 317, 0, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566411533235469223047752911158626797040611862752186898443944266343988659827826479239234328935767601822901894596015951584117963190594151960444267998994106243427706477115708478577579396493220067842033167593157');
  t('8.97371291', '0.3719735775671023097475891375084145348906220025730133913939942524611173752325026636714885219183798325655250074242298356330254527400069488220051881131301673788', 125, 2, '1.5293685748722098601193043716159635080474575111815123438248797257101978062606475866389742997157853705155102517819580454003322');
  t('500000000000000000100002000000004000000009000004000000000000000000000.0008288', '19999999999999999999999999999999999999999999999999999999999999.999999999999999999999999999999999', 149, 6, '1.5707962867948966192313430329732447754117452311655422664148774416140316384157439413719499691896166382056900775498385205763727073603338127325942159374');
  t('5582891.3597685055690985730589137363770728987728496', '266666666666666382042958984077143507617183562784966139887556362967881425215585235664628852767376244487606988880345564665279504009361199333583929835062876027928683507896995851822443540478720956364107283254806348650308460828', 104, 6, '0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020935842599131918229758939061032881098666523650418225935407930210608256253258086396866954585005435137654');
  t('4', '254000000', 59, 0, '0.000000015748031496062990824144377947548739729887884697571800377569');
  t('15326115.03190697849221085243183992543694223981330695906500550503698952983127434939', '30768.131968114546961069250957311802', 53, 0, '1.5687887671120183139020396925338495333330008731836498');
  t('8034290.5', '6000000090000000', 204, 1, '0.00000000133904839658094071715222871666241558165445391260174475208666675651357061285430590958040066303866213458688136814863999406379772159594451196227157306095448221693734706596871168056987826817590075405752191267');
  t('273111111111111111191131111111111111111111111111111111111111111111911111111111111101211111111111111111111111111111111111111111111111.11113111111111111111111111111111111111111111111111111118111111411111', '0.00000068502191855763597473010208377780570007199638735702991349078013656230206105269222443517141499856', 44, 5, '1.5707963267948966192313216916397514420985847');
  t('85', '95753278410486313854503', 147, 5, '0.000000000000000000000887698065392728312874734146073384850456334779025402771466973758023667262126652535350318967494673024347770761537590742106186593369841123114713544955');
  t('708296988445555555555555', '7', 162, 5, '1.57079632679489661923131180877971646954155521813533680672970849949841498424452150783046455072506127688700844098356667167357522651436714788445420817147133311022297');
  t('67381111111111111111', '2', 235, 5, '1.570796326794896619201639782763211693075565254889511026429926110525705919896593801691189227911950841228275003643935654428367121002853687190621360713931591682143109405062846172592007176046070894191718933231800595180657008817073239215772');
  t('811522222222222222222222222222222222222422222222222222222222222222282.422222222', '-5222222222416415910444444444444.729788169848249155', 35, 1, '1.5707963267948966192313216916397514');
  */
});
