/*
    Copyright (c) 2008-2013 NetAllied Systems GmbH

    This file is part of COLLADASaxFrameworkLoader.

    Licensed under the MIT Open Source License,
    for details please see LICENSE file or the website
    http://www.opensource.org/licenses/mit-license.php
*/

#include "COLLADASaxFWLStableHeaders.h"
#include "GeneratedSaxParserUtils.h"

#include "COLLADASaxFWLColladaParserAutoGen14Private.h"


// disable warning "unused variable"
#if defined(__INTEL_COMPILER) && !defined(WIN32)
template <typename T>
inline void disable_warning_unused(T &x) { (void)x; }
#    define DISABLE_WARNING_UNUSED(x) disable_warning_unused(x);
#else
#    define DISABLE_WARNING_UNUSED(x) (void)x;
#endif



namespace COLLADASaxFWL14
{


//---------------------------------------------------------------------
ColladaParserAutoGen14Private::ColladaParserAutoGen14Private( COLLADASaxFWL14::ColladaParserAutoGen14* impl, GeneratedSaxParser::IErrorHandler* errorHandler 
)    : GeneratedSaxParser::ParserTemplate<ColladaParserAutoGen14Private, ColladaParserAutoGen14>(impl, errorHandler)
{
    initFunctionMap();
    initNameMap();
}

//---------------------------------------------------------------------
ColladaParserAutoGen14Private::~ColladaParserAutoGen14Private()
{
}


//---------------------------------------------------------------------
const char* NAME_NAMESPACE_COLLADA = "http://www.collada.org/2005/11/COLLADASchema";
const char* NAME_NAMESPACE_http___www_w3_org_2001_XMLSchema = "http://www.w3.org/2001/XMLSchema";
const char* NAME_NAMESPACE_http___www_w3_org_XML_1998_namespace = "http://www.w3.org/XML/1998/namespace";

const char* NAME_ATTRIBUTE_base = "xml:base";
const char* NAME_ATTRIBUTE_body = "body";
const char* NAME_ATTRIBUTE_camera_node = "camera_node";
const char* NAME_ATTRIBUTE_closed = "closed";
const char* NAME_ATTRIBUTE_constraint = "constraint";
const char* NAME_ATTRIBUTE_convex_hull_of = "convex_hull_of";
const char* NAME_ATTRIBUTE_count = "count";
const char* NAME_ATTRIBUTE_depth = "depth";
const char* NAME_ATTRIBUTE_digits = "digits";
const char* NAME_ATTRIBUTE_end = "end";
const char* NAME_ATTRIBUTE_face = NAME_ELEMENT_FACE;
const char* NAME_ATTRIBUTE_format = "format";
const char* NAME_ATTRIBUTE_height = "height";
const char* NAME_ATTRIBUTE_id = "id";
const char* NAME_ATTRIBUTE_index = "index";
const char* NAME_ATTRIBUTE_input_semantic = "input_semantic";
const char* NAME_ATTRIBUTE_input_set = "input_set";
const char* NAME_ATTRIBUTE_layer = "layer";
const char* NAME_ATTRIBUTE_length = "length";
const char* NAME_ATTRIBUTE_magnitude = "magnitude";
const char* NAME_ATTRIBUTE_material = "material";
const char* NAME_ATTRIBUTE_maxInclusive = "maxInclusive";
const char* NAME_ATTRIBUTE_meter = "meter";
const char* NAME_ATTRIBUTE_method = "method";
const char* NAME_ATTRIBUTE_minInclusive = "minInclusive";
const char* NAME_ATTRIBUTE_mip = "mip";
const char* NAME_ATTRIBUTE_name = "name";
const char* NAME_ATTRIBUTE_offset = "offset";
const char* NAME_ATTRIBUTE_opaque = "opaque";
const char* NAME_ATTRIBUTE_operand = "operand";
const char* NAME_ATTRIBUTE_operator = "operator";
const char* NAME_ATTRIBUTE_param = NAME_ELEMENT_PARAM;
const char* NAME_ATTRIBUTE_parent = "parent";
const char* NAME_ATTRIBUTE_platform = "platform";
const char* NAME_ATTRIBUTE_profile = "profile";
const char* NAME_ATTRIBUTE_program = "program";
const char* NAME_ATTRIBUTE_ref = "ref";
const char* NAME_ATTRIBUTE_rigid_body = NAME_ELEMENT_RIGID_BODY;
const char* NAME_ATTRIBUTE_scale = NAME_ELEMENT_SCALE;
const char* NAME_ATTRIBUTE_semantic = "semantic";
const char* NAME_ATTRIBUTE_set = "set";
const char* NAME_ATTRIBUTE_sid = "sid";
const char* NAME_ATTRIBUTE_slice = "slice";
const char* NAME_ATTRIBUTE_source = NAME_ELEMENT_SOURCE;
const char* NAME_ATTRIBUTE_stage = "stage";
const char* NAME_ATTRIBUTE_start = "start";
const char* NAME_ATTRIBUTE_stride = "stride";
const char* NAME_ATTRIBUTE_symbol = "symbol";
const char* NAME_ATTRIBUTE_target = "target";
const char* NAME_ATTRIBUTE_texcoord = NAME_ELEMENT_TEXCOORD;
const char* NAME_ATTRIBUTE_texture = NAME_ELEMENT_TEXTURE;
const char* NAME_ATTRIBUTE_type = "type";
const char* NAME_ATTRIBUTE_unit = NAME_ELEMENT_UNIT;
const char* NAME_ATTRIBUTE_url = "url";
const char* NAME_ATTRIBUTE_value = "value";
const char* NAME_ATTRIBUTE_version = "version";
const char* NAME_ATTRIBUTE_width = "width";
const char* NAME_ATTRIBUTE_xmlns = "xmlns";
const char* NAME_ELEMENT_ACCESSOR = "accessor";
const char* NAME_ELEMENT_ALL = "all";
const char* NAME_ELEMENT_ALPHA = "alpha";
const char* NAME_ELEMENT_ALPHA_FUNC = "alpha_func";
const char* NAME_ELEMENT_ALPHA_TEST_ENABLE = "alpha_test_enable";
const char* NAME_ELEMENT_ALPHA____GLES_TEXCOMBINER_COMMANDALPHA_TYPE = "alpha____gles_texcombiner_commandAlpha_type";
const char* NAME_ELEMENT_AMBIENT = "ambient";
const char* NAME_ELEMENT_AMBIENT____COMMON_COLOR_OR_TEXTURE_TYPE = "ambient____common_color_or_texture_type";
const char* NAME_ELEMENT_ANGULAR = "angular";
const char* NAME_ELEMENT_ANGULAR_VELOCITY = "angular_velocity";
const char* NAME_ELEMENT_ANIMATION = "animation";
const char* NAME_ELEMENT_ANIMATION_CLIP = "animation_clip";
const char* NAME_ELEMENT_ANIMATION__SOURCE__TECHNIQUE_COMMON = "animation__source__technique_common";
const char* NAME_ELEMENT_ANNOTATE = "annotate";
const char* NAME_ELEMENT_ARGUMENT = "argument";
const char* NAME_ELEMENT_ARGUMENT____GLES_TEXCOMBINER_ARGUMENTALPHA_TYPE = "argument____gles_texcombiner_argumentAlpha_type";
const char* NAME_ELEMENT_ARGUMENT____GLES_TEXCOMBINER_ARGUMENTRGB_TYPE = "argument____gles_texcombiner_argumentRGB_type";
const char* NAME_ELEMENT_ARRAY = "array";
const char* NAME_ELEMENT_ARRAY____CG_NEWARRAY_TYPE = "array____cg_newarray_type";
const char* NAME_ELEMENT_ARRAY____CG_SETARRAY_TYPE = "array____cg_setarray_type";
const char* NAME_ELEMENT_ARRAY____GLSL_NEWARRAY_TYPE = "array____glsl_newarray_type";
const char* NAME_ELEMENT_ARRAY____GLSL_SETARRAY_TYPE = "array____glsl_setarray_type";
const char* NAME_ELEMENT_ASPECT_RATIO = "aspect_ratio";
const char* NAME_ELEMENT_ASSET = "asset";
const char* NAME_ELEMENT_ATTACHMENT = "attachment";
const char* NAME_ELEMENT_AUTHOR = "author";
const char* NAME_ELEMENT_AUTHORING_TOOL = "authoring_tool";
const char* NAME_ELEMENT_AUTO_NORMAL_ENABLE = "auto_normal_enable";
const char* NAME_ELEMENT_BACK = "back";
const char* NAME_ELEMENT_BIND = "bind";
const char* NAME_ELEMENT_BIND_MATERIAL = "bind_material";
const char* NAME_ELEMENT_BIND_MATERIAL__TECHNIQUE_COMMON = "bind_material__technique_common";
const char* NAME_ELEMENT_BIND_SHAPE_MATRIX = "bind_shape_matrix";
const char* NAME_ELEMENT_BIND_VERTEX_INPUT = "bind_vertex_input";
const char* NAME_ELEMENT_BLEND_COLOR = "blend_color";
const char* NAME_ELEMENT_BLEND_ENABLE = "blend_enable";
const char* NAME_ELEMENT_BLEND_EQUATION = "blend_equation";
const char* NAME_ELEMENT_BLEND_EQUATION_SEPARATE = "blend_equation_separate";
const char* NAME_ELEMENT_BLEND_EQUATION_SEPARATE__ALPHA = "blend_equation_separate__alpha";
const char* NAME_ELEMENT_BLEND_FUNC = "blend_func";
const char* NAME_ELEMENT_BLEND_FUNC_SEPARATE = "blend_func_separate";
const char* NAME_ELEMENT_BLINN = "blinn";
const char* NAME_ELEMENT_BOOL = "bool";
const char* NAME_ELEMENT_BOOL1 = "bool1";
const char* NAME_ELEMENT_BOOL1X1 = "bool1x1";
const char* NAME_ELEMENT_BOOL1X2 = "bool1x2";
const char* NAME_ELEMENT_BOOL1X3 = "bool1x3";
const char* NAME_ELEMENT_BOOL1X4 = "bool1x4";
const char* NAME_ELEMENT_BOOL2 = "bool2";
const char* NAME_ELEMENT_BOOL2X1 = "bool2x1";
const char* NAME_ELEMENT_BOOL2X2 = "bool2x2";
const char* NAME_ELEMENT_BOOL2X3 = "bool2x3";
const char* NAME_ELEMENT_BOOL2X4 = "bool2x4";
const char* NAME_ELEMENT_BOOL2____BOOL2 = "bool2____bool2";
const char* NAME_ELEMENT_BOOL2____CG_BOOL2 = "bool2____cg_bool2";
const char* NAME_ELEMENT_BOOL2____GLSL_BOOL2 = "bool2____glsl_bool2";
const char* NAME_ELEMENT_BOOL3 = "bool3";
const char* NAME_ELEMENT_BOOL3X1 = "bool3x1";
const char* NAME_ELEMENT_BOOL3X2 = "bool3x2";
const char* NAME_ELEMENT_BOOL3X3 = "bool3x3";
const char* NAME_ELEMENT_BOOL3X4 = "bool3x4";
const char* NAME_ELEMENT_BOOL3____BOOL3 = "bool3____bool3";
const char* NAME_ELEMENT_BOOL3____CG_BOOL3 = "bool3____cg_bool3";
const char* NAME_ELEMENT_BOOL3____GLSL_BOOL3 = "bool3____glsl_bool3";
const char* NAME_ELEMENT_BOOL4 = "bool4";
const char* NAME_ELEMENT_BOOL4X1 = "bool4x1";
const char* NAME_ELEMENT_BOOL4X2 = "bool4x2";
const char* NAME_ELEMENT_BOOL4X3 = "bool4x3";
const char* NAME_ELEMENT_BOOL4X4 = "bool4x4";
const char* NAME_ELEMENT_BOOL4____BOOL4 = "bool4____bool4";
const char* NAME_ELEMENT_BOOL4____CG_BOOL4 = "bool4____cg_bool4";
const char* NAME_ELEMENT_BOOL4____GLSL_BOOL4 = "bool4____glsl_bool4";
const char* NAME_ELEMENT_BOOL_ARRAY = "bool_array";
const char* NAME_ELEMENT_BOOL____BOOL = "bool____bool";
const char* NAME_ELEMENT_BOOL____CG_BOOL = "bool____cg_bool";
const char* NAME_ELEMENT_BOOL____GLSL_BOOL = "bool____glsl_bool";
const char* NAME_ELEMENT_BORDER_COLOR = "border_color";
const char* NAME_ELEMENT_BOX = "box";
const char* NAME_ELEMENT_CAMERA = "camera";
const char* NAME_ELEMENT_CAPSULE = "capsule";
const char* NAME_ELEMENT_CG_SURFACE_TYPE____GENERATOR = "cg_surface_type____generator";
const char* NAME_ELEMENT_CHANNEL = "channel";
const char* NAME_ELEMENT_CHANNELS = "channels";
const char* NAME_ELEMENT_CLEAR_COLOR = "clear_color";
const char* NAME_ELEMENT_CLEAR_DEPTH = "clear_depth";
const char* NAME_ELEMENT_CLEAR_STENCIL = "clear_stencil";
const char* NAME_ELEMENT_CLIP_PLANE = "clip_plane";
const char* NAME_ELEMENT_CLIP_PLANE_ENABLE = "clip_plane_enable";
const char* NAME_ELEMENT_CODE = "code";
const char* NAME_ELEMENT_COLLADA = "COLLADA";
const char* NAME_ELEMENT_COLOR = "color";
const char* NAME_ELEMENT_COLOR_CLEAR = "color_clear";
const char* NAME_ELEMENT_COLOR_CLEAR____FX_CLEARCOLOR_COMMON = "color_clear____fx_clearcolor_common";
const char* NAME_ELEMENT_COLOR_CLEAR____FX_COLOR_COMMON = "color_clear____fx_color_common";
const char* NAME_ELEMENT_COLOR_LOGIC_OP_ENABLE = "color_logic_op_enable";
const char* NAME_ELEMENT_COLOR_MASK = "color_mask";
const char* NAME_ELEMENT_COLOR_MATERIAL = "color_material";
const char* NAME_ELEMENT_COLOR_MATERIAL_ENABLE = "color_material_enable";
const char* NAME_ELEMENT_COLOR_MATERIAL__FACE = "color_material__face";
const char* NAME_ELEMENT_COLOR_MATERIAL__MODE = "color_material__mode";
const char* NAME_ELEMENT_COLOR_TARGET = "color_target";
const char* NAME_ELEMENT_COLOR_TARGET____FX_COLORTARGET_COMMON = "color_target____fx_colortarget_common";
const char* NAME_ELEMENT_COLOR_TARGET____GLES_RENDERTARGET_COMMON = "color_target____gles_rendertarget_common";
const char* NAME_ELEMENT_COLOR____TARGETABLEFLOAT3 = "color____TargetableFloat3";
const char* NAME_ELEMENT_COMMENTS = "comments";
const char* NAME_ELEMENT_COMMON_COLOR_OR_TEXTURE_TYPE____COLOR = "common_color_or_texture_type____color";
const char* NAME_ELEMENT_COMMON_COLOR_OR_TEXTURE_TYPE____PARAM = "common_color_or_texture_type____param";
const char* NAME_ELEMENT_COMMON_FLOAT_OR_PARAM_TYPE____FLOAT = "common_float_or_param_type____float";
const char* NAME_ELEMENT_COMMON_FLOAT_OR_PARAM_TYPE____PARAM = "common_float_or_param_type____param";
const char* NAME_ELEMENT_COMPILER_OPTIONS = "compiler_options";
const char* NAME_ELEMENT_COMPILER_TARGET = "compiler_target";
const char* NAME_ELEMENT_CONNECT_PARAM = "connect_param";
const char* NAME_ELEMENT_CONSTANT = "constant";
const char* NAME_ELEMENT_CONSTANT_ATTENUATION = "constant_attenuation";
const char* NAME_ELEMENT_CONSTANT____GLES_TEXTURE_CONSTANT_TYPE = "constant____gles_texture_constant_type";
const char* NAME_ELEMENT_CONTRIBUTOR = "contributor";
const char* NAME_ELEMENT_CONTROLLER = "controller";
const char* NAME_ELEMENT_CONTROL_VERTICES = "control_vertices";
const char* NAME_ELEMENT_CONVEX_MESH = "convex_mesh";
const char* NAME_ELEMENT_COPYRIGHT = "copyright";
const char* NAME_ELEMENT_CREATED = "created";
const char* NAME_ELEMENT_CULL_FACE = "cull_face";
const char* NAME_ELEMENT_CULL_FACE_ENABLE = "cull_face_enable";
const char* NAME_ELEMENT_CYLINDER = "cylinder";
const char* NAME_ELEMENT_DAMPING = "damping";
const char* NAME_ELEMENT_DATA = "data";
const char* NAME_ELEMENT_DENSITY = "density";
const char* NAME_ELEMENT_DEPTH_BOUNDS = "depth_bounds";
const char* NAME_ELEMENT_DEPTH_BOUNDS_ENABLE = "depth_bounds_enable";
const char* NAME_ELEMENT_DEPTH_CLAMP_ENABLE = "depth_clamp_enable";
const char* NAME_ELEMENT_DEPTH_CLEAR = "depth_clear";
const char* NAME_ELEMENT_DEPTH_CLEAR____FLOAT = "depth_clear____float";
const char* NAME_ELEMENT_DEPTH_CLEAR____FX_CLEARDEPTH_COMMON = "depth_clear____fx_cleardepth_common";
const char* NAME_ELEMENT_DEPTH_FUNC = "depth_func";
const char* NAME_ELEMENT_DEPTH_MASK = "depth_mask";
const char* NAME_ELEMENT_DEPTH_RANGE = "depth_range";
const char* NAME_ELEMENT_DEPTH_TARGET = "depth_target";
const char* NAME_ELEMENT_DEPTH_TARGET____FX_DEPTHTARGET_COMMON = "depth_target____fx_depthtarget_common";
const char* NAME_ELEMENT_DEPTH_TARGET____GLES_RENDERTARGET_COMMON = "depth_target____gles_rendertarget_common";
const char* NAME_ELEMENT_DEPTH_TEST_ENABLE = "depth_test_enable";
const char* NAME_ELEMENT_DEST = "dest";
const char* NAME_ELEMENT_DEST_ALPHA = "dest_alpha";
const char* NAME_ELEMENT_DEST_RGB = "dest_rgb";
const char* NAME_ELEMENT_DIFFUSE = "diffuse";
const char* NAME_ELEMENT_DIRECTIONAL = "directional";
const char* NAME_ELEMENT_DITHER_ENABLE = "dither_enable";
const char* NAME_ELEMENT_DRAW = "draw";
const char* NAME_ELEMENT_DYNAMIC = "dynamic";
const char* NAME_ELEMENT_DYNAMIC_FRICTION = "dynamic_friction";
const char* NAME_ELEMENT_EFFECT = "effect";
const char* NAME_ELEMENT_ELLIPSOID = "ellipsoid";
const char* NAME_ELEMENT_EMISSION = "emission";
const char* NAME_ELEMENT_ENABLED = "enabled";
const char* NAME_ELEMENT_ENUM = "enum";
const char* NAME_ELEMENT_ENUM____GLES_ENUMERATION = "enum____gles_enumeration";
const char* NAME_ELEMENT_ENUM____GL_ENUMERATION = "enum____gl_enumeration";
const char* NAME_ELEMENT_ENUM____STRING = "enum____string";
const char* NAME_ELEMENT_EQUATION = "equation";
const char* NAME_ELEMENT_EVALUATE_SCENE = "evaluate_scene";
const char* NAME_ELEMENT_EXTRA = "extra";
const char* NAME_ELEMENT_FACE = "face";
const char* NAME_ELEMENT_FAIL = "fail";
const char* NAME_ELEMENT_FALLOFF_ANGLE = "falloff_angle";
const char* NAME_ELEMENT_FALLOFF_EXPONENT = "falloff_exponent";
const char* NAME_ELEMENT_FIXED = "fixed";
const char* NAME_ELEMENT_FIXED1 = "fixed1";
const char* NAME_ELEMENT_FIXED1X1 = "fixed1x1";
const char* NAME_ELEMENT_FIXED1X2 = "fixed1x2";
const char* NAME_ELEMENT_FIXED1X3 = "fixed1x3";
const char* NAME_ELEMENT_FIXED1X4 = "fixed1x4";
const char* NAME_ELEMENT_FIXED2 = "fixed2";
const char* NAME_ELEMENT_FIXED2X1 = "fixed2x1";
const char* NAME_ELEMENT_FIXED2X2 = "fixed2x2";
const char* NAME_ELEMENT_FIXED2X3 = "fixed2x3";
const char* NAME_ELEMENT_FIXED2X4 = "fixed2x4";
const char* NAME_ELEMENT_FIXED3 = "fixed3";
const char* NAME_ELEMENT_FIXED3X1 = "fixed3x1";
const char* NAME_ELEMENT_FIXED3X2 = "fixed3x2";
const char* NAME_ELEMENT_FIXED3X3 = "fixed3x3";
const char* NAME_ELEMENT_FIXED3X4 = "fixed3x4";
const char* NAME_ELEMENT_FIXED4 = "fixed4";
const char* NAME_ELEMENT_FIXED4X1 = "fixed4x1";
const char* NAME_ELEMENT_FIXED4X2 = "fixed4x2";
const char* NAME_ELEMENT_FIXED4X3 = "fixed4x3";
const char* NAME_ELEMENT_FIXED4X4 = "fixed4x4";
const char* NAME_ELEMENT_FLOAT = "float";
const char* NAME_ELEMENT_FLOAT1 = "float1";
const char* NAME_ELEMENT_FLOAT1X1 = "float1x1";
const char* NAME_ELEMENT_FLOAT1X1____CG_FLOAT1X1 = "float1x1____cg_float1x1";
const char* NAME_ELEMENT_FLOAT1X1____FLOAT = "float1x1____float";
const char* NAME_ELEMENT_FLOAT1X2 = "float1x2";
const char* NAME_ELEMENT_FLOAT1X2____CG_FLOAT1X2 = "float1x2____cg_float1x2";
const char* NAME_ELEMENT_FLOAT1X2____FLOAT2 = "float1x2____float2";
const char* NAME_ELEMENT_FLOAT1X3 = "float1x3";
const char* NAME_ELEMENT_FLOAT1X3____CG_FLOAT1X3 = "float1x3____cg_float1x3";
const char* NAME_ELEMENT_FLOAT1X3____FLOAT3 = "float1x3____float3";
const char* NAME_ELEMENT_FLOAT1X4 = "float1x4";
const char* NAME_ELEMENT_FLOAT1X4____CG_FLOAT1X4 = "float1x4____cg_float1x4";
const char* NAME_ELEMENT_FLOAT1X4____FLOAT4 = "float1x4____float4";
const char* NAME_ELEMENT_FLOAT2 = "float2";
const char* NAME_ELEMENT_FLOAT2X1 = "float2x1";
const char* NAME_ELEMENT_FLOAT2X1____CG_FLOAT2X1 = "float2x1____cg_float2x1";
const char* NAME_ELEMENT_FLOAT2X1____FLOAT2 = "float2x1____float2";
const char* NAME_ELEMENT_FLOAT2X2 = "float2x2";
const char* NAME_ELEMENT_FLOAT2X2____CG_FLOAT2X2 = "float2x2____cg_float2x2";
const char* NAME_ELEMENT_FLOAT2X2____FLOAT2X2 = "float2x2____float2x2";
const char* NAME_ELEMENT_FLOAT2X2____GLSL_FLOAT2X2 = "float2x2____glsl_float2x2";
const char* NAME_ELEMENT_FLOAT2X3 = "float2x3";
const char* NAME_ELEMENT_FLOAT2X3____CG_FLOAT2X3 = "float2x3____cg_float2x3";
const char* NAME_ELEMENT_FLOAT2X3____FLOAT2X3 = "float2x3____float2x3";
const char* NAME_ELEMENT_FLOAT2X4 = "float2x4";
const char* NAME_ELEMENT_FLOAT2X4____CG_FLOAT2X4 = "float2x4____cg_float2x4";
const char* NAME_ELEMENT_FLOAT2X4____FLOAT2X4 = "float2x4____float2x4";
const char* NAME_ELEMENT_FLOAT2____CG_FLOAT2 = "float2____cg_float2";
const char* NAME_ELEMENT_FLOAT2____FLOAT2 = "float2____float2";
const char* NAME_ELEMENT_FLOAT2____GLSL_FLOAT2 = "float2____glsl_float2";
const char* NAME_ELEMENT_FLOAT3 = "float3";
const char* NAME_ELEMENT_FLOAT3X1 = "float3x1";
const char* NAME_ELEMENT_FLOAT3X1____CG_FLOAT3X1 = "float3x1____cg_float3x1";
const char* NAME_ELEMENT_FLOAT3X1____FLOAT3 = "float3x1____float3";
const char* NAME_ELEMENT_FLOAT3X2 = "float3x2";
const char* NAME_ELEMENT_FLOAT3X2____CG_FLOAT3X2 = "float3x2____cg_float3x2";
const char* NAME_ELEMENT_FLOAT3X2____FLOAT3X2 = "float3x2____float3x2";
const char* NAME_ELEMENT_FLOAT3X3 = "float3x3";
const char* NAME_ELEMENT_FLOAT3X3____CG_FLOAT3X3 = "float3x3____cg_float3x3";
const char* NAME_ELEMENT_FLOAT3X3____FLOAT3X3 = "float3x3____float3x3";
const char* NAME_ELEMENT_FLOAT3X3____GLSL_FLOAT3X3 = "float3x3____glsl_float3x3";
const char* NAME_ELEMENT_FLOAT3X4 = "float3x4";
const char* NAME_ELEMENT_FLOAT3X4____CG_FLOAT3X4 = "float3x4____cg_float3x4";
const char* NAME_ELEMENT_FLOAT3X4____FLOAT3X4 = "float3x4____float3x4";
const char* NAME_ELEMENT_FLOAT3____CG_FLOAT3 = "float3____cg_float3";
const char* NAME_ELEMENT_FLOAT3____FLOAT3 = "float3____float3";
const char* NAME_ELEMENT_FLOAT3____GLSL_FLOAT3 = "float3____glsl_float3";
const char* NAME_ELEMENT_FLOAT4 = "float4";
const char* NAME_ELEMENT_FLOAT4X1 = "float4x1";
const char* NAME_ELEMENT_FLOAT4X1____CG_FLOAT4X1 = "float4x1____cg_float4x1";
const char* NAME_ELEMENT_FLOAT4X1____FLOAT4 = "float4x1____float4";
const char* NAME_ELEMENT_FLOAT4X2 = "float4x2";
const char* NAME_ELEMENT_FLOAT4X2____CG_FLOAT4X2 = "float4x2____cg_float4x2";
const char* NAME_ELEMENT_FLOAT4X2____FLOAT4X2 = "float4x2____float4x2";
const char* NAME_ELEMENT_FLOAT4X3 = "float4x3";
const char* NAME_ELEMENT_FLOAT4X3____CG_FLOAT4X3 = "float4x3____cg_float4x3";
const char* NAME_ELEMENT_FLOAT4X3____FLOAT4X3 = "float4x3____float4x3";
const char* NAME_ELEMENT_FLOAT4X4 = "float4x4";
const char* NAME_ELEMENT_FLOAT4X4____CG_FLOAT4X4 = "float4x4____cg_float4x4";
const char* NAME_ELEMENT_FLOAT4X4____FLOAT4X4 = "float4x4____float4x4";
const char* NAME_ELEMENT_FLOAT4X4____GLSL_FLOAT4X4 = "float4x4____glsl_float4x4";
const char* NAME_ELEMENT_FLOAT4____CG_FLOAT4 = "float4____cg_float4";
const char* NAME_ELEMENT_FLOAT4____FLOAT4 = "float4____float4";
const char* NAME_ELEMENT_FLOAT4____GLSL_FLOAT4 = "float4____glsl_float4";
const char* NAME_ELEMENT_FLOAT_ARRAY = "float_array";
const char* NAME_ELEMENT_FLOAT____CG_FLOAT = "float____cg_float";
const char* NAME_ELEMENT_FLOAT____FLOAT = "float____float";
const char* NAME_ELEMENT_FLOAT____GLSL_FLOAT = "float____glsl_float";
const char* NAME_ELEMENT_FOG_COLOR = "fog_color";
const char* NAME_ELEMENT_FOG_COORD_SRC = "fog_coord_src";
const char* NAME_ELEMENT_FOG_DENSITY = "fog_density";
const char* NAME_ELEMENT_FOG_ENABLE = "fog_enable";
const char* NAME_ELEMENT_FOG_END = "fog_end";
const char* NAME_ELEMENT_FOG_MODE = "fog_mode";
const char* NAME_ELEMENT_FOG_START = "fog_start";
const char* NAME_ELEMENT_FORCE_FIELD = "force_field";
const char* NAME_ELEMENT_FORMAT = NAME_ATTRIBUTE_format;
const char* NAME_ELEMENT_FORMAT_HINT = "format_hint";
const char* NAME_ELEMENT_FRONT = "front";
const char* NAME_ELEMENT_FRONT_FACE = "front_face";
const char* NAME_ELEMENT_FUNC = "func";
const char* NAME_ELEMENT_FX_PROFILE_ABSTRACT = "fx_profile_abstract";
const char* NAME_ELEMENT_FX_SURFACE_INIT_CUBE_COMMON____ALL = "fx_surface_init_cube_common____all";
const char* NAME_ELEMENT_FX_SURFACE_INIT_CUBE_COMMON____FACE = "fx_surface_init_cube_common____face";
const char* NAME_ELEMENT_FX_SURFACE_INIT_CUBE_COMMON____PRIMARY = "fx_surface_init_cube_common____primary";
const char* NAME_ELEMENT_FX_SURFACE_INIT_PLANAR_COMMON____ALL = "fx_surface_init_planar_common____all";
const char* NAME_ELEMENT_FX_SURFACE_INIT_VOLUME_COMMON____ALL = "fx_surface_init_volume_common____all";
const char* NAME_ELEMENT_FX_SURFACE_INIT_VOLUME_COMMON____PRIMARY = "fx_surface_init_volume_common____primary";
const char* NAME_ELEMENT_GENERATOR = "generator";
const char* NAME_ELEMENT_GEOMETRY = "geometry";
const char* NAME_ELEMENT_GLSL_SURFACE_TYPE____GENERATOR = "glsl_surface_type____generator";
const char* NAME_ELEMENT_GL_HOOK_ABSTRACT = "gl_hook_abstract";
const char* NAME_ELEMENT_GRAVITY = "gravity";
const char* NAME_ELEMENT_H = "h";
const char* NAME_ELEMENT_HALF = "half";
const char* NAME_ELEMENT_HALF1 = "half1";
const char* NAME_ELEMENT_HALF1X1 = "half1x1";
const char* NAME_ELEMENT_HALF1X2 = "half1x2";
const char* NAME_ELEMENT_HALF1X3 = "half1x3";
const char* NAME_ELEMENT_HALF1X4 = "half1x4";
const char* NAME_ELEMENT_HALF2 = "half2";
const char* NAME_ELEMENT_HALF2X1 = "half2x1";
const char* NAME_ELEMENT_HALF2X2 = "half2x2";
const char* NAME_ELEMENT_HALF2X3 = "half2x3";
const char* NAME_ELEMENT_HALF2X4 = "half2x4";
const char* NAME_ELEMENT_HALF3 = "half3";
const char* NAME_ELEMENT_HALF3X1 = "half3x1";
const char* NAME_ELEMENT_HALF3X2 = "half3x2";
const char* NAME_ELEMENT_HALF3X3 = "half3x3";
const char* NAME_ELEMENT_HALF3X4 = "half3x4";
const char* NAME_ELEMENT_HALF4 = "half4";
const char* NAME_ELEMENT_HALF4X1 = "half4x1";
const char* NAME_ELEMENT_HALF4X2 = "half4x2";
const char* NAME_ELEMENT_HALF4X3 = "half4x3";
const char* NAME_ELEMENT_HALF4X4 = "half4x4";
const char* NAME_ELEMENT_HALF_EXTENTS = "half_extents";
const char* NAME_ELEMENT_HEIGHT = NAME_ATTRIBUTE_height;
const char* NAME_ELEMENT_HOLLOW = "hollow";
const char* NAME_ELEMENT_IDREF_ARRAY = "IDREF_array";
const char* NAME_ELEMENT_IMAGE = "image";
const char* NAME_ELEMENT_IMAGER = "imager";
const char* NAME_ELEMENT_INCLUDE = "include";
const char* NAME_ELEMENT_INDEX_OF_REFRACTION = "index_of_refraction";
const char* NAME_ELEMENT_INERTIA = "inertia";
const char* NAME_ELEMENT_INIT_AS_NULL = "init_as_null";
const char* NAME_ELEMENT_INIT_AS_TARGET = "init_as_target";
const char* NAME_ELEMENT_INIT_CUBE = "init_cube";
const char* NAME_ELEMENT_INIT_FROM = "init_from";
const char* NAME_ELEMENT_INIT_FROM____ANYURI = "init_from____anyURI";
const char* NAME_ELEMENT_INIT_FROM____FX_SURFACE_INIT_FROM_COMMON = "init_from____fx_surface_init_from_common";
const char* NAME_ELEMENT_INIT_PLANAR = "init_planar";
const char* NAME_ELEMENT_INIT_VOLUME = "init_volume";
const char* NAME_ELEMENT_INPUT = "input";
const char* NAME_ELEMENT_INPUT____INPUTLOCAL = "input____InputLocal";
const char* NAME_ELEMENT_INPUT____INPUTLOCALOFFSET = "input____InputLocalOffset";
const char* NAME_ELEMENT_INSTANCE_ANIMATION = "instance_animation";
const char* NAME_ELEMENT_INSTANCE_CAMERA = "instance_camera";
const char* NAME_ELEMENT_INSTANCE_CONTROLLER = "instance_controller";
const char* NAME_ELEMENT_INSTANCE_EFFECT = "instance_effect";
const char* NAME_ELEMENT_INSTANCE_EFFECT__SETPARAM = "instance_effect__setparam";
const char* NAME_ELEMENT_INSTANCE_FORCE_FIELD = "instance_force_field";
const char* NAME_ELEMENT_INSTANCE_GEOMETRY = "instance_geometry";
const char* NAME_ELEMENT_INSTANCE_LIGHT = "instance_light";
const char* NAME_ELEMENT_INSTANCE_MATERIAL = "instance_material";
const char* NAME_ELEMENT_INSTANCE_MATERIAL__BIND = "instance_material__bind";
const char* NAME_ELEMENT_INSTANCE_NODE = "instance_node";
const char* NAME_ELEMENT_INSTANCE_PHYSICS_MATERIAL = "instance_physics_material";
const char* NAME_ELEMENT_INSTANCE_PHYSICS_MODEL = "instance_physics_model";
const char* NAME_ELEMENT_INSTANCE_PHYSICS_SCENE = "instance_physics_scene";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY = "instance_rigid_body";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON = "instance_rigid_body__technique_common";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__DYNAMIC = "instance_rigid_body__technique_common__dynamic";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__MASS_FRAME = "instance_rigid_body__technique_common__mass_frame";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__SHAPE = "instance_rigid_body__technique_common__shape";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__SHAPE__HOLLOW = "instance_rigid_body__technique_common__shape__hollow";
const char* NAME_ELEMENT_INSTANCE_RIGID_CONSTRAINT = "instance_rigid_constraint";
const char* NAME_ELEMENT_INSTANCE_VISUAL_SCENE = "instance_visual_scene";
const char* NAME_ELEMENT_INT = "int";
const char* NAME_ELEMENT_INT1 = "int1";
const char* NAME_ELEMENT_INT1X1 = "int1x1";
const char* NAME_ELEMENT_INT1X2 = "int1x2";
const char* NAME_ELEMENT_INT1X3 = "int1x3";
const char* NAME_ELEMENT_INT1X4 = "int1x4";
const char* NAME_ELEMENT_INT2 = "int2";
const char* NAME_ELEMENT_INT2X1 = "int2x1";
const char* NAME_ELEMENT_INT2X2 = "int2x2";
const char* NAME_ELEMENT_INT2X3 = "int2x3";
const char* NAME_ELEMENT_INT2X4 = "int2x4";
const char* NAME_ELEMENT_INT2____CG_INT2 = "int2____cg_int2";
const char* NAME_ELEMENT_INT2____GLSL_INT2 = "int2____glsl_int2";
const char* NAME_ELEMENT_INT2____INT2 = "int2____int2";
const char* NAME_ELEMENT_INT3 = "int3";
const char* NAME_ELEMENT_INT3X1 = "int3x1";
const char* NAME_ELEMENT_INT3X2 = "int3x2";
const char* NAME_ELEMENT_INT3X3 = "int3x3";
const char* NAME_ELEMENT_INT3X4 = "int3x4";
const char* NAME_ELEMENT_INT3____CG_INT3 = "int3____cg_int3";
const char* NAME_ELEMENT_INT3____GLSL_INT3 = "int3____glsl_int3";
const char* NAME_ELEMENT_INT3____INT3 = "int3____int3";
const char* NAME_ELEMENT_INT4 = "int4";
const char* NAME_ELEMENT_INT4X1 = "int4x1";
const char* NAME_ELEMENT_INT4X2 = "int4x2";
const char* NAME_ELEMENT_INT4X3 = "int4x3";
const char* NAME_ELEMENT_INT4X4 = "int4x4";
const char* NAME_ELEMENT_INT4____CG_INT4 = "int4____cg_int4";
const char* NAME_ELEMENT_INT4____GLSL_INT4 = "int4____glsl_int4";
const char* NAME_ELEMENT_INT4____INT4 = "int4____int4";
const char* NAME_ELEMENT_INTERPENETRATE = "interpenetrate";
const char* NAME_ELEMENT_INT_ARRAY = "int_array";
const char* NAME_ELEMENT_INT____CG_INT = "int____cg_int";
const char* NAME_ELEMENT_INT____GLSL_INT = "int____glsl_int";
const char* NAME_ELEMENT_INT____INT = "int____int";
const char* NAME_ELEMENT_JOINTS = "joints";
const char* NAME_ELEMENT_KEYWORDS = "keywords";
const char* NAME_ELEMENT_LAMBERT = "lambert";
const char* NAME_ELEMENT_LAYER = NAME_ATTRIBUTE_layer;
const char* NAME_ELEMENT_LIBRARY_ANIMATIONS = "library_animations";
const char* NAME_ELEMENT_LIBRARY_ANIMATION_CLIPS = "library_animation_clips";
const char* NAME_ELEMENT_LIBRARY_CAMERAS = "library_cameras";
const char* NAME_ELEMENT_LIBRARY_CONTROLLERS = "library_controllers";
const char* NAME_ELEMENT_LIBRARY_EFFECTS = "library_effects";
const char* NAME_ELEMENT_LIBRARY_FORCE_FIELDS = "library_force_fields";
const char* NAME_ELEMENT_LIBRARY_GEOMETRIES = "library_geometries";
const char* NAME_ELEMENT_LIBRARY_IMAGES = "library_images";
const char* NAME_ELEMENT_LIBRARY_LIGHTS = "library_lights";
const char* NAME_ELEMENT_LIBRARY_MATERIALS = "library_materials";
const char* NAME_ELEMENT_LIBRARY_NODES = "library_nodes";
const char* NAME_ELEMENT_LIBRARY_PHYSICS_MATERIALS = "library_physics_materials";
const char* NAME_ELEMENT_LIBRARY_PHYSICS_MODELS = "library_physics_models";
const char* NAME_ELEMENT_LIBRARY_PHYSICS_SCENES = "library_physics_scenes";
const char* NAME_ELEMENT_LIBRARY_VISUAL_SCENES = "library_visual_scenes";
const char* NAME_ELEMENT_LIGHT = "light";
const char* NAME_ELEMENT_LIGHTING_ENABLE = "lighting_enable";
const char* NAME_ELEMENT_LIGHT_AMBIENT = "light_ambient";
const char* NAME_ELEMENT_LIGHT_CONSTANT_ATTENUATION = "light_constant_attenuation";
const char* NAME_ELEMENT_LIGHT_DIFFUSE = "light_diffuse";
const char* NAME_ELEMENT_LIGHT_ENABLE = "light_enable";
const char* NAME_ELEMENT_LIGHT_LINEAR_ATTENUATION = "light_linear_attenuation";
const char* NAME_ELEMENT_LIGHT_LINEAR_ATTENUTATION = "light_linear_attenutation";
const char* NAME_ELEMENT_LIGHT_MODEL_AMBIENT = "light_model_ambient";
const char* NAME_ELEMENT_LIGHT_MODEL_COLOR_CONTROL = "light_model_color_control";
const char* NAME_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE = "light_model_local_viewer_enable";
const char* NAME_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE = "light_model_two_side_enable";
const char* NAME_ELEMENT_LIGHT_POSITION = "light_position";
const char* NAME_ELEMENT_LIGHT_QUADRATIC_ATTENUATION = "light_quadratic_attenuation";
const char* NAME_ELEMENT_LIGHT_SPECULAR = "light_specular";
const char* NAME_ELEMENT_LIGHT_SPOT_CUTOFF = "light_spot_cutoff";
const char* NAME_ELEMENT_LIGHT_SPOT_DIRECTION = "light_spot_direction";
const char* NAME_ELEMENT_LIGHT_SPOT_EXPONENT = "light_spot_exponent";
const char* NAME_ELEMENT_LIGHT__TECHNIQUE_COMMON = "light__technique_common";
const char* NAME_ELEMENT_LIGHT__TECHNIQUE_COMMON__AMBIENT = "light__technique_common__ambient";
const char* NAME_ELEMENT_LIMITS = "limits";
const char* NAME_ELEMENT_LIMITS__LINEAR = "limits__linear";
const char* NAME_ELEMENT_LINEAR = "linear";
const char* NAME_ELEMENT_LINEAR_ATTENUATION = "linear_attenuation";
const char* NAME_ELEMENT_LINES = "lines";
const char* NAME_ELEMENT_LINESTRIPS = "linestrips";
const char* NAME_ELEMENT_LINE_SMOOTH_ENABLE = "line_smooth_enable";
const char* NAME_ELEMENT_LINE_STIPPLE = "line_stipple";
const char* NAME_ELEMENT_LINE_STIPPLE_ENABLE = "line_stipple_enable";
const char* NAME_ELEMENT_LINE_WIDTH = "line_width";
const char* NAME_ELEMENT_LOGIC_OP = "logic_op";
const char* NAME_ELEMENT_LOGIC_OP_ENABLE = "logic_op_enable";
const char* NAME_ELEMENT_LOOKAT = "lookat";
const char* NAME_ELEMENT_MAGFILTER = "magfilter";
const char* NAME_ELEMENT_MASK = "mask";
const char* NAME_ELEMENT_MASS = "mass";
const char* NAME_ELEMENT_MASS_FRAME = "mass_frame";
const char* NAME_ELEMENT_MATERIAL = NAME_ATTRIBUTE_material;
const char* NAME_ELEMENT_MATERIAL_AMBIENT = "material_ambient";
const char* NAME_ELEMENT_MATERIAL_DIFFUSE = "material_diffuse";
const char* NAME_ELEMENT_MATERIAL_EMISSION = "material_emission";
const char* NAME_ELEMENT_MATERIAL_SHININESS = "material_shininess";
const char* NAME_ELEMENT_MATERIAL_SPECULAR = "material_specular";
const char* NAME_ELEMENT_MATRIX = "matrix";
const char* NAME_ELEMENT_MAX = "max";
const char* NAME_ELEMENT_MESH = "mesh";
const char* NAME_ELEMENT_MIN = "min";
const char* NAME_ELEMENT_MINFILTER = "minfilter";
const char* NAME_ELEMENT_MIPFILTER = "mipfilter";
const char* NAME_ELEMENT_MIPMAP_BIAS = "mipmap_bias";
const char* NAME_ELEMENT_MIPMAP_GENERATE = "mipmap_generate";
const char* NAME_ELEMENT_MIPMAP_MAXLEVEL = "mipmap_maxlevel";
const char* NAME_ELEMENT_MIP_LEVELS = "mip_levels";
const char* NAME_ELEMENT_MODE = "mode";
const char* NAME_ELEMENT_MODEL_VIEW_MATRIX = "model_view_matrix";
const char* NAME_ELEMENT_MODIFIED = "modified";
const char* NAME_ELEMENT_MODIFIER = "modifier";
const char* NAME_ELEMENT_MORPH = "morph";
const char* NAME_ELEMENT_MULTISAMPLE_ENABLE = "multisample_enable";
const char* NAME_ELEMENT_NAME = NAME_ATTRIBUTE_name;
const char* NAME_ELEMENT_NAME_ARRAY = "Name_array";
const char* NAME_ELEMENT_NEWPARAM = "newparam";
const char* NAME_ELEMENT_NEWPARAM____CG_NEWPARAM = "newparam____cg_newparam";
const char* NAME_ELEMENT_NEWPARAM____COMMON_NEWPARAM_TYPE = "newparam____common_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____FX_NEWPARAM_COMMON = "newparam____fx_newparam_common";
const char* NAME_ELEMENT_NEWPARAM____GLES_NEWPARAM = "newparam____gles_newparam";
const char* NAME_ELEMENT_NEWPARAM____GLSL_NEWPARAM = "newparam____glsl_newparam";
const char* NAME_ELEMENT_NODE = "node";
const char* NAME_ELEMENT_NORMALIZE_ENABLE = "normalize_enable";
const char* NAME_ELEMENT_OPTICS = "optics";
const char* NAME_ELEMENT_OPTICS__TECHNIQUE_COMMON = "optics__technique_common";
const char* NAME_ELEMENT_OPTION = "option";
const char* NAME_ELEMENT_ORDER = "order";
const char* NAME_ELEMENT_ORTHOGRAPHIC = "orthographic";
const char* NAME_ELEMENT_P = "p";
const char* NAME_ELEMENT_PARAM = "param";
const char* NAME_ELEMENT_PARAM____NCNAME = "param____NCName";
const char* NAME_ELEMENT_PASS = "pass";
const char* NAME_ELEMENT_PERSPECTIVE = "perspective";
const char* NAME_ELEMENT_PH = "ph";
const char* NAME_ELEMENT_PHONG = "phong";
const char* NAME_ELEMENT_PHYSICS_MATERIAL = "physics_material";
const char* NAME_ELEMENT_PHYSICS_MATERIAL__TECHNIQUE_COMMON = "physics_material__technique_common";
const char* NAME_ELEMENT_PHYSICS_MODEL = "physics_model";
const char* NAME_ELEMENT_PHYSICS_SCENE = "physics_scene";
const char* NAME_ELEMENT_PHYSICS_SCENE__TECHNIQUE_COMMON = "physics_scene__technique_common";
const char* NAME_ELEMENT_PLANE = "plane";
const char* NAME_ELEMENT_POINT = "point";
const char* NAME_ELEMENT_POINT_DISTANCE_ATTENUATION = "point_distance_attenuation";
const char* NAME_ELEMENT_POINT_FADE_THRESHOLD_SIZE = "point_fade_threshold_size";
const char* NAME_ELEMENT_POINT_SIZE = "point_size";
const char* NAME_ELEMENT_POINT_SIZE_MAX = "point_size_max";
const char* NAME_ELEMENT_POINT_SIZE_MIN = "point_size_min";
const char* NAME_ELEMENT_POINT_SMOOTH_ENABLE = "point_smooth_enable";
const char* NAME_ELEMENT_POLYGONS = "polygons";
const char* NAME_ELEMENT_POLYGON_MODE = "polygon_mode";
const char* NAME_ELEMENT_POLYGON_MODE__FACE = "polygon_mode__face";
const char* NAME_ELEMENT_POLYGON_MODE__MODE = "polygon_mode__mode";
const char* NAME_ELEMENT_POLYGON_OFFSET = "polygon_offset";
const char* NAME_ELEMENT_POLYGON_OFFSET_FILL_ENABLE = "polygon_offset_fill_enable";
const char* NAME_ELEMENT_POLYGON_OFFSET_LINE_ENABLE = "polygon_offset_line_enable";
const char* NAME_ELEMENT_POLYGON_OFFSET_POINT_ENABLE = "polygon_offset_point_enable";
const char* NAME_ELEMENT_POLYGON_SMOOTH_ENABLE = "polygon_smooth_enable";
const char* NAME_ELEMENT_POLYGON_STIPPLE_ENABLE = "polygon_stipple_enable";
const char* NAME_ELEMENT_POLYLIST = "polylist";
const char* NAME_ELEMENT_PRECISION = "precision";
const char* NAME_ELEMENT_PRIMARY = "primary";
const char* NAME_ELEMENT_PROFILE_CG = "profile_CG";
const char* NAME_ELEMENT_PROFILE_CG__NEWPARAM__SURFACE__GENERATOR__NAME = "profile_CG__newparam__surface__generator__name";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE = "profile_CG__technique";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS = "profile_CG__technique__pass";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__SHADER = "profile_CG__technique__pass__shader";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__SHADER__BIND = "profile_CG__technique__pass__shader__bind";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__SHADER__BIND__PARAM = "profile_CG__technique__pass__shader__bind__param";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__SHADER__COMPILER_TARGET = "profile_CG__technique__pass__shader__compiler_target";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__SHADER__NAME = "profile_CG__technique__pass__shader__name";
const char* NAME_ELEMENT_PROFILE_COMMON = "profile_COMMON";
const char* NAME_ELEMENT_PROFILE_COMMON__TECHNIQUE = "profile_COMMON__technique";
const char* NAME_ELEMENT_PROFILE_COMMON__TECHNIQUE__CONSTANT = "profile_COMMON__technique__constant";
const char* NAME_ELEMENT_PROFILE_GLES = "profile_GLES";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE = "profile_GLES__technique";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS = "profile_GLES__technique__pass";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__ALPHA_FUNC = "profile_GLES__technique__pass__alpha_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__ALPHA_FUNC__FUNC = "profile_GLES__technique__pass__alpha_func__func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__ALPHA_FUNC__VALUE = "profile_GLES__technique__pass__alpha_func__value";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__ALPHA_TEST_ENABLE = "profile_GLES__technique__pass__alpha_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__BLEND_ENABLE = "profile_GLES__technique__pass__blend_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__BLEND_FUNC = "profile_GLES__technique__pass__blend_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__BLEND_FUNC__DEST = "profile_GLES__technique__pass__blend_func__dest";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__BLEND_FUNC__SRC = "profile_GLES__technique__pass__blend_func__src";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CLEAR_COLOR = "profile_GLES__technique__pass__clear_color";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CLEAR_DEPTH = "profile_GLES__technique__pass__clear_depth";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CLEAR_STENCIL = "profile_GLES__technique__pass__clear_stencil";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CLIP_PLANE = "profile_GLES__technique__pass__clip_plane";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CLIP_PLANE_ENABLE = "profile_GLES__technique__pass__clip_plane_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__COLOR_LOGIC_OP_ENABLE = "profile_GLES__technique__pass__color_logic_op_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__COLOR_MASK = "profile_GLES__technique__pass__color_mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__COLOR_MATERIAL_ENABLE = "profile_GLES__technique__pass__color_material_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CULL_FACE = "profile_GLES__technique__pass__cull_face";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__CULL_FACE_ENABLE = "profile_GLES__technique__pass__cull_face_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__DEPTH_FUNC = "profile_GLES__technique__pass__depth_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__DEPTH_MASK = "profile_GLES__technique__pass__depth_mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__DEPTH_RANGE = "profile_GLES__technique__pass__depth_range";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__DEPTH_TEST_ENABLE = "profile_GLES__technique__pass__depth_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__DITHER_ENABLE = "profile_GLES__technique__pass__dither_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FOG_COLOR = "profile_GLES__technique__pass__fog_color";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FOG_DENSITY = "profile_GLES__technique__pass__fog_density";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FOG_ENABLE = "profile_GLES__technique__pass__fog_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FOG_END = "profile_GLES__technique__pass__fog_end";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FOG_MODE = "profile_GLES__technique__pass__fog_mode";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FOG_START = "profile_GLES__technique__pass__fog_start";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__FRONT_FACE = "profile_GLES__technique__pass__front_face";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHTING_ENABLE = "profile_GLES__technique__pass__lighting_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_AMBIENT = "profile_GLES__technique__pass__light_ambient";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_CONSTANT_ATTENUATION = "profile_GLES__technique__pass__light_constant_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_DIFFUSE = "profile_GLES__technique__pass__light_diffuse";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_ENABLE = "profile_GLES__technique__pass__light_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_MODEL_AMBIENT = "profile_GLES__technique__pass__light_model_ambient";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_MODEL_TWO_SIDE_ENABLE = "profile_GLES__technique__pass__light_model_two_side_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_POSITION = "profile_GLES__technique__pass__light_position";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_QUADRATIC_ATTENUATION = "profile_GLES__technique__pass__light_quadratic_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_SPECULAR = "profile_GLES__technique__pass__light_specular";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_SPOT_CUTOFF = "profile_GLES__technique__pass__light_spot_cutoff";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_SPOT_DIRECTION = "profile_GLES__technique__pass__light_spot_direction";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LIGHT_SPOT_EXPONENT = "profile_GLES__technique__pass__light_spot_exponent";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LINE_SMOOTH_ENABLE = "profile_GLES__technique__pass__line_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LINE_WIDTH = "profile_GLES__technique__pass__line_width";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__LOGIC_OP = "profile_GLES__technique__pass__logic_op";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MATERIAL_AMBIENT = "profile_GLES__technique__pass__material_ambient";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MATERIAL_DIFFUSE = "profile_GLES__technique__pass__material_diffuse";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MATERIAL_EMISSION = "profile_GLES__technique__pass__material_emission";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MATERIAL_SHININESS = "profile_GLES__technique__pass__material_shininess";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MATERIAL_SPECULAR = "profile_GLES__technique__pass__material_specular";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MODEL_VIEW_MATRIX = "profile_GLES__technique__pass__model_view_matrix";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__MULTISAMPLE_ENABLE = "profile_GLES__technique__pass__multisample_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__NORMALIZE_ENABLE = "profile_GLES__technique__pass__normalize_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POINT_DISTANCE_ATTENUATION = "profile_GLES__technique__pass__point_distance_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POINT_FADE_THRESHOLD_SIZE = "profile_GLES__technique__pass__point_fade_threshold_size";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POINT_SIZE = "profile_GLES__technique__pass__point_size";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POINT_SIZE_MAX = "profile_GLES__technique__pass__point_size_max";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POINT_SIZE_MIN = "profile_GLES__technique__pass__point_size_min";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POINT_SMOOTH_ENABLE = "profile_GLES__technique__pass__point_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POLYGON_OFFSET = "profile_GLES__technique__pass__polygon_offset";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__POLYGON_OFFSET_FILL_ENABLE = "profile_GLES__technique__pass__polygon_offset_fill_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__PROJECTION_MATRIX = "profile_GLES__technique__pass__projection_matrix";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__RESCALE_NORMAL_ENABLE = "profile_GLES__technique__pass__rescale_normal_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "profile_GLES__technique__pass__sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__SAMPLE_ALPHA_TO_ONE_ENABLE = "profile_GLES__technique__pass__sample_alpha_to_one_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__SAMPLE_COVERAGE_ENABLE = "profile_GLES__technique__pass__sample_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__SCISSOR = "profile_GLES__technique__pass__scissor";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__SCISSOR_TEST_ENABLE = "profile_GLES__technique__pass__scissor_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__SHADE_MODEL = "profile_GLES__technique__pass__shade_model";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_FUNC = "profile_GLES__technique__pass__stencil_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_FUNC__FUNC = "profile_GLES__technique__pass__stencil_func__func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_FUNC__MASK = "profile_GLES__technique__pass__stencil_func__mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_FUNC__REF = "profile_GLES__technique__pass__stencil_func__ref";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_MASK = "profile_GLES__technique__pass__stencil_mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_OP = "profile_GLES__technique__pass__stencil_op";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_OP__FAIL = "profile_GLES__technique__pass__stencil_op__fail";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_OP__ZFAIL = "profile_GLES__technique__pass__stencil_op__zfail";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_OP__ZPASS = "profile_GLES__technique__pass__stencil_op__zpass";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STENCIL_TEST_ENABLE = "profile_GLES__technique__pass__stencil_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__TEXTURE_PIPELINE = "profile_GLES__technique__pass__texture_pipeline";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__SETPARAM = "profile_GLES__technique__setparam";
const char* NAME_ELEMENT_PROFILE_GLSL = "profile_GLSL";
const char* NAME_ELEMENT_PROFILE_GLSL__NEWPARAM__SURFACE__GENERATOR__NAME = "profile_GLSL__newparam__surface__generator__name";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE = "profile_GLSL__technique";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS = "profile_GLSL__technique__pass";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__ALPHA_FUNC = "profile_GLSL__technique__pass__alpha_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__ALPHA_FUNC__FUNC = "profile_GLSL__technique__pass__alpha_func__func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__ALPHA_FUNC__VALUE = "profile_GLSL__technique__pass__alpha_func__value";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__ALPHA_TEST_ENABLE = "profile_GLSL__technique__pass__alpha_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__BLEND_ENABLE = "profile_GLSL__technique__pass__blend_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__BLEND_FUNC = "profile_GLSL__technique__pass__blend_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__BLEND_FUNC__DEST = "profile_GLSL__technique__pass__blend_func__dest";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__BLEND_FUNC__SRC = "profile_GLSL__technique__pass__blend_func__src";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CLEAR_COLOR = "profile_GLSL__technique__pass__clear_color";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CLEAR_DEPTH = "profile_GLSL__technique__pass__clear_depth";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CLEAR_STENCIL = "profile_GLSL__technique__pass__clear_stencil";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CLIP_PLANE = "profile_GLSL__technique__pass__clip_plane";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CLIP_PLANE_ENABLE = "profile_GLSL__technique__pass__clip_plane_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__COLOR_LOGIC_OP_ENABLE = "profile_GLSL__technique__pass__color_logic_op_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__COLOR_MASK = "profile_GLSL__technique__pass__color_mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__COLOR_MATERIAL_ENABLE = "profile_GLSL__technique__pass__color_material_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CULL_FACE = "profile_GLSL__technique__pass__cull_face";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__CULL_FACE_ENABLE = "profile_GLSL__technique__pass__cull_face_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__DEPTH_FUNC = "profile_GLSL__technique__pass__depth_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__DEPTH_MASK = "profile_GLSL__technique__pass__depth_mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__DEPTH_RANGE = "profile_GLSL__technique__pass__depth_range";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__DEPTH_TEST_ENABLE = "profile_GLSL__technique__pass__depth_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__DITHER_ENABLE = "profile_GLSL__technique__pass__dither_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FOG_COLOR = "profile_GLSL__technique__pass__fog_color";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FOG_DENSITY = "profile_GLSL__technique__pass__fog_density";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FOG_ENABLE = "profile_GLSL__technique__pass__fog_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FOG_END = "profile_GLSL__technique__pass__fog_end";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FOG_MODE = "profile_GLSL__technique__pass__fog_mode";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FOG_START = "profile_GLSL__technique__pass__fog_start";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__FRONT_FACE = "profile_GLSL__technique__pass__front_face";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHTING_ENABLE = "profile_GLSL__technique__pass__lighting_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_AMBIENT = "profile_GLSL__technique__pass__light_ambient";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_CONSTANT_ATTENUATION = "profile_GLSL__technique__pass__light_constant_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_DIFFUSE = "profile_GLSL__technique__pass__light_diffuse";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_ENABLE = "profile_GLSL__technique__pass__light_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_MODEL_AMBIENT = "profile_GLSL__technique__pass__light_model_ambient";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_MODEL_TWO_SIDE_ENABLE = "profile_GLSL__technique__pass__light_model_two_side_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_POSITION = "profile_GLSL__technique__pass__light_position";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_QUADRATIC_ATTENUATION = "profile_GLSL__technique__pass__light_quadratic_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_SPECULAR = "profile_GLSL__technique__pass__light_specular";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_SPOT_CUTOFF = "profile_GLSL__technique__pass__light_spot_cutoff";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_SPOT_DIRECTION = "profile_GLSL__technique__pass__light_spot_direction";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LIGHT_SPOT_EXPONENT = "profile_GLSL__technique__pass__light_spot_exponent";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LINE_SMOOTH_ENABLE = "profile_GLSL__technique__pass__line_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LINE_WIDTH = "profile_GLSL__technique__pass__line_width";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__LOGIC_OP = "profile_GLSL__technique__pass__logic_op";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MATERIAL_AMBIENT = "profile_GLSL__technique__pass__material_ambient";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MATERIAL_DIFFUSE = "profile_GLSL__technique__pass__material_diffuse";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MATERIAL_EMISSION = "profile_GLSL__technique__pass__material_emission";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MATERIAL_SHININESS = "profile_GLSL__technique__pass__material_shininess";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MATERIAL_SPECULAR = "profile_GLSL__technique__pass__material_specular";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MODEL_VIEW_MATRIX = "profile_GLSL__technique__pass__model_view_matrix";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__MULTISAMPLE_ENABLE = "profile_GLSL__technique__pass__multisample_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__NORMALIZE_ENABLE = "profile_GLSL__technique__pass__normalize_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POINT_DISTANCE_ATTENUATION = "profile_GLSL__technique__pass__point_distance_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POINT_FADE_THRESHOLD_SIZE = "profile_GLSL__technique__pass__point_fade_threshold_size";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POINT_SIZE = "profile_GLSL__technique__pass__point_size";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POINT_SIZE_MAX = "profile_GLSL__technique__pass__point_size_max";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POINT_SIZE_MIN = "profile_GLSL__technique__pass__point_size_min";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POINT_SMOOTH_ENABLE = "profile_GLSL__technique__pass__point_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POLYGON_OFFSET = "profile_GLSL__technique__pass__polygon_offset";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__POLYGON_OFFSET_FILL_ENABLE = "profile_GLSL__technique__pass__polygon_offset_fill_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__PROJECTION_MATRIX = "profile_GLSL__technique__pass__projection_matrix";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__RESCALE_NORMAL_ENABLE = "profile_GLSL__technique__pass__rescale_normal_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "profile_GLSL__technique__pass__sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SAMPLE_ALPHA_TO_ONE_ENABLE = "profile_GLSL__technique__pass__sample_alpha_to_one_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SAMPLE_COVERAGE_ENABLE = "profile_GLSL__technique__pass__sample_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SCISSOR = "profile_GLSL__technique__pass__scissor";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SCISSOR_TEST_ENABLE = "profile_GLSL__technique__pass__scissor_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SHADER = "profile_GLSL__technique__pass__shader";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SHADER__BIND = "profile_GLSL__technique__pass__shader__bind";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SHADER__BIND__PARAM = "profile_GLSL__technique__pass__shader__bind__param";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SHADER__COMPILER_TARGET = "profile_GLSL__technique__pass__shader__compiler_target";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SHADER__NAME = "profile_GLSL__technique__pass__shader__name";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__SHADE_MODEL = "profile_GLSL__technique__pass__shade_model";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_FUNC = "profile_GLSL__technique__pass__stencil_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_FUNC__FUNC = "profile_GLSL__technique__pass__stencil_func__func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_FUNC__MASK = "profile_GLSL__technique__pass__stencil_func__mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_FUNC__REF = "profile_GLSL__technique__pass__stencil_func__ref";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_MASK = "profile_GLSL__technique__pass__stencil_mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_OP = "profile_GLSL__technique__pass__stencil_op";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_OP__FAIL = "profile_GLSL__technique__pass__stencil_op__fail";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_OP__ZFAIL = "profile_GLSL__technique__pass__stencil_op__zfail";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_OP__ZPASS = "profile_GLSL__technique__pass__stencil_op__zpass";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STENCIL_TEST_ENABLE = "profile_GLSL__technique__pass__stencil_test_enable";
const char* NAME_ELEMENT_PROJECTION_MATRIX = "projection_matrix";
const char* NAME_ELEMENT_QUADRATIC_ATTENUATION = "quadratic_attenuation";
const char* NAME_ELEMENT_RADIUS = "radius";
const char* NAME_ELEMENT_RADIUS1 = "radius1";
const char* NAME_ELEMENT_RADIUS2 = "radius2";
const char* NAME_ELEMENT_RADIUS____FLOAT = "radius____float";
const char* NAME_ELEMENT_RADIUS____FLOAT2 = "radius____float2";
const char* NAME_ELEMENT_RANGE = "range";
const char* NAME_ELEMENT_REF = NAME_ATTRIBUTE_ref;
const char* NAME_ELEMENT_REFLECTIVE = "reflective";
const char* NAME_ELEMENT_REFLECTIVITY = "reflectivity";
const char* NAME_ELEMENT_REF_ATTACHMENT = "ref_attachment";
const char* NAME_ELEMENT_RENDER = "render";
const char* NAME_ELEMENT_RESCALE_NORMAL_ENABLE = "rescale_normal_enable";
const char* NAME_ELEMENT_RESTITUTION = "restitution";
const char* NAME_ELEMENT_REVISION = "revision";
const char* NAME_ELEMENT_RGB = "RGB";
const char* NAME_ELEMENT_RIGID_BODY = "rigid_body";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON = "rigid_body__technique_common";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__DYNAMIC = "rigid_body__technique_common__dynamic";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__MASS_FRAME = "rigid_body__technique_common__mass_frame";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__SHAPE = "rigid_body__technique_common__shape";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__SHAPE__HOLLOW = "rigid_body__technique_common__shape__hollow";
const char* NAME_ELEMENT_RIGID_CONSTRAINT = "rigid_constraint";
const char* NAME_ELEMENT_RIGID_CONSTRAINT__TECHNIQUE_COMMON = "rigid_constraint__technique_common";
const char* NAME_ELEMENT_ROTATE = "rotate";
const char* NAME_ELEMENT_SAMPLER = "sampler";
const char* NAME_ELEMENT_SAMPLER1D = "sampler1D";
const char* NAME_ELEMENT_SAMPLER1D____CG_SAMPLER1D = "sampler1D____cg_sampler1D";
const char* NAME_ELEMENT_SAMPLER1D____FX_SAMPLER1D_COMMON = "sampler1D____fx_sampler1D_common";
const char* NAME_ELEMENT_SAMPLER1D____GL_SAMPLER1D = "sampler1D____gl_sampler1D";
const char* NAME_ELEMENT_SAMPLER2D = "sampler2D";
const char* NAME_ELEMENT_SAMPLER2D____CG_SAMPLER2D = "sampler2D____cg_sampler2D";
const char* NAME_ELEMENT_SAMPLER2D____FX_SAMPLER2D_COMMON = "sampler2D____fx_sampler2D_common";
const char* NAME_ELEMENT_SAMPLER2D____GL_SAMPLER2D = "sampler2D____gl_sampler2D";
const char* NAME_ELEMENT_SAMPLER3D = "sampler3D";
const char* NAME_ELEMENT_SAMPLER3D____CG_SAMPLER3D = "sampler3D____cg_sampler3D";
const char* NAME_ELEMENT_SAMPLER3D____FX_SAMPLER3D_COMMON = "sampler3D____fx_sampler3D_common";
const char* NAME_ELEMENT_SAMPLER3D____GL_SAMPLER3D = "sampler3D____gl_sampler3D";
const char* NAME_ELEMENT_SAMPLERCUBE = "samplerCUBE";
const char* NAME_ELEMENT_SAMPLERCUBE____CG_SAMPLERCUBE = "samplerCUBE____cg_samplerCUBE";
const char* NAME_ELEMENT_SAMPLERCUBE____FX_SAMPLERCUBE_COMMON = "samplerCUBE____fx_samplerCUBE_common";
const char* NAME_ELEMENT_SAMPLERCUBE____GL_SAMPLERCUBE = "samplerCUBE____gl_samplerCUBE";
const char* NAME_ELEMENT_SAMPLERDEPTH = "samplerDEPTH";
const char* NAME_ELEMENT_SAMPLERDEPTH____CG_SAMPLERDEPTH = "samplerDEPTH____cg_samplerDEPTH";
const char* NAME_ELEMENT_SAMPLERDEPTH____FX_SAMPLERDEPTH_COMMON = "samplerDEPTH____fx_samplerDEPTH_common";
const char* NAME_ELEMENT_SAMPLERDEPTH____GL_SAMPLERDEPTH = "samplerDEPTH____gl_samplerDEPTH";
const char* NAME_ELEMENT_SAMPLERRECT = "samplerRECT";
const char* NAME_ELEMENT_SAMPLERRECT____CG_SAMPLERRECT = "samplerRECT____cg_samplerRECT";
const char* NAME_ELEMENT_SAMPLERRECT____FX_SAMPLERRECT_COMMON = "samplerRECT____fx_samplerRECT_common";
const char* NAME_ELEMENT_SAMPLERRECT____GL_SAMPLERRECT = "samplerRECT____gl_samplerRECT";
const char* NAME_ELEMENT_SAMPLER_STATE = "sampler_state";
const char* NAME_ELEMENT_SAMPLER_STATE____GLES_SAMPLER_STATE = "sampler_state____gles_sampler_state";
const char* NAME_ELEMENT_SAMPLER_STATE____NCNAME = "sampler_state____NCName";
const char* NAME_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE = "sample_alpha_to_one_enable";
const char* NAME_ELEMENT_SAMPLE_COVERAGE_ENABLE = "sample_coverage_enable";
const char* NAME_ELEMENT_SCALE = "scale";
const char* NAME_ELEMENT_SCENE = "scene";
const char* NAME_ELEMENT_SCISSOR = "scissor";
const char* NAME_ELEMENT_SCISSOR_TEST_ENABLE = "scissor_test_enable";
const char* NAME_ELEMENT_SEMANTIC = NAME_ATTRIBUTE_semantic;
const char* NAME_ELEMENT_SETPARAM = "setparam";
const char* NAME_ELEMENT_SETPARAM____CG_SETPARAM = "setparam____cg_setparam";
const char* NAME_ELEMENT_SETPARAM____CG_SETPARAM_SIMPLE = "setparam____cg_setparam_simple";
const char* NAME_ELEMENT_SETPARAM____GLSL_SETPARAM = "setparam____glsl_setparam";
const char* NAME_ELEMENT_SETPARAM____GLSL_SETPARAM_SIMPLE = "setparam____glsl_setparam_simple";
const char* NAME_ELEMENT_SHADER = "shader";
const char* NAME_ELEMENT_SHADE_MODEL = "shade_model";
const char* NAME_ELEMENT_SHAPE = "shape";
const char* NAME_ELEMENT_SHININESS = "shininess";
const char* NAME_ELEMENT_SIZE = "size";
const char* NAME_ELEMENT_SIZE____FLOAT3 = "size____float3";
const char* NAME_ELEMENT_SIZE____INT3 = "size____int3";
const char* NAME_ELEMENT_SKELETON = "skeleton";
const char* NAME_ELEMENT_SKEW = "skew";
const char* NAME_ELEMENT_SKIN = "skin";
const char* NAME_ELEMENT_SOURCE = "source";
const char* NAME_ELEMENT_SOURCE_DATA = "source_data";
const char* NAME_ELEMENT_SOURCE____NCNAME = "source____NCName";
const char* NAME_ELEMENT_SPECULAR = "specular";
const char* NAME_ELEMENT_SPHERE = "sphere";
const char* NAME_ELEMENT_SPLINE = "spline";
const char* NAME_ELEMENT_SPOT = "spot";
const char* NAME_ELEMENT_SPRING = "spring";
const char* NAME_ELEMENT_SPRING__LINEAR = "spring__linear";
const char* NAME_ELEMENT_SRC = "src";
const char* NAME_ELEMENT_SRC_ALPHA = "src_alpha";
const char* NAME_ELEMENT_SRC_RGB = "src_rgb";
const char* NAME_ELEMENT_STATIC_FRICTION = "static_friction";
const char* NAME_ELEMENT_STENCIL_CLEAR = "stencil_clear";
const char* NAME_ELEMENT_STENCIL_CLEAR____BYTE = "stencil_clear____byte";
const char* NAME_ELEMENT_STENCIL_CLEAR____FX_CLEARSTENCIL_COMMON = "stencil_clear____fx_clearstencil_common";
const char* NAME_ELEMENT_STENCIL_FUNC = "stencil_func";
const char* NAME_ELEMENT_STENCIL_FUNC_SEPARATE = "stencil_func_separate";
const char* NAME_ELEMENT_STENCIL_FUNC_SEPARATE__MASK = "stencil_func_separate__mask";
const char* NAME_ELEMENT_STENCIL_FUNC_SEPARATE__REF = "stencil_func_separate__ref";
const char* NAME_ELEMENT_STENCIL_MASK = "stencil_mask";
const char* NAME_ELEMENT_STENCIL_MASK_SEPARATE = "stencil_mask_separate";
const char* NAME_ELEMENT_STENCIL_MASK_SEPARATE__FACE = "stencil_mask_separate__face";
const char* NAME_ELEMENT_STENCIL_MASK_SEPARATE__MASK = "stencil_mask_separate__mask";
const char* NAME_ELEMENT_STENCIL_OP = "stencil_op";
const char* NAME_ELEMENT_STENCIL_OP_SEPARATE = "stencil_op_separate";
const char* NAME_ELEMENT_STENCIL_OP_SEPARATE__FACE = "stencil_op_separate__face";
const char* NAME_ELEMENT_STENCIL_OP_SEPARATE__FAIL = "stencil_op_separate__fail";
const char* NAME_ELEMENT_STENCIL_OP_SEPARATE__ZFAIL = "stencil_op_separate__zfail";
const char* NAME_ELEMENT_STENCIL_OP_SEPARATE__ZPASS = "stencil_op_separate__zpass";
const char* NAME_ELEMENT_STENCIL_TARGET = "stencil_target";
const char* NAME_ELEMENT_STENCIL_TARGET____FX_STENCILTARGET_COMMON = "stencil_target____fx_stenciltarget_common";
const char* NAME_ELEMENT_STENCIL_TARGET____GLES_RENDERTARGET_COMMON = "stencil_target____gles_rendertarget_common";
const char* NAME_ELEMENT_STENCIL_TEST_ENABLE = "stencil_test_enable";
const char* NAME_ELEMENT_STIFFNESS = "stiffness";
const char* NAME_ELEMENT_STRING = "string";
const char* NAME_ELEMENT_SUBJECT = "subject";
const char* NAME_ELEMENT_SURFACE = "surface";
const char* NAME_ELEMENT_SURFACE____CG_SURFACE_TYPE = "surface____cg_surface_type";
const char* NAME_ELEMENT_SURFACE____FX_SURFACE_COMMON = "surface____fx_surface_common";
const char* NAME_ELEMENT_SURFACE____GLSL_SURFACE_TYPE = "surface____glsl_surface_type";
const char* NAME_ELEMENT_SURFACE____NCNAME = "surface____NCName";
const char* NAME_ELEMENT_SWING_CONE_AND_TWIST = "swing_cone_and_twist";
const char* NAME_ELEMENT_TAPERED_CAPSULE = "tapered_capsule";
const char* NAME_ELEMENT_TAPERED_CYLINDER = "tapered_cylinder";
const char* NAME_ELEMENT_TARGETS = "targets";
const char* NAME_ELEMENT_TARGET_VALUE = "target_value";
const char* NAME_ELEMENT_TECHNIQUE = "technique";
const char* NAME_ELEMENT_TECHNIQUE_COMMON = "technique_common";
const char* NAME_ELEMENT_TECHNIQUE_HINT = "technique_hint";
const char* NAME_ELEMENT_TEXCOMBINER = "texcombiner";
const char* NAME_ELEMENT_TEXCOORD = "texcoord";
const char* NAME_ELEMENT_TEXENV = "texenv";
const char* NAME_ELEMENT_TEXTURE = "texture";
const char* NAME_ELEMENT_TEXTURE1D = "texture1D";
const char* NAME_ELEMENT_TEXTURE1D_ENABLE = "texture1D_enable";
const char* NAME_ELEMENT_TEXTURE2D = "texture2D";
const char* NAME_ELEMENT_TEXTURE2D_ENABLE = "texture2D_enable";
const char* NAME_ELEMENT_TEXTURE3D = "texture3D";
const char* NAME_ELEMENT_TEXTURE3D_ENABLE = "texture3D_enable";
const char* NAME_ELEMENT_TEXTURECUBE = "textureCUBE";
const char* NAME_ELEMENT_TEXTURECUBE_ENABLE = "textureCUBE_enable";
const char* NAME_ELEMENT_TEXTUREDEPTH = "textureDEPTH";
const char* NAME_ELEMENT_TEXTUREDEPTH_ENABLE = "textureDEPTH_enable";
const char* NAME_ELEMENT_TEXTURERECT = "textureRECT";
const char* NAME_ELEMENT_TEXTURERECT_ENABLE = "textureRECT_enable";
const char* NAME_ELEMENT_TEXTURE_ENV_COLOR = "texture_env_color";
const char* NAME_ELEMENT_TEXTURE_ENV_MODE = "texture_env_mode";
const char* NAME_ELEMENT_TEXTURE_PIPELINE = "texture_pipeline";
const char* NAME_ELEMENT_TEXTURE_PIPELINE_ENABLE = "texture_pipeline_enable";
const char* NAME_ELEMENT_TEXTURE_PIPELINE____GLES_TEXTURE_PIPELINE = "texture_pipeline____gles_texture_pipeline";
const char* NAME_ELEMENT_TEXTURE_UNIT = "texture_unit";
const char* NAME_ELEMENT_TIME_STEP = "time_step";
const char* NAME_ELEMENT_TITLE = "title";
const char* NAME_ELEMENT_TRANSLATE = "translate";
const char* NAME_ELEMENT_TRANSPARENCY = "transparency";
const char* NAME_ELEMENT_TRANSPARENT = "transparent";
const char* NAME_ELEMENT_TRIANGLES = "triangles";
const char* NAME_ELEMENT_TRIFANS = "trifans";
const char* NAME_ELEMENT_TRISTRIPS = "tristrips";
const char* NAME_ELEMENT_UNIT = "unit";
const char* NAME_ELEMENT_UP_AXIS = "up_axis";
const char* NAME_ELEMENT_USERTYPE = "usertype";
const char* NAME_ELEMENT_V = "v";
const char* NAME_ELEMENT_VALUE = NAME_ATTRIBUTE_value;
const char* NAME_ELEMENT_VALUE____GLES_TEXTURE_PIPELINE = "value____gles_texture_pipeline";
const char* NAME_ELEMENT_VALUE____GL_SAMPLER1D = "value____gl_sampler1D";
const char* NAME_ELEMENT_VALUE____GL_SAMPLER2D = "value____gl_sampler2D";
const char* NAME_ELEMENT_VALUE____GL_SAMPLER3D = "value____gl_sampler3D";
const char* NAME_ELEMENT_VALUE____GL_SAMPLERCUBE = "value____gl_samplerCUBE";
const char* NAME_ELEMENT_VALUE____GL_SAMPLERDEPTH = "value____gl_samplerDEPTH";
const char* NAME_ELEMENT_VALUE____GL_SAMPLERRECT = "value____gl_samplerRECT";
const char* NAME_ELEMENT_VCOUNT = "vcount";
const char* NAME_ELEMENT_VELOCITY = "velocity";
const char* NAME_ELEMENT_VERTEX_WEIGHTS = "vertex_weights";
const char* NAME_ELEMENT_VERTICES = "vertices";
const char* NAME_ELEMENT_VIEWPORT_RATIO = "viewport_ratio";
const char* NAME_ELEMENT_VISUAL_SCENE = "visual_scene";
const char* NAME_ELEMENT_WRAP_P = "wrap_p";
const char* NAME_ELEMENT_WRAP_S = "wrap_s";
const char* NAME_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_COMMON = "wrap_s____fx_sampler_wrap_common";
const char* NAME_ELEMENT_WRAP_S____GLES_SAMPLER_WRAP = "wrap_s____gles_sampler_wrap";
const char* NAME_ELEMENT_WRAP_T = "wrap_t";
const char* NAME_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_COMMON = "wrap_t____fx_sampler_wrap_common";
const char* NAME_ELEMENT_WRAP_T____GLES_SAMPLER_WRAP = "wrap_t____gles_sampler_wrap";
const char* NAME_ELEMENT_XFOV = "xfov";
const char* NAME_ELEMENT_XMAG = "xmag";
const char* NAME_ELEMENT_YFOV = "yfov";
const char* NAME_ELEMENT_YMAG = "ymag";
const char* NAME_ELEMENT_ZFAIL = "zfail";
const char* NAME_ELEMENT_ZFAR = "zfar";
const char* NAME_ELEMENT_ZNEAR = "znear";
const char* NAME_ELEMENT_ZPASS = "zpass";



//---------------------------------------------------------------------
const COLLADA__AttributeData COLLADA__AttributeData::DEFAULT = {0, ENUM__VersionType__NOT_PRESENT, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__COLLADA( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__COLLADA( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__COLLADA( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

COLLADA__AttributeData* attributeData = newData<COLLADA__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_version:
    {
bool failed;
attributeData->version = Utils::toEnum<ENUM__VersionType, StringHash, ENUM__VersionType__COUNT>(attributeValue, failed, ENUM__VersionTypeMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLLADA,
        HASH_ATTRIBUTE_version,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_base:
    {
bool failed;
attributeData->base = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLLADA,
        HASH_ATTRIBUTE_base,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= COLLADA__AttributeData::ATTRIBUTE_BASE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_xmlns:
    {
    // ignore

    break;
    }
    default:
    {
        StringHashPair hashPair = Utils::calculateStringHashWithNamespace( attribute );
        if ( hashPair.first != HASH_ATTRIBUTE_xmlns )
        {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLLADA, attribute, attributeValue))
            {return false;}        }
        else
        {
            // ignore
        }

    }
    }
    }
}
if ((attributeData->present_attributes & COLLADA__AttributeData::ATTRIBUTE_BASE_PRESENT) == 0)
{
    attributeData->base = COLLADABU::URI("");
}
if ( attributeData->version == ENUM__VersionType__NOT_PRESENT )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_COLLADA, HASH_ATTRIBUTE_version, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__COLLADA()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__COLLADA();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__COLLADA( void* attributeData )
{
    COLLADA__AttributeData* typedAttributeData = static_cast<COLLADA__AttributeData*>(attributeData);

    typedAttributeData->~COLLADA__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__VersionType ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__VersionType (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__VersionType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__VersionType, StringHash, ENUM__VersionType__COUNT, &toEnum_ENUM__VersionType>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__VersionType (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__VersionType*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__VersionType, StringHash, ENUM__VersionType__COUNT>(text, textLength, dataFunction, ENUM__VersionTypeMap, baseConversionFunc, &toEnum_ENUM__VersionType, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__VersionType);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__VersionType (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__VersionType*, size_t ),
    const std::pair<StringHash, ENUM__VersionType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__VersionType (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__VersionType>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__VersionType, StringHash, ENUM__VersionType__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__asset( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__asset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__asset( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__asset()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__asset();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__asset( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__contributor( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__contributor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__contributor( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__contributor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__contributor();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__contributor( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__author( const ParserChar* text, size_t textLength )
{

return mImpl->data__author(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__author( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__author( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__author()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__author();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__author( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__authoring_tool( const ParserChar* text, size_t textLength )
{

return mImpl->data__authoring_tool(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__authoring_tool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__authoring_tool( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__authoring_tool()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__authoring_tool();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__authoring_tool( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__comments( const ParserChar* text, size_t textLength )
{

return mImpl->data__comments(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__comments( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__comments( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__comments()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__comments();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__comments( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__copyright( const ParserChar* text, size_t textLength )
{

return mImpl->data__copyright(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__copyright( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__copyright( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__copyright()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__copyright();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__copyright( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__source_data( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__source_data( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__source_data( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__source_data()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__source_data();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
COLLADABU::URI parameter = GeneratedSaxParser::Utils::toURI((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__source_data(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_SOURCE_DATA, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__source_data( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__created( const ParserChar* text, size_t textLength )
{

return mImpl->data__created(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__created( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__created( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__created()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__created();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__created( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__keywords( const ParserChar* text, size_t textLength )
{

return mImpl->data__keywords(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__keywords( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__keywords( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__keywords()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__keywords();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__keywords( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__modified( const ParserChar* text, size_t textLength )
{

return mImpl->data__modified(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__modified( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__modified( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__modified()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__modified();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__modified( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__revision( const ParserChar* text, size_t textLength )
{

return mImpl->data__revision(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__revision( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__revision( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__revision()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__revision();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__revision( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__subject( const ParserChar* text, size_t textLength )
{

return mImpl->data__subject(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__subject( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__subject( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__subject()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__subject();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__subject( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__title( const ParserChar* text, size_t textLength )
{

return mImpl->data__title(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__title( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__title( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__title()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__title();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__title( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const unit__AttributeData unit__AttributeData::DEFAULT = {1.0E0, (const ParserChar*)"meter"};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__unit( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__unit( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__unit( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

unit__AttributeData* attributeData = newData<unit__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_meter:
    {
bool failed;
attributeData->meter = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_UNIT,
        HASH_ATTRIBUTE_meter,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_UNIT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_UNIT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__unit()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__unit();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__unit( void* attributeData )
{
    unit__AttributeData* typedAttributeData = static_cast<unit__AttributeData*>(attributeData);

    typedAttributeData->~unit__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__up_axis( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__up_axis( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__up_axis( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__up_axis()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__up_axis();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__UpAxisType parameter = Utils::toEnum<ENUM__UpAxisType, StringHash, ENUM__UpAxisType__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__UpAxisTypeMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__up_axis(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__up_axis( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__UpAxisType ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__UpAxisType (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__UpAxisType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__UpAxisType, StringHash, ENUM__UpAxisType__COUNT, &toEnum_ENUM__UpAxisType>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__UpAxisType (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__UpAxisType*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__UpAxisType, StringHash, ENUM__UpAxisType__COUNT>(text, textLength, dataFunction, ENUM__UpAxisTypeMap, baseConversionFunc, &toEnum_ENUM__UpAxisType, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__UpAxisType);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__UpAxisType (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__UpAxisType*, size_t ),
    const std::pair<StringHash, ENUM__UpAxisType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__UpAxisType (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__UpAxisType>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__UpAxisType, StringHash, ENUM__UpAxisType__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const library_animations__AttributeData library_animations__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_animations( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_animations( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_animations( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_animations__AttributeData* attributeData = newData<library_animations__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_ANIMATIONS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_ANIMATIONS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_animations()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_animations();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_animations( void* attributeData )
{
    library_animations__AttributeData* typedAttributeData = static_cast<library_animations__AttributeData*>(attributeData);

    typedAttributeData->~library_animations__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const animation__AttributeData animation__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__animation( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__animation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

animation__AttributeData* attributeData = newData<animation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ANIMATION,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ANIMATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__animation();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__animation( void* attributeData )
{
    animation__AttributeData* typedAttributeData = static_cast<animation__AttributeData*>(attributeData);

    typedAttributeData->~animation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const source__AttributeData source__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__source( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__source( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__source( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

source__AttributeData* attributeData = newData<source__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_SOURCE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SOURCE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SOURCE, HASH_ATTRIBUTE_id, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__source()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__source();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__source( void* attributeData )
{
    source__AttributeData* typedAttributeData = static_cast<source__AttributeData*>(attributeData);

    typedAttributeData->~source__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const IDREF_array__AttributeData IDREF_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__IDREF_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        IDREF_array__ValidationData* validationData = (IDREF_array__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2StringData(text, textLength, &ColladaParserAutoGen14::data__IDREF_array, &validate__IDREFS__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen14::data__IDREF_array);
    }
#else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen14::data__IDREF_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__IDREF_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__IDREF_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

IDREF_array__AttributeData* attributeData = newData<IDREF_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_IDREF_ARRAY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_IDREF_ARRAY,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= IDREF_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_IDREF_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & IDREF_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_IDREF_ARRAY, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__IDREF_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__IDREF_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        IDREF_array__ValidationData* validationData = (IDREF_array__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = stringListDataEnd( &ColladaParserAutoGen14::data__IDREF_array, &validate__IDREFS__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__IDREFS(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_IDREF_ARRAY,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return stringListDataEnd( &ColladaParserAutoGen14::data__IDREF_array );
    }
#else
    {
return stringListDataEnd( &ColladaParserAutoGen14::data__IDREF_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__IDREF_array( void* attributeData )
{
    IDREF_array__AttributeData* typedAttributeData = static_cast<IDREF_array__AttributeData*>(attributeData);

    typedAttributeData->~IDREF_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const Name_array__AttributeData Name_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__Name_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen14::data__Name_array, 0, 0, &validate__Name);
    }
    else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen14::data__Name_array);
    }
#else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen14::data__Name_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__Name_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__Name_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

Name_array__AttributeData* attributeData = newData<Name_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NAME_ARRAY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NAME_ARRAY,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= Name_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NAME_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & Name_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NAME_ARRAY, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__Name_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__Name_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = stringListDataEnd( &ColladaParserAutoGen14::data__Name_array, 0, 0, &validate__Name );
        return returnValue;
    }
    else
    {
return stringListDataEnd( &ColladaParserAutoGen14::data__Name_array );
    }
#else
    {
return stringListDataEnd( &ColladaParserAutoGen14::data__Name_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__Name_array( void* attributeData )
{
    Name_array__AttributeData* typedAttributeData = static_cast<Name_array__AttributeData*>(attributeData);

    typedAttributeData->~Name_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const bool_array__AttributeData bool_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bool_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool_array, 0, 0, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool_array);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bool_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

bool_array__AttributeData* attributeData = newData<bool_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_BOOL_ARRAY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BOOL_ARRAY,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= bool_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BOOL_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & bool_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BOOL_ARRAY, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bool_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = boolDataEnd( &ColladaParserAutoGen14::data__bool_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool_array );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bool_array( void* attributeData )
{
    bool_array__AttributeData* typedAttributeData = static_cast<bool_array__AttributeData*>(attributeData);

    typedAttributeData->~bool_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const float_array__AttributeData float_array__AttributeData::DEFAULT = {0, 0, 0, 0, 6, 38};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float_array, 0, 0, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float_array);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

float_array__AttributeData* attributeData = newData<float_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FLOAT_ARRAY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FLOAT_ARRAY,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= float_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_digits:
    {
bool failed;
attributeData->digits = GeneratedSaxParser::Utils::toSint16(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FLOAT_ARRAY,
        HASH_ATTRIBUTE_digits,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_magnitude:
    {
bool failed;
attributeData->magnitude = GeneratedSaxParser::Utils::toSint16(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FLOAT_ARRAY,
        HASH_ATTRIBUTE_magnitude,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FLOAT_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & float_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_FLOAT_ARRAY, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float_array );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float_array( void* attributeData )
{
    float_array__AttributeData* typedAttributeData = static_cast<float_array__AttributeData*>(attributeData);

    typedAttributeData->~float_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const int_array__AttributeData int_array__AttributeData::DEFAULT = {0, 0, 0, 0, -2147483647-1, 2147483647};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__int_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int_array, 0, 0, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int_array);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__int_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

int_array__AttributeData* attributeData = newData<int_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INT_ARRAY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INT_ARRAY,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= int_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_minInclusive:
    {
bool failed;
attributeData->minInclusive = GeneratedSaxParser::Utils::toSint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INT_ARRAY,
        HASH_ATTRIBUTE_minInclusive,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_maxInclusive:
    {
bool failed;
attributeData->maxInclusive = GeneratedSaxParser::Utils::toSint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INT_ARRAY,
        HASH_ATTRIBUTE_maxInclusive,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INT_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & int_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INT_ARRAY, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__int_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = sint64DataEnd( &ColladaParserAutoGen14::data__int_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int_array );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__int_array( void* attributeData )
{
    int_array__AttributeData* typedAttributeData = static_cast<int_array__AttributeData*>(attributeData);

    typedAttributeData->~int_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__animation__source__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__animation__source__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__animation__source__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__animation__source__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__animation__source__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__animation__source__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const accessor__AttributeData accessor__AttributeData::DEFAULT = {0, 0, 0, 0, 1};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__accessor( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__accessor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__accessor( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

accessor__AttributeData* attributeData = newData<accessor__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= accessor__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_offset:
    {
bool failed;
attributeData->offset = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_offset,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_source:
    {
bool failed;
attributeData->source = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_source,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= accessor__AttributeData::ATTRIBUTE_SOURCE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_stride:
    {
bool failed;
attributeData->stride = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_stride,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ACCESSOR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & accessor__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0)
{
    attributeData->source = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & accessor__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ACCESSOR, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__accessor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__accessor();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__accessor( void* attributeData )
{
    accessor__AttributeData* typedAttributeData = static_cast<accessor__AttributeData*>(attributeData);

    typedAttributeData->~accessor__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const param__AttributeData param__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__param( const ParserChar* text, size_t textLength )
{

return mImpl->data__param(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__param( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

param__AttributeData* attributeData = newData<param__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_semantic:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_type:
    {

attributeData->type = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->type, strlen(attributeData->type));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_type,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->type )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PARAM, HASH_ATTRIBUTE_type, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__param()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__param();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__param( void* attributeData )
{
    param__AttributeData* typedAttributeData = static_cast<param__AttributeData*>(attributeData);

    typedAttributeData->~param__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const technique__AttributeData technique__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__technique( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__technique( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__technique( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

technique__AttributeData* attributeData = newData<technique__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_profile:
    {

attributeData->profile = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->profile, strlen(attributeData->profile));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE,
            HASH_ATTRIBUTE_profile,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TECHNIQUE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->profile )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TECHNIQUE, HASH_ATTRIBUTE_profile, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__technique()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__technique();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__technique( void* attributeData )
{
    technique__AttributeData* typedAttributeData = static_cast<technique__AttributeData*>(attributeData);

    typedAttributeData->~technique__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const sampler__AttributeData sampler__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sampler( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sampler( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

sampler__AttributeData* attributeData = newData<sampler__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SAMPLER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sampler()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sampler( void* attributeData )
{
    sampler__AttributeData* typedAttributeData = static_cast<sampler__AttributeData*>(attributeData);

    typedAttributeData->~sampler__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const input____InputLocal__AttributeData input____InputLocal__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__input____InputLocal( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__input____InputLocal( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__input____InputLocal( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

input____InputLocal__AttributeData* attributeData = newData<input____InputLocal__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_semantic:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_source:
    {

attributeData->source = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__URIFragmentType(attributeData->source, strlen(attributeData->source));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_source,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INPUT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_semantic, 0 ) )
        return false;
}
if ( !attributeData->source )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_source, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__input____InputLocal()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__input____InputLocal();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__input____InputLocal( void* attributeData )
{
    input____InputLocal__AttributeData* typedAttributeData = static_cast<input____InputLocal__AttributeData*>(attributeData);

    typedAttributeData->~input____InputLocal__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const channel__AttributeData channel__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__channel( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__channel( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__channel( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

channel__AttributeData* attributeData = newData<channel__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_source:
    {

attributeData->source = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__URIFragmentType(attributeData->source, strlen(attributeData->source));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CHANNEL,
            HASH_ATTRIBUTE_source,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_target:
    {

attributeData->target = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CHANNEL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->source )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_CHANNEL, HASH_ATTRIBUTE_source, 0 ) )
        return false;
}
if ( !attributeData->target )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_CHANNEL, HASH_ATTRIBUTE_target, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__channel()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__channel();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__channel( void* attributeData )
{
    channel__AttributeData* typedAttributeData = static_cast<channel__AttributeData*>(attributeData);

    typedAttributeData->~channel__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const extra__AttributeData extra__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__extra( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__extra( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__extra( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

extra__AttributeData* attributeData = newData<extra__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_EXTRA,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_type:
    {

attributeData->type = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->type, strlen(attributeData->type));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_EXTRA,
            HASH_ATTRIBUTE_type,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_EXTRA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__extra()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__extra();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__extra( void* attributeData )
{
    extra__AttributeData* typedAttributeData = static_cast<extra__AttributeData*>(attributeData);

    typedAttributeData->~extra__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_animation_clips__AttributeData library_animation_clips__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_animation_clips( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_animation_clips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_animation_clips( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_animation_clips__AttributeData* attributeData = newData<library_animation_clips__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_animation_clips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_animation_clips();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_animation_clips( void* attributeData )
{
    library_animation_clips__AttributeData* typedAttributeData = static_cast<library_animation_clips__AttributeData*>(attributeData);

    typedAttributeData->~library_animation_clips__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const animation_clip__AttributeData animation_clip__AttributeData::DEFAULT = {0, 0, 0, 0.0E1, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__animation_clip( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__animation_clip( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__animation_clip( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

animation_clip__AttributeData* attributeData = newData<animation_clip__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ANIMATION_CLIP,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_start:
    {
bool failed;
attributeData->start = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ANIMATION_CLIP,
        HASH_ATTRIBUTE_start,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_end:
    {
bool failed;
attributeData->end = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ANIMATION_CLIP,
        HASH_ATTRIBUTE_end,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= animation_clip__AttributeData::ATTRIBUTE_END_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ANIMATION_CLIP, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__animation_clip()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__animation_clip();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__animation_clip( void* attributeData )
{
    animation_clip__AttributeData* typedAttributeData = static_cast<animation_clip__AttributeData*>(attributeData);

    typedAttributeData->~animation_clip__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_animation__AttributeData instance_animation__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_animation( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_animation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_animation__AttributeData* attributeData = newData<instance_animation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_ANIMATION,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_animation__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_ANIMATION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_ANIMATION,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_ANIMATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_animation__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_animation__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_ANIMATION, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_animation();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_animation( void* attributeData )
{
    instance_animation__AttributeData* typedAttributeData = static_cast<instance_animation__AttributeData*>(attributeData);

    typedAttributeData->~instance_animation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_cameras__AttributeData library_cameras__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_cameras( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_cameras( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_cameras( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_cameras__AttributeData* attributeData = newData<library_cameras__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_CAMERAS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_CAMERAS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_cameras()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_cameras();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_cameras( void* attributeData )
{
    library_cameras__AttributeData* typedAttributeData = static_cast<library_cameras__AttributeData*>(attributeData);

    typedAttributeData->~library_cameras__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const camera__AttributeData camera__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__camera( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__camera( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__camera( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

camera__AttributeData* attributeData = newData<camera__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CAMERA,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CAMERA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__camera()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__camera();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__camera( void* attributeData )
{
    camera__AttributeData* typedAttributeData = static_cast<camera__AttributeData*>(attributeData);

    typedAttributeData->~camera__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__optics( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__optics( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__optics( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__optics()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__optics();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__optics( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__optics__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__optics__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__optics__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__optics__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__optics__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__optics__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__orthographic( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__orthographic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__orthographic( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__orthographic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__orthographic();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__orthographic( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const xmag__AttributeData xmag__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__xmag( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__xmag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__xmag( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

xmag__AttributeData* attributeData = newData<xmag__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_XMAG,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_XMAG, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__xmag()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__xmag();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__xmag(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_XMAG, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__xmag( void* attributeData )
{
    xmag__AttributeData* typedAttributeData = static_cast<xmag__AttributeData*>(attributeData);

    typedAttributeData->~xmag__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const ymag__AttributeData ymag__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__ymag( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__ymag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ymag( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

ymag__AttributeData* attributeData = newData<ymag__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_YMAG,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_YMAG, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__ymag()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ymag();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__ymag(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_YMAG, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__ymag( void* attributeData )
{
    ymag__AttributeData* typedAttributeData = static_cast<ymag__AttributeData*>(attributeData);

    typedAttributeData->~ymag__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const aspect_ratio__AttributeData aspect_ratio__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__aspect_ratio( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__aspect_ratio( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__aspect_ratio( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

aspect_ratio__AttributeData* attributeData = newData<aspect_ratio__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ASPECT_RATIO,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ASPECT_RATIO, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__aspect_ratio()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__aspect_ratio();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__aspect_ratio(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ASPECT_RATIO, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__aspect_ratio( void* attributeData )
{
    aspect_ratio__AttributeData* typedAttributeData = static_cast<aspect_ratio__AttributeData*>(attributeData);

    typedAttributeData->~aspect_ratio__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const znear__AttributeData znear__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__znear( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__znear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__znear( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

znear__AttributeData* attributeData = newData<znear__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ZNEAR,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZNEAR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__znear()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__znear();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__znear(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ZNEAR, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__znear( void* attributeData )
{
    znear__AttributeData* typedAttributeData = static_cast<znear__AttributeData*>(attributeData);

    typedAttributeData->~znear__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const zfar__AttributeData zfar__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__zfar( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__zfar( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__zfar( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

zfar__AttributeData* attributeData = newData<zfar__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ZFAR,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZFAR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__zfar()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__zfar();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__zfar(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ZFAR, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__zfar( void* attributeData )
{
    zfar__AttributeData* typedAttributeData = static_cast<zfar__AttributeData*>(attributeData);

    typedAttributeData->~zfar__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__perspective( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__perspective( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__perspective( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__perspective()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__perspective();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__perspective( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const xfov__AttributeData xfov__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__xfov( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__xfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__xfov( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

xfov__AttributeData* attributeData = newData<xfov__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_XFOV,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_XFOV, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__xfov()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__xfov();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__xfov(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_XFOV, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__xfov( void* attributeData )
{
    xfov__AttributeData* typedAttributeData = static_cast<xfov__AttributeData*>(attributeData);

    typedAttributeData->~xfov__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const yfov__AttributeData yfov__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__yfov( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__yfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__yfov( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

yfov__AttributeData* attributeData = newData<yfov__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_YFOV,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_YFOV, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__yfov()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__yfov();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__yfov(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_YFOV, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__yfov( void* attributeData )
{
    yfov__AttributeData* typedAttributeData = static_cast<yfov__AttributeData*>(attributeData);

    typedAttributeData->~yfov__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__imager( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__imager( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__imager( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__imager()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__imager();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__imager( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const library_controllers__AttributeData library_controllers__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_controllers( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_controllers( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_controllers( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_controllers__AttributeData* attributeData = newData<library_controllers__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_CONTROLLERS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_CONTROLLERS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_controllers()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_controllers();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_controllers( void* attributeData )
{
    library_controllers__AttributeData* typedAttributeData = static_cast<library_controllers__AttributeData*>(attributeData);

    typedAttributeData->~library_controllers__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const controller__AttributeData controller__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__controller( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__controller( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__controller( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

controller__AttributeData* attributeData = newData<controller__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CONTROLLER,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONTROLLER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__controller()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__controller();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__controller( void* attributeData )
{
    controller__AttributeData* typedAttributeData = static_cast<controller__AttributeData*>(attributeData);

    typedAttributeData->~controller__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const skin__AttributeData skin__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__skin( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__skin( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__skin( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

skin__AttributeData* attributeData = newData<skin__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_source:
    {
bool failed;
attributeData->source = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SKIN,
        HASH_ATTRIBUTE_source,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= skin__AttributeData::ATTRIBUTE_SOURCE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SKIN, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & skin__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0)
{
    attributeData->source = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & skin__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SKIN, HASH_ATTRIBUTE_source, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__skin()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__skin();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__skin( void* attributeData )
{
    skin__AttributeData* typedAttributeData = static_cast<skin__AttributeData*>(attributeData);

    typedAttributeData->~skin__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bind_shape_matrix( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__bind_shape_matrix, &validate__float4x4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__bind_shape_matrix);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__bind_shape_matrix);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bind_shape_matrix( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bind_shape_matrix( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bind_shape_matrix()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bind_shape_matrix();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__bind_shape_matrix, &validate__float4x4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BIND_SHAPE_MATRIX,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__bind_shape_matrix );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__bind_shape_matrix );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bind_shape_matrix( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__joints( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__joints( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__joints( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__joints()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__joints();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__joints( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const vertex_weights__AttributeData vertex_weights__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__vertex_weights( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__vertex_weights( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vertex_weights( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

vertex_weights__AttributeData* attributeData = newData<vertex_weights__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_VERTEX_WEIGHTS,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= vertex_weights__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_VERTEX_WEIGHTS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & vertex_weights__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_VERTEX_WEIGHTS, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__vertex_weights()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vertex_weights();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__vertex_weights( void* attributeData )
{
    vertex_weights__AttributeData* typedAttributeData = static_cast<vertex_weights__AttributeData*>(attributeData);

    typedAttributeData->~vertex_weights__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const input____InputLocalOffset__AttributeData input____InputLocalOffset__AttributeData::DEFAULT = {0, 0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__input____InputLocalOffset( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__input____InputLocalOffset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__input____InputLocalOffset( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

input____InputLocalOffset__AttributeData* attributeData = newData<input____InputLocalOffset__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_offset:
    {
bool failed;
attributeData->offset = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INPUT,
        HASH_ATTRIBUTE_offset,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= input____InputLocalOffset__AttributeData::ATTRIBUTE_OFFSET_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_semantic:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_source:
    {

attributeData->source = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__URIFragmentType(attributeData->source, strlen(attributeData->source));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_source,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_set:
    {
bool failed;
attributeData->set = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INPUT,
        HASH_ATTRIBUTE_set,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= input____InputLocalOffset__AttributeData::ATTRIBUTE_SET_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INPUT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & input____InputLocalOffset__AttributeData::ATTRIBUTE_OFFSET_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_offset, 0 ) )
        return false;
}
if ( !attributeData->semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_semantic, 0 ) )
        return false;
}
if ( !attributeData->source )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_source, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__input____InputLocalOffset()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__input____InputLocalOffset();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__input____InputLocalOffset( void* attributeData )
{
    input____InputLocalOffset__AttributeData* typedAttributeData = static_cast<input____InputLocalOffset__AttributeData*>(attributeData);

    typedAttributeData->~input____InputLocalOffset__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__vcount( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__vcount, 0, 0, 0);
    }
    else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__vcount);
    }
#else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__vcount);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__vcount( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vcount( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__vcount()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vcount();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint64DataEnd( &ColladaParserAutoGen14::data__vcount, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint64DataEnd( &ColladaParserAutoGen14::data__vcount );
    }
#else
    {
return uint64DataEnd( &ColladaParserAutoGen14::data__vcount );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__vcount( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__v( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__v, 0, 0, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__v);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__v);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__v( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__v( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__v()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__v();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = sint64DataEnd( &ColladaParserAutoGen14::data__v, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__v );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__v );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__v( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const morph__AttributeData morph__AttributeData::DEFAULT = {0, ENUM__MorphMethodType__NORMALIZED, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__morph( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__morph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__morph( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

morph__AttributeData* attributeData = newData<morph__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_method:
    {
bool failed;
attributeData->method = Utils::toEnum<ENUM__MorphMethodType, StringHash, ENUM__MorphMethodType__COUNT>(attributeValue, failed, ENUM__MorphMethodTypeMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MORPH,
        HASH_ATTRIBUTE_method,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_source:
    {
bool failed;
attributeData->source = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MORPH,
        HASH_ATTRIBUTE_source,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= morph__AttributeData::ATTRIBUTE_SOURCE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MORPH, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & morph__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0)
{
    attributeData->source = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & morph__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_MORPH, HASH_ATTRIBUTE_source, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__morph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__morph();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__morph( void* attributeData )
{
    morph__AttributeData* typedAttributeData = static_cast<morph__AttributeData*>(attributeData);

    typedAttributeData->~morph__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__MorphMethodType ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__MorphMethodType (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__MorphMethodType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__MorphMethodType, StringHash, ENUM__MorphMethodType__COUNT, &toEnum_ENUM__MorphMethodType>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__MorphMethodType (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__MorphMethodType*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__MorphMethodType, StringHash, ENUM__MorphMethodType__COUNT>(text, textLength, dataFunction, ENUM__MorphMethodTypeMap, baseConversionFunc, &toEnum_ENUM__MorphMethodType, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__MorphMethodType);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__MorphMethodType (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__MorphMethodType*, size_t ),
    const std::pair<StringHash, ENUM__MorphMethodType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__MorphMethodType (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__MorphMethodType>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__MorphMethodType, StringHash, ENUM__MorphMethodType__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__targets( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__targets( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__targets( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__targets()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__targets();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__targets( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const library_geometries__AttributeData library_geometries__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_geometries( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_geometries( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_geometries( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_geometries__AttributeData* attributeData = newData<library_geometries__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_GEOMETRIES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_GEOMETRIES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_geometries()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_geometries();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_geometries( void* attributeData )
{
    library_geometries__AttributeData* typedAttributeData = static_cast<library_geometries__AttributeData*>(attributeData);

    typedAttributeData->~library_geometries__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const geometry__AttributeData geometry__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__geometry( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__geometry( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__geometry( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

geometry__AttributeData* attributeData = newData<geometry__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_GEOMETRY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_GEOMETRY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__geometry()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__geometry();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__geometry( void* attributeData )
{
    geometry__AttributeData* typedAttributeData = static_cast<geometry__AttributeData*>(attributeData);

    typedAttributeData->~geometry__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const convex_mesh__AttributeData convex_mesh__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__convex_mesh( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__convex_mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__convex_mesh( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

convex_mesh__AttributeData* attributeData = newData<convex_mesh__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_convex_hull_of:
    {
bool failed;
attributeData->convex_hull_of = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_CONVEX_MESH,
        HASH_ATTRIBUTE_convex_hull_of,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= convex_mesh__AttributeData::ATTRIBUTE_CONVEX_HULL_OF_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONVEX_MESH, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & convex_mesh__AttributeData::ATTRIBUTE_CONVEX_HULL_OF_PRESENT) == 0)
{
    attributeData->convex_hull_of = COLLADABU::URI("");
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__convex_mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__convex_mesh();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__convex_mesh( void* attributeData )
{
    convex_mesh__AttributeData* typedAttributeData = static_cast<convex_mesh__AttributeData*>(attributeData);

    typedAttributeData->~convex_mesh__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const vertices__AttributeData vertices__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__vertices( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vertices( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

vertices__AttributeData* attributeData = newData<vertices__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_VERTICES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_VERTICES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_VERTICES, HASH_ATTRIBUTE_id, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vertices();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__vertices( void* attributeData )
{
    vertices__AttributeData* typedAttributeData = static_cast<vertices__AttributeData*>(attributeData);

    typedAttributeData->~vertices__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const lines__AttributeData lines__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__lines( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__lines( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__lines( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

lines__AttributeData* attributeData = newData<lines__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_LINES,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= lines__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINES,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & lines__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_LINES, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__lines()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__lines();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__lines( void* attributeData )
{
    lines__AttributeData* typedAttributeData = static_cast<lines__AttributeData*>(attributeData);

    typedAttributeData->~lines__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__p( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__p, 0, 0, 0);
    }
    else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__p);
    }
#else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__p);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__p( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__p( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__p()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__p();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint64DataEnd( &ColladaParserAutoGen14::data__p, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint64DataEnd( &ColladaParserAutoGen14::data__p );
    }
#else
    {
return uint64DataEnd( &ColladaParserAutoGen14::data__p );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__p( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const linestrips__AttributeData linestrips__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__linestrips( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__linestrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__linestrips( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

linestrips__AttributeData* attributeData = newData<linestrips__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINESTRIPS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_LINESTRIPS,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= linestrips__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINESTRIPS,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINESTRIPS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & linestrips__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_LINESTRIPS, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__linestrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__linestrips();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__linestrips( void* attributeData )
{
    linestrips__AttributeData* typedAttributeData = static_cast<linestrips__AttributeData*>(attributeData);

    typedAttributeData->~linestrips__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const polygons__AttributeData polygons__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__polygons( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__polygons( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__polygons( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

polygons__AttributeData* attributeData = newData<polygons__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYGONS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POLYGONS,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= polygons__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYGONS,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POLYGONS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & polygons__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_POLYGONS, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__polygons()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__polygons();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__polygons( void* attributeData )
{
    polygons__AttributeData* typedAttributeData = static_cast<polygons__AttributeData*>(attributeData);

    typedAttributeData->~polygons__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__ph( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__ph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ph( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__ph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ph();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__ph( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__h( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__h, 0, 0, 0);
    }
    else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__h);
    }
#else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen14::data__h);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__h( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__h( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__h()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__h();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint64DataEnd( &ColladaParserAutoGen14::data__h, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint64DataEnd( &ColladaParserAutoGen14::data__h );
    }
#else
    {
return uint64DataEnd( &ColladaParserAutoGen14::data__h );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__h( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const polylist__AttributeData polylist__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__polylist( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__polylist( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__polylist( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

polylist__AttributeData* attributeData = newData<polylist__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYLIST,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POLYLIST,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= polylist__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYLIST,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POLYLIST, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & polylist__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_POLYLIST, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__polylist()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__polylist();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__polylist( void* attributeData )
{
    polylist__AttributeData* typedAttributeData = static_cast<polylist__AttributeData*>(attributeData);

    typedAttributeData->~polylist__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const triangles__AttributeData triangles__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__triangles( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__triangles( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__triangles( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

triangles__AttributeData* attributeData = newData<triangles__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRIANGLES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRIANGLES,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= triangles__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRIANGLES,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRIANGLES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & triangles__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TRIANGLES, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__triangles()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__triangles();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__triangles( void* attributeData )
{
    triangles__AttributeData* typedAttributeData = static_cast<triangles__AttributeData*>(attributeData);

    typedAttributeData->~triangles__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const trifans__AttributeData trifans__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__trifans( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__trifans( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__trifans( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

trifans__AttributeData* attributeData = newData<trifans__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRIFANS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRIFANS,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= trifans__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRIFANS,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRIFANS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & trifans__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TRIFANS, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__trifans()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__trifans();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__trifans( void* attributeData )
{
    trifans__AttributeData* typedAttributeData = static_cast<trifans__AttributeData*>(attributeData);

    typedAttributeData->~trifans__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const tristrips__AttributeData tristrips__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__tristrips( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__tristrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__tristrips( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

tristrips__AttributeData* attributeData = newData<tristrips__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRISTRIPS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_count:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRISTRIPS,
        HASH_ATTRIBUTE_count,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= tristrips__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_material:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRISTRIPS,
            HASH_ATTRIBUTE_material,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRISTRIPS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & tristrips__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TRISTRIPS, HASH_ATTRIBUTE_count, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__tristrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__tristrips();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__tristrips( void* attributeData )
{
    tristrips__AttributeData* typedAttributeData = static_cast<tristrips__AttributeData*>(attributeData);

    typedAttributeData->~tristrips__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mesh( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mesh( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mesh();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mesh( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const spline__AttributeData spline__AttributeData::DEFAULT = {false};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__spline( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__spline( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__spline( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

spline__AttributeData* attributeData = newData<spline__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_closed:
    {
bool failed;
attributeData->closed = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SPLINE,
        HASH_ATTRIBUTE_closed,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SPLINE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__spline()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__spline();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__spline( void* attributeData )
{
    spline__AttributeData* typedAttributeData = static_cast<spline__AttributeData*>(attributeData);

    typedAttributeData->~spline__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__control_vertices( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__control_vertices( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__control_vertices();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__control_vertices( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const library_effects__AttributeData library_effects__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_effects( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_effects( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_effects( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_effects__AttributeData* attributeData = newData<library_effects__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_EFFECTS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_EFFECTS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_effects()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_effects();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_effects( void* attributeData )
{
    library_effects__AttributeData* typedAttributeData = static_cast<library_effects__AttributeData*>(attributeData);

    typedAttributeData->~library_effects__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const effect__AttributeData effect__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__effect( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__effect( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__effect( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

effect__AttributeData* attributeData = newData<effect__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_EFFECT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_EFFECT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_EFFECT, HASH_ATTRIBUTE_id, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__effect()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__effect();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__effect( void* attributeData )
{
    effect__AttributeData* typedAttributeData = static_cast<effect__AttributeData*>(attributeData);

    typedAttributeData->~effect__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const annotate__AttributeData annotate__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__annotate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__annotate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__annotate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

annotate__AttributeData* attributeData = newData<annotate__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ANNOTATE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ANNOTATE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->name )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ANNOTATE, HASH_ATTRIBUTE_name, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__annotate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__annotate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__annotate( void* attributeData )
{
    annotate__AttributeData* typedAttributeData = static_cast<annotate__AttributeData*>(attributeData);

    typedAttributeData->~annotate__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bool____bool( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bool____bool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool____bool( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bool____bool()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool____bool();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__bool____bool(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_BOOL, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bool____bool( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bool2____bool2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool2____bool2__ValidationData* validationData = (bool2____bool2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool2____bool2, &validate__bool2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool2____bool2);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool2____bool2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bool2____bool2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool2____bool2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bool2____bool2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool2____bool2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool2____bool2__ValidationData* validationData = (bool2____bool2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen14::data__bool2____bool2, &validate__bool2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BOOL2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool2____bool2 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool2____bool2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bool2____bool2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bool3____bool3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool3____bool3__ValidationData* validationData = (bool3____bool3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool3____bool3, &validate__bool3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool3____bool3);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool3____bool3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bool3____bool3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool3____bool3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bool3____bool3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool3____bool3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool3____bool3__ValidationData* validationData = (bool3____bool3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen14::data__bool3____bool3, &validate__bool3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BOOL3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool3____bool3 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool3____bool3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bool3____bool3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bool4____bool4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool4____bool4__ValidationData* validationData = (bool4____bool4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool4____bool4, &validate__bool4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool4____bool4);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen14::data__bool4____bool4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bool4____bool4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool4____bool4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bool4____bool4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool4____bool4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool4____bool4__ValidationData* validationData = (bool4____bool4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen14::data__bool4____bool4, &validate__bool4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BOOL4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool4____bool4 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen14::data__bool4____bool4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bool4____bool4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__int____int( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__int____int( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int____int( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__int____int()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int____int();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
sint64 parameter = GeneratedSaxParser::Utils::toSint64((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__int____int(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_INT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__int____int( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__int2____int2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int2____int2__ValidationData* validationData = (int2____int2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int2____int2, &validate__int2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int2____int2);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int2____int2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__int2____int2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int2____int2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__int2____int2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int2____int2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int2____int2__ValidationData* validationData = (int2____int2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen14::data__int2____int2, &validate__int2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INT2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int2____int2 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int2____int2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__int2____int2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__int3____int3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3____int3__ValidationData* validationData = (int3____int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int3____int3, &validate__int3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int3____int3);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int3____int3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__int3____int3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int3____int3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__int3____int3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int3____int3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3____int3__ValidationData* validationData = (int3____int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen14::data__int3____int3, &validate__int3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INT3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int3____int3 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int3____int3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__int3____int3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__int4____int4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int4____int4__ValidationData* validationData = (int4____int4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int4____int4, &validate__int4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int4____int4);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__int4____int4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__int4____int4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int4____int4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__int4____int4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int4____int4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int4____int4__ValidationData* validationData = (int4____int4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen14::data__int4____int4, &validate__int4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INT4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int4____int4 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__int4____int4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__int4____int4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float____float( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float____float( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float____float( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float____float()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float____float();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__float____float(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float____float( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float2____float2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2____float2, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2____float2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2____float2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float2____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2____float2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float2____float2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2____float2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float2____float2, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2____float2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2____float2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float2____float2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float3____float3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3____float3, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3____float3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3____float3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float3____float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3____float3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float3____float3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3____float3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float3____float3, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3____float3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3____float3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float3____float3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float4____float4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4____float4, &validate__float4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4____float4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4____float4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float4____float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4____float4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float4____float4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4____float4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float4____float4, &validate__float4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4____float4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4____float4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float4____float4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float2x2____float2x2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x2____float2x2__ValidationData* validationData = (float2x2____float2x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x2____float2x2, &validate__float2x2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x2____float2x2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x2____float2x2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float2x2____float2x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x2____float2x2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float2x2____float2x2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x2____float2x2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x2____float2x2__ValidationData* validationData = (float2x2____float2x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float2x2____float2x2, &validate__float2x2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x2____float2x2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x2____float2x2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float2x2____float2x2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float3x3____float3x3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3____float3x3__ValidationData* validationData = (float3x3____float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x3____float3x3, &validate__float3x3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x3____float3x3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x3____float3x3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float3x3____float3x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x3____float3x3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float3x3____float3x3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x3____float3x3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3____float3x3__ValidationData* validationData = (float3x3____float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float3x3____float3x3, &validate__float3x3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x3____float3x3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x3____float3x3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float3x3____float3x3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float4x4____float4x4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x4____float4x4, &validate__float4x4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x4____float4x4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x4____float4x4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float4x4____float4x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x4____float4x4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float4x4____float4x4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x4____float4x4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float4x4____float4x4, &validate__float4x4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x4____float4x4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x4____float4x4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float4x4____float4x4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__string( const ParserChar* text, size_t textLength )
{

return mImpl->data__string(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__string( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__string( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__string()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__string();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__string( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const image__AttributeData image__AttributeData::DEFAULT = {0, 0, 0, 0, 0, 0, 1};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__image( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__image( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__image( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

image__AttributeData* attributeData = newData<image__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_IMAGE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_format:
    {

attributeData->format = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_height:
    {
bool failed;
attributeData->height = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_IMAGE,
        HASH_ATTRIBUTE_height,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= image__AttributeData::ATTRIBUTE_HEIGHT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_width:
    {
bool failed;
attributeData->width = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_IMAGE,
        HASH_ATTRIBUTE_width,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= image__AttributeData::ATTRIBUTE_WIDTH_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_depth:
    {
bool failed;
attributeData->depth = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_IMAGE,
        HASH_ATTRIBUTE_depth,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_IMAGE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__image()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__image();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__image( void* attributeData )
{
    image__AttributeData* typedAttributeData = static_cast<image__AttributeData*>(attributeData);

    typedAttributeData->~image__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__data( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint8Data(text, textLength, &ColladaParserAutoGen14::data__data, 0, 0, 0);
    }
    else
    {
return characterData2Uint8Data(text, textLength, &ColladaParserAutoGen14::data__data);
    }
#else
    {
return characterData2Uint8Data(text, textLength, &ColladaParserAutoGen14::data__data);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__data( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__data( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__data()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__data();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint8DataEnd( &ColladaParserAutoGen14::data__data, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint8DataEnd( &ColladaParserAutoGen14::data__data );
    }
#else
    {
return uint8DataEnd( &ColladaParserAutoGen14::data__data );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__data( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_from____anyURI( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_from____anyURI( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_from____anyURI( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_from____anyURI()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_from____anyURI();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
COLLADABU::URI parameter = GeneratedSaxParser::Utils::toURI((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__init_from____anyURI(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_INIT_FROM, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_from____anyURI( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const newparam____fx_newparam_common__AttributeData newparam____fx_newparam_common__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__newparam____fx_newparam_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__newparam____fx_newparam_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__newparam____fx_newparam_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

newparam____fx_newparam_common__AttributeData* attributeData = newData<newparam____fx_newparam_common__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NEWPARAM,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NEWPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NEWPARAM, HASH_ATTRIBUTE_sid, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__newparam____fx_newparam_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__newparam____fx_newparam_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__newparam____fx_newparam_common( void* attributeData )
{
    newparam____fx_newparam_common__AttributeData* typedAttributeData = static_cast<newparam____fx_newparam_common__AttributeData*>(attributeData);

    typedAttributeData->~newparam____fx_newparam_common__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__semantic( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__semantic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__semantic( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__semantic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__semantic();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__semantic(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__semantic( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__modifier( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__modifier( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__modifier( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__modifier()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__modifier();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_modifier_enum_common parameter = Utils::toEnum<ENUM__fx_modifier_enum_common, StringHash, ENUM__fx_modifier_enum_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_modifier_enum_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__modifier(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__modifier( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_modifier_enum_common ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_modifier_enum_common (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_modifier_enum_common>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_modifier_enum_common, StringHash, ENUM__fx_modifier_enum_common__COUNT, &toEnum_ENUM__fx_modifier_enum_common>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_modifier_enum_common (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_modifier_enum_common*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_modifier_enum_common, StringHash, ENUM__fx_modifier_enum_common__COUNT>(text, textLength, dataFunction, ENUM__fx_modifier_enum_commonMap, baseConversionFunc, &toEnum_ENUM__fx_modifier_enum_common, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_modifier_enum_common);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_modifier_enum_common (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_modifier_enum_common*, size_t ),
    const std::pair<StringHash, ENUM__fx_modifier_enum_common>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_modifier_enum_common (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_modifier_enum_common>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_modifier_enum_common, StringHash, ENUM__fx_modifier_enum_common__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float1x1____float( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float1x1____float( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float1x1____float( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float1x1____float()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float1x1____float();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__float1x1____float(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FLOAT1X1, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float1x1____float( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float1x2____float2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x2____float2, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x2____float2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x2____float2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float1x2____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float1x2____float2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float1x2____float2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float1x2____float2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float1x2____float2, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT1X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float1x2____float2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float1x2____float2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float1x2____float2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float1x3____float3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x3____float3, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x3____float3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x3____float3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float1x3____float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float1x3____float3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float1x3____float3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float1x3____float3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float1x3____float3, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT1X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float1x3____float3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float1x3____float3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float1x3____float3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float1x4____float4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x4____float4, &validate__float4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x4____float4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float1x4____float4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float1x4____float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float1x4____float4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float1x4____float4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float1x4____float4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float1x4____float4, &validate__float4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT1X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float1x4____float4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float1x4____float4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float1x4____float4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float2x1____float2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x1____float2, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x1____float2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x1____float2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float2x1____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x1____float2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float2x1____float2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x1____float2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float2x1____float2, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x1____float2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x1____float2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float2x1____float2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float2x3____float2x3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x3____float2x3__ValidationData* validationData = (float2x3____float2x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x3____float2x3, &validate__float2x3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x3____float2x3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x3____float2x3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float2x3____float2x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x3____float2x3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float2x3____float2x3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x3____float2x3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x3____float2x3__ValidationData* validationData = (float2x3____float2x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float2x3____float2x3, &validate__float2x3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x3____float2x3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x3____float2x3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float2x3____float2x3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float2x4____float2x4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x4____float2x4__ValidationData* validationData = (float2x4____float2x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x4____float2x4, &validate__float2x4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x4____float2x4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float2x4____float2x4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float2x4____float2x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x4____float2x4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float2x4____float2x4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x4____float2x4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x4____float2x4__ValidationData* validationData = (float2x4____float2x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float2x4____float2x4, &validate__float2x4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x4____float2x4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float2x4____float2x4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float2x4____float2x4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float3x1____float3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x1____float3, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x1____float3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x1____float3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float3x1____float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x1____float3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float3x1____float3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x1____float3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float3x1____float3, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x1____float3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x1____float3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float3x1____float3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float3x2____float3x2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x2____float3x2__ValidationData* validationData = (float3x2____float3x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x2____float3x2, &validate__float3x2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x2____float3x2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x2____float3x2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float3x2____float3x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x2____float3x2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float3x2____float3x2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x2____float3x2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x2____float3x2__ValidationData* validationData = (float3x2____float3x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float3x2____float3x2, &validate__float3x2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x2____float3x2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x2____float3x2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float3x2____float3x2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float3x4____float3x4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x4____float3x4__ValidationData* validationData = (float3x4____float3x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x4____float3x4, &validate__float3x4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x4____float3x4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float3x4____float3x4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float3x4____float3x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x4____float3x4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float3x4____float3x4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x4____float3x4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x4____float3x4__ValidationData* validationData = (float3x4____float3x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float3x4____float3x4, &validate__float3x4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x4____float3x4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float3x4____float3x4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float3x4____float3x4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float4x1____float4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x1____float4, &validate__float4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x1____float4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x1____float4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float4x1____float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x1____float4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float4x1____float4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x1____float4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float4x1____float4, &validate__float4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x1____float4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x1____float4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float4x1____float4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float4x2____float4x2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x2____float4x2__ValidationData* validationData = (float4x2____float4x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x2____float4x2, &validate__float4x2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x2____float4x2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x2____float4x2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float4x2____float4x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x2____float4x2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float4x2____float4x2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x2____float4x2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x2____float4x2__ValidationData* validationData = (float4x2____float4x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float4x2____float4x2, &validate__float4x2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x2____float4x2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x2____float4x2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float4x2____float4x2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__float4x3____float4x3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x3____float4x3__ValidationData* validationData = (float4x3____float4x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x3____float4x3, &validate__float4x3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x3____float4x3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__float4x3____float4x3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__float4x3____float4x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x3____float4x3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__float4x3____float4x3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x3____float4x3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x3____float4x3__ValidationData* validationData = (float4x3____float4x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__float4x3____float4x3, &validate__float4x3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x3____float4x3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__float4x3____float4x3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__float4x3____float4x3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const surface____fx_surface_common__AttributeData surface____fx_surface_common__AttributeData::DEFAULT = {ENUM__fx_surface_type_enum__NOT_PRESENT};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__surface____fx_surface_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__surface____fx_surface_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__surface____fx_surface_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

surface____fx_surface_common__AttributeData* attributeData = newData<surface____fx_surface_common__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_type:
    {
bool failed;
attributeData->type = Utils::toEnum<ENUM__fx_surface_type_enum, StringHash, ENUM__fx_surface_type_enum__COUNT>(attributeValue, failed, ENUM__fx_surface_type_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SURFACE,
        HASH_ATTRIBUTE_type,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SURFACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( attributeData->type == ENUM__fx_surface_type_enum__NOT_PRESENT )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SURFACE, HASH_ATTRIBUTE_type, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__surface____fx_surface_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__surface____fx_surface_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__surface____fx_surface_common( void* attributeData )
{
    surface____fx_surface_common__AttributeData* typedAttributeData = static_cast<surface____fx_surface_common__AttributeData*>(attributeData);

    typedAttributeData->~surface____fx_surface_common__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__fx_surface_type_enum ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_type_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_surface_type_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_surface_type_enum, StringHash, ENUM__fx_surface_type_enum__COUNT, &toEnum_ENUM__fx_surface_type_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_surface_type_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_type_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_surface_type_enum, StringHash, ENUM__fx_surface_type_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_surface_type_enumMap, baseConversionFunc, &toEnum_ENUM__fx_surface_type_enum, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_type_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_surface_type_enum (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_type_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_surface_type_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_surface_type_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_surface_type_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_surface_type_enum, StringHash, ENUM__fx_surface_type_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const init_as_null__AttributeData init_as_null__AttributeData::DEFAULT = {GeneratedSaxParser::XSList<const ParserChar*>()};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_as_null( const ParserChar* text, size_t textLength )
{

return mImpl->data__init_as_null(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_as_null( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_as_null( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

init_as_null__AttributeData* attributeData = newData<init_as_null__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


        if ( !attributeData->unknownAttributes.data )
            attributeData->unknownAttributes.data = (const ParserChar**)mStackMemoryManager.newObject( 2 * sizeof( const ParserChar* ) );
        else
            attributeData->unknownAttributes.data = (const ParserChar**)mStackMemoryManager.growObject( 2 * sizeof( const ParserChar* ) );
        attributeData->unknownAttributes.data[ attributeData->unknownAttributes.size ] = attribute;
        attributeData->unknownAttributes.data[ attributeData->unknownAttributes.size+1 ] = attributeValue;
        attributeData->unknownAttributes.size += 2;

    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_as_null()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_as_null();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_as_null( void* attributeData )
{
    init_as_null__AttributeData* typedAttributeData = static_cast<init_as_null__AttributeData*>(attributeData);
    if (typedAttributeData->unknownAttributes.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~init_as_null__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const init_as_target__AttributeData init_as_target__AttributeData::DEFAULT = {GeneratedSaxParser::XSList<const ParserChar*>()};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_as_target( const ParserChar* text, size_t textLength )
{

return mImpl->data__init_as_target(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_as_target( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_as_target( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

init_as_target__AttributeData* attributeData = newData<init_as_target__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


        if ( !attributeData->unknownAttributes.data )
            attributeData->unknownAttributes.data = (const ParserChar**)mStackMemoryManager.newObject( 2 * sizeof( const ParserChar* ) );
        else
            attributeData->unknownAttributes.data = (const ParserChar**)mStackMemoryManager.growObject( 2 * sizeof( const ParserChar* ) );
        attributeData->unknownAttributes.data[ attributeData->unknownAttributes.size ] = attribute;
        attributeData->unknownAttributes.data[ attributeData->unknownAttributes.size+1 ] = attributeValue;
        attributeData->unknownAttributes.size += 2;

    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_as_target()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_as_target();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_as_target( void* attributeData )
{
    init_as_target__AttributeData* typedAttributeData = static_cast<init_as_target__AttributeData*>(attributeData);
    if (typedAttributeData->unknownAttributes.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~init_as_target__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_cube( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_cube( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_cube( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_cube()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_cube();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_cube( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const fx_surface_init_cube_common____all__AttributeData fx_surface_init_cube_common____all__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_surface_init_cube_common____all( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_surface_init_cube_common____all( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_surface_init_cube_common____all( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_surface_init_cube_common____all__AttributeData* attributeData = newData<fx_surface_init_cube_common____all__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ALL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ALL, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_surface_init_cube_common____all()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_surface_init_cube_common____all();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_surface_init_cube_common____all( void* attributeData )
{
    fx_surface_init_cube_common____all__AttributeData* typedAttributeData = static_cast<fx_surface_init_cube_common____all__AttributeData*>(attributeData);

    typedAttributeData->~fx_surface_init_cube_common____all__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const fx_surface_init_cube_common____primary__AttributeData fx_surface_init_cube_common____primary__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_surface_init_cube_common____primary( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_surface_init_cube_common____primary( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_surface_init_cube_common____primary( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_surface_init_cube_common____primary__AttributeData* attributeData = newData<fx_surface_init_cube_common____primary__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PRIMARY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PRIMARY, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_surface_init_cube_common____primary()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_surface_init_cube_common____primary();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_surface_init_cube_common____primary( void* attributeData )
{
    fx_surface_init_cube_common____primary__AttributeData* typedAttributeData = static_cast<fx_surface_init_cube_common____primary__AttributeData*>(attributeData);

    typedAttributeData->~fx_surface_init_cube_common____primary__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__order( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__order( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__order( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__order()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__order();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_surface_face_enum parameter = Utils::toEnum<ENUM__fx_surface_face_enum, StringHash, ENUM__fx_surface_face_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_surface_face_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__order(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ORDER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__order( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_surface_face_enum ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_face_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_surface_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_surface_face_enum, StringHash, ENUM__fx_surface_face_enum__COUNT, &toEnum_ENUM__fx_surface_face_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_surface_face_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_face_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_surface_face_enum, StringHash, ENUM__fx_surface_face_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_surface_face_enumMap, baseConversionFunc, &toEnum_ENUM__fx_surface_face_enum, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_face_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_surface_face_enum (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_face_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_surface_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_surface_face_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_surface_face_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_surface_face_enum, StringHash, ENUM__fx_surface_face_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const fx_surface_init_cube_common____face__AttributeData fx_surface_init_cube_common____face__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_surface_init_cube_common____face( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_surface_init_cube_common____face( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_surface_init_cube_common____face( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_surface_init_cube_common____face__AttributeData* attributeData = newData<fx_surface_init_cube_common____face__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_FACE, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_surface_init_cube_common____face()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_surface_init_cube_common____face();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_surface_init_cube_common____face( void* attributeData )
{
    fx_surface_init_cube_common____face__AttributeData* typedAttributeData = static_cast<fx_surface_init_cube_common____face__AttributeData*>(attributeData);

    typedAttributeData->~fx_surface_init_cube_common____face__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_volume( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_volume( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_volume( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_volume()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_volume();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_volume( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const fx_surface_init_volume_common____all__AttributeData fx_surface_init_volume_common____all__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_surface_init_volume_common____all( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_surface_init_volume_common____all( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_surface_init_volume_common____all( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_surface_init_volume_common____all__AttributeData* attributeData = newData<fx_surface_init_volume_common____all__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ALL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ALL, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_surface_init_volume_common____all()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_surface_init_volume_common____all();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_surface_init_volume_common____all( void* attributeData )
{
    fx_surface_init_volume_common____all__AttributeData* typedAttributeData = static_cast<fx_surface_init_volume_common____all__AttributeData*>(attributeData);

    typedAttributeData->~fx_surface_init_volume_common____all__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const fx_surface_init_volume_common____primary__AttributeData fx_surface_init_volume_common____primary__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_surface_init_volume_common____primary( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_surface_init_volume_common____primary( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_surface_init_volume_common____primary( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_surface_init_volume_common____primary__AttributeData* attributeData = newData<fx_surface_init_volume_common____primary__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PRIMARY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PRIMARY, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_surface_init_volume_common____primary()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_surface_init_volume_common____primary();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_surface_init_volume_common____primary( void* attributeData )
{
    fx_surface_init_volume_common____primary__AttributeData* typedAttributeData = static_cast<fx_surface_init_volume_common____primary__AttributeData*>(attributeData);

    typedAttributeData->~fx_surface_init_volume_common____primary__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_planar( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_planar( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_planar( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_planar()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_planar();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_planar( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const fx_surface_init_planar_common____all__AttributeData fx_surface_init_planar_common____all__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_surface_init_planar_common____all( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_surface_init_planar_common____all( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_surface_init_planar_common____all( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_surface_init_planar_common____all__AttributeData* attributeData = newData<fx_surface_init_planar_common____all__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ALL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ALL, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_surface_init_planar_common____all()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_surface_init_planar_common____all();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_surface_init_planar_common____all( void* attributeData )
{
    fx_surface_init_planar_common____all__AttributeData* typedAttributeData = static_cast<fx_surface_init_planar_common____all__AttributeData*>(attributeData);

    typedAttributeData->~fx_surface_init_planar_common____all__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const init_from____fx_surface_init_from_common__AttributeData init_from____fx_surface_init_from_common__AttributeData::DEFAULT = {0, 0, ENUM__fx_surface_face_enum__POSITIVE_X};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__init_from____fx_surface_init_from_common( const ParserChar* text, size_t textLength )
{

return mImpl->data__init_from____fx_surface_init_from_common(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__init_from____fx_surface_init_from_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__init_from____fx_surface_init_from_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

init_from____fx_surface_init_from_common__AttributeData* attributeData = newData<init_from____fx_surface_init_from_common__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_mip:
    {
bool failed;
attributeData->mip = GeneratedSaxParser::Utils::toUint32(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INIT_FROM,
        HASH_ATTRIBUTE_mip,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__unsignedInt(attributeData->mip);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INIT_FROM,
            HASH_ATTRIBUTE_mip,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_slice:
    {
bool failed;
attributeData->slice = GeneratedSaxParser::Utils::toUint32(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INIT_FROM,
        HASH_ATTRIBUTE_slice,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__unsignedInt(attributeData->slice);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INIT_FROM,
            HASH_ATTRIBUTE_slice,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_face:
    {
bool failed;
attributeData->face = Utils::toEnum<ENUM__fx_surface_face_enum, StringHash, ENUM__fx_surface_face_enum__COUNT>(attributeValue, failed, ENUM__fx_surface_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INIT_FROM,
        HASH_ATTRIBUTE_face,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INIT_FROM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__init_from____fx_surface_init_from_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__init_from____fx_surface_init_from_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__init_from____fx_surface_init_from_common( void* attributeData )
{
    init_from____fx_surface_init_from_common__AttributeData* typedAttributeData = static_cast<init_from____fx_surface_init_from_common__AttributeData*>(attributeData);

    typedAttributeData->~init_from____fx_surface_init_from_common__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__format( const ParserChar* text, size_t textLength )
{

return mImpl->data__format(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__format( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__format( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__format()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__format();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__format( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__format_hint( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__format_hint( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__format_hint( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__format_hint()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__format_hint();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__format_hint( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__channels( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__channels( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__channels( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__channels()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__channels();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_surface_format_hint_channels_enum parameter = Utils::toEnum<ENUM__fx_surface_format_hint_channels_enum, StringHash, ENUM__fx_surface_format_hint_channels_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_surface_format_hint_channels_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__channels(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_CHANNELS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__channels( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_surface_format_hint_channels_enum ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_channels_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_surface_format_hint_channels_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_surface_format_hint_channels_enum, StringHash, ENUM__fx_surface_format_hint_channels_enum__COUNT, &toEnum_ENUM__fx_surface_format_hint_channels_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_surface_format_hint_channels_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_channels_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_surface_format_hint_channels_enum, StringHash, ENUM__fx_surface_format_hint_channels_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_surface_format_hint_channels_enumMap, baseConversionFunc, &toEnum_ENUM__fx_surface_format_hint_channels_enum, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_channels_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_surface_format_hint_channels_enum (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_channels_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_surface_format_hint_channels_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_surface_format_hint_channels_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_surface_format_hint_channels_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_surface_format_hint_channels_enum, StringHash, ENUM__fx_surface_format_hint_channels_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__range( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__range( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__range( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__range()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__range();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_surface_format_hint_range_enum parameter = Utils::toEnum<ENUM__fx_surface_format_hint_range_enum, StringHash, ENUM__fx_surface_format_hint_range_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_surface_format_hint_range_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__range(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_RANGE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__range( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_surface_format_hint_range_enum ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_range_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_surface_format_hint_range_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_surface_format_hint_range_enum, StringHash, ENUM__fx_surface_format_hint_range_enum__COUNT, &toEnum_ENUM__fx_surface_format_hint_range_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_surface_format_hint_range_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_range_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_surface_format_hint_range_enum, StringHash, ENUM__fx_surface_format_hint_range_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_surface_format_hint_range_enumMap, baseConversionFunc, &toEnum_ENUM__fx_surface_format_hint_range_enum, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_range_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_surface_format_hint_range_enum (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_range_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_surface_format_hint_range_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_surface_format_hint_range_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_surface_format_hint_range_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_surface_format_hint_range_enum, StringHash, ENUM__fx_surface_format_hint_range_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__precision( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__precision( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__precision( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__precision()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__precision();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_surface_format_hint_precision_enum parameter = Utils::toEnum<ENUM__fx_surface_format_hint_precision_enum, StringHash, ENUM__fx_surface_format_hint_precision_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_surface_format_hint_precision_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__precision(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_PRECISION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__precision( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_surface_format_hint_precision_enum ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_precision_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_surface_format_hint_precision_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_surface_format_hint_precision_enum, StringHash, ENUM__fx_surface_format_hint_precision_enum__COUNT, &toEnum_ENUM__fx_surface_format_hint_precision_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_surface_format_hint_precision_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_precision_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_surface_format_hint_precision_enum, StringHash, ENUM__fx_surface_format_hint_precision_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_surface_format_hint_precision_enumMap, baseConversionFunc, &toEnum_ENUM__fx_surface_format_hint_precision_enum, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_precision_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_surface_format_hint_precision_enum (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_precision_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_surface_format_hint_precision_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_surface_format_hint_precision_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_surface_format_hint_precision_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_surface_format_hint_precision_enum, StringHash, ENUM__fx_surface_format_hint_precision_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__option( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__option( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__option( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__option()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__option();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_surface_format_hint_option_enum parameter = Utils::toEnum<ENUM__fx_surface_format_hint_option_enum, StringHash, ENUM__fx_surface_format_hint_option_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_surface_format_hint_option_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__option(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_OPTION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__option( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_surface_format_hint_option_enum ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_option_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_surface_format_hint_option_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_surface_format_hint_option_enum, StringHash, ENUM__fx_surface_format_hint_option_enum__COUNT, &toEnum_ENUM__fx_surface_format_hint_option_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_surface_format_hint_option_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_option_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_surface_format_hint_option_enum, StringHash, ENUM__fx_surface_format_hint_option_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_surface_format_hint_option_enumMap, baseConversionFunc, &toEnum_ENUM__fx_surface_format_hint_option_enum, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_surface_format_hint_option_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_surface_format_hint_option_enum (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_surface_format_hint_option_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_surface_format_hint_option_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_surface_format_hint_option_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_surface_format_hint_option_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_surface_format_hint_option_enum, StringHash, ENUM__fx_surface_format_hint_option_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__size____int3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3____int3__ValidationData* validationData = (int3____int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__size____int3, &validate__int3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__size____int3);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen14::data__size____int3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__size____int3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__size____int3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__size____int3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__size____int3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3____int3__ValidationData* validationData = (int3____int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen14::data__size____int3, &validate__int3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_SIZE,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__size____int3 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen14::data__size____int3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__size____int3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__viewport_ratio( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__viewport_ratio, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__viewport_ratio);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__viewport_ratio);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__viewport_ratio( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__viewport_ratio( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__viewport_ratio()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__viewport_ratio();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__viewport_ratio, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_VIEWPORT_RATIO,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__viewport_ratio );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__viewport_ratio );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__viewport_ratio( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mip_levels( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mip_levels( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mip_levels( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mip_levels()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mip_levels();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
uint32 parameter = GeneratedSaxParser::Utils::toUint32((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__unsignedInt(parameter);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        ParserChar msg[21];
        Utils::fillErrorMsg(msg, ptrForErr, 20);
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            0,
            msg) )
        {
            return false;
        }
    }
    } // validation
#endif
    returnValue = mImpl->data__mip_levels(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIP_LEVELS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mip_levels( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mipmap_generate( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mipmap_generate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mipmap_generate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mipmap_generate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mipmap_generate();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mipmap_generate(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIPMAP_GENERATE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mipmap_generate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sampler1D____fx_sampler1D_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sampler1D____fx_sampler1D_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler1D____fx_sampler1D_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sampler1D____fx_sampler1D_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler1D____fx_sampler1D_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sampler1D____fx_sampler1D_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__source____NCName( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__source____NCName( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__source____NCName( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__source____NCName()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__source____NCName();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__source____NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__source____NCName( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__wrap_s____fx_sampler_wrap_common( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__wrap_s____fx_sampler_wrap_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_s____fx_sampler_wrap_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__wrap_s____fx_sampler_wrap_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_s____fx_sampler_wrap_common();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_wrap_common parameter = Utils::toEnum<ENUM__fx_sampler_wrap_common, StringHash, ENUM__fx_sampler_wrap_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_wrap_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_s____fx_sampler_wrap_common(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__wrap_s____fx_sampler_wrap_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_sampler_wrap_common ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_sampler_wrap_common (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_sampler_wrap_common>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_sampler_wrap_common, StringHash, ENUM__fx_sampler_wrap_common__COUNT, &toEnum_ENUM__fx_sampler_wrap_common>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_sampler_wrap_common (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_sampler_wrap_common*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_sampler_wrap_common, StringHash, ENUM__fx_sampler_wrap_common__COUNT>(text, textLength, dataFunction, ENUM__fx_sampler_wrap_commonMap, baseConversionFunc, &toEnum_ENUM__fx_sampler_wrap_common, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_sampler_wrap_common);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_sampler_wrap_common (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_sampler_wrap_common*, size_t ),
    const std::pair<StringHash, ENUM__fx_sampler_wrap_common>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_sampler_wrap_common (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_sampler_wrap_common>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_sampler_wrap_common, StringHash, ENUM__fx_sampler_wrap_common__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__minfilter( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__minfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__minfilter( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__minfilter()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__minfilter();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_filter_common parameter = Utils::toEnum<ENUM__fx_sampler_filter_common, StringHash, ENUM__fx_sampler_filter_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_filter_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__minfilter(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__minfilter( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_sampler_filter_common ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_sampler_filter_common (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_sampler_filter_common>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_sampler_filter_common, StringHash, ENUM__fx_sampler_filter_common__COUNT, &toEnum_ENUM__fx_sampler_filter_common>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__fx_sampler_filter_common (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_sampler_filter_common*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_sampler_filter_common, StringHash, ENUM__fx_sampler_filter_common__COUNT>(text, textLength, dataFunction, ENUM__fx_sampler_filter_commonMap, baseConversionFunc, &toEnum_ENUM__fx_sampler_filter_common, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__fx_sampler_filter_common);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__fx_sampler_filter_common (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__fx_sampler_filter_common*, size_t ),
    const std::pair<StringHash, ENUM__fx_sampler_filter_common>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_sampler_filter_common (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_sampler_filter_common>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_sampler_filter_common, StringHash, ENUM__fx_sampler_filter_common__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__magfilter( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__magfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__magfilter( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__magfilter()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__magfilter();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_filter_common parameter = Utils::toEnum<ENUM__fx_sampler_filter_common, StringHash, ENUM__fx_sampler_filter_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_filter_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__magfilter(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__magfilter( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mipfilter( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mipfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mipfilter( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mipfilter()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mipfilter();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_filter_common parameter = Utils::toEnum<ENUM__fx_sampler_filter_common, StringHash, ENUM__fx_sampler_filter_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_filter_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mipfilter(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mipfilter( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__border_color( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__border_color, &validate__fx_color_common__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__border_color);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__border_color);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__border_color( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__border_color( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__border_color()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__border_color();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__border_color, &validate__fx_color_common__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__fx_color_common(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BORDER_COLOR,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__border_color );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__border_color );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__border_color( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mipmap_maxlevel( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mipmap_maxlevel( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mipmap_maxlevel( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mipmap_maxlevel()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mipmap_maxlevel();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
uint8 parameter = GeneratedSaxParser::Utils::toUint8((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mipmap_maxlevel(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mipmap_maxlevel( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mipmap_bias( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mipmap_bias( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mipmap_bias( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mipmap_bias()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mipmap_bias();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mipmap_bias(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mipmap_bias( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sampler2D____fx_sampler2D_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sampler2D____fx_sampler2D_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler2D____fx_sampler2D_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sampler2D____fx_sampler2D_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler2D____fx_sampler2D_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sampler2D____fx_sampler2D_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__wrap_t____fx_sampler_wrap_common( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__wrap_t____fx_sampler_wrap_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_t____fx_sampler_wrap_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__wrap_t____fx_sampler_wrap_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_t____fx_sampler_wrap_common();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_wrap_common parameter = Utils::toEnum<ENUM__fx_sampler_wrap_common, StringHash, ENUM__fx_sampler_wrap_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_wrap_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_t____fx_sampler_wrap_common(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_T, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__wrap_t____fx_sampler_wrap_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sampler3D____fx_sampler3D_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sampler3D____fx_sampler3D_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler3D____fx_sampler3D_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sampler3D____fx_sampler3D_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler3D____fx_sampler3D_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sampler3D____fx_sampler3D_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__wrap_p( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__wrap_p( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_p( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__wrap_p()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_p();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_wrap_common parameter = Utils::toEnum<ENUM__fx_sampler_wrap_common, StringHash, ENUM__fx_sampler_wrap_common__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_wrap_commonMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_p(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_P, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__wrap_p( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__samplerCUBE____fx_samplerCUBE_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__samplerCUBE____fx_samplerCUBE_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__samplerCUBE____fx_samplerCUBE_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__samplerCUBE____fx_samplerCUBE_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__samplerCUBE____fx_samplerCUBE_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__samplerCUBE____fx_samplerCUBE_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__samplerRECT____fx_samplerRECT_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__samplerRECT____fx_samplerRECT_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__samplerRECT____fx_samplerRECT_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__samplerRECT____fx_samplerRECT_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__samplerRECT____fx_samplerRECT_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__samplerRECT____fx_samplerRECT_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__samplerDEPTH____fx_samplerDEPTH_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__samplerDEPTH____fx_samplerDEPTH_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__samplerDEPTH____fx_samplerDEPTH_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__samplerDEPTH____fx_samplerDEPTH_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__samplerDEPTH____fx_samplerDEPTH_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__samplerDEPTH____fx_samplerDEPTH_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__enum____string( const ParserChar* text, size_t textLength )
{

return mImpl->data__enum____string(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__enum____string( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__enum____string( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__enum____string()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__enum____string();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__enum____string( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const fx_profile_abstract__AttributeData fx_profile_abstract__AttributeData::DEFAULT = {GeneratedSaxParser::XSList<const ParserChar*>()};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__fx_profile_abstract( const ParserChar* text, size_t textLength )
{

return mImpl->data__fx_profile_abstract(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__fx_profile_abstract( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_profile_abstract( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_profile_abstract__AttributeData* attributeData = newData<fx_profile_abstract__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


        if ( !attributeData->unknownAttributes.data )
            attributeData->unknownAttributes.data = (const ParserChar**)mStackMemoryManager.newObject( 2 * sizeof( const ParserChar* ) );
        else
            attributeData->unknownAttributes.data = (const ParserChar**)mStackMemoryManager.growObject( 2 * sizeof( const ParserChar* ) );
        attributeData->unknownAttributes.data[ attributeData->unknownAttributes.size ] = attribute;
        attributeData->unknownAttributes.data[ attributeData->unknownAttributes.size+1 ] = attributeValue;
        attributeData->unknownAttributes.size += 2;

    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__fx_profile_abstract()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_profile_abstract();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__fx_profile_abstract( void* attributeData )
{
    fx_profile_abstract__AttributeData* typedAttributeData = static_cast<fx_profile_abstract__AttributeData*>(attributeData);
    if (typedAttributeData->unknownAttributes.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~fx_profile_abstract__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_force_fields__AttributeData library_force_fields__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_force_fields( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_force_fields( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_force_fields( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_force_fields__AttributeData* attributeData = newData<library_force_fields__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_FORCE_FIELDS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_FORCE_FIELDS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_force_fields()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_force_fields();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_force_fields( void* attributeData )
{
    library_force_fields__AttributeData* typedAttributeData = static_cast<library_force_fields__AttributeData*>(attributeData);

    typedAttributeData->~library_force_fields__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const force_field__AttributeData force_field__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__force_field( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__force_field( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__force_field( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

force_field__AttributeData* attributeData = newData<force_field__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FORCE_FIELD,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FORCE_FIELD, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__force_field()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__force_field();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__force_field( void* attributeData )
{
    force_field__AttributeData* typedAttributeData = static_cast<force_field__AttributeData*>(attributeData);

    typedAttributeData->~force_field__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_images__AttributeData library_images__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_images( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_images( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_images( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_images__AttributeData* attributeData = newData<library_images__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_IMAGES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_IMAGES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_images()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_images();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_images( void* attributeData )
{
    library_images__AttributeData* typedAttributeData = static_cast<library_images__AttributeData*>(attributeData);

    typedAttributeData->~library_images__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_lights__AttributeData library_lights__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_lights( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_lights( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_lights( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_lights__AttributeData* attributeData = newData<library_lights__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_LIGHTS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_LIGHTS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_lights()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_lights();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_lights( void* attributeData )
{
    library_lights__AttributeData* typedAttributeData = static_cast<library_lights__AttributeData*>(attributeData);

    typedAttributeData->~library_lights__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const light__AttributeData light__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__light( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__light( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__light( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

light__AttributeData* attributeData = newData<light__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIGHT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIGHT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__light()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__light();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__light( void* attributeData )
{
    light__AttributeData* typedAttributeData = static_cast<light__AttributeData*>(attributeData);

    typedAttributeData->~light__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__light__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__light__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__light__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__light__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__light__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__light__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__light__technique_common__ambient( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__light__technique_common__ambient( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__light__technique_common__ambient( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__light__technique_common__ambient()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__light__technique_common__ambient();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__light__technique_common__ambient( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const color____TargetableFloat3__AttributeData color____TargetableFloat3__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__color____TargetableFloat3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__color____TargetableFloat3, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__color____TargetableFloat3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__color____TargetableFloat3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__color____TargetableFloat3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__color____TargetableFloat3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

color____TargetableFloat3__AttributeData* attributeData = newData<color____TargetableFloat3__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_COLOR,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLOR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__color____TargetableFloat3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__color____TargetableFloat3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__color____TargetableFloat3, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_COLOR,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__color____TargetableFloat3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__color____TargetableFloat3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__color____TargetableFloat3( void* attributeData )
{
    color____TargetableFloat3__AttributeData* typedAttributeData = static_cast<color____TargetableFloat3__AttributeData*>(attributeData);

    typedAttributeData->~color____TargetableFloat3__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__directional( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__directional( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__directional( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__directional()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__directional();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__directional( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__point( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__point( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__point( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__point()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__point();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__point( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const constant_attenuation__AttributeData constant_attenuation__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__constant_attenuation( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__constant_attenuation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__constant_attenuation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

constant_attenuation__AttributeData* attributeData = newData<constant_attenuation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CONSTANT_ATTENUATION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONSTANT_ATTENUATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__constant_attenuation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__constant_attenuation();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__constant_attenuation(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_CONSTANT_ATTENUATION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__constant_attenuation( void* attributeData )
{
    constant_attenuation__AttributeData* typedAttributeData = static_cast<constant_attenuation__AttributeData*>(attributeData);

    typedAttributeData->~constant_attenuation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const linear_attenuation__AttributeData linear_attenuation__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__linear_attenuation( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__linear_attenuation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__linear_attenuation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

linear_attenuation__AttributeData* attributeData = newData<linear_attenuation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINEAR_ATTENUATION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINEAR_ATTENUATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__linear_attenuation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__linear_attenuation();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__linear_attenuation(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_LINEAR_ATTENUATION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__linear_attenuation( void* attributeData )
{
    linear_attenuation__AttributeData* typedAttributeData = static_cast<linear_attenuation__AttributeData*>(attributeData);

    typedAttributeData->~linear_attenuation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const quadratic_attenuation__AttributeData quadratic_attenuation__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__quadratic_attenuation( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__quadratic_attenuation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__quadratic_attenuation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

quadratic_attenuation__AttributeData* attributeData = newData<quadratic_attenuation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_QUADRATIC_ATTENUATION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_QUADRATIC_ATTENUATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__quadratic_attenuation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__quadratic_attenuation();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__quadratic_attenuation(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_QUADRATIC_ATTENUATION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__quadratic_attenuation( void* attributeData )
{
    quadratic_attenuation__AttributeData* typedAttributeData = static_cast<quadratic_attenuation__AttributeData*>(attributeData);

    typedAttributeData->~quadratic_attenuation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__spot( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__spot( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__spot( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__spot()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__spot();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__spot( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const falloff_angle__AttributeData falloff_angle__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__falloff_angle( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__falloff_angle( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__falloff_angle( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

falloff_angle__AttributeData* attributeData = newData<falloff_angle__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FALLOFF_ANGLE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FALLOFF_ANGLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__falloff_angle()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__falloff_angle();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__falloff_angle(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FALLOFF_ANGLE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__falloff_angle( void* attributeData )
{
    falloff_angle__AttributeData* typedAttributeData = static_cast<falloff_angle__AttributeData*>(attributeData);

    typedAttributeData->~falloff_angle__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const falloff_exponent__AttributeData falloff_exponent__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__falloff_exponent( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__falloff_exponent( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__falloff_exponent( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

falloff_exponent__AttributeData* attributeData = newData<falloff_exponent__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FALLOFF_EXPONENT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FALLOFF_EXPONENT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__falloff_exponent()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__falloff_exponent();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__falloff_exponent(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FALLOFF_EXPONENT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__falloff_exponent( void* attributeData )
{
    falloff_exponent__AttributeData* typedAttributeData = static_cast<falloff_exponent__AttributeData*>(attributeData);

    typedAttributeData->~falloff_exponent__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_materials__AttributeData library_materials__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_materials( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_materials( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_materials( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_materials__AttributeData* attributeData = newData<library_materials__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_MATERIALS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_MATERIALS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_materials()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_materials();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_materials( void* attributeData )
{
    library_materials__AttributeData* typedAttributeData = static_cast<library_materials__AttributeData*>(attributeData);

    typedAttributeData->~library_materials__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const material__AttributeData material__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__material( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__material( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__material( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

material__AttributeData* attributeData = newData<material__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_MATERIAL,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MATERIAL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__material()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__material();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__material( void* attributeData )
{
    material__AttributeData* typedAttributeData = static_cast<material__AttributeData*>(attributeData);

    typedAttributeData->~material__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_effect__AttributeData instance_effect__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_effect( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_effect( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_effect( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_effect__AttributeData* attributeData = newData<instance_effect__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_EFFECT,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_effect__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_EFFECT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_EFFECT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_EFFECT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_effect__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_effect__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_EFFECT, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_effect()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_effect();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_effect( void* attributeData )
{
    instance_effect__AttributeData* typedAttributeData = static_cast<instance_effect__AttributeData*>(attributeData);

    typedAttributeData->~instance_effect__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const technique_hint__AttributeData technique_hint__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__technique_hint( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__technique_hint( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__technique_hint( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

technique_hint__AttributeData* attributeData = newData<technique_hint__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_platform:
    {

attributeData->platform = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->platform, strlen(attributeData->platform));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE_HINT,
            HASH_ATTRIBUTE_platform,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_profile:
    {

attributeData->profile = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->profile, strlen(attributeData->profile));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE_HINT,
            HASH_ATTRIBUTE_profile,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->ref, strlen(attributeData->ref));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE_HINT,
            HASH_ATTRIBUTE_ref,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TECHNIQUE_HINT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TECHNIQUE_HINT, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__technique_hint()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__technique_hint();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__technique_hint( void* attributeData )
{
    technique_hint__AttributeData* typedAttributeData = static_cast<technique_hint__AttributeData*>(attributeData);

    typedAttributeData->~technique_hint__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_effect__setparam__AttributeData instance_effect__setparam__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_effect__setparam( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_effect__setparam( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_effect__setparam( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_effect__setparam__AttributeData* attributeData = newData<instance_effect__setparam__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ref:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SETPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SETPARAM, HASH_ATTRIBUTE_ref, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_effect__setparam()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_effect__setparam();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_effect__setparam( void* attributeData )
{
    instance_effect__setparam__AttributeData* typedAttributeData = static_cast<instance_effect__setparam__AttributeData*>(attributeData);

    typedAttributeData->~instance_effect__setparam__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_nodes__AttributeData library_nodes__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_nodes( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_nodes( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_nodes( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_nodes__AttributeData* attributeData = newData<library_nodes__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_NODES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_NODES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_nodes()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_nodes();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_nodes( void* attributeData )
{
    library_nodes__AttributeData* typedAttributeData = static_cast<library_nodes__AttributeData*>(attributeData);

    typedAttributeData->~library_nodes__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const node__AttributeData node__AttributeData::DEFAULT = {0, 0, 0, 0, ENUM__NodeType__NODE, GeneratedSaxParser::XSList<ParserString>()};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__node( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__node( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__node( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

node__AttributeData* attributeData = newData<node__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NODE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NODE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_type:
    {
bool failed;
attributeData->type = Utils::toEnum<ENUM__NodeType, StringHash, ENUM__NodeType__COUNT>(attributeValue, failed, ENUM__NodeTypeMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NODE,
        HASH_ATTRIBUTE_type,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_layer:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2StringList(attributeValue, attributeData->layer, &validate__Name, HASH_ELEMENT_NODE, HASH_ATTRIBUTE_layer);
    }
    else
    {
failed = !characterData2StringList(attributeValue, attributeData->layer);
    }
#else
    {
failed = !characterData2StringList(attributeValue, attributeData->layer);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NODE,
        HASH_ATTRIBUTE_layer,
        attributeValue))
{
    return false;
}

if ( !failed )
    attributeData->present_attributes |= node__AttributeData::ATTRIBUTE_LAYER_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NODE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & node__AttributeData::ATTRIBUTE_LAYER_PRESENT) == 0)
{
    attributeData->layer = GeneratedSaxParser::XSList<ParserString>();
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__node()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__node();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__node( void* attributeData )
{
    node__AttributeData* typedAttributeData = static_cast<node__AttributeData*>(attributeData);
    if (typedAttributeData->layer.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~node__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__NodeType ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__NodeType (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__NodeType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__NodeType, StringHash, ENUM__NodeType__COUNT, &toEnum_ENUM__NodeType>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__NodeType (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__NodeType*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__NodeType, StringHash, ENUM__NodeType__COUNT>(text, textLength, dataFunction, ENUM__NodeTypeMap, baseConversionFunc, &toEnum_ENUM__NodeType, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__NodeType);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__NodeType (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__NodeType*, size_t ),
    const std::pair<StringHash, ENUM__NodeType>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__NodeType (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__NodeType>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__NodeType, StringHash, ENUM__NodeType__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const lookat__AttributeData lookat__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__lookat( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3____float3x3__ValidationData* validationData = (float3x3____float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__lookat, &validate__float3x3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__lookat);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__lookat);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__lookat( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__lookat( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

lookat__AttributeData* attributeData = newData<lookat__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LOOKAT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LOOKAT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__lookat()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__lookat();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3____float3x3__ValidationData* validationData = (float3x3____float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__lookat, &validate__float3x3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_LOOKAT,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__lookat );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__lookat );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__lookat( void* attributeData )
{
    lookat__AttributeData* typedAttributeData = static_cast<lookat__AttributeData*>(attributeData);

    typedAttributeData->~lookat__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const matrix__AttributeData matrix__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__matrix( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__matrix, &validate__float4x4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__matrix);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__matrix);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__matrix( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__matrix( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

matrix__AttributeData* attributeData = newData<matrix__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_MATRIX,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MATRIX, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__matrix()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__matrix();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__matrix, &validate__float4x4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_MATRIX,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__matrix );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__matrix );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__matrix( void* attributeData )
{
    matrix__AttributeData* typedAttributeData = static_cast<matrix__AttributeData*>(attributeData);

    typedAttributeData->~matrix__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const rotate__AttributeData rotate__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rotate( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__rotate, &validate__float4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__rotate);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__rotate);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rotate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rotate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

rotate__AttributeData* attributeData = newData<rotate__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ROTATE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ROTATE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rotate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rotate();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__rotate, &validate__float4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_ROTATE,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__rotate );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__rotate );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rotate( void* attributeData )
{
    rotate__AttributeData* typedAttributeData = static_cast<rotate__AttributeData*>(attributeData);

    typedAttributeData->~rotate__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const scale__AttributeData scale__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__scale( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__scale, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__scale);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__scale);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__scale( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__scale( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

scale__AttributeData* attributeData = newData<scale__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_SCALE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SCALE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__scale()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__scale();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__scale, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_SCALE,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__scale );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__scale );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__scale( void* attributeData )
{
    scale__AttributeData* typedAttributeData = static_cast<scale__AttributeData*>(attributeData);

    typedAttributeData->~scale__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const skew__AttributeData skew__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__skew( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        skew__ValidationData* validationData = (skew__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__skew, &validate__float7__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__skew);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__skew);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__skew( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__skew( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

skew__AttributeData* attributeData = newData<skew__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_SKEW,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SKEW, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__skew()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__skew();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        skew__ValidationData* validationData = (skew__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__skew, &validate__float7__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float7(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_SKEW,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__skew );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__skew );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__skew( void* attributeData )
{
    skew__AttributeData* typedAttributeData = static_cast<skew__AttributeData*>(attributeData);

    typedAttributeData->~skew__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const translate__AttributeData translate__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__translate( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__translate, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__translate);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__translate);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__translate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__translate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

translate__AttributeData* attributeData = newData<translate__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRANSLATE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRANSLATE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__translate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__translate();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__translate, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_TRANSLATE,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__translate );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__translate );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__translate( void* attributeData )
{
    translate__AttributeData* typedAttributeData = static_cast<translate__AttributeData*>(attributeData);

    typedAttributeData->~translate__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_camera__AttributeData instance_camera__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_camera( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_camera( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_camera( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_camera__AttributeData* attributeData = newData<instance_camera__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_CAMERA,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_camera__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_CAMERA,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_CAMERA,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_CAMERA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_camera__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_camera__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_CAMERA, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_camera()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_camera();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_camera( void* attributeData )
{
    instance_camera__AttributeData* typedAttributeData = static_cast<instance_camera__AttributeData*>(attributeData);

    typedAttributeData->~instance_camera__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_controller__AttributeData instance_controller__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_controller( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_controller( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_controller( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_controller__AttributeData* attributeData = newData<instance_controller__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_CONTROLLER,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_controller__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_CONTROLLER,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_CONTROLLER,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_CONTROLLER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_controller__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_controller__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_CONTROLLER, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_controller()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_controller();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_controller( void* attributeData )
{
    instance_controller__AttributeData* typedAttributeData = static_cast<instance_controller__AttributeData*>(attributeData);

    typedAttributeData->~instance_controller__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__skeleton( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__skeleton( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__skeleton( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__skeleton()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__skeleton();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
COLLADABU::URI parameter = GeneratedSaxParser::Utils::toURI((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__skeleton(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_SKELETON, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__skeleton( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bind_material( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bind_material( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bind_material( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bind_material()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bind_material();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bind_material( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bind_material__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bind_material__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bind_material__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bind_material__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bind_material__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bind_material__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const instance_material__AttributeData instance_material__AttributeData::DEFAULT = {0, 0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_material( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_material( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_material( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_material__AttributeData* attributeData = newData<instance_material__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_symbol:
    {

attributeData->symbol = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->symbol, strlen(attributeData->symbol));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_MATERIAL,
            HASH_ATTRIBUTE_symbol,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_target:
    {
bool failed;
attributeData->target = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_MATERIAL,
        HASH_ATTRIBUTE_target,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_material__AttributeData::ATTRIBUTE_TARGET_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_MATERIAL,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_MATERIAL,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_MATERIAL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_material__AttributeData::ATTRIBUTE_TARGET_PRESENT) == 0)
{
    attributeData->target = COLLADABU::URI("");
}
if ( !attributeData->symbol )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_MATERIAL, HASH_ATTRIBUTE_symbol, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & instance_material__AttributeData::ATTRIBUTE_TARGET_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_MATERIAL, HASH_ATTRIBUTE_target, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_material()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_material();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_material( void* attributeData )
{
    instance_material__AttributeData* typedAttributeData = static_cast<instance_material__AttributeData*>(attributeData);

    typedAttributeData->~instance_material__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_material__bind__AttributeData instance_material__bind__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_material__bind( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_material__bind( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_material__bind( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_material__bind__AttributeData* attributeData = newData<instance_material__bind__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_semantic:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_BIND,
            HASH_ATTRIBUTE_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_target:
    {

attributeData->target = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BIND, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BIND, HASH_ATTRIBUTE_semantic, 0 ) )
        return false;
}
if ( !attributeData->target )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BIND, HASH_ATTRIBUTE_target, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_material__bind()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_material__bind();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_material__bind( void* attributeData )
{
    instance_material__bind__AttributeData* typedAttributeData = static_cast<instance_material__bind__AttributeData*>(attributeData);

    typedAttributeData->~instance_material__bind__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const bind_vertex_input__AttributeData bind_vertex_input__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__bind_vertex_input( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__bind_vertex_input( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bind_vertex_input( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

bind_vertex_input__AttributeData* attributeData = newData<bind_vertex_input__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_semantic:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_BIND_VERTEX_INPUT,
            HASH_ATTRIBUTE_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_input_semantic:
    {

attributeData->input_semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->input_semantic, strlen(attributeData->input_semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_BIND_VERTEX_INPUT,
            HASH_ATTRIBUTE_input_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_input_set:
    {
bool failed;
attributeData->input_set = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BIND_VERTEX_INPUT,
        HASH_ATTRIBUTE_input_set,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= bind_vertex_input__AttributeData::ATTRIBUTE_INPUT_SET_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BIND_VERTEX_INPUT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BIND_VERTEX_INPUT, HASH_ATTRIBUTE_semantic, 0 ) )
        return false;
}
if ( !attributeData->input_semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BIND_VERTEX_INPUT, HASH_ATTRIBUTE_input_semantic, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__bind_vertex_input()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bind_vertex_input();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__bind_vertex_input( void* attributeData )
{
    bind_vertex_input__AttributeData* typedAttributeData = static_cast<bind_vertex_input__AttributeData*>(attributeData);

    typedAttributeData->~bind_vertex_input__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_geometry__AttributeData instance_geometry__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_geometry( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_geometry( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_geometry( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_geometry__AttributeData* attributeData = newData<instance_geometry__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_GEOMETRY,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_geometry__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_GEOMETRY,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_GEOMETRY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_GEOMETRY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_geometry__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_geometry__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_GEOMETRY, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_geometry()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_geometry();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_geometry( void* attributeData )
{
    instance_geometry__AttributeData* typedAttributeData = static_cast<instance_geometry__AttributeData*>(attributeData);

    typedAttributeData->~instance_geometry__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_light__AttributeData instance_light__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_light( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_light( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_light( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_light__AttributeData* attributeData = newData<instance_light__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_LIGHT,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_light__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_LIGHT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_LIGHT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_LIGHT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_light__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_light__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_LIGHT, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_light()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_light();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_light( void* attributeData )
{
    instance_light__AttributeData* typedAttributeData = static_cast<instance_light__AttributeData*>(attributeData);

    typedAttributeData->~instance_light__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_node__AttributeData instance_node__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_node( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_node( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_node( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_node__AttributeData* attributeData = newData<instance_node__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_NODE,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_node__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_NODE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_NODE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_NODE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_node__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_node__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_NODE, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_node()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_node();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_node( void* attributeData )
{
    instance_node__AttributeData* typedAttributeData = static_cast<instance_node__AttributeData*>(attributeData);

    typedAttributeData->~instance_node__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_physics_materials__AttributeData library_physics_materials__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_physics_materials( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_physics_materials( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_physics_materials( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_physics_materials__AttributeData* attributeData = newData<library_physics_materials__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_physics_materials()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_physics_materials();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_physics_materials( void* attributeData )
{
    library_physics_materials__AttributeData* typedAttributeData = static_cast<library_physics_materials__AttributeData*>(attributeData);

    typedAttributeData->~library_physics_materials__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const physics_material__AttributeData physics_material__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__physics_material( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__physics_material( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__physics_material( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

physics_material__AttributeData* attributeData = newData<physics_material__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PHYSICS_MATERIAL,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PHYSICS_MATERIAL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__physics_material()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__physics_material();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__physics_material( void* attributeData )
{
    physics_material__AttributeData* typedAttributeData = static_cast<physics_material__AttributeData*>(attributeData);

    typedAttributeData->~physics_material__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__physics_material__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__physics_material__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__physics_material__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__physics_material__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__physics_material__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__physics_material__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const dynamic_friction__AttributeData dynamic_friction__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__dynamic_friction( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__dynamic_friction( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__dynamic_friction( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

dynamic_friction__AttributeData* attributeData = newData<dynamic_friction__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_DYNAMIC_FRICTION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DYNAMIC_FRICTION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__dynamic_friction()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__dynamic_friction();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__dynamic_friction(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_DYNAMIC_FRICTION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__dynamic_friction( void* attributeData )
{
    dynamic_friction__AttributeData* typedAttributeData = static_cast<dynamic_friction__AttributeData*>(attributeData);

    typedAttributeData->~dynamic_friction__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const restitution__AttributeData restitution__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__restitution( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__restitution( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__restitution( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

restitution__AttributeData* attributeData = newData<restitution__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_RESTITUTION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_RESTITUTION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__restitution()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__restitution();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__restitution(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_RESTITUTION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__restitution( void* attributeData )
{
    restitution__AttributeData* typedAttributeData = static_cast<restitution__AttributeData*>(attributeData);

    typedAttributeData->~restitution__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const static_friction__AttributeData static_friction__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__static_friction( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__static_friction( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__static_friction( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

static_friction__AttributeData* attributeData = newData<static_friction__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_STATIC_FRICTION,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_STATIC_FRICTION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__static_friction()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__static_friction();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__static_friction(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_STATIC_FRICTION, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__static_friction( void* attributeData )
{
    static_friction__AttributeData* typedAttributeData = static_cast<static_friction__AttributeData*>(attributeData);

    typedAttributeData->~static_friction__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_physics_models__AttributeData library_physics_models__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_physics_models( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_physics_models( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_physics_models( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_physics_models__AttributeData* attributeData = newData<library_physics_models__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_PHYSICS_MODELS,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_PHYSICS_MODELS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_physics_models()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_physics_models();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_physics_models( void* attributeData )
{
    library_physics_models__AttributeData* typedAttributeData = static_cast<library_physics_models__AttributeData*>(attributeData);

    typedAttributeData->~library_physics_models__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const physics_model__AttributeData physics_model__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__physics_model( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__physics_model( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__physics_model( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

physics_model__AttributeData* attributeData = newData<physics_model__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PHYSICS_MODEL,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PHYSICS_MODEL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__physics_model()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__physics_model();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__physics_model( void* attributeData )
{
    physics_model__AttributeData* typedAttributeData = static_cast<physics_model__AttributeData*>(attributeData);

    typedAttributeData->~physics_model__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const rigid_body__AttributeData rigid_body__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_body( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_body( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_body( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

rigid_body__AttributeData* attributeData = newData<rigid_body__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_RIGID_BODY,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_RIGID_BODY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_RIGID_BODY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_RIGID_BODY, HASH_ATTRIBUTE_sid, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_body()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_body();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_body( void* attributeData )
{
    rigid_body__AttributeData* typedAttributeData = static_cast<rigid_body__AttributeData*>(attributeData);

    typedAttributeData->~rigid_body__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_body__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_body__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_body__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_body__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_body__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_body__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const rigid_body__technique_common__dynamic__AttributeData rigid_body__technique_common__dynamic__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_body__technique_common__dynamic( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_body__technique_common__dynamic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_body__technique_common__dynamic( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

rigid_body__technique_common__dynamic__AttributeData* attributeData = newData<rigid_body__technique_common__dynamic__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_DYNAMIC,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DYNAMIC, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_body__technique_common__dynamic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_body__technique_common__dynamic();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__rigid_body__technique_common__dynamic(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_DYNAMIC, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_body__technique_common__dynamic( void* attributeData )
{
    rigid_body__technique_common__dynamic__AttributeData* typedAttributeData = static_cast<rigid_body__technique_common__dynamic__AttributeData*>(attributeData);

    typedAttributeData->~rigid_body__technique_common__dynamic__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const mass__AttributeData mass__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__mass( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__mass( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mass( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

mass__AttributeData* attributeData = newData<mass__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_MASS,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MASS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__mass()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mass();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mass(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MASS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__mass( void* attributeData )
{
    mass__AttributeData* typedAttributeData = static_cast<mass__AttributeData*>(attributeData);

    typedAttributeData->~mass__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_body__technique_common__mass_frame( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_body__technique_common__mass_frame( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_body__technique_common__mass_frame( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_body__technique_common__mass_frame()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_body__technique_common__mass_frame();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_body__technique_common__mass_frame( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const inertia__AttributeData inertia__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__inertia( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__inertia, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__inertia);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__inertia);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__inertia( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__inertia( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

inertia__AttributeData* attributeData = newData<inertia__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INERTIA,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INERTIA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__inertia()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__inertia();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__inertia, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INERTIA,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__inertia );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__inertia );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__inertia( void* attributeData )
{
    inertia__AttributeData* typedAttributeData = static_cast<inertia__AttributeData*>(attributeData);

    typedAttributeData->~inertia__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_physics_material__AttributeData instance_physics_material__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_physics_material( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_physics_material( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_physics_material( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_physics_material__AttributeData* attributeData = newData<instance_physics_material__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_physics_material__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_physics_material__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_physics_material__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_physics_material()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_physics_material();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_physics_material( void* attributeData )
{
    instance_physics_material__AttributeData* typedAttributeData = static_cast<instance_physics_material__AttributeData*>(attributeData);

    typedAttributeData->~instance_physics_material__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_body__technique_common__shape( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_body__technique_common__shape( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_body__technique_common__shape( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_body__technique_common__shape()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_body__technique_common__shape();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_body__technique_common__shape( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const rigid_body__technique_common__shape__hollow__AttributeData rigid_body__technique_common__shape__hollow__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_body__technique_common__shape__hollow( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_body__technique_common__shape__hollow( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_body__technique_common__shape__hollow( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

rigid_body__technique_common__shape__hollow__AttributeData* attributeData = newData<rigid_body__technique_common__shape__hollow__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_HOLLOW,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_HOLLOW, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_body__technique_common__shape__hollow()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_body__technique_common__shape__hollow();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__rigid_body__technique_common__shape__hollow(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_HOLLOW, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_body__technique_common__shape__hollow( void* attributeData )
{
    rigid_body__technique_common__shape__hollow__AttributeData* typedAttributeData = static_cast<rigid_body__technique_common__shape__hollow__AttributeData*>(attributeData);

    typedAttributeData->~rigid_body__technique_common__shape__hollow__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const density__AttributeData density__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__density( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__density( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__density( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

density__AttributeData* attributeData = newData<density__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_DENSITY,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DENSITY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__density()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__density();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__density(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_DENSITY, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__density( void* attributeData )
{
    density__AttributeData* typedAttributeData = static_cast<density__AttributeData*>(attributeData);

    typedAttributeData->~density__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__plane( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__plane( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__plane( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__plane()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__plane();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__plane( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__equation( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__equation, &validate__float4__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__equation);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__equation);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__equation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__equation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__equation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__equation();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__equation, &validate__float4__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_EQUATION,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__equation );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__equation );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__equation( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__box( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__box( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__box( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__box()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__box();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__box( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__half_extents( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__half_extents, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__half_extents);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__half_extents);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__half_extents( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__half_extents( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__half_extents()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__half_extents();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__half_extents, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_HALF_EXTENTS,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__half_extents );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__half_extents );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__half_extents( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sphere( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sphere( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sphere( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sphere()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sphere();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sphere( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__radius____float( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__radius____float( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__radius____float( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__radius____float()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__radius____float();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__radius____float(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__radius____float( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__cylinder( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__cylinder( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__cylinder( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__cylinder()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__cylinder();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__cylinder( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__height( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__height( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__height( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__height()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__height();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__height(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_HEIGHT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__height( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__radius____float2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius____float2, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius____float2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius____float2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__radius____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__radius____float2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__radius____float2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__radius____float2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__radius____float2, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_RADIUS,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__radius____float2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__radius____float2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__radius____float2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__tapered_cylinder( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__tapered_cylinder( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__tapered_cylinder( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__tapered_cylinder()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__tapered_cylinder();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__tapered_cylinder( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__radius1( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius1, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius1);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius1);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__radius1( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__radius1( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__radius1()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__radius1();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__radius1, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_RADIUS1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__radius1 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__radius1 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__radius1( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__radius2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius2, &validate__float2__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__radius2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__radius2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__radius2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__radius2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__radius2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__radius2, &validate__float2__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_RADIUS2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__radius2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__radius2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__radius2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__capsule( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__capsule( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__capsule( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__capsule()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__capsule();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__capsule( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__tapered_capsule( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__tapered_capsule( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__tapered_capsule( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__tapered_capsule()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__tapered_capsule();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__tapered_capsule( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const rigid_constraint__AttributeData rigid_constraint__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_constraint( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_constraint( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_constraint( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

rigid_constraint__AttributeData* attributeData = newData<rigid_constraint__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_RIGID_CONSTRAINT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_RIGID_CONSTRAINT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_RIGID_CONSTRAINT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_RIGID_CONSTRAINT, HASH_ATTRIBUTE_sid, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_constraint()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_constraint();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_constraint( void* attributeData )
{
    rigid_constraint__AttributeData* typedAttributeData = static_cast<rigid_constraint__AttributeData*>(attributeData);

    typedAttributeData->~rigid_constraint__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const ref_attachment__AttributeData ref_attachment__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__ref_attachment( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__ref_attachment( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ref_attachment( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

ref_attachment__AttributeData* attributeData = newData<ref_attachment__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_rigid_body:
    {
bool failed;
attributeData->rigid_body = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_REF_ATTACHMENT,
        HASH_ATTRIBUTE_rigid_body,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= ref_attachment__AttributeData::ATTRIBUTE_RIGID_BODY_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_REF_ATTACHMENT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & ref_attachment__AttributeData::ATTRIBUTE_RIGID_BODY_PRESENT) == 0)
{
    attributeData->rigid_body = COLLADABU::URI("");
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__ref_attachment()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ref_attachment();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__ref_attachment( void* attributeData )
{
    ref_attachment__AttributeData* typedAttributeData = static_cast<ref_attachment__AttributeData*>(attributeData);

    typedAttributeData->~ref_attachment__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const attachment__AttributeData attachment__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__attachment( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__attachment( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__attachment( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

attachment__AttributeData* attributeData = newData<attachment__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_rigid_body:
    {
bool failed;
attributeData->rigid_body = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ATTACHMENT,
        HASH_ATTRIBUTE_rigid_body,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= attachment__AttributeData::ATTRIBUTE_RIGID_BODY_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ATTACHMENT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & attachment__AttributeData::ATTRIBUTE_RIGID_BODY_PRESENT) == 0)
{
    attributeData->rigid_body = COLLADABU::URI("");
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__attachment()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__attachment();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__attachment( void* attributeData )
{
    attachment__AttributeData* typedAttributeData = static_cast<attachment__AttributeData*>(attributeData);

    typedAttributeData->~attachment__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__rigid_constraint__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__rigid_constraint__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__rigid_constraint__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__rigid_constraint__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__rigid_constraint__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__rigid_constraint__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const enabled__AttributeData enabled__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__enabled( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__enabled( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__enabled( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

enabled__AttributeData* attributeData = newData<enabled__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ENABLED,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ENABLED, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__enabled()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__enabled();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__enabled(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ENABLED, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__enabled( void* attributeData )
{
    enabled__AttributeData* typedAttributeData = static_cast<enabled__AttributeData*>(attributeData);

    typedAttributeData->~enabled__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const interpenetrate__AttributeData interpenetrate__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__interpenetrate( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__interpenetrate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__interpenetrate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

interpenetrate__AttributeData* attributeData = newData<interpenetrate__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INTERPENETRATE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INTERPENETRATE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__interpenetrate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__interpenetrate();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__interpenetrate(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_INTERPENETRATE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__interpenetrate( void* attributeData )
{
    interpenetrate__AttributeData* typedAttributeData = static_cast<interpenetrate__AttributeData*>(attributeData);

    typedAttributeData->~interpenetrate__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__limits( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__limits( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__limits( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__limits()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__limits();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__limits( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__swing_cone_and_twist( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__swing_cone_and_twist( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__swing_cone_and_twist( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__swing_cone_and_twist()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__swing_cone_and_twist();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__swing_cone_and_twist( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const min__AttributeData min__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__min( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__min, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__min);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__min);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__min( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__min( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

min__AttributeData* attributeData = newData<min__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_MIN,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MIN, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__min()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__min();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__min, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_MIN,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__min );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__min );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__min( void* attributeData )
{
    min__AttributeData* typedAttributeData = static_cast<min__AttributeData*>(attributeData);

    typedAttributeData->~min__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const max__AttributeData max__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__max( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__max, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__max);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__max);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__max( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__max( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

max__AttributeData* attributeData = newData<max__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_MAX,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MAX, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__max()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__max();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__max, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_MAX,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__max );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__max );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__max( void* attributeData )
{
    max__AttributeData* typedAttributeData = static_cast<max__AttributeData*>(attributeData);

    typedAttributeData->~max__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__limits__linear( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__limits__linear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__limits__linear( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__limits__linear()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__limits__linear();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__limits__linear( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__spring( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__spring( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__spring( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__spring()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__spring();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__spring( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__angular( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__angular( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__angular( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__angular()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__angular();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__angular( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const stiffness__AttributeData stiffness__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__stiffness( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__stiffness( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__stiffness( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

stiffness__AttributeData* attributeData = newData<stiffness__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_STIFFNESS,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_STIFFNESS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__stiffness()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__stiffness();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__stiffness(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_STIFFNESS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__stiffness( void* attributeData )
{
    stiffness__AttributeData* typedAttributeData = static_cast<stiffness__AttributeData*>(attributeData);

    typedAttributeData->~stiffness__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const damping__AttributeData damping__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__damping( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__damping( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__damping( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

damping__AttributeData* attributeData = newData<damping__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_DAMPING,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DAMPING, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__damping()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__damping();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__damping(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_DAMPING, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__damping( void* attributeData )
{
    damping__AttributeData* typedAttributeData = static_cast<damping__AttributeData*>(attributeData);

    typedAttributeData->~damping__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const target_value__AttributeData target_value__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__target_value( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__target_value( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__target_value( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

target_value__AttributeData* attributeData = newData<target_value__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TARGET_VALUE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TARGET_VALUE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__target_value()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__target_value();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__target_value(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_TARGET_VALUE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__target_value( void* attributeData )
{
    target_value__AttributeData* typedAttributeData = static_cast<target_value__AttributeData*>(attributeData);

    typedAttributeData->~target_value__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__spring__linear( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__spring__linear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__spring__linear( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__spring__linear()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__spring__linear();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__spring__linear( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const instance_physics_model__AttributeData instance_physics_model__AttributeData::DEFAULT = {0, 0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_physics_model( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_physics_model( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_physics_model( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_physics_model__AttributeData* attributeData = newData<instance_physics_model__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_PHYSICS_MODEL,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_physics_model__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_PHYSICS_MODEL,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_PHYSICS_MODEL,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_parent:
    {
bool failed;
attributeData->parent = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_PHYSICS_MODEL,
        HASH_ATTRIBUTE_parent,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_physics_model__AttributeData::ATTRIBUTE_PARENT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_PHYSICS_MODEL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_physics_model__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ((attributeData->present_attributes & instance_physics_model__AttributeData::ATTRIBUTE_PARENT_PRESENT) == 0)
{
    attributeData->parent = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_physics_model__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_PHYSICS_MODEL, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_physics_model()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_physics_model();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_physics_model( void* attributeData )
{
    instance_physics_model__AttributeData* typedAttributeData = static_cast<instance_physics_model__AttributeData*>(attributeData);

    typedAttributeData->~instance_physics_model__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_force_field__AttributeData instance_force_field__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_force_field( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_force_field( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_force_field( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_force_field__AttributeData* attributeData = newData<instance_force_field__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_FORCE_FIELD,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_force_field__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_FORCE_FIELD,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_FORCE_FIELD,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_FORCE_FIELD, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_force_field__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_force_field__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_FORCE_FIELD, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_force_field()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_force_field();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_force_field( void* attributeData )
{
    instance_force_field__AttributeData* typedAttributeData = static_cast<instance_force_field__AttributeData*>(attributeData);

    typedAttributeData->~instance_force_field__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_rigid_body__AttributeData instance_rigid_body__AttributeData::DEFAULT = {0, 0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_body( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_body( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_body( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_rigid_body__AttributeData* attributeData = newData<instance_rigid_body__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_body:
    {

attributeData->body = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->body, strlen(attributeData->body));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_RIGID_BODY,
            HASH_ATTRIBUTE_body,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_RIGID_BODY,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_RIGID_BODY,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_target:
    {
bool failed;
attributeData->target = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_RIGID_BODY,
        HASH_ATTRIBUTE_target,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_rigid_body__AttributeData::ATTRIBUTE_TARGET_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_RIGID_BODY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_rigid_body__AttributeData::ATTRIBUTE_TARGET_PRESENT) == 0)
{
    attributeData->target = COLLADABU::URI("");
}
if ( !attributeData->body )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_RIGID_BODY, HASH_ATTRIBUTE_body, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & instance_rigid_body__AttributeData::ATTRIBUTE_TARGET_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_RIGID_BODY, HASH_ATTRIBUTE_target, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_body()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_body();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_body( void* attributeData )
{
    instance_rigid_body__AttributeData* typedAttributeData = static_cast<instance_rigid_body__AttributeData*>(attributeData);

    typedAttributeData->~instance_rigid_body__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_body__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_body__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_body__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_body__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_body__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_body__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__angular_velocity( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__angular_velocity, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__angular_velocity);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__angular_velocity);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__angular_velocity( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__angular_velocity( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__angular_velocity()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__angular_velocity();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__angular_velocity, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_ANGULAR_VELOCITY,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__angular_velocity );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__angular_velocity );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__angular_velocity( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__velocity( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__velocity, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__velocity);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__velocity);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__velocity( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__velocity( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__velocity()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__velocity();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__velocity, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_VELOCITY,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__velocity );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__velocity );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__velocity( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const instance_rigid_body__technique_common__dynamic__AttributeData instance_rigid_body__technique_common__dynamic__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_body__technique_common__dynamic( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_body__technique_common__dynamic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_body__technique_common__dynamic( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_rigid_body__technique_common__dynamic__AttributeData* attributeData = newData<instance_rigid_body__technique_common__dynamic__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_DYNAMIC,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DYNAMIC, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_body__technique_common__dynamic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_body__technique_common__dynamic();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__instance_rigid_body__technique_common__dynamic(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_DYNAMIC, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_body__technique_common__dynamic( void* attributeData )
{
    instance_rigid_body__technique_common__dynamic__AttributeData* typedAttributeData = static_cast<instance_rigid_body__technique_common__dynamic__AttributeData*>(attributeData);

    typedAttributeData->~instance_rigid_body__technique_common__dynamic__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_body__technique_common__mass_frame( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_body__technique_common__mass_frame( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_body__technique_common__mass_frame( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_body__technique_common__mass_frame()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_body__technique_common__mass_frame();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_body__technique_common__mass_frame( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_body__technique_common__shape( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_body__technique_common__shape( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_body__technique_common__shape( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_body__technique_common__shape()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_body__technique_common__shape();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_body__technique_common__shape( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const instance_rigid_body__technique_common__shape__hollow__AttributeData instance_rigid_body__technique_common__shape__hollow__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_body__technique_common__shape__hollow( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_body__technique_common__shape__hollow( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_body__technique_common__shape__hollow( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_rigid_body__technique_common__shape__hollow__AttributeData* attributeData = newData<instance_rigid_body__technique_common__shape__hollow__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_HOLLOW,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_HOLLOW, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_body__technique_common__shape__hollow()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_body__technique_common__shape__hollow();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__instance_rigid_body__technique_common__shape__hollow(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_HOLLOW, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_body__technique_common__shape__hollow( void* attributeData )
{
    instance_rigid_body__technique_common__shape__hollow__AttributeData* typedAttributeData = static_cast<instance_rigid_body__technique_common__shape__hollow__AttributeData*>(attributeData);

    typedAttributeData->~instance_rigid_body__technique_common__shape__hollow__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_rigid_constraint__AttributeData instance_rigid_constraint__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_rigid_constraint( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_rigid_constraint( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_rigid_constraint( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_rigid_constraint__AttributeData* attributeData = newData<instance_rigid_constraint__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_constraint:
    {

attributeData->constraint = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->constraint, strlen(attributeData->constraint));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT,
            HASH_ATTRIBUTE_constraint,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->constraint )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_RIGID_CONSTRAINT, HASH_ATTRIBUTE_constraint, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_rigid_constraint()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_rigid_constraint();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_rigid_constraint( void* attributeData )
{
    instance_rigid_constraint__AttributeData* typedAttributeData = static_cast<instance_rigid_constraint__AttributeData*>(attributeData);

    typedAttributeData->~instance_rigid_constraint__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_physics_scenes__AttributeData library_physics_scenes__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_physics_scenes( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_physics_scenes( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_physics_scenes( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_physics_scenes__AttributeData* attributeData = newData<library_physics_scenes__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_PHYSICS_SCENES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_PHYSICS_SCENES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_physics_scenes()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_physics_scenes();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_physics_scenes( void* attributeData )
{
    library_physics_scenes__AttributeData* typedAttributeData = static_cast<library_physics_scenes__AttributeData*>(attributeData);

    typedAttributeData->~library_physics_scenes__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const physics_scene__AttributeData physics_scene__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__physics_scene( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__physics_scene( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__physics_scene( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

physics_scene__AttributeData* attributeData = newData<physics_scene__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PHYSICS_SCENE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PHYSICS_SCENE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__physics_scene()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__physics_scene();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__physics_scene( void* attributeData )
{
    physics_scene__AttributeData* typedAttributeData = static_cast<physics_scene__AttributeData*>(attributeData);

    typedAttributeData->~physics_scene__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__physics_scene__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__physics_scene__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__physics_scene__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__physics_scene__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__physics_scene__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__physics_scene__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const gravity__AttributeData gravity__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__gravity( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__gravity, &validate__float3__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__gravity);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen14::data__gravity);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__gravity( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__gravity( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

gravity__AttributeData* attributeData = newData<gravity__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_GRAVITY,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_GRAVITY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__gravity()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__gravity();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen14::data__gravity, &validate__float3__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_GRAVITY,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__gravity );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen14::data__gravity );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__gravity( void* attributeData )
{
    gravity__AttributeData* typedAttributeData = static_cast<gravity__AttributeData*>(attributeData);

    typedAttributeData->~gravity__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const time_step__AttributeData time_step__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__time_step( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__time_step( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__time_step( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

time_step__AttributeData* attributeData = newData<time_step__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TIME_STEP,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TIME_STEP, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__time_step()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__time_step();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__time_step(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_TIME_STEP, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__time_step( void* attributeData )
{
    time_step__AttributeData* typedAttributeData = static_cast<time_step__AttributeData*>(attributeData);

    typedAttributeData->~time_step__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_visual_scenes__AttributeData library_visual_scenes__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__library_visual_scenes( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__library_visual_scenes( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_visual_scenes( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_visual_scenes__AttributeData* attributeData = newData<library_visual_scenes__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LIBRARY_VISUAL_SCENES,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_VISUAL_SCENES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__library_visual_scenes()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_visual_scenes();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__library_visual_scenes( void* attributeData )
{
    library_visual_scenes__AttributeData* typedAttributeData = static_cast<library_visual_scenes__AttributeData*>(attributeData);

    typedAttributeData->~library_visual_scenes__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const visual_scene__AttributeData visual_scene__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__visual_scene( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__visual_scene( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__visual_scene( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

visual_scene__AttributeData* attributeData = newData<visual_scene__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_VISUAL_SCENE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_VISUAL_SCENE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__visual_scene()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__visual_scene();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__visual_scene( void* attributeData )
{
    visual_scene__AttributeData* typedAttributeData = static_cast<visual_scene__AttributeData*>(attributeData);

    typedAttributeData->~visual_scene__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const evaluate_scene__AttributeData evaluate_scene__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__evaluate_scene( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__evaluate_scene( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__evaluate_scene( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

evaluate_scene__AttributeData* attributeData = newData<evaluate_scene__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_EVALUATE_SCENE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_EVALUATE_SCENE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__evaluate_scene()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__evaluate_scene();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__evaluate_scene( void* attributeData )
{
    evaluate_scene__AttributeData* typedAttributeData = static_cast<evaluate_scene__AttributeData*>(attributeData);

    typedAttributeData->~evaluate_scene__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const render__AttributeData render__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__render( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__render( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__render( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

render__AttributeData* attributeData = newData<render__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_camera_node:
    {
bool failed;
attributeData->camera_node = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_RENDER,
        HASH_ATTRIBUTE_camera_node,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= render__AttributeData::ATTRIBUTE_CAMERA_NODE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_RENDER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & render__AttributeData::ATTRIBUTE_CAMERA_NODE_PRESENT) == 0)
{
    attributeData->camera_node = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & render__AttributeData::ATTRIBUTE_CAMERA_NODE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_RENDER, HASH_ATTRIBUTE_camera_node, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__render()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__render();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__render( void* attributeData )
{
    render__AttributeData* typedAttributeData = static_cast<render__AttributeData*>(attributeData);

    typedAttributeData->~render__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__layer( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__layer( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__layer( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__layer()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__layer();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__layer(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__layer( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__scene( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__scene( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__scene( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__scene()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__scene();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__scene( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const instance_physics_scene__AttributeData instance_physics_scene__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_physics_scene( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_physics_scene( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_physics_scene( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_physics_scene__AttributeData* attributeData = newData<instance_physics_scene__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_PHYSICS_SCENE,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_physics_scene__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_PHYSICS_SCENE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_PHYSICS_SCENE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_PHYSICS_SCENE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_physics_scene__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_physics_scene__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_PHYSICS_SCENE, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_physics_scene()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_physics_scene();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_physics_scene( void* attributeData )
{
    instance_physics_scene__AttributeData* typedAttributeData = static_cast<instance_physics_scene__AttributeData*>(attributeData);

    typedAttributeData->~instance_physics_scene__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_visual_scene__AttributeData instance_visual_scene__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__instance_visual_scene( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__instance_visual_scene( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_visual_scene( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_visual_scene__AttributeData* attributeData = newData<instance_visual_scene__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_url:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_VISUAL_SCENE,
        HASH_ATTRIBUTE_url,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_visual_scene__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_VISUAL_SCENE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_name:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_VISUAL_SCENE,
            HASH_ATTRIBUTE_name,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_VISUAL_SCENE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_visual_scene__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_visual_scene__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_VISUAL_SCENE, HASH_ATTRIBUTE_url, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__instance_visual_scene()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_visual_scene();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__instance_visual_scene( void* attributeData )
{
    instance_visual_scene__AttributeData* typedAttributeData = static_cast<instance_visual_scene__AttributeData*>(attributeData);

    typedAttributeData->~instance_visual_scene__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES__AttributeData profile_GLES__AttributeData::DEFAULT = {0, (const ParserChar*)"PC"};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__profile_GLES( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__profile_GLES( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES__AttributeData* attributeData = newData<profile_GLES__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_id:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_platform:
    {

attributeData->platform = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->platform, strlen(attributeData->platform));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PROFILE_GLES,
            HASH_ATTRIBUTE_platform,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PROFILE_GLES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__profile_GLES()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__profile_GLES( void* attributeData )
{
    profile_GLES__AttributeData* typedAttributeData = static_cast<profile_GLES__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const newparam____gles_newparam__AttributeData newparam____gles_newparam__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__newparam____gles_newparam( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__newparam____gles_newparam( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__newparam____gles_newparam( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

newparam____gles_newparam__AttributeData* attributeData = newData<newparam____gles_newparam__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NEWPARAM,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NEWPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NEWPARAM, HASH_ATTRIBUTE_sid, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__newparam____gles_newparam()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__newparam____gles_newparam();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__newparam____gles_newparam( void* attributeData )
{
    newparam____gles_newparam__AttributeData* typedAttributeData = static_cast<newparam____gles_newparam__AttributeData*>(attributeData);

    typedAttributeData->~newparam____gles_newparam__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const texture_pipeline____gles_texture_pipeline__AttributeData texture_pipeline____gles_texture_pipeline__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__texture_pipeline____gles_texture_pipeline( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__texture_pipeline____gles_texture_pipeline( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__texture_pipeline____gles_texture_pipeline( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

texture_pipeline____gles_texture_pipeline__AttributeData* attributeData = newData<texture_pipeline____gles_texture_pipeline__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TEXTURE_PIPELINE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TEXTURE_PIPELINE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__texture_pipeline____gles_texture_pipeline()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__texture_pipeline____gles_texture_pipeline();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__texture_pipeline____gles_texture_pipeline( void* attributeData )
{
    texture_pipeline____gles_texture_pipeline__AttributeData* typedAttributeData = static_cast<texture_pipeline____gles_texture_pipeline__AttributeData*>(attributeData);

    typedAttributeData->~texture_pipeline____gles_texture_pipeline__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__texcombiner( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__texcombiner( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__texcombiner( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__texcombiner()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__texcombiner();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__texcombiner( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const constant____gles_texture_constant_type__AttributeData constant____gles_texture_constant_type__AttributeData::DEFAULT = {0, GeneratedSaxParser::XSList<float>(), 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__constant____gles_texture_constant_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__constant____gles_texture_constant_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__constant____gles_texture_constant_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

constant____gles_texture_constant_type__AttributeData* attributeData = newData<constant____gles_texture_constant_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_value:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2FloatList(attributeValue, attributeData->value, 0, HASH_ELEMENT_CONSTANT, HASH_ATTRIBUTE_value);
    }
    else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    }
#else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_CONSTANT,
        HASH_ATTRIBUTE_value,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__float4(attributeData->value.data, attributeData->value.size);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CONSTANT,
            HASH_ATTRIBUTE_value,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

if ( !failed )
    attributeData->present_attributes |= constant____gles_texture_constant_type__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_param:
    {

attributeData->param = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->param, strlen(attributeData->param));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CONSTANT,
            HASH_ATTRIBUTE_param,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONSTANT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & constant____gles_texture_constant_type__AttributeData::ATTRIBUTE_VALUE_PRESENT) == 0)
{
    attributeData->value = GeneratedSaxParser::XSList<float>();
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__constant____gles_texture_constant_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__constant____gles_texture_constant_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__constant____gles_texture_constant_type( void* attributeData )
{
    constant____gles_texture_constant_type__AttributeData* typedAttributeData = static_cast<constant____gles_texture_constant_type__AttributeData*>(attributeData);
    if (typedAttributeData->value.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~constant____gles_texture_constant_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const RGB__AttributeData RGB__AttributeData::DEFAULT = {0, ENUM__gles_texcombiner_operatorRGB_enums__NOT_PRESENT, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__RGB( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__RGB( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__RGB( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

RGB__AttributeData* attributeData = newData<RGB__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_operator:
    {
bool failed;
attributeData->_operator = Utils::toEnum<ENUM__gles_texcombiner_operatorRGB_enums, StringHash, ENUM__gles_texcombiner_operatorRGB_enums__COUNT>(attributeValue, failed, ENUM__gles_texcombiner_operatorRGB_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_RGB,
        HASH_ATTRIBUTE_operator,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_scale:
    {
bool failed;
attributeData->scale = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_RGB,
        HASH_ATTRIBUTE_scale,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= RGB__AttributeData::ATTRIBUTE_SCALE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_RGB, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__RGB()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__RGB();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__RGB( void* attributeData )
{
    RGB__AttributeData* typedAttributeData = static_cast<RGB__AttributeData*>(attributeData);

    typedAttributeData->~RGB__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__gles_texcombiner_operatorRGB_enums ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operatorRGB_enums (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_texcombiner_operatorRGB_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_texcombiner_operatorRGB_enums, StringHash, ENUM__gles_texcombiner_operatorRGB_enums__COUNT, &toEnum_ENUM__gles_texcombiner_operatorRGB_enums>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_texcombiner_operatorRGB_enums (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operatorRGB_enums*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_texcombiner_operatorRGB_enums, StringHash, ENUM__gles_texcombiner_operatorRGB_enums__COUNT>(text, textLength, dataFunction, ENUM__gles_texcombiner_operatorRGB_enumsMap, baseConversionFunc, &toEnum_ENUM__gles_texcombiner_operatorRGB_enums, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operatorRGB_enums);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_texcombiner_operatorRGB_enums (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operatorRGB_enums*, size_t ),
    const std::pair<StringHash, ENUM__gles_texcombiner_operatorRGB_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_texcombiner_operatorRGB_enums (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_texcombiner_operatorRGB_enums>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_texcombiner_operatorRGB_enums, StringHash, ENUM__gles_texcombiner_operatorRGB_enums__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const argument____gles_texcombiner_argumentRGB_type__AttributeData argument____gles_texcombiner_argumentRGB_type__AttributeData::DEFAULT = {ENUM__gles_texcombiner_source_enums__NOT_PRESENT, ENUM__gles_texcombiner_operandRGB_enums__SRC_COLOR, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__argument____gles_texcombiner_argumentRGB_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__argument____gles_texcombiner_argumentRGB_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__argument____gles_texcombiner_argumentRGB_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

argument____gles_texcombiner_argumentRGB_type__AttributeData* attributeData = newData<argument____gles_texcombiner_argumentRGB_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_source:
    {
bool failed;
attributeData->source = Utils::toEnum<ENUM__gles_texcombiner_source_enums, StringHash, ENUM__gles_texcombiner_source_enums__COUNT>(attributeValue, failed, ENUM__gles_texcombiner_source_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ARGUMENT,
        HASH_ATTRIBUTE_source,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_operand:
    {
bool failed;
attributeData->operand = Utils::toEnum<ENUM__gles_texcombiner_operandRGB_enums, StringHash, ENUM__gles_texcombiner_operandRGB_enums__COUNT>(attributeValue, failed, ENUM__gles_texcombiner_operandRGB_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ARGUMENT,
        HASH_ATTRIBUTE_operand,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_unit:
    {

attributeData->unit = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->unit, strlen(attributeData->unit));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ARGUMENT,
            HASH_ATTRIBUTE_unit,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ARGUMENT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__argument____gles_texcombiner_argumentRGB_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__argument____gles_texcombiner_argumentRGB_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__argument____gles_texcombiner_argumentRGB_type( void* attributeData )
{
    argument____gles_texcombiner_argumentRGB_type__AttributeData* typedAttributeData = static_cast<argument____gles_texcombiner_argumentRGB_type__AttributeData*>(attributeData);

    typedAttributeData->~argument____gles_texcombiner_argumentRGB_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__gles_texcombiner_source_enums ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_source_enums (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_texcombiner_source_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_texcombiner_source_enums, StringHash, ENUM__gles_texcombiner_source_enums__COUNT, &toEnum_ENUM__gles_texcombiner_source_enums>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_texcombiner_source_enums (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_source_enums*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_texcombiner_source_enums, StringHash, ENUM__gles_texcombiner_source_enums__COUNT>(text, textLength, dataFunction, ENUM__gles_texcombiner_source_enumsMap, baseConversionFunc, &toEnum_ENUM__gles_texcombiner_source_enums, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_source_enums);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_texcombiner_source_enums (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_source_enums*, size_t ),
    const std::pair<StringHash, ENUM__gles_texcombiner_source_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_texcombiner_source_enums (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_texcombiner_source_enums>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_texcombiner_source_enums, StringHash, ENUM__gles_texcombiner_source_enums__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gles_texcombiner_operandRGB_enums ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operandRGB_enums (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_texcombiner_operandRGB_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_texcombiner_operandRGB_enums, StringHash, ENUM__gles_texcombiner_operandRGB_enums__COUNT, &toEnum_ENUM__gles_texcombiner_operandRGB_enums>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_texcombiner_operandRGB_enums (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operandRGB_enums*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_texcombiner_operandRGB_enums, StringHash, ENUM__gles_texcombiner_operandRGB_enums__COUNT>(text, textLength, dataFunction, ENUM__gles_texcombiner_operandRGB_enumsMap, baseConversionFunc, &toEnum_ENUM__gles_texcombiner_operandRGB_enums, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operandRGB_enums);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_texcombiner_operandRGB_enums (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operandRGB_enums*, size_t ),
    const std::pair<StringHash, ENUM__gles_texcombiner_operandRGB_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_texcombiner_operandRGB_enums (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_texcombiner_operandRGB_enums>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_texcombiner_operandRGB_enums, StringHash, ENUM__gles_texcombiner_operandRGB_enums__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const alpha____gles_texcombiner_commandAlpha_type__AttributeData alpha____gles_texcombiner_commandAlpha_type__AttributeData::DEFAULT = {0, ENUM__gles_texcombiner_operatorAlpha_enums__NOT_PRESENT, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__alpha____gles_texcombiner_commandAlpha_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__alpha____gles_texcombiner_commandAlpha_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__alpha____gles_texcombiner_commandAlpha_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

alpha____gles_texcombiner_commandAlpha_type__AttributeData* attributeData = newData<alpha____gles_texcombiner_commandAlpha_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_operator:
    {
bool failed;
attributeData->_operator = Utils::toEnum<ENUM__gles_texcombiner_operatorAlpha_enums, StringHash, ENUM__gles_texcombiner_operatorAlpha_enums__COUNT>(attributeValue, failed, ENUM__gles_texcombiner_operatorAlpha_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ALPHA,
        HASH_ATTRIBUTE_operator,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_scale:
    {
bool failed;
attributeData->scale = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ALPHA,
        HASH_ATTRIBUTE_scale,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= alpha____gles_texcombiner_commandAlpha_type__AttributeData::ATTRIBUTE_SCALE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ALPHA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__alpha____gles_texcombiner_commandAlpha_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__alpha____gles_texcombiner_commandAlpha_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__alpha____gles_texcombiner_commandAlpha_type( void* attributeData )
{
    alpha____gles_texcombiner_commandAlpha_type__AttributeData* typedAttributeData = static_cast<alpha____gles_texcombiner_commandAlpha_type__AttributeData*>(attributeData);

    typedAttributeData->~alpha____gles_texcombiner_commandAlpha_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__gles_texcombiner_operatorAlpha_enums ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operatorAlpha_enums (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_texcombiner_operatorAlpha_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_texcombiner_operatorAlpha_enums, StringHash, ENUM__gles_texcombiner_operatorAlpha_enums__COUNT, &toEnum_ENUM__gles_texcombiner_operatorAlpha_enums>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_texcombiner_operatorAlpha_enums (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operatorAlpha_enums*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_texcombiner_operatorAlpha_enums, StringHash, ENUM__gles_texcombiner_operatorAlpha_enums__COUNT>(text, textLength, dataFunction, ENUM__gles_texcombiner_operatorAlpha_enumsMap, baseConversionFunc, &toEnum_ENUM__gles_texcombiner_operatorAlpha_enums, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operatorAlpha_enums);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_texcombiner_operatorAlpha_enums (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operatorAlpha_enums*, size_t ),
    const std::pair<StringHash, ENUM__gles_texcombiner_operatorAlpha_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_texcombiner_operatorAlpha_enums (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_texcombiner_operatorAlpha_enums>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_texcombiner_operatorAlpha_enums, StringHash, ENUM__gles_texcombiner_operatorAlpha_enums__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const argument____gles_texcombiner_argumentAlpha_type__AttributeData argument____gles_texcombiner_argumentAlpha_type__AttributeData::DEFAULT = {ENUM__gles_texcombiner_source_enums__NOT_PRESENT, ENUM__gles_texcombiner_operandAlpha_enums__SRC_ALPHA, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__argument____gles_texcombiner_argumentAlpha_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__argument____gles_texcombiner_argumentAlpha_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__argument____gles_texcombiner_argumentAlpha_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

argument____gles_texcombiner_argumentAlpha_type__AttributeData* attributeData = newData<argument____gles_texcombiner_argumentAlpha_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_source:
    {
bool failed;
attributeData->source = Utils::toEnum<ENUM__gles_texcombiner_source_enums, StringHash, ENUM__gles_texcombiner_source_enums__COUNT>(attributeValue, failed, ENUM__gles_texcombiner_source_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ARGUMENT,
        HASH_ATTRIBUTE_source,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_operand:
    {
bool failed;
attributeData->operand = Utils::toEnum<ENUM__gles_texcombiner_operandAlpha_enums, StringHash, ENUM__gles_texcombiner_operandAlpha_enums__COUNT>(attributeValue, failed, ENUM__gles_texcombiner_operandAlpha_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ARGUMENT,
        HASH_ATTRIBUTE_operand,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_unit:
    {

attributeData->unit = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->unit, strlen(attributeData->unit));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ARGUMENT,
            HASH_ATTRIBUTE_unit,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ARGUMENT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__argument____gles_texcombiner_argumentAlpha_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__argument____gles_texcombiner_argumentAlpha_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__argument____gles_texcombiner_argumentAlpha_type( void* attributeData )
{
    argument____gles_texcombiner_argumentAlpha_type__AttributeData* typedAttributeData = static_cast<argument____gles_texcombiner_argumentAlpha_type__AttributeData*>(attributeData);

    typedAttributeData->~argument____gles_texcombiner_argumentAlpha_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__gles_texcombiner_operandAlpha_enums ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operandAlpha_enums (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_texcombiner_operandAlpha_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_texcombiner_operandAlpha_enums, StringHash, ENUM__gles_texcombiner_operandAlpha_enums__COUNT, &toEnum_ENUM__gles_texcombiner_operandAlpha_enums>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_texcombiner_operandAlpha_enums (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operandAlpha_enums*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_texcombiner_operandAlpha_enums, StringHash, ENUM__gles_texcombiner_operandAlpha_enums__COUNT>(text, textLength, dataFunction, ENUM__gles_texcombiner_operandAlpha_enumsMap, baseConversionFunc, &toEnum_ENUM__gles_texcombiner_operandAlpha_enums, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texcombiner_operandAlpha_enums);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_texcombiner_operandAlpha_enums (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texcombiner_operandAlpha_enums*, size_t ),
    const std::pair<StringHash, ENUM__gles_texcombiner_operandAlpha_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_texcombiner_operandAlpha_enums (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_texcombiner_operandAlpha_enums>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_texcombiner_operandAlpha_enums, StringHash, ENUM__gles_texcombiner_operandAlpha_enums__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const texenv__AttributeData texenv__AttributeData::DEFAULT = {ENUM__gles_texenv_mode_enums__NOT_PRESENT, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__texenv( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__texenv( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__texenv( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

texenv__AttributeData* attributeData = newData<texenv__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_operator:
    {
bool failed;
attributeData->_operator = Utils::toEnum<ENUM__gles_texenv_mode_enums, StringHash, ENUM__gles_texenv_mode_enums__COUNT>(attributeValue, failed, ENUM__gles_texenv_mode_enumsMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TEXENV,
        HASH_ATTRIBUTE_operator,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_unit:
    {

attributeData->unit = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->unit, strlen(attributeData->unit));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TEXENV,
            HASH_ATTRIBUTE_unit,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TEXENV, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__texenv()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__texenv();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__texenv( void* attributeData )
{
    texenv__AttributeData* typedAttributeData = static_cast<texenv__AttributeData*>(attributeData);

    typedAttributeData->~texenv__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__gles_texenv_mode_enums ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texenv_mode_enums (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_texenv_mode_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_texenv_mode_enums, StringHash, ENUM__gles_texenv_mode_enums__COUNT, &toEnum_ENUM__gles_texenv_mode_enums>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_texenv_mode_enums (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texenv_mode_enums*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_texenv_mode_enums, StringHash, ENUM__gles_texenv_mode_enums__COUNT>(text, textLength, dataFunction, ENUM__gles_texenv_mode_enumsMap, baseConversionFunc, &toEnum_ENUM__gles_texenv_mode_enums, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_texenv_mode_enums);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_texenv_mode_enums (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_texenv_mode_enums*, size_t ),
    const std::pair<StringHash, ENUM__gles_texenv_mode_enums>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_texenv_mode_enums (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_texenv_mode_enums>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_texenv_mode_enums, StringHash, ENUM__gles_texenv_mode_enums__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const sampler_state____gles_sampler_state__AttributeData sampler_state____gles_sampler_state__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sampler_state____gles_sampler_state( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sampler_state____gles_sampler_state( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler_state____gles_sampler_state( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

sampler_state____gles_sampler_state__AttributeData* attributeData = newData<sampler_state____gles_sampler_state__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_SAMPLER_STATE,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SAMPLER_STATE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sampler_state____gles_sampler_state()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler_state____gles_sampler_state();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sampler_state____gles_sampler_state( void* attributeData )
{
    sampler_state____gles_sampler_state__AttributeData* typedAttributeData = static_cast<sampler_state____gles_sampler_state__AttributeData*>(attributeData);

    typedAttributeData->~sampler_state____gles_sampler_state__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__wrap_s____gles_sampler_wrap( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__wrap_s____gles_sampler_wrap( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_s____gles_sampler_wrap( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__wrap_s____gles_sampler_wrap()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_s____gles_sampler_wrap();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__gles_sampler_wrap parameter = Utils::toEnum<ENUM__gles_sampler_wrap, StringHash, ENUM__gles_sampler_wrap__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__gles_sampler_wrapMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_s____gles_sampler_wrap(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__wrap_s____gles_sampler_wrap( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__gles_sampler_wrap ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_sampler_wrap (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gles_sampler_wrap>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gles_sampler_wrap, StringHash, ENUM__gles_sampler_wrap__COUNT, &toEnum_ENUM__gles_sampler_wrap>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::characterData2EnumData_ENUM__gles_sampler_wrap (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_sampler_wrap*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gles_sampler_wrap, StringHash, ENUM__gles_sampler_wrap__COUNT>(text, textLength, dataFunction, ENUM__gles_sampler_wrapMap, baseConversionFunc, &toEnum_ENUM__gles_sampler_wrap, &ColladaParserAutoGen14Private::toEnumDataPrefix_ENUM__gles_sampler_wrap);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::dataEnumEnd_ENUM__gles_sampler_wrap (
    bool ( ColladaParserAutoGen14::*dataFunction )(const ENUM__gles_sampler_wrap*, size_t ),
    const std::pair<StringHash, ENUM__gles_sampler_wrap>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gles_sampler_wrap (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gles_sampler_wrap>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gles_sampler_wrap, StringHash, ENUM__gles_sampler_wrap__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__wrap_t____gles_sampler_wrap( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__wrap_t____gles_sampler_wrap( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_t____gles_sampler_wrap( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__wrap_t____gles_sampler_wrap()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_t____gles_sampler_wrap();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__gles_sampler_wrap parameter = Utils::toEnum<ENUM__gles_sampler_wrap, StringHash, ENUM__gles_sampler_wrap__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__gles_sampler_wrapMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_t____gles_sampler_wrap(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_T, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__wrap_t____gles_sampler_wrap( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const texture_unit__AttributeData texture_unit__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__texture_unit( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__texture_unit( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__texture_unit( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

texture_unit__AttributeData* attributeData = newData<texture_unit__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_sid:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TEXTURE_UNIT,
            HASH_ATTRIBUTE_sid,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TEXTURE_UNIT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__texture_unit()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__texture_unit();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__texture_unit( void* attributeData )
{
    texture_unit__AttributeData* typedAttributeData = static_cast<texture_unit__AttributeData*>(attributeData);

    typedAttributeData->~texture_unit__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__surface____NCName( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__surface____NCName( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__surface____NCName( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__surface____NCName()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__surface____NCName();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__surface____NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__surface____NCName( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__sampler_state____NCName( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__sampler_state____NCName( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler_state____NCName( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__sampler_state____NCName()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler_state____NCName();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__sampler_state____NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__sampler_state____NCName( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const texcoord__AttributeData texcoord__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__texcoord( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__texcoord( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__texcoord( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

texcoord__AttributeData* attributeData = newData<texcoord__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_semantic:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TEXCOORD,
            HASH_ATTRIBUTE_semantic,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TEXCOORD, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preEnd__texcoord()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__texcoord();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_freeAttributes__texcoord( void* attributeData )
{
    texcoord__AttributeData* typedAttributeData = static_cast<texcoord__AttributeData*>(attributeData);

    typedAttributeData->~texcoord__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_data__enum____gles_enumeration( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_preBegin__enum____gles_enumeration( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__enum____gles_enumeration( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) retu