/**********************************************************************
 * $exprinfo_test example -- C source code using TF/ACC PLI routines
 *
 * C source to illustrate reading 4-state logic values into C integers.
 * The signals in Verilog to be read can be a vector of any bit size
 * (including scalar).
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage:
 * ------
 *
 *   Syntax:   $exprinfo_test(<signal>);
 *
 *   Example:
 *    reg [0:39] data;
 *    initial $exprinfo_test(data);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_exprinfoTest_checktf(),
 *              PLIbook_exprinfoTest_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_exprinfoTest_checktf,  /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_exprinfoTest_calltf,   /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$exprinfo_test",              /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_exprinfoTest_checktf()
{
  if (tf_nump() != 1)
    tf_error("Usage error: $exprinfo_test(<signal>);");
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_exprinfoTest_calltf()
{
  s_tfexprinfo info_s;     /* structure for tf_exprinfo() */
  p_vecval     val_array;  /* pointer to value array in info struct */
  int i;
  
  tf_exprinfo(1, &info_s); /* read expression info for arg 1 */

  io_printf("Expression info:\n");
  switch (info_s.expr_type) {
    case TF_NULLPARAM:    io_printf(" type = TF_NULLPARAM\n"); break;
    case TF_STRING:       io_printf(" type = TF_STRING\n"); break;
    case TF_READONLY:     io_printf(" type = TF_READONLY\n"); break;
    case TF_READONLYREAL: io_printf(" type = TF_READONLYREAL\n"); break;
    case TF_READWRITE:    io_printf(" type = TF_READWRITE\n"); break;
    case TF_READWRITEREAL:io_printf(" type = TF_READWRITEREAL\n");break;
    case TF_RWBITSELECT:  io_printf(" type = TF_RWBITSELECT\n"); break;
    case TF_RWPARTSELECT: io_printf(" type = TF_RWPARTSELECT\n"); break;
    case TF_RWMEMSELECT:  io_printf(" type = TF_RWMEMSELECT\n"); break;
    default: io_printf(" type is unknown (%d)\n", info_s.expr_type);
  }
  io_printf(" ngroups = %d\n",     info_s.expr_ngroups);
  io_printf(" vector size = %d\n", info_s.expr_vec_size);
  io_printf(" sign = %d\n",        info_s.expr_sign);
  io_printf(" LHS select = %d\n",  info_s.expr_lhs_select);
  io_printf(" RHS select = %d\n",  info_s.expr_rhs_select);

  switch (info_s.expr_type) {
    case TF_STRING:
      io_printf(" string value = %s\n", info_s.expr_string); break;
    case TF_READONLYREAL:
    case TF_READWRITEREAL:
      io_printf(" real value = %f\n", info_s.real_value); break;
    case TF_READONLY:
    case TF_READWRITE:
    case TF_RWBITSELECT:
    case TF_RWPARTSELECT:
    case TF_RWMEMSELECT:
      val_array = info_s.expr_value_p;
      io_printf(" vector value (in hex):\n");
      for (i=0; i<info_s.expr_ngroups; i++) {
        io_printf("  avalbits[%d] = %x\n", i, val_array[i].avalbits);
        io_printf("  bvalbits[%d] = %x\n", i, val_array[i].bvalbits);
      }
      break;
  }
  io_printf("\n\n");
  return(0);
}

/*********************************************************************/
