# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccountCredentialDetails(msrest.serialization.Model):
    """Credential details of the account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_name: Name of the account.
    :vartype account_name: str
    :ivar data_account_type: Type of the account. Possible values include: "StorageAccount",
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :ivar account_connection_string: Connection string of the account endpoint to use the account
     as a storage endpoint on the device.
    :vartype account_connection_string: str
    :ivar share_credential_details: Per share level unencrypted access credentials.
    :vartype share_credential_details: list[~azure.mgmt.databox.models.ShareCredentialDetails]
    """

    _validation = {
        'account_name': {'readonly': True},
        'data_account_type': {'readonly': True},
        'account_connection_string': {'readonly': True},
        'share_credential_details': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'account_connection_string': {'key': 'accountConnectionString', 'type': 'str'},
        'share_credential_details': {'key': 'shareCredentialDetails', 'type': '[ShareCredentialDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountCredentialDetails, self).__init__(**kwargs)
        self.account_name = None
        self.data_account_type = None
        self.account_connection_string = None
        self.share_credential_details = None


class AdditionalErrorInfo(msrest.serialization.Model):
    """Additional error info.

    :param type: Additional error type.
    :type type: str
    :param info: Additional error info.
    :type info: object
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdditionalErrorInfo, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.info = kwargs.get('info', None)


class AddressValidationOutput(msrest.serialization.Model):
    """Output of the address validation api.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param validation_type: Identifies the type of validation response.Constant filled by server.
     Possible values include: "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob",
     "ValidatePreferences", "ValidateCreateOrderLimit", "ValidateSkuAvailability",
     "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar validation_status: The address validation status. Possible values include: "Valid",
     "Invalid", "Ambiguous".
    :vartype validation_status: str or ~azure.mgmt.databox.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.models.ShippingAddress]
    """

    _validation = {
        'error': {'readonly': True},
        'validation_status': {'readonly': True},
        'alternate_addresses': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'properties.validationType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'CloudError'},
        'validation_status': {'key': 'properties.validationStatus', 'type': 'str'},
        'alternate_addresses': {'key': 'properties.alternateAddresses', 'type': '[ShippingAddress]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressValidationOutput, self).__init__(**kwargs)
        self.validation_type = None  # type: Optional[str]
        self.error = None
        self.validation_status = None
        self.alternate_addresses = None


class ValidationInputResponse(msrest.serialization.Model):
    """Minimum properties that should be present in each individual validation response.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddressValidationProperties, CreateOrderLimitForSubscriptionValidationResponseProperties, DataTransferDetailsValidationResponseProperties, PreferencesValidationResponseProperties, SkuAvailabilityValidationResponseProperties, SubscriptionIsAllowedToCreateJobValidationResponseProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
    }

    _subtype_map = {
        'validation_type': {'ValidateAddress': 'AddressValidationProperties', 'ValidateCreateOrderLimit': 'CreateOrderLimitForSubscriptionValidationResponseProperties', 'ValidateDataTransferDetails': 'DataTransferDetailsValidationResponseProperties', 'ValidatePreferences': 'PreferencesValidationResponseProperties', 'ValidateSkuAvailability': 'SkuAvailabilityValidationResponseProperties', 'ValidateSubscriptionIsAllowedToCreateJob': 'SubscriptionIsAllowedToCreateJobValidationResponseProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationInputResponse, self).__init__(**kwargs)
        self.validation_type = None  # type: Optional[str]
        self.error = None


class AddressValidationProperties(ValidationInputResponse):
    """The address validation output.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar validation_status: The address validation status. Possible values include: "Valid",
     "Invalid", "Ambiguous".
    :vartype validation_status: str or ~azure.mgmt.databox.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.models.ShippingAddress]
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'validation_status': {'readonly': True},
        'alternate_addresses': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'validation_status': {'key': 'validationStatus', 'type': 'str'},
        'alternate_addresses': {'key': 'alternateAddresses', 'type': '[ShippingAddress]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressValidationProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateAddress'  # type: str
        self.validation_status = None
        self.alternate_addresses = None


class ApiError(msrest.serialization.Model):
    """ApiError.

    All required parameters must be populated in order to send to Azure.

    :param error: Required.
    :type error: ~azure.mgmt.databox.models.ErrorDetail
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.error = kwargs['error']


class ApplianceNetworkConfiguration(msrest.serialization.Model):
    """The Network Adapter configuration of a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the network.
    :vartype name: str
    :ivar mac_address: Mac Address.
    :vartype mac_address: str
    """

    _validation = {
        'name': {'readonly': True},
        'mac_address': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplianceNetworkConfiguration, self).__init__(**kwargs)
        self.name = None
        self.mac_address = None


class ArmBaseObject(msrest.serialization.Model):
    """Base class for all objects under resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmBaseObject, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None


class AvailableSkuRequest(msrest.serialization.Model):
    """The filters for showing the available skus.

    All required parameters must be populated in order to send to Azure.

    :param transfer_type: Required. Type of the transfer. Possible values include: "ImportToAzure",
     "ExportFromAzure".
    :type transfer_type: str or ~azure.mgmt.databox.models.TransferType
    :param country: Required. ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements.
    :type country: str
    :param location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type location: str
    :param sku_names: Sku Names to filter for available skus.
    :type sku_names: list[str or ~azure.mgmt.databox.models.SkuName]
    """

    _validation = {
        'transfer_type': {'required': True},
        'country': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'transfer_type': {'key': 'transferType', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku_names': {'key': 'skuNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableSkuRequest, self).__init__(**kwargs)
        self.transfer_type = kwargs['transfer_type']
        self.country = kwargs['country']
        self.location = kwargs['location']
        self.sku_names = kwargs.get('sku_names', None)


class AvailableSkusResult(msrest.serialization.Model):
    """The available skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of available skus.
    :vartype value: list[~azure.mgmt.databox.models.SkuInformation]
    :param next_link: Link for the next set of skus.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInformation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableSkusResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class AzureFileFilterDetails(msrest.serialization.Model):
    """Filter details to transfer Azure files.

    :param file_prefix_list: Prefix list of the Azure files to be transferred.
    :type file_prefix_list: list[str]
    :param file_path_list: List of full path of the files to be transferred.
    :type file_path_list: list[str]
    :param file_share_list: List of file shares to be transferred.
    :type file_share_list: list[str]
    """

    _attribute_map = {
        'file_prefix_list': {'key': 'filePrefixList', 'type': '[str]'},
        'file_path_list': {'key': 'filePathList', 'type': '[str]'},
        'file_share_list': {'key': 'fileShareList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFileFilterDetails, self).__init__(**kwargs)
        self.file_prefix_list = kwargs.get('file_prefix_list', None)
        self.file_path_list = kwargs.get('file_path_list', None)
        self.file_share_list = kwargs.get('file_share_list', None)


class BlobFilterDetails(msrest.serialization.Model):
    """Filter details to transfer Azure Blobs.

    :param blob_prefix_list: Prefix list of the Azure blobs to be transferred.
    :type blob_prefix_list: list[str]
    :param blob_path_list: List of full path of the blobs to be transferred.
    :type blob_path_list: list[str]
    :param container_list: List of blob containers to be transferred.
    :type container_list: list[str]
    """

    _attribute_map = {
        'blob_prefix_list': {'key': 'blobPrefixList', 'type': '[str]'},
        'blob_path_list': {'key': 'blobPathList', 'type': '[str]'},
        'container_list': {'key': 'containerList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobFilterDetails, self).__init__(**kwargs)
        self.blob_prefix_list = kwargs.get('blob_prefix_list', None)
        self.blob_path_list = kwargs.get('blob_path_list', None)
        self.container_list = kwargs.get('container_list', None)


class CancellationReason(msrest.serialization.Model):
    """Reason for cancellation.

    All required parameters must be populated in order to send to Azure.

    :param reason: Required. Reason for cancellation.
    :type reason: str
    """

    _validation = {
        'reason': {'required': True},
    }

    _attribute_map = {
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CancellationReason, self).__init__(**kwargs)
        self.reason = kwargs['reason']


class CloudError(msrest.serialization.Model):
    """Cloud error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param code: Cloud error code.
    :type code: str
    :param message: Cloud error message.
    :type message: str
    :param target: Cloud error target.
    :type target: str
    :ivar details: Cloud error details.
    :vartype details: list[~azure.mgmt.databox.models.CloudError]
    :ivar additional_info: Cloud error additional info.
    :vartype additional_info: list[~azure.mgmt.databox.models.AdditionalErrorInfo]
    """

    _validation = {
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudError]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[AdditionalErrorInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = None
        self.additional_info = None


class ContactDetails(msrest.serialization.Model):
    """Contact Details.

    All required parameters must be populated in order to send to Azure.

    :param contact_name: Required. Contact name of the person.
    :type contact_name: str
    :param phone: Required. Phone number of the contact person.
    :type phone: str
    :param phone_extension: Phone extension number of the contact person.
    :type phone_extension: str
    :param mobile: Mobile number of the contact person.
    :type mobile: str
    :param email_list: Required. List of Email-ids to be notified about job progress.
    :type email_list: list[str]
    :param notification_preference: Notification preference for a job stage.
    :type notification_preference: list[~azure.mgmt.databox.models.NotificationPreference]
    """

    _validation = {
        'contact_name': {'required': True},
        'phone': {'required': True},
        'email_list': {'required': True},
    }

    _attribute_map = {
        'contact_name': {'key': 'contactName', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'phone_extension': {'key': 'phoneExtension', 'type': 'str'},
        'mobile': {'key': 'mobile', 'type': 'str'},
        'email_list': {'key': 'emailList', 'type': '[str]'},
        'notification_preference': {'key': 'notificationPreference', 'type': '[NotificationPreference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactDetails, self).__init__(**kwargs)
        self.contact_name = kwargs['contact_name']
        self.phone = kwargs['phone']
        self.phone_extension = kwargs.get('phone_extension', None)
        self.mobile = kwargs.get('mobile', None)
        self.email_list = kwargs['email_list']
        self.notification_preference = kwargs.get('notification_preference', None)


class CopyLogDetails(msrest.serialization.Model):
    """Details for log generated during copy.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataBoxAccountCopyLogDetails, DataBoxDiskCopyLogDetails, DataBoxHeavyAccountCopyLogDetails.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    """

    _validation = {
        'copy_log_details_type': {'required': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
    }

    _subtype_map = {
        'copy_log_details_type': {'DataBox': 'DataBoxAccountCopyLogDetails', 'DataBoxDisk': 'DataBoxDiskCopyLogDetails', 'DataBoxHeavy': 'DataBoxHeavyAccountCopyLogDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = None  # type: Optional[str]


class CopyProgress(msrest.serialization.Model):
    """Copy progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account. This will be empty for data account
     types other than storage account.
    :vartype storage_account_name: str
    :ivar transfer_type: Transfer type of data. Possible values include: "ImportToAzure",
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.models.TransferType
    :ivar data_account_type: Data Account Type. Possible values include: "StorageAccount",
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_processed: To indicate bytes transferred.
    :vartype bytes_processed: long
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: long
    :ivar files_processed: Number of files processed.
    :vartype files_processed: long
    :ivar total_files_to_process: Total files to process.
    :vartype total_files_to_process: long
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: long
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: long
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: long
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: long
    :ivar directories_errored_out: To indicate directories errored out in the job.
    :vartype directories_errored_out: long
    :ivar invalid_directories_processed: To indicate directories renamed.
    :vartype invalid_directories_processed: long
    :ivar is_enumeration_in_progress: To indicate if enumeration of data is in progress.
     Until this is true, the TotalBytesToProcess may not be valid.
    :vartype is_enumeration_in_progress: bool
    """

    _validation = {
        'storage_account_name': {'readonly': True},
        'transfer_type': {'readonly': True},
        'data_account_type': {'readonly': True},
        'account_id': {'readonly': True},
        'bytes_processed': {'readonly': True},
        'total_bytes_to_process': {'readonly': True},
        'files_processed': {'readonly': True},
        'total_files_to_process': {'readonly': True},
        'invalid_files_processed': {'readonly': True},
        'invalid_file_bytes_uploaded': {'readonly': True},
        'renamed_container_count': {'readonly': True},
        'files_errored_out': {'readonly': True},
        'directories_errored_out': {'readonly': True},
        'invalid_directories_processed': {'readonly': True},
        'is_enumeration_in_progress': {'readonly': True},
    }

    _attribute_map = {
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'transfer_type': {'key': 'transferType', 'type': 'str'},
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'account_id': {'key': 'accountId', 'type': 'str'},
        'bytes_processed': {'key': 'bytesProcessed', 'type': 'long'},
        'total_bytes_to_process': {'key': 'totalBytesToProcess', 'type': 'long'},
        'files_processed': {'key': 'filesProcessed', 'type': 'long'},
        'total_files_to_process': {'key': 'totalFilesToProcess', 'type': 'long'},
        'invalid_files_processed': {'key': 'invalidFilesProcessed', 'type': 'long'},
        'invalid_file_bytes_uploaded': {'key': 'invalidFileBytesUploaded', 'type': 'long'},
        'renamed_container_count': {'key': 'renamedContainerCount', 'type': 'long'},
        'files_errored_out': {'key': 'filesErroredOut', 'type': 'long'},
        'directories_errored_out': {'key': 'directoriesErroredOut', 'type': 'long'},
        'invalid_directories_processed': {'key': 'invalidDirectoriesProcessed', 'type': 'long'},
        'is_enumeration_in_progress': {'key': 'isEnumerationInProgress', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyProgress, self).__init__(**kwargs)
        self.storage_account_name = None
        self.transfer_type = None
        self.data_account_type = None
        self.account_id = None
        self.bytes_processed = None
        self.total_bytes_to_process = None
        self.files_processed = None
        self.total_files_to_process = None
        self.invalid_files_processed = None
        self.invalid_file_bytes_uploaded = None
        self.renamed_container_count = None
        self.files_errored_out = None
        self.directories_errored_out = None
        self.invalid_directories_processed = None
        self.is_enumeration_in_progress = None


class ValidationRequest(msrest.serialization.Model):
    """Minimum request requirement of any validation category.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CreateJobValidations.

    All required parameters must be populated in order to send to Azure.

    :param validation_category: Required. Identify the nature of validation.Constant filled by
     server.
    :type validation_category: str
    :param individual_request_details: Required. List of request details contain validationType and
     its request as key and value respectively.
    :type individual_request_details: list[~azure.mgmt.databox.models.ValidationInputRequest]
    """

    _validation = {
        'validation_category': {'required': True},
        'individual_request_details': {'required': True},
    }

    _attribute_map = {
        'validation_category': {'key': 'validationCategory', 'type': 'str'},
        'individual_request_details': {'key': 'individualRequestDetails', 'type': '[ValidationInputRequest]'},
    }

    _subtype_map = {
        'validation_category': {'JobCreationValidation': 'CreateJobValidations'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationRequest, self).__init__(**kwargs)
        self.validation_category = None  # type: Optional[str]
        self.individual_request_details = kwargs['individual_request_details']


class CreateJobValidations(ValidationRequest):
    """It does all pre-job creation validations.

    All required parameters must be populated in order to send to Azure.

    :param validation_category: Required. Identify the nature of validation.Constant filled by
     server.
    :type validation_category: str
    :param individual_request_details: Required. List of request details contain validationType and
     its request as key and value respectively.
    :type individual_request_details: list[~azure.mgmt.databox.models.ValidationInputRequest]
    """

    _validation = {
        'validation_category': {'required': True},
        'individual_request_details': {'required': True},
    }

    _attribute_map = {
        'validation_category': {'key': 'validationCategory', 'type': 'str'},
        'individual_request_details': {'key': 'individualRequestDetails', 'type': '[ValidationInputRequest]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateJobValidations, self).__init__(**kwargs)
        self.validation_category = 'JobCreationValidation'  # type: str


class ValidationInputRequest(msrest.serialization.Model):
    """Minimum fields that must be present in any type of validation request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ValidateAddress, CreateOrderLimitForSubscriptionValidationRequest, DataTransferDetailsValidationRequest, PreferencesValidationRequest, SkuAvailabilityValidationRequest, SubscriptionIsAllowedToCreateJobValidationRequest.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    """

    _validation = {
        'validation_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
    }

    _subtype_map = {
        'validation_type': {'ValidateAddress': 'ValidateAddress', 'ValidateCreateOrderLimit': 'CreateOrderLimitForSubscriptionValidationRequest', 'ValidateDataTransferDetails': 'DataTransferDetailsValidationRequest', 'ValidatePreferences': 'PreferencesValidationRequest', 'ValidateSkuAvailability': 'SkuAvailabilityValidationRequest', 'ValidateSubscriptionIsAllowedToCreateJob': 'SubscriptionIsAllowedToCreateJobValidationRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationInputRequest, self).__init__(**kwargs)
        self.validation_type = None  # type: Optional[str]


class CreateOrderLimitForSubscriptionValidationRequest(ValidationInputRequest):
    """Request to validate create order limit for current subscription.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrderLimitForSubscriptionValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateCreateOrderLimit'  # type: str
        self.device_type = kwargs['device_type']


class CreateOrderLimitForSubscriptionValidationResponseProperties(ValidationInputResponse):
    """Properties of create order limit for subscription validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar status: Create order limit validation status. Possible values include: "Valid",
     "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrderLimitForSubscriptionValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateCreateOrderLimit'  # type: str
        self.status = None


class DataAccountDetails(msrest.serialization.Model):
    """Account details of the data to be transferred.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedDiskDetails, StorageAccountDetails.

    All required parameters must be populated in order to send to Azure.

    :param data_account_type: Required. Account Type of the data to be transferred.Constant filled
     by server.  Possible values include: "StorageAccount", "ManagedDisk".
    :type data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :param share_password: Password for all the shares to be created on the device. Should not be
     passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :type share_password: str
    """

    _validation = {
        'data_account_type': {'required': True},
    }

    _attribute_map = {
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'share_password': {'key': 'sharePassword', 'type': 'str'},
    }

    _subtype_map = {
        'data_account_type': {'ManagedDisk': 'ManagedDiskDetails', 'StorageAccount': 'StorageAccountDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataAccountDetails, self).__init__(**kwargs)
        self.data_account_type = None  # type: Optional[str]
        self.share_password = kwargs.get('share_password', None)


class DataBoxAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account of a DataBox job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar account_name: Account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: str
    :ivar copy_verbose_log_link: Link for copy verbose logs. This will be set only when
     LogCollectionLevel is set to Verbose.
    :vartype copy_verbose_log_link: str
    """

    _validation = {
        'copy_log_details_type': {'required': True},
        'account_name': {'readonly': True},
        'copy_log_link': {'readonly': True},
        'copy_verbose_log_link': {'readonly': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'copy_log_link': {'key': 'copyLogLink', 'type': 'str'},
        'copy_verbose_log_link': {'key': 'copyVerboseLogLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxAccountCopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = 'DataBox'  # type: str
        self.account_name = None
        self.copy_log_link = None
        self.copy_verbose_log_link = None


class DataBoxDiskCopyLogDetails(CopyLogDetails):
    """Copy Log Details for a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar disk_serial_number: Disk Serial Number.
    :vartype disk_serial_number: str
    :ivar error_log_link: Link for copy error logs.
    :vartype error_log_link: str
    :ivar verbose_log_link: Link for copy verbose logs.
    :vartype verbose_log_link: str
    """

    _validation = {
        'copy_log_details_type': {'required': True},
        'disk_serial_number': {'readonly': True},
        'error_log_link': {'readonly': True},
        'verbose_log_link': {'readonly': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
        'disk_serial_number': {'key': 'diskSerialNumber', 'type': 'str'},
        'error_log_link': {'key': 'errorLogLink', 'type': 'str'},
        'verbose_log_link': {'key': 'verboseLogLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxDiskCopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = 'DataBoxDisk'  # type: str
        self.disk_serial_number = None
        self.error_log_link = None
        self.verbose_log_link = None


class DataBoxDiskCopyProgress(msrest.serialization.Model):
    """DataBox Disk Copy Progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar serial_number: The serial number of the disk.
    :vartype serial_number: str
    :ivar bytes_copied: Bytes copied during the copy of disk.
    :vartype bytes_copied: long
    :ivar percent_complete: Indicates the percentage completed for the copy of the disk.
    :vartype percent_complete: int
    :ivar status: The Status of the copy. Possible values include: "NotStarted", "InProgress",
     "Completed", "CompletedWithErrors", "Failed", "NotReturned", "HardwareError",
     "DeviceFormatted", "DeviceMetadataModified", "StorageAccountNotAccessible", "UnsupportedData".
    :vartype status: str or ~azure.mgmt.databox.models.CopyStatus
    """

    _validation = {
        'serial_number': {'readonly': True},
        'bytes_copied': {'readonly': True},
        'percent_complete': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'bytes_copied': {'key': 'bytesCopied', 'type': 'long'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxDiskCopyProgress, self).__init__(**kwargs)
        self.serial_number = None
        self.bytes_copied = None
        self.percent_complete = None
        self.status = None


class JobDetails(msrest.serialization.Model):
    """Job details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataBoxJobDetails, DataBoxDiskJobDetails, DataBoxHeavyJobDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param data_import_details: Details of the data to be imported into azure.
    :type data_import_details: list[~azure.mgmt.databox.models.DataImportDetails]
    :param data_export_details: Details of the data to be exported from azure.
    :type data_export_details: list[~azure.mgmt.databox.models.DataExportDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.models.KeyEncryptionKey
    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'key_encryption_key': {'readonly': True},
    }

    _attribute_map = {
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'data_import_details': {'key': 'dataImportDetails', 'type': '[DataImportDetails]'},
        'data_export_details': {'key': 'dataExportDetails', 'type': '[DataExportDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyEncryptionKey'},
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
    }

    _subtype_map = {
        'job_details_type': {'DataBox': 'DataBoxJobDetails', 'DataBoxDisk': 'DataBoxDiskJobDetails', 'DataBoxHeavy': 'DataBoxHeavyJobDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobDetails, self).__init__(**kwargs)
        self.job_stages = None
        self.contact_details = kwargs['contact_details']
        self.shipping_address = kwargs.get('shipping_address', None)
        self.delivery_package = None
        self.return_package = None
        self.data_import_details = kwargs.get('data_import_details', None)
        self.data_export_details = kwargs.get('data_export_details', None)
        self.job_details_type = None  # type: Optional[str]
        self.preferences = kwargs.get('preferences', None)
        self.copy_log_details = None
        self.reverse_shipment_label_sas_key = None
        self.chain_of_custody_sas_key = None
        self.key_encryption_key = None
        self.expected_data_size_in_terabytes = kwargs.get('expected_data_size_in_terabytes', None)


class DataBoxDiskJobDetails(JobDetails):
    """DataBox Disk Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param data_import_details: Details of the data to be imported into azure.
    :type data_import_details: list[~azure.mgmt.databox.models.DataImportDetails]
    :param data_export_details: Details of the data to be exported from azure.
    :type data_export_details: list[~azure.mgmt.databox.models.DataExportDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.models.KeyEncryptionKey
    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :param preferred_disks: User preference on what size disks are needed for the job. The map is
     from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but
     will be checked against an int.
    :type preferred_disks: dict[str, int]
    :ivar copy_progress: Copy progress per disk.
    :vartype copy_progress: list[~azure.mgmt.databox.models.DataBoxDiskCopyProgress]
    :ivar disks_and_size_details: Contains the map of disk serial number to the disk size being
     used for the job. Is returned only after the disks are shipped to the customer.
    :vartype disks_and_size_details: dict[str, int]
    :param passkey: User entered passkey for DataBox Disk job.
    :type passkey: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'key_encryption_key': {'readonly': True},
        'copy_progress': {'readonly': True},
        'disks_and_size_details': {'readonly': True},
    }

    _attribute_map = {
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'data_import_details': {'key': 'dataImportDetails', 'type': '[DataImportDetails]'},
        'data_export_details': {'key': 'dataExportDetails', 'type': '[DataExportDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyEncryptionKey'},
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'preferred_disks': {'key': 'preferredDisks', 'type': '{int}'},
        'copy_progress': {'key': 'copyProgress', 'type': '[DataBoxDiskCopyProgress]'},
        'disks_and_size_details': {'key': 'disksAndSizeDetails', 'type': '{int}'},
        'passkey': {'key': 'passkey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxDiskJobDetails, self).__init__(**kwargs)
        self.job_details_type = 'DataBoxDisk'  # type: str
        self.preferred_disks = kwargs.get('preferred_disks', None)
        self.copy_progress = None
        self.disks_and_size_details = None
        self.passkey = kwargs.get('passkey', None)


class JobSecrets(msrest.serialization.Model):
    """The base class for the secrets.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataboxJobSecrets, DataBoxDiskJobSecrets, DataBoxHeavyJobSecrets.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    """

    _validation = {
        'job_secrets_type': {'required': True},
        'dc_access_security_code': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'error': {'key': 'error', 'type': 'CloudError'},
    }

    _subtype_map = {
        'job_secrets_type': {'DataBox': 'DataboxJobSecrets', 'DataBoxDisk': 'DataBoxDiskJobSecrets', 'DataBoxHeavy': 'DataBoxHeavyJobSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobSecrets, self).__init__(**kwargs)
        self.job_secrets_type = None  # type: Optional[str]
        self.dc_access_security_code = None
        self.error = None


class DataBoxDiskJobSecrets(JobSecrets):
    """The secrets related to disk job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar disk_secrets: Contains the list of secrets object for that device.
    :vartype disk_secrets: list[~azure.mgmt.databox.models.DiskSecret]
    :ivar pass_key: PassKey for the disk Job.
    :vartype pass_key: str
    :ivar is_passkey_user_defined: Whether passkey was provided by user.
    :vartype is_passkey_user_defined: bool
    """

    _validation = {
        'job_secrets_type': {'required': True},
        'dc_access_security_code': {'readonly': True},
        'error': {'readonly': True},
        'disk_secrets': {'readonly': True},
        'pass_key': {'readonly': True},
        'is_passkey_user_defined': {'readonly': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'disk_secrets': {'key': 'diskSecrets', 'type': '[DiskSecret]'},
        'pass_key': {'key': 'passKey', 'type': 'str'},
        'is_passkey_user_defined': {'key': 'isPasskeyUserDefined', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxDiskJobSecrets, self).__init__(**kwargs)
        self.job_secrets_type = 'DataBoxDisk'  # type: str
        self.disk_secrets = None
        self.pass_key = None
        self.is_passkey_user_defined = None


class DataBoxHeavyAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account for Databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar account_name: Account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: list[str]
    :ivar copy_verbose_log_link: Link for copy verbose logs. This will be set only when the
     LogCollectionLevel is set to verbose.
    :vartype copy_verbose_log_link: list[str]
    """

    _validation = {
        'copy_log_details_type': {'required': True},
        'account_name': {'readonly': True},
        'copy_log_link': {'readonly': True},
        'copy_verbose_log_link': {'readonly': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'copy_log_link': {'key': 'copyLogLink', 'type': '[str]'},
        'copy_verbose_log_link': {'key': 'copyVerboseLogLink', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxHeavyAccountCopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = 'DataBoxHeavy'  # type: str
        self.account_name = None
        self.copy_log_link = None
        self.copy_verbose_log_link = None


class DataBoxHeavyJobDetails(JobDetails):
    """Databox Heavy Device Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param data_import_details: Details of the data to be imported into azure.
    :type data_import_details: list[~azure.mgmt.databox.models.DataImportDetails]
    :param data_export_details: Details of the data to be exported from azure.
    :type data_export_details: list[~azure.mgmt.databox.models.DataExportDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.models.KeyEncryptionKey
    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :ivar copy_progress: Copy progress per account.
    :vartype copy_progress: list[~azure.mgmt.databox.models.CopyProgress]
    :param device_password: Set Device password for unlocking Databox Heavy. Should not be passed
     for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :type device_password: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'key_encryption_key': {'readonly': True},
        'copy_progress': {'readonly': True},
    }

    _attribute_map = {
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'data_import_details': {'key': 'dataImportDetails', 'type': '[DataImportDetails]'},
        'data_export_details': {'key': 'dataExportDetails', 'type': '[DataExportDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyEncryptionKey'},
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'copy_progress': {'key': 'copyProgress', 'type': '[CopyProgress]'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxHeavyJobDetails, self).__init__(**kwargs)
        self.job_details_type = 'DataBoxHeavy'  # type: str
        self.copy_progress = None
        self.device_password = kwargs.get('device_password', None)


class DataBoxHeavyJobSecrets(JobSecrets):
    """The secrets related to a databox heavy job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar cabinet_pod_secrets: Contains the list of secret objects for a databox heavy job.
    :vartype cabinet_pod_secrets: list[~azure.mgmt.databox.models.DataBoxHeavySecret]
    """

    _validation = {
        'job_secrets_type': {'required': True},
        'dc_access_security_code': {'readonly': True},
        'error': {'readonly': True},
        'cabinet_pod_secrets': {'readonly': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'cabinet_pod_secrets': {'key': 'cabinetPodSecrets', 'type': '[DataBoxHeavySecret]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxHeavyJobSecrets, self).__init__(**kwargs)
        self.job_secrets_type = 'DataBoxHeavy'  # type: str
        self.cabinet_pod_secrets = None


class DataBoxHeavySecret(msrest.serialization.Model):
    """The secrets related to a databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations: list[~azure.mgmt.databox.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details: list[~azure.mgmt.databox.models.AccountCredentialDetails]
    """

    _validation = {
        'device_serial_number': {'readonly': True},
        'device_password': {'readonly': True},
        'network_configurations': {'readonly': True},
        'encoded_validation_cert_pub_key': {'readonly': True},
        'account_credential_details': {'readonly': True},
    }

    _attribute_map = {
        'device_serial_number': {'key': 'deviceSerialNumber', 'type': 'str'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
        'network_configurations': {'key': 'networkConfigurations', 'type': '[ApplianceNetworkConfiguration]'},
        'encoded_validation_cert_pub_key': {'key': 'encodedValidationCertPubKey', 'type': 'str'},
        'account_credential_details': {'key': 'accountCredentialDetails', 'type': '[AccountCredentialDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxHeavySecret, self).__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataBoxJobDetails(JobDetails):
    """Databox Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param data_import_details: Details of the data to be imported into azure.
    :type data_import_details: list[~azure.mgmt.databox.models.DataImportDetails]
    :param data_export_details: Details of the data to be exported from azure.
    :type data_export_details: list[~azure.mgmt.databox.models.DataExportDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.models.KeyEncryptionKey
    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :ivar copy_progress: Copy progress per storage account.
    :vartype copy_progress: list[~azure.mgmt.databox.models.CopyProgress]
    :param device_password: Set Device password for unlocking Databox. Should not be passed for
     TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password
     itself. This will not be returned in Get Call. Password Requirements :  Password must be
     minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet,
     one number and one special character. Password cannot have the following characters : IilLoO0
     Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :type device_password: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'key_encryption_key': {'readonly': True},
        'copy_progress': {'readonly': True},
    }

    _attribute_map = {
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'data_import_details': {'key': 'dataImportDetails', 'type': '[DataImportDetails]'},
        'data_export_details': {'key': 'dataExportDetails', 'type': '[DataExportDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyEncryptionKey'},
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'copy_progress': {'key': 'copyProgress', 'type': '[CopyProgress]'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxJobDetails, self).__init__(**kwargs)
        self.job_details_type = 'DataBox'  # type: str
        self.copy_progress = None
        self.device_password = kwargs.get('device_password', None)


class DataboxJobSecrets(JobSecrets):
    """The secrets related to a databox job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :param pod_secrets: Contains the list of secret objects for a job.
    :type pod_secrets: list[~azure.mgmt.databox.models.DataBoxSecret]
    """

    _validation = {
        'job_secrets_type': {'required': True},
        'dc_access_security_code': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'pod_secrets': {'key': 'podSecrets', 'type': '[DataBoxSecret]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataboxJobSecrets, self).__init__(**kwargs)
        self.job_secrets_type = 'DataBox'  # type: str
        self.pod_secrets = kwargs.get('pod_secrets', None)


class ScheduleAvailabilityRequest(msrest.serialization.Model):
    """Request body to get the availability for scheduling orders.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataBoxScheduleAvailabilityRequest, DiskScheduleAvailabilityRequest, HeavyScheduleAvailabilityRequest.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    :param country: Country in which storage location should be supported.
    :type country: str
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
    }

    _subtype_map = {
        'sku_name': {'DataBox': 'DataBoxScheduleAvailabilityRequest', 'DataBoxDisk': 'DiskScheduleAvailabilityRequest', 'DataBoxHeavy': 'HeavyScheduleAvailabilityRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduleAvailabilityRequest, self).__init__(**kwargs)
        self.storage_location = kwargs['storage_location']
        self.sku_name = None  # type: Optional[str]
        self.country = kwargs.get('country', None)


class DataBoxScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling data box orders orders.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    :param country: Country in which storage location should be supported.
    :type country: str
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxScheduleAvailabilityRequest, self).__init__(**kwargs)
        self.sku_name = 'DataBox'  # type: str


class DataBoxSecret(msrest.serialization.Model):
    """The secrets related to a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations: list[~azure.mgmt.databox.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details: list[~azure.mgmt.databox.models.AccountCredentialDetails]
    """

    _validation = {
        'device_serial_number': {'readonly': True},
        'device_password': {'readonly': True},
        'network_configurations': {'readonly': True},
        'encoded_validation_cert_pub_key': {'readonly': True},
        'account_credential_details': {'readonly': True},
    }

    _attribute_map = {
        'device_serial_number': {'key': 'deviceSerialNumber', 'type': 'str'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
        'network_configurations': {'key': 'networkConfigurations', 'type': '[ApplianceNetworkConfiguration]'},
        'encoded_validation_cert_pub_key': {'key': 'encodedValidationCertPubKey', 'type': 'str'},
        'account_credential_details': {'key': 'accountCredentialDetails', 'type': '[AccountCredentialDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxSecret, self).__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataExportDetails(msrest.serialization.Model):
    """Details of the data to be used for exporting data from azure.

    All required parameters must be populated in order to send to Azure.

    :param transfer_configuration: Required. Configuration for the data transfer.
    :type transfer_configuration: ~azure.mgmt.databox.models.TransferConfiguration
    :param log_collection_level: Level of the logs to be collected. Possible values include:
     "Error", "Verbose".
    :type log_collection_level: str or ~azure.mgmt.databox.models.LogCollectionLevel
    :param account_details: Required. Account details of the data to be transferred.
    :type account_details: ~azure.mgmt.databox.models.DataAccountDetails
    """

    _validation = {
        'transfer_configuration': {'required': True},
        'account_details': {'required': True},
    }

    _attribute_map = {
        'transfer_configuration': {'key': 'transferConfiguration', 'type': 'TransferConfiguration'},
        'log_collection_level': {'key': 'logCollectionLevel', 'type': 'str'},
        'account_details': {'key': 'accountDetails', 'type': 'DataAccountDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataExportDetails, self).__init__(**kwargs)
        self.transfer_configuration = kwargs['transfer_configuration']
        self.log_collection_level = kwargs.get('log_collection_level', None)
        self.account_details = kwargs['account_details']


class DataImportDetails(msrest.serialization.Model):
    """Details of the data to be used for importing data to azure.

    All required parameters must be populated in order to send to Azure.

    :param account_details: Required. Account details of the data to be transferred.
    :type account_details: ~azure.mgmt.databox.models.DataAccountDetails
    """

    _validation = {
        'account_details': {'required': True},
    }

    _attribute_map = {
        'account_details': {'key': 'accountDetails', 'type': 'DataAccountDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataImportDetails, self).__init__(**kwargs)
        self.account_details = kwargs['account_details']


class DataLocationToServiceLocationMap(msrest.serialization.Model):
    """Map of data location to service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_location: Location of the data.
    :vartype data_location: str
    :ivar service_location: Location of the service.
    :vartype service_location: str
    """

    _validation = {
        'data_location': {'readonly': True},
        'service_location': {'readonly': True},
    }

    _attribute_map = {
        'data_location': {'key': 'dataLocation', 'type': 'str'},
        'service_location': {'key': 'serviceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLocationToServiceLocationMap, self).__init__(**kwargs)
        self.data_location = None
        self.service_location = None


class DataTransferDetailsValidationRequest(ValidationInputRequest):
    """Request to validate export and import data details.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param data_export_details: List of DataTransfer details to be used to export data from azure.
    :type data_export_details: list[~azure.mgmt.databox.models.DataExportDetails]
    :param data_import_details: List of DataTransfer details to be used to import data to azure.
    :type data_import_details: list[~azure.mgmt.databox.models.DataImportDetails]
    :param device_type: Required. Device type. Possible values include: "DataBox", "DataBoxDisk",
     "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    :param transfer_type: Required. Type of the transfer. Possible values include: "ImportToAzure",
     "ExportFromAzure".
    :type transfer_type: str or ~azure.mgmt.databox.models.TransferType
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
        'transfer_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'data_export_details': {'key': 'dataExportDetails', 'type': '[DataExportDetails]'},
        'data_import_details': {'key': 'dataImportDetails', 'type': '[DataImportDetails]'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'transfer_type': {'key': 'transferType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataTransferDetailsValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateDataTransferDetails'  # type: str
        self.data_export_details = kwargs.get('data_export_details', None)
        self.data_import_details = kwargs.get('data_import_details', None)
        self.device_type = kwargs['device_type']
        self.transfer_type = kwargs['transfer_type']


class DataTransferDetailsValidationResponseProperties(ValidationInputResponse):
    """Properties of data transfer details validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar status: Data transfer details validation status. Possible values include: "Valid",
     "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataTransferDetailsValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateDataTransferDetails'  # type: str
        self.status = None


class DcAccessSecurityCode(msrest.serialization.Model):
    """Dc access security code.

    :param reverse_dc_access_code: Reverse Dc access security code.
    :type reverse_dc_access_code: str
    :param forward_dc_access_code: Forward Dc access security code.
    :type forward_dc_access_code: str
    """

    _attribute_map = {
        'reverse_dc_access_code': {'key': 'reverseDcAccessCode', 'type': 'str'},
        'forward_dc_access_code': {'key': 'forwardDcAccessCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DcAccessSecurityCode, self).__init__(**kwargs)
        self.reverse_dc_access_code = kwargs.get('reverse_dc_access_code', None)
        self.forward_dc_access_code = kwargs.get('forward_dc_access_code', None)


class Details(msrest.serialization.Model):
    """Details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required.
    :type code: str
    :param message: Required.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Details, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']


class DiskScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling disk orders.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    :param country: Country in which storage location should be supported.
    :type country: str
    :param expected_data_size_in_terabytes: Required. The expected size of the data, which needs to
     be transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
        'expected_data_size_in_terabytes': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskScheduleAvailabilityRequest, self).__init__(**kwargs)
        self.sku_name = 'DataBoxDisk'  # type: str
        self.expected_data_size_in_terabytes = kwargs['expected_data_size_in_terabytes']


class DiskSecret(msrest.serialization.Model):
    """Contains all the secrets of a Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_serial_number: Serial number of the assigned disk.
    :vartype disk_serial_number: str
    :ivar bit_locker_key: Bit Locker key of the disk which can be used to unlock the disk to copy
     data.
    :vartype bit_locker_key: str
    """

    _validation = {
        'disk_serial_number': {'readonly': True},
        'bit_locker_key': {'readonly': True},
    }

    _attribute_map = {
        'disk_serial_number': {'key': 'diskSerialNumber', 'type': 'str'},
        'bit_locker_key': {'key': 'bitLockerKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskSecret, self).__init__(**kwargs)
        self.disk_serial_number = None
        self.bit_locker_key = None


class ErrorDetail(msrest.serialization.Model):
    """ErrorDetail.

    All required parameters must be populated in order to send to Azure.

    :param code: Required.
    :type code: str
    :param message: Required.
    :type message: str
    :param details:
    :type details: list[~azure.mgmt.databox.models.Details]
    :param target:
    :type target: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Details]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.details = kwargs.get('details', None)
        self.target = kwargs.get('target', None)


class FilterFileDetails(msrest.serialization.Model):
    """Details of the filter files to be used for data transfer.

    All required parameters must be populated in order to send to Azure.

    :param filter_file_type: Required. Type of the filter file. Possible values include:
     "AzureBlob", "AzureFile".
    :type filter_file_type: str or ~azure.mgmt.databox.models.FilterFileType
    :param filter_file_path: Required. Path of the file that contains the details of all items to
     transfer.
    :type filter_file_path: str
    """

    _validation = {
        'filter_file_type': {'required': True},
        'filter_file_path': {'required': True},
    }

    _attribute_map = {
        'filter_file_type': {'key': 'filterFileType', 'type': 'str'},
        'filter_file_path': {'key': 'filterFilePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FilterFileDetails, self).__init__(**kwargs)
        self.filter_file_type = kwargs['filter_file_type']
        self.filter_file_path = kwargs['filter_file_path']


class HeavyScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling heavy orders.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    :param country: Country in which storage location should be supported.
    :type country: str
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HeavyScheduleAvailabilityRequest, self).__init__(**kwargs)
        self.sku_name = 'DataBoxHeavy'  # type: str


class JobDeliveryInfo(msrest.serialization.Model):
    """Additional delivery info.

    :param scheduled_date_time: Scheduled date time.
    :type scheduled_date_time: ~datetime.datetime
    """

    _attribute_map = {
        'scheduled_date_time': {'key': 'scheduledDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobDeliveryInfo, self).__init__(**kwargs)
        self.scheduled_date_time = kwargs.get('scheduled_date_time', None)


class Resource(msrest.serialization.Model):
    """Model of the Resource.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource. This will be one of the supported and
     registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
     resource cannot be changed once it is created, but if an identical region is specified on
     update the request will succeed.
    :type location: str
    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param sku: Required. The sku type.
    :type sku: ~azure.mgmt.databox.models.Sku
    :param identity: Msi identity of the resource.
    :type identity: ~azure.mgmt.databox.models.ResourceIdentity
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs['sku']
        self.identity = kwargs.get('identity', None)


class JobResource(Resource):
    """Job Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource. This will be one of the supported and
     registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
     resource cannot be changed once it is created, but if an identical region is specified on
     update the request will succeed.
    :type location: str
    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param sku: Required. The sku type.
    :type sku: ~azure.mgmt.databox.models.Sku
    :param identity: Msi identity of the resource.
    :type identity: ~azure.mgmt.databox.models.ResourceIdentity
    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    :param transfer_type: Required. Type of the data transfer. Possible values include:
     "ImportToAzure", "ExportFromAzure".
    :type transfer_type: str or ~azure.mgmt.databox.models.TransferType
    :ivar is_cancellable: Describes whether the job is cancellable or not.
    :vartype is_cancellable: bool
    :ivar is_deletable: Describes whether the job is deletable or not.
    :vartype is_deletable: bool
    :ivar is_shipping_address_editable: Describes whether the shipping address is editable or not.
    :vartype is_shipping_address_editable: bool
    :ivar is_prepare_to_ship_enabled: Is Prepare To Ship Enabled on this job.
    :vartype is_prepare_to_ship_enabled: bool
    :ivar status: Name of the stage which is in progress. Possible values include: "DeviceOrdered",
     "DevicePrepared", "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", "ReadyToReceiveAtAzureDC".
    :vartype status: str or ~azure.mgmt.databox.models.StageName
    :ivar start_time: Time at which the job was started in UTC ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar error: Top level error for the job.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :param details: Details of a job run. This field will only be sent for expand details filter.
    :type details: ~azure.mgmt.databox.models.JobDetails
    :ivar cancellation_reason: Reason for cancellation.
    :vartype cancellation_reason: str
    :param delivery_type: Delivery type of Job. Possible values include: "NonScheduled",
     "Scheduled".
    :type delivery_type: str or ~azure.mgmt.databox.models.JobDeliveryType
    :param delivery_info: Delivery Info of Job.
    :type delivery_info: ~azure.mgmt.databox.models.JobDeliveryInfo
    :ivar is_cancellable_without_fee: Flag to indicate cancellation of scheduled job.
    :vartype is_cancellable_without_fee: bool
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'transfer_type': {'required': True},
        'is_cancellable': {'readonly': True},
        'is_deletable': {'readonly': True},
        'is_shipping_address_editable': {'readonly': True},
        'is_prepare_to_ship_enabled': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'error': {'readonly': True},
        'cancellation_reason': {'readonly': True},
        'is_cancellable_without_fee': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'transfer_type': {'key': 'properties.transferType', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
        'is_deletable': {'key': 'properties.isDeletable', 'type': 'bool'},
        'is_shipping_address_editable': {'key': 'properties.isShippingAddressEditable', 'type': 'bool'},
        'is_prepare_to_ship_enabled': {'key': 'properties.isPrepareToShipEnabled', 'type': 'bool'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'error': {'key': 'properties.error', 'type': 'CloudError'},
        'details': {'key': 'properties.details', 'type': 'JobDetails'},
        'cancellation_reason': {'key': 'properties.cancellationReason', 'type': 'str'},
        'delivery_type': {'key': 'properties.deliveryType', 'type': 'str'},
        'delivery_info': {'key': 'properties.deliveryInfo', 'type': 'JobDeliveryInfo'},
        'is_cancellable_without_fee': {'key': 'properties.isCancellableWithoutFee', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResource, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.transfer_type = kwargs['transfer_type']
        self.is_cancellable = None
        self.is_deletable = None
        self.is_shipping_address_editable = None
        self.is_prepare_to_ship_enabled = None
        self.status = None
        self.start_time = None
        self.error = None
        self.details = kwargs.get('details', None)
        self.cancellation_reason = None
        self.delivery_type = kwargs.get('delivery_type', None)
        self.delivery_info = kwargs.get('delivery_info', None)
        self.is_cancellable_without_fee = None


class JobResourceList(msrest.serialization.Model):
    """Job Resource Collection.

    :param value: List of job resources.
    :type value: list[~azure.mgmt.databox.models.JobResource]
    :param next_link: Link for the next set of job resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class JobResourceUpdateParameter(msrest.serialization.Model):
    """The JobResourceUpdateParameter.

    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param identity: Msi identity of the resource.
    :type identity: ~azure.mgmt.databox.models.ResourceIdentity
    :param details: Details of a job to be updated.
    :type details: ~azure.mgmt.databox.models.UpdateJobDetails
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'details': {'key': 'properties.details', 'type': 'UpdateJobDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResourceUpdateParameter, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.details = kwargs.get('details', None)


class JobStages(msrest.serialization.Model):
    """Job stages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar stage_name: Name of the job stage. Possible values include: "DeviceOrdered",
     "DevicePrepared", "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", "ReadyToReceiveAtAzureDC".
    :vartype stage_name: str or ~azure.mgmt.databox.models.StageName
    :ivar display_name: Display name of the job stage.
    :vartype display_name: str
    :ivar stage_status: Status of the job stage. Possible values include: "None", "InProgress",
     "Succeeded", "Failed", "Cancelled", "Cancelling", "SucceededWithErrors",
     "WaitingForCustomerAction", "SucceededWithWarnings".
    :vartype stage_status: str or ~azure.mgmt.databox.models.StageStatus
    :ivar stage_time: Time for the job stage in UTC ISO 8601 format.
    :vartype stage_time: ~datetime.datetime
    :ivar job_stage_details: Job Stage Details.
    :vartype job_stage_details: object
    """

    _validation = {
        'stage_name': {'readonly': True},
        'display_name': {'readonly': True},
        'stage_status': {'readonly': True},
        'stage_time': {'readonly': True},
        'job_stage_details': {'readonly': True},
    }

    _attribute_map = {
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'stage_status': {'key': 'stageStatus', 'type': 'str'},
        'stage_time': {'key': 'stageTime', 'type': 'iso-8601'},
        'job_stage_details': {'key': 'jobStageDetails', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobStages, self).__init__(**kwargs)
        self.stage_name = None
        self.display_name = None
        self.stage_status = None
        self.stage_time = None
        self.job_stage_details = None


class KeyEncryptionKey(msrest.serialization.Model):
    """Encryption key containing details about key to encrypt different keys.

    All required parameters must be populated in order to send to Azure.

    :param kek_type: Required. Type of encryption key used for key encryption. Possible values
     include: "MicrosoftManaged", "CustomerManaged".
    :type kek_type: str or ~azure.mgmt.databox.models.KekType
    :param kek_url: Key encryption key. It is required in case of Customer managed KekType.
    :type kek_url: str
    :param kek_vault_resource_id: Kek vault resource id. It is required in case of Customer managed
     KekType.
    :type kek_vault_resource_id: str
    """

    _validation = {
        'kek_type': {'required': True},
    }

    _attribute_map = {
        'kek_type': {'key': 'kekType', 'type': 'str'},
        'kek_url': {'key': 'kekUrl', 'type': 'str'},
        'kek_vault_resource_id': {'key': 'kekVaultResourceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyEncryptionKey, self).__init__(**kwargs)
        self.kek_type = kwargs['kek_type']
        self.kek_url = kwargs.get('kek_url', None)
        self.kek_vault_resource_id = kwargs.get('kek_vault_resource_id', None)


class ManagedDiskDetails(DataAccountDetails):
    """Details of the managed disks.

    All required parameters must be populated in order to send to Azure.

    :param data_account_type: Required. Account Type of the data to be transferred.Constant filled
     by server.  Possible values include: "StorageAccount", "ManagedDisk".
    :type data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :param share_password: Password for all the shares to be created on the device. Should not be
     passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :type share_password: str
    :param resource_group_id: Required. Resource Group Id of the compute disks.
    :type resource_group_id: str
    :param staging_storage_account_id: Required. Resource Id of the storage account that can be
     used to copy the vhd for staging.
    :type staging_storage_account_id: str
    """

    _validation = {
        'data_account_type': {'required': True},
        'resource_group_id': {'required': True},
        'staging_storage_account_id': {'required': True},
    }

    _attribute_map = {
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'share_password': {'key': 'sharePassword', 'type': 'str'},
        'resource_group_id': {'key': 'resourceGroupId', 'type': 'str'},
        'staging_storage_account_id': {'key': 'stagingStorageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedDiskDetails, self).__init__(**kwargs)
        self.data_account_type = 'ManagedDisk'  # type: str
        self.resource_group_id = kwargs['resource_group_id']
        self.staging_storage_account_id = kwargs['staging_storage_account_id']


class NotificationPreference(msrest.serialization.Model):
    """Notification preference for a job stage.

    All required parameters must be populated in order to send to Azure.

    :param stage_name: Required. Name of the stage. Possible values include: "DevicePrepared",
     "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy".
    :type stage_name: str or ~azure.mgmt.databox.models.NotificationStageName
    :param send_notification: Required. Notification is required or not.
    :type send_notification: bool
    """

    _validation = {
        'stage_name': {'required': True},
        'send_notification': {'required': True},
    }

    _attribute_map = {
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'send_notification': {'key': 'sendNotification', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotificationPreference, self).__init__(**kwargs)
        self.stage_name = kwargs['stage_name']
        self.send_notification = kwargs['send_notification']


class Operation(msrest.serialization.Model):
    """Operation entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation. Format:
     {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}.
    :vartype name: str
    :ivar display: Operation display values.
    :vartype display: ~azure.mgmt.databox.models.OperationDisplay
    :ivar properties: Operation properties.
    :vartype properties: object
    :ivar origin: Origin of the operation. Can be : user|system|user,system.
    :vartype origin: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'properties': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'object'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.properties = None
        self.origin = None
        self.is_data_action = kwargs.get('is_data_action', None)


class OperationDisplay(msrest.serialization.Model):
    """Operation display.

    :param provider: Provider name.
    :type provider: str
    :param resource: Resource name.
    :type resource: str
    :param operation: Localized name of the operation for display purpose.
    :type operation: str
    :param description: Localized description of the operation for display purpose.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationList(msrest.serialization.Model):
    """Operation Collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations.
    :vartype value: list[~azure.mgmt.databox.models.Operation]
    :param next_link: Link for the next set of operations.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class PackageShippingDetails(msrest.serialization.Model):
    """Shipping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking Id of shipment.
    :vartype tracking_id: str
    :ivar tracking_url: Url where shipment can be tracked.
    :vartype tracking_url: str
    """

    _validation = {
        'carrier_name': {'readonly': True},
        'tracking_id': {'readonly': True},
        'tracking_url': {'readonly': True},
    }

    _attribute_map = {
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PackageShippingDetails, self).__init__(**kwargs)
        self.carrier_name = None
        self.tracking_id = None
        self.tracking_url = None


class Preferences(msrest.serialization.Model):
    """Preferences related to the order.

    :param preferred_data_center_region: Preferred data center region.
    :type preferred_data_center_region: list[str]
    :param transport_preferences: Preferences related to the shipment logistics of the sku.
    :type transport_preferences: ~azure.mgmt.databox.models.TransportPreferences
    """

    _attribute_map = {
        'preferred_data_center_region': {'key': 'preferredDataCenterRegion', 'type': '[str]'},
        'transport_preferences': {'key': 'transportPreferences', 'type': 'TransportPreferences'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Preferences, self).__init__(**kwargs)
        self.preferred_data_center_region = kwargs.get('preferred_data_center_region', None)
        self.transport_preferences = kwargs.get('transport_preferences', None)


class PreferencesValidationRequest(ValidationInputRequest):
    """Request to validate preference of transport and data center.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param preference: Preference of transport and data center.
    :type preference: ~azure.mgmt.databox.models.Preferences
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'preference': {'key': 'preference', 'type': 'Preferences'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PreferencesValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidatePreferences'  # type: str
        self.preference = kwargs.get('preference', None)
        self.device_type = kwargs['device_type']


class PreferencesValidationResponseProperties(ValidationInputResponse):
    """Properties of data center and transport preference validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar status: Validation status of requested data center and transport. Possible values
     include: "Valid", "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PreferencesValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidatePreferences'  # type: str
        self.status = None


class RegionConfigurationRequest(msrest.serialization.Model):
    """Request body to get the configuration for the region.

    :param schedule_availability_request: Request body to get the availability for scheduling
     orders.
    :type schedule_availability_request: ~azure.mgmt.databox.models.ScheduleAvailabilityRequest
    :param transport_availability_request: Request body to get the transport availability for given
     sku.
    :type transport_availability_request: ~azure.mgmt.databox.models.TransportAvailabilityRequest
    """

    _attribute_map = {
        'schedule_availability_request': {'key': 'scheduleAvailabilityRequest', 'type': 'ScheduleAvailabilityRequest'},
        'transport_availability_request': {'key': 'transportAvailabilityRequest', 'type': 'TransportAvailabilityRequest'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionConfigurationRequest, self).__init__(**kwargs)
        self.schedule_availability_request = kwargs.get('schedule_availability_request', None)
        self.transport_availability_request = kwargs.get('transport_availability_request', None)


class RegionConfigurationResponse(msrest.serialization.Model):
    """Configuration response specific to a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schedule_availability_response: Schedule availability for given sku in a region.
    :vartype schedule_availability_response:
     ~azure.mgmt.databox.models.ScheduleAvailabilityResponse
    :ivar transport_availability_response: Transport options available for given sku in a region.
    :vartype transport_availability_response:
     ~azure.mgmt.databox.models.TransportAvailabilityResponse
    """

    _validation = {
        'schedule_availability_response': {'readonly': True},
        'transport_availability_response': {'readonly': True},
    }

    _attribute_map = {
        'schedule_availability_response': {'key': 'scheduleAvailabilityResponse', 'type': 'ScheduleAvailabilityResponse'},
        'transport_availability_response': {'key': 'transportAvailabilityResponse', 'type': 'TransportAvailabilityResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionConfigurationResponse, self).__init__(**kwargs)
        self.schedule_availability_response = None
        self.transport_availability_response = None


class ResourceIdentity(msrest.serialization.Model):
    """Msi identity details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Identity type.
    :type type: str
    :ivar principal_id: Service Principal Id backing the Msi.
    :vartype principal_id: str
    :ivar tenant_id: Home Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = None
        self.tenant_id = None


class ScheduleAvailabilityResponse(msrest.serialization.Model):
    """Schedule availability for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar available_dates: List of dates available to schedule.
    :vartype available_dates: list[~datetime.datetime]
    """

    _validation = {
        'available_dates': {'readonly': True},
    }

    _attribute_map = {
        'available_dates': {'key': 'availableDates', 'type': '[iso-8601]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduleAvailabilityResponse, self).__init__(**kwargs)
        self.available_dates = None


class ShareCredentialDetails(msrest.serialization.Model):
    """Credential details of the shares in account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar share_name: Name of the share.
    :vartype share_name: str
    :ivar share_type: Type of the share. Possible values include: "UnknownType", "HCS",
     "BlockBlob", "PageBlob", "AzureFile", "ManagedDisk".
    :vartype share_type: str or ~azure.mgmt.databox.models.ShareDestinationFormatType
    :ivar user_name: User name for the share.
    :vartype user_name: str
    :ivar password: Password for the share.
    :vartype password: str
    :ivar supported_access_protocols: Access protocols supported on the device.
    :vartype supported_access_protocols: list[str or ~azure.mgmt.databox.models.AccessProtocol]
    """

    _validation = {
        'share_name': {'readonly': True},
        'share_type': {'readonly': True},
        'user_name': {'readonly': True},
        'password': {'readonly': True},
        'supported_access_protocols': {'readonly': True},
    }

    _attribute_map = {
        'share_name': {'key': 'shareName', 'type': 'str'},
        'share_type': {'key': 'shareType', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'supported_access_protocols': {'key': 'supportedAccessProtocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShareCredentialDetails, self).__init__(**kwargs)
        self.share_name = None
        self.share_type = None
        self.user_name = None
        self.password = None
        self.supported_access_protocols = None


class ShipmentPickUpRequest(msrest.serialization.Model):
    """Shipment pick up request details.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. Minimum date after which the pick up should commence, this must be
     in local time of pick up area.
    :type start_time: ~datetime.datetime
    :param end_time: Required. Maximum date before which the pick up should commence, this must be
     in local time of pick up area.
    :type end_time: ~datetime.datetime
    :param shipment_location: Required. Shipment Location in the pickup place. Eg.front desk.
    :type shipment_location: str
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'shipment_location': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'shipment_location': {'key': 'shipmentLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShipmentPickUpRequest, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.shipment_location = kwargs['shipment_location']


class ShipmentPickUpResponse(msrest.serialization.Model):
    """Shipment pick up response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confirmation_number: Confirmation number for the pick up request.
    :vartype confirmation_number: str
    :ivar ready_by_time: Time by which shipment should be ready for pick up, this is in local time
     of pick up area.
    :vartype ready_by_time: ~datetime.datetime
    """

    _validation = {
        'confirmation_number': {'readonly': True},
        'ready_by_time': {'readonly': True},
    }

    _attribute_map = {
        'confirmation_number': {'key': 'confirmationNumber', 'type': 'str'},
        'ready_by_time': {'key': 'readyByTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShipmentPickUpResponse, self).__init__(**kwargs)
        self.confirmation_number = None
        self.ready_by_time = None


class ShippingAddress(msrest.serialization.Model):
    """Shipping address where customer wishes to receive the device.

    All required parameters must be populated in order to send to Azure.

    :param street_address1: Required. Street Address line 1.
    :type street_address1: str
    :param street_address2: Street Address line 2.
    :type street_address2: str
    :param street_address3: Street Address line 3.
    :type street_address3: str
    :param city: Name of the City.
    :type city: str
    :param state_or_province: Name of the State or Province.
    :type state_or_province: str
    :param country: Required. Name of the Country.
    :type country: str
    :param postal_code: Required. Postal code.
    :type postal_code: str
    :param zip_extended_code: Extended Zip Code.
    :type zip_extended_code: str
    :param company_name: Name of the company.
    :type company_name: str
    :param address_type: Type of address. Possible values include: "None", "Residential",
     "Commercial".
    :type address_type: str or ~azure.mgmt.databox.models.AddressType
    """

    _validation = {
        'street_address1': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
    }

    _attribute_map = {
        'street_address1': {'key': 'streetAddress1', 'type': 'str'},
        'street_address2': {'key': 'streetAddress2', 'type': 'str'},
        'street_address3': {'key': 'streetAddress3', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state_or_province': {'key': 'stateOrProvince', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'zip_extended_code': {'key': 'zipExtendedCode', 'type': 'str'},
        'company_name': {'key': 'companyName', 'type': 'str'},
        'address_type': {'key': 'addressType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShippingAddress, self).__init__(**kwargs)
        self.street_address1 = kwargs['street_address1']
        self.street_address2 = kwargs.get('street_address2', None)
        self.street_address3 = kwargs.get('street_address3', None)
        self.city = kwargs.get('city', None)
        self.state_or_province = kwargs.get('state_or_province', None)
        self.country = kwargs['country']
        self.postal_code = kwargs['postal_code']
        self.zip_extended_code = kwargs.get('zip_extended_code', None)
        self.company_name = kwargs.get('company_name', None)
        self.address_type = kwargs.get('address_type', None)


class Sku(msrest.serialization.Model):
    """The Sku.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The sku name. Possible values include: "DataBox", "DataBoxDisk",
     "DataBoxHeavy".
    :type name: str or ~azure.mgmt.databox.models.SkuName
    :param display_name: The display name of the sku.
    :type display_name: str
    :param family: The sku family.
    :type family: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.display_name = kwargs.get('display_name', None)
        self.family = kwargs.get('family', None)


class SkuAvailabilityValidationRequest(ValidationInputRequest):
    """Request to validate sku availability.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    :param transfer_type: Required. Type of the transfer. Possible values include: "ImportToAzure",
     "ExportFromAzure".
    :type transfer_type: str or ~azure.mgmt.databox.models.TransferType
    :param country: Required. ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements.
    :type country: str
    :param location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type location: str
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
        'transfer_type': {'required': True},
        'country': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'transfer_type': {'key': 'transferType', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuAvailabilityValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateSkuAvailability'  # type: str
        self.device_type = kwargs['device_type']
        self.transfer_type = kwargs['transfer_type']
        self.country = kwargs['country']
        self.location = kwargs['location']


class SkuAvailabilityValidationResponseProperties(ValidationInputResponse):
    """Properties of sku availability validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar status: Sku availability validation status. Possible values include: "Valid", "Invalid",
     "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuAvailabilityValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateSkuAvailability'  # type: str
        self.status = None


class SkuCapacity(msrest.serialization.Model):
    """Capacity of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar usable: Usable capacity in TB.
    :vartype usable: str
    :ivar maximum: Maximum capacity in TB.
    :vartype maximum: str
    """

    _validation = {
        'usable': {'readonly': True},
        'maximum': {'readonly': True},
    }

    _attribute_map = {
        'usable': {'key': 'usable', 'type': 'str'},
        'maximum': {'key': 'maximum', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapacity, self).__init__(**kwargs)
        self.usable = None
        self.maximum = None


class SkuCost(msrest.serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Meter id of the Sku.
    :vartype meter_id: str
    :ivar meter_type: The type of the meter.
    :vartype meter_type: str
    :ivar multiplier: Multiplier specifies the region specific value to be multiplied with 1$ guid.
     Eg: Our new regions will be using 1$ shipping guid with appropriate multiplier specific to
     region.
    :vartype multiplier: float
    """

    _validation = {
        'meter_id': {'readonly': True},
        'meter_type': {'readonly': True},
        'multiplier': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterId', 'type': 'str'},
        'meter_type': {'key': 'meterType', 'type': 'str'},
        'multiplier': {'key': 'multiplier', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCost, self).__init__(**kwargs)
        self.meter_id = None
        self.meter_type = None
        self.multiplier = None


class SkuInformation(msrest.serialization.Model):
    """Information of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.databox.models.Sku
    :ivar enabled: The sku is enabled or not.
    :vartype enabled: bool
    :ivar data_location_to_service_location_map: The map of data location to service location.
    :vartype data_location_to_service_location_map:
     list[~azure.mgmt.databox.models.DataLocationToServiceLocationMap]
    :ivar capacity: Capacity of the Sku.
    :vartype capacity: ~azure.mgmt.databox.models.SkuCapacity
    :ivar costs: Cost of the Sku.
    :vartype costs: list[~azure.mgmt.databox.models.SkuCost]
    :ivar api_versions: Api versions that support this Sku.
    :vartype api_versions: list[str]
    :ivar disabled_reason: Reason why the Sku is disabled. Possible values include: "None",
     "Country", "Region", "Feature", "OfferType", "NoSubscriptionInfo".
    :vartype disabled_reason: str or ~azure.mgmt.databox.models.SkuDisabledReason
    :ivar disabled_reason_message: Message for why the Sku is disabled.
    :vartype disabled_reason_message: str
    :ivar required_feature: Required feature to access the sku.
    :vartype required_feature: str
    """

    _validation = {
        'sku': {'readonly': True},
        'enabled': {'readonly': True},
        'data_location_to_service_location_map': {'readonly': True},
        'capacity': {'readonly': True},
        'costs': {'readonly': True},
        'api_versions': {'readonly': True},
        'disabled_reason': {'readonly': True},
        'disabled_reason_message': {'readonly': True},
        'required_feature': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'data_location_to_service_location_map': {'key': 'properties.dataLocationToServiceLocationMap', 'type': '[DataLocationToServiceLocationMap]'},
        'capacity': {'key': 'properties.capacity', 'type': 'SkuCapacity'},
        'costs': {'key': 'properties.costs', 'type': '[SkuCost]'},
        'api_versions': {'key': 'properties.apiVersions', 'type': '[str]'},
        'disabled_reason': {'key': 'properties.disabledReason', 'type': 'str'},
        'disabled_reason_message': {'key': 'properties.disabledReasonMessage', 'type': 'str'},
        'required_feature': {'key': 'properties.requiredFeature', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInformation, self).__init__(**kwargs)
        self.sku = None
        self.enabled = None
        self.data_location_to_service_location_map = None
        self.capacity = None
        self.costs = None
        self.api_versions = None
        self.disabled_reason = None
        self.disabled_reason_message = None
        self.required_feature = None


class StorageAccountDetails(DataAccountDetails):
    """Details for the storage account.

    All required parameters must be populated in order to send to Azure.

    :param data_account_type: Required. Account Type of the data to be transferred.Constant filled
     by server.  Possible values include: "StorageAccount", "ManagedDisk".
    :type data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :param share_password: Password for all the shares to be created on the device. Should not be
     passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :type share_password: str
    :param storage_account_id: Required. Storage Account Resource Id.
    :type storage_account_id: str
    """

    _validation = {
        'data_account_type': {'required': True},
        'storage_account_id': {'required': True},
    }

    _attribute_map = {
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'share_password': {'key': 'sharePassword', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountDetails, self).__init__(**kwargs)
        self.data_account_type = 'StorageAccount'  # type: str
        self.storage_account_id = kwargs['storage_account_id']


class SubscriptionIsAllowedToCreateJobValidationRequest(ValidationInputRequest):
    """Request to validate subscription permission to create jobs.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    """

    _validation = {
        'validation_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionIsAllowedToCreateJobValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateSubscriptionIsAllowedToCreateJob'  # type: str


class SubscriptionIsAllowedToCreateJobValidationResponseProperties(ValidationInputResponse):
    """Properties of subscription permission to create job validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.CloudError
    :ivar status: Validation status of subscription permission to create job. Possible values
     include: "Valid", "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'CloudError'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionIsAllowedToCreateJobValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateSubscriptionIsAllowedToCreateJob'  # type: str
        self.status = None


class TransferAllDetails(msrest.serialization.Model):
    """Details to transfer all data.

    All required parameters must be populated in order to send to Azure.

    :param data_account_type: Required. Type of the account of data. Possible values include:
     "StorageAccount", "ManagedDisk".
    :type data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :param transfer_all_blobs: To indicate if all Azure blobs have to be transferred.
    :type transfer_all_blobs: bool
    :param transfer_all_files: To indicate if all Azure Files have to be transferred.
    :type transfer_all_files: bool
    """

    _validation = {
        'data_account_type': {'required': True},
    }

    _attribute_map = {
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'transfer_all_blobs': {'key': 'transferAllBlobs', 'type': 'bool'},
        'transfer_all_files': {'key': 'transferAllFiles', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferAllDetails, self).__init__(**kwargs)
        self.data_account_type = kwargs['data_account_type']
        self.transfer_all_blobs = kwargs.get('transfer_all_blobs', None)
        self.transfer_all_files = kwargs.get('transfer_all_files', None)


class TransferConfiguration(msrest.serialization.Model):
    """Configuration for defining the transfer of data.

    All required parameters must be populated in order to send to Azure.

    :param transfer_configuration_type: Required. Type of the configuration for transfer. Possible
     values include: "TransferAll", "TransferUsingFilter".
    :type transfer_configuration_type: str or ~azure.mgmt.databox.models.TransferConfigurationType
    :param transfer_filter_details: Map of filter type and the details to filter. This field is
     required only if the TransferConfigurationType is given as TransferUsingFilter.
    :type transfer_filter_details:
     ~azure.mgmt.databox.models.TransferConfigurationTransferFilterDetails
    :param transfer_all_details: Map of filter type and the details to transfer all data. This
     field is required only if the TransferConfigurationType is given as TransferAll.
    :type transfer_all_details: ~azure.mgmt.databox.models.TransferConfigurationTransferAllDetails
    """

    _validation = {
        'transfer_configuration_type': {'required': True},
    }

    _attribute_map = {
        'transfer_configuration_type': {'key': 'transferConfigurationType', 'type': 'str'},
        'transfer_filter_details': {'key': 'transferFilterDetails', 'type': 'TransferConfigurationTransferFilterDetails'},
        'transfer_all_details': {'key': 'transferAllDetails', 'type': 'TransferConfigurationTransferAllDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferConfiguration, self).__init__(**kwargs)
        self.transfer_configuration_type = kwargs['transfer_configuration_type']
        self.transfer_filter_details = kwargs.get('transfer_filter_details', None)
        self.transfer_all_details = kwargs.get('transfer_all_details', None)


class TransferConfigurationTransferAllDetails(msrest.serialization.Model):
    """Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll.

    :param include: Details to transfer all data.
    :type include: ~azure.mgmt.databox.models.TransferAllDetails
    """

    _attribute_map = {
        'include': {'key': 'include', 'type': 'TransferAllDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferConfigurationTransferAllDetails, self).__init__(**kwargs)
        self.include = kwargs.get('include', None)


class TransferConfigurationTransferFilterDetails(msrest.serialization.Model):
    """Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.

    :param include: Details of the filtering the transfer of data.
    :type include: ~azure.mgmt.databox.models.TransferFilterDetails
    """

    _attribute_map = {
        'include': {'key': 'include', 'type': 'TransferFilterDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferConfigurationTransferFilterDetails, self).__init__(**kwargs)
        self.include = kwargs.get('include', None)


class TransferFilterDetails(msrest.serialization.Model):
    """Details of the filtering the transfer of data.

    All required parameters must be populated in order to send to Azure.

    :param data_account_type: Required. Type of the account of data. Possible values include:
     "StorageAccount", "ManagedDisk".
    :type data_account_type: str or ~azure.mgmt.databox.models.DataAccountType
    :param blob_filter_details: Filter details to transfer blobs.
    :type blob_filter_details: ~azure.mgmt.databox.models.BlobFilterDetails
    :param azure_file_filter_details: Filter details to transfer Azure files.
    :type azure_file_filter_details: ~azure.mgmt.databox.models.AzureFileFilterDetails
    :param filter_file_details: Details of the filter files to be used for data transfer.
    :type filter_file_details: list[~azure.mgmt.databox.models.FilterFileDetails]
    """

    _validation = {
        'data_account_type': {'required': True},
    }

    _attribute_map = {
        'data_account_type': {'key': 'dataAccountType', 'type': 'str'},
        'blob_filter_details': {'key': 'blobFilterDetails', 'type': 'BlobFilterDetails'},
        'azure_file_filter_details': {'key': 'azureFileFilterDetails', 'type': 'AzureFileFilterDetails'},
        'filter_file_details': {'key': 'filterFileDetails', 'type': '[FilterFileDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferFilterDetails, self).__init__(**kwargs)
        self.data_account_type = kwargs['data_account_type']
        self.blob_filter_details = kwargs.get('blob_filter_details', None)
        self.azure_file_filter_details = kwargs.get('azure_file_filter_details', None)
        self.filter_file_details = kwargs.get('filter_file_details', None)


class TransportAvailabilityDetails(msrest.serialization.Model):
    """Transport options availability details for given region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar shipment_type: Transport Shipment Type supported for given region. Possible values
     include: "CustomerManaged", "MicrosoftManaged".
    :vartype shipment_type: str or ~azure.mgmt.databox.models.TransportShipmentTypes
    """

    _validation = {
        'shipment_type': {'readonly': True},
    }

    _attribute_map = {
        'shipment_type': {'key': 'shipmentType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportAvailabilityDetails, self).__init__(**kwargs)
        self.shipment_type = None


class TransportAvailabilityRequest(msrest.serialization.Model):
    """Request body to get the transport availability for given sku.

    :param sku_name: Type of the device. Possible values include: "DataBox", "DataBoxDisk",
     "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    """

    _attribute_map = {
        'sku_name': {'key': 'skuName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportAvailabilityRequest, self).__init__(**kwargs)
        self.sku_name = kwargs.get('sku_name', None)


class TransportAvailabilityResponse(msrest.serialization.Model):
    """Transport options available for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar transport_availability_details: List of transport availability details for given region.
    :vartype transport_availability_details:
     list[~azure.mgmt.databox.models.TransportAvailabilityDetails]
    """

    _validation = {
        'transport_availability_details': {'readonly': True},
    }

    _attribute_map = {
        'transport_availability_details': {'key': 'transportAvailabilityDetails', 'type': '[TransportAvailabilityDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportAvailabilityResponse, self).__init__(**kwargs)
        self.transport_availability_details = None


class TransportPreferences(msrest.serialization.Model):
    """Preferences related to the shipment logistics of the sku.

    All required parameters must be populated in order to send to Azure.

    :param preferred_shipment_type: Required. Indicates Shipment Logistics type that the customer
     preferred. Possible values include: "CustomerManaged", "MicrosoftManaged".
    :type preferred_shipment_type: str or ~azure.mgmt.databox.models.TransportShipmentTypes
    """

    _validation = {
        'preferred_shipment_type': {'required': True},
    }

    _attribute_map = {
        'preferred_shipment_type': {'key': 'preferredShipmentType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportPreferences, self).__init__(**kwargs)
        self.preferred_shipment_type = kwargs['preferred_shipment_type']


class UnencryptedCredentials(msrest.serialization.Model):
    """Unencrypted credentials for accessing device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: Name of the job.
    :vartype job_name: str
    :ivar job_secrets: Secrets related to this job.
    :vartype job_secrets: ~azure.mgmt.databox.models.JobSecrets
    """

    _validation = {
        'job_name': {'readonly': True},
        'job_secrets': {'readonly': True},
    }

    _attribute_map = {
        'job_name': {'key': 'jobName', 'type': 'str'},
        'job_secrets': {'key': 'jobSecrets', 'type': 'JobSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnencryptedCredentials, self).__init__(**kwargs)
        self.job_name = None
        self.job_secrets = None


class UnencryptedCredentialsList(msrest.serialization.Model):
    """List of unencrypted credentials for accessing device.

    :param value: List of unencrypted credentials.
    :type value: list[~azure.mgmt.databox.models.UnencryptedCredentials]
    :param next_link: Link for the next set of unencrypted credentials.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UnencryptedCredentials]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnencryptedCredentialsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class UpdateJobDetails(msrest.serialization.Model):
    """Job details for update.

    :param contact_details: Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :param key_encryption_key: Key encryption key for the job.
    :type key_encryption_key: ~azure.mgmt.databox.models.KeyEncryptionKey
    """

    _attribute_map = {
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyEncryptionKey'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateJobDetails, self).__init__(**kwargs)
        self.contact_details = kwargs.get('contact_details', None)
        self.shipping_address = kwargs.get('shipping_address', None)
        self.key_encryption_key = kwargs.get('key_encryption_key', None)


class ValidateAddress(ValidationInputRequest):
    """The requirements to validate customer address where the device needs to be shipped.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability", "ValidateDataTransferDetails".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param shipping_address: Required. Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    :param transport_preferences: Preferences related to the shipment logistics of the sku.
    :type transport_preferences: ~azure.mgmt.databox.models.TransportPreferences
    """

    _validation = {
        'validation_type': {'required': True},
        'shipping_address': {'required': True},
        'device_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'transport_preferences': {'key': 'transportPreferences', 'type': 'TransportPreferences'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateAddress, self).__init__(**kwargs)
        self.validation_type = 'ValidateAddress'  # type: str
        self.shipping_address = kwargs['shipping_address']
        self.device_type = kwargs['device_type']
        self.transport_preferences = kwargs.get('transport_preferences', None)


class ValidationResponse(msrest.serialization.Model):
    """Response of pre job creation validations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Overall validation status. Possible values include: "AllValidToProceed",
     "InputsRevisitRequired", "CertainInputValidationsSkipped".
    :vartype status: str or ~azure.mgmt.databox.models.OverallValidationStatus
    :ivar individual_response_details: List of response details contain validationType and its
     response as key and value respectively.
    :vartype individual_response_details: list[~azure.mgmt.databox.models.ValidationInputResponse]
    """

    _validation = {
        'status': {'readonly': True},
        'individual_response_details': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'properties.status', 'type': 'str'},
        'individual_response_details': {'key': 'properties.individualResponseDetails', 'type': '[ValidationInputResponse]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationResponse, self).__init__(**kwargs)
        self.status = None
        self.individual_response_details = None
