% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ballgown-expr-methods.R
\docType{methods}
\name{texpr}
\alias{texpr}
\alias{texpr,ballgown-method}
\title{extract transcript-level expression measurements from ballgown objects}
\usage{
texpr(x, meas = "FPKM")

\S4method{texpr}{ballgown}(x, meas = "FPKM")
}
\arguments{
\item{x}{a ballgown object}

\item{meas}{type of measurement to extract. Can be "cov", "FPKM", or "all". 
Default "FPKM".}
}
\value{
transcript-by-sample matrix containing expression values (measured by
  \code{meas}). If \code{meas} is \code{"all"}, a data frame is returned, 
  containing all measurements and location information.
}
\description{
extract transcript-level expression measurements from ballgown objects
}
\examples{
data(bg)
transcript_fpkm_matrix = texpr(bg)
transcript_data_frame = texpr(bg, 'all')
}
