% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaraParam.R
\docType{class}
\name{ClaraParam-class}
\alias{ClaraParam-class}
\alias{show,ClaraParam-method}
\alias{.defaultScalarArguments,ClaraParam-method}
\alias{ClaraParam}
\alias{clusterRows,ANY,ClaraParam-method}
\title{Clustering Large Applications}
\usage{
ClaraParam(
  centers,
  metric = NULL,
  stand = NULL,
  samples = NULL,
  sampsize = NULL
)

\S4method{clusterRows}{ANY,ClaraParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{centers}{An integer scalar specifying the number of centers.
Alternatively, a function that takes the number of observations and returns the number of centers.}

\item{metric, stand, samples, sampsize}{Further arguments to pass to \code{\link{clara}}.
Set to the function defaults if not supplied.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{ClaraParam} object.}

\item{full}{Logical scalar indicating whether the full PAM statistics should be returned.}
}
\value{
The \code{ClaraParam} constructor will return a \linkS4class{ClaraParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects}
(a list containing \code{clara}, the direct output of \code{\link{clara}}).
}
\description{
Run the CLARA algorithm, an extension of the PAM method for large datasets.
}
\details{
This class usually requires the user to specify the number of clusters beforehand.
However, we can also allow the number of clusters to vary as a function of the number of observations.
The latter is occasionally useful, e.g., to allow the clustering to automatically become more granular for large datasets.

To modify an existing ClaraParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.

Note that \code{clusterRows} will always use \code{rngR=TRUE}, for greater consistency with other algorithms of the \linkS4class{FixedNumberParam} class;
and \code{pamLike=TRUE}, for consistency with the PAM implementation from which it was derived.
}
\examples{
clusterRows(iris[,1:4], ClaraParam(centers=4))
clusterRows(iris[,1:4], ClaraParam(centers=4, sampsize=50))
clusterRows(iris[,1:4], ClaraParam(centers=sqrt))
}
\seealso{
\code{\link{clara}}, which actually does all the heavy lifting.

\linkS4class{PamParam}, for the original PAM algorithm.
}
\author{
Aaron Lun
}
