% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifiers.R
\name{gliomaClassifier}
\alias{gliomaClassifier}
\title{Gliomar classifier}
\usage{
gliomaClassifier(data)
}
\arguments{
\item{data}{DNA methylation matrix or Summarized Experiments with samples on columns
and probes on the rows}
}
\value{
A list of 3 data frames:
1) Sample final classification
2) Each model final classification
3) Each class probability of classification
}
\description{
Classify DNA methylation gliomas using data from
https://doi.org/10.1016/j.cell.2015.12.028
}
\examples{
\dontrun{
query <- GDCquery(project= "TCGA-GBM",
                  data.category = "DNA methylation",
                  barcode = c("TCGA-06-0122","TCGA-14-1456"),
                  platform = "Illumina Human Methylation 27",
                  legacy = TRUE)
GDCdownload(query)
data.hg19 <- GDCprepare(query)
classification <- gliomaClassifier(data.hg19)

# Comparing reslts
TCGAquery_subtype("GBM") \%>\%
dplyr::filter(patient \%in\% c("TCGA-06-0122","TCGA-14-1456")) \%>\%
dplyr::select("patient","Supervised.DNA.Methylation.Cluster")
}
}
\author{
Tiago Chedraoui Silva, Tathiane Malta, Houtan Noushmehr
}
