% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{prior_summary.brmsfit}
\alias{prior_summary.brmsfit}
\alias{prior_summary}
\title{Extract Priors of a Bayesian Model Fitted with \pkg{brms}}
\usage{
\method{prior_summary}{brmsfit}(object, all = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{all}{Logical; Show all parameters in the model which may have
priors (\code{TRUE}) or only those with proper priors (\code{FALSE})?}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
For \code{brmsfit} objects, an object of class \code{brmsprior}.
}
\description{
Extract Priors of a Bayesian Model Fitted with \pkg{brms}
}
\examples{
\dontrun{
fit <- brm(count ~ zAge + zBase * Trt
             + (1|patient) + (1|obs),
           data = epilepsy, family = poisson(),
           prior = c(prior(student_t(5,0,10), class = b),
                     prior(cauchy(0,2), class = sd)))

prior_summary(fit)
prior_summary(fit, all = FALSE)
print(prior_summary(fit, all = FALSE), show_df = FALSE)
}

}
