% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifySurv.R
\name{stratifySurv}
\alias{stratifySurv}
\title{Add strata to a Surv object}
\usage{
stratifySurv(y, strata)
}
\arguments{
\item{y}{A Surv object.}

\item{strata}{A vector of length equal to the number of observations in
y, indicating strata membership.}
}
\value{
An object of class \code{stratifySurv} (in addition to all the
classes \code{y} belonged to).
}
\description{
Helper function to add strata as an attribute to a Surv object. The
output of this function can be used as the response in \code{glmnet()}
for fitting stratified Cox models.
}
\details{
When fitting a stratified Cox model with \code{glmnet()}, strata should
be added to a \code{Surv} response with this helper function. Note that
it is not sufficient to add strata as an attribute to the \code{Surv}
response manually: if the result does not have class \code{stratifySurv},
subsetting of the response will not work properly.
}
\examples{
y <- survival::Surv(1:10, rep(0:1, length.out = 10))
strata <- rep(1:3, length.out = 10)
y2 <- stratifySurv(y, strata)  # returns stratifySurv object

}
