% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semicolon_linter.R
\name{semicolon_linter}
\alias{semicolon_linter}
\alias{semicolon_terminator_linter}
\title{Semicolon linter}
\usage{
semicolon_linter(allow_compound = FALSE, allow_trailing = FALSE)

semicolon_terminator_linter(semicolon = c("compound", "trailing"))
}
\arguments{
\item{allow_compound}{Logical, default \code{FALSE}. If \code{TRUE}, "compound"
semicolons (e.g. as in \verb{x; y}, i.e., on the same line of code) are allowed.}

\item{allow_trailing}{Logical, default \code{FALSE}. If \code{TRUE}, "trailing"
semicolons (i.e., those that terminate lines of code) are allowed.}

\item{semicolon}{A character vector defining which semicolons to report:
\describe{
\item{compound}{Semicolons that separate two statements on the same line.}
\item{trailing}{Semicolons following the last statement on the line.}
}}
}
\description{
Check that no semicolons terminate expressions.
}
\seealso{
\link{linters} for a complete list of linters available in lintr. \cr
\url{https://style.tidyverse.org/syntax.html#semicolons}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
