% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_serial.R
\name{pdwtest}
\alias{pdwtest}
\alias{pdwtest.panelmodel}
\alias{pdwtest.formula}
\title{Durbin--Watson Test for Panel Models}
\usage{
pdwtest(x, ...)

\method{pdwtest}{panelmodel}(x, ...)

\method{pdwtest}{formula}(x, data, ...)
}
\arguments{
\item{x}{an object of class \code{"panelmodel"} or of class
\code{"formula"},}

\item{\dots}{further arguments to be passed on to \code{dwtest},
e.g., \code{alternative}, see \code{\link[lmtest:dwtest]{lmtest::dwtest()}} for
further details.}

\item{data}{a \code{data.frame},}
}
\value{
An object of class \code{"htest"}.
}
\description{
Test of serial correlation for (the idiosyncratic component of) the errors
in panel models.
}
\details{
This Durbin--Watson test uses the auxiliary model on
(quasi-)demeaned data taken from a model of class \code{plm} which may
be a \code{pooling} (the default), \code{random} or \code{within} model. It
performs a Durbin--Watson test (using \code{dwtest} from package
\CRANpkg{lmtest} on the residuals of the (quasi-)demeaned model,
which should be serially uncorrelated under the null of no serial
correlation in idiosyncratic errors. The function takes the
demeaned data, estimates the model and calls \code{dwtest}. Thus, this
test does not take the panel structure of the residuals into
consideration; it shall not be confused with the generalized
Durbin-Watson test for panels in \code{pbnftest}.
}
\examples{

data("Grunfeld", package = "plm")
g <- plm(inv ~ value + capital, data = Grunfeld, model="random")
pdwtest(g)
pdwtest(g, alternative="two.sided")
## formula interface
pdwtest(inv ~ value + capital, data=Grunfeld, model="random")

}
\references{
\insertRef{DURB:WATS:50}{plm}

\insertRef{DURB:WATS:51}{plm}

\insertRef{DURB:WATS:71}{plm}

\insertRef{WOOL:02}{plm}

\insertRef{WOOL:10}{plm}
}
\seealso{
\code{\link[lmtest:dwtest]{lmtest::dwtest()}} for the Durbin--Watson test
in \CRANpkg{lmtest}, \code{\link[=pbgtest]{pbgtest()}} for the analogous
Breusch--Godfrey test for panel models,
\code{\link[lmtest:bgtest]{lmtest::bgtest()}} for the Breusch--Godfrey test for
serial correlation in the linear model. \code{\link[=pbltest]{pbltest()}},
\code{\link[=pbsytest]{pbsytest()}}, \code{\link[=pwartest]{pwartest()}} and
\code{\link[=pwfdtest]{pwfdtest()}} for other serial correlation tests for
panel models.

For the Durbin-Watson test generalized to panel data models see
\code{\link[=pbnftest]{pbnftest()}}.
}
\author{
Giovanni Millo
}
\keyword{htest}
