% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R, R/transmute.R
\name{mutate}
\alias{mutate}
\alias{mutate.data.frame}
\alias{transmute}
\title{Create or transform variables}
\usage{
mutate(.data, ...)

\method{mutate}{data.frame}(
  .data,
  ...,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)

transmute(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Name-value pairs of expressions, each with length \code{1L}. The name of each argument will be the name of a
new column and the value will be its corresponding value. Use a \code{NULL} value in \code{mutate} to drop a variable. New
variables overwrite existing variables of the same name.}

\item{.keep}{This argument allows you to control which columns from \code{.data} are retained in the output:
\itemize{
\item \code{"all"}, the default, retains all variables.
\item \code{"used"} keeps any variables used to make new variables; it's useful for checking your work as it displays inputs
and outputs side-by-side.
\item \code{"unused"} keeps only existing variables \strong{not} used to make new variables.
\item \code{"none"}, only keeps grouping keys (like \code{\link[=transmute]{transmute()}}).
}

Grouping variables are always kept, unconditional to \code{.keep}.}

\item{.before, .after}{<\code{\link[=select_helpers]{poor-select}}> Optionally, control where new columns should appear (the
default is to add to the right hand side). See \code{\link[=relocate]{relocate()}} for more details.}
}
\description{
\code{mutate()} adds new variables and preserves existing ones; \code{transmute()} adds new variables and drops existing ones.
Both functions preserve the number of rows of the input. New variables overwrite existing variables of the same name.
Variables can be removed by setting their value to \code{NULL}.
}
\section{Useful mutate functions}{

\itemize{
\item \code{\link{+}}, \code{\link{-}}, \code{\link[=log]{log()}}, etc., for their usual mathematical meanings
\item \code{\link[=lead]{lead()}}, \code{\link[=lag]{lag()}}
\item \code{\link[=dense_rank]{dense_rank()}}, \code{\link[=min_rank]{min_rank()}}, \code{\link[=percent_rank]{percent_rank()}}, \code{\link[=row_number]{row_number()}}, \code{\link[=cume_dist]{cume_dist()}}, \code{\link[=ntile]{ntile()}}
\item \code{\link[=cumsum]{cumsum()}}, \code{\link[=cummin]{cummin()}}, \code{\link[=cummax]{cummax()}}
\item \code{\link[=na_if]{na_if()}}, \code{\link[=coalesce]{coalesce()}}
\item \code{\link[=if_else]{if_else()}}, \code{\link[=recode]{recode()}}, \code{\link[=case_when]{case_when()}}
}
}

\examples{
mutate(mtcars, mpg2 = mpg * 2)
mtcars \%>\% mutate(mpg2 = mpg * 2)
mtcars \%>\% mutate(mpg2 = mpg * 2, cyl2 = cyl * 2)

# Newly created variables are available immediately
mtcars \%>\% mutate(mpg2 = mpg * 2, mpg4 = mpg2 * 2)

# You can also use mutate() to remove variables and modify existing variables
mtcars \%>\% mutate(
  mpg = NULL,
  disp = disp * 0.0163871 # convert to litres
)

# By default, new columns are placed on the far right.
# You can override this with `.before` or `.after`.
df <- data.frame(x = 1, y = 2)
df \%>\% mutate(z = x + y)
df \%>\% mutate(z = x + y, .before = 1)
df \%>\% mutate(z = x + y, .after = x)

# By default, mutate() keeps all columns from the input data.
# You can override with `.keep`
df <- data.frame(
  x = 1, y = 2, a = "a", b = "b",
  stringsAsFactors = FALSE
)
df \%>\% mutate(z = x + y, .keep = "all") # the default
df \%>\% mutate(z = x + y, .keep = "used")
df \%>\% mutate(z = x + y, .keep = "unused")
df \%>\% mutate(z = x + y, .keep = "none") # same as transmute()

# mutate() vs transmute --------------------------
# mutate() keeps all existing variables
mtcars \%>\%
  mutate(displ_l = disp / 61.0237)

# transmute keeps only the variables you create
mtcars \%>\%
  transmute(displ_l = disp / 61.0237)

}
