% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws_rvars.R
\name{draws_rvars}
\alias{draws_rvars}
\alias{as_draws_rvars}
\alias{as_draws_rvars.default}
\alias{as_draws_rvars.draws_rvars}
\alias{as_draws_rvars.list}
\alias{as_draws_rvars.draws_matrix}
\alias{as_draws_rvars.draws_array}
\alias{as_draws_rvars.draws_df}
\alias{as_draws_rvars.draws_list}
\alias{as_draws_rvars.mcmc}
\alias{as_draws_rvars.mcmc.list}
\alias{is_draws_rvars}
\title{The \code{draws_rvars} format}
\usage{
as_draws_rvars(x, ...)

\method{as_draws_rvars}{default}(x, ...)

\method{as_draws_rvars}{draws_rvars}(x, ...)

\method{as_draws_rvars}{list}(x, ...)

\method{as_draws_rvars}{draws_matrix}(x, ...)

\method{as_draws_rvars}{draws_array}(x, ...)

\method{as_draws_rvars}{draws_df}(x, ...)

\method{as_draws_rvars}{draws_list}(x, ...)

\method{as_draws_rvars}{mcmc}(x, ...)

\method{as_draws_rvars}{mcmc.list}(x, ...)

draws_rvars(..., .nchains = 1)

is_draws_rvars(x)
}
\arguments{
\item{x}{An object to convert to a \code{draws_rvars} object.}

\item{...}{For \code{as_draws_rvars()}:
Arguments passed to individual methods (if applicable).
For \code{draws_rvars()}: Named
arguments containing numeric vectors each defining a separate variable.}

\item{.nchains}{(positive integer) The number of chains. The default is \code{1}.}
}
\value{
A \code{draws_rvars} object, which has classes
\code{c("draws_rvars", "draws", "list")}.
}
\description{
The \code{as_draws_rvars()} methods convert
objects to the \code{draws_rvars} format.
The \code{draws_rvars()} function creates an object of the
\code{draws_rvars} format based on a set of numeric vectors.
See \strong{Details}.
}
\details{
Objects of class \code{"draws_rvars"} are lists of \code{\link{rvar}} objects.
See \strong{Examples}.
}
\examples{
x1 <- as_draws_rvars(example_draws())
class(x1)
print(x1)
str(x1)

x2 <- draws_rvars(a = rnorm(10), b = rnorm(10), c = 1)
class(x2)
print(x2)
str(x2)
}
\seealso{
Other formats: 
\code{\link{draws}},
\code{\link{draws_array}()},
\code{\link{draws_df}()},
\code{\link{draws_list}()},
\code{\link{draws_matrix}()}
}
\concept{formats}
