% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_linpred.R
\name{posterior_linpred}
\alias{posterior_linpred}
\title{Generic function for accessing the posterior distribution of the linear
predictor}
\usage{
posterior_linpred(object, transform = FALSE, ...)
}
\arguments{
\item{object}{The object to use.}

\item{transform}{Should the linear predictor be transformed using the
inverse-link function? The default is \code{FALSE}, in which case the
untransformed linear predictor is returned.}

\item{...}{Arguments passed to methods. See the methods in the \pkg{rstanarm}
package for examples.}
}
\value{
\code{posterior_linpred()} methods should return a \eqn{D} by \eqn{N}
matrix, where \eqn{D} is the number of draws from the posterior
distribution distribution and \eqn{N} is the number of data points.
}
\description{
Extract the posterior draws of the linear predictor, possibly transformed by
the inverse-link function. See
\href{https://mc-stan.org/rstanarm/reference/posterior_linpred.stanreg.html}{posterior_linpred.stanreg()}
in the \pkg{rstanarm} package for an example.
}
\examples{
# See help("posterior_linpred", package = "rstanarm")

}
\seealso{
\itemize{
\item The \pkg{rstanarm} package (\href{https://mc-stan.org/rstanarm/}{mc-stan.org/rstanarm})
for example methods
(\href{https://CRAN.R-project.org/package=rstanarm}{CRAN},
\href{https://github.com/stan-dev/rstanarm}{GitHub}).
}

\itemize{
\item Guidelines and recommendations for developers of \R packages
interfacing with Stan and a demonstration getting a simple package working
can be found in the vignettes included with \pkg{rstantools} and at
\href{https://mc-stan.org/rstantools/articles/}{mc-stan.org/rstantools/articles}.
}
}
