% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimnames.R
\name{dimnames.xts}
\alias{dimnames.xts}
\alias{dimnames<-.xts}
\title{Dimnames of an xts Object}
\usage{
\method{dimnames}{xts}(x)

\method{dimnames}{xts}(x) <- value
}
\arguments{
\item{x}{An xts object.}

\item{value}{A two element list. See Details.}
}
\value{
A list or character string containing coerced row names and/or
actual column names.

Attempts to set rownames on xts objects via rownames or dimnames will
silently fail.
}
\description{
Get or set dimnames of an xts object.
}
\details{
For efficienty, xts objects do not have rownames (unlike zoo objects).
Attempts to set rownames on an xts object will silently set them to \code{NULL}.
This is done for internal compatibility reasons, as well as to provide
consistency in performance regardless of object use.
}
\note{
Unlike zoo, all xts objects have dimensions. xts objects cannot be
plain vectors.
}
\examples{

x <- xts(1:10, Sys.Date()+1:10)
dimnames(x)
rownames(x)
rownames(x) <- 1:10
rownames(x)
str(x)

}
\seealso{
\code{\link[=xts]{xts()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{misc}
