///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2018 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//! @examplefile dirichlet_hho.cc The Poisson problem by the hybrid high order method
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "dirichlet_homogeneous.h"
#include "diffusion_isotropic.h"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  string Pkd = (argc > 2) ? argv[2] : "P1d",
         Pld = (argc > 3) ? argv[3] :  Pkd;
  Float beta = (argc > 4) ? atof(argv[4]) : 1;
  space  Xh (omega, Pld),
         Mh (omega["sides"], Pkd);
  Mh.block("boundary");
  size_t k = Xh.degree(), l = Mh.degree(), d = omega.dimension();
  check_macro(l == k-1 || l == k || l == k+1,
    "invalid (k,l) = ("<<k<<","<<l<<")");
  space Xhs(omega, "P"+itos(k+1)+"d"),
        Zh (omega, "P0"),
        Mht(omega, "trace(P"+itos(k)+"d)");
  space Yh = Xh*Xhs*Xh*Mht*Zh;
  trial x(Yh), lambda(Mh);
  test  y(Yh), mu(Mh);
  auto u = x[0], us = x[1], ut = x[2], deltat = x[3], zeta = x[4];
  auto v = y[0], vs = y[1], vt = y[2], gammat = y[3], xi   = y[4];
  integrate_option iopt;
  iopt.invert = true;
  form inv_a = integrate(dot(grad_h(us),a(d)*grad_h(vs))
                + dot(grad_h(us)-grad_h(u),a(d)*(grad_h(vs)-grad_h(v)))
                + (us-u)*xi + (vs-v)*zeta + (ut-us)*(vt-vs)
                + on_local_sides(beta/h_local()*deltat*gammat
                  + u*dot(a(d)*grad_h(vs),normal())
                  + v*dot(a(d)*grad_h(us),normal())
                  + (deltat - us + ut)*(gammat - vs + vt)), iopt);
  form b = integrate(omega,on_local_sides(-mu*dot(a(d)*grad_h(us),normal())));
	// TODO: remove omega, autodetect it ?
  field lh = integrate (f(d)*v);
	// TODO: f -> -f ? check the FV...
  field lambda_h(Mh,0);
  form s = b*inv_a*trans(b);
  field rh = b*(inv_a*lh);
  problem p (s);
  p.solve (rh, lambda_h);
  field xh = inv_a*(lh - b.trans_mult(lambda_h));
  dout << catchmark("beta")   << beta << endl
       << catchmark("u")      << xh[0]
       << catchmark("us")     << xh[1]
       << catchmark("ut")     << xh[2]
       << catchmark("delta")  << xh[3]
       << catchmark("zeta")   << xh[4]
       << catchmark("lambda") << lambda_h;
}
