# 2022-04-05 Triage Log

A somewhat quiet week with only a few improvements and regressions, but with improvements ever so slightly edging out regressions. The biggest regression was in a rollup which makes investigation difficult though it looks like its in trait resolution which impacts crates that do a lot of that such as diesel. The biggest improvement comes from work done by the performance team (more specifically @nnethercote) to improve `macro_rules` parsing which can lead to sizeable performance gains for crates using the ["token munching"](https://danielkeep.github.io/tlborm/book/pat-incremental-tt-munchers.html) pattern in `macro_rules`.

Triage done by **@rylev**.
Revision range: [3e7514670db841a7f0d7656f3b13b1c8b2c11599..949b98cab8a186b98bf87e64374b8d0848c55271](https://perf.rust-lang.org/?start=3e7514670db841a7f0d7656f3b13b1c8b2c11599&end=949b98cab8a186b98bf87e64374b8d0848c55271&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 1 Mixed; 2 of them in rollups
37 comparisons made in total

#### Regressions

Make lowering pull-based [#90204](https://github.com/rust-lang/rust/pull/90204) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=03314912f1361af6b39383958b5aa1b4aed61c26&end=bd1a8692f6260fd59dba1e0fa187092a1c354b2e&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 2 | 33 | 0 | 0 | 2 |
| mean | 0.3% | 0.7% | N/A | N/A | 0.3% |
| max | 0.4% | 1.7% | N/A | N/A | 0.4% |
- This is necessary for unlocking incremental lowering. [It was justified as acceptable](https://github.com/rust-lang/rust/pull/90204#pullrequestreview-878629128) since the performance will hopefully be won back (in the incremental case) when lowering is made incremental and the impact on real world crates is pretty small (only 2 regressions at an average of 0.3%).


Rollup of 7 pull requests [#95662](https://github.com/rust-lang/rust/pull/95662) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=60e50fc1cfe0bb693a5f4f93eb83ef70854531e3&end=a22cf2af0510b3ec4cbb19c3de11d3d8291349d9&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 20 | 13 | 0 | 6 | 20 |
| mean | 0.8% | 0.4% | N/A | -0.4% | 0.8% |
| max | 2.0% | 0.7% | N/A | -0.5% | 2.0% |
- It's not clear what the underlying cause could be as it seems that the issues are coming in trait selection and there are several PRs that touch trait selection (albeit for diagnostics purposes). I've left [a comment](https://github.com/rust-lang/rust/pull/95662#issuecomment-1088686029) to see if we can investigate further.

#### Improvements

Yet more `parse_tt` improvements [#95425](https://github.com/rust-lang/rust/pull/95425) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bb5c437a2ce9ccf2204c974300c5ea9eb32d3635&end=c5cf08d37b85f953b132951e868df5b924250fdc&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 0 | 30 | 23 | 31 |
| mean | 0.3% | N/A | -0.9% | -2.0% | -0.9% |
| max | 0.3% | N/A | -2.3% | -6.2% | -2.3% |


Add debug assertions to some unsafe functions [#92686](https://github.com/rust-lang/rust/pull/92686) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=15a242a432c9c40a60def102209a5d40900b7b9d&end=168a0209002fef203e83989ff641c1b3e1a51859&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 0 | 17 | 19 | 18 |
| mean | 0.6% | N/A | -0.5% | -0.4% | -0.4% |
| max | 0.6% | N/A | -1.4% | -0.8% | -1.4% |


#### Mixed

A new matcher representation for use in `parse_tt` [#95555](https://github.com/rust-lang/rust/pull/95555) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d5139f44690e7765df801ca33a7f627d128ac9e2&end=6a9080b25e73d26aae94c3f6a13b31de58e66b5a&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 3 | 10 | 18 | 11 | 21 |
| mean | 0.4% | 1.0% | -1.0% | -2.4% | -0.8% |
| max | 0.4% | 2.8% | -2.0% | -4.6% | -2.0% |
- This was already [justified](https://github.com/rust-lang/rust/pull/95555#issuecomment-1088070142) as being acceptable since the real world crates that suffer from regressions are exercising some of the worst case scenario execution paths. There is an attempt to address this in a follow up ([#95669](https://github.com/rust-lang/rust/pull/95669)). In any case, the improvements outweigh the regressions in both magnitude and number.
