/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "vcruise/ad2044_items.h"

namespace VCruise {

const AD2044ItemInfo g_ad2044ItemInfos[kNumAD2044Items] = {
	{0, 0, false, 0},                // 0
	{0, 0, false, 0},               // 1
	{0, 0, false, 0},               // 2
	{0, 0, false, 0},               // 3
	{0, 0, false, 0},               // 4
	{0, 0, false, 0},               // 5
	{0, 0, false, 0},               // 6
	{0, 0, false, 0},               // 7
	{0, 0, false, 0},               // 8
	{0, 0, false, 0},               // 9
	{0, 0, false, 0},               // 10
	{0, 0, false, 0},               // 11
	{0, 0, false, 0},               // 12
	{0, 0, false, 0},               // 13
	{0, 0, false, 0},               // 14
	{0, 0, false, 0},               // 15
	{0, 0, false, 0},               // 16
	{0, 0, false, 0},                      // 17
	{0x3D70D2EC, 0x98382A38, true, 0x128}, // 18 spoon
	{0, 0, false, 0},               // 19
	{0, 0, false, 0},               // 20
	{0, 0, false, 0},               // 21
	{0, 0, false, 0},               // 22
	{0, 0, false, 0},               // 23
	{0, 0, true, 0x134},            // 24 cigarettes (filled)
	{0, 0, false, 0},               // 25
	{0, 0, false, 0},               // 26
	{0, 0, true, 0x137},            // 27 matches
	{0, 0, false, 0},               // 28
	{0, 0, false, 0},               // 29
	{0, 0, false, 0},               // 30
	{0, 0, false, 0},               // 31
	{0, 0, false, 0},               // 32
	{0, 0, false, 0},               // 33
	{0, 0, false, 0},               // 34
	{0, 0, false, 0},               // 35
	{0, 0, false, 0},               // 36
	{0, 0, false, 0},               // 37
	{0, 0, false, 0},               // 38
	{0, 0, false, 0},               // 39
	{0, 0, false, 0},               // 40
	{0, 0, false, 0},               // 41
	{0, 0, false, 0},               // 42
	{0, 0, false, 0},               // 43
	{0, 0, false, 0},               // 44
	{0, 0, false, 0},               // 45
	{0, 0, false, 0},               // 46
	{0, 0, false, 0},               // 47
	{0, 0, false, 0},               // 48
	{0, 0, false, 0},               // 49
	{0, 0, false, 0},               // 50
	{0, 0, false, 0},               // 51
	{0, 0, false, 0},               // 52
	{0, 0, false, 0},               // 53
	{0x83d54448, 0x839911EF, 0, 0}, // 54 goaler (sic)
	{0, 0, false, 0},               // 55
	{0, 0, false, 0},               // 56
	{0, 0, false, 0},               // 57
	{0, 0, false, 0},               // 58
	{0, 0, false, 0},               // 59
	{0, 0, false, 0x170},           // 60 mirror
	{0, 0, false, 0},               // 61
	{0, 0, false, 0},               // 62
	{0, 0, false, 0},               // 63
	{0, 0, false, 0},               // 64
	{0, 0, false, 0},               // 65
	{0, 0, false, 0},               // 66
	{0, 0, false, 0},               // 67
	{0, 0, true, 0x178},            // 68 cigarette
	{0, 0, true, 0x179},            // 69 cigarette (lit)
	{0, 0, false, 0},               // 70
	{0, 0, false, 0},               // 71
	{0, 0, false, 0},               // 72
	{0, 0, true, 0x183},            // 73 cigarettes (1 missing)
};

} // End of namespace VCruise
