/***************************************************************************
*   Copyright (C) 2020 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program. If not, see <https://www.gnu.org/licenses/>  *
***************************************************************************/
/** @file
* This file defines classes SKGSQLCipherDriverPlugin.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/

#include "qsql_sqlite_p.h"
#include <qsqldriverplugin.h>
#include <qstringlist.h>

QT_BEGIN_NAMESPACE

class SKGSQLCipherDriverPlugin : public QSqlDriverPlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.qt-project.Qt.QSqlDriverFactoryInterface" FILE "skgsqlcipherdriverplugin.json")

public:
    SKGSQLCipherDriverPlugin()
        = default;

    QSqlDriver* create(const QString& iName) override
    {
        if (iName == QStringLiteral("SKGSQLCIPHER")) {
            auto driver = new QSQLiteDriver();
            return driver;
        }
        return nullptr;
    }
};


QT_END_NAMESPACE

#include "skgsqlcipherdriverplugin.moc"
