/* -*- mode: C; mode: fold; -*- */
/* This file was automatically generated. */

/*
  Copyright (c) 2003-2011 Massachusetts Institute of Technology

  This software was developed by the MIT Center for Space Research
  under contract SV1-61010 from the Smithsonian Institution.

  Permission to use, copy, modify, distribute, and sell this software
  and its documentation for any purpose is hereby granted without fee,
  provided that the above copyright notice appear in all copies and
  that both that copyright notice and this permission notice appear in
  the supporting documentation, and that the name of the Massachusetts
  Institute of Technology not be used in advertising or publicity
  pertaining to distribution of the software without specific, written
  prior permission.  The Massachusetts Institute of Technology makes
  no representations about the suitability of this software for any
  purpose.  It is provided "as is" without express or implied warranty.

  THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
  INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
  WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/* Author: John E. Davis (jed@jedsoft.org) */

#include <stdio.h>
#include <slang.h>

#include <gsl/gsl_errno.h>
#include <gsl/gsl_version.h>

#include <gsl/gsl_const_cgs.h>
#include <gsl/gsl_const_cgsm.h>
#include <gsl/gsl_const_mksa.h>
#include <gsl/gsl_const_mks.h>
#include <gsl/gsl_const_num.h>

#ifdef __cplusplus
extern "C"
{
#endif
/* SLANG_MODULE(gslconst); */
#ifdef __cplusplus
}
#endif

#include "slgsl.h"
#include "version.h"

#define MODULE_HAS_DCONSTANTS
#define _GSLCONST_MODULE_C_
#ifdef MODULE_HAS_INTRINSICS
/*{{{ Helper Functions */

#ifdef _GSLSF_MODULE_C_
static gsl_mode_t Default_GSL_Mode = GSL_PREC_SINGLE;

static int get_gsl_precision (void)
{
   return (int) Default_GSL_Mode;
}
static void set_gsl_precision (int *pp)
{
   int p = *pp;

   if ((p == GSL_PREC_SINGLE) || (p == GSL_PREC_DOUBLE) || (p == GSL_PREC_APPROX))
     Default_GSL_Mode = p;
}

static int get_gsl_mode (gsl_mode_t *mp, int from_stack)
{
   if (from_stack)
     {
	int mode;
	if (-1 == SLang_pop_integer (&mode))
	  return -1;
	*mp = (gsl_mode_t) mode;
     }

   *mp = Default_GSL_Mode;
   return 0;
}

static void do_d_dm (double (*f)(double, gsl_mode_t), gsl_mode_t m)
{
   SLGSL_Double_Array_Type a;
   SLang_Array_Type *in, *out;
   unsigned int i, n;
   double *xp, *yp;

   if (-1 == slgsl_pop_d_array (&a, 0))
     return;

   if (NULL == (in = a.at))
     {
	(void) SLang_push_double ((*f)(a.x, m));
	return;
     }

   if (NULL == (out = SLang_create_array (SLANG_DOUBLE_TYPE, 0, NULL, in->dims, in->num_dims)))
     {
	SLang_free_array (in);
	return;
     }

   n = in->num_elements;
   xp = a.xp;
   yp = (double *) out->data;
   for (i = 0; i < n; i++)
     yp[i] = (*f)(xp[i], m);

   (void) SLang_push_array (out, 1);
   SLang_free_array (in);
}

static void do_d_ddm (double (*f)(double, double, gsl_mode_t), gsl_mode_t m)
{
   SLGSL_Double_Array_Type a, b;
   SLang_Array_Type *atz;
   unsigned int i, n;
   double *xp, *yp, *zp;
   unsigned int xinc, yinc;

   if (-1 == slgsl_pop_dd_array (&a, &b, 0))
     return;

   if ((NULL == (atz = a.at))
       && (NULL == (atz = b.at)))
     {
	(void) SLang_push_double ((*f)(a.x, b.x, m));
	return;
     }

   atz = SLang_create_array (SLANG_DOUBLE_TYPE, 0, NULL, atz->dims, atz->num_dims);
   if (atz == NULL)
     {
	SLang_free_array (a.at);
	SLang_free_array (b.at);
	return;
     }

   n = atz->num_elements;
   zp = (double *) atz->data;
   xp = a.xp;
   yp = b.xp;
   xinc = a.inc;
   yinc = b.inc;

   for (i = 0; i < n; i++)
     {
	zp[i] = (*f)(*xp, *yp, m);
	xp += xinc;
	yp += yinc;
     }

   (void) SLang_push_array (atz, 1);
   SLang_free_array (a.at);
   SLang_free_array (b.at);
}

static void do_d_dddm (double (*f)(double, double, double, gsl_mode_t), gsl_mode_t m)
{
   SLGSL_Double_Array_Type a, b, c;
   SLang_Array_Type *atz;
   unsigned int i, n;
   double *ap, *bp, *cp, *zp;
   unsigned int ainc, binc, cinc;

   if (-1 == slgsl_pop_ddd_array (&a, &b, &c, 0))
     return;

   if ((NULL == (atz = a.at))
       && (NULL == (atz = b.at))
       && (NULL == (atz = c.at)))
     {
	(void) SLang_push_double ((*f)(a.x, b.x, c.x, m));
	return;
     }

   atz = SLang_create_array (SLANG_DOUBLE_TYPE, 0, NULL, atz->dims, atz->num_dims);
   if (atz == NULL)
     {
	SLang_free_array (a.at);
	SLang_free_array (b.at);
	SLang_free_array (c.at);
	return;
     }

   n = atz->num_elements;
   zp = (double *) atz->data;
   ap = a.xp;
   bp = b.xp;
   cp = c.xp;
   ainc = a.inc;
   binc = b.inc;
   cinc = c.inc;

   for (i = 0; i < n; i++)
     {
	zp[i] = (*f)(*ap, *bp, *cp, m);
	ap += ainc;
	bp += binc;
	cp += cinc;
     }

   (void) SLang_push_array (atz, 1);
   SLang_free_array (a.at);
   SLang_free_array (b.at);
   SLang_free_array (c.at);
}

static void do_d_ddddm (double (*f)(double, double, double, double, gsl_mode_t),
			gsl_mode_t m)
{
   SLGSL_Double_Array_Type a, b, c, d;
   SLang_Array_Type *atz;
   unsigned int i, n;
   double *ap, *bp, *cp, *dp, *zp;
   unsigned int ainc, binc, cinc, dinc;

   if (-1 == slgsl_pop_dddd_array (&a, &b, &c, &d, 0))
     return;

   if ((NULL == (atz = a.at))
       && (NULL == (atz = b.at))
       && (NULL == (atz = c.at))
       && (NULL == (atz = d.at)))
     {
	(void) SLang_push_double ((*f)(a.x, b.x, c.x, d.x, m));
	return;
     }

   atz = SLang_create_array (SLANG_DOUBLE_TYPE, 0, NULL, atz->dims, atz->num_dims);
   if (atz == NULL)
     {
	SLang_free_array (a.at);
	SLang_free_array (b.at);
	SLang_free_array (c.at);
	SLang_free_array (d.at);
	return;
     }

   n = atz->num_elements;
   zp = (double *) atz->data;
   ap = a.xp;
   bp = b.xp;
   cp = c.xp;
   dp = d.xp;
   ainc = a.inc;
   binc = b.inc;
   cinc = c.inc;
   dinc = d.inc;

   for (i = 0; i < n; i++)
     {
	zp[i] = (*f)(*ap, *bp, *cp, *dp, m);
	ap += ainc;
	bp += binc;
	cp += cinc;
	dp += dinc;
     }

   (void) SLang_push_array (atz, 1);
   SLang_free_array (a.at);
   SLang_free_array (b.at);
   SLang_free_array (c.at);
   SLang_free_array (d.at);
}

static void do_d_dm_fun (const char *fun, double (*f)(double, gsl_mode_t))
{
   gsl_mode_t m;

   if (SLang_Num_Function_Args < 1)
     {
	SLang_verror (SL_USAGE_ERROR, "Usage: y=%s(double[,mode])", fun);
	return;
     }
   if (-1 == get_gsl_mode (&m, SLang_Num_Function_Args-1))
     return;

   slgsl_reset_errors ();
   do_d_dm (f,m);
   slgsl_check_errors (fun);
}

static void do_d_ddm_fun (const char *fun, double (*f)(double, double, gsl_mode_t))
{
   gsl_mode_t m;
   if (SLang_Num_Function_Args < 2)
     {
	SLang_verror (SL_USAGE_ERROR, "Usage: y=%s(double, double [,mode])", fun);
	return;
     }
   if (-1 == get_gsl_mode (&m, SLang_Num_Function_Args-2))
     return;
   slgsl_reset_errors ();
   do_d_ddm (f,m);
   slgsl_check_errors (fun);
}

static void do_d_dddm_fun (const char *fun, double (*f)(double, double, double, gsl_mode_t))
{
   gsl_mode_t m;
   if (SLang_Num_Function_Args < 3)
     {
	SLang_verror (SL_USAGE_ERROR, "Usage: y=%s(double, double, double[,mode])", fun);
	return;
     }
   if (-1 == get_gsl_mode (&m, SLang_Num_Function_Args-3))
     return;
   slgsl_reset_errors ();
   do_d_dddm (f,m);
   slgsl_check_errors (fun);
}

static void do_d_ddddm_fun (const char *fun, double (*f)(double,double,double,double,gsl_mode_t))
{
   gsl_mode_t m;

   if (SLang_Num_Function_Args < 4)
     {
	SLang_verror (SL_USAGE_ERROR, "Usage: y=%s(double, double, double, double [,mode])", fun);
	return;
     }
   if (-1 == get_gsl_mode (&m, SLang_Num_Function_Args-4))
     return;
   slgsl_reset_errors ();
   do_d_ddddm (f,m);
   slgsl_check_errors (fun);
}
#endif				       /* _GSLSF_MODULE_C_ */

/* Macros to aid in wrapping the functions */
#define SLF(f) f##_intrin

#define D_FD(f,n) \
     static void SLF(f) (void) { slgsl_do_d_d_fun (n,f); }
#define D_FDD(f,n) \
     static void SLF(f) (void) { slgsl_do_d_dd_fun (n,f); }
#define D_FDDD(f,n) \
     static void SLF(f) (void) { slgsl_do_d_ddd_fun (n,f); }
#define D_FDDDD(f,n) \
     static void SLF(f) (void) { slgsl_do_d_dddd_fun (n,f); }
#define D_FDM(f,n) \
     static void SLF(f) (void) { do_d_dm_fun (n,f); }
#define D_FDDM(f,n) \
     static void SLF(f) (void) { do_d_ddm_fun (n,f); }
#define D_FDDDM(f,n) \
     static void SLF(f) (void) { do_d_dddm_fun (n,f); }
#define D_FDDDDM(f,n) \
     static void SLF(f) (void) { do_d_ddddm_fun (n,f); }
#define D_FI(f,n) \
     static void SLF(f) (void) { slgsl_do_d_i_fun (n,f); }
#define D_FID(f,n) \
     static void SLF(f) (void) { slgsl_do_d_id_fun (n,f); }
#define D_FIDD(f,n) \
     static void SLF(f) (void) { slgsl_do_d_idd_fun (n,f); }
#define D_FIID(f,n) \
     static void SLF(f) (void) { slgsl_do_d_iid_fun (n,f); }
#define D_FIIDD(f,n) \
     static void SLF(f) (void) { slgsl_do_d_iidd_fun (n,f); }
#define I_FD(f,n) \
     static void SLF(f) (void) { slgsl_do_i_d_fun (n,f); }

/*}}}*/

#define V SLANG_VOID_TYPE
static SLang_Intrin_Fun_Type Module_Intrinsics [] =
{
#ifdef _GSLSF_MODULE_C_
   MAKE_INTRINSIC_0("gslsf_get_precision", get_gsl_precision, SLANG_INT_TYPE),
   MAKE_INTRINSIC_I("gslsf_set_precision", set_gsl_precision, SLANG_VOID_TYPE),
#endif
   SLANG_END_INTRIN_FUN_TABLE
};
#undef V
#endif				       /* MODULE_HAS_INTRINSICS */

static SLang_Intrin_Var_Type Module_Variables [] =
{
   MAKE_VARIABLE("_gslconst_module_version_string", &Module_Version_String, SLANG_STRING_TYPE, 1),
   MAKE_VARIABLE("GSL_VERSION", &gsl_version, SLANG_STRING_TYPE, 1),
   SLANG_END_INTRIN_VAR_TABLE
};

static SLang_IConstant_Type Module_IConstants [] =
{
   MAKE_ICONSTANT("_gslconst_module_version", MODULE_VERSION_NUMBER),
#ifdef _GSLSF_MODULE_C_
   MAKE_ICONSTANT("GSL_PREC_SINGLE", GSL_PREC_SINGLE),
   MAKE_ICONSTANT("GSL_PREC_DOUBLE", GSL_PREC_DOUBLE),
   MAKE_ICONSTANT("GSL_PREC_APPROX", GSL_PREC_APPROX),
#endif
   SLANG_END_ICONST_TABLE
};

#ifdef MODULE_HAS_DCONSTANTS
static SLang_DConstant_Type Module_DConstants [] =
{
#ifdef GSL_CONST_CGSM_ACRE
   MAKE_DCONSTANT("CONST_CGSM_ACRE", GSL_CONST_CGSM_ACRE),
#endif
#ifdef GSL_CONST_CGSM_ANGSTROM
   MAKE_DCONSTANT("CONST_CGSM_ANGSTROM", GSL_CONST_CGSM_ANGSTROM),
#endif
#ifdef GSL_CONST_CGSM_ASTRONOMICAL_UNIT
   MAKE_DCONSTANT("CONST_CGSM_ASTRONOMICAL_UNIT", GSL_CONST_CGSM_ASTRONOMICAL_UNIT),
#endif
#ifdef GSL_CONST_CGSM_BAR
   MAKE_DCONSTANT("CONST_CGSM_BAR", GSL_CONST_CGSM_BAR),
#endif
#ifdef GSL_CONST_CGSM_BARN
   MAKE_DCONSTANT("CONST_CGSM_BARN", GSL_CONST_CGSM_BARN),
#endif
#ifdef GSL_CONST_CGSM_BOHR_MAGNETON
   MAKE_DCONSTANT("CONST_CGSM_BOHR_MAGNETON", GSL_CONST_CGSM_BOHR_MAGNETON),
#endif
#ifdef GSL_CONST_CGSM_BOHR_RADIUS
   MAKE_DCONSTANT("CONST_CGSM_BOHR_RADIUS", GSL_CONST_CGSM_BOHR_RADIUS),
#endif
#ifdef GSL_CONST_CGSM_BOLTZMANN
   MAKE_DCONSTANT("CONST_CGSM_BOLTZMANN", GSL_CONST_CGSM_BOLTZMANN),
#endif
#ifdef GSL_CONST_CGSM_BTU
   MAKE_DCONSTANT("CONST_CGSM_BTU", GSL_CONST_CGSM_BTU),
#endif
#ifdef GSL_CONST_CGSM_CALORIE
   MAKE_DCONSTANT("CONST_CGSM_CALORIE", GSL_CONST_CGSM_CALORIE),
#endif
#ifdef GSL_CONST_CGSM_CANADIAN_GALLON
   MAKE_DCONSTANT("CONST_CGSM_CANADIAN_GALLON", GSL_CONST_CGSM_CANADIAN_GALLON),
#endif
#ifdef GSL_CONST_CGSM_CARAT
   MAKE_DCONSTANT("CONST_CGSM_CARAT", GSL_CONST_CGSM_CARAT),
#endif
#ifdef GSL_CONST_CGSM_CUP
   MAKE_DCONSTANT("CONST_CGSM_CUP", GSL_CONST_CGSM_CUP),
#endif
#ifdef GSL_CONST_CGSM_CURIE
   MAKE_DCONSTANT("CONST_CGSM_CURIE", GSL_CONST_CGSM_CURIE),
#endif
#ifdef GSL_CONST_CGSM_DAY
   MAKE_DCONSTANT("CONST_CGSM_DAY", GSL_CONST_CGSM_DAY),
#endif
#ifdef GSL_CONST_CGSM_DYNE
   MAKE_DCONSTANT("CONST_CGSM_DYNE", GSL_CONST_CGSM_DYNE),
#endif
#ifdef GSL_CONST_CGSM_ELECTRON_CHARGE
   MAKE_DCONSTANT("CONST_CGSM_ELECTRON_CHARGE", GSL_CONST_CGSM_ELECTRON_CHARGE),
#endif
#ifdef GSL_CONST_CGSM_ELECTRON_MAGNETIC_MOMENT
   MAKE_DCONSTANT("CONST_CGSM_ELECTRON_MAGNETIC_MOMENT", GSL_CONST_CGSM_ELECTRON_MAGNETIC_MOMENT),
#endif
#ifdef GSL_CONST_CGSM_ELECTRON_VOLT
   MAKE_DCONSTANT("CONST_CGSM_ELECTRON_VOLT", GSL_CONST_CGSM_ELECTRON_VOLT),
#endif
#ifdef GSL_CONST_CGSM_ERG
   MAKE_DCONSTANT("CONST_CGSM_ERG", GSL_CONST_CGSM_ERG),
#endif
#ifdef GSL_CONST_CGSM_FARADAY
   MAKE_DCONSTANT("CONST_CGSM_FARADAY", GSL_CONST_CGSM_FARADAY),
#endif
#ifdef GSL_CONST_CGSM_FATHOM
   MAKE_DCONSTANT("CONST_CGSM_FATHOM", GSL_CONST_CGSM_FATHOM),
#endif
#ifdef GSL_CONST_CGSM_FLUID_OUNCE
   MAKE_DCONSTANT("CONST_CGSM_FLUID_OUNCE", GSL_CONST_CGSM_FLUID_OUNCE),
#endif
#ifdef GSL_CONST_CGSM_FOOT
   MAKE_DCONSTANT("CONST_CGSM_FOOT", GSL_CONST_CGSM_FOOT),
#endif
#ifdef GSL_CONST_CGSM_FOOTCANDLE
   MAKE_DCONSTANT("CONST_CGSM_FOOTCANDLE", GSL_CONST_CGSM_FOOTCANDLE),
#endif
#ifdef GSL_CONST_CGSM_FOOTLAMBERT
   MAKE_DCONSTANT("CONST_CGSM_FOOTLAMBERT", GSL_CONST_CGSM_FOOTLAMBERT),
#endif
#ifdef GSL_CONST_CGSM_GRAM_FORCE
   MAKE_DCONSTANT("CONST_CGSM_GRAM_FORCE", GSL_CONST_CGSM_GRAM_FORCE),
#endif
#ifdef GSL_CONST_CGSM_GRAVITATIONAL_CONSTANT
   MAKE_DCONSTANT("CONST_CGSM_GRAVITATIONAL_CONSTANT", GSL_CONST_CGSM_GRAVITATIONAL_CONSTANT),
#endif
#ifdef GSL_CONST_CGSM_GRAV_ACCEL
   MAKE_DCONSTANT("CONST_CGSM_GRAV_ACCEL", GSL_CONST_CGSM_GRAV_ACCEL),
#endif
#ifdef GSL_CONST_CGSM_HECTARE
   MAKE_DCONSTANT("CONST_CGSM_HECTARE", GSL_CONST_CGSM_HECTARE),
#endif
#ifdef GSL_CONST_CGSM_HORSEPOWER
   MAKE_DCONSTANT("CONST_CGSM_HORSEPOWER", GSL_CONST_CGSM_HORSEPOWER),
#endif
#ifdef GSL_CONST_CGSM_HOUR
   MAKE_DCONSTANT("CONST_CGSM_HOUR", GSL_CONST_CGSM_HOUR),
#endif
#ifdef GSL_CONST_CGSM_INCH
   MAKE_DCONSTANT("CONST_CGSM_INCH", GSL_CONST_CGSM_INCH),
#endif
#ifdef GSL_CONST_CGSM_INCH_OF_MERCURY
   MAKE_DCONSTANT("CONST_CGSM_INCH_OF_MERCURY", GSL_CONST_CGSM_INCH_OF_MERCURY),
#endif
#ifdef GSL_CONST_CGSM_INCH_OF_WATER
   MAKE_DCONSTANT("CONST_CGSM_INCH_OF_WATER", GSL_CONST_CGSM_INCH_OF_WATER),
#endif
#ifdef GSL_CONST_CGSM_JOULE
   MAKE_DCONSTANT("CONST_CGSM_JOULE", GSL_CONST_CGSM_JOULE),
#endif
#ifdef GSL_CONST_CGSM_KILOMETERS_PER_HOUR
   MAKE_DCONSTANT("CONST_CGSM_KILOMETERS_PER_HOUR", GSL_CONST_CGSM_KILOMETERS_PER_HOUR),
#endif
#ifdef GSL_CONST_CGSM_KILOPOUND_FORCE
   MAKE_DCONSTANT("CONST_CGSM_KILOPOUND_FORCE", GSL_CONST_CGSM_KILOPOUND_FORCE),
#endif
#ifdef GSL_CONST_CGSM_KNOT
   MAKE_DCONSTANT("CONST_CGSM_KNOT", GSL_CONST_CGSM_KNOT),
#endif
#ifdef GSL_CONST_CGSM_LAMBERT
   MAKE_DCONSTANT("CONST_CGSM_LAMBERT", GSL_CONST_CGSM_LAMBERT),
#endif
#ifdef GSL_CONST_CGSM_LIGHT_YEAR
   MAKE_DCONSTANT("CONST_CGSM_LIGHT_YEAR", GSL_CONST_CGSM_LIGHT_YEAR),
#endif
#ifdef GSL_CONST_CGSM_LITER
   MAKE_DCONSTANT("CONST_CGSM_LITER", GSL_CONST_CGSM_LITER),
#endif
#ifdef GSL_CONST_CGSM_LUMEN
   MAKE_DCONSTANT("CONST_CGSM_LUMEN", GSL_CONST_CGSM_LUMEN),
#endif
#ifdef GSL_CONST_CGSM_LUX
   MAKE_DCONSTANT("CONST_CGSM_LUX", GSL_CONST_CGSM_LUX),
#endif
#ifdef GSL_CONST_CGSM_MASS_ELECTRON
   MAKE_DCONSTANT("CONST_CGSM_MASS_ELECTRON", GSL_CONST_CGSM_MASS_ELECTRON),
#endif
#ifdef GSL_CONST_CGSM_MASS_MUON
   MAKE_DCONSTANT("CONST_CGSM_MASS_MUON", GSL_CONST_CGSM_MASS_MUON),
#endif
#ifdef GSL_CONST_CGSM_MASS_NEUTRON
   MAKE_DCONSTANT("CONST_CGSM_MASS_NEUTRON", GSL_CONST_CGSM_MASS_NEUTRON),
#endif
#ifdef GSL_CONST_CGSM_MASS_PROTON
   MAKE_DCONSTANT("CONST_CGSM_MASS_PROTON", GSL_CONST_CGSM_MASS_PROTON),
#endif
#ifdef GSL_CONST_CGSM_METER_OF_MERCURY
   MAKE_DCONSTANT("CONST_CGSM_METER_OF_MERCURY", GSL_CONST_CGSM_METER_OF_MERCURY),
#endif
#ifdef GSL_CONST_CGSM_METRIC_TON
   MAKE_DCONSTANT("CONST_CGSM_METRIC_TON", GSL_CONST_CGSM_METRIC_TON),
#endif
#ifdef GSL_CONST_CGSM_MICRON
   MAKE_DCONSTANT("CONST_CGSM_MICRON", GSL_CONST_CGSM_MICRON),
#endif
#ifdef GSL_CONST_CGSM_MIL
   MAKE_DCONSTANT("CONST_CGSM_MIL", GSL_CONST_CGSM_MIL),
#endif
#ifdef GSL_CONST_CGSM_MILE
   MAKE_DCONSTANT("CONST_CGSM_MILE", GSL_CONST_CGSM_MILE),
#endif
#ifdef GSL_CONST_CGSM_MILES_PER_HOUR
   MAKE_DCONSTANT("CONST_CGSM_MILES_PER_HOUR", GSL_CONST_CGSM_MILES_PER_HOUR),
#endif
#ifdef GSL_CONST_CGSM_MINUTE
   MAKE_DCONSTANT("CONST_CGSM_MINUTE", GSL_CONST_CGSM_MINUTE),
#endif
#ifdef GSL_CONST_CGSM_MOLAR_GAS
   MAKE_DCONSTANT("CONST_CGSM_MOLAR_GAS", GSL_CONST_CGSM_MOLAR_GAS),
#endif
#ifdef GSL_CONST_CGSM_NAUTICAL_MILE
   MAKE_DCONSTANT("CONST_CGSM_NAUTICAL_MILE", GSL_CONST_CGSM_NAUTICAL_MILE),
#endif
#ifdef GSL_CONST_CGSM_NEWTON
   MAKE_DCONSTANT("CONST_CGSM_NEWTON", GSL_CONST_CGSM_NEWTON),
#endif
#ifdef GSL_CONST_CGSM_NUCLEAR_MAGNETON
   MAKE_DCONSTANT("CONST_CGSM_NUCLEAR_MAGNETON", GSL_CONST_CGSM_NUCLEAR_MAGNETON),
#endif
#ifdef GSL_CONST_CGSM_OUNCE_MASS
   MAKE_DCONSTANT("CONST_CGSM_OUNCE_MASS", GSL_CONST_CGSM_OUNCE_MASS),
#endif
#ifdef GSL_CONST_CGSM_PARSEC
   MAKE_DCONSTANT("CONST_CGSM_PARSEC", GSL_CONST_CGSM_PARSEC),
#endif
#ifdef GSL_CONST_CGSM_PHOT
   MAKE_DCONSTANT("CONST_CGSM_PHOT", GSL_CONST_CGSM_PHOT),
#endif
#ifdef GSL_CONST_CGSM_PINT
   MAKE_DCONSTANT("CONST_CGSM_PINT", GSL_CONST_CGSM_PINT),
#endif
#ifdef GSL_CONST_CGSM_PLANCKS_CONSTANT_H
   MAKE_DCONSTANT("CONST_CGSM_PLANCKS_CONSTANT_H", GSL_CONST_CGSM_PLANCKS_CONSTANT_H),
#endif
#ifdef GSL_CONST_CGSM_PLANCKS_CONSTANT_HBAR
   MAKE_DCONSTANT("CONST_CGSM_PLANCKS_CONSTANT_HBAR", GSL_CONST_CGSM_PLANCKS_CONSTANT_HBAR),
#endif
#ifdef GSL_CONST_CGSM_POINT
   MAKE_DCONSTANT("CONST_CGSM_POINT", GSL_CONST_CGSM_POINT),
#endif
#ifdef GSL_CONST_CGSM_POISE
   MAKE_DCONSTANT("CONST_CGSM_POISE", GSL_CONST_CGSM_POISE),
#endif
#ifdef GSL_CONST_CGSM_POUNDAL
   MAKE_DCONSTANT("CONST_CGSM_POUNDAL", GSL_CONST_CGSM_POUNDAL),
#endif
#ifdef GSL_CONST_CGSM_POUND_FORCE
   MAKE_DCONSTANT("CONST_CGSM_POUND_FORCE", GSL_CONST_CGSM_POUND_FORCE),
#endif
#ifdef GSL_CONST_CGSM_POUND_MASS
   MAKE_DCONSTANT("CONST_CGSM_POUND_MASS", GSL_CONST_CGSM_POUND_MASS),
#endif
#ifdef GSL_CONST_CGSM_PROTON_MAGNETIC_MOMENT
   MAKE_DCONSTANT("CONST_CGSM_PROTON_MAGNETIC_MOMENT", GSL_CONST_CGSM_PROTON_MAGNETIC_MOMENT),
#endif
#ifdef GSL_CONST_CGSM_PSI
   MAKE_DCONSTANT("CONST_CGSM_PSI", GSL_CONST_CGSM_PSI),
#endif
#ifdef GSL_CONST_CGSM_QUART
   MAKE_DCONSTANT("CONST_CGSM_QUART", GSL_CONST_CGSM_QUART),
#endif
#ifdef GSL_CONST_CGSM_RAD
   MAKE_DCONSTANT("CONST_CGSM_RAD", GSL_CONST_CGSM_RAD),
#endif
#ifdef GSL_CONST_CGSM_ROENTGEN
   MAKE_DCONSTANT("CONST_CGSM_ROENTGEN", GSL_CONST_CGSM_ROENTGEN),
#endif
#ifdef GSL_CONST_CGSM_RYDBERG
   MAKE_DCONSTANT("CONST_CGSM_RYDBERG", GSL_CONST_CGSM_RYDBERG),
#endif
#ifdef GSL_CONST_CGSM_SOLAR_MASS
   MAKE_DCONSTANT("CONST_CGSM_SOLAR_MASS", GSL_CONST_CGSM_SOLAR_MASS),
#endif
#ifdef GSL_CONST_CGSM_SPEED_OF_LIGHT
   MAKE_DCONSTANT("CONST_CGSM_SPEED_OF_LIGHT", GSL_CONST_CGSM_SPEED_OF_LIGHT),
#endif
#ifdef GSL_CONST_CGSM_STANDARD_GAS_VOLUME
   MAKE_DCONSTANT("CONST_CGSM_STANDARD_GAS_VOLUME", GSL_CONST_CGSM_STANDARD_GAS_VOLUME),
#endif
#ifdef GSL_CONST_CGSM_STD_ATMOSPHERE
   MAKE_DCONSTANT("CONST_CGSM_STD_ATMOSPHERE", GSL_CONST_CGSM_STD_ATMOSPHERE),
#endif
#ifdef GSL_CONST_CGSM_STEFAN_BOLTZMANN_CONSTANT
   MAKE_DCONSTANT("CONST_CGSM_STEFAN_BOLTZMANN_CONSTANT", GSL_CONST_CGSM_STEFAN_BOLTZMANN_CONSTANT),
#endif
#ifdef GSL_CONST_CGSM_STILB
   MAKE_DCONSTANT("CONST_CGSM_STILB", GSL_CONST_CGSM_STILB),
#endif
#ifdef GSL_CONST_CGSM_STOKES
   MAKE_DCONSTANT("CONST_CGSM_STOKES", GSL_CONST_CGSM_STOKES),
#endif
#ifdef GSL_CONST_CGSM_TABLESPOON
   MAKE_DCONSTANT("CONST_CGSM_TABLESPOON", GSL_CONST_CGSM_TABLESPOON),
#endif
#ifdef GSL_CONST_CGSM_TEASPOON
   MAKE_DCONSTANT("CONST_CGSM_TEASPOON", GSL_CONST_CGSM_TEASPOON),
#endif
#ifdef GSL_CONST_CGSM_TEXPOINT
   MAKE_DCONSTANT("CONST_CGSM_TEXPOINT", GSL_CONST_CGSM_TEXPOINT),
#endif
#ifdef GSL_CONST_CGSM_THERM
   MAKE_DCONSTANT("CONST_CGSM_THERM", GSL_CONST_CGSM_THERM),
#endif
#ifdef GSL_CONST_CGSM_THOMSON_CROSS_SECTION
   MAKE_DCONSTANT("CONST_CGSM_THOMSON_CROSS_SECTION", GSL_CONST_CGSM_THOMSON_CROSS_SECTION),
#endif
#ifdef GSL_CONST_CGSM_TON
   MAKE_DCONSTANT("CONST_CGSM_TON", GSL_CONST_CGSM_TON),
#endif
#ifdef GSL_CONST_CGSM_TORR
   MAKE_DCONSTANT("CONST_CGSM_TORR", GSL_CONST_CGSM_TORR),
#endif
#ifdef GSL_CONST_CGSM_TROY_OUNCE
   MAKE_DCONSTANT("CONST_CGSM_TROY_OUNCE", GSL_CONST_CGSM_TROY_OUNCE),
#endif
#ifdef GSL_CONST_CGSM_UK_GALLON
   MAKE_DCONSTANT("CONST_CGSM_UK_GALLON", GSL_CONST_CGSM_UK_GALLON),
#endif
#ifdef GSL_CONST_CGSM_UK_TON
   MAKE_DCONSTANT("CONST_CGSM_UK_TON", GSL_CONST_CGSM_UK_TON),
#endif
#ifdef GSL_CONST_CGSM_UNIFIED_ATOMIC_MASS
   MAKE_DCONSTANT("CONST_CGSM_UNIFIED_ATOMIC_MASS", GSL_CONST_CGSM_UNIFIED_ATOMIC_MASS),
#endif
#ifdef GSL_CONST_CGSM_US_GALLON
   MAKE_DCONSTANT("CONST_CGSM_US_GALLON", GSL_CONST_CGSM_US_GALLON),
#endif
#ifdef GSL_CONST_CGSM_WEEK
   MAKE_DCONSTANT("CONST_CGSM_WEEK", GSL_CONST_CGSM_WEEK),
#endif
#ifdef GSL_CONST_CGSM_YARD
   MAKE_DCONSTANT("CONST_CGSM_YARD", GSL_CONST_CGSM_YARD),
#endif
#ifdef GSL_CONST_CGS_ACRE
   MAKE_DCONSTANT("CONST_CGS_ACRE", GSL_CONST_CGS_ACRE),
#endif
#ifdef GSL_CONST_CGS_ANGSTROM
   MAKE_DCONSTANT("CONST_CGS_ANGSTROM", GSL_CONST_CGS_ANGSTROM),
#endif
#ifdef GSL_CONST_CGS_ASTRONOMICAL_UNIT
   MAKE_DCONSTANT("CONST_CGS_ASTRONOMICAL_UNIT", GSL_CONST_CGS_ASTRONOMICAL_UNIT),
#endif
#ifdef GSL_CONST_CGS_BAR
   MAKE_DCONSTANT("CONST_CGS_BAR", GSL_CONST_CGS_BAR),
#endif
#ifdef GSL_CONST_CGS_BARN
   MAKE_DCONSTANT("CONST_CGS_BARN", GSL_CONST_CGS_BARN),
#endif
#ifdef GSL_CONST_CGS_BOHR_RADIUS
   MAKE_DCONSTANT("CONST_CGS_BOHR_RADIUS", GSL_CONST_CGS_BOHR_RADIUS),
#endif
#ifdef GSL_CONST_CGS_BOLTZMANN
   MAKE_DCONSTANT("CONST_CGS_BOLTZMANN", GSL_CONST_CGS_BOLTZMANN),
#endif
#ifdef GSL_CONST_CGS_BTU
   MAKE_DCONSTANT("CONST_CGS_BTU", GSL_CONST_CGS_BTU),
#endif
#ifdef GSL_CONST_CGS_CALORIE
   MAKE_DCONSTANT("CONST_CGS_CALORIE", GSL_CONST_CGS_CALORIE),
#endif
#ifdef GSL_CONST_CGS_CANADIAN_GALLON
   MAKE_DCONSTANT("CONST_CGS_CANADIAN_GALLON", GSL_CONST_CGS_CANADIAN_GALLON),
#endif
#ifdef GSL_CONST_CGS_CARAT
   MAKE_DCONSTANT("CONST_CGS_CARAT", GSL_CONST_CGS_CARAT),
#endif
#ifdef GSL_CONST_CGS_CUP
   MAKE_DCONSTANT("CONST_CGS_CUP", GSL_CONST_CGS_CUP),
#endif
#ifdef GSL_CONST_CGS_CURIE
   MAKE_DCONSTANT("CONST_CGS_CURIE", GSL_CONST_CGS_CURIE),
#endif
#ifdef GSL_CONST_CGS_DAY
   MAKE_DCONSTANT("CONST_CGS_DAY", GSL_CONST_CGS_DAY),
#endif
#ifdef GSL_CONST_CGS_DYNE
   MAKE_DCONSTANT("CONST_CGS_DYNE", GSL_CONST_CGS_DYNE),
#endif
#ifdef GSL_CONST_CGS_ELECTRON_VOLT
   MAKE_DCONSTANT("CONST_CGS_ELECTRON_VOLT", GSL_CONST_CGS_ELECTRON_VOLT),
#endif
#ifdef GSL_CONST_CGS_ERG
   MAKE_DCONSTANT("CONST_CGS_ERG", GSL_CONST_CGS_ERG),
#endif
#ifdef GSL_CONST_CGS_FATHOM
   MAKE_DCONSTANT("CONST_CGS_FATHOM", GSL_CONST_CGS_FATHOM),
#endif
#ifdef GSL_CONST_CGS_FLUID_OUNCE
   MAKE_DCONSTANT("CONST_CGS_FLUID_OUNCE", GSL_CONST_CGS_FLUID_OUNCE),
#endif
#ifdef GSL_CONST_CGS_FOOT
   MAKE_DCONSTANT("CONST_CGS_FOOT", GSL_CONST_CGS_FOOT),
#endif
#ifdef GSL_CONST_CGS_FOOTCANDLE
   MAKE_DCONSTANT("CONST_CGS_FOOTCANDLE", GSL_CONST_CGS_FOOTCANDLE),
#endif
#ifdef GSL_CONST_CGS_FOOTLAMBERT
   MAKE_DCONSTANT("CONST_CGS_FOOTLAMBERT", GSL_CONST_CGS_FOOTLAMBERT),
#endif
#ifdef GSL_CONST_CGS_GRAM_FORCE
   MAKE_DCONSTANT("CONST_CGS_GRAM_FORCE", GSL_CONST_CGS_GRAM_FORCE),
#endif
#ifdef GSL_CONST_CGS_GRAVITATIONAL_CONSTANT
   MAKE_DCONSTANT("CONST_CGS_GRAVITATIONAL_CONSTANT", GSL_CONST_CGS_GRAVITATIONAL_CONSTANT),
#endif
#ifdef GSL_CONST_CGS_GRAV_ACCEL
   MAKE_DCONSTANT("CONST_CGS_GRAV_ACCEL", GSL_CONST_CGS_GRAV_ACCEL),
#endif
#ifdef GSL_CONST_CGS_HECTARE
   MAKE_DCONSTANT("CONST_CGS_HECTARE", GSL_CONST_CGS_HECTARE),
#endif
#ifdef GSL_CONST_CGS_HORSEPOWER
   MAKE_DCONSTANT("CONST_CGS_HORSEPOWER", GSL_CONST_CGS_HORSEPOWER),
#endif
#ifdef GSL_CONST_CGS_HOUR
   MAKE_DCONSTANT("CONST_CGS_HOUR", GSL_CONST_CGS_HOUR),
#endif
#ifdef GSL_CONST_CGS_INCH
   MAKE_DCONSTANT("CONST_CGS_INCH", GSL_CONST_CGS_INCH),
#endif
#ifdef GSL_CONST_CGS_INCH_OF_MERCURY
   MAKE_DCONSTANT("CONST_CGS_INCH_OF_MERCURY", GSL_CONST_CGS_INCH_OF_MERCURY),
#endif
#ifdef GSL_CONST_CGS_INCH_OF_WATER
   MAKE_DCONSTANT("CONST_CGS_INCH_OF_WATER", GSL_CONST_CGS_INCH_OF_WATER),
#endif
#ifdef GSL_CONST_CGS_JOULE
   MAKE_DCONSTANT("CONST_CGS_JOULE", GSL_CONST_CGS_JOULE),
#endif
#ifdef GSL_CONST_CGS_KILOMETERS_PER_HOUR
   MAKE_DCONSTANT("CONST_CGS_KILOMETERS_PER_HOUR", GSL_CONST_CGS_KILOMETERS_PER_HOUR),
#endif
#ifdef GSL_CONST_CGS_KILOPOUND_FORCE
   MAKE_DCONSTANT("CONST_CGS_KILOPOUND_FORCE", GSL_CONST_CGS_KILOPOUND_FORCE),
#endif
#ifdef GSL_CONST_CGS_KNOT
   MAKE_DCONSTANT("CONST_CGS_KNOT", GSL_CONST_CGS_KNOT),
#endif
#ifdef GSL_CONST_CGS_LAMBERT
   MAKE_DCONSTANT("CONST_CGS_LAMBERT", GSL_CONST_CGS_LAMBERT),
#endif
#ifdef GSL_CONST_CGS_LIGHT_YEAR
   MAKE_DCONSTANT("CONST_CGS_LIGHT_YEAR", GSL_CONST_CGS_LIGHT_YEAR),
#endif
#ifdef GSL_CONST_CGS_LITER
   MAKE_DCONSTANT("CONST_CGS_LITER", GSL_CONST_CGS_LITER),
#endif
#ifdef GSL_CONST_CGS_LUMEN
   MAKE_DCONSTANT("CONST_CGS_LUMEN", GSL_CONST_CGS_LUMEN),
#endif
#ifdef GSL_CONST_CGS_LUX
   MAKE_DCONSTANT("CONST_CGS_LUX", GSL_CONST_CGS_LUX),
#endif
#ifdef GSL_CONST_CGS_MASS_ELECTRON
   MAKE_DCONSTANT("CONST_CGS_MASS_ELECTRON", GSL_CONST_CGS_MASS_ELECTRON),
#endif
#ifdef GSL_CONST_CGS_MASS_MUON
   MAKE_DCONSTANT("CONST_CGS_MASS_MUON", GSL_CONST_CGS_MASS_MUON),
#endif
#ifdef GSL_CONST_CGS_MASS_NEUTRON
   MAKE_DCONSTANT("CONST_CGS_MASS_NEUTRON", GSL_CONST_CGS_MASS_NEUTRON),
#endif
#ifdef GSL_CONST_CGS_MASS_PROTON
   MAKE_DCONSTANT("CONST_CGS_MASS_PROTON", GSL_CONST_CGS_MASS_PROTON),
#endif
#ifdef GSL_CONST_CGS_METER_OF_MERCURY
   MAKE_DCONSTANT("CONST_CGS_METER_OF_MERCURY", GSL_CONST_CGS_METER_OF_MERCURY),
#endif
#ifdef GSL_CONST_CGS_METRIC_TON
   MAKE_DCONSTANT("CONST_CGS_METRIC_TON", GSL_CONST_CGS_METRIC_TON),
#endif
#ifdef GSL_CONST_CGS_MICRON
   MAKE_DCONSTANT("CONST_CGS_MICRON", GSL_CONST_CGS_MICRON),
#endif
#ifdef GSL_CONST_CGS_MIL
   MAKE_DCONSTANT("CONST_CGS_MIL", GSL_CONST_CGS_MIL),
#endif
#ifdef GSL_CONST_CGS_MILE
   MAKE_DCONSTANT("CONST_CGS_MILE", GSL_CONST_CGS_MILE),
#endif
#ifdef GSL_CONST_CGS_MILES_PER_HOUR
   MAKE_DCONSTANT("CONST_CGS_MILES_PER_HOUR", GSL_CONST_CGS_MILES_PER_HOUR),
#endif
#ifdef GSL_CONST_CGS_MINUTE
   MAKE_DCONSTANT("CONST_CGS_MINUTE", GSL_CONST_CGS_MINUTE),
#endif
#ifdef GSL_CONST_CGS_MOLAR_GAS
   MAKE_DCONSTANT("CONST_CGS_MOLAR_GAS", GSL_CONST_CGS_MOLAR_GAS),
#endif
#ifdef GSL_CONST_CGS_NAUTICAL_MILE
   MAKE_DCONSTANT("CONST_CGS_NAUTICAL_MILE", GSL_CONST_CGS_NAUTICAL_MILE),
#endif
#ifdef GSL_CONST_CGS_NEWTON
   MAKE_DCONSTANT("CONST_CGS_NEWTON", GSL_CONST_CGS_NEWTON),
#endif
#ifdef GSL_CONST_CGS_OUNCE_MASS
   MAKE_DCONSTANT("CONST_CGS_OUNCE_MASS", GSL_CONST_CGS_OUNCE_MASS),
#endif
#ifdef GSL_CONST_CGS_PARSEC
   MAKE_DCONSTANT("CONST_CGS_PARSEC", GSL_CONST_CGS_PARSEC),
#endif
#ifdef GSL_CONST_CGS_PHOT
   MAKE_DCONSTANT("CONST_CGS_PHOT", GSL_CONST_CGS_PHOT),
#endif
#ifdef GSL_CONST_CGS_PINT
   MAKE_DCONSTANT("CONST_CGS_PINT", GSL_CONST_CGS_PINT),
#endif
#ifdef GSL_CONST_CGS_PLANCKS_CONSTANT_H
   MAKE_DCONSTANT("CONST_CGS_PLANCKS_CONSTANT_H", GSL_CONST_CGS_PLANCKS_CONSTANT_H),
#endif
#ifdef GSL_CONST_CGS_PLANCKS_CONSTANT_HBAR
   MAKE_DCONSTANT("CONST_CGS_PLANCKS_CONSTANT_HBAR", GSL_CONST_CGS_PLANCKS_CONSTANT_HBAR),
#endif
#ifdef GSL_CONST_CGS_POINT
   MAKE_DCONSTANT("CONST_CGS_POINT", GSL_CONST_CGS_POINT),
#endif
#ifdef GSL_CONST_CGS_POISE
   MAKE_DCONSTANT("CONST_CGS_POISE", GSL_CONST_CGS_POISE),
#endif
#ifdef GSL_CONST_CGS_POUNDAL
   MAKE_DCONSTANT("CONST_CGS_POUNDAL", GSL_CONST_CGS_POUNDAL),
#endif
#ifdef GSL_CONST_CGS_POUND_FORCE
   MAKE_DCONSTANT("CONST_CGS_POUND_FORCE", GSL_CONST_CGS_POUND_FORCE),
#endif
#ifdef GSL_CONST_CGS_POUND_MASS
   MAKE_DCONSTANT("CONST_CGS_POUND_MASS", GSL_CONST_CGS_POUND_MASS),
#endif
#ifdef GSL_CONST_CGS_PSI
   MAKE_DCONSTANT("CONST_CGS_PSI", GSL_CONST_CGS_PSI),
#endif
#ifdef GSL_CONST_CGS_QUART
   MAKE_DCONSTANT("CONST_CGS_QUART", GSL_CONST_CGS_QUART),
#endif
#ifdef GSL_CONST_CGS_RAD
   MAKE_DCONSTANT("CONST_CGS_RAD", GSL_CONST_CGS_RAD),
#endif
#ifdef GSL_CONST_CGS_ROENTGEN
   MAKE_DCONSTANT("CONST_CGS_ROENTGEN", GSL_CONST_CGS_ROENTGEN),
#endif
#ifdef GSL_CONST_CGS_RYDBERG
   MAKE_DCONSTANT("CONST_CGS_RYDBERG", GSL_CONST_CGS_RYDBERG),
#endif
#ifdef GSL_CONST_CGS_SOLAR_MASS
   MAKE_DCONSTANT("CONST_CGS_SOLAR_MASS", GSL_CONST_CGS_SOLAR_MASS),
#endif
#ifdef GSL_CONST_CGS_SPEED_OF_LIGHT
   MAKE_DCONSTANT("CONST_CGS_SPEED_OF_LIGHT", GSL_CONST_CGS_SPEED_OF_LIGHT),
#endif
#ifdef GSL_CONST_CGS_STANDARD_GAS_VOLUME
   MAKE_DCONSTANT("CONST_CGS_STANDARD_GAS_VOLUME", GSL_CONST_CGS_STANDARD_GAS_VOLUME),
#endif
#ifdef GSL_CONST_CGS_STD_ATMOSPHERE
   MAKE_DCONSTANT("CONST_CGS_STD_ATMOSPHERE", GSL_CONST_CGS_STD_ATMOSPHERE),
#endif
#ifdef GSL_CONST_CGS_STEFAN_BOLTZMANN_CONSTANT
   MAKE_DCONSTANT("CONST_CGS_STEFAN_BOLTZMANN_CONSTANT", GSL_CONST_CGS_STEFAN_BOLTZMANN_CONSTANT),
#endif
#ifdef GSL_CONST_CGS_STILB
   MAKE_DCONSTANT("CONST_CGS_STILB", GSL_CONST_CGS_STILB),
#endif
#ifdef GSL_CONST_CGS_STOKES
   MAKE_DCONSTANT("CONST_CGS_STOKES", GSL_CONST_CGS_STOKES),
#endif
#ifdef GSL_CONST_CGS_TABLESPOON
   MAKE_DCONSTANT("CONST_CGS_TABLESPOON", GSL_CONST_CGS_TABLESPOON),
#endif
#ifdef GSL_CONST_CGS_TEASPOON
   MAKE_DCONSTANT("CONST_CGS_TEASPOON", GSL_CONST_CGS_TEASPOON),
#endif
#ifdef GSL_CONST_CGS_TEXPOINT
   MAKE_DCONSTANT("CONST_CGS_TEXPOINT", GSL_CONST_CGS_TEXPOINT),
#endif
#ifdef GSL_CONST_CGS_THERM
   MAKE_DCONSTANT("CONST_CGS_THERM", GSL_CONST_CGS_THERM),
#endif
#ifdef GSL_CONST_CGS_THOMSON_CROSS_SECTION
   MAKE_DCONSTANT("CONST_CGS_THOMSON_CROSS_SECTION", GSL_CONST_CGS_THOMSON_CROSS_SECTION),
#endif
#ifdef GSL_CONST_CGS_TON
   MAKE_DCONSTANT("CONST_CGS_TON", GSL_CONST_CGS_TON),
#endif
#ifdef GSL_CONST_CGS_TORR
   MAKE_DCONSTANT("CONST_CGS_TORR", GSL_CONST_CGS_TORR),
#endif
#ifdef GSL_CONST_CGS_TROY_OUNCE
   MAKE_DCONSTANT("CONST_CGS_TROY_OUNCE", GSL_CONST_CGS_TROY_OUNCE),
#endif
#ifdef GSL_CONST_CGS_UK_GALLON
   MAKE_DCONSTANT("CONST_CGS_UK_GALLON", GSL_CONST_CGS_UK_GALLON),
#endif
#ifdef GSL_CONST_CGS_UK_TON
   MAKE_DCONSTANT("CONST_CGS_UK_TON", GSL_CONST_CGS_UK_TON),
#endif
#ifdef GSL_CONST_CGS_UNIFIED_ATOMIC_MASS
   MAKE_DCONSTANT("CONST_CGS_UNIFIED_ATOMIC_MASS", GSL_CONST_CGS_UNIFIED_ATOMIC_MASS),
#endif
#ifdef GSL_CONST_CGS_US_GALLON
   MAKE_DCONSTANT("CONST_CGS_US_GALLON", GSL_CONST_CGS_US_GALLON),
#endif
#ifdef GSL_CONST_CGS_WEEK
   MAKE_DCONSTANT("CONST_CGS_WEEK", GSL_CONST_CGS_WEEK),
#endif
#ifdef GSL_CONST_CGS_YARD
   MAKE_DCONSTANT("CONST_CGS_YARD", GSL_CONST_CGS_YARD),
#endif
#ifdef GSL_CONST_MKSA_ACRE
   MAKE_DCONSTANT("CONST_MKSA_ACRE", GSL_CONST_MKSA_ACRE),
#endif
#ifdef GSL_CONST_MKSA_ANGSTROM
   MAKE_DCONSTANT("CONST_MKSA_ANGSTROM", GSL_CONST_MKSA_ANGSTROM),
#endif
#ifdef GSL_CONST_MKSA_ASTRONOMICAL_UNIT
   MAKE_DCONSTANT("CONST_MKSA_ASTRONOMICAL_UNIT", GSL_CONST_MKSA_ASTRONOMICAL_UNIT),
#endif
#ifdef GSL_CONST_MKSA_BAR
   MAKE_DCONSTANT("CONST_MKSA_BAR", GSL_CONST_MKSA_BAR),
#endif
#ifdef GSL_CONST_MKSA_BARN
   MAKE_DCONSTANT("CONST_MKSA_BARN", GSL_CONST_MKSA_BARN),
#endif
#ifdef GSL_CONST_MKSA_BOHR_MAGNETON
   MAKE_DCONSTANT("CONST_MKSA_BOHR_MAGNETON", GSL_CONST_MKSA_BOHR_MAGNETON),
#endif
#ifdef GSL_CONST_MKSA_BOHR_RADIUS
   MAKE_DCONSTANT("CONST_MKSA_BOHR_RADIUS", GSL_CONST_MKSA_BOHR_RADIUS),
#endif
#ifdef GSL_CONST_MKSA_BOLTZMANN
   MAKE_DCONSTANT("CONST_MKSA_BOLTZMANN", GSL_CONST_MKSA_BOLTZMANN),
#endif
#ifdef GSL_CONST_MKSA_BTU
   MAKE_DCONSTANT("CONST_MKSA_BTU", GSL_CONST_MKSA_BTU),
#endif
#ifdef GSL_CONST_MKSA_CALORIE
   MAKE_DCONSTANT("CONST_MKSA_CALORIE", GSL_CONST_MKSA_CALORIE),
#endif
#ifdef GSL_CONST_MKSA_CANADIAN_GALLON
   MAKE_DCONSTANT("CONST_MKSA_CANADIAN_GALLON", GSL_CONST_MKSA_CANADIAN_GALLON),
#endif
#ifdef GSL_CONST_MKSA_CARAT
   MAKE_DCONSTANT("CONST_MKSA_CARAT", GSL_CONST_MKSA_CARAT),
#endif
#ifdef GSL_CONST_MKSA_CUP
   MAKE_DCONSTANT("CONST_MKSA_CUP", GSL_CONST_MKSA_CUP),
#endif
#ifdef GSL_CONST_MKSA_CURIE
   MAKE_DCONSTANT("CONST_MKSA_CURIE", GSL_CONST_MKSA_CURIE),
#endif
#ifdef GSL_CONST_MKSA_DAY
   MAKE_DCONSTANT("CONST_MKSA_DAY", GSL_CONST_MKSA_DAY),
#endif
#ifdef GSL_CONST_MKSA_DEBYE
   MAKE_DCONSTANT("CONST_MKSA_DEBYE", GSL_CONST_MKSA_DEBYE),
#endif
#ifdef GSL_CONST_MKSA_DYNE
   MAKE_DCONSTANT("CONST_MKSA_DYNE", GSL_CONST_MKSA_DYNE),
#endif
#ifdef GSL_CONST_MKSA_ELECTRON_CHARGE
   MAKE_DCONSTANT("CONST_MKSA_ELECTRON_CHARGE", GSL_CONST_MKSA_ELECTRON_CHARGE),
#endif
#ifdef GSL_CONST_MKSA_ELECTRON_MAGNETIC_MOMENT
   MAKE_DCONSTANT("CONST_MKSA_ELECTRON_MAGNETIC_MOMENT", GSL_CONST_MKSA_ELECTRON_MAGNETIC_MOMENT),
#endif
#ifdef GSL_CONST_MKSA_ELECTRON_VOLT
   MAKE_DCONSTANT("CONST_MKSA_ELECTRON_VOLT", GSL_CONST_MKSA_ELECTRON_VOLT),
#endif
#ifdef GSL_CONST_MKSA_ERG
   MAKE_DCONSTANT("CONST_MKSA_ERG", GSL_CONST_MKSA_ERG),
#endif
#ifdef GSL_CONST_MKSA_FARADAY
   MAKE_DCONSTANT("CONST_MKSA_FARADAY", GSL_CONST_MKSA_FARADAY),
#endif
#ifdef GSL_CONST_MKSA_FATHOM
   MAKE_DCONSTANT("CONST_MKSA_FATHOM", GSL_CONST_MKSA_FATHOM),
#endif
#ifdef GSL_CONST_MKSA_FLUID_OUNCE
   MAKE_DCONSTANT("CONST_MKSA_FLUID_OUNCE", GSL_CONST_MKSA_FLUID_OUNCE),
#endif
#ifdef GSL_CONST_MKSA_FOOT
   MAKE_DCONSTANT("CONST_MKSA_FOOT", GSL_CONST_MKSA_FOOT),
#endif
#ifdef GSL_CONST_MKSA_FOOTCANDLE
   MAKE_DCONSTANT("CONST_MKSA_FOOTCANDLE", GSL_CONST_MKSA_FOOTCANDLE),
#endif
#ifdef GSL_CONST_MKSA_FOOTLAMBERT
   MAKE_DCONSTANT("CONST_MKSA_FOOTLAMBERT", GSL_CONST_MKSA_FOOTLAMBERT),
#endif
#ifdef GSL_CONST_MKSA_GAUSS
   MAKE_DCONSTANT("CONST_MKSA_GAUSS", GSL_CONST_MKSA_GAUSS),
#endif
#ifdef GSL_CONST_MKSA_GRAM_FORCE
   MAKE_DCONSTANT("CONST_MKSA_GRAM_FORCE", GSL_CONST_MKSA_GRAM_FORCE),
#endif
#ifdef GSL_CONST_MKSA_GRAVITATIONAL_CONSTANT
   MAKE_DCONSTANT("CONST_MKSA_GRAVITATIONAL_CONSTANT", GSL_CONST_MKSA_GRAVITATIONAL_CONSTANT),
#endif
#ifdef GSL_CONST_MKSA_GRAV_ACCEL
   MAKE_DCONSTANT("CONST_MKSA_GRAV_ACCEL", GSL_CONST_MKSA_GRAV_ACCEL),
#endif
#ifdef GSL_CONST_MKSA_HECTARE
   MAKE_DCONSTANT("CONST_MKSA_HECTARE", GSL_CONST_MKSA_HECTARE),
#endif
#ifdef GSL_CONST_MKSA_HORSEPOWER
   MAKE_DCONSTANT("CONST_MKSA_HORSEPOWER", GSL_CONST_MKSA_HORSEPOWER),
#endif
#ifdef GSL_CONST_MKSA_HOUR
   MAKE_DCONSTANT("CONST_MKSA_HOUR", GSL_CONST_MKSA_HOUR),
#endif
#ifdef GSL_CONST_MKSA_INCH
   MAKE_DCONSTANT("CONST_MKSA_INCH", GSL_CONST_MKSA_INCH),
#endif
#ifdef GSL_CONST_MKSA_INCH_OF_MERCURY
   MAKE_DCONSTANT("CONST_MKSA_INCH_OF_MERCURY", GSL_CONST_MKSA_INCH_OF_MERCURY),
#endif
#ifdef GSL_CONST_MKSA_INCH_OF_WATER
   MAKE_DCONSTANT("CONST_MKSA_INCH_OF_WATER", GSL_CONST_MKSA_INCH_OF_WATER),
#endif
#ifdef GSL_CONST_MKSA_JOULE
   MAKE_DCONSTANT("CONST_MKSA_JOULE", GSL_CONST_MKSA_JOULE),
#endif
#ifdef GSL_CONST_MKSA_KILOMETERS_PER_HOUR
   MAKE_DCONSTANT("CONST_MKSA_KILOMETERS_PER_HOUR", GSL_CONST_MKSA_KILOMETERS_PER_HOUR),
#endif
#ifdef GSL_CONST_MKSA_KILOPOUND_FORCE
   MAKE_DCONSTANT("CONST_MKSA_KILOPOUND_FORCE", GSL_CONST_MKSA_KILOPOUND_FORCE),
#endif
#ifdef GSL_CONST_MKSA_KNOT
   MAKE_DCONSTANT("CONST_MKSA_KNOT", GSL_CONST_MKSA_KNOT),
#endif
#ifdef GSL_CONST_MKSA_LAMBERT
   MAKE_DCONSTANT("CONST_MKSA_LAMBERT", GSL_CONST_MKSA_LAMBERT),
#endif
#ifdef GSL_CONST_MKSA_LIGHT_YEAR
   MAKE_DCONSTANT("CONST_MKSA_LIGHT_YEAR", GSL_CONST_MKSA_LIGHT_YEAR),
#endif
#ifdef GSL_CONST_MKSA_LITER
   MAKE_DCONSTANT("CONST_MKSA_LITER", GSL_CONST_MKSA_LITER),
#endif
#ifdef GSL_CONST_MKSA_LUMEN
   MAKE_DCONSTANT("CONST_MKSA_LUMEN", GSL_CONST_MKSA_LUMEN),
#endif
#ifdef GSL_CONST_MKSA_LUX
   MAKE_DCONSTANT("CONST_MKSA_LUX", GSL_CONST_MKSA_LUX),
#endif
#ifdef GSL_CONST_MKSA_MASS_ELECTRON
   MAKE_DCONSTANT("CONST_MKSA_MASS_ELECTRON", GSL_CONST_MKSA_MASS_ELECTRON),
#endif
#ifdef GSL_CONST_MKSA_MASS_MUON
   MAKE_DCONSTANT("CONST_MKSA_MASS_MUON", GSL_CONST_MKSA_MASS_MUON),
#endif
#ifdef GSL_CONST_MKSA_MASS_NEUTRON
   MAKE_DCONSTANT("CONST_MKSA_MASS_NEUTRON", GSL_CONST_MKSA_MASS_NEUTRON),
#endif
#ifdef GSL_CONST_MKSA_MASS_PROTON
   MAKE_DCONSTANT("CONST_MKSA_MASS_PROTON", GSL_CONST_MKSA_MASS_PROTON),
#endif
#ifdef GSL_CONST_MKSA_METER_OF_MERCURY
   MAKE_DCONSTANT("CONST_MKSA_METER_OF_MERCURY", GSL_CONST_MKSA_METER_OF_MERCURY),
#endif
#ifdef GSL_CONST_MKSA_METRIC_TON
   MAKE_DCONSTANT("CONST_MKSA_METRIC_TON", GSL_CONST_MKSA_METRIC_TON),
#endif
#ifdef GSL_CONST_MKSA_MICRON
   MAKE_DCONSTANT("CONST_MKSA_MICRON", GSL_CONST_MKSA_MICRON),
#endif
#ifdef GSL_CONST_MKSA_MIL
   MAKE_DCONSTANT("CONST_MKSA_MIL", GSL_CONST_MKSA_MIL),
#endif
#ifdef GSL_CONST_MKSA_MILE
   MAKE_DCONSTANT("CONST_MKSA_MILE", GSL_CONST_MKSA_MILE),
#endif
#ifdef GSL_CONST_MKSA_MILES_PER_HOUR
   MAKE_DCONSTANT("CONST_MKSA_MILES_PER_HOUR", GSL_CONST_MKSA_MILES_PER_HOUR),
#endif
#ifdef GSL_CONST_MKSA_MINUTE
   MAKE_DCONSTANT("CONST_MKSA_MINUTE", GSL_CONST_MKSA_MINUTE),
#endif
#ifdef GSL_CONST_MKSA_MOLAR_GAS
   MAKE_DCONSTANT("CONST_MKSA_MOLAR_GAS", GSL_CONST_MKSA_MOLAR_GAS),
#endif
#ifdef GSL_CONST_MKSA_NAUTICAL_MILE
   MAKE_DCONSTANT("CONST_MKSA_NAUTICAL_MILE", GSL_CONST_MKSA_NAUTICAL_MILE),
#endif
#ifdef GSL_CONST_MKSA_NEWTON
   MAKE_DCONSTANT("CONST_MKSA_NEWTON", GSL_CONST_MKSA_NEWTON),
#endif
#ifdef GSL_CONST_MKSA_NUCLEAR_MAGNETON
   MAKE_DCONSTANT("CONST_MKSA_NUCLEAR_MAGNETON", GSL_CONST_MKSA_NUCLEAR_MAGNETON),
#endif
#ifdef GSL_CONST_MKSA_OUNCE_MASS
   MAKE_DCONSTANT("CONST_MKSA_OUNCE_MASS", GSL_CONST_MKSA_OUNCE_MASS),
#endif
#ifdef GSL_CONST_MKSA_PARSEC
   MAKE_DCONSTANT("CONST_MKSA_PARSEC", GSL_CONST_MKSA_PARSEC),
#endif
#ifdef GSL_CONST_MKSA_PHOT
   MAKE_DCONSTANT("CONST_MKSA_PHOT", GSL_CONST_MKSA_PHOT),
#endif
#ifdef GSL_CONST_MKSA_PINT
   MAKE_DCONSTANT("CONST_MKSA_PINT", GSL_CONST_MKSA_PINT),
#endif
#ifdef GSL_CONST_MKSA_PLANCKS_CONSTANT_H
   MAKE_DCONSTANT("CONST_MKSA_PLANCKS_CONSTANT_H", GSL_CONST_MKSA_PLANCKS_CONSTANT_H),
#endif
#ifdef GSL_CONST_MKSA_PLANCKS_CONSTANT_HBAR
   MAKE_DCONSTANT("CONST_MKSA_PLANCKS_CONSTANT_HBAR", GSL_CONST_MKSA_PLANCKS_CONSTANT_HBAR),
#endif
#ifdef GSL_CONST_MKSA_POINT
   MAKE_DCONSTANT("CONST_MKSA_POINT", GSL_CONST_MKSA_POINT),
#endif
#ifdef GSL_CONST_MKSA_POISE
   MAKE_DCONSTANT("CONST_MKSA_POISE", GSL_CONST_MKSA_POISE),
#endif
#ifdef GSL_CONST_MKSA_POUNDAL
   MAKE_DCONSTANT("CONST_MKSA_POUNDAL", GSL_CONST_MKSA_POUNDAL),
#endif
#ifdef GSL_CONST_MKSA_POUND_FORCE
   MAKE_DCONSTANT("CONST_MKSA_POUND_FORCE", GSL_CONST_MKSA_POUND_FORCE),
#endif
#ifdef GSL_CONST_MKSA_POUND_MASS
   MAKE_DCONSTANT("CONST_MKSA_POUND_MASS", GSL_CONST_MKSA_POUND_MASS),
#endif
#ifdef GSL_CONST_MKSA_PROTON_MAGNETIC_MOMENT
   MAKE_DCONSTANT("CONST_MKSA_PROTON_MAGNETIC_MOMENT", GSL_CONST_MKSA_PROTON_MAGNETIC_MOMENT),
#endif
#ifdef GSL_CONST_MKSA_PSI
   MAKE_DCONSTANT("CONST_MKSA_PSI", GSL_CONST_MKSA_PSI),
#endif
#ifdef GSL_CONST_MKSA_QUART
   MAKE_DCONSTANT("CONST_MKSA_QUART", GSL_CONST_MKSA_QUART),
#endif
#ifdef GSL_CONST_MKSA_RAD
   MAKE_DCONSTANT("CONST_MKSA_RAD", GSL_CONST_MKSA_RAD),
#endif
#ifdef GSL_CONST_MKSA_ROENTGEN
   MAKE_DCONSTANT("CONST_MKSA_ROENTGEN", GSL_CONST_MKSA_ROENTGEN),
#endif
#ifdef GSL_CONST_MKSA_RYDBERG
   MAKE_DCONSTANT("CONST_MKSA_RYDBERG", GSL_CONST_MKSA_RYDBERG),
#endif
#ifdef GSL_CONST_MKSA_SOLAR_MASS
   MAKE_DCONSTANT("CONST_MKSA_SOLAR_MASS", GSL_CONST_MKSA_SOLAR_MASS),
#endif
#ifdef GSL_CONST_MKSA_SPEED_OF_LIGHT
   MAKE_DCONSTANT("CONST_MKSA_SPEED_OF_LIGHT", GSL_CONST_MKSA_SPEED_OF_LIGHT),
#endif
#ifdef GSL_CONST_MKSA_STANDARD_GAS_VOLUME
   MAKE_DCONSTANT("CONST_MKSA_STANDARD_GAS_VOLUME", GSL_CONST_MKSA_STANDARD_GAS_VOLUME),
#endif
#ifdef GSL_CONST_MKSA_STD_ATMOSPHERE
   MAKE_DCONSTANT("CONST_MKSA_STD_ATMOSPHERE", GSL_CONST_MKSA_STD_ATMOSPHERE),
#endif
#ifdef GSL_CONST_MKSA_STEFAN_BOLTZMANN_CONSTANT
   MAKE_DCONSTANT("CONST_MKSA_STEFAN_BOLTZMANN_CONSTANT", GSL_CONST_MKSA_STEFAN_BOLTZMANN_CONSTANT),
#endif
#ifdef GSL_CONST_MKSA_STILB
   MAKE_DCONSTANT("CONST_MKSA_STILB", GSL_CONST_MKSA_STILB),
#endif
#ifdef GSL_CONST_MKSA_STOKES
   MAKE_DCONSTANT("CONST_MKSA_STOKES", GSL_CONST_MKSA_STOKES),
#endif
#ifdef GSL_CONST_MKSA_TABLESPOON
   MAKE_DCONSTANT("CONST_MKSA_TABLESPOON", GSL_CONST_MKSA_TABLESPOON),
#endif
#ifdef GSL_CONST_MKSA_TEASPOON
   MAKE_DCONSTANT("CONST_MKSA_TEASPOON", GSL_CONST_MKSA_TEASPOON),
#endif
#ifdef GSL_CONST_MKSA_TEXPOINT
   MAKE_DCONSTANT("CONST_MKSA_TEXPOINT", GSL_CONST_MKSA_TEXPOINT),
#endif
#ifdef GSL_CONST_MKSA_THERM
   MAKE_DCONSTANT("CONST_MKSA_THERM", GSL_CONST_MKSA_THERM),
#endif
#ifdef GSL_CONST_MKSA_THOMSON_CROSS_SECTION
   MAKE_DCONSTANT("CONST_MKSA_THOMSON_CROSS_SECTION", GSL_CONST_MKSA_THOMSON_CROSS_SECTION),
#endif
#ifdef GSL_CONST_MKSA_TON
   MAKE_DCONSTANT("CONST_MKSA_TON", GSL_CONST_MKSA_TON),
#endif
#ifdef GSL_CONST_MKSA_TORR
   MAKE_DCONSTANT("CONST_MKSA_TORR", GSL_CONST_MKSA_TORR),
#endif
#ifdef GSL_CONST_MKSA_TROY_OUNCE
   MAKE_DCONSTANT("CONST_MKSA_TROY_OUNCE", GSL_CONST_MKSA_TROY_OUNCE),
#endif
#ifdef GSL_CONST_MKSA_UK_GALLON
   MAKE_DCONSTANT("CONST_MKSA_UK_GALLON", GSL_CONST_MKSA_UK_GALLON),
#endif
#ifdef GSL_CONST_MKSA_UK_TON
   MAKE_DCONSTANT("CONST_MKSA_UK_TON", GSL_CONST_MKSA_UK_TON),
#endif
#ifdef GSL_CONST_MKSA_UNIFIED_ATOMIC_MASS
   MAKE_DCONSTANT("CONST_MKSA_UNIFIED_ATOMIC_MASS", GSL_CONST_MKSA_UNIFIED_ATOMIC_MASS),
#endif
#ifdef GSL_CONST_MKSA_US_GALLON
   MAKE_DCONSTANT("CONST_MKSA_US_GALLON", GSL_CONST_MKSA_US_GALLON),
#endif
#ifdef GSL_CONST_MKSA_VACUUM_PERMEABILITY
   MAKE_DCONSTANT("CONST_MKSA_VACUUM_PERMEABILITY", GSL_CONST_MKSA_VACUUM_PERMEABILITY),
#endif
#ifdef GSL_CONST_MKSA_VACUUM_PERMITTIVITY
   MAKE_DCONSTANT("CONST_MKSA_VACUUM_PERMITTIVITY", GSL_CONST_MKSA_VACUUM_PERMITTIVITY),
#endif
#ifdef GSL_CONST_MKSA_WEEK
   MAKE_DCONSTANT("CONST_MKSA_WEEK", GSL_CONST_MKSA_WEEK),
#endif
#ifdef GSL_CONST_MKSA_YARD
   MAKE_DCONSTANT("CONST_MKSA_YARD", GSL_CONST_MKSA_YARD),
#endif
#ifdef GSL_CONST_MKS_ACRE
   MAKE_DCONSTANT("CONST_MKS_ACRE", GSL_CONST_MKS_ACRE),
#endif
#ifdef GSL_CONST_MKS_ANGSTROM
   MAKE_DCONSTANT("CONST_MKS_ANGSTROM", GSL_CONST_MKS_ANGSTROM),
#endif
#ifdef GSL_CONST_MKS_ASTRONOMICAL_UNIT
   MAKE_DCONSTANT("CONST_MKS_ASTRONOMICAL_UNIT", GSL_CONST_MKS_ASTRONOMICAL_UNIT),
#endif
#ifdef GSL_CONST_MKS_BAR
   MAKE_DCONSTANT("CONST_MKS_BAR", GSL_CONST_MKS_BAR),
#endif
#ifdef GSL_CONST_MKS_BARN
   MAKE_DCONSTANT("CONST_MKS_BARN", GSL_CONST_MKS_BARN),
#endif
#ifdef GSL_CONST_MKS_BOHR_MAGNETON
   MAKE_DCONSTANT("CONST_MKS_BOHR_MAGNETON", GSL_CONST_MKS_BOHR_MAGNETON),
#endif
#ifdef GSL_CONST_MKS_BOHR_RADIUS
   MAKE_DCONSTANT("CONST_MKS_BOHR_RADIUS", GSL_CONST_MKS_BOHR_RADIUS),
#endif
#ifdef GSL_CONST_MKS_BOLTZMANN
   MAKE_DCONSTANT("CONST_MKS_BOLTZMANN", GSL_CONST_MKS_BOLTZMANN),
#endif
#ifdef GSL_CONST_MKS_BTU
   MAKE_DCONSTANT("CONST_MKS_BTU", GSL_CONST_MKS_BTU),
#endif
#ifdef GSL_CONST_MKS_CALORIE
   MAKE_DCONSTANT("CONST_MKS_CALORIE", GSL_CONST_MKS_CALORIE),
#endif
#ifdef GSL_CONST_MKS_CANADIAN_GALLON
   MAKE_DCONSTANT("CONST_MKS_CANADIAN_GALLON", GSL_CONST_MKS_CANADIAN_GALLON),
#endif
#ifdef GSL_CONST_MKS_CARAT
   MAKE_DCONSTANT("CONST_MKS_CARAT", GSL_CONST_MKS_CARAT),
#endif
#ifdef GSL_CONST_MKS_CUP
   MAKE_DCONSTANT("CONST_MKS_CUP", GSL_CONST_MKS_CUP),
#endif
#ifdef GSL_CONST_MKS_CURIE
   MAKE_DCONSTANT("CONST_MKS_CURIE", GSL_CONST_MKS_CURIE),
#endif
#ifdef GSL_CONST_MKS_DAY
   MAKE_DCONSTANT("CONST_MKS_DAY", GSL_CONST_MKS_DAY),
#endif
#ifdef GSL_CONST_MKS_DEBYE
   MAKE_DCONSTANT("CONST_MKS_DEBYE", GSL_CONST_MKS_DEBYE),
#endif
#ifdef GSL_CONST_MKS_DYNE
   MAKE_DCONSTANT("CONST_MKS_DYNE", GSL_CONST_MKS_DYNE),
#endif
#ifdef GSL_CONST_MKS_ELECTRON_CHARGE
   MAKE_DCONSTANT("CONST_MKS_ELECTRON_CHARGE", GSL_CONST_MKS_ELECTRON_CHARGE),
#endif
#ifdef GSL_CONST_MKS_ELECTRON_MAGNETIC_MOMENT
   MAKE_DCONSTANT("CONST_MKS_ELECTRON_MAGNETIC_MOMENT", GSL_CONST_MKS_ELECTRON_MAGNETIC_MOMENT),
#endif
#ifdef GSL_CONST_MKS_ELECTRON_VOLT
   MAKE_DCONSTANT("CONST_MKS_ELECTRON_VOLT", GSL_CONST_MKS_ELECTRON_VOLT),
#endif
#ifdef GSL_CONST_MKS_ERG
   MAKE_DCONSTANT("CONST_MKS_ERG", GSL_CONST_MKS_ERG),
#endif
#ifdef GSL_CONST_MKS_FARADAY
   MAKE_DCONSTANT("CONST_MKS_FARADAY", GSL_CONST_MKS_FARADAY),
#endif
#ifdef GSL_CONST_MKS_FATHOM
   MAKE_DCONSTANT("CONST_MKS_FATHOM", GSL_CONST_MKS_FATHOM),
#endif
#ifdef GSL_CONST_MKS_FLUID_OUNCE
   MAKE_DCONSTANT("CONST_MKS_FLUID_OUNCE", GSL_CONST_MKS_FLUID_OUNCE),
#endif
#ifdef GSL_CONST_MKS_FOOT
   MAKE_DCONSTANT("CONST_MKS_FOOT", GSL_CONST_MKS_FOOT),
#endif
#ifdef GSL_CONST_MKS_FOOTCANDLE
   MAKE_DCONSTANT("CONST_MKS_FOOTCANDLE", GSL_CONST_MKS_FOOTCANDLE),
#endif
#ifdef GSL_CONST_MKS_FOOTLAMBERT
   MAKE_DCONSTANT("CONST_MKS_FOOTLAMBERT", GSL_CONST_MKS_FOOTLAMBERT),
#endif
#ifdef GSL_CONST_MKS_GAUSS
   MAKE_DCONSTANT("CONST_MKS_GAUSS", GSL_CONST_MKS_GAUSS),
#endif
#ifdef GSL_CONST_MKS_GRAM_FORCE
   MAKE_DCONSTANT("CONST_MKS_GRAM_FORCE", GSL_CONST_MKS_GRAM_FORCE),
#endif
#ifdef GSL_CONST_MKS_GRAVITATIONAL_CONSTANT
   MAKE_DCONSTANT("CONST_MKS_GRAVITATIONAL_CONSTANT", GSL_CONST_MKS_GRAVITATIONAL_CONSTANT),
#endif
#ifdef GSL_CONST_MKS_GRAV_ACCEL
   MAKE_DCONSTANT("CONST_MKS_GRAV_ACCEL", GSL_CONST_MKS_GRAV_ACCEL),
#endif
#ifdef GSL_CONST_MKS_HECTARE
   MAKE_DCONSTANT("CONST_MKS_HECTARE", GSL_CONST_MKS_HECTARE),
#endif
#ifdef GSL_CONST_MKS_HORSEPOWER
   MAKE_DCONSTANT("CONST_MKS_HORSEPOWER", GSL_CONST_MKS_HORSEPOWER),
#endif
#ifdef GSL_CONST_MKS_HOUR
   MAKE_DCONSTANT("CONST_MKS_HOUR", GSL_CONST_MKS_HOUR),
#endif
#ifdef GSL_CONST_MKS_INCH
   MAKE_DCONSTANT("CONST_MKS_INCH", GSL_CONST_MKS_INCH),
#endif
#ifdef GSL_CONST_MKS_INCH_OF_MERCURY
   MAKE_DCONSTANT("CONST_MKS_INCH_OF_MERCURY", GSL_CONST_MKS_INCH_OF_MERCURY),
#endif
#ifdef GSL_CONST_MKS_INCH_OF_WATER
   MAKE_DCONSTANT("CONST_MKS_INCH_OF_WATER", GSL_CONST_MKS_INCH_OF_WATER),
#endif
#ifdef GSL_CONST_MKS_JOULE
   MAKE_DCONSTANT("CONST_MKS_JOULE", GSL_CONST_MKS_JOULE),
#endif
#ifdef GSL_CONST_MKS_KILOMETERS_PER_HOUR
   MAKE_DCONSTANT("CONST_MKS_KILOMETERS_PER_HOUR", GSL_CONST_MKS_KILOMETERS_PER_HOUR),
#endif
#ifdef GSL_CONST_MKS_KILOPOUND_FORCE
   MAKE_DCONSTANT("CONST_MKS_KILOPOUND_FORCE", GSL_CONST_MKS_KILOPOUND_FORCE),
#endif
#ifdef GSL_CONST_MKS_KNOT
   MAKE_DCONSTANT("CONST_MKS_KNOT", GSL_CONST_MKS_KNOT),
#endif
#ifdef GSL_CONST_MKS_LAMBERT
   MAKE_DCONSTANT("CONST_MKS_LAMBERT", GSL_CONST_MKS_LAMBERT),
#endif
#ifdef GSL_CONST_MKS_LIGHT_YEAR
   MAKE_DCONSTANT("CONST_MKS_LIGHT_YEAR", GSL_CONST_MKS_LIGHT_YEAR),
#endif
#ifdef GSL_CONST_MKS_LITER
   MAKE_DCONSTANT("CONST_MKS_LITER", GSL_CONST_MKS_LITER),
#endif
#ifdef GSL_CONST_MKS_LUMEN
   MAKE_DCONSTANT("CONST_MKS_LUMEN", GSL_CONST_MKS_LUMEN),
#endif
#ifdef GSL_CONST_MKS_LUX
   MAKE_DCONSTANT("CONST_MKS_LUX", GSL_CONST_MKS_LUX),
#endif
#ifdef GSL_CONST_MKS_MASS_ELECTRON
   MAKE_DCONSTANT("CONST_MKS_MASS_ELECTRON", GSL_CONST_MKS_MASS_ELECTRON),
#endif
#ifdef GSL_CONST_MKS_MASS_MUON
   MAKE_DCONSTANT("CONST_MKS_MASS_MUON", GSL_CONST_MKS_MASS_MUON),
#endif
#ifdef GSL_CONST_MKS_MASS_NEUTRON
   MAKE_DCONSTANT("CONST_MKS_MASS_NEUTRON", GSL_CONST_MKS_MASS_NEUTRON),
#endif
#ifdef GSL_CONST_MKS_MASS_PROTON
   MAKE_DCONSTANT("CONST_MKS_MASS_PROTON", GSL_CONST_MKS_MASS_PROTON),
#endif
#ifdef GSL_CONST_MKS_METER_OF_MERCURY
   MAKE_DCONSTANT("CONST_MKS_METER_OF_MERCURY", GSL_CONST_MKS_METER_OF_MERCURY),
#endif
#ifdef GSL_CONST_MKS_METRIC_TON
   MAKE_DCONSTANT("CONST_MKS_METRIC_TON", GSL_CONST_MKS_METRIC_TON),
#endif
#ifdef GSL_CONST_MKS_MICRON
   MAKE_DCONSTANT("CONST_MKS_MICRON", GSL_CONST_MKS_MICRON),
#endif
#ifdef GSL_CONST_MKS_MIL
   MAKE_DCONSTANT("CONST_MKS_MIL", GSL_CONST_MKS_MIL),
#endif
#ifdef GSL_CONST_MKS_MILE
   MAKE_DCONSTANT("CONST_MKS_MILE", GSL_CONST_MKS_MILE),
#endif
#ifdef GSL_CONST_MKS_MILES_PER_HOUR
   MAKE_DCONSTANT("CONST_MKS_MILES_PER_HOUR", GSL_CONST_MKS_MILES_PER_HOUR),
#endif
#ifdef GSL_CONST_MKS_MINUTE
   MAKE_DCONSTANT("CONST_MKS_MINUTE", GSL_CONST_MKS_MINUTE),
#endif
#ifdef GSL_CONST_MKS_MOLAR_GAS
   MAKE_DCONSTANT("CONST_MKS_MOLAR_GAS", GSL_CONST_MKS_MOLAR_GAS),
#endif
#ifdef GSL_CONST_MKS_NAUTICAL_MILE
   MAKE_DCONSTANT("CONST_MKS_NAUTICAL_MILE", GSL_CONST_MKS_NAUTICAL_MILE),
#endif
#ifdef GSL_CONST_MKS_NEWTON
   MAKE_DCONSTANT("CONST_MKS_NEWTON", GSL_CONST_MKS_NEWTON),
#endif
#ifdef GSL_CONST_MKS_NUCLEAR_MAGNETON
   MAKE_DCONSTANT("CONST_MKS_NUCLEAR_MAGNETON", GSL_CONST_MKS_NUCLEAR_MAGNETON),
#endif
#ifdef GSL_CONST_MKS_OUNCE_MASS
   MAKE_DCONSTANT("CONST_MKS_OUNCE_MASS", GSL_CONST_MKS_OUNCE_MASS),
#endif
#ifdef GSL_CONST_MKS_PARSEC
   MAKE_DCONSTANT("CONST_MKS_PARSEC", GSL_CONST_MKS_PARSEC),
#endif
#ifdef GSL_CONST_MKS_PHOT
   MAKE_DCONSTANT("CONST_MKS_PHOT", GSL_CONST_MKS_PHOT),
#endif
#ifdef GSL_CONST_MKS_PINT
   MAKE_DCONSTANT("CONST_MKS_PINT", GSL_CONST_MKS_PINT),
#endif
#ifdef GSL_CONST_MKS_PLANCKS_CONSTANT_H
   MAKE_DCONSTANT("CONST_MKS_PLANCKS_CONSTANT_H", GSL_CONST_MKS_PLANCKS_CONSTANT_H),
#endif
#ifdef GSL_CONST_MKS_PLANCKS_CONSTANT_HBAR
   MAKE_DCONSTANT("CONST_MKS_PLANCKS_CONSTANT_HBAR", GSL_CONST_MKS_PLANCKS_CONSTANT_HBAR),
#endif
#ifdef GSL_CONST_MKS_POINT
   MAKE_DCONSTANT("CONST_MKS_POINT", GSL_CONST_MKS_POINT),
#endif
#ifdef GSL_CONST_MKS_POISE
   MAKE_DCONSTANT("CONST_MKS_POISE", GSL_CONST_MKS_POISE),
#endif
#ifdef GSL_CONST_MKS_POUNDAL
   MAKE_DCONSTANT("CONST_MKS_POUNDAL", GSL_CONST_MKS_POUNDAL),
#endif
#ifdef GSL_CONST_MKS_POUND_FORCE
   MAKE_DCONSTANT("CONST_MKS_POUND_FORCE", GSL_CONST_MKS_POUND_FORCE),
#endif
#ifdef GSL_CONST_MKS_POUND_MASS
   MAKE_DCONSTANT("CONST_MKS_POUND_MASS", GSL_CONST_MKS_POUND_MASS),
#endif
#ifdef GSL_CONST_MKS_PROTON_MAGNETIC_MOMENT
   MAKE_DCONSTANT("CONST_MKS_PROTON_MAGNETIC_MOMENT", GSL_CONST_MKS_PROTON_MAGNETIC_MOMENT),
#endif
#ifdef GSL_CONST_MKS_PSI
   MAKE_DCONSTANT("CONST_MKS_PSI", GSL_CONST_MKS_PSI),
#endif
#ifdef GSL_CONST_MKS_QUART
   MAKE_DCONSTANT("CONST_MKS_QUART", GSL_CONST_MKS_QUART),
#endif
#ifdef GSL_CONST_MKS_RAD
   MAKE_DCONSTANT("CONST_MKS_RAD", GSL_CONST_MKS_RAD),
#endif
#ifdef GSL_CONST_MKS_ROENTGEN
   MAKE_DCONSTANT("CONST_MKS_ROENTGEN", GSL_CONST_MKS_ROENTGEN),
#endif
#ifdef GSL_CONST_MKS_RYDBERG
   MAKE_DCONSTANT("CONST_MKS_RYDBERG", GSL_CONST_MKS_RYDBERG),
#endif
#ifdef GSL_CONST_MKS_SOLAR_MASS
   MAKE_DCONSTANT("CONST_MKS_SOLAR_MASS", GSL_CONST_MKS_SOLAR_MASS),
#endif
#ifdef GSL_CONST_MKS_SPEED_OF_LIGHT
   MAKE_DCONSTANT("CONST_MKS_SPEED_OF_LIGHT", GSL_CONST_MKS_SPEED_OF_LIGHT),
#endif
#ifdef GSL_CONST_MKS_STANDARD_GAS_VOLUME
   MAKE_DCONSTANT("CONST_MKS_STANDARD_GAS_VOLUME", GSL_CONST_MKS_STANDARD_GAS_VOLUME),
#endif
#ifdef GSL_CONST_MKS_STD_ATMOSPHERE
   MAKE_DCONSTANT("CONST_MKS_STD_ATMOSPHERE", GSL_CONST_MKS_STD_ATMOSPHERE),
#endif
#ifdef GSL_CONST_MKS_STEFAN_BOLTZMANN_CONSTANT
   MAKE_DCONSTANT("CONST_MKS_STEFAN_BOLTZMANN_CONSTANT", GSL_CONST_MKS_STEFAN_BOLTZMANN_CONSTANT),
#endif
#ifdef GSL_CONST_MKS_STILB
   MAKE_DCONSTANT("CONST_MKS_STILB", GSL_CONST_MKS_STILB),
#endif
#ifdef GSL_CONST_MKS_STOKES
   MAKE_DCONSTANT("CONST_MKS_STOKES", GSL_CONST_MKS_STOKES),
#endif
#ifdef GSL_CONST_MKS_TABLESPOON
   MAKE_DCONSTANT("CONST_MKS_TABLESPOON", GSL_CONST_MKS_TABLESPOON),
#endif
#ifdef GSL_CONST_MKS_TEASPOON
   MAKE_DCONSTANT("CONST_MKS_TEASPOON", GSL_CONST_MKS_TEASPOON),
#endif
#ifdef GSL_CONST_MKS_TEXPOINT
   MAKE_DCONSTANT("CONST_MKS_TEXPOINT", GSL_CONST_MKS_TEXPOINT),
#endif
#ifdef GSL_CONST_MKS_THERM
   MAKE_DCONSTANT("CONST_MKS_THERM", GSL_CONST_MKS_THERM),
#endif
#ifdef GSL_CONST_MKS_THOMSON_CROSS_SECTION
   MAKE_DCONSTANT("CONST_MKS_THOMSON_CROSS_SECTION", GSL_CONST_MKS_THOMSON_CROSS_SECTION),
#endif
#ifdef GSL_CONST_MKS_TON
   MAKE_DCONSTANT("CONST_MKS_TON", GSL_CONST_MKS_TON),
#endif
#ifdef GSL_CONST_MKS_TORR
   MAKE_DCONSTANT("CONST_MKS_TORR", GSL_CONST_MKS_TORR),
#endif
#ifdef GSL_CONST_MKS_TROY_OUNCE
   MAKE_DCONSTANT("CONST_MKS_TROY_OUNCE", GSL_CONST_MKS_TROY_OUNCE),
#endif
#ifdef GSL_CONST_MKS_UK_GALLON
   MAKE_DCONSTANT("CONST_MKS_UK_GALLON", GSL_CONST_MKS_UK_GALLON),
#endif
#ifdef GSL_CONST_MKS_UK_TON
   MAKE_DCONSTANT("CONST_MKS_UK_TON", GSL_CONST_MKS_UK_TON),
#endif
#ifdef GSL_CONST_MKS_UNIFIED_ATOMIC_MASS
   MAKE_DCONSTANT("CONST_MKS_UNIFIED_ATOMIC_MASS", GSL_CONST_MKS_UNIFIED_ATOMIC_MASS),
#endif
#ifdef GSL_CONST_MKS_US_GALLON
   MAKE_DCONSTANT("CONST_MKS_US_GALLON", GSL_CONST_MKS_US_GALLON),
#endif
#ifdef GSL_CONST_MKS_VACUUM_PERMEABILITY
   MAKE_DCONSTANT("CONST_MKS_VACUUM_PERMEABILITY", GSL_CONST_MKS_VACUUM_PERMEABILITY),
#endif
#ifdef GSL_CONST_MKS_VACUUM_PERMITTIVITY
   MAKE_DCONSTANT("CONST_MKS_VACUUM_PERMITTIVITY", GSL_CONST_MKS_VACUUM_PERMITTIVITY),
#endif
#ifdef GSL_CONST_MKS_WEEK
   MAKE_DCONSTANT("CONST_MKS_WEEK", GSL_CONST_MKS_WEEK),
#endif
#ifdef GSL_CONST_MKS_YARD
   MAKE_DCONSTANT("CONST_MKS_YARD", GSL_CONST_MKS_YARD),
#endif
#ifdef GSL_CONST_NUM_ATTO
   MAKE_DCONSTANT("CONST_NUM_ATTO", GSL_CONST_NUM_ATTO),
#endif
#ifdef GSL_CONST_NUM_AVOGADRO
   MAKE_DCONSTANT("CONST_NUM_AVOGADRO", GSL_CONST_NUM_AVOGADRO),
#endif
#ifdef GSL_CONST_NUM_EXA
   MAKE_DCONSTANT("CONST_NUM_EXA", GSL_CONST_NUM_EXA),
#endif
#ifdef GSL_CONST_NUM_FEMTO
   MAKE_DCONSTANT("CONST_NUM_FEMTO", GSL_CONST_NUM_FEMTO),
#endif
#ifdef GSL_CONST_NUM_FINE_STRUCTURE
   MAKE_DCONSTANT("CONST_NUM_FINE_STRUCTURE", GSL_CONST_NUM_FINE_STRUCTURE),
#endif
#ifdef GSL_CONST_NUM_GIGA
   MAKE_DCONSTANT("CONST_NUM_GIGA", GSL_CONST_NUM_GIGA),
#endif
#ifdef GSL_CONST_NUM_KILO
   MAKE_DCONSTANT("CONST_NUM_KILO", GSL_CONST_NUM_KILO),
#endif
#ifdef GSL_CONST_NUM_MEGA
   MAKE_DCONSTANT("CONST_NUM_MEGA", GSL_CONST_NUM_MEGA),
#endif
#ifdef GSL_CONST_NUM_MICRO
   MAKE_DCONSTANT("CONST_NUM_MICRO", GSL_CONST_NUM_MICRO),
#endif
#ifdef GSL_CONST_NUM_MILLI
   MAKE_DCONSTANT("CONST_NUM_MILLI", GSL_CONST_NUM_MILLI),
#endif
#ifdef GSL_CONST_NUM_NANO
   MAKE_DCONSTANT("CONST_NUM_NANO", GSL_CONST_NUM_NANO),
#endif
#ifdef GSL_CONST_NUM_PETA
   MAKE_DCONSTANT("CONST_NUM_PETA", GSL_CONST_NUM_PETA),
#endif
#ifdef GSL_CONST_NUM_PICO
   MAKE_DCONSTANT("CONST_NUM_PICO", GSL_CONST_NUM_PICO),
#endif
#ifdef GSL_CONST_NUM_TERA
   MAKE_DCONSTANT("CONST_NUM_TERA", GSL_CONST_NUM_TERA),
#endif
#ifdef GSL_CONST_NUM_YOCTO
   MAKE_DCONSTANT("CONST_NUM_YOCTO", GSL_CONST_NUM_YOCTO),
#endif
#ifdef GSL_CONST_NUM_YOTTA
   MAKE_DCONSTANT("CONST_NUM_YOTTA", GSL_CONST_NUM_YOTTA),
#endif
#ifdef GSL_CONST_NUM_ZEPTO
   MAKE_DCONSTANT("CONST_NUM_ZEPTO", GSL_CONST_NUM_ZEPTO),
#endif
#ifdef GSL_CONST_NUM_ZETTA
   MAKE_DCONSTANT("CONST_NUM_ZETTA", GSL_CONST_NUM_ZETTA),
#endif
   SLANG_END_DCONST_TABLE
};
#endif

int init_gslconst_module_ns (char *ns_name)
{
   SLang_NameSpace_Type *ns = SLns_create_namespace (ns_name);
   if (ns == NULL)
     return -1;

   if (
       (-1 == SLns_add_intrin_var_table (ns, Module_Variables, NULL))
#ifdef MODULE_HAS_INTRINSICS
       || (-1 == SLns_add_intrin_fun_table (ns, Module_Intrinsics, NULL))
#endif
       || (-1 == SLns_add_iconstant_table (ns, Module_IConstants, NULL))
#ifdef MODULE_HAS_DCONSTANTS
       || (-1 == SLns_add_dconstant_table (ns, Module_DConstants, NULL))
#endif
       )
     return -1;

   return 0;
}

/* This function is optional */
void deinit_gslconst_module (void)
{
}
