/*
 * Decompiled with CFR 0.152.
 */
package adql.parser.grammar;

import adql.parser.ADQLParser;
import adql.parser.ADQLQueryFactory;
import adql.parser.IdentifierItems;
import adql.parser.grammar.ADQLGrammar;
import adql.parser.grammar.ADQLGrammar200Constants;
import adql.parser.grammar.ADQLGrammar200TokenManager;
import adql.parser.grammar.ADQLGrammarBase;
import adql.parser.grammar.ParseException;
import adql.parser.grammar.SimpleCharStream;
import adql.parser.grammar.Token;
import adql.parser.grammar.TokenMgrError;
import adql.query.ADQLList;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.constraint.In;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NullValue;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.OperationType;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.MathFunctionType;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ADQLGrammar200
extends ADQLGrammarBase
implements ADQLGrammar200Constants {
    public static final ADQLParser.ADQLVersion VERSION = ADQLParser.ADQLVersion.V2_0;
    public ADQLGrammar200TokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[98];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[19];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries;
    private int[] jj_expentry;
    private int jj_kind;
    private int[] jj_lasttokens;
    private int jj_endpos;
    private boolean trace_enabled;
    private int trace_indent;

    @Override
    public final ADQLParser.ADQLVersion getVersion() {
        return VERSION;
    }

    @Override
    public final boolean isEOF(Token token) {
        return token != null && token.kind == 0;
    }

    @Override
    public final boolean isEOQ(Token token) {
        return token != null && token.kind == 7;
    }

    @Override
    public final boolean isRegularIdentifierCandidate(Token token) {
        return token != null && token.kind == 105;
    }

    @Override
    public final boolean isSQLReservedWord(Token token) {
        return token != null && token.kind == 2;
    }

    @Override
    public final boolean isLeftPar(Token token) {
        return token != null && token.kind == 3;
    }

    @Override
    public final ADQLGrammar.Tokenizer getTokenizer(final String expr) throws NullPointerException {
        if (expr == null) {
            throw new NullPointerException("Missing ADQL expression to tokenize!");
        }
        return new ADQLGrammar.Tokenizer(){
            private final ADQLGrammar200TokenManager tokenManager;
            private boolean eof;
            {
                this.tokenManager = new ADQLGrammar200TokenManager(new SimpleCharStream(new ByteArrayInputStream(expr.getBytes())));
                this.eof = false;
            }

            @Override
            public Token nextToken() {
                if (this.eof) {
                    return null;
                }
                Token tok = this.tokenManager.getNextToken();
                this.eof = tok.kind == 0;
                return tok;
            }
        };
    }

    @Override
    public final ADQLSet Query() throws ParseException {
        this.trace_call("Query");
        try {
            ADQLSet q = null;
            q = this.QueryExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                case 7: {
                    this.jj_consume_token(7);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLSet aDQLSet = q;
            return aDQLSet;
        }
        finally {
            this.trace_return("Query");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet QueryExpression() throws ParseException {
        this.trace_call("QueryExpression");
        try {
            TextPosition endPos = null;
            try {
                this.query = this.queryFactory.createQuery(VERSION);
                this.stackQuery.push(this.query);
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            ClauseSelect select = this.Select();
            this.query.setSelect(select);
            FromContent from = this.From();
            this.query.setFrom(from);
            endPos = from.getPosition();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: {
                    ClauseConstraints where = this.Where();
                    this.query.setWhere(where);
                    endPos = where.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    ClauseADQL<ADQLOperand> groupBy = this.GroupBy();
                    this.query.setGroupBy(groupBy);
                    endPos = groupBy.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 49: {
                    ClauseConstraints having = this.Having();
                    this.query.setHaving(having);
                    endPos = having.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 50: {
                    ClauseADQL<ADQLOrder> orderBy = this.OrderBy();
                    this.query.setOrderBy(orderBy);
                    endPos = orderBy.getPosition();
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                }
            }
            this.query.setPosition(new TextPosition(select.getPosition(), endPos));
            ADQLSet previousQuery = (ADQLSet)this.stackQuery.pop();
            this.query = this.stackQuery.isEmpty() ? null : (ADQLQuery)this.stackQuery.peek();
            ADQLSet aDQLSet = previousQuery;
            return aDQLSet;
        }
        finally {
            this.trace_return("QueryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLSet SubQueryExpression() throws ParseException {
        this.trace_call("SubQueryExpression");
        try {
            ADQLSet q = null;
            Token start = this.jj_consume_token(3);
            q = this.QueryExpression();
            Token end = this.jj_consume_token(4);
            q.setPosition(new TextPosition(start, end));
            ADQLSet aDQLSet = q;
            return aDQLSet;
        }
        finally {
            this.trace_return("SubQueryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseSelect Select() throws ParseException {
        this.trace_call("Select");
        try {
            ClauseSelect select = new ClauseSelect();
            SelectItem item = null;
            Token t = null;
            Token start = this.jj_consume_token(23);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    t = this.jj_consume_token(24);
                    select.setDistinctColumns(t.image.equalsIgnoreCase("DISTINCT"));
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    t = this.jj_consume_token(100);
                    try {
                        select.setLimit(Integer.parseInt(t.image));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("[l." + t.beginLine + ";c." + t.beginColumn + "] The TOP limit (\"" + t.image + "\") isn't a regular unsigned integer !");
                    }
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                }
            }
            item = this.SelectItem();
            select.add(item);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(6);
                item = this.SelectItem();
                select.add(item);
            }
            TextPosition lastItemPos = ((SelectItem)select.get(select.size() - 1)).getPosition();
            select.setPosition(new TextPosition(start.beginLine, start.beginColumn, lastItemPos.endLine, lastItemPos.endColumn));
            ClauseSelect clauseSelect = select;
            return clauseSelect;
        }
        finally {
            this.trace_return("Select");
        }
    }

    /*
     * Unable to fully structure code
     */
    public final SelectItem SelectItem() throws ParseException {
        this.trace_call("SelectItem");
        identifiers = new IdentifierItems(true);
        firstID = null;
        id = null;
        label = null;
        op = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                starToken = this.jj_consume_token(11);
                item = new SelectAllColumns(this.query);
                item.setPosition(new TextPosition(starToken));
                var8_11 = item;
                return var8_11;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        if (this.jj_2_1(7)) {
            id = this.Identifier();
            this.jj_consume_token(5);
            identifiers.append(id);
            firstID = id;
            block9 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 104: 
                case 105: {
                    id = this.Identifier();
                    this.jj_consume_token(5);
                    identifiers.append(id);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 104: 
                        case 105: {
                            id = this.Identifier();
                            this.jj_consume_token(5);
                            identifiers.append(id);
                            break block9;
                        }
                    }
                    this.jj_la1[8] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                }
            }
            starToken = this.jj_consume_token(11);
            try {
                table = this.queryFactory.createTable(identifiers, null);
                table.setPosition(new TextPosition(firstID.position, id.position));
                item = new SelectAllColumns(table);
                item.setPosition(new TextPosition(firstID.position, new TextPosition(starToken)));
                var9_16 = item;
                return var9_16;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        ** switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk)
lbl-1000:
        // 1 sources

        {
            case 3: 
            case 9: 
            case 10: 
            case 42: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 104: 
            case 105: {
                op = this.ValueExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: 
                    case 104: 
                    case 105: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 27: {
                                this.jj_consume_token(27);
                                break;
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                            }
                        }
                        label = this.Identifier();
                        break block15;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                break;
            }
lbl65:
            // 1 sources

            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            item = this.queryFactory.createSelectItem(op, label == null ? null : label.identifier);
            if (label != null) {
                item.setCaseSensitive(label.caseSensitivity);
                item.setPosition(new TextPosition(op.getPosition(), label.position));
            } else {
                item.setPosition(new TextPosition(op.getPosition()));
            }
            ex = item;
            return ex;
        }
        catch (Exception ex) {
            throw this.generateParseException(ex);
        }
        finally {
            this.trace_return("SelectItem");
        }
    }

    @Override
    public final FromContent From() throws ParseException {
        this.trace_call("From");
        try {
            FromContent content = null;
            FromContent content2 = null;
            try {
                Object startPos;
                this.jj_consume_token(26);
                content = this.TableRef();
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(6);
                    content2 = this.TableRef();
                    startPos = content.getPosition();
                    TextPosition endPos = content2.getPosition();
                    content = this.queryFactory.createJoin(ADQLQueryFactory.JoinType.CROSS, content, content2);
                    content.setPosition(new TextPosition((TextPosition)startPos, endPos));
                }
                startPos = content;
                return startPos;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("From");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseConstraints Where() throws ParseException {
        this.trace_call("Where");
        try {
            ClauseConstraints where = new ClauseConstraints("WHERE");
            Token start = this.jj_consume_token(37);
            this.ConditionsList(where);
            TextPosition endPosition = where.getPosition();
            where.setPosition(new TextPosition(start.beginLine, start.beginColumn, endPosition.endLine, endPosition.endColumn));
            ClauseConstraints clauseConstraints = where;
            return clauseConstraints;
        }
        finally {
            this.trace_return("Where");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseADQL<ADQLOperand> GroupBy() throws ParseException {
        this.trace_call("GroupBy");
        try {
            ClauseADQL<ADQLOperand> groupBy = new ClauseADQL<ADQLOperand>("GROUP BY");
            ADQLColumn colRef = null;
            Token start = this.jj_consume_token(48);
            this.jj_consume_token(47);
            colRef = this.Column();
            groupBy.add(colRef);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(6);
                colRef = this.Column();
                groupBy.add(colRef);
            }
            groupBy.setPosition(new TextPosition(new TextPosition(start), colRef.getPosition()));
            ClauseADQL<ADQLOperand> clauseADQL = groupBy;
            return clauseADQL;
        }
        finally {
            this.trace_return("GroupBy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClauseConstraints Having() throws ParseException {
        this.trace_call("Having");
        try {
            ClauseConstraints having = new ClauseConstraints("HAVING");
            Token start = this.jj_consume_token(49);
            this.ConditionsList(having);
            TextPosition endPosition = having.getPosition();
            having.setPosition(new TextPosition(start.beginLine, start.beginColumn, endPosition.endLine, endPosition.endColumn));
            ClauseConstraints clauseConstraints = having;
            return clauseConstraints;
        }
        finally {
            this.trace_return("Having");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseADQL<ADQLOrder> OrderBy() throws ParseException {
        this.trace_call("OrderBy");
        try {
            ClauseADQL<ADQLOrder> orderBy = new ClauseADQL<ADQLOrder>("ORDER BY");
            ADQLOrder order = null;
            Token start = this.jj_consume_token(50);
            this.jj_consume_token(47);
            order = this.OrderItem();
            orderBy.add(order);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(6);
                order = this.OrderItem();
                orderBy.add(order);
            }
            orderBy.setPosition(new TextPosition(start, this.token));
            ClauseADQL<ADQLOrder> clauseADQL = orderBy;
            return clauseADQL;
        }
        finally {
            this.trace_return("OrderBy");
        }
    }

    public final IdentifierItems.IdentifierItem Identifier() throws ParseException {
        this.trace_call("Identifier");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 105: {
                    Token t = this.jj_consume_token(105);
                    this.testRegularIdentifier(t);
                    IdentifierItems.IdentifierItem identifierItem = new IdentifierItems.IdentifierItem(t, false);
                    return identifierItem;
                }
                case 104: {
                    Token t = this.jj_consume_token(104);
                    IdentifierItems.IdentifierItem identifierItem = new IdentifierItems.IdentifierItem(t, true);
                    return identifierItem;
                }
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("Identifier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IdentifierItems TableName() throws ParseException {
        this.trace_call("TableName");
        try {
            IdentifierItems identifiers = new IdentifierItems(true);
            IdentifierItems.IdentifierItem id = null;
            id = this.Identifier();
            identifiers.append(id);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    id = this.Identifier();
                    identifiers.append(id);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    id = this.Identifier();
                    identifiers.append(id);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                }
            }
            IdentifierItems identifierItems = identifiers;
            return identifierItems;
        }
        finally {
            this.trace_return("TableName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IdentifierItems ColumnName() throws ParseException {
        this.trace_call("ColumnName");
        try {
            IdentifierItems table = null;
            IdentifierItems identifiers = new IdentifierItems(false);
            IdentifierItems.IdentifierItem id = this.Identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    this.jj_consume_token(5);
                    table = this.TableName();
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                }
            }
            identifiers.append(id);
            if (table != null) {
                for (int i = 0; i < table.size(); ++i) {
                    identifiers.append(table.get(i));
                }
            }
            IdentifierItems identifierItems = identifiers;
            return identifierItems;
        }
        finally {
            this.trace_return("ColumnName");
        }
    }

    public final ADQLColumn Column() throws ParseException {
        this.trace_call("Column");
        try {
            IdentifierItems identifiers = this.ColumnName();
            try {
                ADQLColumn aDQLColumn = this.queryFactory.createColumn(identifiers);
                return aDQLColumn;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Column");
        }
    }

    public final ADQLOrder OrderItem() throws ParseException {
        this.trace_call("OrderItem");
        try {
            IdentifierItems.IdentifierItem identifier = null;
            Token ind = null;
            Token desc = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 104: 
                case 105: {
                    identifier = this.Identifier();
                    break;
                }
                case 100: {
                    ind = this.jj_consume_token(100);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 51: 
                case 52: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 51: {
                            this.jj_consume_token(51);
                            break block7;
                        }
                        case 52: {
                            desc = this.jj_consume_token(52);
                            break block7;
                        }
                    }
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            try {
                ADQLOrder order = null;
                if (identifier != null) {
                    order = this.queryFactory.createOrder(identifier, desc != null);
                    if (desc == null) {
                        order.setPosition(identifier.position);
                    } else {
                        order.setPosition(new TextPosition(identifier.position, new TextPosition(desc)));
                    }
                } else {
                    order = this.queryFactory.createOrder(Integer.parseInt(ind.image), desc != null);
                    order.getColumnReference().setPosition(new TextPosition(ind));
                    if (desc == null) {
                        order.setPosition(new TextPosition(ind));
                    } else {
                        order.setPosition(new TextPosition(ind, desc));
                    }
                }
                ADQLOrder aDQLOrder = order;
                return aDQLOrder;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("OrderItem");
        }
    }

    public final FromContent SimpleTableRef() throws ParseException {
        this.trace_call("SimpleTableRef");
        try {
            FromContent content;
            block28: {
                IdentifierItems.IdentifierItem alias = null;
                IdentifierItems identifiers = null;
                ADQLSet subQuery = null;
                content = null;
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 104: 
                        case 105: {
                            identifiers = this.TableName();
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 27: 
                                case 104: 
                                case 105: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 27: {
                                            this.jj_consume_token(27);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[24] = this.jj_gen;
                                        }
                                    }
                                    alias = this.Identifier();
                                    break;
                                }
                                default: {
                                    this.jj_la1[25] = this.jj_gen;
                                }
                            }
                            content = this.queryFactory.createTable(identifiers, alias);
                            if (alias == null) {
                                content.setPosition(new TextPosition(identifiers.get((int)0).position, identifiers.get((int)(identifiers.size() - 1)).position));
                            } else {
                                content.setPosition(new TextPosition(identifiers.get((int)0).position, alias.position));
                            }
                            FromContent fromContent = content;
                            return fromContent;
                        }
                    }
                    this.jj_la1[27] = this.jj_gen;
                    if (!this.jj_2_2(2)) break block28;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                subQuery = this.SubQueryExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                alias = this.Identifier();
                content = this.queryFactory.createTable(subQuery, alias);
                if (alias == null) {
                    content.setPosition(new TextPosition(subQuery.getPosition()));
                } else {
                    content.setPosition(new TextPosition(subQuery.getPosition(), alias.position));
                }
                FromContent fromContent = content;
                return fromContent;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    Token start = this.jj_consume_token(3);
                    content = this.JoinedTable();
                    Token end = this.jj_consume_token(4);
                    content.setPosition(new TextPosition(start, end));
                    FromContent fromContent = content;
                    return fromContent;
                }
            }
            this.jj_la1[28] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("SimpleTableRef");
        }
    }

    public final FromContent TableRef() throws ParseException {
        this.trace_call("TableRef");
        try {
            FromContent content = this.SimpleTableRef();
            while (this.jj_2_3(2)) {
                content = this.JoinSpecification(content);
            }
            FromContent fromContent = content;
            return fromContent;
        }
        finally {
            this.trace_return("TableRef");
        }
    }

    public final FromContent JoinedTable() throws ParseException {
        this.trace_call("JoinedTable");
        try {
            FromContent content = this.SimpleTableRef();
            block6: while (true) {
                content = this.JoinSpecification(content);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        continue block6;
                    }
                }
                break;
            }
            this.jj_la1[29] = this.jj_gen;
            FromContent fromContent = content;
            return fromContent;
        }
        finally {
            this.trace_return("JoinedTable");
        }
    }

    /*
     * Exception decompiling
     */
    public final ADQLJoin JoinSpecification(FromContent leftTable) throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final StringConstant String() throws ParseException {
        this.trace_call("String");
        try {
            Token t;
            Token start = null;
            String str = "";
            block9: while (true) {
                t = this.jj_consume_token(97);
                str = str + t.image.substring(1, t.image.length() - 1).replaceAll("''", "'");
                if (start == null) {
                    start = t;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 97: {
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[41] = this.jj_gen;
            try {
                StringConstant cst = this.queryFactory.createStringConstant(str);
                cst.setPosition(new TextPosition(start, t));
                StringConstant stringConstant = cst;
                return stringConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("String");
        }
    }

    public final NumericConstant UnsignedNumeric() throws ParseException {
        this.trace_call("UnsignedNumeric");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 98: {
                    t = this.jj_consume_token(98);
                    break;
                }
                case 99: {
                    t = this.jj_consume_token(99);
                    break;
                }
                case 100: {
                    t = this.jj_consume_token(100);
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                NumericConstant cst = this.queryFactory.createNumericConstant(t.image);
                cst.setPosition(new TextPosition(t));
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UnsignedNumeric");
        }
    }

    public final NumericConstant UnsignedFloat() throws ParseException {
        this.trace_call("UnsignedFloat");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    t = this.jj_consume_token(100);
                    break;
                }
                case 99: {
                    t = this.jj_consume_token(99);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                NumericConstant cst = this.queryFactory.createNumericConstant(t.image);
                cst.setPosition(new TextPosition(t));
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UnsignedFloat");
        }
    }

    public final NumericConstant SignedInteger() throws ParseException {
        this.trace_call("SignedInteger");
        try {
            Token sign = null;
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: {
                            sign = this.jj_consume_token(9);
                            break block3;
                        }
                        case 10: {
                            sign = this.jj_consume_token(10);
                            break block3;
                        }
                    }
                    this.jj_la1[44] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                }
            }
            Token number = this.jj_consume_token(100);
            try {
                NumericConstant cst;
                if (sign == null) {
                    cst = this.queryFactory.createNumericConstant(number.image);
                    cst.setPosition(new TextPosition(number));
                } else {
                    cst = this.queryFactory.createNumericConstant(sign.image + number.image);
                    cst.setPosition(new TextPosition(sign, number));
                }
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("SignedInteger");
        }
    }

    public final ADQLOperand NumericValueExpressionPrimary() throws ParseException {
        this.trace_call("NumericValueExpressionPrimary");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: {
                    Token left = this.jj_consume_token(42);
                    NullValue op = this.queryFactory.createNullValue();
                    op.setPosition(new TextPosition(left));
                    NullValue nullValue = op;
                    return nullValue;
                }
                case 98: 
                case 99: 
                case 100: {
                    NumericConstant op;
                    NumericConstant numericConstant = op = this.UnsignedNumeric();
                    return numericConstant;
                }
                case 104: 
                case 105: {
                    ADQLColumn column = this.Column();
                    column.setExpectedType('N');
                    ADQLColumn aDQLColumn = column;
                    return aDQLColumn;
                }
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    SQLFunction op;
                    SQLFunction sQLFunction = op = this.SqlFunction();
                    return sQLFunction;
                }
                case 3: {
                    Token left = this.jj_consume_token(3);
                    ADQLOperand op = this.NumericExpression();
                    Token right = this.jj_consume_token(4);
                    WrappedOperand wop = this.queryFactory.createWrappedOperand(op);
                    wop.setPosition(new TextPosition(left, right));
                    WrappedOperand wrappedOperand = wop;
                    return wrappedOperand;
                }
            }
            try {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("NumericValueExpressionPrimary");
        }
    }

    public final ADQLOperand StringValueExpressionPrimary() throws ParseException {
        this.trace_call("StringValueExpressionPrimary");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: {
                    Token left = this.jj_consume_token(42);
                    NullValue op = this.queryFactory.createNullValue();
                    op.setPosition(new TextPosition(left));
                    NullValue nullValue = op;
                    return nullValue;
                }
                case 97: {
                    StringConstant expr;
                    StringConstant stringConstant = expr = this.String();
                    return stringConstant;
                }
                case 98: 
                case 99: 
                case 100: {
                    NumericConstant op;
                    NumericConstant numericConstant = op = this.UnsignedNumeric();
                    return numericConstant;
                }
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    SQLFunction op;
                    SQLFunction sQLFunction = op = this.SqlFunction();
                    return sQLFunction;
                }
                case 104: 
                case 105: {
                    ADQLColumn column = this.Column();
                    column.setExpectedType('*');
                    ADQLColumn aDQLColumn = column;
                    return aDQLColumn;
                }
                case 3: {
                    Token left = this.jj_consume_token(3);
                    ADQLOperand op = this.ValueExpression();
                    Token right = this.jj_consume_token(4);
                    WrappedOperand wop = this.queryFactory.createWrappedOperand(op);
                    wop.setPosition(new TextPosition(left, right));
                    WrappedOperand wrappedOperand = wop;
                    return wrappedOperand;
                }
            }
            try {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("StringValueExpressionPrimary");
        }
    }

    public final ADQLOperand ValueExpression() throws ParseException {
        this.trace_call("ValueExpression");
        try {
            ADQLOperand valueExpr = null;
            try {
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    valueExpr = this.NumericExpression();
                } else if (this.jj_2_5(Integer.MAX_VALUE)) {
                    valueExpr = this.StringExpression();
                } else if (this.jj_2_6(Integer.MAX_VALUE)) {
                    Token left = this.jj_consume_token(3);
                    valueExpr = this.ValueExpression();
                    Token right = this.jj_consume_token(4);
                    valueExpr = this.queryFactory.createWrappedOperand(valueExpr);
                    ((WrappedOperand)valueExpr).setPosition(new TextPosition(left, right));
                } else if (this.jj_2_7(Integer.MAX_VALUE)) {
                    valueExpr = this.UserDefinedFunction();
                } else if (this.jj_2_8(2)) {
                    valueExpr = this.GeometryValueFunction();
                } else if (this.jj_2_9(Integer.MAX_VALUE)) {
                    valueExpr = this.Column();
                } else if (this.jj_2_10(Integer.MAX_VALUE)) {
                    valueExpr = this.StringFactor();
                } else if (this.jj_2_11(3)) {
                    valueExpr = this.Factor();
                } else if (this.jj_2_12(2)) {
                    valueExpr = this.NumericFunction();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 104: 
                        case 105: {
                            valueExpr = this.Column();
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                ADQLOperand aDQLOperand = valueExpr;
                return aDQLOperand;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ValueExpression");
        }
    }

    public final ADQLOperand NumericExpression() throws ParseException {
        this.trace_call("NumericExpression");
        try {
            Token sign = null;
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.NumericTerm();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: {
                            sign = this.jj_consume_token(9);
                            break;
                        }
                        case 10: {
                            sign = this.jj_consume_token(10);
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    rightOp = this.NumericExpression();
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                }
            }
            if (sign == null) {
                ADQLOperand aDQLOperand = leftOp;
                return aDQLOperand;
            }
            Operation operation = this.queryFactory.createOperation(leftOp, OperationType.getOperator(sign.image), rightOp);
            operation.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
            Operation operation2 = operation;
            return operation2;
        }
        finally {
            this.trace_return("NumericExpression");
        }
    }

    public final ADQLOperand NumericTerm() throws ParseException {
        this.trace_call("NumericTerm");
        try {
            Token sign = null;
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.Factor();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 11: {
                            sign = this.jj_consume_token(11);
                            break;
                        }
                        case 12: {
                            sign = this.jj_consume_token(12);
                            break;
                        }
                        default: {
                            this.jj_la1[51] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    rightOp = this.NumericTerm();
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                }
            }
            if (sign == null) {
                ADQLOperand aDQLOperand = leftOp;
                return aDQLOperand;
            }
            Operation operation = this.queryFactory.createOperation(leftOp, OperationType.getOperator(sign.image), rightOp);
            operation.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
            Operation operation2 = operation;
            return operation2;
        }
        finally {
            this.trace_return("NumericTerm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand Factor() throws ParseException {
        this.trace_call("Factor");
        try {
            ADQLOperand op;
            boolean negative = false;
            Token minusSign = null;
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: {
                            this.jj_consume_token(9);
                            break block2;
                        }
                        case 10: {
                            minusSign = this.jj_consume_token(10);
                            negative = true;
                            break block2;
                        }
                    }
                    this.jj_la1[53] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                }
            }
            if (this.jj_2_13(2)) {
                op = this.NumericFunction();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: 
                    case 42: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: {
                        op = this.NumericValueExpressionPrimary();
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            if (negative) {
                try {
                    TextPosition position = op.getPosition();
                    op = this.queryFactory.createNegativeOperand(op);
                    NegativeOperand negativeOp = (NegativeOperand)op;
                    if (minusSign != null) {
                        negativeOp.setPosition(new TextPosition(minusSign.beginLine, minusSign.beginColumn, position.endLine, position.endColumn));
                    } else {
                        negativeOp.setPosition(position);
                    }
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            ADQLFunction aDQLFunction = op;
            return aDQLFunction;
        }
        finally {
            this.trace_return("Factor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ADQLOperand StringExpression() throws ParseException {
        this.trace_call("StringExpression");
        try {
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.StringFactor();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(8);
                rightOp = this.StringFactor();
                if (!(leftOp instanceof Concatenation)) {
                    try {
                        ADQLOperand temp = leftOp;
                        leftOp = this.queryFactory.createConcatenation();
                        ((Concatenation)leftOp).add(temp);
                    }
                    catch (Exception ex) {
                        throw this.generateParseException(ex);
                    }
                }
                ((Concatenation)leftOp).add(rightOp);
            }
            if (leftOp instanceof Concatenation) {
                Concatenation concat = (Concatenation)leftOp;
                concat.setPosition(new TextPosition(((ADQLOperand)concat.get(0)).getPosition(), ((ADQLOperand)concat.get(concat.size() - 1)).getPosition()));
            }
            ADQLOperand aDQLOperand = leftOp;
            return aDQLOperand;
        }
        finally {
            this.trace_return("StringExpression");
        }
    }

    public final ADQLOperand StringFactor() throws ParseException {
        this.trace_call("StringFactor");
        try {
            ADQLOperand op;
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 69: {
                    op = this.ExtractCoordSys();
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    if (this.jj_2_14(2)) {
                        op = this.UserDefinedFunction();
                        ((UserDefinedFunction)op).setExpectedType('S');
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 3: 
                        case 42: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 104: 
                        case 105: {
                            op = this.StringValueExpressionPrimary();
                            break block1;
                        }
                    }
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            GeometryFunction geometryFunction = op;
            return geometryFunction;
        }
        finally {
            this.trace_return("StringFactor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction.GeometryValue<GeometryFunction> GeometryExpression() throws ParseException {
        this.trace_call("GeometryExpression");
        try {
            ADQLColumn col = null;
            GeometryFunction gf = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 104: 
                case 105: {
                    col = this.Column();
                    break;
                }
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    gf = this.GeometryValueFunction();
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (col != null) {
                col.setExpectedType('G');
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(col);
                return geometryValue;
            }
            GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(gf);
            return geometryValue;
        }
        finally {
            this.trace_return("GeometryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClauseConstraints ConditionsList(ClauseConstraints clause) throws ParseException {
        this.trace_call("ConditionsList");
        try {
            block25: {
                ADQLConstraint constraint = null;
                Token op = null;
                boolean notOp = false;
                try {
                    TextPosition oldPos;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 40: {
                            op = this.jj_consume_token(40);
                            notOp = true;
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                        }
                    }
                    constraint = this.Constraint();
                    if (notOp) {
                        oldPos = constraint.getPosition();
                        constraint = this.queryFactory.createNot(constraint);
                        ((NotConstraint)constraint).setPosition(new TextPosition(op.beginLine, op.beginColumn, oldPos.endLine, oldPos.endColumn));
                    }
                    notOp = false;
                    if (clause instanceof ADQLConstraint) {
                        clause.add(constraint);
                    } else {
                        clause.add(constraint);
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 38: 
                            case 39: {
                                break;
                            }
                            default: {
                                this.jj_la1[61] = this.jj_gen;
                                break block25;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 38: {
                                op = this.jj_consume_token(38);
                                break;
                            }
                            case 39: {
                                op = this.jj_consume_token(39);
                                break;
                            }
                            default: {
                                this.jj_la1[62] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 40: {
                                this.jj_consume_token(40);
                                notOp = true;
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                            }
                        }
                        constraint = this.Constraint();
                        if (notOp) {
                            oldPos = constraint.getPosition();
                            constraint = this.queryFactory.createNot(constraint);
                            ((NotConstraint)constraint).setPosition(new TextPosition(op.beginLine, op.beginColumn, oldPos.endLine, oldPos.endColumn));
                        }
                        notOp = false;
                        if (clause instanceof ADQLConstraint) {
                            clause.add(op.image, constraint);
                            continue;
                        }
                        clause.add(op.image, constraint);
                    }
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            if (!clause.isEmpty()) {
                TextPosition start = ((ADQLConstraint)clause.get(0)).getPosition();
                TextPosition end = ((ADQLConstraint)clause.get(clause.size() - 1)).getPosition();
                clause.setPosition(new TextPosition(start, end));
            }
            ClauseConstraints clauseConstraints = clause;
            return clauseConstraints;
        }
        finally {
            this.trace_return("ConditionsList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLConstraint Constraint() throws ParseException {
        this.trace_call("Constraint");
        try {
            ADQLConstraint constraint = null;
            if (this.jj_2_15(Integer.MAX_VALUE)) {
                Token start = this.jj_consume_token(3);
                try {
                    constraint = this.queryFactory.createGroupOfConstraints();
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                this.ConditionsList((ClauseConstraints)((Object)constraint));
                Token end = this.jj_consume_token(4);
                ((ADQLList)((Object)constraint)).setPosition(new TextPosition(start, end));
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: 
                    case 9: 
                    case 10: 
                    case 42: 
                    case 46: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: {
                        constraint = this.Predicate();
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            ADQLConstraint aDQLConstraint = constraint;
            return aDQLConstraint;
        }
        finally {
            this.trace_return("Constraint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final ADQLConstraint Predicate() throws ParseException {
        this.trace_call("Predicate");
        try {
            block29: {
                q = null;
                column = null;
                strExpr1 = null;
                strExpr2 = null;
                notToken = null;
                constraint /* !! */  = null;
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 46: {
                            start = this.jj_consume_token(46);
                            q = this.SubQueryExpression();
                            e = this.queryFactory.createExists(q);
                            e.setPosition(new TextPosition(start.beginLine, start.beginColumn, q.getPosition().endLine, q.getPosition().endColumn));
                            var11_13 = e;
                            return var11_13;
                        }
                    }
                    this.jj_la1[69] = this.jj_gen;
                    if (!this.jj_2_17(0x7FFFFFFF)) break block29;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                column = this.Column();
                this.jj_consume_token(41);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 40: {
                        notToken = this.jj_consume_token(40);
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                    }
                }
                end = this.jj_consume_token(42);
                in = this.queryFactory.createIsNull(notToken != null, column);
                in.setPosition(new TextPosition(column.getPosition().beginLine, column.getPosition().beginColumn, end.endLine, end.endColumn < 0 ? -1 : end.endColumn + 1));
                var11_14 = in;
                return var11_14;
            }
            if (this.jj_2_18(0x7FFFFFFF)) {
                strExpr1 = this.StringExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 40: {
                        notToken = this.jj_consume_token(40);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                    }
                }
                this.jj_consume_token(44);
                strExpr2 = this.StringExpression();
                comp = this.queryFactory.createComparison(strExpr1, notToken == null ? ComparisonOperator.LIKE : ComparisonOperator.NOTLIKE, strExpr2);
                comp.setPosition(new TextPosition(strExpr1.getPosition(), strExpr2.getPosition()));
                var11_15 = comp;
                return var11_15;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 9: 
                case 10: 
                case 42: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 104: 
                case 105: {
                    op = this.ValueExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            constraint /* !! */  = this.ComparisonEnd(op);
                            ** break;
                        }
                    }
                    this.jj_la1[67] = this.jj_gen;
                    if (this.jj_2_16(2)) {
                        constraint /* !! */  = this.BetweenEnd(op);
                        ** break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 40: 
                        case 45: {
                            constraint /* !! */  = this.InEnd(op);
                            ** break;
                        }
                    }
                    this.jj_la1[68] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
lbl78:
            // 3 sources

            var10_12 = constraint /* !! */ ;
            return var10_12;
        }
        finally {
            this.trace_return("Predicate");
        }
    }

    public final Comparison ComparisonEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("ComparisonEnd");
        try {
            Token comp;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: {
                    comp = this.jj_consume_token(17);
                    break;
                }
                case 18: {
                    comp = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    comp = this.jj_consume_token(19);
                    break;
                }
                case 20: {
                    comp = this.jj_consume_token(20);
                    break;
                }
                case 21: {
                    comp = this.jj_consume_token(21);
                    break;
                }
                case 22: {
                    comp = this.jj_consume_token(22);
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLOperand rightOp = this.ValueExpression();
            try {
                Comparison comparison = this.queryFactory.createComparison(leftOp, ComparisonOperator.getOperator(comp.image), rightOp);
                comparison.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
                Comparison comparison2 = comparison;
                return comparison2;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ComparisonEnd");
        }
    }

    public final Between BetweenEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("BetweenEnd");
        try {
            Token notToken = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    notToken = this.jj_consume_token(40);
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                }
            }
            Token start = this.jj_consume_token(43);
            ADQLOperand min = this.ValueExpression();
            this.jj_consume_token(38);
            ADQLOperand max = this.ValueExpression();
            try {
                Between bet = this.queryFactory.createBetween(notToken != null, leftOp, min, max);
                if (notToken != null) {
                    start = notToken;
                }
                bet.setPosition(new TextPosition(start.beginLine, start.beginColumn, max.getPosition().endLine, max.getPosition().endColumn));
                Between between = bet;
                return between;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("BetweenEnd");
        }
    }

    public final In InEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("InEnd");
        try {
            Token not = null;
            ADQLSet q = null;
            Vector<ADQLOperand> items = new Vector<ADQLOperand>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    not = this.jj_consume_token(40);
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                }
            }
            Token start = this.jj_consume_token(45);
            if (this.jj_2_19(2)) {
                q = this.SubQueryExpression();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        ADQLOperand item = this.ValueExpression();
                        items.add(item);
                        block15: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[74] = this.jj_gen;
                                    break block15;
                                }
                            }
                            this.jj_consume_token(6);
                            item = this.ValueExpression();
                            items.add(item);
                        }
                        this.jj_consume_token(4);
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            try {
                In in;
                Token token = start = not != null ? not : start;
                if (q != null) {
                    in = this.queryFactory.createIn(leftOp, q, not != null);
                    in.setPosition(new TextPosition(start.beginLine, start.beginColumn, q.getPosition().endLine, q.getPosition().endColumn));
                } else {
                    ADQLOperand[] list = new ADQLOperand[items.size()];
                    int i = 0;
                    for (ADQLOperand op : items) {
                        list[i++] = op;
                    }
                    in = this.queryFactory.createIn(leftOp, list, not != null);
                    in.setPosition(new TextPosition(start.beginLine, start.beginColumn, list[list.length - 1].getPosition().endLine, list[list.length - 1].getPosition().endColumn));
                }
                In in2 = in;
                return in2;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("InEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLFunction SqlFunction() throws ParseException {
        this.trace_call("SqlFunction");
        try {
            Token all = null;
            Token distinct = null;
            ADQLOperand op = null;
            SQLFunction funct = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 57: {
                        Token fct = this.jj_consume_token(57);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: {
                                distinct = this.jj_consume_token(24);
                                break;
                            }
                            default: {
                                this.jj_la1[76] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 11: {
                                all = this.jj_consume_token(11);
                                break;
                            }
                            case 3: 
                            case 9: 
                            case 10: 
                            case 42: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 104: 
                            case 105: {
                                op = this.ValueExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[77] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token end = this.jj_consume_token(4);
                        funct = this.queryFactory.createSQLFunction(all != null ? SQLFunctionType.COUNT_ALL : SQLFunctionType.COUNT, op, distinct != null && distinct.image.equalsIgnoreCase("distinct"));
                        funct.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: {
                        Token fct;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 53: {
                                fct = this.jj_consume_token(53);
                                break;
                            }
                            case 54: {
                                fct = this.jj_consume_token(54);
                                break;
                            }
                            case 55: {
                                fct = this.jj_consume_token(55);
                                break;
                            }
                            case 56: {
                                fct = this.jj_consume_token(56);
                                break;
                            }
                            default: {
                                this.jj_la1[78] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: {
                                distinct = this.jj_consume_token(24);
                                break;
                            }
                            default: {
                                this.jj_la1[79] = this.jj_gen;
                            }
                        }
                        op = this.ValueExpression();
                        Token end = this.jj_consume_token(4);
                        funct = this.queryFactory.createSQLFunction(SQLFunctionType.valueOf(fct.image.toUpperCase()), op, distinct != null && distinct.image.equalsIgnoreCase("distinct"));
                        funct.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    default: {
                        this.jj_la1[80] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            SQLFunction sQLFunction = funct;
            return sQLFunction;
        }
        finally {
            this.trace_return("SqlFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand[] Coordinates() throws ParseException {
        this.trace_call("Coordinates");
        try {
            ADQLOperand op1 = this.NumericExpression();
            this.jj_consume_token(6);
            ADQLOperand op2 = this.NumericExpression();
            ADQLOperand[] aDQLOperandArray = new ADQLOperand[]{op1, op2};
            return aDQLOperandArray;
        }
        finally {
            this.trace_return("Coordinates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction GeometryFunction() throws ParseException {
        this.trace_call("GeometryFunction");
        try {
            Token end;
            Token fct = null;
            GeometryFunction gf = null;
            PointFunction p1 = null;
            PointFunction p2 = null;
            ADQLColumn col1 = null;
            ADQLColumn col2 = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 64: 
                    case 65: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 64: {
                                fct = this.jj_consume_token(64);
                                break;
                            }
                            case 65: {
                                fct = this.jj_consume_token(65);
                                break;
                            }
                            default: {
                                this.jj_la1[81] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(3);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf1 = this.GeometryExpression();
                        this.jj_consume_token(6);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf2 = this.GeometryExpression();
                        end = this.jj_consume_token(4);
                        if (fct.image.equalsIgnoreCase("contains")) {
                            gf = this.queryFactory.createContains(gvf1, gvf2);
                            break;
                        }
                        gf = this.queryFactory.createIntersects(gvf1, gvf2);
                        break;
                    }
                    case 66: {
                        fct = this.jj_consume_token(66);
                        this.jj_consume_token(3);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf1 = this.GeometryExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createArea(gvf1);
                        break;
                    }
                    case 67: {
                        fct = this.jj_consume_token(67);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 61: {
                                p1 = this.Point();
                                gf = this.queryFactory.createCoord1(p1);
                                break;
                            }
                            case 104: 
                            case 105: {
                                col1 = this.Column();
                                col1.setExpectedType('G');
                                gf = this.queryFactory.createCoord1(col1);
                                break;
                            }
                            default: {
                                this.jj_la1[82] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 68: {
                        fct = this.jj_consume_token(68);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 61: {
                                p1 = this.Point();
                                gf = this.queryFactory.createCoord2(p1);
                                break;
                            }
                            case 104: 
                            case 105: {
                                col1 = this.Column();
                                col1.setExpectedType('G');
                                gf = this.queryFactory.createCoord2(col1);
                                break;
                            }
                            default: {
                                this.jj_la1[83] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 70: {
                        GeometryFunction.GeometryValue<GeometryFunction> gvp2;
                        GeometryFunction.GeometryValue<GeometryFunction> gvp1;
                        fct = this.jj_consume_token(70);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 61: {
                                p1 = this.Point();
                                break;
                            }
                            case 104: 
                            case 105: {
                                col1 = this.Column();
                                break;
                            }
                            default: {
                                this.jj_la1[84] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (p1 != null) {
                            gvp1 = new GeometryFunction.GeometryValue<PointFunction>(p1);
                        } else {
                            col1.setExpectedType('G');
                            gvp1 = new GeometryFunction.GeometryValue(col1);
                        }
                        this.jj_consume_token(6);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 61: {
                                p2 = this.Point();
                                break;
                            }
                            case 104: 
                            case 105: {
                                col2 = this.Column();
                                break;
                            }
                            default: {
                                this.jj_la1[85] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (p2 != null) {
                            gvp2 = new GeometryFunction.GeometryValue<PointFunction>(p2);
                        } else {
                            col2.setExpectedType('G');
                            gvp2 = new GeometryFunction.GeometryValue(col2);
                        }
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createDistance(gvp1, gvp2);
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            gf.setPosition(new TextPosition(fct, end));
            GeometryFunction geometryFunction = gf;
            return geometryFunction;
        }
        finally {
            this.trace_return("GeometryFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand CoordinateSystem() throws ParseException {
        this.trace_call("CoordinateSystem");
        try {
            ADQLOperand coordSys = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: {
                    Token tok = this.jj_consume_token(42);
                    coordSys = this.queryFactory.createNullValue();
                    ((NullValue)coordSys).setPosition(new TextPosition(tok));
                    break;
                }
                case 97: {
                    coordSys = this.String();
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            StringConstant stringConstant = coordSys;
            return stringConstant;
        }
        finally {
            this.trace_return("CoordinateSystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction GeometryValueFunction() throws ParseException {
        this.trace_call("GeometryValueFunction");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand op = null;
            GeometryFunction.GeometryValue<GeometryFunction> gvf = null;
            GeometryFunction gf = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 58: {
                        fct = this.jj_consume_token(58);
                        this.jj_consume_token(3);
                        ADQLOperand coordSys = this.CoordinateSystem();
                        this.jj_consume_token(6);
                        ADQLOperand[] coords = this.Coordinates();
                        this.jj_consume_token(6);
                        ADQLOperand width = this.NumericExpression();
                        this.jj_consume_token(6);
                        ADQLOperand height = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createBox(coordSys, coords[0], coords[1], width, height);
                        break;
                    }
                    case 59: {
                        fct = this.jj_consume_token(59);
                        this.jj_consume_token(3);
                        gvf = this.GeometryExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createCentroid(gvf);
                        break;
                    }
                    case 60: {
                        fct = this.jj_consume_token(60);
                        this.jj_consume_token(3);
                        ADQLOperand coordSys = this.CoordinateSystem();
                        this.jj_consume_token(6);
                        ADQLOperand[] coords = this.Coordinates();
                        this.jj_consume_token(6);
                        ADQLOperand width = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createCircle(coordSys, coords[0], coords[1], width);
                        break;
                    }
                    case 61: {
                        gf = this.Point();
                        break;
                    }
                    case 62: {
                        fct = this.jj_consume_token(62);
                        this.jj_consume_token(3);
                        ADQLOperand coordSys = this.CoordinateSystem();
                        Vector<ADQLOperand> vCoords = new Vector<ADQLOperand>();
                        this.jj_consume_token(6);
                        ADQLOperand[] tmp = this.Coordinates();
                        vCoords.add(tmp[0]);
                        vCoords.add(tmp[1]);
                        this.jj_consume_token(6);
                        tmp = this.Coordinates();
                        vCoords.add(tmp[0]);
                        vCoords.add(tmp[1]);
                        this.jj_consume_token(6);
                        tmp = this.Coordinates();
                        vCoords.add(tmp[0]);
                        vCoords.add(tmp[1]);
                        block16: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[88] = this.jj_gen;
                                    break block16;
                                }
                            }
                            this.jj_consume_token(6);
                            tmp = this.Coordinates();
                            vCoords.add(tmp[0]);
                            vCoords.add(tmp[1]);
                        }
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createPolygon(coordSys, vCoords);
                        break;
                    }
                    case 63: {
                        fct = this.jj_consume_token(63);
                        this.jj_consume_token(3);
                        op = this.StringExpression();
                        end = this.jj_consume_token(4);
                        gf = this.queryFactory.createRegion(op);
                        break;
                    }
                    default: {
                        this.jj_la1[89] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            if (fct != null && end != null) {
                gf.setPosition(new TextPosition(fct, end));
            }
            PointFunction pointFunction = gf;
            return pointFunction;
        }
        finally {
            this.trace_return("GeometryValueFunction");
        }
    }

    public final PointFunction Point() throws ParseException {
        this.trace_call("Point");
        try {
            Token start = this.jj_consume_token(61);
            this.jj_consume_token(3);
            ADQLOperand coordSys = this.CoordinateSystem();
            this.jj_consume_token(6);
            ADQLOperand[] coords = this.Coordinates();
            Token end = this.jj_consume_token(4);
            try {
                PointFunction pf = this.queryFactory.createPoint(coordSys, coords[0], coords[1]);
                pf.setPosition(new TextPosition(start, end));
                PointFunction pointFunction = pf;
                return pointFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Point");
        }
    }

    public final GeometryFunction ExtractCoordSys() throws ParseException {
        this.trace_call("ExtractCoordSys");
        try {
            Token start = this.jj_consume_token(69);
            this.jj_consume_token(3);
            GeometryFunction.GeometryValue<GeometryFunction> gvf = this.GeometryExpression();
            Token end = this.jj_consume_token(4);
            try {
                ExtractCoordSys gf = this.queryFactory.createExtractCoordSys(gvf);
                gf.setPosition(new TextPosition(start, end));
                ExtractCoordSys extractCoordSys = gf;
                return extractCoordSys;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ExtractCoordSys");
        }
    }

    public final ADQLFunction NumericFunction() throws ParseException {
        this.trace_call("NumericFunction");
        try {
            ADQLFunction fct;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: {
                    fct = this.MathFunction();
                    break;
                }
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: {
                    fct = this.TrigFunction();
                    break;
                }
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: {
                    fct = this.GeometryFunction();
                    break;
                }
                case 105: {
                    fct = this.UserDefinedFunction();
                    ((UserDefinedFunction)fct).setExpectedType('N');
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLFunction aDQLFunction = fct;
            return aDQLFunction;
        }
        finally {
            this.trace_return("NumericFunction");
        }
    }

    public final MathFunction MathFunction() throws ParseException {
        this.trace_call("MathFunction");
        try {
            Token fct = null;
            ADQLOperand param1 = null;
            ADQLOperand param2 = null;
            Object integerValue = null;
            try {
                Token end;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        fct = this.jj_consume_token(71);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 72: {
                        fct = this.jj_consume_token(72);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 73: {
                        fct = this.jj_consume_token(73);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 74: {
                        fct = this.jj_consume_token(74);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 75: {
                        fct = this.jj_consume_token(75);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 76: {
                        fct = this.jj_consume_token(76);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 77: {
                        fct = this.jj_consume_token(77);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 78: {
                        fct = this.jj_consume_token(78);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        this.jj_consume_token(6);
                        param2 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 79: {
                        fct = this.jj_consume_token(79);
                        this.jj_consume_token(3);
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 80: {
                        fct = this.jj_consume_token(80);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        this.jj_consume_token(6);
                        param2 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 81: {
                        fct = this.jj_consume_token(81);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 82: {
                        fct = this.jj_consume_token(82);
                        this.jj_consume_token(3);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 3: 
                            case 9: 
                            case 10: 
                            case 42: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 104: 
                            case 105: {
                                param1 = this.NumericExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[91] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 83: {
                        fct = this.jj_consume_token(83);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 6: {
                                this.jj_consume_token(6);
                                param2 = this.SignedInteger();
                                break;
                            }
                            default: {
                                this.jj_la1[92] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 84: {
                        fct = this.jj_consume_token(84);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(4);
                        break;
                    }
                    case 85: {
                        fct = this.jj_consume_token(85);
                        this.jj_consume_token(3);
                        param1 = this.NumericExpression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 6: {
                                this.jj_consume_token(6);
                                param2 = this.SignedInteger();
                                break;
                            }
                            default: {
                                this.jj_la1[93] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(4);
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                MathFunction mf = this.queryFactory.createMathFunction(MathFunctionType.valueOf(fct.image.toUpperCase()), param1, param2);
                mf.setPosition(new TextPosition(fct, end));
                MathFunction mathFunction = mf;
                return mathFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("MathFunction");
        }
    }

    public final MathFunction TrigFunction() throws ParseException {
        this.trace_call("TrigFunction");
        try {
            Token end;
            Token fct = null;
            ADQLOperand param1 = null;
            ADQLOperand param2 = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 86: {
                    fct = this.jj_consume_token(86);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 87: {
                    fct = this.jj_consume_token(87);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 88: {
                    fct = this.jj_consume_token(88);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 89: {
                    fct = this.jj_consume_token(89);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    this.jj_consume_token(6);
                    param2 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 90: {
                    fct = this.jj_consume_token(90);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 91: {
                    fct = this.jj_consume_token(91);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 92: {
                    fct = this.jj_consume_token(92);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                case 93: {
                    fct = this.jj_consume_token(93);
                    this.jj_consume_token(3);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                MathFunction mf = this.queryFactory.createMathFunction(MathFunctionType.valueOf(fct.image.toUpperCase()), param1, param2);
                mf.setPosition(new TextPosition(fct, end));
                MathFunction mathFunction = mf;
                return mathFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("TrigFunction");
        }
    }

    /*
     * Exception decompiling
     */
    public final UserDefinedFunction UserDefinedFunction() throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    private boolean jj_3R_JoinSpecification_732_26_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(29)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_732_36_78()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_732_25_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_732_26_57()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_3R_SimpleTableRef_676_9_58()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_734_33_202()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_741_33_203()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_BetweenEnd_1129_9_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_ValueExpression_870_9_53();
    }

    private boolean jj_3R_JoinSpecification_725_25_34() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_725_52_56()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_SimpleTableRef_676_9_58();
    }

    private boolean jj_3R_Predicate_1105_27_144() {
        return this.jj_3R_InEnd_1143_9_153();
    }

    private boolean jj_3_16() {
        return this.jj_3R_BetweenEnd_1129_9_28();
    }

    private boolean jj_3R_Predicate_1101_25_143() {
        return this.jj_3R_ComparisonEnd_1116_9_152();
    }

    private boolean jj_3R_ComparisonEnd_1116_9_152() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(18)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(19)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(20)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(21)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(22)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_ValueExpression_870_9_53();
    }

    private boolean jj_3_18() {
        if (this.jj_3R_StringExpression_958_9_29()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_Predicate_1099_19_122() {
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Predicate_1101_25_143()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_16()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Predicate_1105_27_144()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_723_9_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_725_25_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_732_25_35()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        if (this.jj_3R_Column_639_9_22()) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_JoinedTable_717_11_201() {
        return this.jj_3R_JoinSpecification_723_9_17();
    }

    private boolean jj_3R_SimpleTableRef_678_50_199() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(27)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_Predicate_1092_19_121() {
        if (this.jj_3R_StringExpression_958_9_29()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_StringExpression_958_9_29();
    }

    private boolean jj_3R_JoinedTable_716_9_200() {
        Token xsp;
        if (this.jj_3R_SimpleTableRef_676_9_58()) {
            return true;
        }
        if (this.jj_3R_JoinedTable_717_11_201()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_JoinedTable_717_11_201());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SimpleTableRef_698_25_80() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_JoinedTable_716_9_200()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_3() {
        return this.jj_3R_JoinSpecification_723_9_17();
    }

    private boolean jj_3R_Predicate_1084_19_120() {
        if (this.jj_3R_Column_639_9_22()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_TableRef_710_9_177() {
        Token xsp;
        if (this.jj_3R_SimpleTableRef_676_9_58()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_3());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_UserDefinedFunction_1389_96_148() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_870_9_53();
    }

    private boolean jj_3R_Predicate_1076_19_119() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_3R_SubQueryExpression_457_9_16();
    }

    private boolean jj_3R_OrderItem_650_61_198() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(51)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(52)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_3R_SubQueryExpression_457_9_16()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(27)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_SimpleTableRef_678_25_79() {
        if (this.jj_3R_TableName_613_9_83()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleTableRef_678_50_199()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_Constraint_1067_18_52() {
        return this.jj_3R_Predicate_1073_9_69();
    }

    private boolean jj_3R_Predicate_1073_9_69() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Predicate_1076_19_119()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Predicate_1084_19_120()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Predicate_1092_19_121()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_Predicate_1099_19_122()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Constraint_1054_9_27();
    }

    private boolean jj_3R_SimpleTableRef_676_9_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SimpleTableRef_678_25_79()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_2()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SimpleTableRef_698_25_80()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_Constraint_1054_10_51() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ConditionsList_1006_9_68()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Constraint_1054_9_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Constraint_1054_10_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Constraint_1067_18_52()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_UserDefinedFunction_1389_56_131() {
        Token xsp;
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_UserDefinedFunction_1389_96_148());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ConditionsList_1024_26_142() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_MathFunction_1357_74_170() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SignedInteger_813_9_184();
    }

    private boolean jj_3R_ConditionsList_1023_25_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(38)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(39)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_ConditionsList_1024_26_142()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Constraint_1054_9_27();
    }

    private boolean jj_3R_OrderItem_650_10_197() {
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_MathFunction_1355_71_169() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SignedInteger_813_9_184();
    }

    private boolean jj_3R_OrderItem_650_9_191() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_OrderItem_650_10_197()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(100)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_OrderItem_650_61_198()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_ColumnName_627_28_62() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_TableName_613_9_83();
    }

    private boolean jj_3R_Column_639_9_22() {
        return this.jj_3R_ColumnName_627_9_43();
    }

    private boolean jj_3R_ConditionsList_1007_18_117() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_ColumnName_627_9_43() {
        if (this.jj_3R_Identifier_595_9_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ColumnName_627_28_62()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_GeometryExpression_992_25_147() {
        return this.jj_3R_GeometryValueFunction_1261_9_21();
    }

    private boolean jj_3R_TableName_616_18_139() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_TableName_615_18_138() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_ConditionsList_1006_9_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ConditionsList_1007_18_117()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_Constraint_1054_9_27()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_ConditionsList_1023_25_118());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_UserDefinedFunction_1389_9_26() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_UserDefinedFunction_1389_56_131()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1354_43_154() {
        return this.jj_3R_NumericExpression_899_9_123();
    }

    private boolean jj_3R_TableName_613_9_83() {
        if (this.jj_3R_Identifier_595_9_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TableName_615_18_138()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_TableName_616_18_139()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_TrigFunction_1376_11_111() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1375_11_110() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryExpression_992_10_146() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_Identifier_602_17_31() {
        return this.jj_scan_token(104);
    }

    private boolean jj_3R_TrigFunction_1374_11_109() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryExpression_992_9_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryExpression_992_10_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryExpression_992_25_147()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_TrigFunction_1373_11_108() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1372_11_107() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_TrigFunction_1371_11_106() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_StringFactor_987_11_60() {
        return this.jj_3R_StringValueExpressionPrimary_850_9_82();
    }

    private boolean jj_3R_TrigFunction_1370_11_105() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_14() {
        return this.jj_3R_UserDefinedFunction_1389_9_26();
    }

    private boolean jj_3R_Identifier_596_17_30() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3R_TrigFunction_1369_10_104() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_StringFactor_985_10_59() {
        return this.jj_3R_ExtractCoordSys_1318_9_81();
    }

    private boolean jj_3R_TrigFunction_1369_9_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TrigFunction_1369_10_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_TrigFunction_1370_11_105()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_TrigFunction_1371_11_106()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_TrigFunction_1372_11_107()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_TrigFunction_1373_11_108()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_TrigFunction_1374_11_109()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_TrigFunction_1375_11_110()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_TrigFunction_1376_11_111()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_StringFactor_985_9_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringFactor_985_10_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_14()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_StringFactor_987_11_60()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_MathFunction_1357_19_103() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1357_74_170()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1356_19_102() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1355_19_101() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1355_71_169()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1354_19_100() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1354_43_154()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Factor_935_54_46() {
        return this.jj_3R_NumericValueExpressionPrimary_832_9_64();
    }

    private boolean jj_3R_MathFunction_1353_19_99() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1352_19_98() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Identifier_595_9_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Identifier_596_17_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Identifier_602_17_31()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_MathFunction_1351_19_97() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1350_19_96() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1349_19_95() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1348_19_94() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1347_19_93() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1346_19_92() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1345_19_91() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_MathFunction_1344_19_90() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_OrderBy_584_11_192() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_OrderItem_650_9_191();
    }

    private boolean jj_3R_MathFunction_1343_18_89() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_StringExpression_960_17_54() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_StringFactor_985_9_36();
    }

    private boolean jj_3R_OrderBy_583_9_182() {
        Token xsp;
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_3R_OrderItem_650_9_191()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_OrderBy_584_11_192());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_MathFunction_1342_9_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_MathFunction_1343_18_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_MathFunction_1344_19_90()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_MathFunction_1345_19_91()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_MathFunction_1346_19_92()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_MathFunction_1347_19_93()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_MathFunction_1348_19_94()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_MathFunction_1349_19_95()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_MathFunction_1350_19_96()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_MathFunction_1351_19_97()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_MathFunction_1352_19_98()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_MathFunction_1353_19_99()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_MathFunction_1354_19_100()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_MathFunction_1355_19_101()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_MathFunction_1356_19_102()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_MathFunction_1357_19_103()) {
                                                                    return true;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_StringExpression_958_9_29() {
        Token xsp;
        if (this.jj_3R_StringFactor_985_9_36()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_StringExpression_960_17_54());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_Having_574_9_181() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        return this.jj_3R_ConditionsList_1006_9_68();
    }

    private boolean jj_3R_NumericFunction_1337_11_50() {
        return this.jj_3R_UserDefinedFunction_1389_9_26();
    }

    private boolean jj_3R_NumericFunction_1336_11_49() {
        return this.jj_3R_GeometryFunction_1203_9_67();
    }

    private boolean jj_3R_NumericFunction_1335_11_48() {
        return this.jj_3R_TrigFunction_1369_9_66();
    }

    private boolean jj_3R_Factor_934_27_63() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_NumericFunction_1334_10_47() {
        return this.jj_3R_MathFunction_1342_9_65();
    }

    private boolean jj_3R_GroupBy_566_11_190() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_NumericFunction_1334_9_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericFunction_1334_10_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_NumericFunction_1335_11_48()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_NumericFunction_1336_11_49()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_NumericFunction_1337_11_50()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GroupBy_565_9_180() {
        Token xsp;
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_3R_Column_639_9_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_GroupBy_566_11_190());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_3R_NumericFunction_1334_9_25();
    }

    private boolean jj_3R_Factor_934_18_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Factor_934_27_63()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_Where_556_9_179() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_ConditionsList_1006_9_68();
    }

    private boolean jj_3R_ExtractCoordSys_1318_9_81() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_992_9_130()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SelectItem_521_39_196() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(27)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_From_542_18_178() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_TableRef_710_9_177();
    }

    private boolean jj_3R_NumericTerm_916_27_162() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(12)) {
                return true;
            }
        }
        return this.jj_3R_NumericTerm_916_9_145();
    }

    private boolean jj_3R_Factor_933_9_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Factor_934_18_45()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Factor_935_54_46()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryValueFunction_1286_34_187() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Coordinates_1198_5_186();
    }

    private boolean jj_3R_GeometryFunction_1216_102_158() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_GeometryFunction_1215_102_156() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_From_540_9_163() {
        Token xsp;
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_3R_TableRef_710_9_177()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_From_542_18_178());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_NumericExpression_899_32_151() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                return true;
            }
        }
        return this.jj_3R_NumericExpression_899_9_123();
    }

    private boolean jj_3R_Point_1304_9_61() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1253_9_185()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1198_5_186()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryValueFunction_1291_19_42() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_StringExpression_958_9_29()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SelectItem_502_41_32() {
        if (this.jj_3R_Identifier_595_9_14()) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_NumericTerm_916_9_145() {
        if (this.jj_3R_Factor_933_9_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericTerm_916_27_162()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_SelectItem_521_17_189() {
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_521_39_196()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_null_871_47_19() {
        if (this.jj_3R_Factor_933_9_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryValueFunction_1281_19_41() {
        Token xsp;
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1253_9_185()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1198_5_186()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1198_5_186()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1198_5_186()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_GeometryValueFunction_1286_34_187());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SelectItem_500_33_15() {
        if (this.jj_3R_Identifier_595_9_14()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_502_41_32()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_null_872_42_20() {
        if (this.jj_3R_StringFactor_985_9_36()) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_GeometryValueFunction_1278_19_40() {
        return this.jj_3R_Point_1304_9_61();
    }

    private boolean jj_3R_ValueExpression_891_19_76() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_NumericExpression_899_9_123() {
        if (this.jj_3R_NumericTerm_916_9_145()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericExpression_899_32_151()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_GeometryValueFunction_1272_19_39() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1253_9_185()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1198_5_186()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_12() {
        return this.jj_3R_NumericFunction_1334_9_25();
    }

    private boolean jj_3_10() {
        return this.jj_3R_String_763_9_23();
    }

    private boolean jj_3_9() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_GeometryValueFunction_1269_19_38() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_992_9_130()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(69)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_null_872_42_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_871_28_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_null_871_47_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_null_871_28_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryValueFunction_1263_18_37() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_CoordinateSystem_1253_9_185()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_Coordinates_1198_5_186()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_11() {
        return this.jj_3R_Factor_933_9_24();
    }

    private boolean jj_3R_ValueExpression_877_19_75() {
        return this.jj_3R_StringFactor_985_9_36();
    }

    private boolean jj_3R_ValueExpression_876_19_74() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3_8() {
        return this.jj_3R_GeometryValueFunction_1261_9_21();
    }

    private boolean jj_3R_ValueExpression_874_19_73() {
        return this.jj_3R_UserDefinedFunction_1389_9_26();
    }

    private boolean jj_3R_ValueExpression_873_19_72() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryFunction_1229_45_172() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_ValueExpression_872_19_71() {
        return this.jj_3R_StringExpression_958_9_29();
    }

    private boolean jj_3R_SelectItem_489_17_188() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_1() {
        if (this.jj_3R_Identifier_595_9_14()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_500_33_15()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_ValueExpression_871_18_70() {
        return this.jj_3R_NumericExpression_899_9_123();
    }

    private boolean jj_3R_GeometryValueFunction_1261_9_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryValueFunction_1263_18_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryValueFunction_1269_19_38()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_GeometryValueFunction_1272_19_39()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_GeometryValueFunction_1278_19_40()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_GeometryValueFunction_1281_19_41()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_GeometryValueFunction_1291_19_42()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryFunction_1216_51_157() {
        return this.jj_3R_Point_1304_9_61();
    }

    private boolean jj_3R_SqlFunction_1175_91_161() {
        return this.jj_3R_ValueExpression_870_9_53();
    }

    private boolean jj_3R_GeometryFunction_1215_51_155() {
        return this.jj_3R_Point_1304_9_61();
    }

    private boolean jj_3R_StringValueExpressionPrimary_863_19_137() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryFunction_1219_45_160() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_SelectItem_488_9_175() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SelectItem_489_17_188()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_1()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SelectItem_521_17_189()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryFunction_1229_34_171() {
        return this.jj_3R_Point_1304_9_61();
    }

    private boolean jj_3R_StringValueExpressionPrimary_861_19_136() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_CoordinateSystem_1255_7_195() {
        return this.jj_3R_String_763_9_23();
    }

    private boolean jj_3R_CoordinateSystem_1253_9_185() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_CoordinateSystem_1254_7_194()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_CoordinateSystem_1255_7_195()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_ValueExpression_870_9_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ValueExpression_871_18_70()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ValueExpression_872_19_71()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_ValueExpression_873_19_72()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_ValueExpression_874_19_73()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_8()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_ValueExpression_876_19_74()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_ValueExpression_877_19_75()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_11()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_12()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_ValueExpression_891_19_76()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_CoordinateSystem_1254_7_194() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_StringValueExpressionPrimary_859_19_135() {
        return this.jj_3R_SqlFunction_1173_9_141();
    }

    private boolean jj_3R_StringValueExpressionPrimary_857_19_134() {
        return this.jj_3R_UnsignedNumeric_785_9_140();
    }

    private boolean jj_3R_StringValueExpressionPrimary_855_19_133() {
        return this.jj_3R_String_763_9_23();
    }

    private boolean jj_3R_Select_478_10_176() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SelectItem_488_9_175();
    }

    private boolean jj_3R_GeometryFunction_1219_34_159() {
        return this.jj_3R_Point_1304_9_61();
    }

    private boolean jj_3R_StringValueExpressionPrimary_853_17_132() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_JoinSpecification_725_140_126() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_843_19_88() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Select_467_10_174() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_841_19_87() {
        return this.jj_3R_SqlFunction_1173_9_141();
    }

    private boolean jj_3R_Select_466_10_173() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_StringValueExpressionPrimary_850_9_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_StringValueExpressionPrimary_853_17_132()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_StringValueExpressionPrimary_855_19_133()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_StringValueExpressionPrimary_857_19_134()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_StringValueExpressionPrimary_859_19_135()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_StringValueExpressionPrimary_861_19_136()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_StringValueExpressionPrimary_863_19_137()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_GeometryFunction_1217_25_116() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1219_34_159()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1219_45_160()) {
                return true;
            }
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1229_34_171()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1229_45_172()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_839_19_86() {
        return this.jj_3R_Column_639_9_22();
    }

    private boolean jj_3R_GeometryFunction_1216_25_115() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1216_51_157()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1216_102_158()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_Select_465_9_55() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Select_466_10_173()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_Select_467_10_174()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_SelectItem_488_9_175()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_Select_478_10_176());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_GeometryFunction_1215_25_114() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1215_51_155()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1215_102_156()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_837_19_85() {
        return this.jj_3R_UnsignedNumeric_785_9_140();
    }

    private boolean jj_3R_GeometryFunction_1214_25_113() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_992_9_130()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_835_17_84() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_SubQueryExpression_457_9_16() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_QueryExpression_426_9_33()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_GeometryFunction_1206_25_112() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(64)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(65)) {
                return true;
            }
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_992_9_130()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_GeometryExpression_992_9_130()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_732_114_129() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_NumericValueExpressionPrimary_832_9_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericValueExpressionPrimary_835_17_84()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_NumericValueExpressionPrimary_837_19_85()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_NumericValueExpressionPrimary_839_19_86()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_NumericValueExpressionPrimary_841_19_87()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_NumericValueExpressionPrimary_843_19_88()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_QueryExpression_440_10_167() {
        return this.jj_3R_OrderBy_583_9_182();
    }

    private boolean jj_3R_QueryExpression_439_10_166() {
        return this.jj_3R_Having_574_9_181();
    }

    private boolean jj_3R_QueryExpression_438_10_165() {
        return this.jj_3R_GroupBy_565_9_180();
    }

    private boolean jj_3R_QueryExpression_437_10_164() {
        return this.jj_3R_Where_556_9_179();
    }

    private boolean jj_3R_GeometryFunction_1203_9_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_GeometryFunction_1206_25_112()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_GeometryFunction_1214_25_113()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_GeometryFunction_1215_25_114()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_GeometryFunction_1216_25_115()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_GeometryFunction_1217_25_116()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_InEnd_1145_66_183() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_ValueExpression_870_9_53();
    }

    private boolean jj_3R_JoinSpecification_725_101_125() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_SignedInteger_813_11_193() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_SqlFunction_1181_25_150() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(53)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(54)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(55)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(56)) {
                        return true;
                    }
                }
            }
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_SignedInteger_813_9_184() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SignedInteger_813_11_193()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_Coordinates_1198_5_186() {
        if (this.jj_3R_NumericExpression_899_9_123()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_NumericExpression_899_9_123();
    }

    private boolean jj_3R_QueryExpression_426_9_33() {
        if (this.jj_3R_Select_465_9_55()) {
            return true;
        }
        if (this.jj_3R_From_540_9_163()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_QueryExpression_437_10_164()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_QueryExpression_438_10_165()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_QueryExpression_439_10_166()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_QueryExpression_440_10_167()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_SqlFunction_1175_25_149() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SqlFunction_1175_91_161()) {
                return true;
            }
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_JoinSpecification_732_75_128() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_JoinSpecification_744_57_204() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_Identifier_595_9_14();
    }

    private boolean jj_3R_SqlFunction_1173_9_141() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SqlFunction_1175_25_149()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SqlFunction_1181_25_150()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_UnsignedNumeric_785_9_140() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(98)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(99)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(100)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_725_64_124() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_JoinSpecification_725_62_77() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_725_64_124()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_725_101_125()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_JoinSpecification_725_140_126()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_725_52_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(29)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_725_62_77()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_741_33_203() {
        Token xsp;
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Identifier_595_9_14()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_JoinSpecification_744_57_204());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_InEnd_1145_11_168() {
        Token xsp;
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_ValueExpression_870_9_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_InEnd_1145_66_183());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_String_763_10_44() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_String_763_9_23() {
        Token xsp;
        if (this.jj_3R_String_763_10_44()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_String_763_10_44());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_19() {
        return this.jj_3R_SubQueryExpression_457_9_16();
    }

    private boolean jj_3R_JoinSpecification_732_38_127() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_InEnd_1143_9_153() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(45)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_InEnd_1145_11_168()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_732_36_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_JoinSpecification_732_38_127()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_JoinSpecification_732_75_128()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_JoinSpecification_732_114_129()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_JoinSpecification_734_33_202() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_ConditionsList_1006_9_68();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{129, 0, 0, 0, 0, 0x1000000, 0x2000000, 64, 0, 0, 0x8000000, 0x8000000, 2048, 1544, 64, 64, 64, 0, 32, 32, 32, 0, 0, 0, 0x8000000, 0x8000000, 0x8000000, 0, 8, -1342177280, Integer.MIN_VALUE, 0x40000000, -1610612736, -1610612736, Integer.MIN_VALUE, 0x40000000, -1610612736, -1610612736, 64, 0, -1342177280, 0, 0, 0, 1536, 1536, 8, 8, 0, 1536, 1536, 6144, 6144, 1536, 1536, 8, 256, 0, 8, 0, 0, 0, 0, 0, 1544, 0, 0, 0x7E0000, 0, 0, 1544, 0x7E0000, 0, 0, 64, 8, 0x1000000, 3592, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 1544, 64, 64, 0, 0, 64, 1544};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 32, 65536, 131072, 262144, 0, 0, 0, 0, 0, 0, 0, 0, -2096128, 0, 0, 0, 0, 0, 0, 0, 0, 0x180000, 0x180000, 0, 0, 0, 0, 0, 7, 3, 0, 3, 3, 3, 0, 3, 3, 0, 24, 7, 0, 0, 0, 0, 0, 65012736, 65012736, 0, 0, 0, 0, 0, 0, 0, 65012736, 0, 0, 65012736, -67108864, 256, 192, 192, 256, -2079744, 256, 256, 0, 8448, 16384, -2096128, 0, 256, 256, 0, 0, 0, -2096128, 0x1E00000, 0, 0x3E00000, 0, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0, 1024, 0, -67108864, 0, 65012736, 0, 0, 0, 0, 0, -2096128};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0x3FFFFFFF, 0, 0, 0, 0, 0, 0x3FFFFFFF, 0, 0, 0, 0, 0, 0, 0x3FFFFFFF, 0, 0, 0, 3, 0, 0, 0, 0, 95, 0, 0, 0, 0x3FFFFFDF, 0x3FFFFFDF, 0, 0, 4194176, 1069547520, 0, 0x3FFFFFFF};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 768, 768, 0, 768, 0, 798, 0, 0, 0, 768, 0, 0, 0, 784, 0, 0, 0, 768, 0, 768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 28, 24, 0, 0, 796, 798, 768, 0, 0, 0, 0, 0, 0, 796, 0, 0, 798, 768, 0, 0, 0, 0, 798, 0, 0, 0, 0, 0, 798, 0, 0, 0, 0, 0, 0, 798, 0, 0, 0, 0, 768, 768, 768, 768, 0, 2, 0, 0, 512, 796, 0, 0, 0, 0, 0, 798};
    }

    public ADQLGrammar200(InputStream stream) {
        this(stream, null);
    }

    public ADQLGrammar200(InputStream stream, String encoding) {
        int i;
        this.enable_tracing();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.trace_indent = 0;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ADQLGrammar200TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    @Override
    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLGrammar200(Reader stream) {
        int i;
        this.enable_tracing();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.trace_indent = 0;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ADQLGrammar200TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ADQLGrammar200TokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLGrammar200(ADQLGrammar200TokenManager tm) {
        int i;
        this.enable_tracing();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.trace_indent = 0;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ADQLGrammar200TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            this.trace_token(this.token, "");
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        this.trace_token(this.token, " (in getNextToken)");
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[107];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 98; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 107; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    @Override
    public final void enable_tracing() {
        this.trace_enabled = true;
    }

    @Override
    public final void disable_tracing() {
        this.trace_enabled = false;
    }

    protected void trace_call(String s) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Call:\t" + s);
        }
        this.trace_indent += 2;
    }

    protected void trace_return(String s) {
        this.trace_indent -= 2;
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Return: " + s);
        }
    }

    protected void trace_token(Token t, String where) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Consumed token: <" + tokenImage[t.kind]);
            if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
                System.out.print(": \"" + TokenMgrError.addEscapes(t.image) + "\"");
            }
            System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
        }
    }

    protected void trace_scan(Token t1, int t2) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Visited token: <" + tokenImage[t1.kind]);
            if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
                System.out.print(": \"" + TokenMgrError.addEscapes(t1.image) + "\"");
            }
            System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
        }
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 19; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ADQLGrammar200.jj_la1_init_0();
        ADQLGrammar200.jj_la1_init_1();
        ADQLGrammar200.jj_la1_init_2();
        ADQLGrammar200.jj_la1_init_3();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

