'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\" Copyright (c) 1998-1999 Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH socket n 8.6 Tcl "Tcl Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
socket \- Open a TCP network connection
.SH SYNOPSIS
.sp
\fBsocket \fR?\fIoptions\fR? \fIhost port\fR
.sp
\fBsocket\fR \fB\-server \fIcommand\fR ?\fIoptions\fR? \fIport\fR
.BE
.SH DESCRIPTION
.PP
This command opens a network socket and returns a channel identifier
that may be used in future invocations of commands like \fBread\fR,
\fBputs\fR and \fBflush\fR.  At present only the TCP network protocol
is supported over IPv4 and IPv6; future releases may include support
for additional protocols.  The \fBsocket\fR command may be used to
open either the client or server side of a connection, depending on
whether the \fB\-server\fR switch is specified.
.PP
Note that the default encoding for \fIall\fR sockets is the system
encoding, as returned by \fBencoding system\fR.  Most of the time, you
will need to use \fBchan configure\fR to alter this to something else,
such as \fIutf\-8\fR (ideal for communicating with other Tcl
processes) or \fIiso8859\-1\fR (useful for many network protocols,
especially the older ones).
.SH "CLIENT SOCKETS"
.PP
If the \fB\-server\fR option is not specified, then the client side of a
connection is opened and the command returns a channel identifier
that can be used for both reading and writing.
\fIPort\fR and \fIhost\fR specify a port
to connect to;  there must be a server accepting connections on
this port.  \fIPort\fR is an integer port number
(or service name, where supported and understood by the host operating
system) and \fIhost\fR
is either a domain-style name such as \fBwww.tcl.tk\fR or
a numerical IPv4 or IPv6 address such as \fB127.0.0.1\fR or \fB2001:DB8::1\fR.
Use \fIlocalhost\fR to refer to the host on which the command is invoked.
.PP
The following options may also be present before \fIhost\fR
to specify additional information about the connection:
.TP
\fB\-myaddr\fI addr\fR
.
\fIAddr\fR gives the domain-style name or numerical IP address of
the client-side network interface to use for the connection.
This option may be useful if the client machine has multiple network
interfaces.  If the option is omitted then the client-side interface
will be chosen by the system software.
.TP
\fB\-myport\fI port\fR
.
\fIPort\fR specifies an integer port number (or service name, where
supported and understood by the host operating system) to use for the
client's
side of the connection.  If this option is omitted, the client's
port number will be chosen at random by the system software.
.TP
\fB\-async\fR
.
This option will cause the client socket to be connected
asynchronously. This means that the socket will be created immediately
but may not yet be connected to the server, when the call to
\fBsocket\fR returns.
.RS
.PP
When a \fBgets\fR or \fBflush\fR is done on the socket before the
connection attempt succeeds or fails, if the socket is in blocking
mode, the operation will wait until the connection is completed or
fails. If the socket is in nonblocking mode and a \fBgets\fR or
\fBflush\fR is done on the socket before the connection attempt
succeeds or fails, the operation returns immediately and
\fBfblocked\fR on the socket returns 1. Synchronous client sockets may
be switched (after they have connected) to operating in asynchronous
mode using:
.PP
.CS
\fBchan configure \fIchan \fB\-blocking 0\fR
.CE
.PP
See the \fBchan configure\fR command for more details.
.PP
The Tcl event loop should be running while an asynchronous connection
is in progress, because it may have to do several connection attempts
in the background. Running the event loop also allows you to set up a
writable channel event on the socket to get notified when the
asynchronous connection has succeeded or failed. See the \fBvwait\fR
and the \fBchan\fR commands for more details on the event loop and
channel events.
.PP
The \fBchan configure\fR option \fB-connecting\fR may be used to check if the connect is still running. To verify a successful connect, the option \fB-error\fR may be checked when \fB-connecting\fR returned 0.
.PP
Operation without the event queue requires at the moment calls to \fBchan configure\fR to advance the internal state machine.
.RE
.SH "SERVER SOCKETS"
.PP
If the \fB\-server\fR option is specified then the new socket will be
a server that listens on the given \fIport\fR (either an integer or a
service name, where supported and understood by the host operating
system; if \fIport\fR is zero, the operating system will allocate a
free port to the server socket which may be discovered by using
\fBchan configure\fR to read the \fB\-sockname\fR option). If the host
supports both, IPv4 and IPv6, the socket will listen on both address
families. Tcl will automatically accept connections to the given port.
For each connection Tcl will create a new channel that may be used to
communicate with the client.  Tcl then invokes \fIcommand\fR (properly
a command prefix list, see the \fBEXAMPLES\fR below) with three
additional arguments: the name of the new channel, the address, in
network address notation, of the client's host, and the client's port
number.
.PP
The following additional option may also be specified before \fIport\fR:
.TP
\fB\-myaddr\fI addr\fR
.
\fIAddr\fR gives the domain-style name or numerical IP address of the
server-side network interface to use for the connection.  This option
may be useful if the server machine has multiple network interfaces.
If the option is omitted then the server socket is bound to the
wildcard address so that it can accept connections from any
interface. If \fIaddr\fR is a domain name that resolves to multiple IP
addresses that are available on the local machine, the socket will
listen on all of them.
.PP
Server channels cannot be used for input or output; their sole use is to
accept new client connections. The channels created for each incoming
client connection are opened for input and output. Closing the server
channel shuts down the server so that no new connections will be
accepted;  however, existing connections will be unaffected.
.PP
Server sockets depend on the Tcl event mechanism to find out when
new connections are opened.  If the application does not enter the
event loop, for example by invoking the \fBvwait\fR command or
calling the C procedure \fBTcl_DoOneEvent\fR, then no connections
will be accepted.
.PP
If \fIport\fR is specified as zero, the operating system will allocate
an unused port for use as a server socket.  The port number actually
allocated may be retrieved from the created server socket using the
\fBchan configure\fR command to retrieve the \fB\-sockname\fR option as
described below.
.SH "CONFIGURATION OPTIONS"
.PP
The \fBchan configure\fR command can be used to query several readonly
configuration options for socket channels:
.TP
\fB\-error\fR
.
This option gets the current error status of the given socket.  This
is useful when you need to determine if an asynchronous connect
operation succeeded.  If there was an error, the error message is
returned.  If there was no error, an empty string is returned.
.RS
.PP
Note that the error status is reset by the read operation; this mimics
the underlying getsockopt(SO_ERROR) call.
.RE
.TP
\fB\-sockname\fR
.
For client sockets (including the channels that get created when a
client connects to a server socket) this option returns a list of
three elements, the address, the host name and the port number for the
socket. If the host name cannot be computed, the second element is
identical to the address, the first element of the list.
.RS
.PP
For server sockets this option returns a list of a multiple of three
elements each group of which have the same meaning as described
above. The list contains more than one group when the server socket
was created without \fB\-myaddr\fR or with the argument to
\fB\-myaddr\fR being a domain name that resolves multiple IP addresses
that are local to the invoking host.
.RE
.TP
\fB\-peername\fR
.
This option is not supported by server sockets. For client and accepted
sockets, this option returns a list of three elements; these are the
address, the host name and the port to which the peer socket is connected
or bound. If the host name cannot be computed, the second element of the
list is identical to the address, its first element.
.TP
\fB\-connecting\fR
.
This option is not supported by server sockets. For client sockets, this option returns 1 if an asyncroneous connect is still in progress, 0 otherwise.
.PP
.SH "EXAMPLES"
.PP
Here is a very simple time server:
.PP
.CS
proc Server {startTime channel clientaddr clientport} {
    puts "Connection from $clientaddr registered"
    set now [clock seconds]
    puts $channel [clock format $now]
    puts $channel "[expr {$now - $startTime}] since start"
    close $channel
}

\fBsocket -server\fR [list Server [clock seconds]] 9900
vwait forever
.CE
.PP
And here is the corresponding client to talk to the server and extract
some information:
.PP
.CS
set server localhost
set sockChan [\fBsocket\fR $server 9900]
gets $sockChan line1
gets $sockChan line2
close $sockChan
puts "The time on $server is $line1"
puts "That is [lindex $line2 0]s since the server started"
.CE
.SH "HISTORY"
Support for IPv6 was added in Tcl 8.6.
.SH "SEE ALSO"
chan(n), flush(n), open(n), read(n)
.SH KEYWORDS
asynchronous I/O, bind, channel, connection, domain name, host, network address, socket, tcp
'\" Local Variables:
'\" mode: nroff
'\" End:
