---
myst:
  html_meta:
    keywords: LaTeX, fichiers, pdf, caractères manquants, Adobe
---

# Pourquoi certains caractères manquent dans mon PDF ?

Si vous utilisez *Acrobat Distiller* pour créer votre fichier PDF, 
il se peut que des caractères manquent. 
Cela peut se manifester par des équations mathématiques erronées (signes "-" manquants, 
par exemple), ou par des éléments manquants dans de grands symboles. 
Les premières versions de Distiller ignoraient les positions 0--31 
et 128--159 de chaque police : Les polices d'Adobe n'utilisent jamais ces positions, 
alors pourquoi Distiller devrait-il le faire ?

La réponse à cette question est tout simplement 
"parce qu'Adobe ne produit pas toutes les polices du monde".
Des polices comme *Computer Modern* existaient avant qu'Adobe n'entre en scène 
et *elles* utilisent les positions 0--31. 
Adobe n'a pas réagit directemnet aux plaintes 
mais a publié de nouvelles versions de ses programmes ; 
`Distiller`, depuis au moins la version 4.0, reconnait les positions des polices 
qu'il avait l'habitude de fuir.

Cependant, les utilisateurs de TeX avec de vieilles versions de `Distiller` 
doivent s'occuper de leurs polices. Le programme `dvips` leur vient ici en aide : 
le commutateur `-G1` ("réallocation des caractères") déplace les caractères incriminés. 
L'option PDF (`-Ppdf`), recommandée dans la question 
"[](/5_fichiers/formats/fontes/mon_document_est_flou_a_cause_des_fontes_t3)", inclut ce commutateur.

Ce commutateur n'est pas sans poser quelques difficultés.  
Les versions de `dvips` antérieures à 2003 l'appliqueront également aux polices Adobe, 
causant des ravages (évoqués à la question 
"[](/5_fichiers/formats/fontes/caracteres_bizarres_avec_dvips)"). 
Si ce premier problème trouve est généralement rapidement résolu, 
un document utilisant à la fois des polices *Computer Modern* 
et des polices spécifiées par Adobe demandera des solutions plus drastiques : 
soit mettre à jour `dvips`, soit de dépenser de l'argent pour mettre à jour `Distiller`.


:::{sources}
[Characters missing from PDF output](faquk:FAQ-distill-prob)
:::