/* ed25519_cert.c -- generated by Trunnel v1.5.3.
 * https://gitweb.torproject.org/trunnel.git
 * You probably shouldn't edit this file.
 */
#include <stdlib.h>
#include "trunnel-impl.h"

#include "ed25519_cert.h"

#define TRUNNEL_SET_ERROR_CODE(obj) \
  do {                              \
    (obj)->trunnel_error_code_ = 1; \
  } while (0)

#if defined(__COVERITY__) || defined(__clang_analyzer__)
/* If we're running a static analysis tool, we don't want it to complain
 * that some of our remaining-bytes checks are dead-code. */
int edcert_deadcode_dummy__ = 0;
#define OR_DEADCODE_DUMMY || edcert_deadcode_dummy__
#else
#define OR_DEADCODE_DUMMY
#endif

#define CHECK_REMAINING(nbytes, label)                           \
  do {                                                           \
    if (remaining < (nbytes) OR_DEADCODE_DUMMY) {                \
      goto label;                                                \
    }                                                            \
  } while (0)

create2_cell_body_t *
create2_cell_body_new(void)
{
  create2_cell_body_t *val = trunnel_calloc(1, sizeof(create2_cell_body_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
create2_cell_body_clear(create2_cell_body_t *obj)
{
  (void) obj;
  TRUNNEL_DYNARRAY_WIPE(&obj->handshake_data);
  TRUNNEL_DYNARRAY_CLEAR(&obj->handshake_data);
}

void
create2_cell_body_free(create2_cell_body_t *obj)
{
  if (obj == NULL)
    return;
  create2_cell_body_clear(obj);
  trunnel_memwipe(obj, sizeof(create2_cell_body_t));
  trunnel_free_(obj);
}

uint16_t
create2_cell_body_get_handshake_type(const create2_cell_body_t *inp)
{
  return inp->handshake_type;
}
int
create2_cell_body_set_handshake_type(create2_cell_body_t *inp, uint16_t val)
{
  inp->handshake_type = val;
  return 0;
}
uint16_t
create2_cell_body_get_handshake_len(const create2_cell_body_t *inp)
{
  return inp->handshake_len;
}
int
create2_cell_body_set_handshake_len(create2_cell_body_t *inp, uint16_t val)
{
  inp->handshake_len = val;
  return 0;
}
size_t
create2_cell_body_getlen_handshake_data(const create2_cell_body_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->handshake_data);
}

uint8_t
create2_cell_body_get_handshake_data(create2_cell_body_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->handshake_data, idx);
}

uint8_t
create2_cell_body_getconst_handshake_data(const create2_cell_body_t *inp, size_t idx)
{
  return create2_cell_body_get_handshake_data((create2_cell_body_t*)inp, idx);
}
int
create2_cell_body_set_handshake_data(create2_cell_body_t *inp, size_t idx, uint8_t elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->handshake_data, idx, elt);
  return 0;
}
int
create2_cell_body_add_handshake_data(create2_cell_body_t *inp, uint8_t elt)
{
#if SIZE_MAX >= UINT16_MAX
  if (inp->handshake_data.n_ == UINT16_MAX)
    goto trunnel_alloc_failed;
#endif
  TRUNNEL_DYNARRAY_ADD(uint8_t, &inp->handshake_data, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

uint8_t *
create2_cell_body_getarray_handshake_data(create2_cell_body_t *inp)
{
  return inp->handshake_data.elts_;
}
const uint8_t  *
create2_cell_body_getconstarray_handshake_data(const create2_cell_body_t *inp)
{
  return (const uint8_t  *)create2_cell_body_getarray_handshake_data((create2_cell_body_t*)inp);
}
int
create2_cell_body_setlen_handshake_data(create2_cell_body_t *inp, size_t newlen)
{
  uint8_t *newptr;
#if UINT16_MAX < SIZE_MAX
  if (newlen > UINT16_MAX)
    goto trunnel_alloc_failed;
#endif
  newptr = trunnel_dynarray_setlen(&inp->handshake_data.allocated_,
                 &inp->handshake_data.n_, inp->handshake_data.elts_, newlen,
                 sizeof(inp->handshake_data.elts_[0]), (trunnel_free_fn_t) NULL,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->handshake_data.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
const char *
create2_cell_body_check(const create2_cell_body_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  if (TRUNNEL_DYNARRAY_LEN(&obj->handshake_data) != obj->handshake_len)
    return "Length mismatch for handshake_data";
  return NULL;
}

ssize_t
create2_cell_body_encoded_len(const create2_cell_body_t *obj)
{
  ssize_t result = 0;

  if (NULL != create2_cell_body_check(obj))
     return -1;


  /* Length of u16 handshake_type */
  result += 2;

  /* Length of u16 handshake_len */
  result += 2;

  /* Length of u8 handshake_data[handshake_len] */
  result += TRUNNEL_DYNARRAY_LEN(&obj->handshake_data);
  return result;
}
int
create2_cell_body_clear_errors(create2_cell_body_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
create2_cell_body_encode(uint8_t *output, const size_t avail, const create2_cell_body_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = create2_cell_body_encoded_len(obj);
#endif

  if (NULL != (msg = create2_cell_body_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u16 handshake_type */
  trunnel_assert(written <= avail);
  if (avail - written < 2)
    goto truncated;
  trunnel_set_uint16(ptr, trunnel_htons(obj->handshake_type));
  written += 2; ptr += 2;

  /* Encode u16 handshake_len */
  trunnel_assert(written <= avail);
  if (avail - written < 2)
    goto truncated;
  trunnel_set_uint16(ptr, trunnel_htons(obj->handshake_len));
  written += 2; ptr += 2;

  /* Encode u8 handshake_data[handshake_len] */
  {
    size_t elt_len = TRUNNEL_DYNARRAY_LEN(&obj->handshake_data);
    trunnel_assert(obj->handshake_len == elt_len);
    trunnel_assert(written <= avail);
    if (avail - written < elt_len)
      goto truncated;
    if (elt_len)
      memcpy(ptr, obj->handshake_data.elts_, elt_len);
    written += elt_len; ptr += elt_len;
  }


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As create2_cell_body_parse(), but do not allocate the output
 * object.
 */
static ssize_t
create2_cell_body_parse_into(create2_cell_body_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u16 handshake_type */
  CHECK_REMAINING(2, truncated);
  obj->handshake_type = trunnel_ntohs(trunnel_get_uint16(ptr));
  remaining -= 2; ptr += 2;

  /* Parse u16 handshake_len */
  CHECK_REMAINING(2, truncated);
  obj->handshake_len = trunnel_ntohs(trunnel_get_uint16(ptr));
  remaining -= 2; ptr += 2;

  /* Parse u8 handshake_data[handshake_len] */
  CHECK_REMAINING(obj->handshake_len, truncated);
  TRUNNEL_DYNARRAY_EXPAND(uint8_t, &obj->handshake_data, obj->handshake_len, {});
  obj->handshake_data.n_ = obj->handshake_len;
  if (obj->handshake_len)
    memcpy(obj->handshake_data.elts_, ptr, obj->handshake_len);
  ptr += obj->handshake_len; remaining -= obj->handshake_len;
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 trunnel_alloc_failed:
  return -1;
}

ssize_t
create2_cell_body_parse(create2_cell_body_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = create2_cell_body_new();
  if (NULL == *output)
    return -1;
  result = create2_cell_body_parse_into(*output, input, len_in);
  if (result < 0) {
    create2_cell_body_free(*output);
    *output = NULL;
  }
  return result;
}
ed25519_cert_extension_t *
ed25519_cert_extension_new(void)
{
  ed25519_cert_extension_t *val = trunnel_calloc(1, sizeof(ed25519_cert_extension_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
ed25519_cert_extension_clear(ed25519_cert_extension_t *obj)
{
  (void) obj;
  TRUNNEL_DYNARRAY_WIPE(&obj->un_unparsed);
  TRUNNEL_DYNARRAY_CLEAR(&obj->un_unparsed);
}

void
ed25519_cert_extension_free(ed25519_cert_extension_t *obj)
{
  if (obj == NULL)
    return;
  ed25519_cert_extension_clear(obj);
  trunnel_memwipe(obj, sizeof(ed25519_cert_extension_t));
  trunnel_free_(obj);
}

uint16_t
ed25519_cert_extension_get_ext_length(const ed25519_cert_extension_t *inp)
{
  return inp->ext_length;
}
int
ed25519_cert_extension_set_ext_length(ed25519_cert_extension_t *inp, uint16_t val)
{
  inp->ext_length = val;
  return 0;
}
uint8_t
ed25519_cert_extension_get_ext_type(const ed25519_cert_extension_t *inp)
{
  return inp->ext_type;
}
int
ed25519_cert_extension_set_ext_type(ed25519_cert_extension_t *inp, uint8_t val)
{
  inp->ext_type = val;
  return 0;
}
uint8_t
ed25519_cert_extension_get_ext_flags(const ed25519_cert_extension_t *inp)
{
  return inp->ext_flags;
}
int
ed25519_cert_extension_set_ext_flags(ed25519_cert_extension_t *inp, uint8_t val)
{
  inp->ext_flags = val;
  return 0;
}
size_t
ed25519_cert_extension_getlen_un_signing_key(const ed25519_cert_extension_t *inp)
{
  (void)inp;  return 32;
}

uint8_t
ed25519_cert_extension_get_un_signing_key(ed25519_cert_extension_t *inp, size_t idx)
{
  trunnel_assert(idx < 32);
  return inp->un_signing_key[idx];
}

uint8_t
ed25519_cert_extension_getconst_un_signing_key(const ed25519_cert_extension_t *inp, size_t idx)
{
  return ed25519_cert_extension_get_un_signing_key((ed25519_cert_extension_t*)inp, idx);
}
int
ed25519_cert_extension_set_un_signing_key(ed25519_cert_extension_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 32);
  inp->un_signing_key[idx] = elt;
  return 0;
}

uint8_t *
ed25519_cert_extension_getarray_un_signing_key(ed25519_cert_extension_t *inp)
{
  return inp->un_signing_key;
}
const uint8_t  *
ed25519_cert_extension_getconstarray_un_signing_key(const ed25519_cert_extension_t *inp)
{
  return (const uint8_t  *)ed25519_cert_extension_getarray_un_signing_key((ed25519_cert_extension_t*)inp);
}
size_t
ed25519_cert_extension_getlen_un_unparsed(const ed25519_cert_extension_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->un_unparsed);
}

uint8_t
ed25519_cert_extension_get_un_unparsed(ed25519_cert_extension_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->un_unparsed, idx);
}

uint8_t
ed25519_cert_extension_getconst_un_unparsed(const ed25519_cert_extension_t *inp, size_t idx)
{
  return ed25519_cert_extension_get_un_unparsed((ed25519_cert_extension_t*)inp, idx);
}
int
ed25519_cert_extension_set_un_unparsed(ed25519_cert_extension_t *inp, size_t idx, uint8_t elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->un_unparsed, idx, elt);
  return 0;
}
int
ed25519_cert_extension_add_un_unparsed(ed25519_cert_extension_t *inp, uint8_t elt)
{
  TRUNNEL_DYNARRAY_ADD(uint8_t, &inp->un_unparsed, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

uint8_t *
ed25519_cert_extension_getarray_un_unparsed(ed25519_cert_extension_t *inp)
{
  return inp->un_unparsed.elts_;
}
const uint8_t  *
ed25519_cert_extension_getconstarray_un_unparsed(const ed25519_cert_extension_t *inp)
{
  return (const uint8_t  *)ed25519_cert_extension_getarray_un_unparsed((ed25519_cert_extension_t*)inp);
}
int
ed25519_cert_extension_setlen_un_unparsed(ed25519_cert_extension_t *inp, size_t newlen)
{
  uint8_t *newptr;
  newptr = trunnel_dynarray_setlen(&inp->un_unparsed.allocated_,
                 &inp->un_unparsed.n_, inp->un_unparsed.elts_, newlen,
                 sizeof(inp->un_unparsed.elts_[0]), (trunnel_free_fn_t) NULL,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->un_unparsed.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
const char *
ed25519_cert_extension_check(const ed25519_cert_extension_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  switch (obj->ext_type) {

    case CERTEXT_SIGNED_WITH_KEY:
      break;

    default:
      break;
  }
  return NULL;
}

ssize_t
ed25519_cert_extension_encoded_len(const ed25519_cert_extension_t *obj)
{
  ssize_t result = 0;

  if (NULL != ed25519_cert_extension_check(obj))
     return -1;


  /* Length of u16 ext_length */
  result += 2;

  /* Length of u8 ext_type */
  result += 1;

  /* Length of u8 ext_flags */
  result += 1;
  switch (obj->ext_type) {

    case CERTEXT_SIGNED_WITH_KEY:

      /* Length of u8 un_signing_key[32] */
      result += 32;
      break;

    default:

      /* Length of u8 un_unparsed[] */
      result += TRUNNEL_DYNARRAY_LEN(&obj->un_unparsed);
      break;
  }
  return result;
}
int
ed25519_cert_extension_clear_errors(ed25519_cert_extension_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
ed25519_cert_extension_encode(uint8_t *output, const size_t avail, const ed25519_cert_extension_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = ed25519_cert_extension_encoded_len(obj);
#endif

  uint8_t *backptr_ext_length = NULL;

  if (NULL != (msg = ed25519_cert_extension_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u16 ext_length */
  backptr_ext_length = ptr;
  trunnel_assert(written <= avail);
  if (avail - written < 2)
    goto truncated;
  trunnel_set_uint16(ptr, trunnel_htons(obj->ext_length));
  written += 2; ptr += 2;

  /* Encode u8 ext_type */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->ext_type));
  written += 1; ptr += 1;

  /* Encode u8 ext_flags */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->ext_flags));
  written += 1; ptr += 1;
  {
    size_t written_before_union = written;

    /* Encode union un[ext_type] */
    trunnel_assert(written <= avail);
    switch (obj->ext_type) {

      case CERTEXT_SIGNED_WITH_KEY:

        /* Encode u8 un_signing_key[32] */
        trunnel_assert(written <= avail);
        if (avail - written < 32)
          goto truncated;
        memcpy(ptr, obj->un_signing_key, 32);
        written += 32; ptr += 32;
        break;

      default:

        /* Encode u8 un_unparsed[] */
        {
          size_t elt_len = TRUNNEL_DYNARRAY_LEN(&obj->un_unparsed);
          trunnel_assert(written <= avail);
          if (avail - written < elt_len)
            goto truncated;
          if (elt_len)
            memcpy(ptr, obj->un_unparsed.elts_, elt_len);
          written += elt_len; ptr += elt_len;
        }
        break;
    }
    /* Write the length field back to ext_length */
    trunnel_assert(written >= written_before_union);
#if UINT16_MAX < SIZE_MAX
    if (written - written_before_union > UINT16_MAX)
      goto check_failed;
#endif
    trunnel_set_uint16(backptr_ext_length, trunnel_htons(written - written_before_union));
  }


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As ed25519_cert_extension_parse(), but do not allocate the output
 * object.
 */
static ssize_t
ed25519_cert_extension_parse_into(ed25519_cert_extension_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u16 ext_length */
  CHECK_REMAINING(2, truncated);
  obj->ext_length = trunnel_ntohs(trunnel_get_uint16(ptr));
  remaining -= 2; ptr += 2;

  /* Parse u8 ext_type */
  CHECK_REMAINING(1, truncated);
  obj->ext_type = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse u8 ext_flags */
  CHECK_REMAINING(1, truncated);
  obj->ext_flags = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;
  {
    size_t remaining_after;
    CHECK_REMAINING(obj->ext_length, truncated);
    remaining_after = remaining - obj->ext_length;
    remaining = obj->ext_length;

    /* Parse union un[ext_type] */
    switch (obj->ext_type) {

      case CERTEXT_SIGNED_WITH_KEY:

        /* Parse u8 un_signing_key[32] */
        CHECK_REMAINING(32, fail);
        memcpy(obj->un_signing_key, ptr, 32);
        remaining -= 32; ptr += 32;
        break;

      default:

        /* Parse u8 un_unparsed[] */
        TRUNNEL_DYNARRAY_EXPAND(uint8_t, &obj->un_unparsed, remaining, {});
        obj->un_unparsed.n_ = remaining;
        if (remaining)
          memcpy(obj->un_unparsed.elts_, ptr, remaining);
        ptr += remaining; remaining -= remaining;
        break;
    }
    if (remaining != 0)
      goto fail;
    remaining = remaining_after;
  }
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 trunnel_alloc_failed:
  return -1;
 fail:
  result = -1;
  return result;
}

ssize_t
ed25519_cert_extension_parse(ed25519_cert_extension_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = ed25519_cert_extension_new();
  if (NULL == *output)
    return -1;
  result = ed25519_cert_extension_parse_into(*output, input, len_in);
  if (result < 0) {
    ed25519_cert_extension_free(*output);
    *output = NULL;
  }
  return result;
}
extend1_cell_body_t *
extend1_cell_body_new(void)
{
  extend1_cell_body_t *val = trunnel_calloc(1, sizeof(extend1_cell_body_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
extend1_cell_body_clear(extend1_cell_body_t *obj)
{
  (void) obj;
}

void
extend1_cell_body_free(extend1_cell_body_t *obj)
{
  if (obj == NULL)
    return;
  extend1_cell_body_clear(obj);
  trunnel_memwipe(obj, sizeof(extend1_cell_body_t));
  trunnel_free_(obj);
}

uint32_t
extend1_cell_body_get_ipv4addr(const extend1_cell_body_t *inp)
{
  return inp->ipv4addr;
}
int
extend1_cell_body_set_ipv4addr(extend1_cell_body_t *inp, uint32_t val)
{
  inp->ipv4addr = val;
  return 0;
}
uint16_t
extend1_cell_body_get_port(const extend1_cell_body_t *inp)
{
  return inp->port;
}
int
extend1_cell_body_set_port(extend1_cell_body_t *inp, uint16_t val)
{
  inp->port = val;
  return 0;
}
size_t
extend1_cell_body_getlen_onionskin(const extend1_cell_body_t *inp)
{
  (void)inp;  return 186;
}

uint8_t
extend1_cell_body_get_onionskin(extend1_cell_body_t *inp, size_t idx)
{
  trunnel_assert(idx < 186);
  return inp->onionskin[idx];
}

uint8_t
extend1_cell_body_getconst_onionskin(const extend1_cell_body_t *inp, size_t idx)
{
  return extend1_cell_body_get_onionskin((extend1_cell_body_t*)inp, idx);
}
int
extend1_cell_body_set_onionskin(extend1_cell_body_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 186);
  inp->onionskin[idx] = elt;
  return 0;
}

uint8_t *
extend1_cell_body_getarray_onionskin(extend1_cell_body_t *inp)
{
  return inp->onionskin;
}
const uint8_t  *
extend1_cell_body_getconstarray_onionskin(const extend1_cell_body_t *inp)
{
  return (const uint8_t  *)extend1_cell_body_getarray_onionskin((extend1_cell_body_t*)inp);
}
size_t
extend1_cell_body_getlen_identity(const extend1_cell_body_t *inp)
{
  (void)inp;  return 20;
}

uint8_t
extend1_cell_body_get_identity(extend1_cell_body_t *inp, size_t idx)
{
  trunnel_assert(idx < 20);
  return inp->identity[idx];
}

uint8_t
extend1_cell_body_getconst_identity(const extend1_cell_body_t *inp, size_t idx)
{
  return extend1_cell_body_get_identity((extend1_cell_body_t*)inp, idx);
}
int
extend1_cell_body_set_identity(extend1_cell_body_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 20);
  inp->identity[idx] = elt;
  return 0;
}

uint8_t *
extend1_cell_body_getarray_identity(extend1_cell_body_t *inp)
{
  return inp->identity;
}
const uint8_t  *
extend1_cell_body_getconstarray_identity(const extend1_cell_body_t *inp)
{
  return (const uint8_t  *)extend1_cell_body_getarray_identity((extend1_cell_body_t*)inp);
}
const char *
extend1_cell_body_check(const extend1_cell_body_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  return NULL;
}

ssize_t
extend1_cell_body_encoded_len(const extend1_cell_body_t *obj)
{
  ssize_t result = 0;

  if (NULL != extend1_cell_body_check(obj))
     return -1;


  /* Length of u32 ipv4addr */
  result += 4;

  /* Length of u16 port */
  result += 2;

  /* Length of u8 onionskin[186] */
  result += 186;

  /* Length of u8 identity[20] */
  result += 20;
  return result;
}
int
extend1_cell_body_clear_errors(extend1_cell_body_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
extend1_cell_body_encode(uint8_t *output, const size_t avail, const extend1_cell_body_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = extend1_cell_body_encoded_len(obj);
#endif

  if (NULL != (msg = extend1_cell_body_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u32 ipv4addr */
  trunnel_assert(written <= avail);
  if (avail - written < 4)
    goto truncated;
  trunnel_set_uint32(ptr, trunnel_htonl(obj->ipv4addr));
  written += 4; ptr += 4;

  /* Encode u16 port */
  trunnel_assert(written <= avail);
  if (avail - written < 2)
    goto truncated;
  trunnel_set_uint16(ptr, trunnel_htons(obj->port));
  written += 2; ptr += 2;

  /* Encode u8 onionskin[186] */
  trunnel_assert(written <= avail);
  if (avail - written < 186)
    goto truncated;
  memcpy(ptr, obj->onionskin, 186);
  written += 186; ptr += 186;

  /* Encode u8 identity[20] */
  trunnel_assert(written <= avail);
  if (avail - written < 20)
    goto truncated;
  memcpy(ptr, obj->identity, 20);
  written += 20; ptr += 20;


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As extend1_cell_body_parse(), but do not allocate the output
 * object.
 */
static ssize_t
extend1_cell_body_parse_into(extend1_cell_body_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u32 ipv4addr */
  CHECK_REMAINING(4, truncated);
  obj->ipv4addr = trunnel_ntohl(trunnel_get_uint32(ptr));
  remaining -= 4; ptr += 4;

  /* Parse u16 port */
  CHECK_REMAINING(2, truncated);
  obj->port = trunnel_ntohs(trunnel_get_uint16(ptr));
  remaining -= 2; ptr += 2;

  /* Parse u8 onionskin[186] */
  CHECK_REMAINING(186, truncated);
  memcpy(obj->onionskin, ptr, 186);
  remaining -= 186; ptr += 186;

  /* Parse u8 identity[20] */
  CHECK_REMAINING(20, truncated);
  memcpy(obj->identity, ptr, 20);
  remaining -= 20; ptr += 20;
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
}

ssize_t
extend1_cell_body_parse(extend1_cell_body_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = extend1_cell_body_new();
  if (NULL == *output)
    return -1;
  result = extend1_cell_body_parse_into(*output, input, len_in);
  if (result < 0) {
    extend1_cell_body_free(*output);
    *output = NULL;
  }
  return result;
}
link_specifier_t *
link_specifier_new(void)
{
  link_specifier_t *val = trunnel_calloc(1, sizeof(link_specifier_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
link_specifier_clear(link_specifier_t *obj)
{
  (void) obj;
  TRUNNEL_DYNARRAY_WIPE(&obj->un_unrecognized);
  TRUNNEL_DYNARRAY_CLEAR(&obj->un_unrecognized);
}

void
link_specifier_free(link_specifier_t *obj)
{
  if (obj == NULL)
    return;
  link_specifier_clear(obj);
  trunnel_memwipe(obj, sizeof(link_specifier_t));
  trunnel_free_(obj);
}

uint8_t
link_specifier_get_ls_type(const link_specifier_t *inp)
{
  return inp->ls_type;
}
int
link_specifier_set_ls_type(link_specifier_t *inp, uint8_t val)
{
  inp->ls_type = val;
  return 0;
}
uint8_t
link_specifier_get_ls_len(const link_specifier_t *inp)
{
  return inp->ls_len;
}
int
link_specifier_set_ls_len(link_specifier_t *inp, uint8_t val)
{
  inp->ls_len = val;
  return 0;
}
uint32_t
link_specifier_get_un_ipv4_addr(const link_specifier_t *inp)
{
  return inp->un_ipv4_addr;
}
int
link_specifier_set_un_ipv4_addr(link_specifier_t *inp, uint32_t val)
{
  inp->un_ipv4_addr = val;
  return 0;
}
uint16_t
link_specifier_get_un_ipv4_port(const link_specifier_t *inp)
{
  return inp->un_ipv4_port;
}
int
link_specifier_set_un_ipv4_port(link_specifier_t *inp, uint16_t val)
{
  inp->un_ipv4_port = val;
  return 0;
}
size_t
link_specifier_getlen_un_ipv6_addr(const link_specifier_t *inp)
{
  (void)inp;  return 16;
}

uint8_t
link_specifier_get_un_ipv6_addr(link_specifier_t *inp, size_t idx)
{
  trunnel_assert(idx < 16);
  return inp->un_ipv6_addr[idx];
}

uint8_t
link_specifier_getconst_un_ipv6_addr(const link_specifier_t *inp, size_t idx)
{
  return link_specifier_get_un_ipv6_addr((link_specifier_t*)inp, idx);
}
int
link_specifier_set_un_ipv6_addr(link_specifier_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 16);
  inp->un_ipv6_addr[idx] = elt;
  return 0;
}

uint8_t *
link_specifier_getarray_un_ipv6_addr(link_specifier_t *inp)
{
  return inp->un_ipv6_addr;
}
const uint8_t  *
link_specifier_getconstarray_un_ipv6_addr(const link_specifier_t *inp)
{
  return (const uint8_t  *)link_specifier_getarray_un_ipv6_addr((link_specifier_t*)inp);
}
uint16_t
link_specifier_get_un_ipv6_port(const link_specifier_t *inp)
{
  return inp->un_ipv6_port;
}
int
link_specifier_set_un_ipv6_port(link_specifier_t *inp, uint16_t val)
{
  inp->un_ipv6_port = val;
  return 0;
}
size_t
link_specifier_getlen_un_legacy_id(const link_specifier_t *inp)
{
  (void)inp;  return 20;
}

uint8_t
link_specifier_get_un_legacy_id(link_specifier_t *inp, size_t idx)
{
  trunnel_assert(idx < 20);
  return inp->un_legacy_id[idx];
}

uint8_t
link_specifier_getconst_un_legacy_id(const link_specifier_t *inp, size_t idx)
{
  return link_specifier_get_un_legacy_id((link_specifier_t*)inp, idx);
}
int
link_specifier_set_un_legacy_id(link_specifier_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 20);
  inp->un_legacy_id[idx] = elt;
  return 0;
}

uint8_t *
link_specifier_getarray_un_legacy_id(link_specifier_t *inp)
{
  return inp->un_legacy_id;
}
const uint8_t  *
link_specifier_getconstarray_un_legacy_id(const link_specifier_t *inp)
{
  return (const uint8_t  *)link_specifier_getarray_un_legacy_id((link_specifier_t*)inp);
}
size_t
link_specifier_getlen_un_ed25519_id(const link_specifier_t *inp)
{
  (void)inp;  return 32;
}

uint8_t
link_specifier_get_un_ed25519_id(link_specifier_t *inp, size_t idx)
{
  trunnel_assert(idx < 32);
  return inp->un_ed25519_id[idx];
}

uint8_t
link_specifier_getconst_un_ed25519_id(const link_specifier_t *inp, size_t idx)
{
  return link_specifier_get_un_ed25519_id((link_specifier_t*)inp, idx);
}
int
link_specifier_set_un_ed25519_id(link_specifier_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 32);
  inp->un_ed25519_id[idx] = elt;
  return 0;
}

uint8_t *
link_specifier_getarray_un_ed25519_id(link_specifier_t *inp)
{
  return inp->un_ed25519_id;
}
const uint8_t  *
link_specifier_getconstarray_un_ed25519_id(const link_specifier_t *inp)
{
  return (const uint8_t  *)link_specifier_getarray_un_ed25519_id((link_specifier_t*)inp);
}
size_t
link_specifier_getlen_un_unrecognized(const link_specifier_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->un_unrecognized);
}

uint8_t
link_specifier_get_un_unrecognized(link_specifier_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->un_unrecognized, idx);
}

uint8_t
link_specifier_getconst_un_unrecognized(const link_specifier_t *inp, size_t idx)
{
  return link_specifier_get_un_unrecognized((link_specifier_t*)inp, idx);
}
int
link_specifier_set_un_unrecognized(link_specifier_t *inp, size_t idx, uint8_t elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->un_unrecognized, idx, elt);
  return 0;
}
int
link_specifier_add_un_unrecognized(link_specifier_t *inp, uint8_t elt)
{
  TRUNNEL_DYNARRAY_ADD(uint8_t, &inp->un_unrecognized, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

uint8_t *
link_specifier_getarray_un_unrecognized(link_specifier_t *inp)
{
  return inp->un_unrecognized.elts_;
}
const uint8_t  *
link_specifier_getconstarray_un_unrecognized(const link_specifier_t *inp)
{
  return (const uint8_t  *)link_specifier_getarray_un_unrecognized((link_specifier_t*)inp);
}
int
link_specifier_setlen_un_unrecognized(link_specifier_t *inp, size_t newlen)
{
  uint8_t *newptr;
  newptr = trunnel_dynarray_setlen(&inp->un_unrecognized.allocated_,
                 &inp->un_unrecognized.n_, inp->un_unrecognized.elts_, newlen,
                 sizeof(inp->un_unrecognized.elts_[0]), (trunnel_free_fn_t) NULL,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->un_unrecognized.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
const char *
link_specifier_check(const link_specifier_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  switch (obj->ls_type) {

    case LS_IPV4:
      break;

    case LS_IPV6:
      break;

    case LS_LEGACY_ID:
      break;

    case LS_ED25519_ID:
      break;

    default:
      break;
  }
  return NULL;
}

ssize_t
link_specifier_encoded_len(const link_specifier_t *obj)
{
  ssize_t result = 0;

  if (NULL != link_specifier_check(obj))
     return -1;


  /* Length of u8 ls_type */
  result += 1;

  /* Length of u8 ls_len */
  result += 1;
  switch (obj->ls_type) {

    case LS_IPV4:

      /* Length of u32 un_ipv4_addr */
      result += 4;

      /* Length of u16 un_ipv4_port */
      result += 2;
      break;

    case LS_IPV6:

      /* Length of u8 un_ipv6_addr[16] */
      result += 16;

      /* Length of u16 un_ipv6_port */
      result += 2;
      break;

    case LS_LEGACY_ID:

      /* Length of u8 un_legacy_id[20] */
      result += 20;
      break;

    case LS_ED25519_ID:

      /* Length of u8 un_ed25519_id[32] */
      result += 32;
      break;

    default:

      /* Length of u8 un_unrecognized[] */
      result += TRUNNEL_DYNARRAY_LEN(&obj->un_unrecognized);
      break;
  }
  return result;
}
int
link_specifier_clear_errors(link_specifier_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
link_specifier_encode(uint8_t *output, const size_t avail, const link_specifier_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = link_specifier_encoded_len(obj);
#endif

  uint8_t *backptr_ls_len = NULL;

  if (NULL != (msg = link_specifier_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u8 ls_type */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->ls_type));
  written += 1; ptr += 1;

  /* Encode u8 ls_len */
  backptr_ls_len = ptr;
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->ls_len));
  written += 1; ptr += 1;
  {
    size_t written_before_union = written;

    /* Encode union un[ls_type] */
    trunnel_assert(written <= avail);
    switch (obj->ls_type) {

      case LS_IPV4:

        /* Encode u32 un_ipv4_addr */
        trunnel_assert(written <= avail);
        if (avail - written < 4)
          goto truncated;
        trunnel_set_uint32(ptr, trunnel_htonl(obj->un_ipv4_addr));
        written += 4; ptr += 4;

        /* Encode u16 un_ipv4_port */
        trunnel_assert(written <= avail);
        if (avail - written < 2)
          goto truncated;
        trunnel_set_uint16(ptr, trunnel_htons(obj->un_ipv4_port));
        written += 2; ptr += 2;
        break;

      case LS_IPV6:

        /* Encode u8 un_ipv6_addr[16] */
        trunnel_assert(written <= avail);
        if (avail - written < 16)
          goto truncated;
        memcpy(ptr, obj->un_ipv6_addr, 16);
        written += 16; ptr += 16;

        /* Encode u16 un_ipv6_port */
        trunnel_assert(written <= avail);
        if (avail - written < 2)
          goto truncated;
        trunnel_set_uint16(ptr, trunnel_htons(obj->un_ipv6_port));
        written += 2; ptr += 2;
        break;

      case LS_LEGACY_ID:

        /* Encode u8 un_legacy_id[20] */
        trunnel_assert(written <= avail);
        if (avail - written < 20)
          goto truncated;
        memcpy(ptr, obj->un_legacy_id, 20);
        written += 20; ptr += 20;
        break;

      case LS_ED25519_ID:

        /* Encode u8 un_ed25519_id[32] */
        trunnel_assert(written <= avail);
        if (avail - written < 32)
          goto truncated;
        memcpy(ptr, obj->un_ed25519_id, 32);
        written += 32; ptr += 32;
        break;

      default:

        /* Encode u8 un_unrecognized[] */
        {
          size_t elt_len = TRUNNEL_DYNARRAY_LEN(&obj->un_unrecognized);
          trunnel_assert(written <= avail);
          if (avail - written < elt_len)
            goto truncated;
          if (elt_len)
            memcpy(ptr, obj->un_unrecognized.elts_, elt_len);
          written += elt_len; ptr += elt_len;
        }
        break;
    }
    /* Write the length field back to ls_len */
    trunnel_assert(written >= written_before_union);
#if UINT8_MAX < SIZE_MAX
    if (written - written_before_union > UINT8_MAX)
      goto check_failed;
#endif
    trunnel_set_uint8(backptr_ls_len, (written - written_before_union));
  }


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As link_specifier_parse(), but do not allocate the output object.
 */
static ssize_t
link_specifier_parse_into(link_specifier_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u8 ls_type */
  CHECK_REMAINING(1, truncated);
  obj->ls_type = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse u8 ls_len */
  CHECK_REMAINING(1, truncated);
  obj->ls_len = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;
  {
    size_t remaining_after;
    CHECK_REMAINING(obj->ls_len, truncated);
    remaining_after = remaining - obj->ls_len;
    remaining = obj->ls_len;

    /* Parse union un[ls_type] */
    switch (obj->ls_type) {

      case LS_IPV4:

        /* Parse u32 un_ipv4_addr */
        CHECK_REMAINING(4, fail);
        obj->un_ipv4_addr = trunnel_ntohl(trunnel_get_uint32(ptr));
        remaining -= 4; ptr += 4;

        /* Parse u16 un_ipv4_port */
        CHECK_REMAINING(2, fail);
        obj->un_ipv4_port = trunnel_ntohs(trunnel_get_uint16(ptr));
        remaining -= 2; ptr += 2;
        break;

      case LS_IPV6:

        /* Parse u8 un_ipv6_addr[16] */
        CHECK_REMAINING(16, fail);
        memcpy(obj->un_ipv6_addr, ptr, 16);
        remaining -= 16; ptr += 16;

        /* Parse u16 un_ipv6_port */
        CHECK_REMAINING(2, fail);
        obj->un_ipv6_port = trunnel_ntohs(trunnel_get_uint16(ptr));
        remaining -= 2; ptr += 2;
        break;

      case LS_LEGACY_ID:

        /* Parse u8 un_legacy_id[20] */
        CHECK_REMAINING(20, fail);
        memcpy(obj->un_legacy_id, ptr, 20);
        remaining -= 20; ptr += 20;
        break;

      case LS_ED25519_ID:

        /* Parse u8 un_ed25519_id[32] */
        CHECK_REMAINING(32, fail);
        memcpy(obj->un_ed25519_id, ptr, 32);
        remaining -= 32; ptr += 32;
        break;

      default:

        /* Parse u8 un_unrecognized[] */
        TRUNNEL_DYNARRAY_EXPAND(uint8_t, &obj->un_unrecognized, remaining, {});
        obj->un_unrecognized.n_ = remaining;
        if (remaining)
          memcpy(obj->un_unrecognized.elts_, ptr, remaining);
        ptr += remaining; remaining -= remaining;
        break;
    }
    if (remaining != 0)
      goto fail;
    remaining = remaining_after;
  }
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 trunnel_alloc_failed:
  return -1;
 fail:
  result = -1;
  return result;
}

ssize_t
link_specifier_parse(link_specifier_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = link_specifier_new();
  if (NULL == *output)
    return -1;
  result = link_specifier_parse_into(*output, input, len_in);
  if (result < 0) {
    link_specifier_free(*output);
    *output = NULL;
  }
  return result;
}
ed25519_cert_t *
ed25519_cert_new(void)
{
  ed25519_cert_t *val = trunnel_calloc(1, sizeof(ed25519_cert_t));
  if (NULL == val)
    return NULL;
  val->version = 1;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
ed25519_cert_clear(ed25519_cert_t *obj)
{
  (void) obj;
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ext); ++idx) {
      ed25519_cert_extension_free(TRUNNEL_DYNARRAY_GET(&obj->ext, idx));
    }
  }
  TRUNNEL_DYNARRAY_WIPE(&obj->ext);
  TRUNNEL_DYNARRAY_CLEAR(&obj->ext);
}

void
ed25519_cert_free(ed25519_cert_t *obj)
{
  if (obj == NULL)
    return;
  ed25519_cert_clear(obj);
  trunnel_memwipe(obj, sizeof(ed25519_cert_t));
  trunnel_free_(obj);
}

uint8_t
ed25519_cert_get_version(const ed25519_cert_t *inp)
{
  return inp->version;
}
int
ed25519_cert_set_version(ed25519_cert_t *inp, uint8_t val)
{
  if (! ((val == 1))) {
     TRUNNEL_SET_ERROR_CODE(inp);
     return -1;
  }
  inp->version = val;
  return 0;
}
uint8_t
ed25519_cert_get_cert_type(const ed25519_cert_t *inp)
{
  return inp->cert_type;
}
int
ed25519_cert_set_cert_type(ed25519_cert_t *inp, uint8_t val)
{
  inp->cert_type = val;
  return 0;
}
uint32_t
ed25519_cert_get_exp_field(const ed25519_cert_t *inp)
{
  return inp->exp_field;
}
int
ed25519_cert_set_exp_field(ed25519_cert_t *inp, uint32_t val)
{
  inp->exp_field = val;
  return 0;
}
uint8_t
ed25519_cert_get_cert_key_type(const ed25519_cert_t *inp)
{
  return inp->cert_key_type;
}
int
ed25519_cert_set_cert_key_type(ed25519_cert_t *inp, uint8_t val)
{
  inp->cert_key_type = val;
  return 0;
}
size_t
ed25519_cert_getlen_certified_key(const ed25519_cert_t *inp)
{
  (void)inp;  return 32;
}

uint8_t
ed25519_cert_get_certified_key(ed25519_cert_t *inp, size_t idx)
{
  trunnel_assert(idx < 32);
  return inp->certified_key[idx];
}

uint8_t
ed25519_cert_getconst_certified_key(const ed25519_cert_t *inp, size_t idx)
{
  return ed25519_cert_get_certified_key((ed25519_cert_t*)inp, idx);
}
int
ed25519_cert_set_certified_key(ed25519_cert_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 32);
  inp->certified_key[idx] = elt;
  return 0;
}

uint8_t *
ed25519_cert_getarray_certified_key(ed25519_cert_t *inp)
{
  return inp->certified_key;
}
const uint8_t  *
ed25519_cert_getconstarray_certified_key(const ed25519_cert_t *inp)
{
  return (const uint8_t  *)ed25519_cert_getarray_certified_key((ed25519_cert_t*)inp);
}
uint8_t
ed25519_cert_get_n_extensions(const ed25519_cert_t *inp)
{
  return inp->n_extensions;
}
int
ed25519_cert_set_n_extensions(ed25519_cert_t *inp, uint8_t val)
{
  inp->n_extensions = val;
  return 0;
}
size_t
ed25519_cert_getlen_ext(const ed25519_cert_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->ext);
}

struct ed25519_cert_extension_st *
ed25519_cert_get_ext(ed25519_cert_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->ext, idx);
}

 const struct ed25519_cert_extension_st *
ed25519_cert_getconst_ext(const ed25519_cert_t *inp, size_t idx)
{
  return ed25519_cert_get_ext((ed25519_cert_t*)inp, idx);
}
int
ed25519_cert_set_ext(ed25519_cert_t *inp, size_t idx, struct ed25519_cert_extension_st * elt)
{
  ed25519_cert_extension_t *oldval = TRUNNEL_DYNARRAY_GET(&inp->ext, idx);
  if (oldval && oldval != elt)
    ed25519_cert_extension_free(oldval);
  return ed25519_cert_set0_ext(inp, idx, elt);
}
int
ed25519_cert_set0_ext(ed25519_cert_t *inp, size_t idx, struct ed25519_cert_extension_st * elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->ext, idx, elt);
  return 0;
}
int
ed25519_cert_add_ext(ed25519_cert_t *inp, struct ed25519_cert_extension_st * elt)
{
#if SIZE_MAX >= UINT8_MAX
  if (inp->ext.n_ == UINT8_MAX)
    goto trunnel_alloc_failed;
#endif
  TRUNNEL_DYNARRAY_ADD(struct ed25519_cert_extension_st *, &inp->ext, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

struct ed25519_cert_extension_st * *
ed25519_cert_getarray_ext(ed25519_cert_t *inp)
{
  return inp->ext.elts_;
}
const struct ed25519_cert_extension_st *  const  *
ed25519_cert_getconstarray_ext(const ed25519_cert_t *inp)
{
  return (const struct ed25519_cert_extension_st *  const  *)ed25519_cert_getarray_ext((ed25519_cert_t*)inp);
}
int
ed25519_cert_setlen_ext(ed25519_cert_t *inp, size_t newlen)
{
  struct ed25519_cert_extension_st * *newptr;
#if UINT8_MAX < SIZE_MAX
  if (newlen > UINT8_MAX)
    goto trunnel_alloc_failed;
#endif
  newptr = trunnel_dynarray_setlen(&inp->ext.allocated_,
                 &inp->ext.n_, inp->ext.elts_, newlen,
                 sizeof(inp->ext.elts_[0]), (trunnel_free_fn_t) ed25519_cert_extension_free,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->ext.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
size_t
ed25519_cert_getlen_signature(const ed25519_cert_t *inp)
{
  (void)inp;  return 64;
}

uint8_t
ed25519_cert_get_signature(ed25519_cert_t *inp, size_t idx)
{
  trunnel_assert(idx < 64);
  return inp->signature[idx];
}

uint8_t
ed25519_cert_getconst_signature(const ed25519_cert_t *inp, size_t idx)
{
  return ed25519_cert_get_signature((ed25519_cert_t*)inp, idx);
}
int
ed25519_cert_set_signature(ed25519_cert_t *inp, size_t idx, uint8_t elt)
{
  trunnel_assert(idx < 64);
  inp->signature[idx] = elt;
  return 0;
}

uint8_t *
ed25519_cert_getarray_signature(ed25519_cert_t *inp)
{
  return inp->signature;
}
const uint8_t  *
ed25519_cert_getconstarray_signature(const ed25519_cert_t *inp)
{
  return (const uint8_t  *)ed25519_cert_getarray_signature((ed25519_cert_t*)inp);
}
const char *
ed25519_cert_check(const ed25519_cert_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  if (! (obj->version == 1))
    return "Integer out of bounds";
  {
    const char *msg;

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ext); ++idx) {
      if (NULL != (msg = ed25519_cert_extension_check(TRUNNEL_DYNARRAY_GET(&obj->ext, idx))))
        return msg;
    }
  }
  if (TRUNNEL_DYNARRAY_LEN(&obj->ext) != obj->n_extensions)
    return "Length mismatch for ext";
  return NULL;
}

ssize_t
ed25519_cert_encoded_len(const ed25519_cert_t *obj)
{
  ssize_t result = 0;

  if (NULL != ed25519_cert_check(obj))
     return -1;


  /* Length of u8 version IN [1] */
  result += 1;

  /* Length of u8 cert_type */
  result += 1;

  /* Length of u32 exp_field */
  result += 4;

  /* Length of u8 cert_key_type */
  result += 1;

  /* Length of u8 certified_key[32] */
  result += 32;

  /* Length of u8 n_extensions */
  result += 1;

  /* Length of struct ed25519_cert_extension ext[n_extensions] */
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ext); ++idx) {
      result += ed25519_cert_extension_encoded_len(TRUNNEL_DYNARRAY_GET(&obj->ext, idx));
    }
  }

  /* Length of u8 signature[64] */
  result += 64;
  return result;
}
int
ed25519_cert_clear_errors(ed25519_cert_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
ed25519_cert_encode(uint8_t *output, const size_t avail, const ed25519_cert_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = ed25519_cert_encoded_len(obj);
#endif

  if (NULL != (msg = ed25519_cert_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u8 version IN [1] */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->version));
  written += 1; ptr += 1;

  /* Encode u8 cert_type */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->cert_type));
  written += 1; ptr += 1;

  /* Encode u32 exp_field */
  trunnel_assert(written <= avail);
  if (avail - written < 4)
    goto truncated;
  trunnel_set_uint32(ptr, trunnel_htonl(obj->exp_field));
  written += 4; ptr += 4;

  /* Encode u8 cert_key_type */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->cert_key_type));
  written += 1; ptr += 1;

  /* Encode u8 certified_key[32] */
  trunnel_assert(written <= avail);
  if (avail - written < 32)
    goto truncated;
  memcpy(ptr, obj->certified_key, 32);
  written += 32; ptr += 32;

  /* Encode u8 n_extensions */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->n_extensions));
  written += 1; ptr += 1;

  /* Encode struct ed25519_cert_extension ext[n_extensions] */
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ext); ++idx) {
      trunnel_assert(written <= avail);
      result = ed25519_cert_extension_encode(ptr, avail - written, TRUNNEL_DYNARRAY_GET(&obj->ext, idx));
      if (result < 0)
        goto fail; /* XXXXXXX !*/
      written += result; ptr += result;
    }
  }

  /* Encode u8 signature[64] */
  trunnel_assert(written <= avail);
  if (avail - written < 64)
    goto truncated;
  memcpy(ptr, obj->signature, 64);
  written += 64; ptr += 64;


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As ed25519_cert_parse(), but do not allocate the output object.
 */
static ssize_t
ed25519_cert_parse_into(ed25519_cert_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u8 version IN [1] */
  CHECK_REMAINING(1, truncated);
  obj->version = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;
  if (! (obj->version == 1))
    goto fail;

  /* Parse u8 cert_type */
  CHECK_REMAINING(1, truncated);
  obj->cert_type = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse u32 exp_field */
  CHECK_REMAINING(4, truncated);
  obj->exp_field = trunnel_ntohl(trunnel_get_uint32(ptr));
  remaining -= 4; ptr += 4;

  /* Parse u8 cert_key_type */
  CHECK_REMAINING(1, truncated);
  obj->cert_key_type = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse u8 certified_key[32] */
  CHECK_REMAINING(32, truncated);
  memcpy(obj->certified_key, ptr, 32);
  remaining -= 32; ptr += 32;

  /* Parse u8 n_extensions */
  CHECK_REMAINING(1, truncated);
  obj->n_extensions = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse struct ed25519_cert_extension ext[n_extensions] */
  TRUNNEL_DYNARRAY_EXPAND(ed25519_cert_extension_t *, &obj->ext, obj->n_extensions, {});
  {
    ed25519_cert_extension_t * elt;
    unsigned idx;
    for (idx = 0; idx < obj->n_extensions; ++idx) {
      result = ed25519_cert_extension_parse(&elt, ptr, remaining);
      if (result < 0)
        goto relay_fail;
      trunnel_assert((size_t)result <= remaining);
      remaining -= result; ptr += result;
      TRUNNEL_DYNARRAY_ADD(ed25519_cert_extension_t *, &obj->ext, elt, {ed25519_cert_extension_free(elt);});
    }
  }

  /* Parse u8 signature[64] */
  CHECK_REMAINING(64, truncated);
  memcpy(obj->signature, ptr, 64);
  remaining -= 64; ptr += 64;
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 relay_fail:
  trunnel_assert(result < 0);
  return result;
 trunnel_alloc_failed:
  return -1;
 fail:
  result = -1;
  return result;
}

ssize_t
ed25519_cert_parse(ed25519_cert_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = ed25519_cert_new();
  if (NULL == *output)
    return -1;
  result = ed25519_cert_parse_into(*output, input, len_in);
  if (result < 0) {
    ed25519_cert_free(*output);
    *output = NULL;
  }
  return result;
}
extend2_cell_body_t *
extend2_cell_body_new(void)
{
  extend2_cell_body_t *val = trunnel_calloc(1, sizeof(extend2_cell_body_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
extend2_cell_body_clear(extend2_cell_body_t *obj)
{
  (void) obj;
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ls); ++idx) {
      link_specifier_free(TRUNNEL_DYNARRAY_GET(&obj->ls, idx));
    }
  }
  TRUNNEL_DYNARRAY_WIPE(&obj->ls);
  TRUNNEL_DYNARRAY_CLEAR(&obj->ls);
  create2_cell_body_free(obj->create2);
  obj->create2 = NULL;
}

void
extend2_cell_body_free(extend2_cell_body_t *obj)
{
  if (obj == NULL)
    return;
  extend2_cell_body_clear(obj);
  trunnel_memwipe(obj, sizeof(extend2_cell_body_t));
  trunnel_free_(obj);
}

uint8_t
extend2_cell_body_get_n_spec(const extend2_cell_body_t *inp)
{
  return inp->n_spec;
}
int
extend2_cell_body_set_n_spec(extend2_cell_body_t *inp, uint8_t val)
{
  inp->n_spec = val;
  return 0;
}
size_t
extend2_cell_body_getlen_ls(const extend2_cell_body_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->ls);
}

struct link_specifier_st *
extend2_cell_body_get_ls(extend2_cell_body_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->ls, idx);
}

 const struct link_specifier_st *
extend2_cell_body_getconst_ls(const extend2_cell_body_t *inp, size_t idx)
{
  return extend2_cell_body_get_ls((extend2_cell_body_t*)inp, idx);
}
int
extend2_cell_body_set_ls(extend2_cell_body_t *inp, size_t idx, struct link_specifier_st * elt)
{
  link_specifier_t *oldval = TRUNNEL_DYNARRAY_GET(&inp->ls, idx);
  if (oldval && oldval != elt)
    link_specifier_free(oldval);
  return extend2_cell_body_set0_ls(inp, idx, elt);
}
int
extend2_cell_body_set0_ls(extend2_cell_body_t *inp, size_t idx, struct link_specifier_st * elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->ls, idx, elt);
  return 0;
}
int
extend2_cell_body_add_ls(extend2_cell_body_t *inp, struct link_specifier_st * elt)
{
#if SIZE_MAX >= UINT8_MAX
  if (inp->ls.n_ == UINT8_MAX)
    goto trunnel_alloc_failed;
#endif
  TRUNNEL_DYNARRAY_ADD(struct link_specifier_st *, &inp->ls, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

struct link_specifier_st * *
extend2_cell_body_getarray_ls(extend2_cell_body_t *inp)
{
  return inp->ls.elts_;
}
const struct link_specifier_st *  const  *
extend2_cell_body_getconstarray_ls(const extend2_cell_body_t *inp)
{
  return (const struct link_specifier_st *  const  *)extend2_cell_body_getarray_ls((extend2_cell_body_t*)inp);
}
int
extend2_cell_body_setlen_ls(extend2_cell_body_t *inp, size_t newlen)
{
  struct link_specifier_st * *newptr;
#if UINT8_MAX < SIZE_MAX
  if (newlen > UINT8_MAX)
    goto trunnel_alloc_failed;
#endif
  newptr = trunnel_dynarray_setlen(&inp->ls.allocated_,
                 &inp->ls.n_, inp->ls.elts_, newlen,
                 sizeof(inp->ls.elts_[0]), (trunnel_free_fn_t) link_specifier_free,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->ls.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
struct create2_cell_body_st *
extend2_cell_body_get_create2(extend2_cell_body_t *inp)
{
  return inp->create2;
}
const struct create2_cell_body_st *
extend2_cell_body_getconst_create2(const extend2_cell_body_t *inp)
{
  return extend2_cell_body_get_create2((extend2_cell_body_t*) inp);
}
int
extend2_cell_body_set_create2(extend2_cell_body_t *inp, struct create2_cell_body_st *val)
{
  if (inp->create2 && inp->create2 != val)
    create2_cell_body_free(inp->create2);
  return extend2_cell_body_set0_create2(inp, val);
}
int
extend2_cell_body_set0_create2(extend2_cell_body_t *inp, struct create2_cell_body_st *val)
{
  inp->create2 = val;
  return 0;
}
const char *
extend2_cell_body_check(const extend2_cell_body_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  {
    const char *msg;

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ls); ++idx) {
      if (NULL != (msg = link_specifier_check(TRUNNEL_DYNARRAY_GET(&obj->ls, idx))))
        return msg;
    }
  }
  if (TRUNNEL_DYNARRAY_LEN(&obj->ls) != obj->n_spec)
    return "Length mismatch for ls";
  {
    const char *msg;
    if (NULL != (msg = create2_cell_body_check(obj->create2)))
      return msg;
  }
  return NULL;
}

ssize_t
extend2_cell_body_encoded_len(const extend2_cell_body_t *obj)
{
  ssize_t result = 0;

  if (NULL != extend2_cell_body_check(obj))
     return -1;


  /* Length of u8 n_spec */
  result += 1;

  /* Length of struct link_specifier ls[n_spec] */
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ls); ++idx) {
      result += link_specifier_encoded_len(TRUNNEL_DYNARRAY_GET(&obj->ls, idx));
    }
  }

  /* Length of struct create2_cell_body create2 */
  result += create2_cell_body_encoded_len(obj->create2);
  return result;
}
int
extend2_cell_body_clear_errors(extend2_cell_body_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
extend2_cell_body_encode(uint8_t *output, const size_t avail, const extend2_cell_body_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = extend2_cell_body_encoded_len(obj);
#endif

  if (NULL != (msg = extend2_cell_body_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u8 n_spec */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->n_spec));
  written += 1; ptr += 1;

  /* Encode struct link_specifier ls[n_spec] */
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->ls); ++idx) {
      trunnel_assert(written <= avail);
      result = link_specifier_encode(ptr, avail - written, TRUNNEL_DYNARRAY_GET(&obj->ls, idx));
      if (result < 0)
        goto fail; /* XXXXXXX !*/
      written += result; ptr += result;
    }
  }

  /* Encode struct create2_cell_body create2 */
  trunnel_assert(written <= avail);
  result = create2_cell_body_encode(ptr, avail - written, obj->create2);
  if (result < 0)
    goto fail; /* XXXXXXX !*/
  written += result; ptr += result;


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As extend2_cell_body_parse(), but do not allocate the output
 * object.
 */
static ssize_t
extend2_cell_body_parse_into(extend2_cell_body_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u8 n_spec */
  CHECK_REMAINING(1, truncated);
  obj->n_spec = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse struct link_specifier ls[n_spec] */
  TRUNNEL_DYNARRAY_EXPAND(link_specifier_t *, &obj->ls, obj->n_spec, {});
  {
    link_specifier_t * elt;
    unsigned idx;
    for (idx = 0; idx < obj->n_spec; ++idx) {
      result = link_specifier_parse(&elt, ptr, remaining);
      if (result < 0)
        goto relay_fail;
      trunnel_assert((size_t)result <= remaining);
      remaining -= result; ptr += result;
      TRUNNEL_DYNARRAY_ADD(link_specifier_t *, &obj->ls, elt, {link_specifier_free(elt);});
    }
  }

  /* Parse struct create2_cell_body create2 */
  result = create2_cell_body_parse(&obj->create2, ptr, remaining);
  if (result < 0)
    goto relay_fail;
  trunnel_assert((size_t)result <= remaining);
  remaining -= result; ptr += result;
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 relay_fail:
  trunnel_assert(result < 0);
  return result;
 trunnel_alloc_failed:
  return -1;
}

ssize_t
extend2_cell_body_parse(extend2_cell_body_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = extend2_cell_body_new();
  if (NULL == *output)
    return -1;
  result = extend2_cell_body_parse_into(*output, input, len_in);
  if (result < 0) {
    extend2_cell_body_free(*output);
    *output = NULL;
  }
  return result;
}
link_specifier_list_t *
link_specifier_list_new(void)
{
  link_specifier_list_t *val = trunnel_calloc(1, sizeof(link_specifier_list_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
link_specifier_list_clear(link_specifier_list_t *obj)
{
  (void) obj;
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->spec); ++idx) {
      link_specifier_free(TRUNNEL_DYNARRAY_GET(&obj->spec, idx));
    }
  }
  TRUNNEL_DYNARRAY_WIPE(&obj->spec);
  TRUNNEL_DYNARRAY_CLEAR(&obj->spec);
}

void
link_specifier_list_free(link_specifier_list_t *obj)
{
  if (obj == NULL)
    return;
  link_specifier_list_clear(obj);
  trunnel_memwipe(obj, sizeof(link_specifier_list_t));
  trunnel_free_(obj);
}

uint8_t
link_specifier_list_get_n_spec(const link_specifier_list_t *inp)
{
  return inp->n_spec;
}
int
link_specifier_list_set_n_spec(link_specifier_list_t *inp, uint8_t val)
{
  inp->n_spec = val;
  return 0;
}
size_t
link_specifier_list_getlen_spec(const link_specifier_list_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->spec);
}

struct link_specifier_st *
link_specifier_list_get_spec(link_specifier_list_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->spec, idx);
}

 const struct link_specifier_st *
link_specifier_list_getconst_spec(const link_specifier_list_t *inp, size_t idx)
{
  return link_specifier_list_get_spec((link_specifier_list_t*)inp, idx);
}
int
link_specifier_list_set_spec(link_specifier_list_t *inp, size_t idx, struct link_specifier_st * elt)
{
  link_specifier_t *oldval = TRUNNEL_DYNARRAY_GET(&inp->spec, idx);
  if (oldval && oldval != elt)
    link_specifier_free(oldval);
  return link_specifier_list_set0_spec(inp, idx, elt);
}
int
link_specifier_list_set0_spec(link_specifier_list_t *inp, size_t idx, struct link_specifier_st * elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->spec, idx, elt);
  return 0;
}
int
link_specifier_list_add_spec(link_specifier_list_t *inp, struct link_specifier_st * elt)
{
#if SIZE_MAX >= UINT8_MAX
  if (inp->spec.n_ == UINT8_MAX)
    goto trunnel_alloc_failed;
#endif
  TRUNNEL_DYNARRAY_ADD(struct link_specifier_st *, &inp->spec, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

struct link_specifier_st * *
link_specifier_list_getarray_spec(link_specifier_list_t *inp)
{
  return inp->spec.elts_;
}
const struct link_specifier_st *  const  *
link_specifier_list_getconstarray_spec(const link_specifier_list_t *inp)
{
  return (const struct link_specifier_st *  const  *)link_specifier_list_getarray_spec((link_specifier_list_t*)inp);
}
int
link_specifier_list_setlen_spec(link_specifier_list_t *inp, size_t newlen)
{
  struct link_specifier_st * *newptr;
#if UINT8_MAX < SIZE_MAX
  if (newlen > UINT8_MAX)
    goto trunnel_alloc_failed;
#endif
  newptr = trunnel_dynarray_setlen(&inp->spec.allocated_,
                 &inp->spec.n_, inp->spec.elts_, newlen,
                 sizeof(inp->spec.elts_[0]), (trunnel_free_fn_t) link_specifier_free,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->spec.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
const char *
link_specifier_list_check(const link_specifier_list_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  {
    const char *msg;

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->spec); ++idx) {
      if (NULL != (msg = link_specifier_check(TRUNNEL_DYNARRAY_GET(&obj->spec, idx))))
        return msg;
    }
  }
  if (TRUNNEL_DYNARRAY_LEN(&obj->spec) != obj->n_spec)
    return "Length mismatch for spec";
  return NULL;
}

ssize_t
link_specifier_list_encoded_len(const link_specifier_list_t *obj)
{
  ssize_t result = 0;

  if (NULL != link_specifier_list_check(obj))
     return -1;


  /* Length of u8 n_spec */
  result += 1;

  /* Length of struct link_specifier spec[n_spec] */
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->spec); ++idx) {
      result += link_specifier_encoded_len(TRUNNEL_DYNARRAY_GET(&obj->spec, idx));
    }
  }
  return result;
}
int
link_specifier_list_clear_errors(link_specifier_list_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
link_specifier_list_encode(uint8_t *output, const size_t avail, const link_specifier_list_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = link_specifier_list_encoded_len(obj);
#endif

  if (NULL != (msg = link_specifier_list_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u8 n_spec */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->n_spec));
  written += 1; ptr += 1;

  /* Encode struct link_specifier spec[n_spec] */
  {

    unsigned idx;
    for (idx = 0; idx < TRUNNEL_DYNARRAY_LEN(&obj->spec); ++idx) {
      trunnel_assert(written <= avail);
      result = link_specifier_encode(ptr, avail - written, TRUNNEL_DYNARRAY_GET(&obj->spec, idx));
      if (result < 0)
        goto fail; /* XXXXXXX !*/
      written += result; ptr += result;
    }
  }


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As link_specifier_list_parse(), but do not allocate the output
 * object.
 */
static ssize_t
link_specifier_list_parse_into(link_specifier_list_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u8 n_spec */
  CHECK_REMAINING(1, truncated);
  obj->n_spec = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;

  /* Parse struct link_specifier spec[n_spec] */
  TRUNNEL_DYNARRAY_EXPAND(link_specifier_t *, &obj->spec, obj->n_spec, {});
  {
    link_specifier_t * elt;
    unsigned idx;
    for (idx = 0; idx < obj->n_spec; ++idx) {
      result = link_specifier_parse(&elt, ptr, remaining);
      if (result < 0)
        goto relay_fail;
      trunnel_assert((size_t)result <= remaining);
      remaining -= result; ptr += result;
      TRUNNEL_DYNARRAY_ADD(link_specifier_t *, &obj->spec, elt, {link_specifier_free(elt);});
    }
  }
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 relay_fail:
  trunnel_assert(result < 0);
  return result;
 trunnel_alloc_failed:
  return -1;
}

ssize_t
link_specifier_list_parse(link_specifier_list_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = link_specifier_list_new();
  if (NULL == *output)
    return -1;
  result = link_specifier_list_parse_into(*output, input, len_in);
  if (result < 0) {
    link_specifier_list_free(*output);
    *output = NULL;
  }
  return result;
}
