/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "CSSSelector.h"
#include <wtf/BloomFilter.h>
#include <wtf/TZoneMalloc.h>

namespace WebCore {

class Element;

namespace Style {

enum class MatchElement : uint8_t;

class HasSelectorFilter {
    WTF_MAKE_TZONE_ALLOCATED(HasSelectorFilter);
public:
    enum class Type : uint8_t { Children, Descendants };
    HasSelectorFilter(const Element&, Type);

    Type type() const { return m_type; }
    static std::optional<Type> typeForMatchElement(MatchElement);

    using Key = unsigned;
    static Key makeKey(const CSSSelector& hasSelector);

    bool reject(const CSSSelector& hasSelector) const { return reject(makeKey(hasSelector)); }
    bool reject(Key key) const { return key && !m_filter.mayContain(key); }

private:
    void add(const Element&);

    const Type m_type;
    BloomFilter<12> m_filter;
};

}
}
