<p align="center">
  <a href="http://get.foundation/">
    <img src="https://user-images.githubusercontent.com/9939075/38782856-2a64a43e-40fa-11e8-89cd-e873af03b3c4.png" alt="Foundation for Sites 6" width="448px" style="max-width:100%;"/>
  </a>
</p>

<p align="center">
  <a href="https://get.foundation/sites/docs/installation.html"><b>Install</b></a>
  | <a href="https://get.foundation/sites/docs">Documentation</a>
  | <a href="https://github.com/foundation/foundation-sites/releases">Releases</a>
  | <a href="CONTRIBUTING.md">Contributing</a>
</p>

---

[![Build Status](https://github.com/foundation/foundation-sites/workflows/CI/badge.svg)](https://github.com/foundation/foundation-sites/actions?workflow=CI)
[![dependencies Status](https://david-dm.org/foundation/foundation-sites/status.svg)](https://david-dm.org/foundation/foundation-sites)
[![devDependencies Status](https://david-dm.org/foundation/foundation-sites/dev-status.svg)](https://david-dm.org/foundation/foundation-sites?type=dev)
[![npm version](https://badge.fury.io/js/foundation-sites.svg)](https://badge.fury.io/js/foundation-sites)
[![Bower version](https://badge.fury.io/bo/foundation-sites.svg)](https://badge.fury.io/bo/foundation-sites)
[![Gem Version](https://badge.fury.io/rb/foundation-rails.svg)](https://badge.fury.io/rb/foundation-rails)
[![jsDelivr Hits](https://data.jsdelivr.com/v1/package/npm/foundation-sites/badge?style=rounded)](https://www.jsdelivr.com/package/npm/foundation-sites)
[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/zurb/foundation-sites?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
[![Netlify Status](https://api.netlify.com/api/v1/badges/da72b0f9-3d51-4d50-951e-6bbf5fe88601/deploy-status)](https://app.netlify.com/sites/foundation-sites/deploys)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=foundation_foundation-sites&metric=alert_status)](https://sonarcloud.io/dashboard?id=foundation_foundation-sites)
[![Known Vulnerabilities](https://snyk.io/test/github/foundation/foundation-sites/badge.svg)](https://snyk.io/test/github/foundation/foundation-sites)
[![BrowserStack Status](https://automate.browserstack.com/badge.svg?badge_key=ZlJCVGIxaEgvaFc4TWhBZ0hFWGtIMjBRZEw0UnFrUys3ZGdrbmZ6TW5lZz0tLU9wZUdFV2lmNVd1dU9XbWxuQ05BOGc9PQ==--915d78e23eeed2ae37ce7a670bc370011a9e4fd9)](https://automate.browserstack.com/public-build/ZlJCVGIxaEgvaFc4TWhBZ0hFWGtIMjBRZEw0UnFrUys3ZGdrbmZ6TW5lZz0tLU9wZUdFV2lmNVd1dU9XbWxuQ05BOGc9PQ==--915d78e23eeed2ae37ce7a670bc370011a9e4fd9)


Foundation is the most advanced responsive front-end framework in the world. Quickly go from prototype to production, building sites or apps that work on any kind of device with Foundation. Includes a fully customizable, responsive grid, a large library of Sass mixins, commonly used JavaScript plugins, and full accessibility support.

---

## Run locally

### Documentation

To run the documentation locally on your machine, you need [Node.js](https://nodejs.org/en/) installed on your computer. (Your Node.js version must be **6.4.0** or higher). Run these commands to set up the documentation:

```bash
# Install
git clone https://github.com/foundation/foundation-sites
cd foundation-sites
yarn

# Start the documentation
yarn start
```

### Testing

Foundation has three kinds of tests: JavaScript, Sass, and visual regression. Refer to our [testing guide](https://github.com/foundation/foundation-sites/wiki/Testing-Guide) for more details.

Run tests with:
```bash
# Sass unit tests
yarn test:sass
# JavaScript unit tests
yarn test:javascript:units
# Visual tests
yarn test:visual
```

## Contributing

Check out [CONTRIBUTING.md](CONTRIBUTING.md) to see how to report an issue or submit a bug fix or a new feature, and our [contributing guide](https://get.foundation/get-involved/contribute.html) to learn how you can contribute more globally to Foundation. You can also browse the [Help Wanted](https://github.com/foundation/foundation-sites/labels/help%20wanted) tag in our issue tracker to find things to do.

## Training

Want the guided tour to Foundation from the team that built it? The ZURB team offers comprehensive training courses for developers of all skill levels. If you're new to Foundation, check out the [Introduction to Foundation Course](http://zurb.com/university/foundation-intro?utm_source=Github%20Repo&utm_medium=website&utm_campaign=readme&utm_content=readme%20training%20link) to kickstart your skills, amplify your productivity, and get a comprehensive overview of everything Foundation has to offer. More advanced users should check out the [Advanced Foundation Course](http://zurb.com/university/advanced-foundation-training?utm_source=Github%20Repo&utm_medium=website&utm_campaign=readme&utm_content=readme%20training%20link) to learn the Advanced skills that ZURB uses to deliver quality client work in short timeframes.

Copyright © 2020 Foundation Community
