/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xplot.h"

/* global vars */
Data
    *data;				    /* read datapoints */ 
int
    linetype = LINETYPE_GUESS,		    /* line type for plotting */
    autoredraw = 1,			    /* auto-redraw all data? */
    verbose,                                /* verbosity level */
    ylimits_set,                            /* Y limits set via flag ? */
    ndata;				    /* # of read series */ 
double
    minx = 9e99, maxx = -9e99,		    /* overall boundaries */ 
    miny = 9e99, maxy = -9e99,
    curminx, curmaxx,			    /* current boundaries */ 
    curminy, curmaxy;
Blowup
    *blowups;				    /* array of blowup forms */ 
int
    nblowups;				    /* and # of blowup forms */
char
    formatstring [256],                     /* formatstring to read data */
    titlestring [256];			    /* title of plots if any */

void main (int argc, char **argv)
{
    register int
	i;

    /* check for flags */
    while (argc > 1 && *argv [1] == '-')
    {
        /* title of plot */
        if (! strcmp (argv [1], "-title"))
        {
	    if (argc < 3)
	        error ("missing plot title after -title flag");
	    strcpy (titlestring, argv [2]);
	    argc -= 2;
	    argv += 2;
        }
        /* formatstring to read in data */
        else if (! strcmp (argv [1], "-format"))
        {
            if (argc < 3)
                error ("missing format string after -format flag");
            strcpy (formatstring, argv [2]);
            argc -= 2;
            argv += 2;
        }
        else if (! strcmp (argv [1], "-v"))
        {
            verbose++;
            argc--;
            argv++;
        }
        else if (! strcmp (argv [1], "-y"))
        {
            if (argc < 3)
                error ("missing y range after -y flag");
            if (sscanf (argv [2], "%lf:%lf", &miny, &maxy) < 2)
                error ("bad y range after -y flag, use e.g. -y 0:6.28");
            ylimits_set++;
            argc -= 2;
            argv += 2;
        }
        else
            error ("bad flag argument %s", argv [1]);
    }
	    
    /* check for invocation without args */ 
    if (argc == 1 && isatty (STDIN_FILENO))
	usage ();

    /* demonize if compiled so, see the Makefile */
#ifdef DAEMONIZE
    if (argc > 1)
    {
        if ( (i = fork ()) < 0 )
	    warning ("fork failure: %s", strerror (errno));
        else if (i)
	    exit (0);
    }
#endif    
    
    /* fire up X forms */
    fl_initialize (&argc, argv, "XPlot", 0, 0);
    create_form_plot ();
    create_form_activator ();
    create_form_help ();
    /* initial linestyle */
    fl_set_button (linetype_guess, 1);
    /* initial redraw option */
    fl_set_button (autoredraw_button, 1);

    /* check arguments, read files */
    if (argc == 1)
    {
	if (isatty (STDIN_FILENO))
	    usage ();
	readfile (stdin, "<<stdin>>");
    }
    
    for (i = 1; i < argc; i++)
    {
	FILE
	    *f;
	    
	if (! (f = fopen (argv [i], "r")) )
	    error ("cannot open %s: %s", argv [i], strerror (errno));
	readfile (f, argv [i]);
	fclose (f);
    }

    /* show overall X/Y ranges */
    if (verbose)
        printf ("overall X: %g..%g\n"
	        "overall Y: %g..%g\n", minx, maxx, miny, maxy);

    /* set current boundaries */ 
    curminx = minx; curmaxx = maxx;
    curminy = miny; curmaxy = maxy;
    fl_set_slider_bounds (minx_slider, minx, maxx);
    fl_set_slider_bounds (maxx_slider, minx, maxx);
    /* Changed by: Peter S Galbraith <psg@debian.org>     
       Date:       28 December 1998
       Why:        I am reversing the direction of the y-sliders to make
                   the interface more intuitive.  When a user slide down 
                   the first slider from its top position, the top of the 
                   y-axis scale will change instead of the _bottom_ of the
                   y-axis. 
    Original code:
    fl_set_slider_bounds (miny_slider, miny, maxy);
    fl_set_slider_bounds (maxy_slider, miny, maxy); 
    New code follows the comment:
    */
    fl_set_slider_bounds (miny_slider, maxy, miny);
    fl_set_slider_bounds (maxy_slider, maxy, miny);

    /* show main form and draw */ 
    showform (plot, FL_PLACE_SIZE, "XPlot Control");
    boundaries ();

    /* forms loop */
    fl_do_forms ();
    
    /* not reached */ 
}
