/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>


#include "struct.h"
#include "func.h"
#include "lang.h"
#include "ligas.h"
#include "dmconst.h"
#include "cut_glue.h"
#include "linutil.h"

#include "compat_defs.h"

extern Bool pass4_in;   //䫠: ன 室  ࠭


/*-----------------03-14-95 02:23pm----------------------------------
  comp_to_cell  ᮡࠥ cell  N envelope ᯨ᪠ list;
                頥 㪠⥫  
  NB!      !
-------------------------------------------------------------------*/
cell *comp_to_cell(cell *C, c_comp **list, int16_t N, char bdiff, uchar dflag)
{
  int16_t i,top,bot,left,right;
  cell *B;                       //⥪騩 cell

  if ( N==0 ) return NULL;

  B=new_cell();

  for (top=left=10000,bot=right=-10000,i=0; i<N && i<MAX_SECT; i++)
  {
    if (list[i]->upper<top)
     top=list[i]->upper;
    if (list[i]->upper+list[i]->h>bot)
     bot=list[i]->upper+list[i]->h;
    if (list[i]->left<left)
     left=list[i]->left;
    if (list[i]->left+list[i]->w>right)
     right=list[i]->left+list[i]->w;
  }
  B->r_row=top;
  B->h=bot-top;
  B->r_col=left;
  B->w=right-left;
  B->row=B->r_row-(int16_t)((int32_t)nIncline*B->r_col/2048);
  B->col=B->r_col+(int16_t)((int32_t)nIncline*B->r_row/2048);
  B->env=compose_comp(i,list);
  if ( N>1 ) B->cg_flag=c_cg_comp;
  if ( if_dust(B) & 0x0c )  set_dust(B);
  else                      set_bad(B);
  B->bdiff=bdiff;  B->difflg=dflag;
  set_bad_cell(B);
  insert_cell1(B,C);
  return B;
}

/*-----------------03-14-95 02:23pm----------------------------------
  col_to_one ந ᮢ㯭 cell  n cell' ᯨ᪠ list;
             頥 㪠⥫  
-------------------------------------------------------------------*/
cell *col_to_one(cell **clist, int16_t n)
 {
 int16_t i,top,bot,left,right;
 cell *c;
 c_comp *elist[MAX_SECT];

  if ( n==0 ) return NULL;

  c=new_cell();
  c->bdiff=0;        //訡  new_cell
 for (top=left=10000,bot=right=-10000,i=0; i<n && i<MAX_SECT; i++)
  {
  if (clist[i]->r_row<top)
   top=clist[i]->r_row;
  if (clist[i]->r_row+clist[i]->h>bot)
   bot=clist[i]->r_row+clist[i]->h;
  if (clist[i]->r_col<left)
   left=clist[i]->r_col;
  if (clist[i]->r_col+clist[i]->w>right)
   right=clist[i]->r_col+clist[i]->w;
  elist[i]=clist[i]->env;
  }
 c->r_row=top;
 c->h=bot-top;
 c->r_col=left;
 c->w=right-left;
 c->row=c->r_row-(int16_t)((int32_t)nIncline*c->r_col/2048);
 c->col=c->r_col+(int16_t)((int32_t)nIncline*c->r_row/2048);
  if ( if_dust(c) & 0x0c )  set_dust(c);
  else                      set_bad(c);
  set_bad_cell(c);
  insert_cell1(c,clist[0]);
  if ( c->w > 128 || c->h > 63 )
  {
    del_cell(c); return NULL;
  }
 c->env=compose_comp(i,elist);
 if (n>1) c->cg_flag|=c_cg_comp;
 set_erection(c,erection_compose_inc(n, clist));
 inter_diff(c);
 return c;
 }

/*------------------------------------------------------------------
  overlap_cell ᫨ ࠦ cell' C  D ࠧ 吝 -
               , ந ᮢ㯭 cell  頥 㪠⥫
                ,  頥 NULL
------------------------------------------------------------------*/
static cell *overlap_cell( cell *C, cell *D )
{
  cell *list[2],*P;
  uchar *r;
  MN *mn1;

  if (C->r_col+C->w < D->r_col)  return NULL;
  list[0]=C; list[1]=D;
  if (!(P=col_to_one(list,2)))   return NULL;
  r=(uchar*)save_raster(P);
  mn1=c_locomp(r,(int16_t)((P->w+7)>>3),P->h,P->r_row,P->r_col);
  del_cell(P);
  if (mn1)
    if (!mn1->mnnext)            //᪫
    {
      P=create_my_cell(mn1,C,0,0);
      inter_diff(P);
      return P;
    }
  return NULL;
}

Bool glue_overlap(cell *LC, cell *E)
//᪫ 騥   㣠 cell'
{
  cell *B=LC->next,*C;
  while (1)
  {
    cell *P;
    while ( dust(B) && B != E )  B=B->next;  //  dust
    if (B==E)  break;
    C=B->next;
    while ( dust(C) && C != E )  C=C->next;  //᫥騩  dust
    if (C==E)  break;
    if (P=overlap_cell(B,C))
    {
      if (P->next==LC)
      {
        glsnap('a',LC,"non correct gate");
        del_cell(P);  return FALSE;
      }
      del_cell(B); del_cell(C);
      B=P;
      if (B->w>=minw && !wide(B))
        full_recog(B,NULL,trs2,trs2);
    }
    else
      B=C;
  }
  return TRUE;
}

/*---------------------------------------------------------------------
  find_vers -  ᨨ ᥣ (i1,i0) । ࠭ ᯮ 
               vers_list; 頥 㪠⥫  ᨨ, ᫨
              ,  NULL, ᫨ 
---------------------------------------------------------------------*/
seg_vers *find_vers( int16_t i1, int16_t i0, seg_vers **vers_list )
{
  seg_vers *cur_vers;

  for (cur_vers=*(vers_list+i0); cur_vers != NULL ; cur_vers=cur_vers->next)
  {
	  if (cur_vers->px==i1)
	   break;
  }
  return cur_vers;
}

/*---------------------------------------------------------------------
  store_vers -  ᨨ cur_ver ᥣ (i1,i0)  
               vers_list ( cur_vers==NULL ࠭); 頥
               㪠⥫   ᨨ
---------------------------------------------------------------------*/
seg_vers *store_vers(seg_vers *cur_vers, seg_vers **vers_list,
         int16_t i1, int16_t i0, SVERS *vers, int16_t ro, int16_t width, char gvar)
{
  if (!cur_vers && (*vers_list))           //-Rc //AK! crash //
  {
    cur_vers=*vers_list;
    if (cur_vers != (seg_vers *)vers_list)  // 
    {
      cur_vers->next=*(vers_list+i0);
      *(vers_list+i0)=cur_vers;
      (*vers_list)++;
    }
    else
      cur_vers=NULL;
  }
  if (cur_vers)              //࠭塞
  {
    cur_vers->px=(char)i1;
    cur_vers->ro=ro;
    cur_vers->width=width;
    cur_vers->gvar=gvar;
    memcpy(&cur_vers->vers,vers,sizeof(SVERS));
  }
  return cur_vers;
}

/*-----------------06-15-95 03:19pm-----------------------------------
  not_connect_sect  ஢ 吝 ᥪ樨  i1-  i0-
                    祭ﬨ; 頥  祭-ࠧ
---------------------------------------------------------------------*/
uchar not_connect_sect(int16_t i1, int16_t i0, struct cut_elm *cut_list)
{
  struct cut_elm *cur=&cut_list[i0],*last=&cut_list[i1];

  for ( cur--; cur>last; cur-- )
    if ( cur->dh == 0 )  return cur-cut_list;
  return 0;
}

/*--------------------------------------------------------------
  on_path ᫨ 設 i   , 稢饬  設
          ie, 頥  ᫥饩 設,  - 0;
          cut_list - ᯨ᮪ 祭
--------------------------------------------------------------*/
int16_t on_path(int16_t i, int16_t ie, struct cut_elm *cut_list)
{
  int16_t next=0;
  while (ie>i)
  {
    next=ie;
    ie=cut_list[ie].px;
  }
  return (ie==i) ? next : 0;
}

/*------------------------------------------------------------------------
  quote - ஢, B  B->prevl  ">>"
------------------------------------------------------------------------*/
static char quote(cell *B)
{
  cell *P;

  if ( !dust(B) && B->nvers && !fict(P=B->prevl) && P->nvers )
  {
    uchar let1=B->vers[0].let,let2=P->vers[0].let;
    if ( ( let1=='>' && let2=='>' || let1=='<' && let2=='<' )
          && P->col+P->w > B->col )
    {
      uchar p1=B->vers[0].prob,p2=P->vers[0].prob;
      if ( MAX(p1,p2) >= MINlet )
      {
        glsnap('a',B,"quotation");  return 1;
      }
    }
  }
  return 0;
}

/*--------------------------------------------------------------
--------------------------------------------------------------*/
static int16_t up_dust_mon(cell *B1)
 {
 int16_t h, w, row, dust_monus;
 long cellsz, dustsz;
 cell * wc;

 wc=B1;
pa:
 wc=wc->prev;
 if (wc->flg  & c_f_dust)
 {
   if (wc->cg_flag & c_cg_noglue) goto pa;
   if ( ((row=wc->row)+wc->h >= my_bases.b1) &&
        (row <= my_bases.b2) &&
        ((B1->col - wc->col) <= 2)
      )
     goto ret2;

 }
 wc=B1;
fa:
 wc=wc->next;
 if (wc->flg & c_f_dust)
 {
   if (wc->cg_flag & c_cg_noglue) goto fa;
   if ( ((row=wc->row)+wc->h >= my_bases.b1) &&
        (row <= my_bases.b2) &&
        (wc->col < B1->col+B1->w)
      ) // dust in our vicinity
       goto ret2;
 }
 return 0;
 ret2:
 cellsz = (h=B1->h) * (w=B1->w);
 dustsz = wc->h * wc->w;
 if (w < h)       // doubtful as multi_letter cell
   dust_monus = (int16_t)(dustsz * MONdust * 32 / cellsz);
 else
   dust_monus = (int16_t)(dustsz * MONdust * 256 / cellsz);
 if (dust_monus > MONdust) dust_monus = MONdust;
 return dust_monus & 0xfe;
 }

/*-----------------------------------------------------------------
  mark_own_dust 砥 dust', 뢠 B, ⪮ " "
-----------------------------------------------------------------*/
static void mark_own_dust(cell *B)
{
  int16_t rc=B->r_col+B->w;
  cell *C=B->prev;

  while (dust(C))
  {
    if (!lefter(C,B->r_col))  set_noglue(C);
    C=C->prev;
  }
  C=B->next;
  while (dust(C))
  {
    if (lefter(C,rc))  set_noglue(C);
    C=C->next;
  }
}

/*--------------------------------------------------------------
--------------------------------------------------------------*/
static int16_t discr_vers(cell *B1, int16_t mon, char all_vers)
 {
 version *v;  uchar c,chg=0;
 if (B1->nvers==0) return 0;
 for (v=B1->vers; ((c=v->let) != 0) && (v->prob != 0); v++)
   if (language == PUMA_LANG_RUSSIAN || accent_tab[c]==0 || all_vers)
   {
     chg++;
     if (v->prob>mon) v->prob -= mon;
     else             v->prob  = 2;
   }
 if ( chg != B1->nvers ) sort_vers(B1);
 return B1->vers[0].prob;
 }

/*--------------------------------------------------------------
--------------------------------------------------------------*/
void adjust_3x5(Bool prerecog)
{
 cell *B=cell_f()->nextl;
 while ( !fict(B) )
 {
   if (!pass4_in)  glsnap('a',B,"");
   if ( B->w <= 3*B->h )
   {
     int16_t dust_monus;

     if (pass4_in)
     {
       uchar let;
       B->pr_vers=B->vers[0];
       if (prerecog)  set_bad_cell(B);
       if (may_glue(B))
       {
         if (prerecog)  full_recog(B,NULL,(int16_t)(-((int16_t)trs2)),trs2);
         if ( let(B) &&
              ((let=B->vers[0].let)=='m' || let=='n' || let==liga_rt) )
           if ( dust_monus=up_dust_mon(B) )
           {
             if ( discr_vers(B,dust_monus,0)<trs2 )  let_to_bad(B);
             det_snap(B,"upper dust");
           }
       }
       else
         mark_own_dust(B);
     }
     else  // !pass4_in
     {
       if (language != PUMA_LANG_RUSSIAN &&
           B->nvers==0 && (B->env && (B->env->nl==1) || 3*B->w<=B->h) )
       {
         stick_center_study(B,NULL,1);      // AL, IF : 94.01.07
         det_snap(B,"bring sticks");
       }
       if ( let(B) && B->vers[0].prob<trs2 )  // -  娥
         set_bad(B);
       full_recog(B,NULL,(int16_t)(-((int16_t)trs2)),trs2);
       if ( let(B) && language != PUMA_LANG_RUSSIAN ||
            B->nvers && memchr("",B->vers[0].let,5) &&
		    !is_russian_baltic_conflict(B->vers[0].let) // 17.07.2001 E.P.
		  )
         if ( dust_monus=up_dust_mon(B) )
           if (language != PUMA_LANG_RUSSIAN)
           {
             if ( discr_vers(B,dust_monus,0)<trs2 )  set_bad(B);
             det_snap(B,"upper dust");
           }
           else
             if ( !complete_recog(B) )
             {
               let_to_bad(B);
               full_recog(B,NULL,0,trs2);
             }
       if (quote(B))  //砥 ">>":  ࠢ  ᯮ
       {
         set_let(B);  set_let(B->prevl);
       }
     }
     if (let(B))
     { char c = B->vers[0].let;
       cell *DOT = NULL;
       c = B->vers[0].let;
       if ((c == 'i') || (c == 'j'))
         DOT = dot_ij (B);
       if (c == 'n')
         DOT = dot_ri (B);
       if (DOT)
         DOT->cg_flag |= c_cg_noglue;
     }
   }
  B=B->nextl;
 }
}


/*-----------------02-28-95 03:51pm----------------------------------
  cg_show_rast  뢮  ࠭ ࠦ  r  ᮮ饭 msg
--------------------------------------------------------------------*/
void cg_show_rast(cell *C, raster *r, char *msg, struct cut_elm *cut_list)
{
  int16_t   i,n;
  MN *mn1;
  cell *B,*CI[MAX_SECT];
  void *KIT;

  if (!debug_on) return;

  KIT=give_kit_addr();     //誠 ⥪

  if (!(mn1=c_locomp(r->pict,(int16_t)((r->w+7)>>3),r->h,r->top,r->left)))
  {
    glsnap('a',C,"locomp error"); return;
  }
  for ( i=0; i<MAX_SECT && mn1; i++ )
  {
     CI[i]=create_cell(mn1,C,0,0);
     mn1=mn1->mnnext;
  }

  if ((n=i)>1)
  {
    B=col_to_one(CI,n);
    for (i=0; i<n; i++)   del_cell(CI[i]);
  }
  else
    B=CI[0];
  if (strlen(msg)) glsnap('a',B,msg);
  snap_show_cuts(B,cut_list);

  del_cell(B);
  take_kit_addr(KIT);    //᢮ ⥪

}

/*-----------------06-27-95 01:28pm------------------------------
  cg_show_list  뢮  ࠭ ࠦ ᯨ᪠  N cell' cells
---------------------------------------------------------------*/
void cg_show_list(cell **cells, int16_t N, uchar *msg)
{
  int16_t i;
  cell *B;
  c_comp *complist[MAX_SECT];
  void *KIT;

  if (!debug_on)   return;
#ifndef MY_DEBUG
  if (!det_trace)  return;
#endif

  KIT=give_kit_addr();     //誠 ⥪
  for ( i=0; i<N; i++ )  complist[i]=cells[i]->env;

  B=comp_to_cell(cells[0],complist,N,0,0);
  glsnap('a',B,msg);
  del_cell(B);
  take_kit_addr(KIT);    //᢮ ⥪
}

/*------------------------------------------------------------------
  show_dp  뢮  ࠭ ﭨ  
------------------------------------------------------------------*/
char *show_dp( puchar s, struct cut_elm *cut_list, int16_t i0)
{
  SVERS  *vers;
  char c;
  int16_t x,i,i1 = (i0>15) ? i0-14 : 1;  // ࠭ - ᫥ 15 設

  *s++='\n';
  for (i=i1; i<=i0; i++)  s += sprintf(s,"%5d",i);
  *s++='\n';
  for (i=i1; i<=i0; i++)  s += sprintf(s,"%5d",(cut_list+i)->px);
  *s++='\n';
  for (i=i1; i<=i0; i++)
  {
    vers=&(cut_list+i)->versm;
    if ( vers->nvers )        c=vers->vers[0].let;
    else
      if ( let_or_bad(vers) ) c=1;
      else if ( dust(vers) )  c=2;
           else               c=' ';
    s += sprintf(s,"%5c",c);
  }
  *s++='\n';
  for (i=i1; i<=i0; i++)
  {
    x=(cut_list+i)->rv.v1;
    if ( x==MAXINT ) s += sprintf(s,"%5c",'*');
    else             s += sprintf(s,"%5d",x);
  }
  *s++='\n';
  for (i=i1; i<=i0; i++)
  {
    x=(cut_list+i)->lv.v1;
    if ( x==MAXINT ) s += sprintf(s,"%5c",'*');
    else             s += sprintf(s,"%5d",x);
  }
  return s;
}

void det_snap(cell *C, char *txt)
{
  if (db_status)
#ifndef MY_DEBUG
    if ( det_trace )
#endif
      if (snap_activity('a'))
      {
        snap_newcell(C);
        snap_show_text(strcat(snap_text,txt));
        snap_monitor();
      }
  snap=snap_text; *snap=0;  //᢮ 
}

void show_and_wait(char *txt)
{
  snap_show_text(txt);
#ifdef MY_DEBUG
  Tiger_BIOSKEY(0);
#else
  snap_newcell(cell_f());   snap_monitor();
#endif
  txt[0]=0;
}
