#define DEBUG1 1
static char rcsid[] = "$Id$";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "exon.h"
#include <stdio.h>
#include <string.h>		/* For memcpy */

#include "mem.h"


#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif


#define T Exon_T

T
Exon_new (char firstchar, int exoni, char lastchar) {
  T new = (T) MALLOC(sizeof(*new));

  new->exoni = exoni;
  new->firstchar = firstchar;
  new->lastchar = lastchar;

  return new;
}

static T
Exon_copy (T old) {
  T new = (T) MALLOC(sizeof(*new));
  
#if 0
  new->exoni = old->exoni;
  new->firstchar = old->firstchar;
  new->lastchar = old->lastchar;
#else
  memcpy(new,old,sizeof(*new));
#endif

  return new;
}

List_T
Exon_list_copy (List_T old, Listpool_T listpool) {
  List_T new = NULL;

  while (old != NULL) {
    new = Listpool_push(new,listpool,(void *) Exon_copy((T) List_head(old)));
    old = List_next(old);
  }

  return List_reverse(new);
}


static void
Exon_free (T *old) {
  FREE(*old);
  return;
}


void
Exon_list_gc (List_T *exons) {
  List_T p;
  T exon;

  for (p = *exons; p != NULL; p = List_next(p)) {
    exon = (T) List_head(p);
    Exon_free(&exon);
  }
  /* List_free(&(*exons)); -- allocated by Listpool_push */

  return;
}


void
Exon_list_print_fwd (Filestring_T fp, List_T exons) {
  List_T p;
  T exon;

  if (exons != NULL) {
    exon = (T) List_head(exons);
    if (exon->exoni < 0) {
      FPRINTF(fp,"ii");
    } else {
      FPRINTF(fp,"%c%d%c",exon->firstchar,exon->exoni + /*1-based*/1,exon->lastchar);
    }
  
    for (p = List_next(exons); p != NULL; p = List_next(p)) {
      exon = (T) List_head(p);
      if (exon->exoni < 0) {
	FPRINTF(fp,"|ii");
      } else {
	FPRINTF(fp,"|%c%d%c",exon->firstchar,exon->exoni + /*1-based*/1,exon->lastchar);
      }
    }
  }

  return;
}


void
Exon_list_print_rev (Filestring_T fp, List_T exons) {
  List_T p;
  T exon;

  if (exons != NULL) {
    exons = List_reverse(exons);

    exon = (T) List_head(exons);
    if (exon->exoni < 0) {
      FPRINTF(fp,"ii");
    } else {
      FPRINTF(fp,"%c%d%c",exon->lastchar,exon->exoni + /*1-based*/1,exon->firstchar);
    }

    for (p = List_next(exons); p != NULL; p = List_next(p)) {
      exon = (T) List_head(p);
      if (exon->exoni < 0) {
	FPRINTF(fp,"|ii");
      } else {
	FPRINTF(fp,"|%c%d%c",exon->lastchar,exon->exoni + /*1-based*/1,exon->firstchar);
      }
    }

    exons = List_reverse(exons);
  }

  return;
}


#ifdef DEBUG1
void
Exon_list_print_fwd_stdout (List_T exons) {
  List_T p;
  T exon;

  if (exons != NULL) {
    exon = (T) List_head(exons);
    if (exon->exoni < 0) {
      printf("ii");
    } else {
      printf("%c%d%c",exon->firstchar,exon->exoni + /*1-based*/1,exon->lastchar);
    }
  
    for (p = List_next(exons); p != NULL; p = List_next(p)) {
      exon = (T) List_head(p);
      if (exon->exoni < 0) {
	printf("|ii");
      } else {
	printf("|%c%d%c",exon->firstchar,exon->exoni + /*1-based*/1,exon->lastchar);
      }
    }
  }

  return;
}


void
Exon_list_print_rev_stdout (List_T exons) {
  List_T p;
  T exon;

  if (exons != NULL) {
    exons = List_reverse(exons);

    exon = (T) List_head(exons);
    if (exon->exoni < 0) {
      printf("ii");
    } else {
      printf("%c%d%c",exon->lastchar,exon->exoni + /*1-based*/1,exon->firstchar);
    }
  
    for (p = List_next(exons); p != NULL; p = List_next(p)) {
      exon = (T) List_head(p);
      if (exon->exoni < 0) {
	printf("ii");
      } else {
	printf("|%c%d%c",exon->lastchar,exon->exoni + /*1-based*/1,exon->firstchar);
      }
    }

    exons = List_reverse(exons);
  }

  return;
}
#endif


