// surfaces to hide to make a nice pict:
// 1314 1214 277 1174 1085

dmax = 3.75 ;
dmin = 3.0;
emin = 1.425 ;
mc = 2.25 ;
fc = 2.25 ;
gap = 12.0 ;


/* #d1 */

Point(1) = {8,-8-gap,0.0,emin};
Point(2) = {0.0,-8-gap,8,emin};
Point(3) = {-8,-8-gap,0.0,emin};
Point(4) = {0.0,-8-gap,-8,emin};
Point(5) = {0.0,-8-gap,0.0,emin};

Circle(1) = {1,5,2};
Circle(2) = {2,5,3};
Circle(3) = {3,5,4};
Circle(4) = {4,5,1};

Point(6) = {8,-12-gap,0.0,emin};
Point(7) = {0.0,-12-gap,8.0,emin};
Point(8) = {-8,-12-gap,0.0,emin};
Point(9) = {0.0,-12-gap,-8.0,emin};
Point(10) = {0.0,-12-gap,0.0,emin};

Circle(5) = {6,10,7};
Circle(6) = {7,10,8};
Circle(7) = {8,10,9};
Circle(8) = {9,10,6};

Line(9) = {1,6} ;
Line(10) = {2,7} ;
Line(11) = {3,8} ;
Line(12) = {4,9} ;

Line Loop(13) = {10,-5,-9,1};
Surface(14) = {13};
Line Loop(15) = {11,-6,-10,2};
Surface(16) = {15};
Line Loop(17) = {-12,-3,11,7};
Surface(18) = {17};
Line Loop(19) = {9,-8,-12,4};
Surface(20) = {19};

/* center */

Point(21) = {24,-12-gap,0.0,dmin};
Point(22) = {0.0,-12-gap,24.0,dmin};
Point(23) = {-24,-12-gap,0.0,dmin};
Point(24) = {0.0,-12-gap,-24.0,dmin};

/* #d6 */

Point(36) = {27,-12-gap,0.0,dmin};
Point(37) = {0.0,-12-gap,27.0,dmin};
Point(38) = {-27,-12-gap,0.0,dmin};
Point(39) = {0.0,-12-gap,-27.0,dmin};

Circle(76) = {36,10,37};
Circle(77) = {37,10,38};
Circle(78) = {38,10,39};
Circle(79) = {39,10,36};

Line Loop(84) = {76,77,78,79};
Line Loop(85) = {5,6,7,8};
Plane Surface(86) = {84,85};

/* #d7 */

Point(41) = {24,-15-gap,0.0,dmin};
Point(42) = {0.0,-15-gap,24.0,dmin};
Point(43) = {-24,-15-gap,0.0,dmin};
Point(44) = {0.0,-15-gap,-24.0,dmin};
Point(45) = {0.0,-15-gap,0.0,dmin};

Circle(92) = {41,45,42};
Circle(93) = {42,45,43};
Circle(94) = {43,45,44};
Circle(95) = {44,45,41};


Circle(96) = {41,21,36};
Circle(97) = {42,22,37};
Circle(98) = {38,23,43};
Circle(99) = {44,24,39};

Line Loop(104) = {-97,-92,96,76};
Surface(105) = {104};
Line Loop(106) = {98,-93,97,77};
Surface(107) = {106};
Line Loop(108) = {-99,-94,-98,78};
Surface(109) = {108};
Line Loop(110) = {-96,-95,99,79};
Surface(111) = {110};

/* #d8 */

Point(46) = {13,-15-gap,0.0,emin};
Point(47) = {0.0,-15-gap,13,emin};
Point(48) = {-13,-15-gap,0.0,emin};
Point(49) = {0.0,-15-gap,-13.0,emin};

Circle(112) = {46,45,47};
Circle(113) = {47,45,48};
Circle(114) = {48,45,49};
Circle(115) = {49,45,46};

Line Loop(116) = {92,93,94,95};
Line Loop(117) = {112,113,114,115};
Plane Surface(118) = {116,117};

/* #d9 */

Point(51) = {13,-47.2-gap,0.0,emin};
Point(52) = {0.0,-47.2-gap,13.0,emin};
Point(53) = {-13,-47.2-gap,0.0,emin};
Point(54) = {0.0,-47.2-gap,-13.0,emin};
Point(55) = {0.0,-47.2-gap,0.0,emin};

Circle(119) = {51,55,52};
Circle(120) = {52,55,53};
Circle(121) = {53,55,54};
Circle(122) = {54,55,51};

Line(123) = {51,46} ;
Line(124) = {52,47} ;
Line(125) = {53,48} ;
Line(126) = {54,49} ;

Line Loop(127) = {-114,-125,121,126};
Surface(128) = {127};
Line Loop(129) = {-115,-126,122,123};
Surface(130) = {129};
Line Loop(131) = {-112,-123,119,124};
Surface(132) = {131};
Line Loop(133) = {-113,-124,120,125};
Surface(134) = {133};


/* #d10 */

Point(56) = {28.5,-47.2-gap,0.0,dmin};
Point(57) = {0.0,-47.2-gap,28.5,dmin};
Point(58) = {-28.5,-47.2-gap,0.0,dmin};
Point(59) = {0.0,-47.2-gap,-28.5,dmin};

Circle(135) = {56,55,57};
Circle(136) = {57,55,58};
Circle(137) = {58,55,59};
Circle(138) = {59,55,56};

Line Loop(139) = {135,136,137,138};
Line Loop(140) = {119,120,121,122};
Plane Surface(141) = {139,140};

/* #d11 */

Point(61) = {33.5,-52.2-gap,0.0,dmin};
Point(62) = {0.0,-52.2-gap,33.5,dmin};
Point(63) = {-33.5,-52.2-gap,0.0,dmin};
Point(64) = {0.0,-52.2-gap,-33.5,dmin};
Point(65) = {0.0,-52.2-gap,0.0,dmin};

Circle(142) = {61,65,62};
Circle(143) = {62,65,63};
Circle(144) = {63,65,64};
Circle(145) = {64,65,61};

Point(66) = {28.5,-52.2-gap,0.0,dmin};
Point(67) = {0.0,-52.2-gap,28.5,dmin};
Point(68) = {-28.5,-52.2-gap,0.0,dmin};
Point(69) = {0.0,-52.2-gap,-28.5,dmin};

Circle(146) = {61,66,56};
Circle(147) = {62,67,57};
Circle(148) = {58,68,63};
Circle(149) = {64,69,59};

Line Loop(150) = {-147,-142,146,135};
Surface(151) = {150};
Line Loop(152) = {148,-143,147,136};
Surface(153) = {152};
Line Loop(154) = {-149,-144,-148,137};
Surface(155) = {154};
Line Loop(156) = {146,-138,-149,145};
Surface(157) = {156};

/* #d12 */

Point(71) = {33.5,-67.2-gap,0.0,dmin};
Point(72) = {0.0,-67.2-gap,33.5,dmin};
Point(73) = {-33.5,-67.2-gap,0.0,dmin};
Point(74) = {0.0,-67.2-gap,-33.5,dmin};
Point(75) = {0.0,-67.2-gap,0.0,dmin};

Circle(158) = {71,75,72};
Circle(159) = {72,75,73};
Circle(160) = {73,75,74};
Circle(161) = {74,75,71};

Line(162) = {61,71};
Line(163) = {62,72};
Line(164) = {63,73};
Line(165) = {64,74};

Line Loop(166) = {163,-158,-162,142};
Surface(167) = {166};
Line Loop(168) = {164,-159,-163,143};
Surface(169) = {168};
Line Loop(170) = {165,-160,-164,144};
Surface(171) = {170};
Line Loop(172) = {162,-161,-165,145};
Surface(173) = {172};

/* #d13 */

Point(76) = {27,-67.2-gap,0.0,dmin};
Point(77) = {0.0,-67.2-gap,27,dmin};
Point(78) = {-27,-67.2-gap,0.0,dmin};
Point(79) = {0.0,-67.2-gap,-27,dmin};

Circle(174) = {76,75,77};
Circle(175) = {77,75,78};
Circle(176) = {78,75,79};
Circle(177) = {79,75,76};

Line Loop(178) = {158,159,160,161};
Line Loop(179) = {174,175,176,177};
Plane Surface(180) = {178,179};

/* #d14 */

Point(96) = {27,-102.2,0.0,dmin};
Point(97) = {0.0,-102.2,27.0,dmin};
Point(98) = {-27,-102.2,0.0,dmin};
Point(99) = {0.0,-102.2,-27.0,dmin};
Point(100) = {0.0,-102.2,0.0,dmin};

Circle(220) = {96,100,97};
Circle(221) = {97,100,98};
Circle(222) = {98,100,99};
Circle(223) = {99,100,96};

Line(224) = {76,96} ;
Line(225) = {77,97} ;
Line(226) = {78,98} ;
Line(227) = {79,99} ;

Line Loop(228) = {223,-224,-177,227};
Surface(229) = {228};
Line Loop(230) = {220,-225,-174,224};
Surface(231) = {230};
Line Loop(232) = {221,-226,-175,225};
Surface(233) = {232};
Line Loop(234) = {222,-227,-176,226};
Surface(235) = {234};

/* #d18 */

Point(101) = {41,-102.2,0.0,dmax};
Point(102) = {0.0,-102.2,41.0,dmax};
Point(103) = {-41,-102.2,0.0,dmax};
Point(104) = {0.0,-102.2,-41.0,dmax};

Circle(236) = {101,100,102};
Circle(237) = {102,100,103};
Circle(238) = {103,100,104};
Circle(239) = {104,100,101};

Line Loop(240) = {236,237,238,239};
Line Loop(241) = {220,221,222,223};
Plane Surface(242) = {240,241};

/* #d19 */

Point(106) = {41,-87.2,0.0,dmax};
Point(107) = {0.0,-87.2,41.0,dmax};
Point(108) = {-41,-87.2,0.0,dmax};
Point(109) = {0.0,-87.2,-41.0,dmax};
Point(110) = {0.0,-87.2,0.0,dmax};

Circle(243) = {106,110,107};
Circle(244) = {107,110,108};
Circle(245) = {108,110,109};
Circle(246) = {109,110,106};

Line(247) = {101,106} ;
Line(248) = {102,107} ;
Line(249) = {103,108} ;
Line(250) = {104,109} ;

Line Loop(251) = {-248,-236,247,243};
Surface(252) = {251};
Line Loop(253) = {-249,-237,248,244};
Surface(254) = {253};
Line Loop(255) = {-250,-238,249,245};
Surface(256) = {255};
Line Loop(257) = {-247,-239,250,246};
Surface(258) = {257};

/* for ins*/
Line Loop(263) = {243,244,245,246};

/* #d21 */

Point(116) = {41,50,0.0,dmax};
Point(117) = {0.0,50,41.0,dmax};
Point(118) = {-41,50,0.0,dmax};
Point(119) = {0.0,50,-41.0,dmax};
Point(120) = {0.0,50,0.0,dmax};

Circle(266) = {116,120,117};
Circle(267) = {117,120,118};
Circle(268) = {118,120,119};
Circle(269) = {119,120,116};

Line(270) = {106,116} ;
Line(271) = {107,117} ;
Line(272) = {108,118} ;
Line(273) = {109,119} ;

Line Loop(274) = {-271,-243,270,266};
Surface(275) = {274};
Line Loop(276) = {-272,-244,271,267};
Surface(277) = {276};
Line Loop(278) = {-273,-245,272,268};
Surface(279) = {278};
Line Loop(280) = {-270,-246,273,269};
Surface(281) = {280};

/* for ins*/
Line Loop(286) = {266,267,268,269} ;

/* #d23 */

Point(126) = {41,65,0.0,dmax};
Point(127) = {0.0,65,41.0,dmax};
Point(128) = {-41,65,0.0,dmax};
Point(129) = {0.0,65,-41.0,dmax};
Point(130) = {0.0,65,0.0,dmax} ;

Circle(289) = {126,130,127};
Circle(290) = {127,130,128};
Circle(291) = {128,130,129};
Circle(292) = {129,130,126};

Line(293) = {116,126} ;
Line(294) = {117,127} ;
Line(295) = {118,128} ;
Line(296) = {119,129} ;

Line Loop(297) = {289,-294,-266,293};
Surface(298) = {297};
Line Loop(299) = {295,-290,-294,267};
Surface(300) = {299};
Line Loop(301) = {291,-296,-268,295};
Surface(302) = {301};
Line Loop(303) = {292,-293,-269,296};
Surface(304) = {303};

/* #d24 */

Point(131) = {35,65,0.0,dmin};
Point(132) = {0.0,65,35.0,dmin};
Point(133) = {-35,65,0.0,dmin};
Point(134) = {0.0,65,-35.0,dmin};

Circle(305) = {131,130,132};
Circle(306) = {132,130,133};
Circle(307) = {133,130,134};
Circle(308) = {134,130,131};

Line Loop(309) = {289,290,291,292};
Line Loop(310) = {305,306,307,308};
Plane Surface(311) = {309,310};

/* #d25 */
Point(136) = {35,43,0.0,dmin};
Point(137) = {0.0,43,35.0,dmin};
Point(138) = {-35,43,0.0,dmin};
Point(139) = {0.0,43,-35.0,dmin};
Point(140) = {0.0,43,0.0,dmin};

Circle(312) = {136,140,137};
Circle(313) = {137,140,138};
Circle(314) = {138,140,139};
Circle(315) = {139,140,136};

Line(316) = {131,136} ;
Line(317) = {132,137} ;
Line(318) = {133,138} ;
Line(319) = {134,139} ;

Line Loop(320) = {315,-316,-308,319};
Surface(321) = {320};
Line Loop(322) = {312,-317,-305,316};
Surface(323) = {322};
Line Loop(324) = {313,-318,-306,317};
Surface(325) = {324};
Line Loop(326) = {314,-319,-307,318};
Surface(327) = {326};

/* #d26 */

Point(141) = {32,40,0.0,dmin};
Point(142) = {0.0,40,32.0,dmin};
Point(143) = {-32,40,0.0,dmin};
Point(144) = {0.0,40,-32.0,dmin};
Point(145) = {0.0,40,0.0,dmin};

Circle(328) = {141,145,142};
Circle(329) = {142,145,143};
Circle(330) = {143,145,144};
Circle(331) = {144,145,141};

Point(146) = {32,43,0.0,dmin};
Point(147) = {0.0,43,32.0,dmin};
Point(148) = {-32,43,0.0,dmin};
Point(149) = {0.0,43,-32.0,dmin};

Circle(332) = {141,146,136};
Circle(333) = {142,147,137};
Circle(334) = {138,148,143};
Circle(335) = {144,149,139};

Line Loop(336) = {-333,-328,332,312};
Surface(337) = {336};
Line Loop(338) = {334,-329,333,313};
Surface(339) = {338};
Line Loop(340) = {-335,-330,-334,314};
Surface(341) = {340};
Line Loop(342) = {-332,-331,335,315};
Surface(343) = {342};


/* #2 */

Point(211) = {18,40.0,0.0,emin} ;
Point(212) = {0.0,40.0,18,emin};
Point(213) = {-18,40.0,0.0,emin};
Point(214) = {0.0,40.0,-18,emin};

Circle(521) = {211,145,212};
Circle(522) = {212,145,213};
Circle(523) = {213,145,214};
Circle(524) = {214,145,211};

Line Loop(525) = {328,329,330,331};
Line Loop(526) = {521,522,523,524};
Plane Surface(527) = {525,526};

/* #3 */

Point(221) = {18,15,0.0,emin};
Point(222) = {0.0,15,18,emin};
Point(223) = {-18,15,0.0,emin};
Point(224) = {0.0,15,-18,emin};
Point(225) = {0.0,15,0.0,emin};

Circle(537) = {221,225,222};
Circle(538) = {222,225,223};
Circle(539) = {223,225,224};
Circle(540) = {224,225,221};

Line(541) = {211,221};
Line(542) = {212,222};
Line(543) = {213,223};
Line(544) = {214,224};

Line Loop(545) = {537,-542,-521,541};
Surface(546) = {545};
Line Loop(547) = {538,-543,-522,542};
Surface(548) = {547};
Line Loop(549) = {539,-544,-523,543};
Surface(550) = {549};
Line Loop(551) = {540,-541,-524,544};
Surface(552) = {551};

/* #5 */

Point(236) = {24,15,0.0,dmin};
Point(237) = {0.0,15,24,dmin};
Point(238) = {-24,15,0.0,dmin};
Point(239) = {0.0,15,-24,dmin};

Circle(569) = {236,225,237};
Circle(570) = {237,225,238};
Circle(571) = {238,225,239};
Circle(572) = {239,225,236};

Line Loop(573) = {569,570,571,572};
Line Loop(574) = {537,538,539,540};
Plane Surface(575) = {573,574};

/* #6 */

Point(241) = {27,12,0.0,dmin};
Point(242) = {0.0,12,27,dmin};
Point(243) = {-27,12,0.0,dmin};
Point(244) = {0.0,12,-27,dmin};
Point(245) = {0.0,12,0.0,dmin};

Circle(585) = {241,245,242};
Circle(586) = {242,245,243};
Circle(587) = {243,245,244};
Circle(588) = {244,245,241};

Point(246) = {24,12,0.0,dmin};
Point(247) = {0.0,12,24,dmin};
Point(248) = {-24,12,0.0,dmin};
Point(249) = {0.0,12,-24,dmin};

Circle(589) = {241,246,236};
Circle(590) = {237,247,242};
Circle(591) = {238,248,243};
Circle(592) = {239,249,244};

Line Loop(593) = {590,-585,589,569};
Surface(594) = {593};
Line Loop(595) = {591,-586,-590,570};
Surface(596) = {595};
Line Loop(597) = {592,-587,-591,571};
Surface(598) = {597};
Line Loop(599) = {-589,-588,-592,572};
Surface(600) = {599};

/* #11  */

Point(271) = {8,12,0.0,emin};
Point(272) = {0.0,12,8,emin};
Point(273) = {-8,12,0.0,emin};
Point(274) = {0.0,12,-8,emin};

Circle(665) = {271,245,272};
Circle(666) = {272,245,273};
Circle(667) = {273,245,274};
Circle(668) = {274,245,271};

Line Loop(669) = {585,586,587,588};
Line Loop(670) = {665,666,667,668};
Plane Surface(671) = {669,670};

/* #12	*/

Point(276) = {8,8,0.0,emin};
Point(277) = {0.0,8,8,emin};
Point(278) = {-8,8,0.0,emin};
Point(279) = {0.0,8,-8,emin};
Point(280) = {0.0,8,0.0,emin};

Circle(681) = {276,280,277};
Circle(682) = {277,280,278};
Circle(683) = {278,280,279};
Circle(684) = {279,280,276};

Line(686) = {276,271} ;
Line(687) = {277,272} ;
Line(688) = {278,273} ;
Line(689) = {279,274} ;


Line Loop(690) = {-686,-684,689,668};
Surface(691) = {690};
Line Loop(692) = {-687,-681,686,665};
Surface(693) = {692};
Line Loop(694) = {-688,-682,687,666};
Surface(695) = {694};
Line Loop(696) = {-689,-683,688,667};
Surface(697) = {696};

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////



/************* MAIN CONTACT ***********/

/*c1*/

Point(381) = {14.78,8,0.0,mc};
Point(382) = {17.20,8,4.69,mc};
Point(383) = {18.18,8,9.88,mc};
Point(384) = {17.62,8,15.13,mc};
Point(385) = {15.57,8,20.0,mc};
Point(386) = {12.21,8,24.08,mc};
Point(387) = {7.48,8,25.94,mc};
Point(388) = {2.48,8,26.89,mc};
Point(389) = {-2.6,8,26.87,mc};
Point(390) = {-6.34,8,25.06,mc};
Point(391) = {-5.17,8,23.00,mc};
Point(392) = {-0.31,8,21.90,mc};

Rotate{{0.0,1.0,0.0},{0.0,0.0,0.0},-3.14159/2} {
  Duplicata {
    Point{381}; Point{382}; Point{383}; Point{384}; Point{385};
    Point{386}; Point{387}; Point{388}; Point{389}; Point{390};
    Point{391}; Point{392};
  }
}
Coherence;

Rotate{{0.0,1.0,0.0},{0.0,0.0,0.0},-3.14159/2} {
  Duplicata {
    Point{393}; Point{394}; Point{395}; Point{396}; Point{397};
    Point{398}; Point{399}; Point{400}; Point{401}; Point{402};
    Point{403}; Point{404};
  }
}
Coherence;

Rotate{{0.0,1.0,0.0},{0.0,0.0,0.0},-3.14159/2} {
  Duplicata {
    Point{405}; Point{406}; Point{407}; Point{408}; Point{409};
    Point{410}; Point{411}; Point{412}; Point{413}; Point{414};
    Point{415}; Point{416};
  }
}
Coherence;

Spline(698) = {381,382,383,384,385,386} ;
Spline(699) = {386,387,388,389,390} ;
Spline(700) = {390,391,392} ;
Line(701) = {392,393} ;

Spline(702) = {393,394,395,396,397,398} ;
Spline(703) = {398,399,400,401,402} ;
Spline(704) = {402,403,404} ;
Line(705) = {404,405} ;

Spline(706) = {405,406,407,408,409,410} ;
Spline(707) = {410,411,412,413,414} ;
Spline(708) = {414,415,416} ;
Line(709) = {416,417} ;

Spline(710) = {417,418,419,420,421,422} ;
Spline(711) = {422,423,424,425,426} ;
Spline(712) = {426,427,428} ;
Line(713) = {428,381} ;

Line Loop(714) = {699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,698};
Line Loop(715) = {681,682,683,684};
Plane Surface(716) = {714,715};


/* Extrude fixed contact*/

Extrude {0,-8.0,0}{ Surface {716}; }

/********** Moving Contact ************/

Translate{0.0,-20.0,0.} {
  Duplicata { Surface{716}; }
}
Extrude {0,-8.0,0}{ Surface {819}; }

/********************************************** FLOATING SHIELD ****************************************/

/*f1*/

Point(1001) = {36.5,-29.8,0.0,fc};
Point(1002) = {0.0,-29.8,36.5,fc};
Point(1003) = {-36.5,-29.8,0.0,fc};
Point(1004) = {0.0,-29.8,-36.5,fc};
Point(1005) = {0.0,-29.8,0.0,fc};

Circle(1001) = {1001,1005,1002} ;
Circle(1002) = {1002,1005,1003} ;
Circle(1003) = {1003,1005,1004} ;
Circle(1004) = {1004,1005,1001} ;

Point(1006) = {32,-40.8,0.0,fc};
Point(1007) = {0.0,-40.8,32.0,fc};
Point(1008) = {-32,-40.8,0.0,fc};
Point(1009) = {0.0,-40.8,-32.0,fc};
Point(1010) = {0.0,-40.8,0.0,fc};

Circle(1005) = {1006,1010,1007} ;
Circle(1006) = {1007,1010,1008} ;
Circle(1007) = {1008,1010,1009} ;
Circle(1008) = {1009,1010,1006} ;

Line(1009) = {1001,1006} ;
Line(1010) = {1002,1007} ;
Line(1011) = {1003,1008} ;
Line(1012) = {1004,1009} ;

Line Loop(1013) = {-1005,-1009,1001,1010};
Surface(1014) = {1013};
Line Loop(1015) = {-1006,-1010,1002,1011};
Surface(1016) = {1015};
Line Loop(1017) = {-1007,-1011,1003,1012};
Surface(1018) = {1017};
Line Loop(1019) = {-1008,-1012,1004,1009};
Surface(1020) = {1019};

/*f2*/

Point(1011) = {29,-40.8,0.0,fc};
Point(1012) = {0.0,-40.8,29,fc};
Point(1013) = {-29,-40.8,0.0,fc};
Point(1014) = {0.0,-40.8,-29,fc};

Point(1016) = {29,-43.8,0.0,fc};
Point(1017) = {0.0,-43.8,29.0,fc};
Point(1018) = {-29,-43.8,0.0,fc};
Point(1019) = {0.0,-43.8,-29.0,fc};
Point(1020) = {0.0,-43.8,0.0,fc};

Circle(1021) = {1016,1020,1017} ;
Circle(1022) = {1017,1020,1018} ;
Circle(1023) = {1018,1020,1019} ;
Circle(1024) = {1019,1020,1016} ;

Circle(1025) = {1016,1011,1006} ;
Circle(1026) = {1007,1012,1017} ;
Circle(1027) = {1008,1013,1018} ;
Circle(1028) = {1009,1014,1019} ;

Line Loop(1029) = {-1023,-1027,1007,1028};
Surface(1030) = {1029};
Line Loop(1031) = {-1008,1028,1024,1025};
Surface(1032) = {1031};
Line Loop(1033) = {-1021,1025,1005,1026};
Surface(1034) = {1033};
Line Loop(1035) = {-1022,-1026,1006,1027};
Surface(1036) = {1035};

/*f3*/

Point(1021) = {26,-40.8,0.0,fc};
Point(1022) = {0.0,-40.8,26.0,fc};
Point(1023) = {-26,-40.8,0.0,fc};
Point(1024) = {0.0,-40.8,-26.0,fc};

Circle(1037) = {1021,1010,1022} ;
Circle(1038) = {1022,1010,1023} ;
Circle(1039) = {1023,1010,1024} ;
Circle(1040) = {1024,1010,1021} ;

Circle(1041) = {1018,1013,1023};
Circle(1042) = {1019,1014,1024};
Circle(1043) = {1021,1011,1016};
Circle(1044) = {1017,1012,1022};

Line Loop(1045) = {-1038,-1044,1022,1041};
Surface(1046) = {1045};
Line Loop(1047) = {-1039,-1041,1023,1042};
Surface(1048) = {1047};
Line Loop(1049) = {-1024,1042,1040,1043};
Surface(1050) = {1049};
Line Loop(1051) = {-1037,1043,1021,1044};
Surface(1052) = {1051};

/*f4*/

Point(1026) = {31,-40.8,0.0,fc};
Point(1027) = {0.0,-40.8,31.0,fc};
Point(1028) = {-31,-40.8,0.0,fc};
Point(1029) = {0.0,-40.8,-31.0,fc};

Circle(1053) = {1026,1010,1027} ;
Circle(1054) = {1027,1010,1028} ;
Circle(1055) = {1028,1010,1029} ;
Circle(1056) = {1029,1010,1026} ;

Line Loop(1057) = {1053,1054,1055,1056};
Line Loop(1058) = {1037,1038,1039,1040};
Plane Surface(1059) = {1057,1058};

/*f5*/

Point(1031) = {35.5,-29.8,0.0,fc};
Point(1032) = {0.0,-29.8,35.5,fc};
Point(1033) = {-35.5,-29.8,0.0,fc};
Point(1034) = {0.0,-29.8,-35.5,fc};

Circle(1060) = {1031,1005,1032} ;
Circle(1061) = {1032,1005,1033} ;
Circle(1062) = {1033,1005,1034} ;
Circle(1063) = {1034,1005,1031} ;

Line(1064) = {1026,1031} ;
Line(1065) = {1027,1032} ;
Line(1066) = {1028,1033} ;
Line(1067) = {1029,1034} ;

Line Loop(1068) = {1063,-1064,-1056,1067};
Surface(1069) = {1068};
Line Loop(1070) = {1062,-1067,-1055,1066};
Surface(1071) = {1070};
Line Loop(1072) = {1061,-1066,-1054,1065};
Surface(1073) = {1072};
Line Loop(1074) = {1060,-1065,-1053,1064};
Surface(1075) = {1074};

/*f6*/

Point(1036) = {35.5,13.2,0.0,fc};
Point(1037) = {0.0,13.2,35.5,fc};
Point(1038) = {-35.5,13.2,0.0,fc};
Point(1039) = {0.0,13.2,-35.5,fc};
Point(1040) = {0.0,13.2,0.0,fc};

Circle(1076) = {1036,1040,1037} ;
Circle(1077) = {1037,1040,1038} ;
Circle(1078) = {1038,1040,1039} ;
Circle(1079) = {1039,1040,1036} ;

Line(1080) = {1036,1031};
Line(1081) = {1037,1032};
Line(1082) = {1038,1033};
Line(1083) = {1039,1034};

Line Loop(1084) = {1061,-1082,-1077,1081};
Surface(1085) = {1084};
Line Loop(1086) = {1062,-1083,-1078,1082};
Surface(1087) = {1086};
Line Loop(1088) = {1063,-1080,-1079,1083};
Surface(1089) = {1088};
Line Loop(1090) = {1060,-1081,-1076,1080};
Surface(1091) = {1090};

/*f7*/

Point(1041) = {30.5,26.2,0.0,fc};
Point(1042) = {0.0,26.2,30.5,fc};
Point(1043) = {-30.5,26.2,0.0,fc};
Point(1044) = {0.0,26.2,-30.5,fc};
Point(1045) = {0.0,26.2,0.0,fc};

Circle(1092) = {1041,1045,1042} ;
Circle(1093) = {1042,1045,1043} ;
Circle(1094) = {1043,1045,1044} ;
Circle(1095) = {1044,1045,1041} ;

Line(1096) = {1036,1041};
Line(1097) = {1037,1042};
Line(1098) = {1038,1043};
Line(1099) = {1039,1044};

Line Loop(1100) = {-1095,-1099,1079,1096};
Surface(1101) = {1100};
Line Loop(1102) = {-1092,-1096,1076,1097};
Surface(1103) = {1102};
Line Loop(1104) = {-1093,-1097,1077,1098};
Surface(1105) = {1104};
Line Loop(1106) = {-1094,-1098,1078,1099};
Surface(1107) = {1106};

/*f8*/

Point(1046) = {26,26.2,0.0,fc};
Point(1047) = {0.0,26.2,26,fc};
Point(1048) = {-26,26.2,0.0,fc};
Point(1049) = {0.0,26.2,-26,fc};

Circle(1108) = {1046,1045,1047} ;
Circle(1109) = {1047,1045,1048} ;
Circle(1110) = {1048,1045,1049} ;
Circle(1111) = {1049,1045,1046} ;

Line Loop(1112) = {1095,1092,1093,1094};
Line Loop(1113) = {1110,1111,1108,1109};
Plane Surface(1114) = {1112,1113};

/*f9*/

Point(1051) = {29,29.2,0.0,fc};
Point(1052) = {0.0,29.2,29,fc};
Point(1053) = {-29,29.2,0.0,fc};
Point(1054) = {0.0,29.2,-29,fc};
Point(1055) = {0.0,29.2,0.0,fc};

Circle(1115) = {1051,1055,1052} ;
Circle(1116) = {1052,1055,1053} ;
Circle(1117) = {1053,1055,1054} ;
Circle(1118) = {1054,1055,1051} ;

Point(1056) = {29,26.2,0.0,fc};
Point(1057) = {0.0,26.2,29,fc};
Point(1058) = {-29,26.2,0.0,fc};
Point(1059) = {0.0,26.2,-29,fc};

Circle(1119) = {1051,1056,1046} ;
Circle(1120) = {1047,1057,1052} ;
Circle(1121) = {1048,1058,1053} ;
Circle(1122) = {1049,1059,1054} ;

Line Loop(1123) = {-1117,-1121,1110,1122};
Surface(1124) = {1123};
Line Loop(1125) = {-1111,1122,1118,1119};
Surface(1126) = {1125};
Line Loop(1127) = {-1115,1119,1108,1120};
Surface(1128) = {1127};
Line Loop(1129) = {-1116,-1120,1109,1121};
Surface(1130) = {1129};

/* f10 */

Point(1061) = {32,26.2,0.0,fc};
Point(1062) = {0.0,26.2,32,fc};
Point(1063) = {-32,26.2,0.0,fc};
Point(1064) = {0.0,26.2,-32,fc};

Circle(1131) = {1061,1045,1062} ;
Circle(1132) = {1062,1045,1063} ;
Circle(1133) = {1063,1045,1064} ;
Circle(1134) = {1064,1045,1061} ;

Circle(1135) = {1061,1056,1051} ;
Circle(1136) = {1052,1057,1062} ;
Circle(1137) = {1053,1058,1063} ;
Circle(1138) = {1054,1059,1064} ;

Line Loop(1139) = {-1133,-1137,1117,1138};
Surface(1140) = {1139};
Line Loop(1141) = {-1118,1138,1134,1135};
Surface(1142) = {1141};
Line Loop(1143) = {-1131,1135,1115,1136};
Surface(1144) = {1143};
Line Loop(1145) = {-1132,-1136,1116,1137};
Surface(1146) = {1145};


/* f11 */

Point(1066) = {36.5,13.2,0.0,fc};
Point(1067) = {0.0,13.2,36.5,fc};
Point(1068) = {-36.5,13.2,0.0,fc};
Point(1069) = {0.0,13.2,-36.5,fc};

Circle(1147) = {1066,1040,1067} ;
Circle(1148) = {1067,1040,1068} ;
Circle(1149) = {1068,1040,1069} ;
Circle(1150) = {1069,1040,1066} ;

Line(1151) = {1061,1066} ;
Line(1152) = {1062,1067} ;
Line(1153) = {1063,1068} ;
Line(1154) = {1064,1069} ;

Line Loop(1155) = {-1149,-1153,1133,1154};
Surface(1156) = {1155};
Line Loop(1157) = {-1150,-1154,1134,1151};
Surface(1158) = {1157};
Line Loop(1159) = {-1147,-1151,1131,1152};
Surface(1160) = {1159};
Line Loop(1161) = {-1148,-1152,1132,1153};
Surface(1162) = {1161};

/* f12 */

Line(1163) = {1001,1066} ;
Line(1164) = {1002,1067} ;
Line(1165) = {1003,1068} ;
Line(1166) = {1004,1069} ;

Line Loop(1167) = {-1149,-1165,1003,1166};
Surface(1168) = {1167};
Line Loop(1169) = {-1150,-1166,1004,1163};
Surface(1170) = {1169};
Line Loop(1171) = {-1147,-1163,1001,1164};
Surface(1172) = {1171};
Line Loop(1173) = {-1148,-1164,1002,1165};
Surface(1174) = {1173};


/********************************************** insulator ****************************************/

/* insul #1 */

Point(1101) = {47,50,0.0,dmax};
Point(1102) = {0.0,50,47.0,dmax};
Point(1103) = {-47,50,0.0,dmax};
Point(1104) = {0.0,50,-47.0,dmax};

Circle(1201) = {1101,120,1102};
Circle(1202) = {1102,120,1103};
Circle(1203) = {1103,120,1104};
Circle(1204) = {1104,120,1101};

Line Loop(1205) = {1201,1202,1203,1204};
Plane Surface(1206) = {1205,286};

/* insul #2 */

Point(1106) = {47,-87.2,0.0,dmax};
Point(1107) = {0.0,-87.2,47.0,dmax};
Point(1108) = {-47,-87.2,0.0,dmax};
Point(1109) = {0.0,-87.2,-47.0,dmax};

Circle(1205) = {1106,110,1107};
Circle(1206) = {1107,110,1108};
Circle(1207) = {1108,110,1109};
Circle(1208) = {1109,110,1106};

Line(1209) = {1101,1106} ;
Line(1210) = {1102,1107} ;
Line(1211) = {1103,1108} ;
Line(1212) = {1104,1109} ;

Line Loop(1213) = {1206,-1211,-1202,1210};
Surface(1214) = {1213};
Line Loop(1215) = {1207,-1212,-1203,1211};
Surface(1216) = {1215};
Line Loop(1217) = {1208,-1209,-1204,1212};
Surface(1218) = {1217};
Line Loop(1219) = {1205,-1210,-1201,1209};
Surface(1220) = {1219};


/* insul #3 */

Line Loop(1221) = {1205,1206,1207,1208};
Plane Surface(1222) = {1221,263};


/********************************************** air region ****************************************/


/* a#1 */

Point(1201) = {60,65,0.0,dmax};
Point(1202) = {0.0,65,60.0,dmax};
Point(1203) = {-60,65,0.0,dmax};
Point(1204) = {0.0,65,-60.0,dmax};

Circle(1301) = {1201,130,1202};
Circle(1302) = {1202,130,1203};
Circle(1303) = {1203,130,1204};
Circle(1304) = {1204,130,1201};

Line Loop(1305) = {1301,1302,1303,1304};
Plane Surface(1306) = {1305,309};

/* a#2 */

Point(1206) = {60,-102.2,0.0,dmax};
Point(1207) = {0.0,-102.2,60.0,dmax};
Point(1208) = {-60,-102.2,0.0,dmax};
Point(1209) = {0.0,-102.2,-60.0,dmax};

Circle(1305) = {1206,100,1207};
Circle(1306) = {1207,100,1208};
Circle(1307) = {1208,100,1209};
Circle(1308) = {1209,100,1206};

Line(1309) = {1201,1206} ;
Line(1310) = {1202,1207} ;
Line(1311) = {1203,1208} ;
Line(1312) = {1204,1209} ;

Line Loop(1313) = {1306,-1311,-1302,1310};
Surface(1314) = {1313};
Line Loop(1315) = {1307,-1312,-1303,1311};
Surface(1316) = {1315};
Line Loop(1317) = {1308,-1309,-1304,1312};
Surface(1318) = {1317};
Line Loop(1319) = {1305,-1310,-1301,1309};
Surface(1320) = {1319};

Line Loop(1321) = {1305,1306,1307,1308};
Plane Surface(1322) = {1321,240};
Surface Loop(1) = {1306, 1320, 1322, 1314, 1316, 1318, 1220, 1222, 1214, 1216, 1218, 1206, 298, 300, 302, 304, 252, 254, 256, 258};
Volume(3) = {1};
Surface Loop(2) = {1218, 1222, 1220, 1214, 1216, 1206, 281, 275, 277, 279};
Volume(4) = {2};
Surface Loop(3) = {1156, 1168, 1174, 1162, 1160, 1172, 1170, 1158, 1142, 1126, 1114, 1101, 1107, 1105, 1103, 1091, 1075, 1073, 1085, 1087, 1071, 1069, 1089, 1059, 1050, 1032, 1020, 1018, 1030, 1048, 1046, 1052, 1034, 1014, 1016, 1036, 1130, 1146, 1144, 1128, 1140, 1124};
Volume(5) = {3};
Curve Loop(1322) = {736, 737, 734, 735};
Surface(1323) = {1322};
Curve Loop(1323) = {836, 837, 838, 839};
Surface(1324) = {1323};

Surface Loop(4) = {281, 275, 277, 279, 258, 252, 254, 256, 242, 229, 231, 233, 235, 180, 167, 169, 171, 173, 157, 151, 153, 155, 141, 130, 118, 105, 107, 109, 111, 86, 20, 14, 16, 18, 128, 134, 132, 941, 864, 819, 868, 872, 876, 880, 884, 888, 892, 896, 900, 904, 908, 912, 916, 920, 924, 1324, 552, 575, 594, 596, 598, 600, 671, 691, 693, 695, 697, 550, 527, 337, 339, 341, 343, 321, 323, 325, 327, 311, 548, 546, 716, 741, 745, 749, 753, 757, 761, 765, 769, 773, 777, 781, 785, 789, 793, 797, 801, 818, 1323, 298, 300, 302, 304};
//+
Volume(6) = {3, 4};


// ********** Begin SPEC validation **********

Mesh.MeshSizeFactor = 0.13;
Mesh.Algorithm = 5; // del2d
Mesh.Algorithm3D = 10; // hxt
Mesh 3;
n = 1.25589e+08;
file = StrCat(StrPrefix(StrRelative(General.FileName)), ".val");
Printf("Number of tet elements is %g (estimated %g)", Mesh.NbTetrahedra, n);
If ( Fabs(Mesh.NbTetrahedra - n) / Mesh.NbTetrahedra > 0.03 )
  Printf("Error: Number of tet elements is %g (estimated %g), outside of range", Mesh.NbTetrahedra, n) >> file;
  Error("Number of tet elements is %g (estimated %g), outside of range", Mesh.NbTetrahedra, n);
Else
  Printf("Successful Verification of requested %g elements", n) >> file;
EndIf

// ********** End SPEC validation **********
