// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns metadata, such as bucket name, about an Amazon S3 bucket location.
func (c *Client) DescribeLocationS3(ctx context.Context, params *DescribeLocationS3Input, optFns ...func(*Options)) (*DescribeLocationS3Output, error) {
	if params == nil {
		params = &DescribeLocationS3Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeLocationS3", params, optFns, c.addOperationDescribeLocationS3Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeLocationS3Output)
	out.ResultMetadata = metadata
	return out, nil
}

// DescribeLocationS3Request
type DescribeLocationS3Input struct {

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.
	//
	// This member is required.
	LocationArn *string

	noSmithyDocumentSerde
}

// DescribeLocationS3Response
type DescribeLocationS3Output struct {

	// If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource
	// Name (ARNs) of the EC2 agents deployed on your Outpost. For more information
	// about launching a DataSync agent on an Amazon Web Services Outpost, see Deploy
	// your DataSync agent on Outposts
	// (https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
	AgentArns []string

	// The time that the Amazon S3 bucket location was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
	LocationArn *string

	// The URL of the Amazon S3 location that was described.
	LocationUri *string

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
	// used to access an Amazon S3 bucket. For detailed information about using such a
	// role, see Creating a Location for Amazon S3 in the DataSync User Guide.
	S3Config *types.S3Config

	// The Amazon S3 storage class that you chose to store your files in when this
	// location is used as a task destination. For more information about S3 storage
	// classes, see Amazon S3 Storage Classes
	// (http://aws.amazon.com/s3/storage-classes/). Some storage classes have behaviors
	// that can affect your S3 storage cost. For detailed information, see
	// Considerations when working with S3 storage classes in DataSync
	// (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
	S3StorageClass types.S3StorageClass

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeLocationS3Middlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeLocationS3{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeLocationS3{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeLocationS3ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeLocationS3(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeLocationS3(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "datasync",
		OperationName: "DescribeLocationS3",
	}
}
