// Code generated by smithy-go-codegen DO NOT EDIT.

package iottwinmaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iottwinmaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the metadata transfer jobs.
func (c *Client) ListMetadataTransferJobs(ctx context.Context, params *ListMetadataTransferJobsInput, optFns ...func(*Options)) (*ListMetadataTransferJobsOutput, error) {
	if params == nil {
		params = &ListMetadataTransferJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMetadataTransferJobs", params, optFns, c.addOperationListMetadataTransferJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMetadataTransferJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMetadataTransferJobsInput struct {

	// The metadata transfer job's destination type.
	//
	// This member is required.
	DestinationType types.DestinationType

	// The metadata transfer job's source type.
	//
	// This member is required.
	SourceType types.SourceType

	// An object that filters metadata transfer jobs.
	Filters []types.ListMetadataTransferJobsFilter

	// The maximum number of results to return at one time.
	MaxResults *int32

	// The string that specifies the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMetadataTransferJobsOutput struct {

	// The metadata transfer job summaries.
	//
	// This member is required.
	MetadataTransferJobSummaries []types.MetadataTransferJobSummary

	// The string that specifies the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMetadataTransferJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMetadataTransferJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMetadataTransferJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMetadataTransferJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListMetadataTransferJobsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListMetadataTransferJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMetadataTransferJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opListMetadataTransferJobsMiddleware struct {
}

func (*endpointPrefix_opListMetadataTransferJobsMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListMetadataTransferJobsMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListMetadataTransferJobsMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListMetadataTransferJobsMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListMetadataTransferJobsAPIClient is a client that implements the
// ListMetadataTransferJobs operation.
type ListMetadataTransferJobsAPIClient interface {
	ListMetadataTransferJobs(context.Context, *ListMetadataTransferJobsInput, ...func(*Options)) (*ListMetadataTransferJobsOutput, error)
}

var _ ListMetadataTransferJobsAPIClient = (*Client)(nil)

// ListMetadataTransferJobsPaginatorOptions is the paginator options for
// ListMetadataTransferJobs
type ListMetadataTransferJobsPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMetadataTransferJobsPaginator is a paginator for ListMetadataTransferJobs
type ListMetadataTransferJobsPaginator struct {
	options   ListMetadataTransferJobsPaginatorOptions
	client    ListMetadataTransferJobsAPIClient
	params    *ListMetadataTransferJobsInput
	nextToken *string
	firstPage bool
}

// NewListMetadataTransferJobsPaginator returns a new
// ListMetadataTransferJobsPaginator
func NewListMetadataTransferJobsPaginator(client ListMetadataTransferJobsAPIClient, params *ListMetadataTransferJobsInput, optFns ...func(*ListMetadataTransferJobsPaginatorOptions)) *ListMetadataTransferJobsPaginator {
	if params == nil {
		params = &ListMetadataTransferJobsInput{}
	}

	options := ListMetadataTransferJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMetadataTransferJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMetadataTransferJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMetadataTransferJobs page.
func (p *ListMetadataTransferJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMetadataTransferJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListMetadataTransferJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListMetadataTransferJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMetadataTransferJobs",
	}
}
