// Code generated by smithy-go-codegen DO NOT EDIT.

package rum

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rum/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of destinations that you have created to receive RUM extended
// metrics, for the specified app monitor. For more information about extended
// metrics, see AddRumMetrics (https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_AddRumMetrcs.html)
// .
func (c *Client) ListRumMetricsDestinations(ctx context.Context, params *ListRumMetricsDestinationsInput, optFns ...func(*Options)) (*ListRumMetricsDestinationsOutput, error) {
	if params == nil {
		params = &ListRumMetricsDestinationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRumMetricsDestinations", params, optFns, c.addOperationListRumMetricsDestinationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRumMetricsDestinationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRumMetricsDestinationsInput struct {

	// The name of the app monitor associated with the destinations that you want to
	// retrieve.
	//
	// This member is required.
	AppMonitorName *string

	// The maximum number of results to return in one operation. The default is 50.
	// The maximum that you can specify is 100. To retrieve the remaining results, make
	// another call with the returned NextToken value.
	MaxResults *int32

	// Use the token returned by the previous operation to request the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRumMetricsDestinationsOutput struct {

	// The list of CloudWatch RUM extended metrics destinations associated with the
	// app monitor that you specified.
	Destinations []types.MetricDestinationSummary

	// A token that you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRumMetricsDestinationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRumMetricsDestinations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRumMetricsDestinations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRumMetricsDestinations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListRumMetricsDestinationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRumMetricsDestinations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRumMetricsDestinationsAPIClient is a client that implements the
// ListRumMetricsDestinations operation.
type ListRumMetricsDestinationsAPIClient interface {
	ListRumMetricsDestinations(context.Context, *ListRumMetricsDestinationsInput, ...func(*Options)) (*ListRumMetricsDestinationsOutput, error)
}

var _ ListRumMetricsDestinationsAPIClient = (*Client)(nil)

// ListRumMetricsDestinationsPaginatorOptions is the paginator options for
// ListRumMetricsDestinations
type ListRumMetricsDestinationsPaginatorOptions struct {
	// The maximum number of results to return in one operation. The default is 50.
	// The maximum that you can specify is 100. To retrieve the remaining results, make
	// another call with the returned NextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRumMetricsDestinationsPaginator is a paginator for
// ListRumMetricsDestinations
type ListRumMetricsDestinationsPaginator struct {
	options   ListRumMetricsDestinationsPaginatorOptions
	client    ListRumMetricsDestinationsAPIClient
	params    *ListRumMetricsDestinationsInput
	nextToken *string
	firstPage bool
}

// NewListRumMetricsDestinationsPaginator returns a new
// ListRumMetricsDestinationsPaginator
func NewListRumMetricsDestinationsPaginator(client ListRumMetricsDestinationsAPIClient, params *ListRumMetricsDestinationsInput, optFns ...func(*ListRumMetricsDestinationsPaginatorOptions)) *ListRumMetricsDestinationsPaginator {
	if params == nil {
		params = &ListRumMetricsDestinationsInput{}
	}

	options := ListRumMetricsDestinationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRumMetricsDestinationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRumMetricsDestinationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRumMetricsDestinations page.
func (p *ListRumMetricsDestinationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRumMetricsDestinationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListRumMetricsDestinations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListRumMetricsDestinations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRumMetricsDestinations",
	}
}
